; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

define i1 @xor_logic_and_logic_or1(i1 %c, i1 %x, i1 %y) {
; CHECK-LABEL: @xor_logic_and_logic_or1(
; CHECK-NEXT:    [[TMP1:%.*]] = xor i1 [[X:%.*]], true
; CHECK-NEXT:    [[R:%.*]] = select i1 [[C:%.*]], i1 [[TMP1]], i1 [[Y:%.*]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %o = select i1 %c, i1 true, i1 %y
  %a = select i1 %c, i1 %x, i1 false
  %r = xor i1 %a, %o
  ret i1 %r
}

define i1 @xor_logic_and_logic_or2(i1 %c, i1 %x, i1 %y) {
; CHECK-LABEL: @xor_logic_and_logic_or2(
; CHECK-NEXT:    [[O:%.*]] = select i1 [[Y:%.*]], i1 true, i1 [[C:%.*]]
; CHECK-NEXT:    [[A:%.*]] = select i1 [[C]], i1 [[X:%.*]], i1 false
; CHECK-NEXT:    [[R:%.*]] = xor i1 [[A]], [[O]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %o = select i1 %y, i1 true, i1 %c
  %a = select i1 %c, i1 %x, i1 false
  %r = xor i1 %a, %o
  ret i1 %r
}

define i1 @xor_logic_and_logic_or3(i1 %c, i1 %x, i1 %y) {
; CHECK-LABEL: @xor_logic_and_logic_or3(
; CHECK-NEXT:    [[O:%.*]] = select i1 [[Y:%.*]], i1 true, i1 [[C:%.*]]
; CHECK-NEXT:    [[A:%.*]] = select i1 [[X:%.*]], i1 [[C]], i1 false
; CHECK-NEXT:    [[R:%.*]] = xor i1 [[A]], [[O]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %o = select i1 %y, i1 true, i1 %c
  %a = select i1 %x, i1 %c, i1 false
  %r = xor i1 %a, %o
  ret i1 %r
}

define i1 @xor_logic_and_logic_or4(i1 %c, i1 %x, i1 %y) {
; CHECK-LABEL: @xor_logic_and_logic_or4(
; CHECK-NEXT:    [[O:%.*]] = select i1 [[C:%.*]], i1 true, i1 [[Y:%.*]]
; CHECK-NEXT:    [[A:%.*]] = select i1 [[X:%.*]], i1 [[C]], i1 false
; CHECK-NEXT:    [[R:%.*]] = xor i1 [[A]], [[O]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %o = select i1 %c, i1 true, i1 %y
  %a = select i1 %x, i1 %c, i1 false
  %r = xor i1 %a, %o
  ret i1 %r
}

define <3 x i1> @xor_logic_and_logic_or_vector1(<3 x i1> %c, <3 x i1> %x, <3 x i1> %y) {
; CHECK-LABEL: @xor_logic_and_logic_or_vector1(
; CHECK-NEXT:    [[TMP1:%.*]] = xor <3 x i1> [[X:%.*]], <i1 true, i1 true, i1 true>
; CHECK-NEXT:    [[R:%.*]] = select <3 x i1> [[C:%.*]], <3 x i1> [[TMP1]], <3 x i1> [[Y:%.*]]
; CHECK-NEXT:    ret <3 x i1> [[R]]
;
  %o = select <3 x i1> %c, <3 x i1> <i1 true, i1 true, i1 true>, <3 x i1> %y
  %a = select <3 x i1> %c, <3 x i1> %x, <3 x i1> <i1 false, i1 false, i1 false>
  %r = xor <3 x i1> %a, %o
  ret <3 x i1> %r
}

define <3 x i1> @xor_logic_and_logic_or_vector2(<3 x i1> %c, <3 x i1> %x, <3 x i1> %y) {
; CHECK-LABEL: @xor_logic_and_logic_or_vector2(
; CHECK-NEXT:    [[O:%.*]] = select <3 x i1> [[Y:%.*]], <3 x i1> <i1 true, i1 true, i1 true>, <3 x i1> [[C:%.*]]
; CHECK-NEXT:    [[A:%.*]] = select <3 x i1> [[X:%.*]], <3 x i1> [[C]], <3 x i1> zeroinitializer
; CHECK-NEXT:    [[R:%.*]] = xor <3 x i1> [[A]], [[O]]
; CHECK-NEXT:    ret <3 x i1> [[R]]
;
  %o = select <3 x i1> %y, <3 x i1> <i1 true, i1 true, i1 true>, <3 x i1> %c
  %a = select <3 x i1> %x, <3 x i1> %c, <3 x i1> <i1 false, i1 false, i1 false>
  %r = xor <3 x i1> %a, %o
  ret <3 x i1> %r
}

define <3 x i1> @xor_logic_and_logic_or_vector_poison1(<3 x i1> %c, <3 x i1> %x, <3 x i1> %y) {
; CHECK-LABEL: @xor_logic_and_logic_or_vector_poison1(
; CHECK-NEXT:    [[TMP1:%.*]] = xor <3 x i1> [[X:%.*]], <i1 true, i1 true, i1 poison>
; CHECK-NEXT:    [[R:%.*]] = select <3 x i1> [[C:%.*]], <3 x i1> [[TMP1]], <3 x i1> [[Y:%.*]]
; CHECK-NEXT:    ret <3 x i1> [[R]]
;
  %o = select <3 x i1> %c, <3 x i1> <i1 true, i1 true, i1 poison>, <3 x i1> %y
  %a = select <3 x i1> %c, <3 x i1> %x, <3 x i1> <i1 false, i1 false, i1 false>
  %r = xor <3 x i1> %a, %o
  ret <3 x i1> %r
}

define <3 x i1> @xor_logic_and_logic_or_vector_poison2(<3 x i1> %c, <3 x i1> %x, <3 x i1> %y) {
; CHECK-LABEL: @xor_logic_and_logic_or_vector_poison2(
; CHECK-NEXT:    [[TMP1:%.*]] = xor <3 x i1> [[X:%.*]], <i1 true, i1 true, i1 true>
; CHECK-NEXT:    [[R:%.*]] = select <3 x i1> [[C:%.*]], <3 x i1> [[TMP1]], <3 x i1> [[Y:%.*]]
; CHECK-NEXT:    ret <3 x i1> [[R]]
;
  %o = select <3 x i1> %c, <3 x i1> <i1 true, i1 true, i1 true>, <3 x i1> %y
  %a = select <3 x i1> %c, <3 x i1> %x, <3 x i1> <i1 false, i1 poison, i1 false>
  %r = xor <3 x i1> %a, %o
  ret <3 x i1> %r
}

define i1 @xor_and_logic_or1(i1 %c, i1 %x, i1 %y) {
; CHECK-LABEL: @xor_and_logic_or1(
; CHECK-NEXT:    [[O:%.*]] = select i1 [[C:%.*]], i1 true, i1 [[Y:%.*]]
; CHECK-NEXT:    [[A:%.*]] = and i1 [[C]], [[X:%.*]]
; CHECK-NEXT:    [[R:%.*]] = xor i1 [[A]], [[O]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %o = select i1 %c, i1 true, i1 %y
  %a = and i1 %c, %x
  %r = xor i1 %a, %o
  ret i1 %r
}

define i1 @xor_and_logic_or2(i1 %c, i1 %x, i1 %y) {
; CHECK-LABEL: @xor_and_logic_or2(
; CHECK-NEXT:    [[O:%.*]] = select i1 [[Y:%.*]], i1 true, i1 [[C:%.*]]
; CHECK-NEXT:    [[A:%.*]] = and i1 [[X:%.*]], [[C]]
; CHECK-NEXT:    [[R:%.*]] = xor i1 [[A]], [[O]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %o = select i1 %y, i1 true, i1 %c
  %a = and i1 %x, %c
  %r = xor i1 %a, %o
  ret i1 %r
}

define <2 x i1> @xor_and_logic_or_vector(<2 x i1> %c, <2 x i1> %x, <2 x i1> %y) {
; CHECK-LABEL: @xor_and_logic_or_vector(
; CHECK-NEXT:    [[O:%.*]] = select <2 x i1> [[C:%.*]], <2 x i1> <i1 true, i1 true>, <2 x i1> [[Y:%.*]]
; CHECK-NEXT:    [[A:%.*]] = and <2 x i1> [[C]], [[X:%.*]]
; CHECK-NEXT:    [[R:%.*]] = xor <2 x i1> [[A]], [[O]]
; CHECK-NEXT:    ret <2 x i1> [[R]]
;
  %o = select <2 x i1> %c, <2 x i1> <i1 true, i1 true>, <2 x i1> %y
  %a = and <2 x i1> %c, %x
  %r = xor <2 x i1> %a, %o
  ret <2 x i1> %r
}

define <2 x i1> @xor_and_logic_or_vector_poison(<2 x i1> %c, <2 x i1> %x, <2 x i1> %y) {
; CHECK-LABEL: @xor_and_logic_or_vector_poison(
; CHECK-NEXT:    [[O:%.*]] = select <2 x i1> [[C:%.*]], <2 x i1> <i1 poison, i1 true>, <2 x i1> [[Y:%.*]]
; CHECK-NEXT:    [[A:%.*]] = and <2 x i1> [[C]], [[X:%.*]]
; CHECK-NEXT:    [[R:%.*]] = xor <2 x i1> [[A]], [[O]]
; CHECK-NEXT:    ret <2 x i1> [[R]]
;
  %o = select <2 x i1> %c, <2 x i1> <i1 poison, i1 true>, <2 x i1> %y
  %a = and <2 x i1> %c, %x
  %r = xor <2 x i1> %a, %o
  ret <2 x i1> %r
}

define i1 @xor_logic_and_or1(i1 %c, i1 %x, i1 %y) {
; CHECK-LABEL: @xor_logic_and_or1(
; CHECK-NEXT:    [[O:%.*]] = or i1 [[Y:%.*]], [[C:%.*]]
; CHECK-NEXT:    [[A:%.*]] = select i1 [[C]], i1 [[X:%.*]], i1 false
; CHECK-NEXT:    [[R:%.*]] = xor i1 [[A]], [[O]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %o = or i1 %y, %c
  %a = select i1 %c, i1 %x, i1 false
  %r = xor i1 %a, %o
  ret i1 %r
}

define i1 @xor_logic_and_or2(i1 %c, i1 %x, i1 %y) {
; CHECK-LABEL: @xor_logic_and_or2(
; CHECK-NEXT:    [[O:%.*]] = or i1 [[C:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[A:%.*]] = select i1 [[X:%.*]], i1 [[C]], i1 false
; CHECK-NEXT:    [[R:%.*]] = xor i1 [[A]], [[O]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %o = or i1 %c, %y
  %a = select i1 %x, i1 %c, i1 false
  %r = xor i1 %a, %o
  ret i1 %r
}

define <2 x i1> @xor_logic_and_or_vector(<2 x i1> %c, <2 x i1> %x, <2 x i1> %y) {
; CHECK-LABEL: @xor_logic_and_or_vector(
; CHECK-NEXT:    [[O:%.*]] = or <2 x i1> [[Y:%.*]], [[C:%.*]]
; CHECK-NEXT:    [[A:%.*]] = select <2 x i1> [[C]], <2 x i1> [[X:%.*]], <2 x i1> zeroinitializer
; CHECK-NEXT:    [[R:%.*]] = xor <2 x i1> [[A]], [[O]]
; CHECK-NEXT:    ret <2 x i1> [[R]]
;
  %o = or <2 x i1> %y, %c
  %a = select <2 x i1> %c, <2 x i1> %x, <2 x i1> <i1 false, i1 false>
  %r = xor <2 x i1> %a, %o
  ret <2 x i1> %r
}

define <2 x i1> @xor_logic_and_or_vector_poison(<2 x i1> %c, <2 x i1> %x, <2 x i1> %y) {
; CHECK-LABEL: @xor_logic_and_or_vector_poison(
; CHECK-NEXT:    [[O:%.*]] = or <2 x i1> [[Y:%.*]], [[C:%.*]]
; CHECK-NEXT:    [[A:%.*]] = select <2 x i1> [[C]], <2 x i1> [[X:%.*]], <2 x i1> <i1 poison, i1 false>
; CHECK-NEXT:    [[R:%.*]] = xor <2 x i1> [[A]], [[O]]
; CHECK-NEXT:    ret <2 x i1> [[R]]
;
  %o = or <2 x i1> %y, %c
  %a = select <2 x i1> %c, <2 x i1> %x, <2 x i1> <i1 poison, i1 false>
  %r = xor <2 x i1> %a, %o
  ret <2 x i1> %r
}

;; TODO: do we really need to do this transform?
define i1 @xor_and_or(i1 %c, i1 %x, i1 %y) {
; CHECK-LABEL: @xor_and_or(
; CHECK-NEXT:    [[O:%.*]] = or i1 [[Y:%.*]], [[C:%.*]]
; CHECK-NEXT:    [[A:%.*]] = and i1 [[C]], [[X:%.*]]
; CHECK-NEXT:    [[R:%.*]] = xor i1 [[A]], [[O]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %o = or i1 %y, %c
  %a = and i1 %c, %x
  %r = xor i1 %a, %o
  ret i1 %r
}

;; TODO: do we really need to do this transform?
define <4 x i1> @xor_and_or_vector(<4 x i1> %c, <4 x i1> %x, <4 x i1> %y) {
; CHECK-LABEL: @xor_and_or_vector(
; CHECK-NEXT:    [[O:%.*]] = or <4 x i1> [[Y:%.*]], [[C:%.*]]
; CHECK-NEXT:    [[A:%.*]] = and <4 x i1> [[C]], [[X:%.*]]
; CHECK-NEXT:    [[R:%.*]] = xor <4 x i1> [[A]], [[O]]
; CHECK-NEXT:    ret <4 x i1> [[R]]
;
  %o = or <4 x i1> %y, %c
  %a = and <4 x i1> %c, %x
  %r = xor <4 x i1> %a, %o
  ret <4 x i1> %r
}

define i1 @xor_and_or_negative_oneuse(i1 %c, i1 %x, i1 %y) {
; CHECK-LABEL: @xor_and_or_negative_oneuse(
; CHECK-NEXT:    [[O:%.*]] = or i1 [[Y:%.*]], [[C:%.*]]
; CHECK-NEXT:    [[A:%.*]] = and i1 [[C]], [[X:%.*]]
; CHECK-NEXT:    [[R:%.*]] = xor i1 [[A]], [[O]]
; CHECK-NEXT:    call void @use(i1 [[O]])
; CHECK-NEXT:    ret i1 [[R]]
;
  %o = or i1 %y, %c
  %a = and i1 %c, %x
  %r = xor i1 %a, %o
  call void @use(i1 %o)
  ret i1 %r
}

declare void @use(i1)
