; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=sse | FileCheck %s

define <3 x float> @fadd(<3 x float> %v, float %d) {
; CHECK-LABEL: fadd:
; CHECK:       # BB#0:
; CHECK-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,0,0,3]
; CHECK-NEXT:    addps %xmm1, %xmm0
; CHECK-NEXT:    retq
;
  %ins = insertelement <3 x float> undef, float %d, i32 0
  %splat = shufflevector <3 x float> %ins, <3 x float> undef, <3 x i32> zeroinitializer
  %add = fadd <3 x float> %splat, %v
  ret <3 x float> %add
}

; PR29114: https://llvm.org/bugs/show_bug.cgi?id=29114

define <3 x float> @fdiv(<3 x float> %v, float %d) {
; CHECK-LABEL: fdiv:
; CHECK:       # BB#0:
; CHECK-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,0,0,3]
; CHECK-NEXT:    divps %xmm0, %xmm1
; CHECK-NEXT:    movaps %xmm1, %xmm0
; CHECK-NEXT:    retq
;
  %ins = insertelement <3 x float> undef, float %d, i32 0
  %splat = shufflevector <3 x float> %ins, <3 x float> undef, <3 x i32> zeroinitializer
  %div = fdiv <3 x float> %splat, %v
  ret <3 x float> %div
}

