// RUN: llvm-mc -triple i386-unknown-unknown --show-encoding %s | FileCheck %s

// CHECK: addps -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x0f,0x58,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
addps -485498096(%edx,%eax,4), %xmm1

// CHECK: addps 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x0f,0x58,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
addps 485498096(%edx,%eax,4), %xmm1

// CHECK: addps 485498096(%edx), %xmm1
// CHECK: encoding: [0x0f,0x58,0x8a,0xf0,0x1c,0xf0,0x1c]
addps 485498096(%edx), %xmm1

// CHECK: addps 485498096, %xmm1
// CHECK: encoding: [0x0f,0x58,0x0d,0xf0,0x1c,0xf0,0x1c]
addps 485498096, %xmm1

// CHECK: addps 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x0f,0x58,0x4c,0x02,0x40]
addps 64(%edx,%eax), %xmm1

// CHECK: addps (%edx), %xmm1
// CHECK: encoding: [0x0f,0x58,0x0a]
addps (%edx), %xmm1

// CHECK: addps %xmm1, %xmm1
// CHECK: encoding: [0x0f,0x58,0xc9]
addps %xmm1, %xmm1

// CHECK: addss -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0xf3,0x0f,0x58,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
addss -485498096(%edx,%eax,4), %xmm1

// CHECK: addss 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0xf3,0x0f,0x58,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
addss 485498096(%edx,%eax,4), %xmm1

// CHECK: addss 485498096(%edx), %xmm1
// CHECK: encoding: [0xf3,0x0f,0x58,0x8a,0xf0,0x1c,0xf0,0x1c]
addss 485498096(%edx), %xmm1

// CHECK: addss 485498096, %xmm1
// CHECK: encoding: [0xf3,0x0f,0x58,0x0d,0xf0,0x1c,0xf0,0x1c]
addss 485498096, %xmm1

// CHECK: addss 64(%edx,%eax), %xmm1
// CHECK: encoding: [0xf3,0x0f,0x58,0x4c,0x02,0x40]
addss 64(%edx,%eax), %xmm1

// CHECK: addss (%edx), %xmm1
// CHECK: encoding: [0xf3,0x0f,0x58,0x0a]
addss (%edx), %xmm1

// CHECK: addss %xmm1, %xmm1
// CHECK: encoding: [0xf3,0x0f,0x58,0xc9]
addss %xmm1, %xmm1

// CHECK: andnps -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x0f,0x55,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
andnps -485498096(%edx,%eax,4), %xmm1

// CHECK: andnps 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x0f,0x55,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
andnps 485498096(%edx,%eax,4), %xmm1

// CHECK: andnps 485498096(%edx), %xmm1
// CHECK: encoding: [0x0f,0x55,0x8a,0xf0,0x1c,0xf0,0x1c]
andnps 485498096(%edx), %xmm1

// CHECK: andnps 485498096, %xmm1
// CHECK: encoding: [0x0f,0x55,0x0d,0xf0,0x1c,0xf0,0x1c]
andnps 485498096, %xmm1

// CHECK: andnps 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x0f,0x55,0x4c,0x02,0x40]
andnps 64(%edx,%eax), %xmm1

// CHECK: andnps (%edx), %xmm1
// CHECK: encoding: [0x0f,0x55,0x0a]
andnps (%edx), %xmm1

// CHECK: andnps %xmm1, %xmm1
// CHECK: encoding: [0x0f,0x55,0xc9]
andnps %xmm1, %xmm1

// CHECK: andps -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x0f,0x54,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
andps -485498096(%edx,%eax,4), %xmm1

// CHECK: andps 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x0f,0x54,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
andps 485498096(%edx,%eax,4), %xmm1

// CHECK: andps 485498096(%edx), %xmm1
// CHECK: encoding: [0x0f,0x54,0x8a,0xf0,0x1c,0xf0,0x1c]
andps 485498096(%edx), %xmm1

// CHECK: andps 485498096, %xmm1
// CHECK: encoding: [0x0f,0x54,0x0d,0xf0,0x1c,0xf0,0x1c]
andps 485498096, %xmm1

// CHECK: andps 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x0f,0x54,0x4c,0x02,0x40]
andps 64(%edx,%eax), %xmm1

// CHECK: andps (%edx), %xmm1
// CHECK: encoding: [0x0f,0x54,0x0a]
andps (%edx), %xmm1

// CHECK: andps %xmm1, %xmm1
// CHECK: encoding: [0x0f,0x54,0xc9]
andps %xmm1, %xmm1

// CHECK: cmpeqps -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x0f,0xc2,0x8c,0x82,0x10,0xe3,0x0f,0xe3,0x00]
cmpeqps -485498096(%edx,%eax,4), %xmm1

// CHECK: cmpeqps 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x0f,0xc2,0x8c,0x82,0xf0,0x1c,0xf0,0x1c,0x00]
cmpeqps 485498096(%edx,%eax,4), %xmm1

// CHECK: cmpeqps 485498096(%edx), %xmm1
// CHECK: encoding: [0x0f,0xc2,0x8a,0xf0,0x1c,0xf0,0x1c,0x00]
cmpeqps 485498096(%edx), %xmm1

// CHECK: cmpeqps 485498096, %xmm1
// CHECK: encoding: [0x0f,0xc2,0x0d,0xf0,0x1c,0xf0,0x1c,0x00]
cmpeqps 485498096, %xmm1

// CHECK: cmpeqps 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x0f,0xc2,0x4c,0x02,0x40,0x00]
cmpeqps 64(%edx,%eax), %xmm1

// CHECK: cmpeqps (%edx), %xmm1
// CHECK: encoding: [0x0f,0xc2,0x0a,0x00]
cmpeqps (%edx), %xmm1

// CHECK: cmpeqps %xmm1, %xmm1
// CHECK: encoding: [0x0f,0xc2,0xc9,0x00]
cmpeqps %xmm1, %xmm1

// CHECK: cmpeqss -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0xf3,0x0f,0xc2,0x8c,0x82,0x10,0xe3,0x0f,0xe3,0x00]
cmpeqss -485498096(%edx,%eax,4), %xmm1

// CHECK: cmpeqss 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0xf3,0x0f,0xc2,0x8c,0x82,0xf0,0x1c,0xf0,0x1c,0x00]
cmpeqss 485498096(%edx,%eax,4), %xmm1

// CHECK: cmpeqss 485498096(%edx), %xmm1
// CHECK: encoding: [0xf3,0x0f,0xc2,0x8a,0xf0,0x1c,0xf0,0x1c,0x00]
cmpeqss 485498096(%edx), %xmm1

// CHECK: cmpeqss 485498096, %xmm1
// CHECK: encoding: [0xf3,0x0f,0xc2,0x0d,0xf0,0x1c,0xf0,0x1c,0x00]
cmpeqss 485498096, %xmm1

// CHECK: cmpeqss 64(%edx,%eax), %xmm1
// CHECK: encoding: [0xf3,0x0f,0xc2,0x4c,0x02,0x40,0x00]
cmpeqss 64(%edx,%eax), %xmm1

// CHECK: cmpeqss (%edx), %xmm1
// CHECK: encoding: [0xf3,0x0f,0xc2,0x0a,0x00]
cmpeqss (%edx), %xmm1

// CHECK: cmpeqss %xmm1, %xmm1
// CHECK: encoding: [0xf3,0x0f,0xc2,0xc9,0x00]
cmpeqss %xmm1, %xmm1

// CHECK: comiss -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x0f,0x2f,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
comiss -485498096(%edx,%eax,4), %xmm1

// CHECK: comiss 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x0f,0x2f,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
comiss 485498096(%edx,%eax,4), %xmm1

// CHECK: comiss 485498096(%edx), %xmm1
// CHECK: encoding: [0x0f,0x2f,0x8a,0xf0,0x1c,0xf0,0x1c]
comiss 485498096(%edx), %xmm1

// CHECK: comiss 485498096, %xmm1
// CHECK: encoding: [0x0f,0x2f,0x0d,0xf0,0x1c,0xf0,0x1c]
comiss 485498096, %xmm1

// CHECK: comiss 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x0f,0x2f,0x4c,0x02,0x40]
comiss 64(%edx,%eax), %xmm1

// CHECK: comiss (%edx), %xmm1
// CHECK: encoding: [0x0f,0x2f,0x0a]
comiss (%edx), %xmm1

// CHECK: comiss %xmm1, %xmm1
// CHECK: encoding: [0x0f,0x2f,0xc9]
comiss %xmm1, %xmm1

// CHECK: cvtpi2ps -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x0f,0x2a,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
cvtpi2ps -485498096(%edx,%eax,4), %xmm1

// CHECK: cvtpi2ps 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x0f,0x2a,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
cvtpi2ps 485498096(%edx,%eax,4), %xmm1

// CHECK: cvtpi2ps 485498096(%edx), %xmm1
// CHECK: encoding: [0x0f,0x2a,0x8a,0xf0,0x1c,0xf0,0x1c]
cvtpi2ps 485498096(%edx), %xmm1

// CHECK: cvtpi2ps 485498096, %xmm1
// CHECK: encoding: [0x0f,0x2a,0x0d,0xf0,0x1c,0xf0,0x1c]
cvtpi2ps 485498096, %xmm1

// CHECK: cvtpi2ps 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x0f,0x2a,0x4c,0x02,0x40]
cvtpi2ps 64(%edx,%eax), %xmm1

// CHECK: cvtpi2ps (%edx), %xmm1
// CHECK: encoding: [0x0f,0x2a,0x0a]
cvtpi2ps (%edx), %xmm1

// CHECK: cvtpi2ps %mm4, %xmm1
// CHECK: encoding: [0x0f,0x2a,0xcc]
cvtpi2ps %mm4, %xmm1

// CHECK: cvtps2pi -485498096(%edx,%eax,4), %mm4
// CHECK: encoding: [0x0f,0x2d,0xa4,0x82,0x10,0xe3,0x0f,0xe3]
cvtps2pi -485498096(%edx,%eax,4), %mm4

// CHECK: cvtps2pi 485498096(%edx,%eax,4), %mm4
// CHECK: encoding: [0x0f,0x2d,0xa4,0x82,0xf0,0x1c,0xf0,0x1c]
cvtps2pi 485498096(%edx,%eax,4), %mm4

// CHECK: cvtps2pi 485498096(%edx), %mm4
// CHECK: encoding: [0x0f,0x2d,0xa2,0xf0,0x1c,0xf0,0x1c]
cvtps2pi 485498096(%edx), %mm4

// CHECK: cvtps2pi 485498096, %mm4
// CHECK: encoding: [0x0f,0x2d,0x25,0xf0,0x1c,0xf0,0x1c]
cvtps2pi 485498096, %mm4

// CHECK: cvtps2pi 64(%edx,%eax), %mm4
// CHECK: encoding: [0x0f,0x2d,0x64,0x02,0x40]
cvtps2pi 64(%edx,%eax), %mm4

// CHECK: cvtps2pi (%edx), %mm4
// CHECK: encoding: [0x0f,0x2d,0x22]
cvtps2pi (%edx), %mm4

// CHECK: cvtps2pi %xmm1, %mm4
// CHECK: encoding: [0x0f,0x2d,0xe1]
cvtps2pi %xmm1, %mm4

// CHECK: cvtsi2ssl -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0xf3,0x0f,0x2a,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
cvtsi2ssl -485498096(%edx,%eax,4), %xmm1

// CHECK: cvtsi2ssl 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0xf3,0x0f,0x2a,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
cvtsi2ssl 485498096(%edx,%eax,4), %xmm1

// CHECK: cvtsi2ssl 485498096(%edx), %xmm1
// CHECK: encoding: [0xf3,0x0f,0x2a,0x8a,0xf0,0x1c,0xf0,0x1c]
cvtsi2ssl 485498096(%edx), %xmm1

// CHECK: cvtsi2ssl 485498096, %xmm1
// CHECK: encoding: [0xf3,0x0f,0x2a,0x0d,0xf0,0x1c,0xf0,0x1c]
cvtsi2ssl 485498096, %xmm1

// CHECK: cvtsi2ssl 64(%edx,%eax), %xmm1
// CHECK: encoding: [0xf3,0x0f,0x2a,0x4c,0x02,0x40]
cvtsi2ssl 64(%edx,%eax), %xmm1

// CHECK: cvtsi2ssl (%edx), %xmm1
// CHECK: encoding: [0xf3,0x0f,0x2a,0x0a]
cvtsi2ssl (%edx), %xmm1

// CHECK: cvttps2pi -485498096(%edx,%eax,4), %mm4
// CHECK: encoding: [0x0f,0x2c,0xa4,0x82,0x10,0xe3,0x0f,0xe3]
cvttps2pi -485498096(%edx,%eax,4), %mm4

// CHECK: cvttps2pi 485498096(%edx,%eax,4), %mm4
// CHECK: encoding: [0x0f,0x2c,0xa4,0x82,0xf0,0x1c,0xf0,0x1c]
cvttps2pi 485498096(%edx,%eax,4), %mm4

// CHECK: cvttps2pi 485498096(%edx), %mm4
// CHECK: encoding: [0x0f,0x2c,0xa2,0xf0,0x1c,0xf0,0x1c]
cvttps2pi 485498096(%edx), %mm4

// CHECK: cvttps2pi 485498096, %mm4
// CHECK: encoding: [0x0f,0x2c,0x25,0xf0,0x1c,0xf0,0x1c]
cvttps2pi 485498096, %mm4

// CHECK: cvttps2pi 64(%edx,%eax), %mm4
// CHECK: encoding: [0x0f,0x2c,0x64,0x02,0x40]
cvttps2pi 64(%edx,%eax), %mm4

// CHECK: cvttps2pi (%edx), %mm4
// CHECK: encoding: [0x0f,0x2c,0x22]
cvttps2pi (%edx), %mm4

// CHECK: cvttps2pi %xmm1, %mm4
// CHECK: encoding: [0x0f,0x2c,0xe1]
cvttps2pi %xmm1, %mm4

// CHECK: divps -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x0f,0x5e,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
divps -485498096(%edx,%eax,4), %xmm1

// CHECK: divps 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x0f,0x5e,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
divps 485498096(%edx,%eax,4), %xmm1

// CHECK: divps 485498096(%edx), %xmm1
// CHECK: encoding: [0x0f,0x5e,0x8a,0xf0,0x1c,0xf0,0x1c]
divps 485498096(%edx), %xmm1

// CHECK: divps 485498096, %xmm1
// CHECK: encoding: [0x0f,0x5e,0x0d,0xf0,0x1c,0xf0,0x1c]
divps 485498096, %xmm1

// CHECK: divps 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x0f,0x5e,0x4c,0x02,0x40]
divps 64(%edx,%eax), %xmm1

// CHECK: divps (%edx), %xmm1
// CHECK: encoding: [0x0f,0x5e,0x0a]
divps (%edx), %xmm1

// CHECK: divps %xmm1, %xmm1
// CHECK: encoding: [0x0f,0x5e,0xc9]
divps %xmm1, %xmm1

// CHECK: divss -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0xf3,0x0f,0x5e,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
divss -485498096(%edx,%eax,4), %xmm1

// CHECK: divss 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0xf3,0x0f,0x5e,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
divss 485498096(%edx,%eax,4), %xmm1

// CHECK: divss 485498096(%edx), %xmm1
// CHECK: encoding: [0xf3,0x0f,0x5e,0x8a,0xf0,0x1c,0xf0,0x1c]
divss 485498096(%edx), %xmm1

// CHECK: divss 485498096, %xmm1
// CHECK: encoding: [0xf3,0x0f,0x5e,0x0d,0xf0,0x1c,0xf0,0x1c]
divss 485498096, %xmm1

// CHECK: divss 64(%edx,%eax), %xmm1
// CHECK: encoding: [0xf3,0x0f,0x5e,0x4c,0x02,0x40]
divss 64(%edx,%eax), %xmm1

// CHECK: divss (%edx), %xmm1
// CHECK: encoding: [0xf3,0x0f,0x5e,0x0a]
divss (%edx), %xmm1

// CHECK: divss %xmm1, %xmm1
// CHECK: encoding: [0xf3,0x0f,0x5e,0xc9]
divss %xmm1, %xmm1

// CHECK: maxps -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x0f,0x5f,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
maxps -485498096(%edx,%eax,4), %xmm1

// CHECK: maxps 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x0f,0x5f,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
maxps 485498096(%edx,%eax,4), %xmm1

// CHECK: maxps 485498096(%edx), %xmm1
// CHECK: encoding: [0x0f,0x5f,0x8a,0xf0,0x1c,0xf0,0x1c]
maxps 485498096(%edx), %xmm1

// CHECK: maxps 485498096, %xmm1
// CHECK: encoding: [0x0f,0x5f,0x0d,0xf0,0x1c,0xf0,0x1c]
maxps 485498096, %xmm1

// CHECK: maxps 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x0f,0x5f,0x4c,0x02,0x40]
maxps 64(%edx,%eax), %xmm1

// CHECK: maxps (%edx), %xmm1
// CHECK: encoding: [0x0f,0x5f,0x0a]
maxps (%edx), %xmm1

// CHECK: maxps %xmm1, %xmm1
// CHECK: encoding: [0x0f,0x5f,0xc9]
maxps %xmm1, %xmm1

// CHECK: maxss -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0xf3,0x0f,0x5f,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
maxss -485498096(%edx,%eax,4), %xmm1

// CHECK: maxss 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0xf3,0x0f,0x5f,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
maxss 485498096(%edx,%eax,4), %xmm1

// CHECK: maxss 485498096(%edx), %xmm1
// CHECK: encoding: [0xf3,0x0f,0x5f,0x8a,0xf0,0x1c,0xf0,0x1c]
maxss 485498096(%edx), %xmm1

// CHECK: maxss 485498096, %xmm1
// CHECK: encoding: [0xf3,0x0f,0x5f,0x0d,0xf0,0x1c,0xf0,0x1c]
maxss 485498096, %xmm1

// CHECK: maxss 64(%edx,%eax), %xmm1
// CHECK: encoding: [0xf3,0x0f,0x5f,0x4c,0x02,0x40]
maxss 64(%edx,%eax), %xmm1

// CHECK: maxss (%edx), %xmm1
// CHECK: encoding: [0xf3,0x0f,0x5f,0x0a]
maxss (%edx), %xmm1

// CHECK: maxss %xmm1, %xmm1
// CHECK: encoding: [0xf3,0x0f,0x5f,0xc9]
maxss %xmm1, %xmm1

// CHECK: minps -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x0f,0x5d,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
minps -485498096(%edx,%eax,4), %xmm1

// CHECK: minps 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x0f,0x5d,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
minps 485498096(%edx,%eax,4), %xmm1

// CHECK: minps 485498096(%edx), %xmm1
// CHECK: encoding: [0x0f,0x5d,0x8a,0xf0,0x1c,0xf0,0x1c]
minps 485498096(%edx), %xmm1

// CHECK: minps 485498096, %xmm1
// CHECK: encoding: [0x0f,0x5d,0x0d,0xf0,0x1c,0xf0,0x1c]
minps 485498096, %xmm1

// CHECK: minps 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x0f,0x5d,0x4c,0x02,0x40]
minps 64(%edx,%eax), %xmm1

// CHECK: minps (%edx), %xmm1
// CHECK: encoding: [0x0f,0x5d,0x0a]
minps (%edx), %xmm1

// CHECK: minps %xmm1, %xmm1
// CHECK: encoding: [0x0f,0x5d,0xc9]
minps %xmm1, %xmm1

// CHECK: minss -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0xf3,0x0f,0x5d,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
minss -485498096(%edx,%eax,4), %xmm1

// CHECK: minss 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0xf3,0x0f,0x5d,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
minss 485498096(%edx,%eax,4), %xmm1

// CHECK: minss 485498096(%edx), %xmm1
// CHECK: encoding: [0xf3,0x0f,0x5d,0x8a,0xf0,0x1c,0xf0,0x1c]
minss 485498096(%edx), %xmm1

// CHECK: minss 485498096, %xmm1
// CHECK: encoding: [0xf3,0x0f,0x5d,0x0d,0xf0,0x1c,0xf0,0x1c]
minss 485498096, %xmm1

// CHECK: minss 64(%edx,%eax), %xmm1
// CHECK: encoding: [0xf3,0x0f,0x5d,0x4c,0x02,0x40]
minss 64(%edx,%eax), %xmm1

// CHECK: minss (%edx), %xmm1
// CHECK: encoding: [0xf3,0x0f,0x5d,0x0a]
minss (%edx), %xmm1

// CHECK: minss %xmm1, %xmm1
// CHECK: encoding: [0xf3,0x0f,0x5d,0xc9]
minss %xmm1, %xmm1

// CHECK: movaps -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x0f,0x28,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
movaps -485498096(%edx,%eax,4), %xmm1

// CHECK: movaps 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x0f,0x28,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
movaps 485498096(%edx,%eax,4), %xmm1

// CHECK: movaps 485498096(%edx), %xmm1
// CHECK: encoding: [0x0f,0x28,0x8a,0xf0,0x1c,0xf0,0x1c]
movaps 485498096(%edx), %xmm1

// CHECK: movaps 485498096, %xmm1
// CHECK: encoding: [0x0f,0x28,0x0d,0xf0,0x1c,0xf0,0x1c]
movaps 485498096, %xmm1

// CHECK: movaps 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x0f,0x28,0x4c,0x02,0x40]
movaps 64(%edx,%eax), %xmm1

// CHECK: movaps (%edx), %xmm1
// CHECK: encoding: [0x0f,0x28,0x0a]
movaps (%edx), %xmm1

// CHECK: movaps %xmm1, 485498096
// CHECK: encoding: [0x0f,0x29,0x0d,0xf0,0x1c,0xf0,0x1c]
movaps %xmm1, 485498096

// CHECK: movaps %xmm1, 485498096(%edx)
// CHECK: encoding: [0x0f,0x29,0x8a,0xf0,0x1c,0xf0,0x1c]
movaps %xmm1, 485498096(%edx)

// CHECK: movaps %xmm1, -485498096(%edx,%eax,4)
// CHECK: encoding: [0x0f,0x29,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
movaps %xmm1, -485498096(%edx,%eax,4)

// CHECK: movaps %xmm1, 485498096(%edx,%eax,4)
// CHECK: encoding: [0x0f,0x29,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
movaps %xmm1, 485498096(%edx,%eax,4)

// CHECK: movaps %xmm1, 64(%edx,%eax)
// CHECK: encoding: [0x0f,0x29,0x4c,0x02,0x40]
movaps %xmm1, 64(%edx,%eax)

// CHECK: movaps %xmm1, (%edx)
// CHECK: encoding: [0x0f,0x29,0x0a]
movaps %xmm1, (%edx)

// CHECK: movaps %xmm1, %xmm1
// CHECK: encoding: [0x0f,0x28,0xc9]
movaps %xmm1, %xmm1

// CHECK: movhlps %xmm1, %xmm1
// CHECK: encoding: [0x0f,0x12,0xc9]
movhlps %xmm1, %xmm1

// CHECK: movhps -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x0f,0x16,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
movhps -485498096(%edx,%eax,4), %xmm1

// CHECK: movhps 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x0f,0x16,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
movhps 485498096(%edx,%eax,4), %xmm1

// CHECK: movhps 485498096(%edx), %xmm1
// CHECK: encoding: [0x0f,0x16,0x8a,0xf0,0x1c,0xf0,0x1c]
movhps 485498096(%edx), %xmm1

// CHECK: movhps 485498096, %xmm1
// CHECK: encoding: [0x0f,0x16,0x0d,0xf0,0x1c,0xf0,0x1c]
movhps 485498096, %xmm1

// CHECK: movhps 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x0f,0x16,0x4c,0x02,0x40]
movhps 64(%edx,%eax), %xmm1

// CHECK: movhps (%edx), %xmm1
// CHECK: encoding: [0x0f,0x16,0x0a]
movhps (%edx), %xmm1

// CHECK: movhps %xmm1, 485498096
// CHECK: encoding: [0x0f,0x17,0x0d,0xf0,0x1c,0xf0,0x1c]
movhps %xmm1, 485498096

// CHECK: movhps %xmm1, 485498096(%edx)
// CHECK: encoding: [0x0f,0x17,0x8a,0xf0,0x1c,0xf0,0x1c]
movhps %xmm1, 485498096(%edx)

// CHECK: movhps %xmm1, -485498096(%edx,%eax,4)
// CHECK: encoding: [0x0f,0x17,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
movhps %xmm1, -485498096(%edx,%eax,4)

// CHECK: movhps %xmm1, 485498096(%edx,%eax,4)
// CHECK: encoding: [0x0f,0x17,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
movhps %xmm1, 485498096(%edx,%eax,4)

// CHECK: movhps %xmm1, 64(%edx,%eax)
// CHECK: encoding: [0x0f,0x17,0x4c,0x02,0x40]
movhps %xmm1, 64(%edx,%eax)

// CHECK: movhps %xmm1, (%edx)
// CHECK: encoding: [0x0f,0x17,0x0a]
movhps %xmm1, (%edx)

// CHECK: movlhps %xmm1, %xmm1
// CHECK: encoding: [0x0f,0x16,0xc9]
movlhps %xmm1, %xmm1

// CHECK: movlps -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x0f,0x12,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
movlps -485498096(%edx,%eax,4), %xmm1

// CHECK: movlps 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x0f,0x12,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
movlps 485498096(%edx,%eax,4), %xmm1

// CHECK: movlps 485498096(%edx), %xmm1
// CHECK: encoding: [0x0f,0x12,0x8a,0xf0,0x1c,0xf0,0x1c]
movlps 485498096(%edx), %xmm1

// CHECK: movlps 485498096, %xmm1
// CHECK: encoding: [0x0f,0x12,0x0d,0xf0,0x1c,0xf0,0x1c]
movlps 485498096, %xmm1

// CHECK: movlps 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x0f,0x12,0x4c,0x02,0x40]
movlps 64(%edx,%eax), %xmm1

// CHECK: movlps (%edx), %xmm1
// CHECK: encoding: [0x0f,0x12,0x0a]
movlps (%edx), %xmm1

// CHECK: movlps %xmm1, 485498096
// CHECK: encoding: [0x0f,0x13,0x0d,0xf0,0x1c,0xf0,0x1c]
movlps %xmm1, 485498096

// CHECK: movlps %xmm1, 485498096(%edx)
// CHECK: encoding: [0x0f,0x13,0x8a,0xf0,0x1c,0xf0,0x1c]
movlps %xmm1, 485498096(%edx)

// CHECK: movlps %xmm1, -485498096(%edx,%eax,4)
// CHECK: encoding: [0x0f,0x13,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
movlps %xmm1, -485498096(%edx,%eax,4)

// CHECK: movlps %xmm1, 485498096(%edx,%eax,4)
// CHECK: encoding: [0x0f,0x13,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
movlps %xmm1, 485498096(%edx,%eax,4)

// CHECK: movlps %xmm1, 64(%edx,%eax)
// CHECK: encoding: [0x0f,0x13,0x4c,0x02,0x40]
movlps %xmm1, 64(%edx,%eax)

// CHECK: movlps %xmm1, (%edx)
// CHECK: encoding: [0x0f,0x13,0x0a]
movlps %xmm1, (%edx)

// CHECK: movntps %xmm1, 485498096
// CHECK: encoding: [0x0f,0x2b,0x0d,0xf0,0x1c,0xf0,0x1c]
movntps %xmm1, 485498096

// CHECK: movntps %xmm1, 485498096(%edx)
// CHECK: encoding: [0x0f,0x2b,0x8a,0xf0,0x1c,0xf0,0x1c]
movntps %xmm1, 485498096(%edx)

// CHECK: movntps %xmm1, -485498096(%edx,%eax,4)
// CHECK: encoding: [0x0f,0x2b,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
movntps %xmm1, -485498096(%edx,%eax,4)

// CHECK: movntps %xmm1, 485498096(%edx,%eax,4)
// CHECK: encoding: [0x0f,0x2b,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
movntps %xmm1, 485498096(%edx,%eax,4)

// CHECK: movntps %xmm1, 64(%edx,%eax)
// CHECK: encoding: [0x0f,0x2b,0x4c,0x02,0x40]
movntps %xmm1, 64(%edx,%eax)

// CHECK: movntps %xmm1, (%edx)
// CHECK: encoding: [0x0f,0x2b,0x0a]
movntps %xmm1, (%edx)

// CHECK: movss -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0xf3,0x0f,0x10,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
movss -485498096(%edx,%eax,4), %xmm1

// CHECK: movss 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0xf3,0x0f,0x10,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
movss 485498096(%edx,%eax,4), %xmm1

// CHECK: movss 485498096(%edx), %xmm1
// CHECK: encoding: [0xf3,0x0f,0x10,0x8a,0xf0,0x1c,0xf0,0x1c]
movss 485498096(%edx), %xmm1

// CHECK: movss 485498096, %xmm1
// CHECK: encoding: [0xf3,0x0f,0x10,0x0d,0xf0,0x1c,0xf0,0x1c]
movss 485498096, %xmm1

// CHECK: movss 64(%edx,%eax), %xmm1
// CHECK: encoding: [0xf3,0x0f,0x10,0x4c,0x02,0x40]
movss 64(%edx,%eax), %xmm1

// CHECK: movss (%edx), %xmm1
// CHECK: encoding: [0xf3,0x0f,0x10,0x0a]
movss (%edx), %xmm1

// CHECK: movss %xmm1, 485498096
// CHECK: encoding: [0xf3,0x0f,0x11,0x0d,0xf0,0x1c,0xf0,0x1c]
movss %xmm1, 485498096

// CHECK: movss %xmm1, 485498096(%edx)
// CHECK: encoding: [0xf3,0x0f,0x11,0x8a,0xf0,0x1c,0xf0,0x1c]
movss %xmm1, 485498096(%edx)

// CHECK: movss %xmm1, -485498096(%edx,%eax,4)
// CHECK: encoding: [0xf3,0x0f,0x11,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
movss %xmm1, -485498096(%edx,%eax,4)

// CHECK: movss %xmm1, 485498096(%edx,%eax,4)
// CHECK: encoding: [0xf3,0x0f,0x11,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
movss %xmm1, 485498096(%edx,%eax,4)

// CHECK: movss %xmm1, 64(%edx,%eax)
// CHECK: encoding: [0xf3,0x0f,0x11,0x4c,0x02,0x40]
movss %xmm1, 64(%edx,%eax)

// CHECK: movss %xmm1, (%edx)
// CHECK: encoding: [0xf3,0x0f,0x11,0x0a]
movss %xmm1, (%edx)

// CHECK: movss %xmm1, %xmm1
// CHECK: encoding: [0xf3,0x0f,0x10,0xc9]
movss %xmm1, %xmm1

// CHECK: movups -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x0f,0x10,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
movups -485498096(%edx,%eax,4), %xmm1

// CHECK: movups 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x0f,0x10,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
movups 485498096(%edx,%eax,4), %xmm1

// CHECK: movups 485498096(%edx), %xmm1
// CHECK: encoding: [0x0f,0x10,0x8a,0xf0,0x1c,0xf0,0x1c]
movups 485498096(%edx), %xmm1

// CHECK: movups 485498096, %xmm1
// CHECK: encoding: [0x0f,0x10,0x0d,0xf0,0x1c,0xf0,0x1c]
movups 485498096, %xmm1

// CHECK: movups 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x0f,0x10,0x4c,0x02,0x40]
movups 64(%edx,%eax), %xmm1

// CHECK: movups (%edx), %xmm1
// CHECK: encoding: [0x0f,0x10,0x0a]
movups (%edx), %xmm1

// CHECK: movups %xmm1, 485498096
// CHECK: encoding: [0x0f,0x11,0x0d,0xf0,0x1c,0xf0,0x1c]
movups %xmm1, 485498096

// CHECK: movups %xmm1, 485498096(%edx)
// CHECK: encoding: [0x0f,0x11,0x8a,0xf0,0x1c,0xf0,0x1c]
movups %xmm1, 485498096(%edx)

// CHECK: movups %xmm1, -485498096(%edx,%eax,4)
// CHECK: encoding: [0x0f,0x11,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
movups %xmm1, -485498096(%edx,%eax,4)

// CHECK: movups %xmm1, 485498096(%edx,%eax,4)
// CHECK: encoding: [0x0f,0x11,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
movups %xmm1, 485498096(%edx,%eax,4)

// CHECK: movups %xmm1, 64(%edx,%eax)
// CHECK: encoding: [0x0f,0x11,0x4c,0x02,0x40]
movups %xmm1, 64(%edx,%eax)

// CHECK: movups %xmm1, (%edx)
// CHECK: encoding: [0x0f,0x11,0x0a]
movups %xmm1, (%edx)

// CHECK: movups %xmm1, %xmm1
// CHECK: encoding: [0x0f,0x10,0xc9]
movups %xmm1, %xmm1

// CHECK: mulps -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x0f,0x59,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
mulps -485498096(%edx,%eax,4), %xmm1

// CHECK: mulps 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x0f,0x59,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
mulps 485498096(%edx,%eax,4), %xmm1

// CHECK: mulps 485498096(%edx), %xmm1
// CHECK: encoding: [0x0f,0x59,0x8a,0xf0,0x1c,0xf0,0x1c]
mulps 485498096(%edx), %xmm1

// CHECK: mulps 485498096, %xmm1
// CHECK: encoding: [0x0f,0x59,0x0d,0xf0,0x1c,0xf0,0x1c]
mulps 485498096, %xmm1

// CHECK: mulps 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x0f,0x59,0x4c,0x02,0x40]
mulps 64(%edx,%eax), %xmm1

// CHECK: mulps (%edx), %xmm1
// CHECK: encoding: [0x0f,0x59,0x0a]
mulps (%edx), %xmm1

// CHECK: mulps %xmm1, %xmm1
// CHECK: encoding: [0x0f,0x59,0xc9]
mulps %xmm1, %xmm1

// CHECK: mulss -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0xf3,0x0f,0x59,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
mulss -485498096(%edx,%eax,4), %xmm1

// CHECK: mulss 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0xf3,0x0f,0x59,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
mulss 485498096(%edx,%eax,4), %xmm1

// CHECK: mulss 485498096(%edx), %xmm1
// CHECK: encoding: [0xf3,0x0f,0x59,0x8a,0xf0,0x1c,0xf0,0x1c]
mulss 485498096(%edx), %xmm1

// CHECK: mulss 485498096, %xmm1
// CHECK: encoding: [0xf3,0x0f,0x59,0x0d,0xf0,0x1c,0xf0,0x1c]
mulss 485498096, %xmm1

// CHECK: mulss 64(%edx,%eax), %xmm1
// CHECK: encoding: [0xf3,0x0f,0x59,0x4c,0x02,0x40]
mulss 64(%edx,%eax), %xmm1

// CHECK: mulss (%edx), %xmm1
// CHECK: encoding: [0xf3,0x0f,0x59,0x0a]
mulss (%edx), %xmm1

// CHECK: mulss %xmm1, %xmm1
// CHECK: encoding: [0xf3,0x0f,0x59,0xc9]
mulss %xmm1, %xmm1

// CHECK: orps -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x0f,0x56,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
orps -485498096(%edx,%eax,4), %xmm1

// CHECK: orps 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x0f,0x56,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
orps 485498096(%edx,%eax,4), %xmm1

// CHECK: orps 485498096(%edx), %xmm1
// CHECK: encoding: [0x0f,0x56,0x8a,0xf0,0x1c,0xf0,0x1c]
orps 485498096(%edx), %xmm1

// CHECK: orps 485498096, %xmm1
// CHECK: encoding: [0x0f,0x56,0x0d,0xf0,0x1c,0xf0,0x1c]
orps 485498096, %xmm1

// CHECK: orps 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x0f,0x56,0x4c,0x02,0x40]
orps 64(%edx,%eax), %xmm1

// CHECK: orps (%edx), %xmm1
// CHECK: encoding: [0x0f,0x56,0x0a]
orps (%edx), %xmm1

// CHECK: orps %xmm1, %xmm1
// CHECK: encoding: [0x0f,0x56,0xc9]
orps %xmm1, %xmm1

// CHECK: pextrw $0, %mm4, %eax
// CHECK: encoding: [0x0f,0xc5,0xc4,0x00]
pextrw $0, %mm4, %eax

// CHECK: pinsrw $0, -485498096(%edx,%eax,4), %mm4
// CHECK: encoding: [0x0f,0xc4,0xa4,0x82,0x10,0xe3,0x0f,0xe3,0x00]
pinsrw $0, -485498096(%edx,%eax,4), %mm4

// CHECK: pinsrw $0, 485498096(%edx,%eax,4), %mm4
// CHECK: encoding: [0x0f,0xc4,0xa4,0x82,0xf0,0x1c,0xf0,0x1c,0x00]
pinsrw $0, 485498096(%edx,%eax,4), %mm4

// CHECK: pinsrw $0, 485498096(%edx), %mm4
// CHECK: encoding: [0x0f,0xc4,0xa2,0xf0,0x1c,0xf0,0x1c,0x00]
pinsrw $0, 485498096(%edx), %mm4

// CHECK: pinsrw $0, 485498096, %mm4
// CHECK: encoding: [0x0f,0xc4,0x25,0xf0,0x1c,0xf0,0x1c,0x00]
pinsrw $0, 485498096, %mm4

// CHECK: pinsrw $0, 64(%edx,%eax), %mm4
// CHECK: encoding: [0x0f,0xc4,0x64,0x02,0x40,0x00]
pinsrw $0, 64(%edx,%eax), %mm4

// CHECK: pinsrw $0, (%edx), %mm4
// CHECK: encoding: [0x0f,0xc4,0x22,0x00]
pinsrw $0, (%edx), %mm4

// CHECK: pinsrw $0, %eax, %mm4
// CHECK: encoding: [0x0f,0xc4,0xe0,0x00]
pinsrw $0, %eax, %mm4

// CHECK: pmovmskb %mm4, %eax
// CHECK: encoding: [0x0f,0xd7,0xc4]
pmovmskb %mm4, %eax

// CHECK: rcpps -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x0f,0x53,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
rcpps -485498096(%edx,%eax,4), %xmm1

// CHECK: rcpps 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x0f,0x53,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
rcpps 485498096(%edx,%eax,4), %xmm1

// CHECK: rcpps 485498096(%edx), %xmm1
// CHECK: encoding: [0x0f,0x53,0x8a,0xf0,0x1c,0xf0,0x1c]
rcpps 485498096(%edx), %xmm1

// CHECK: rcpps 485498096, %xmm1
// CHECK: encoding: [0x0f,0x53,0x0d,0xf0,0x1c,0xf0,0x1c]
rcpps 485498096, %xmm1

// CHECK: rcpps 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x0f,0x53,0x4c,0x02,0x40]
rcpps 64(%edx,%eax), %xmm1

// CHECK: rcpps (%edx), %xmm1
// CHECK: encoding: [0x0f,0x53,0x0a]
rcpps (%edx), %xmm1

// CHECK: rcpps %xmm1, %xmm1
// CHECK: encoding: [0x0f,0x53,0xc9]
rcpps %xmm1, %xmm1

// CHECK: rcpss -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0xf3,0x0f,0x53,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
rcpss -485498096(%edx,%eax,4), %xmm1

// CHECK: rcpss 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0xf3,0x0f,0x53,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
rcpss 485498096(%edx,%eax,4), %xmm1

// CHECK: rcpss 485498096(%edx), %xmm1
// CHECK: encoding: [0xf3,0x0f,0x53,0x8a,0xf0,0x1c,0xf0,0x1c]
rcpss 485498096(%edx), %xmm1

// CHECK: rcpss 485498096, %xmm1
// CHECK: encoding: [0xf3,0x0f,0x53,0x0d,0xf0,0x1c,0xf0,0x1c]
rcpss 485498096, %xmm1

// CHECK: rcpss 64(%edx,%eax), %xmm1
// CHECK: encoding: [0xf3,0x0f,0x53,0x4c,0x02,0x40]
rcpss 64(%edx,%eax), %xmm1

// CHECK: rcpss (%edx), %xmm1
// CHECK: encoding: [0xf3,0x0f,0x53,0x0a]
rcpss (%edx), %xmm1

// CHECK: rcpss %xmm1, %xmm1
// CHECK: encoding: [0xf3,0x0f,0x53,0xc9]
rcpss %xmm1, %xmm1

// CHECK: rsqrtps -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x0f,0x52,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
rsqrtps -485498096(%edx,%eax,4), %xmm1

// CHECK: rsqrtps 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x0f,0x52,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
rsqrtps 485498096(%edx,%eax,4), %xmm1

// CHECK: rsqrtps 485498096(%edx), %xmm1
// CHECK: encoding: [0x0f,0x52,0x8a,0xf0,0x1c,0xf0,0x1c]
rsqrtps 485498096(%edx), %xmm1

// CHECK: rsqrtps 485498096, %xmm1
// CHECK: encoding: [0x0f,0x52,0x0d,0xf0,0x1c,0xf0,0x1c]
rsqrtps 485498096, %xmm1

// CHECK: rsqrtps 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x0f,0x52,0x4c,0x02,0x40]
rsqrtps 64(%edx,%eax), %xmm1

// CHECK: rsqrtps (%edx), %xmm1
// CHECK: encoding: [0x0f,0x52,0x0a]
rsqrtps (%edx), %xmm1

// CHECK: rsqrtps %xmm1, %xmm1
// CHECK: encoding: [0x0f,0x52,0xc9]
rsqrtps %xmm1, %xmm1

// CHECK: rsqrtss -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0xf3,0x0f,0x52,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
rsqrtss -485498096(%edx,%eax,4), %xmm1

// CHECK: rsqrtss 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0xf3,0x0f,0x52,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
rsqrtss 485498096(%edx,%eax,4), %xmm1

// CHECK: rsqrtss 485498096(%edx), %xmm1
// CHECK: encoding: [0xf3,0x0f,0x52,0x8a,0xf0,0x1c,0xf0,0x1c]
rsqrtss 485498096(%edx), %xmm1

// CHECK: rsqrtss 485498096, %xmm1
// CHECK: encoding: [0xf3,0x0f,0x52,0x0d,0xf0,0x1c,0xf0,0x1c]
rsqrtss 485498096, %xmm1

// CHECK: rsqrtss 64(%edx,%eax), %xmm1
// CHECK: encoding: [0xf3,0x0f,0x52,0x4c,0x02,0x40]
rsqrtss 64(%edx,%eax), %xmm1

// CHECK: rsqrtss (%edx), %xmm1
// CHECK: encoding: [0xf3,0x0f,0x52,0x0a]
rsqrtss (%edx), %xmm1

// CHECK: rsqrtss %xmm1, %xmm1
// CHECK: encoding: [0xf3,0x0f,0x52,0xc9]
rsqrtss %xmm1, %xmm1

// CHECK: sfence
// CHECK: encoding: [0x0f,0xae,0xf8]
sfence

// CHECK: shufps $0, -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x0f,0xc6,0x8c,0x82,0x10,0xe3,0x0f,0xe3,0x00]
shufps $0, -485498096(%edx,%eax,4), %xmm1

// CHECK: shufps $0, 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x0f,0xc6,0x8c,0x82,0xf0,0x1c,0xf0,0x1c,0x00]
shufps $0, 485498096(%edx,%eax,4), %xmm1

// CHECK: shufps $0, 485498096(%edx), %xmm1
// CHECK: encoding: [0x0f,0xc6,0x8a,0xf0,0x1c,0xf0,0x1c,0x00]
shufps $0, 485498096(%edx), %xmm1

// CHECK: shufps $0, 485498096, %xmm1
// CHECK: encoding: [0x0f,0xc6,0x0d,0xf0,0x1c,0xf0,0x1c,0x00]
shufps $0, 485498096, %xmm1

// CHECK: shufps $0, 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x0f,0xc6,0x4c,0x02,0x40,0x00]
shufps $0, 64(%edx,%eax), %xmm1

// CHECK: shufps $0, (%edx), %xmm1
// CHECK: encoding: [0x0f,0xc6,0x0a,0x00]
shufps $0, (%edx), %xmm1

// CHECK: shufps $0, %xmm1, %xmm1
// CHECK: encoding: [0x0f,0xc6,0xc9,0x00]
shufps $0, %xmm1, %xmm1

// CHECK: sqrtps -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x0f,0x51,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
sqrtps -485498096(%edx,%eax,4), %xmm1

// CHECK: sqrtps 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x0f,0x51,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
sqrtps 485498096(%edx,%eax,4), %xmm1

// CHECK: sqrtps 485498096(%edx), %xmm1
// CHECK: encoding: [0x0f,0x51,0x8a,0xf0,0x1c,0xf0,0x1c]
sqrtps 485498096(%edx), %xmm1

// CHECK: sqrtps 485498096, %xmm1
// CHECK: encoding: [0x0f,0x51,0x0d,0xf0,0x1c,0xf0,0x1c]
sqrtps 485498096, %xmm1

// CHECK: sqrtps 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x0f,0x51,0x4c,0x02,0x40]
sqrtps 64(%edx,%eax), %xmm1

// CHECK: sqrtps (%edx), %xmm1
// CHECK: encoding: [0x0f,0x51,0x0a]
sqrtps (%edx), %xmm1

// CHECK: sqrtps %xmm1, %xmm1
// CHECK: encoding: [0x0f,0x51,0xc9]
sqrtps %xmm1, %xmm1

// CHECK: sqrtss -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0xf3,0x0f,0x51,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
sqrtss -485498096(%edx,%eax,4), %xmm1

// CHECK: sqrtss 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0xf3,0x0f,0x51,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
sqrtss 485498096(%edx,%eax,4), %xmm1

// CHECK: sqrtss 485498096(%edx), %xmm1
// CHECK: encoding: [0xf3,0x0f,0x51,0x8a,0xf0,0x1c,0xf0,0x1c]
sqrtss 485498096(%edx), %xmm1

// CHECK: sqrtss 485498096, %xmm1
// CHECK: encoding: [0xf3,0x0f,0x51,0x0d,0xf0,0x1c,0xf0,0x1c]
sqrtss 485498096, %xmm1

// CHECK: sqrtss 64(%edx,%eax), %xmm1
// CHECK: encoding: [0xf3,0x0f,0x51,0x4c,0x02,0x40]
sqrtss 64(%edx,%eax), %xmm1

// CHECK: sqrtss (%edx), %xmm1
// CHECK: encoding: [0xf3,0x0f,0x51,0x0a]
sqrtss (%edx), %xmm1

// CHECK: sqrtss %xmm1, %xmm1
// CHECK: encoding: [0xf3,0x0f,0x51,0xc9]
sqrtss %xmm1, %xmm1

// CHECK: subps -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x0f,0x5c,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
subps -485498096(%edx,%eax,4), %xmm1

// CHECK: subps 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x0f,0x5c,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
subps 485498096(%edx,%eax,4), %xmm1

// CHECK: subps 485498096(%edx), %xmm1
// CHECK: encoding: [0x0f,0x5c,0x8a,0xf0,0x1c,0xf0,0x1c]
subps 485498096(%edx), %xmm1

// CHECK: subps 485498096, %xmm1
// CHECK: encoding: [0x0f,0x5c,0x0d,0xf0,0x1c,0xf0,0x1c]
subps 485498096, %xmm1

// CHECK: subps 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x0f,0x5c,0x4c,0x02,0x40]
subps 64(%edx,%eax), %xmm1

// CHECK: subps (%edx), %xmm1
// CHECK: encoding: [0x0f,0x5c,0x0a]
subps (%edx), %xmm1

// CHECK: subps %xmm1, %xmm1
// CHECK: encoding: [0x0f,0x5c,0xc9]
subps %xmm1, %xmm1

// CHECK: subss -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0xf3,0x0f,0x5c,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
subss -485498096(%edx,%eax,4), %xmm1

// CHECK: subss 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0xf3,0x0f,0x5c,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
subss 485498096(%edx,%eax,4), %xmm1

// CHECK: subss 485498096(%edx), %xmm1
// CHECK: encoding: [0xf3,0x0f,0x5c,0x8a,0xf0,0x1c,0xf0,0x1c]
subss 485498096(%edx), %xmm1

// CHECK: subss 485498096, %xmm1
// CHECK: encoding: [0xf3,0x0f,0x5c,0x0d,0xf0,0x1c,0xf0,0x1c]
subss 485498096, %xmm1

// CHECK: subss 64(%edx,%eax), %xmm1
// CHECK: encoding: [0xf3,0x0f,0x5c,0x4c,0x02,0x40]
subss 64(%edx,%eax), %xmm1

// CHECK: subss (%edx), %xmm1
// CHECK: encoding: [0xf3,0x0f,0x5c,0x0a]
subss (%edx), %xmm1

// CHECK: subss %xmm1, %xmm1
// CHECK: encoding: [0xf3,0x0f,0x5c,0xc9]
subss %xmm1, %xmm1

// CHECK: ucomiss -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x0f,0x2e,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
ucomiss -485498096(%edx,%eax,4), %xmm1

// CHECK: ucomiss 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x0f,0x2e,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
ucomiss 485498096(%edx,%eax,4), %xmm1

// CHECK: ucomiss 485498096(%edx), %xmm1
// CHECK: encoding: [0x0f,0x2e,0x8a,0xf0,0x1c,0xf0,0x1c]
ucomiss 485498096(%edx), %xmm1

// CHECK: ucomiss 485498096, %xmm1
// CHECK: encoding: [0x0f,0x2e,0x0d,0xf0,0x1c,0xf0,0x1c]
ucomiss 485498096, %xmm1

// CHECK: ucomiss 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x0f,0x2e,0x4c,0x02,0x40]
ucomiss 64(%edx,%eax), %xmm1

// CHECK: ucomiss (%edx), %xmm1
// CHECK: encoding: [0x0f,0x2e,0x0a]
ucomiss (%edx), %xmm1

// CHECK: ucomiss %xmm1, %xmm1
// CHECK: encoding: [0x0f,0x2e,0xc9]
ucomiss %xmm1, %xmm1

// CHECK: unpckhps -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x0f,0x15,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
unpckhps -485498096(%edx,%eax,4), %xmm1

// CHECK: unpckhps 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x0f,0x15,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
unpckhps 485498096(%edx,%eax,4), %xmm1

// CHECK: unpckhps 485498096(%edx), %xmm1
// CHECK: encoding: [0x0f,0x15,0x8a,0xf0,0x1c,0xf0,0x1c]
unpckhps 485498096(%edx), %xmm1

// CHECK: unpckhps 485498096, %xmm1
// CHECK: encoding: [0x0f,0x15,0x0d,0xf0,0x1c,0xf0,0x1c]
unpckhps 485498096, %xmm1

// CHECK: unpckhps 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x0f,0x15,0x4c,0x02,0x40]
unpckhps 64(%edx,%eax), %xmm1

// CHECK: unpckhps (%edx), %xmm1
// CHECK: encoding: [0x0f,0x15,0x0a]
unpckhps (%edx), %xmm1

// CHECK: unpckhps %xmm1, %xmm1
// CHECK: encoding: [0x0f,0x15,0xc9]
unpckhps %xmm1, %xmm1

// CHECK: unpcklps -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x0f,0x14,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
unpcklps -485498096(%edx,%eax,4), %xmm1

// CHECK: unpcklps 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x0f,0x14,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
unpcklps 485498096(%edx,%eax,4), %xmm1

// CHECK: unpcklps 485498096(%edx), %xmm1
// CHECK: encoding: [0x0f,0x14,0x8a,0xf0,0x1c,0xf0,0x1c]
unpcklps 485498096(%edx), %xmm1

// CHECK: unpcklps 485498096, %xmm1
// CHECK: encoding: [0x0f,0x14,0x0d,0xf0,0x1c,0xf0,0x1c]
unpcklps 485498096, %xmm1

// CHECK: unpcklps 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x0f,0x14,0x4c,0x02,0x40]
unpcklps 64(%edx,%eax), %xmm1

// CHECK: unpcklps (%edx), %xmm1
// CHECK: encoding: [0x0f,0x14,0x0a]
unpcklps (%edx), %xmm1

// CHECK: unpcklps %xmm1, %xmm1
// CHECK: encoding: [0x0f,0x14,0xc9]
unpcklps %xmm1, %xmm1

// CHECK: xorps -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x0f,0x57,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
xorps -485498096(%edx,%eax,4), %xmm1

// CHECK: xorps 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x0f,0x57,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
xorps 485498096(%edx,%eax,4), %xmm1

// CHECK: xorps 485498096(%edx), %xmm1
// CHECK: encoding: [0x0f,0x57,0x8a,0xf0,0x1c,0xf0,0x1c]
xorps 485498096(%edx), %xmm1

// CHECK: xorps 485498096, %xmm1
// CHECK: encoding: [0x0f,0x57,0x0d,0xf0,0x1c,0xf0,0x1c]
xorps 485498096, %xmm1

// CHECK: xorps 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x0f,0x57,0x4c,0x02,0x40]
xorps 64(%edx,%eax), %xmm1

// CHECK: xorps (%edx), %xmm1
// CHECK: encoding: [0x0f,0x57,0x0a]
xorps (%edx), %xmm1

// CHECK: xorps %xmm1, %xmm1
// CHECK: encoding: [0x0f,0x57,0xc9]
xorps %xmm1, %xmm1

