/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the libgltf project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */

#ifndef LOADSCENE_H
#define LOADSCENE_H

#include <string>
#include <vector>
#include <boost/property_tree/json_parser.hpp>
#include "Common.h"

namespace libgltf
{

class Parser
{
public:
    void getFileNamesInJson(std::vector<glTFFile>& o_glTFFiles);
    void setScene(Scene* pscene);
    int parseScene(const std::vector<glTFFile>& inputFiles);
    bool parseJsonFile(const std::string& jsonfile);
    void clearPropertyTree();
    Parser();
    ~Parser();
private:
    Parser(const Parser&);
    Parser& operator=(const Parser&);

    int readBuffers(const std::vector<glTFFile>& inputFiles);
    void freeBuffers();
    bool parseNodes();
    bool parseMeshs();
    int parseMaterials(const std::vector<glTFFile>& inputFiles);
    bool parseCameras();
    bool parseLights();
    bool parseAttributes();
    int parseTechniques(const std::vector<glTFFile>& inputFiles);
    bool parseAnim();
    bool parseSkins();

    bool parsePrimitive(const boost::property_tree::ptree& pTree, Mesh* pMesh);
    int parseMaterialProper(const boost::property_tree::ptree& pTree,
                             Material* pMaterial,
                             const std::string& techniqueId,
                             const std::vector<glTFFile>& inputFiles);
    void parseNode(const std::string& id, Node* pParentNode,
                   const glm::mat4& pmatrix);
    int parseTechniqueProgram(const boost::property_tree::ptree& pInstanceTree,
                              const boost::property_tree::ptree& pParameterTree,
                              Technique* pTechnique, const std::vector<glTFFile>& inputFiles);

    bool parseTechniqueState(boost::property_tree::ptree& pInstanceTree,
                             Technique* pTechnique);

    bool parseTechniqueLight(const boost::property_tree::ptree& pInstanceTree,
                             const boost::property_tree::ptree& pParameterTree,
                             Technique* pTechnique);

    std::string parseChannel(const boost::property_tree::ptree& pTree);
    int parsePara(const boost::property_tree::ptree& pTree, Animation* pAnimation,
                  const std::string& nodeId);

    bool inline isFoundPtree(boost::property_tree::ptree& pTree,
                             const char* key)
    {
        if (pTree.find(key) != pTree.not_found())
        {
            return true;
        }
        return false;
    };
    boost::property_tree::ptree ptParse;
    Scene* pScene;
};

} // namespace libgltf

#endif

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
