﻿// This file is used by Code Analysis to maintain SuppressMessage 
// attributes that are applied to this project.
// Project-level suppressions either have no target or are given 
// a specific target and scoped to a namespace, type, member, etc.
//
// To add a suppression to this file, right-click the message in the 
// Error List, point to "Suppress Message(s)", and click 
// "In Project Suppression File".
// You do not need to add suppressions to this file manually.

using System.Diagnostics.CodeAnalysis;

// These suppressions were automatically migrated from the FxCop baseline files.

#region $/DevDiv/Dev11/pu/MQAspNet/ddsuites/src/FxCop/Excludes/Triaged/System.Web.dll.FxCop
[module: SuppressMessage("Microsoft.MSInternal", "CA905:SystemAndMicrosoftNamespacesRequireApproval", Scope = "namespace", Target = "System.Web.Administration", Justification = @"[....]: Our namespaces have approval.")]
[module: SuppressMessage("Microsoft.MSInternal", "CA905:SystemAndMicrosoftNamespacesRequireApproval", Scope = "namespace", Target = "System.Web.DataAccess", Justification = @"[....]: Our namespaces have approval.")]
[module: SuppressMessage("Microsoft.MSInternal", "CA905:SystemAndMicrosoftNamespacesRequireApproval", Scope = "namespace", Target = "System.Web.Management", Justification = @"[....]: Our namespaces have approval.")]
[module: SuppressMessage("Microsoft.MSInternal", "CA905:SystemAndMicrosoftNamespacesRequireApproval", Scope = "namespace", Target = "System.Web.Profile", Justification = @"[....]: Our namespaces have approval.")]
[module: SuppressMessage("Microsoft.MSInternal", "CA905:SystemAndMicrosoftNamespacesRequireApproval", Scope = "namespace", Target = "System.Web.UI.Adapters", Justification = @"[....]: Our namespaces have approval.")]
[module: SuppressMessage("Microsoft.MSInternal", "CA905:SystemAndMicrosoftNamespacesRequireApproval", Scope = "namespace", Target = "System.Web.UI.WebControls.Adapters", Justification = @"[....]: Our namespaces have approval.")]
[module: SuppressMessage("Microsoft.MSInternal", "CA905:SystemAndMicrosoftNamespacesRequireApproval", Scope = "namespace", Target = "System.Web.UI.WebControls.WebParts", Justification = @"[....]: Our namespaces have approval.")]
[module: SuppressMessage("Microsoft.Design", "CA2210:AssembliesShouldHaveValidStrongNames", Scope = "module", Target = "system.web.dll", Justification = @"[....]: We're not going to change the name of System.Web")]
[module: SuppressMessage("Microsoft.Performance", "CA1812:AvoidUninstantiatedInternalClasses", Scope = "type", Target = ".AssemblyRef", Justification = @"[....]: These classes are used in assembly generation.")]
[module: SuppressMessage("Microsoft.Performance", "CA1812:AvoidUninstantiatedInternalClasses", Scope = "type", Target = ".FXAssembly", Justification = @"[....]: This is a generated class containing just the version")]
[module: SuppressMessage("Microsoft.Performance", "CA1812:AvoidUninstantiatedInternalClasses", Scope = "type", Target = ".ThisAssembly", Justification = @"[....]: These classes are used in assembly generation.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.ApplicationImpersonationContext.#.ctor()", Justification = @"[....]: Config should not be protected by link demands.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.ApplicationShutdownReason.#ChangeInGlobalAsax", MessageId = "Asax", Justification = @"[....]: Spelling ok")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "member", Target = "System.Web.ApplicationShutdownReason.#ChangeInSecurityPolicyFile", MessageId = "InSecurity", Justification = @"[....]: Spellings ok.")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.AspNetSynchronizationContext.#CallCallbackPossiblyUnderLock(System.Threading.SendOrPostCallback,System.Object)", Justification = @"[....]: No security issues= non-ClsCompliant exceptions are ok to bubble up here.")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope = "type", Target = "System.Web.BeginEventHandler", Justification = @"NO_JUSTIFICATION_PROVIDED")]
[module: SuppressMessage("Microsoft.Performance", "CA1807:AvoidUnnecessaryStringCreation", Scope = "member", Target = "System.Web.CachedPathData.#CreateKey(System.String)", MessageId = "stack0", Justification = @"[....]: The 'stack0' variable is only used in a Debug statement.  Excluding since it's a debug only false alarm.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.CachedPathData.#GetApplicationPathData()", Justification = @"[....]: Config should not be protected by a link demand.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.CachedPathData.#GetConfigPathData(System.String)", Justification = @"[....]: Config should not be protected by a link demand.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.CachedPathData.#GetVirtualPathData(System.Web.VirtualPath,System.Boolean)", Justification = @"[....]: Config should not be protected by a link demand.")]
[module: SuppressMessage("Microsoft.Performance", "CA1812:AvoidUninstantiatedInternalClasses", Scope = "type", Target = "System.Web.DefaultHttpHandler", Justification = @"[....]: Don't know where these come from. Will check with Polita.")]
[module: SuppressMessage("Microsoft.Design", "CA1055:UriReturnValuesShouldNotBeStrings", Scope = "member", Target = "System.Web.DefaultHttpHandler.#OverrideExecuteUrlPath()", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.DictionaryEntryCaseInsensitiveComparer.#.ctor()", Justification = @"[....]: Invoked via reflection.")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.DirectoryMonitor.#DebugDescription(System.String)", Justification = @"[....]: already excluded, accidental duplication in merge")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.DirectoryMonitor.#FireNotifications()", Justification = @"[....]: Disregarding this rule because it doesn't make sense for our code.")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.DirectoryMonitor.#OnFileChange(System.Web.FileAction,System.String,System.DateTime)", Justification = @"[....]: Disregarding this rule because it doesn't make sense for our code.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.DirMonCompletion.#.ctor(System.Web.DirectoryMonitor,System.String,System.Boolean,System.UInt32)", Justification = @"[....]: pipeline runtime instances are not handed out to user code and the ctor demands full trust.  Excluded after review")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope = "member", Target = "System.Web.DirMonCompletion.#_ndirMonCompletionHandle", Justification = @"[....]: _ndirMonCompletionPtr and _ndirmonCompletionHandle are pointer and handle to an internally created native object.  DirmonCompletion.Dispose has code to release that resource.  Don't need a need to use SafeHandle here.")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope = "member", Target = "System.Web.DirMonCompletion.#_ndirMonCompletionPtr", Justification = @"[....]: _ndirMonCompletionPtr and _ndirmonCompletionHandle are pointer and handle to an internally created native object.  DirmonCompletion.Dispose has code to release that resource.  Don't need a need to use SafeHandle here.")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.DirMonCompletion.#DebugDescription(System.String)", Justification = @"[....]: already excluded, accidental duplication in merge")]
[module: SuppressMessage("Microsoft.Security", "CA2115:CallGCKeepAliveWhenUsingNativeResources", Scope = "member", Target = "System.Web.DirMonCompletion.#OnFileChange(System.Web.FileAction,System.String,System.Int64)", Justification = @"[....]: The IntPtr isn't finalized, so GC.KeepAlive is not needed.")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope = "type", Target = "System.Web.EndEventHandler", Justification = @"NO_JUSTIFICATION_PROVIDED")]
[module: SuppressMessage("Microsoft.Globalization", "CA1303:DoNotPassLiteralsAsLocalizedParameters", Scope = "member", Target = "System.Web.ErrorFormatter.#CreateBreakLiteral()", MessageId = "System.Web.UI.WebControls.Literal.set_Text(System.String)", Justification = @"[....]: The break tag literal is culture independent and does not need to be retrieved from resource.")]
[module: SuppressMessage("Microsoft.Security", "CA2107:ReviewDenyAndPermitOnlyUsage", Scope = "member", Target = "System.Web.ErrorFormatter.#GetHtmlErrorMessage(System.Boolean)", Justification = @"[....]: This usage has been carefully reviewed.")]
[module: SuppressMessage("Microsoft.Performance", "CA1812:AvoidUninstantiatedInternalClasses", Scope = "type", Target = "System.Web.EtwTrace", Justification = @"[....]: code may be used for debug purposes and through reflection")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.EtwTrace.#TraceEnableCheck(System.Web.EtwTraceConfigType,System.IntPtr)", Justification = @"[....]: ok")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.FileChangesMonitor.#CreateFileMonitoringException(System.Int32,System.String)", Justification = @"[....]: pipeline runtime instances are not handed out to user code and the ctor demands full trust.  Excluded after review")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.FileChangesMonitor.#DebugDescription(System.String)", Justification = @"[....]: already excluded, accidental duplication in merge")]
[module: SuppressMessage("Microsoft.Security", "CA2106:SecureAsserts", Scope = "member", Target = "System.Web.FileChangesMonitor.#GetFullPath(System.String)", Justification = @"[....]: PipelineRuntime instances not given out to user code.  If this assumption changes, we need to change this")]
[module: SuppressMessage("Microsoft.Performance", "CA1812:AvoidUninstantiatedInternalClasses", Scope = "type", Target = "System.Web.FileSecurity", Justification = @"[....]: Internal HttpModule only instantiated through reflection.")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.FileSecurity.#.ctor()", Justification = @"[....]: Error in violation")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.FileSecurity.#GetDacl(System.String)", Justification = @"[....]: pipeline runtime instances are not handed out to user code and the ctor demands full trust.  Excluded after review")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope = "member", Target = "System.Web.FormatterWithFileInfo.#GetSourceFileLines(System.String,System.Text.Encoding,System.String,System.Int32)", Justification = @"[....]: It's fine here to catch all exceptions.")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.HttpApplication.#AddOnAcquireRequestStateAsync(System.Web.BeginEventHandler,System.Web.EndEventHandler)", Justification = @"[....]: These are not true events, but asynchronous ones, they require Begin and End delegates, not simple event handler. This pattern is in place since v1.0")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.HttpApplication.#AddOnAcquireRequestStateAsync(System.Web.BeginEventHandler,System.Web.EndEventHandler,System.Object)", Justification = @"[....]: this is an 'async' event which does not fit the standard event pattern")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.HttpApplication.#AddOnAuthenticateRequestAsync(System.Web.BeginEventHandler,System.Web.EndEventHandler)", Justification = @"[....]: These are not true events, but asynchronous ones, they require Begin and End delegates, not simple event handler. This pattern is in place since v1.0")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.HttpApplication.#AddOnAuthenticateRequestAsync(System.Web.BeginEventHandler,System.Web.EndEventHandler,System.Object)", Justification = @"[....]: this is an 'async' event which does not fit the standard event pattern")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.HttpApplication.#AddOnAuthorizeRequestAsync(System.Web.BeginEventHandler,System.Web.EndEventHandler)", Justification = @"[....]: These are not true events, but asynchronous ones, they require Begin and End delegates, not simple event handler. This pattern is in place since v1.0")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.HttpApplication.#AddOnAuthorizeRequestAsync(System.Web.BeginEventHandler,System.Web.EndEventHandler,System.Object)", Justification = @"[....]: this is an 'async' event which does not fit the standard event pattern")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.HttpApplication.#AddOnBeginRequestAsync(System.Web.BeginEventHandler,System.Web.EndEventHandler)", Justification = @"[....]: These are not true events, but asynchronous ones, they require Begin and End delegates, not simple event handler. This pattern is in place since v1.0")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.HttpApplication.#AddOnBeginRequestAsync(System.Web.BeginEventHandler,System.Web.EndEventHandler,System.Object)", Justification = @"[....]: this is an 'async' event which does not fit the standard event pattern")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.HttpApplication.#AddOnEndRequestAsync(System.Web.BeginEventHandler,System.Web.EndEventHandler)", Justification = @"[....]: These are not true events, but asynchronous ones, they require Begin and End delegates, not simple event handler. This pattern is in place since v1.0")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.HttpApplication.#AddOnEndRequestAsync(System.Web.BeginEventHandler,System.Web.EndEventHandler,System.Object)", Justification = @"[....]: this is an 'async' event which does not fit the standard event pattern")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.HttpApplication.#AddOnLogRequestAsync(System.Web.BeginEventHandler,System.Web.EndEventHandler)", Justification = @"[....]: Reviewed and excluded in beta2lhsd, based on parity with existing pattern")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.HttpApplication.#AddOnLogRequestAsync(System.Web.BeginEventHandler,System.Web.EndEventHandler,System.Object)", Justification = @"[....]: Reviewed and excluded in beta2lhsd, based on parity with existing pattern")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.HttpApplication.#AddOnMapRequestHandlerAsync(System.Web.BeginEventHandler,System.Web.EndEventHandler)", Justification = @"[....]: Reviewed and excluded in beta2lhsd, based on parity with existing pattern")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.HttpApplication.#AddOnMapRequestHandlerAsync(System.Web.BeginEventHandler,System.Web.EndEventHandler,System.Object)", Justification = @"[....]: Reviewed and excluded in beta2lhsd, based on parity with existing pattern")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.HttpApplication.#AddOnPostAcquireRequestStateAsync(System.Web.BeginEventHandler,System.Web.EndEventHandler)", MessageId = "0#", Justification = @"[....]: these new methods have the same parameter names as the existing public ones that cannot be changed (breaking change) - i think we should keep consistent names")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.HttpApplication.#AddOnPostAcquireRequestStateAsync(System.Web.BeginEventHandler,System.Web.EndEventHandler)", MessageId = "bh", Justification = @"[....]: This is for consistency with existing methods.")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.HttpApplication.#AddOnPostAcquireRequestStateAsync(System.Web.BeginEventHandler,System.Web.EndEventHandler)", Justification = @"[....]: These are not true events, but asynchronous ones, they require Begin and End delegates, not simple event handler. This pattern is in place since v1.0")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.HttpApplication.#AddOnPostAcquireRequestStateAsync(System.Web.BeginEventHandler,System.Web.EndEventHandler,System.Object)", Justification = @"[....]: this is an 'async' event which does not fit the standard event pattern")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.HttpApplication.#AddOnPostAuthenticateRequestAsync(System.Web.BeginEventHandler,System.Web.EndEventHandler)", MessageId = "0#", Justification = @"[....]: these new methods have the same parameter names as the existing public ones that cannot be changed (breaking change) - i think we should keep consistent names")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.HttpApplication.#AddOnPostAuthenticateRequestAsync(System.Web.BeginEventHandler,System.Web.EndEventHandler)", MessageId = "bh", Justification = @"[....]: This is for consistency with existing methods.")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.HttpApplication.#AddOnPostAuthenticateRequestAsync(System.Web.BeginEventHandler,System.Web.EndEventHandler)", Justification = @"[....]: These are not true events, but asynchronous ones, they require Begin and End delegates, not simple event handler. This pattern is in place since v1.0")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.HttpApplication.#AddOnPostAuthenticateRequestAsync(System.Web.BeginEventHandler,System.Web.EndEventHandler,System.Object)", Justification = @"[....]: this is an 'async' event which does not fit the standard event pattern")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.HttpApplication.#AddOnPostAuthorizeRequestAsync(System.Web.BeginEventHandler,System.Web.EndEventHandler)", MessageId = "0#", Justification = @"[....]: these new methods have the same parameter names as the existing public ones that cannot be changed (breaking change) - i think we should keep consistent names")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.HttpApplication.#AddOnPostAuthorizeRequestAsync(System.Web.BeginEventHandler,System.Web.EndEventHandler)", MessageId = "bh", Justification = @"[....]: This is for consistency with existing methods.")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.HttpApplication.#AddOnPostAuthorizeRequestAsync(System.Web.BeginEventHandler,System.Web.EndEventHandler)", Justification = @"[....]: These are not true events, but asynchronous ones, they require Begin and End delegates, not simple event handler. This pattern is in place since v1.0")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.HttpApplication.#AddOnPostAuthorizeRequestAsync(System.Web.BeginEventHandler,System.Web.EndEventHandler,System.Object)", Justification = @"[....]: this is an 'async' event which does not fit the standard event pattern")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.HttpApplication.#AddOnPostLogRequestAsync(System.Web.BeginEventHandler,System.Web.EndEventHandler)", Justification = @"[....]: Reviewed and excluded in beta2lhsd, based on parity with existing pattern")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.HttpApplication.#AddOnPostLogRequestAsync(System.Web.BeginEventHandler,System.Web.EndEventHandler,System.Object)", Justification = @"[....]: Reviewed and excluded in beta2lhsd, based on parity with existing pattern")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.HttpApplication.#AddOnPostMapRequestHandlerAsync(System.Web.BeginEventHandler,System.Web.EndEventHandler)", MessageId = "0#", Justification = @"[....]: these new methods have the same parameter names as the existing public ones that cannot be changed (breaking change) - i think we should keep consistent names")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.HttpApplication.#AddOnPostMapRequestHandlerAsync(System.Web.BeginEventHandler,System.Web.EndEventHandler)", MessageId = "bh", Justification = @"[....]: This is for consistency with existing methods.")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.HttpApplication.#AddOnPostMapRequestHandlerAsync(System.Web.BeginEventHandler,System.Web.EndEventHandler)", Justification = @"[....]: These are not true events, but asynchronous ones, they require Begin and End delegates, not simple event handler. This pattern is in place since v1.0")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.HttpApplication.#AddOnPostMapRequestHandlerAsync(System.Web.BeginEventHandler,System.Web.EndEventHandler,System.Object)", Justification = @"[....]: this is an 'async' event which does not fit the standard event pattern")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.HttpApplication.#AddOnPostReleaseRequestStateAsync(System.Web.BeginEventHandler,System.Web.EndEventHandler)", MessageId = "0#", Justification = @"[....]: these new methods have the same parameter names as the existing public ones that cannot be changed (breaking change) - i think we should keep consistent names")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.HttpApplication.#AddOnPostReleaseRequestStateAsync(System.Web.BeginEventHandler,System.Web.EndEventHandler)", MessageId = "bh", Justification = @"[....]: This is for consistency with existing methods.")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.HttpApplication.#AddOnPostReleaseRequestStateAsync(System.Web.BeginEventHandler,System.Web.EndEventHandler)", Justification = @"[....]: These are not true events, but asynchronous ones, they require Begin and End delegates, not simple event handler. This pattern is in place since v1.0")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.HttpApplication.#AddOnPostReleaseRequestStateAsync(System.Web.BeginEventHandler,System.Web.EndEventHandler,System.Object)", Justification = @"[....]: this is an 'async' event which does not fit the standard event pattern")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.HttpApplication.#AddOnPostRequestHandlerExecuteAsync(System.Web.BeginEventHandler,System.Web.EndEventHandler)", Justification = @"[....]: These are not true events, but asynchronous ones, they require Begin and End delegates, not simple event handler. This pattern is in place since v1.0")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.HttpApplication.#AddOnPostRequestHandlerExecuteAsync(System.Web.BeginEventHandler,System.Web.EndEventHandler,System.Object)", Justification = @"[....]: this is an 'async' event which does not fit the standard event pattern")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.HttpApplication.#AddOnPostResolveRequestCacheAsync(System.Web.BeginEventHandler,System.Web.EndEventHandler)", MessageId = "0#", Justification = @"[....]: these new methods have the same parameter names as the existing public ones that cannot be changed (breaking change) - i think we should keep consistent names")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.HttpApplication.#AddOnPostResolveRequestCacheAsync(System.Web.BeginEventHandler,System.Web.EndEventHandler)", MessageId = "bh", Justification = @"[....]: This is for consistency with existing methods.")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.HttpApplication.#AddOnPostResolveRequestCacheAsync(System.Web.BeginEventHandler,System.Web.EndEventHandler)", Justification = @"[....]: These are not true events, but asynchronous ones, they require Begin and End delegates, not simple event handler. This pattern is in place since v1.0")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.HttpApplication.#AddOnPostResolveRequestCacheAsync(System.Web.BeginEventHandler,System.Web.EndEventHandler,System.Object)", Justification = @"[....]: this is an 'async' event which does not fit the standard event pattern")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.HttpApplication.#AddOnPostUpdateRequestCacheAsync(System.Web.BeginEventHandler,System.Web.EndEventHandler)", MessageId = "0#", Justification = @"[....]: these new methods have the same parameter names as the existing public ones that cannot be changed (breaking change) - i think we should keep consistent names")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.HttpApplication.#AddOnPostUpdateRequestCacheAsync(System.Web.BeginEventHandler,System.Web.EndEventHandler)", MessageId = "bh", Justification = @"[....]: This is for consistency with existing methods.")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.HttpApplication.#AddOnPostUpdateRequestCacheAsync(System.Web.BeginEventHandler,System.Web.EndEventHandler)", Justification = @"[....]: These are not true events, but asynchronous ones, they require Begin and End delegates, not simple event handler. This pattern is in place since v1.0")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.HttpApplication.#AddOnPostUpdateRequestCacheAsync(System.Web.BeginEventHandler,System.Web.EndEventHandler,System.Object)", Justification = @"[....]: this is an 'async' event which does not fit the standard event pattern")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.HttpApplication.#AddOnPreRequestHandlerExecuteAsync(System.Web.BeginEventHandler,System.Web.EndEventHandler)", Justification = @"[....]: These are not true events, but asynchronous ones, they require Begin and End delegates, not simple event handler. This pattern is in place since v1.0")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.HttpApplication.#AddOnPreRequestHandlerExecuteAsync(System.Web.BeginEventHandler,System.Web.EndEventHandler,System.Object)", Justification = @"[....]: this is an 'async' event which does not fit the standard event pattern")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.HttpApplication.#AddOnReleaseRequestStateAsync(System.Web.BeginEventHandler,System.Web.EndEventHandler)", Justification = @"[....]: These are not true events, but asynchronous ones, they require Begin and End delegates, not simple event handler. This pattern is in place since v1.0")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.HttpApplication.#AddOnReleaseRequestStateAsync(System.Web.BeginEventHandler,System.Web.EndEventHandler,System.Object)", Justification = @"[....]: this is an 'async' event which does not fit the standard event pattern")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.HttpApplication.#AddOnResolveRequestCacheAsync(System.Web.BeginEventHandler,System.Web.EndEventHandler)", Justification = @"[....]: These are not true events, but asynchronous ones, they require Begin and End delegates, not simple event handler. This pattern is in place since v1.0")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.HttpApplication.#AddOnResolveRequestCacheAsync(System.Web.BeginEventHandler,System.Web.EndEventHandler,System.Object)", Justification = @"[....]: this is an 'async' event which does not fit the standard event pattern")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.HttpApplication.#AddOnUpdateRequestCacheAsync(System.Web.BeginEventHandler,System.Web.EndEventHandler)", Justification = @"[....]: These are not true events, but asynchronous ones, they require Begin and End delegates, not simple event handler. This pattern is in place since v1.0")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.HttpApplication.#AddOnUpdateRequestCacheAsync(System.Web.BeginEventHandler,System.Web.EndEventHandler,System.Object)", Justification = @"[....]: this is an 'async' event which does not fit the standard event pattern")]
[module: SuppressMessage("Microsoft.Usage", "CA2213:DisposableFieldsShouldBeDisposed", Scope = "member", Target = "System.Web.HttpApplication.#Dispose()", Justification = @"[....]: it does call  _events.Dispose in the finally block contained in the Dispose method")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.HttpApplication.#DisposeInternal()", Justification = @"[....]: Non-CLSExceptions are ok to bubble up here- no security issues.")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope = "member", Target = "System.Web.HttpApplication.#DisposeInternal()", Justification = @"[....]: we've decided not to try to catch specific exceptions - in many cases it is unknown what they are and in some cases there is no outer catch block to report the error to the client nicely")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.HttpApplication.#remove_DefaultAuthentication(System.EventHandler)", Justification = @"[....]: events have to have both add_ and remove_")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope = "member", Target = "System.Web.HttpApplication.#ExecuteStep(System.Web.HttpApplication+IExecutionStep,System.Boolean&)", Justification = @"[....]: we've decided not to try to catch specific exceptions - in many cases it is unknown what they are and in some cases there is no outer catch block to report the error to the client nicely")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.HttpApplication.#InitInternal(System.Web.HttpContext,System.Web.HttpApplicationState,System.Reflection.MethodInfo[])", Justification = @"[....]: Non-CLSExceptions are ok to bubble up here- no security issues.")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope = "member", Target = "System.Web.HttpApplication.#InitInternal(System.Web.HttpContext,System.Web.HttpApplicationState,System.Reflection.MethodInfo[])", Justification = @"[....]: we've decided not to try to catch specific exceptions - in many cases it is unknown what they are and in some cases there is no outer catch block to report the error to the client nicely")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.HttpApplication.#ProcessSpecialRequest(System.Web.HttpContext,System.Reflection.MethodInfo,System.Int32,System.Object,System.EventArgs,System.Web.SessionState.HttpSessionState)", Justification = @"[....]: Non-CLSExceptions are ok to bubble up here- no security issues.")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope = "member", Target = "System.Web.HttpApplication.#ProcessSpecialRequest(System.Web.HttpContext,System.Reflection.MethodInfo,System.Int32,System.Object,System.EventArgs,System.Web.SessionState.HttpSessionState)", Justification = @"[....]: we've decided not to try to catch specific exceptions - in many cases it is unknown what they are and in some cases there is no outer catch block to report the error to the client nicely")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.HttpApplication.#RaiseOnError()", Justification = @"[....]: Non-CLSExceptions are ok to bubble up here- no security issues.")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope = "member", Target = "System.Web.HttpApplication.#RaiseOnError()", Justification = @"[....]: we've decided not to try to catch specific exceptions - in many cases it is unknown what they are and in some cases there is no outer catch block to report the error to the client nicely")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.HttpApplication.#RaiseOnError()", Justification = @"[....]: RaiseOnError is a private method to fire an event")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.HttpApplication.#RaiseOnPreSendRequestContent()", Justification = @"[....]: Non-CLSExceptions are ok to bubble up here- no security issues.")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope = "member", Target = "System.Web.HttpApplication.#RaiseOnPreSendRequestContent()", Justification = @"[....]: we've decided not to try to catch specific exceptions - in many cases it is unknown what they are and in some cases there is no outer catch block to report the error to the client nicely")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.HttpApplication.#RaiseOnPreSendRequestHeaders()", Justification = @"[....]: Non-CLSExceptions are ok to bubble up here- no security issues.")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope = "member", Target = "System.Web.HttpApplication.#RaiseOnPreSendRequestHeaders()", Justification = @"[....]: we've decided not to try to catch specific exceptions - in many cases it is unknown what they are and in some cases there is no outer catch block to report the error to the client nicely")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.HttpApplication.#ResumeSteps(System.Exception)", Justification = @"[....]: Non-CLSExceptions are ok to bubble up here- no security issues.")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope = "member", Target = "System.Web.HttpApplication.#ResumeSteps(System.Exception)", Justification = @"[....]: we've decided not to try to catch specific exceptions - in many cases it is unknown what they are and in some cases there is no outer catch block to report the error to the client nicely")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.HttpApplication.#System.Web.IHttpAsyncHandler.BeginProcessRequest(System.Web.HttpContext,System.AsyncCallback,System.Object)", Justification = @"[....]: HttpApplication cannot be sealed - classes compiled from GLOBAL.ASAX are derived from it")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.HttpApplication.#System.Web.IHttpAsyncHandler.EndProcessRequest(System.IAsyncResult)", Justification = @"[....]: HttpApplication cannot be sealed - it is the base class for GLOBAL.ASAX")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.HttpApplication.#System.Web.IHttpHandler.get_IsReusable()", Justification = @"[....]: HttpApplication cannot be sealed because it is used as base for GLOBAL.ASAX")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.HttpApplication.#System.Web.IHttpHandler.ProcessRequest(System.Web.HttpContext)", Justification = @"[....]: HttpApplication cannot be sealed - it is the base class for GLOBAL.ASAX")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.HttpApplication+AsyncEventExecutionStep.#OnAsyncEventCompletion(System.IAsyncResult)", Justification = @"[....]: Non-CLSExceptions are ok to bubble up here- no security issues.")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope = "member", Target = "System.Web.HttpApplication+AsyncEventExecutionStep.#OnAsyncEventCompletion(System.IAsyncResult)", Justification = @"[....]: we've decided not to try to catch specific exceptions - in many cases it is unknown what they are and in some cases there is no outer catch block to report the error to the client nicely")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.HttpApplication+CallHandlerExecutionStep.#OnAsyncHandlerCompletion(System.IAsyncResult)", Justification = @"[....]: Non-CLSExceptions are ok to bubble up here- no security issues.")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope = "member", Target = "System.Web.HttpApplication+CallHandlerExecutionStep.#OnAsyncHandlerCompletion(System.IAsyncResult)", Justification = @"[....]: we've decided not to try to catch specific exceptions - in many cases it is unknown what they are and in some cases there is no outer catch block to report the error to the client nicely")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.ThreadContext.#DisassociateFromCurrentThread()", Justification = @"[....]: Reviewed, no PipelineRuntime instances handed out")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.HttpApplicationFactory.#CompileApplication()", Justification = @"[....]: pipeline runtime instances are not handed out to user code and the ctor demands full trust.  Excluded after review")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.HttpApplicationFactory.#EnsureAppStartCalled(System.Web.HttpContext)", Justification = @"[....]: Reviewed, no pipeline runtime instances handed out")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.HttpApplicationFactory.#FireApplicationOnStart(System.Web.HttpContext)", Justification = @"[....]: Reviewed, no pipeline runtime instances handed out")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.HttpApplicationFactory.#GetApplicationFile()", Justification = @"[....]: pipeline runtime instances are not handed out to user code and the ctor demands full trust.  Excluded after review")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.HttpApplicationFactory.#GetApplicationInstance(System.Web.HttpContext)", Justification = @"[....]: Reviewed, no pipeline runtime instances handed out")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.HttpApplicationFactory.#GetAppStateByParsingGlobalAsax()", Justification = @"[....]: pipeline runtime instances are not handed out to user code and the ctor demands full trust.  Excluded after review")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.HttpApplicationFactory.#GetNormalApplicationInstance(System.Web.HttpContext)", Justification = @"[....]: Reviewed, no pipeline runtime instances handed out")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.HttpApplicationFactory.#GetSpecialApplicationInstance(System.IntPtr,System.Web.HttpContext)", Justification = @"[....]: Method signature changed.")]
[module: SuppressMessage("Microsoft.Globalization", "CA1303:DoNotPassLiteralsAsLocalizedParameters", Scope = "member", Target = "System.Web.HttpApplicationFactory.#OnAppFileChange(System.Object,System.Web.FileChangeEvent)", MessageId = "System.Web.HttpRuntime.ShutdownAppDomain(System.Web.ApplicationShutdownReason,System.String)", Justification = @"[....]: The message in only used for debugging purposes.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.HttpApplicationFactory.#SetupChangesMonitor()", Justification = @"[....]: pipeline runtime instances are not handed out to user code and the ctor demands full trust.  Excluded after review")]
[module: SuppressMessage("Microsoft.Usage", "CA2237:MarkISerializableTypesWithSerializable", Scope = "type", Target = "System.Web.HttpApplicationState", Justification = @"[....]: The two underlying HttpStaticObjectsCollection aren't serializable.")]
[module: SuppressMessage("Microsoft.Naming", "CA1706:ShortAcronymsShouldBeUppercase", Scope = "member", Target = "System.Web.HttpApplicationStateBase.#UnLock()", MessageId = "Member", Justification = @"[....]: legacy")]
[module: SuppressMessage("Microsoft.Security", "CA2110:SecureGetObjectDataOverrides", Scope = "member", Target = "System.Web.HttpApplicationStateWrapper.#GetObjectData(System.Runtime.Serialization.SerializationInfo,System.Runtime.Serialization.StreamingContext)", Justification = @"[....]: already fixed")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.HttpCachePolicy.#SetETag(System.String)", Justification = @"[....]: Reviewed, and these are appropriate uses of methods.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.HttpCachePolicy.#SetExpires(System.DateTime)", Justification = @"[....]: Reviewed, and these are appropriate uses of methods.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.HttpCachePolicy.#SetLastModified(System.DateTime)", Justification = @"[....]: Reviewed, and these are appropriate uses of methods.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.HttpCachePolicy.#SetMaxAge(System.TimeSpan)", Justification = @"[....]: Reviewed, and these are appropriate uses of methods.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.HttpCachePolicy.#SetOmitVaryStar(System.Boolean)", Justification = @"[....]: The naming of methods on this class follows an established pattern for cache control policy (i.e. HttpCachePolicy), and is thus excluded.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.HttpCachePolicy.#SetProxyMaxAge(System.TimeSpan)", Justification = @"[....]: Reviewed, and these are appropriate uses of methods.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.HttpCachePolicy.#SetRevalidation(System.Web.HttpCacheRevalidation)", Justification = @"[....]: Reviewed, and these are appropriate uses of methods.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.HttpCachePolicy.#SetSlidingExpiration(System.Boolean)", Justification = @"[....]: Reviewed, and these are appropriate uses of methods.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.HttpCachePolicy.#SetValidUntilExpires(System.Boolean)", Justification = @"[....]: Reviewed, and these are appropriate uses of methods.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.HttpCachePolicy.#SetVaryByCustom(System.String)", Justification = @"[....]: Reviewed, and these are appropriate uses of methods.")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope = "type", Target = "System.Web.HttpCacheValidateHandler", Justification = @"NO_JUSTIFICATION_PROVIDED")]
[module: SuppressMessage("Microsoft.Usage", "CA2237:MarkISerializableTypesWithSerializable", Scope = "type", Target = "System.Web.HttpClientCertificate", Justification = @"[....]: this collection is not intended to be serialized")]
[module: SuppressMessage("Microsoft.Performance", "CA1807:AvoidUnnecessaryStringCreation", Scope = "member", Target = "System.Web.HttpClientCertificate.#Get(System.String)", MessageId = "field", Justification = @"[....]: ToLower is called to make the switch statement work.")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.HttpCompileException.#GetObjectData(System.Runtime.Serialization.SerializationInfo,System.Runtime.Serialization.StreamingContext)", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.HttpCompileException.#GetObjectData(System.Runtime.Serialization.SerializationInfo,System.Runtime.Serialization.StreamingContext)", Justification = @"[....]: Classes we don't own can't be changed.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.HttpContext.#get_Current()", Justification = @"[....]: HttpContext is only non-null when the LinkDemand for AspNetHostingPermission would be satisfied.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.HttpContext.#GetConfig(System.String)", Justification = @"[....]: HttpContext is only non-null when the LinkDemand for AspNetHostingPermission would be satisfied.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.HttpContext.#GetRuntimeConfig()", Justification = @"[....]: HttpContext is only non-null when the LinkDemand for AspNetHostingPermission would be satisfied.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.HttpContext.#GetSection(System.String)", Justification = @"[....]: HttpContext is only non-null when the LinkDemand for AspNetHostingPermission would be satisfied.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.HttpContext.#get_IsCustomErrorEnabled()", Justification = @"[....]: This is just a helper method that calls into CustomErrorsSection, which does not have the AspNetHostingPermission LinkDemand.  So it is safe to expose the IsCustomErrorEnabled() method to user code.")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope = "member", Target = "System.Web.HttpContext.#get_IsDebuggingEnabled()", Justification = @"[....]: general exception catching is OK")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.HttpContext.#get_Request()", Justification = @"[....]: HttpContext is only non-null when the LinkDemand for AspNetHostingPermission would be satisfied.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.HttpContext.#get_Response()", Justification = @"[....]: HttpContext is only non-null when the LinkDemand for AspNetHostingPermission would be satisfied.")]
[module: SuppressMessage("Microsoft.Naming", "CA1720:AvoidTypeNamesInParameters", Scope = "member", Target = "System.Web.HttpContext.#RewritePath(System.String,System.String,System.String)", MessageId = "2#", Justification = @"[....]: Breaking changes")]
[module: SuppressMessage("Microsoft.Naming", "CA1720:AvoidTypeNamesInParameters", Scope = "member", Target = "System.Web.HttpContext.#RewritePath(System.String,System.String,System.String,System.Boolean)", MessageId = "2#", Justification = @"[....]: Added a method overload with the same parameter names.")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.HttpContext.#SendEmptyResponse()", Justification = @"[....]: code may be used for debug purposes and through reflection")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.HttpContext.#set_SkipAuthorization(System.Boolean)", Justification = @"[....]: These are protected by a full declarative unmanaged code demand, which covers security on the methods.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.HttpContext.#get_Timeout()", Justification = @"[....]: HttpContext is only non-null when the LinkDemand for AspNetHostingPermission would be satisfied.")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.HttpContext.#set_User(System.Security.Principal.IPrincipal)", Justification = @"[....]: These are protected by a full declarative unmanaged code demand, which covers security on the methods.")]
[module: SuppressMessage("Microsoft.Usage", "CA2237:MarkISerializableTypesWithSerializable", Scope = "type", Target = "System.Web.HttpCookieCollection", Justification = @"[....]: this collection is not intended to be serialized")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.HttpException.#.ctor(System.Int32,System.String)", Justification = @"[....]: RuntimeConfig.GetAppConfig only accesseses the System.Web configuration system when the LinkDemand for AspNetHostingPermission would be satisfied.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.HttpException.#.ctor(System.String)", Justification = @"[....]: The HttpException is caught as rethrown as ConfigurationErrorsException, the original exception is not exposed externally.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.HttpException.#GetHtmlErrorMessage()", Justification = @"[....]: Reviewed, and these are appropriate uses of methods.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.HttpException.#GetHttpCode()", Justification = @"[....]: This occurs only for DBG builds.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.HttpException.#GetHttpCode()", Justification = @"[....]: Reviewed, and these are appropriate uses of methods.")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.HttpException.#GetObjectData(System.Runtime.Serialization.SerializationInfo,System.Runtime.Serialization.StreamingContext)", Justification = @"[....]: Seems fine here")]
[module: SuppressMessage("Microsoft.Usage", "CA2237:MarkISerializableTypesWithSerializable", Scope = "type", Target = "System.Web.HttpFileCollection", Justification = @"[....]: this collection is not intended to be serialized")]
[module: SuppressMessage("Microsoft.Security", "CA2110:SecureGetObjectDataOverrides", Scope = "member", Target = "System.Web.HttpFileCollectionWrapper.#GetObjectData(System.Runtime.Serialization.SerializationInfo,System.Runtime.Serialization.StreamingContext)", Justification = @"[....]: it's already fixed")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope = "type", Target = "System.Web.HttpFileResponseElement", Justification = @"[....]: This is an internal class (since v1.0), it's lifetime is controlled by ASP.NET")]
[module: SuppressMessage("Microsoft.Performance", "CA1812:AvoidUninstantiatedInternalClasses", Scope = "type", Target = "System.Web.HttpForbiddenHandler", Justification = @"[....]: usable via machine.config")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.HttpForbiddenHandler.#.ctor()", Justification = @"[....]: The class is referenced via config.")]
[module: SuppressMessage("Microsoft.Performance", "CA1812:AvoidUninstantiatedInternalClasses", Scope = "type", Target = "System.Web.HttpMethodNotAllowedHandler", Justification = @"[....]: usable via machine.config")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.HttpMethodNotAllowedHandler.#.ctor()", Justification = @"[....]: The class is referenced via config.")]
[module: SuppressMessage("Microsoft.Usage", "CA2237:MarkISerializableTypesWithSerializable", Scope = "type", Target = "System.Web.HttpModuleCollection", Justification = @"[....]: this is an old v1.x class and we don't care if it is serializable")]
[module: SuppressMessage("Microsoft.Performance", "CA1812:AvoidUninstantiatedInternalClasses", Scope = "type", Target = "System.Web.HttpNotFoundHandler", Justification = @"[....]: usable via machine.config")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.HttpNotFoundHandler.#.ctor()", Justification = @"[....]: The class is referenced via config.")]
[module: SuppressMessage("Microsoft.Performance", "CA1812:AvoidUninstantiatedInternalClasses", Scope = "type", Target = "System.Web.HttpNotImplementedHandler", Justification = @"[....]: usable via machine.config")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.HttpNotImplementedHandler.#.ctor()", Justification = @"[....]: The class is referenced via config.")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.HttpParseException.#GetObjectData(System.Runtime.Serialization.SerializationInfo,System.Runtime.Serialization.StreamingContext)", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.HttpParseException.#GetObjectData(System.Runtime.Serialization.SerializationInfo,System.Runtime.Serialization.StreamingContext)", Justification = @"[....]: Classes we don't own can't be changed.")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope = "member", Target = "System.Web.HttpRawUploadedContent+TempFile.#.ctor()", Justification = @"[....]: we've decided not to try to catch specific exceptions - in many cases it is unknown what they are and in some cases there is no outer catch block to report the error to the client nicely")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope = "member", Target = "System.Web.HttpRawUploadedContent+TempFile.#Dispose()", Justification = @"[....]: we've decided not to try to catch specific exceptions - in many cases it is unknown what they are and in some cases there is no outer catch block to report the error to the client nicely")]
[module: SuppressMessage("Microsoft.Naming", "CA1720:AvoidTypeNamesInParameters", Scope = "member", Target = "System.Web.HttpRequest.#.ctor(System.String,System.String,System.String)", MessageId = "2#", Justification = @"[....]: Breaking changes")]
[module: SuppressMessage("Microsoft.Naming", "CA1706:ShortAcronymsShouldBeUppercase", Scope = "member", Target = "System.Web.HttpRequest.#AnonymousID", Justification = @"[....]: ID approved acronym.")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope = "member", Target = "System.Web.HttpRequest.#get_ContentLength()", Justification = @"[....]: general exception catching is OK")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.HttpRequest.#FillInFormCollection()", Justification = @"[....]: No security issues= non-ClsCompliant exceptions are ok to bubble up here.")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope = "member", Target = "System.Web.HttpRequest.#GetEncodingFromHeaders()", Justification = @"[....]: general exception catching is OK")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope = "member", Target = "System.Web.HttpRequest.#MapImageCoordinates(System.String)", Justification = @"[....]: general exception catching is OK")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.HttpRequest.#SetSkipAuthorization(System.Boolean)", Justification = @"NO_JUSTIFICATION_PROVIDED")]
[module: SuppressMessage("Microsoft.Usage", "CA2234:PassSystemUriObjectsInsteadOfStrings", Scope = "member", Target = "System.Web.HttpRequest.#get_UrlReferrer()", Justification = @"[....]: This looks fine.")]
[module: SuppressMessage("Microsoft.Naming", "CA1706:ShortAcronymsShouldBeUppercase", Scope = "member", Target = "System.Web.HttpRequestBase.#AnonymousID", MessageId = "Member", Justification = @"[....]: already fixed")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope = "type", Target = "System.Web.HttpResourceResponseElement", Justification = @"[....]: this class does not allocate unmanaged resource")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope = "member", Target = "System.Web.HttpResourceResponseElement.#_data", Justification = @"[....]: this is a pointer to unmanaged buffer (ASP.NET controls the buffer pool from unmanaged code)")]
[module: SuppressMessage("Microsoft.Globalization", "CA1305:SpecifyIFormatProvider", Scope = "member", Target = "System.Web.HttpResponse.#AppendHeader(System.String,System.String)", Justification = @"[....]: although unlikely, the content length string could be passed using the current culture")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope = "member", Target = "System.Web.HttpResponse.#GenerateResponseHeaders(System.Boolean)", Justification = @"[....]: general exception catching is OK")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.HttpResponse.#SetCookie(System.Web.HttpCookie)", Justification = @"[....]: Reviewed, and these are appropriate uses of methods.")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "member", Target = "System.Web.HttpResponse.#TransmitFile(System.String,System.Int64,System.Int64)", MessageId = "filename", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.HttpResponse.#WriteFile(System.IntPtr,System.Int64,System.Int64)", Justification = @"[....]: These are protected by a full declarative unmanaged code demand, which covers security on the methods.")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.HttpResponseStreamFilterSink.#get_Filtering()", Justification = @"[....]: code may be used for debug purposes and through reflection")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope = "type", Target = "System.Web.HttpResponseSubstitutionCallback", Justification = @"NO_JUSTIFICATION_PROVIDED")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope = "type", Target = "System.Web.HttpResponseUnmanagedBufferElement", Justification = @"[....]: ASP.NET controls the lifetime of this internal class")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope = "member", Target = "System.Web.HttpResponseUnmanagedBufferElement.#_data", Justification = @"[....]: this IntPtr is not an OS handler")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope = "member", Target = "System.Web.HttpResponseUnmanagedBufferElement.#s_Pool", Justification = @"[....]: this IntPtr is not an OS handler")]
[module: SuppressMessage("Microsoft.Globalization", "CA1303:DoNotPassLiteralsAsLocalizedParameters", Scope = "member", Target = "System.Web.HttpRuntime.#.cctor()", MessageId = "System.Web.HttpRuntime.AddAppDomainTraceMessage(System.String)", Justification = @"[....]: the string is for internal instrumentation only - it does not get to the customer")]
[module: SuppressMessage("Microsoft.Usage", "CA2204:LiteralsShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.HttpRuntime.#.cctor()", MessageId = "cctor", Justification = @"[....]: the string is for internal instrumentation only - it does not get to the customer")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.HttpRuntime.#.ctor()", Justification = @"[....]: These are protected by a full declarative unmanaged code demand, which covers security on the methods.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.HttpRuntime.#AddAppDomainTraceMessage(System.String)", Justification = @"[....]: There's a full demand on the ctor of ISAPIRuntime and the object is well-protected so a user should never get an instance, so these should not be a vulnerability.  [....] did the security review.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.HttpRuntime.#get_AppDomainAppPathInternal()", Justification = @"[....]: These do not present a security problem - the data called is never exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.HttpRuntime.#get_AppDomainAppVirtualPath()", Justification = @"[....]: If ASP.NET is not hosted, and thus the link demand not satisifed, this code path is not followed.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.HttpRuntime.#get_AppDomainAppVirtualPathObject()", Justification = @"[....]: This is fine.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.HttpRuntime.#get_AppDomainAppVirtualPathString()", Justification = @"[....]: This is fine.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.HttpRuntime.#get_AppDomainIdInternal()", Justification = @"[....]: This was excluded before, but a small method change made it pop up again.")]
[module: SuppressMessage("Microsoft.Globalization", "CA1303:DoNotPassLiteralsAsLocalizedParameters", Scope = "member", Target = "System.Web.HttpRuntime.#AppDomainShutdownTimerCallback(System.Object)", MessageId = "System.Web.HttpRuntime.ShutdownAppDomain(System.Web.ApplicationShutdownReason,System.String)", Justification = @"[....]: the string is for internal instrumentation only - it does not get to the customer")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.HttpRuntime.#get_CacheInternal()", Justification = @"[....]: WebConfigurationManager only invokes the HttpConfigurationSystem when the LinkDemand for AspNetHostingPermission would be satisfied.")]
[module: SuppressMessage("Microsoft.Globalization", "CA1303:DoNotPassLiteralsAsLocalizedParameters", Scope = "member", Target = "System.Web.HttpRuntime.#Close()", MessageId = "System.Web.HttpRuntime.SetShutdownReason(System.Web.ApplicationShutdownReason,System.String)", Justification = @"[....]: the string is for internal instrumentation only - it does not get to the customer")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.HttpRuntime.#Close()", Justification = @"[....]: These are protected by a full declarative unmanaged code demand, which covers security on the methods.")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope = "member", Target = "System.Web.HttpRuntime.#CoalesceNotifications()", Justification = @"[....]: general exception catching is OK")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.HttpRuntime.#get_CodegenDirInternal()", Justification = @"[....]: This is used only in debug build for debugging purpose.")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope = "member", Target = "System.Web.HttpRuntime.#Dispose()", Justification = @"[....]: general exception catching is OK")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.HttpRuntime.#remove_AppDomainShutdown(System.Web.Compilation.BuildManagerHostUnloadEventHandler)", Justification = @"[....]: Internal event field.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.HttpRuntime.#FailIfNoAPTCABit(System.Type,System.Configuration.ElementInformation,System.String)", Justification = @"[....]: No problem here.")]
[module: SuppressMessage("Microsoft.Globalization", "CA1303:DoNotPassLiteralsAsLocalizedParameters", Scope = "member", Target = "System.Web.HttpRuntime.#FinishPipelineRequest(System.Web.HttpContext)", MessageId = "System.Web.HttpRuntime.ShutdownAppDomain(System.Web.ApplicationShutdownReason,System.String)", Justification = @"[....]: ok")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.HttpRuntime.#FinishRequest(System.Web.HttpWorkerRequest,System.Web.HttpContext,System.Exception)", Justification = @"[....]: Non-CLSExceptions are ok to bubble up here- no security issues.")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope = "member", Target = "System.Web.HttpRuntime.#FinishRequest(System.Web.HttpWorkerRequest,System.Web.HttpContext,System.Exception)", Justification = @"[....]: general exception catching is OK")]
[module: SuppressMessage("Microsoft.Globalization", "CA1303:DoNotPassLiteralsAsLocalizedParameters", Scope = "member", Target = "System.Web.HttpRuntime.#FinishRequest(System.Web.HttpWorkerRequest,System.Web.HttpContext,System.Exception)", MessageId = "System.Web.HttpRuntime.ShutdownAppDomain(System.Web.ApplicationShutdownReason,System.String)", Justification = @"[....]: The message in only used for debugging purposes.")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.HttpRuntime.#FirstRequestInit(System.Web.HttpContext)", Justification = @"[....]: Non-CLSExceptions are ok to bubble up here- no security issues.")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope = "member", Target = "System.Web.HttpRuntime.#FirstRequestInit(System.Web.HttpContext)", Justification = @"[....]: general exception catching is OK")]
[module: SuppressMessage("Microsoft.Globalization", "CA1303:DoNotPassLiteralsAsLocalizedParameters", Scope = "member", Target = "System.Web.HttpRuntime.#FirstRequestInit(System.Web.HttpContext)", MessageId = "System.Web.HttpRuntime.AddAppDomainTraceMessage(System.String)", Justification = @"[....]: the string is for internal instrumentation only - it does not get to the customer")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.HttpRuntime.#ForceStaticInit()", Justification = @"[....]: I have added a Demand for UnmanagedCode permissions to the RemoteWebServer, so that is only used via DCOM.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.HttpRuntime.#GetNamedPermissionSet()", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope = "member", Target = "System.Web.HttpRuntime.#GetSafePath(System.String)", Justification = @"[....]: general exception catching is OK")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope = "member", Target = "System.Web.HttpRuntime.#HasFilePermission(System.String)", Justification = @"[....]: general exception catching is OK")]
[module: SuppressMessage("Microsoft.Security", "CA2103:ReviewImperativeSecurity", Scope = "member", Target = "System.Web.HttpRuntime.#HasFilePermission(System.String,System.Boolean)", Justification = @"[....]: Ok, since string is immutable")]
[module: SuppressMessage("Microsoft.Security", "CA2103:ReviewImperativeSecurity", Scope = "member", Target = "System.Web.HttpRuntime.#HasWebPermission(System.Uri)", Justification = @"[....]: Looks fine, since strings are immutable.")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.HttpRuntime.#HostingInit(System.Web.Hosting.HostingEnvironmentFlags)", Justification = @"[....]: Non-CLSExceptions are ok to bubble up here- no security issues.")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.HttpRuntime.#Init()", Justification = @"[....]: Non-CLSExceptions are ok to bubble up here- no security issues.")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope = "member", Target = "System.Web.HttpRuntime.#Init()", Justification = @"[....]: general exception catching is OK")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope = "member", Target = "System.Web.HttpRuntime.#InitHttpConfiguration()", Justification = @"[....]: general exception catching is OK")]
[module: SuppressMessage("Microsoft.Reliability", "CA2003:DoNotTreatFibersAsThreads", Scope = "member", Target = "System.Web.HttpRuntime.#InitHttpConfiguration()", Justification = @"[....]: we know we're working with managed threads")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.HttpRuntime.#get_IsFullTrust()", Justification = @"[....]: code may be used for debug purposes and through reflection")]
[module: SuppressMessage("Microsoft.Globalization", "CA1303:DoNotPassLiteralsAsLocalizedParameters", Scope = "member", Target = "System.Web.HttpRuntime.#OnAppOfflineFileChange(System.Object,System.Web.FileChangeEvent)", MessageId = "System.Web.HttpRuntime.ShutdownAppDomain(System.Web.ApplicationShutdownReason,System.String)", Justification = @"[....]: literal used for internal instrumentation only")]
[module: SuppressMessage("Microsoft.Usage", "CA2204:LiteralsShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.HttpRuntime.#OnAppOfflineFileChange(System.Object,System.Web.FileChangeEvent)", MessageId = "htm", Justification = @"[....]: the literal is spelled correctly -- .htm is file extension")]
[module: SuppressMessage("Microsoft.Globalization", "CA1303:DoNotPassLiteralsAsLocalizedParameters", Scope = "member", Target = "System.Web.HttpRuntime.#OnConfigChange()", MessageId = "System.Web.HttpRuntime.ShutdownAppDomain(System.Web.ApplicationShutdownReason,System.String)", Justification = @"[....]: the string is for internal instrumentation only - it does not get to the customer")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.HttpRuntime.#OnHandlerCompletion(System.IAsyncResult)", Justification = @"[....]: Non-CLSExceptions are ok to bubble up here- no security issues.")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope = "member", Target = "System.Web.HttpRuntime.#OnHandlerCompletion(System.IAsyncResult)", Justification = @"[....]: general exception catching is OK")]
[module: SuppressMessage("Microsoft.Globalization", "CA1303:DoNotPassLiteralsAsLocalizedParameters", Scope = "member", Target = "System.Web.HttpRuntime.#OnSecurityPolicyFileChange(System.Object,System.Web.FileChangeEvent)", MessageId = "System.Web.HttpRuntime.ShutdownAppDomain(System.Web.ApplicationShutdownReason,System.String)", Justification = @"[....]: The message in only used for debugging purposes.")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope = "member", Target = "System.Web.HttpRuntime.#PreloadAssembliesFromBin()", Justification = @"[....]: general exception catching is OK")]
[module: SuppressMessage("Microsoft.Reliability", "CA2001:AvoidCallingProblematicMethods", Scope = "member", Target = "System.Web.HttpRuntime.#PreloadAssembliesFromBinRecursive(System.IO.DirectoryInfo)", MessageId = "System.Reflection.Assembly.LoadFrom", Justification = @"[....]: This is what we want.")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.HttpRuntime.#ProcessRequestInternal(System.Web.HttpWorkerRequest)", Justification = @"[....]: Non-CLSExceptions are ok to bubble up here- no security issues.")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope = "member", Target = "System.Web.HttpRuntime.#ProcessRequestInternal(System.Web.HttpWorkerRequest)", Justification = @"[....]: general exception catching is OK")]
[module: SuppressMessage("Microsoft.Globalization", "CA1303:DoNotPassLiteralsAsLocalizedParameters", Scope = "member", Target = "System.Web.HttpRuntime.#RecoverFromUnexceptedAppDomainUnload()", MessageId = "System.Web.HttpRuntime.AddAppDomainTraceMessage(System.String)", Justification = @"[....]: the string is for internal instrumentation only - it does not get to the customer")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.HttpRuntime.#RejectRequestInternal(System.Web.HttpWorkerRequest,System.Boolean)", Justification = @"[....]: Non-CLSExceptions are ok to bubble up here- no security issues.")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.HttpRuntime.#ReleaseResourcesAndUnloadAppDomain(System.Object)", Justification = @"[....]: Non-CLSExceptions are ok to bubble up here- no security issues.")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope = "member", Target = "System.Web.HttpRuntime.#ReleaseResourcesAndUnloadAppDomain(System.Object)", Justification = @"[....]: general exception catching is OK")]
[module: SuppressMessage("Microsoft.Globalization", "CA1303:DoNotPassLiteralsAsLocalizedParameters", Scope = "member", Target = "System.Web.HttpRuntime.#ReleaseResourcesAndUnloadAppDomain(System.Object)", MessageId = "System.Web.HttpRuntime.AddAppDomainTraceMessage(System.String)", Justification = @"[....]: the string is for internal instrumentation only - it does not get to the customer")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.HttpRuntime.#ShutdownAppDomain(System.Web.ApplicationShutdownReason,System.String)", Justification = @"[....]: There's a full demand on the ctor of ISAPIRuntime and the object is well-protected so a user should never get an instance, so these should not be a vulnerability.  [....] did the security review.")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope = "member", Target = "System.Web.HttpRuntime.#StaticInit()", Justification = @"[....]: general exception catching is OK")]
[module: SuppressMessage("Microsoft.Globalization", "CA1303:DoNotPassLiteralsAsLocalizedParameters", Scope = "member", Target = "System.Web.HttpRuntime.#StaticInit()", MessageId = "System.Web.HttpRuntime.AddAppDomainTraceMessage(System.String)", Justification = @"[....]: the string is for internal instrumentation only - it does not get to the customer")]
[module: SuppressMessage("Microsoft.Globalization", "CA1303:DoNotPassLiteralsAsLocalizedParameters", Scope = "member", Target = "System.Web.HttpRuntime.#UnloadAppDomain()", MessageId = "System.Web.HttpRuntime.ShutdownAppDomain(System.Web.ApplicationShutdownReason,System.String)", Justification = @"[....]: the string is for internal instrumentation only - it does not get to the customer")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.HttpRuntime.#UnloadAppDomain()", Justification = @"[....]: These are protected by a full declarative unmanaged code demand, which covers security on the methods.")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope = "member", Target = "System.Web.HttpServerUtility.#CreateObject(System.String)", Justification = @"[....]: general exception catching is OK")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.HttpServerUtility.#CreateObject(System.String)", Justification = @"[....]: These are protected by a full declarative unmanaged code demand, which covers security on the methods.")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.HttpServerUtility.#CreateObject(System.Type)", Justification = @"[....]: These are protected by a full declarative unmanaged code demand, which covers security on the methods.")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope = "member", Target = "System.Web.HttpServerUtility.#CreateObjectFromClsid(System.String)", Justification = @"[....]: general exception catching is OK")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.HttpServerUtility.#CreateObjectFromClsid(System.String)", Justification = @"[....]: These are protected by a full declarative unmanaged code demand, which covers security on the methods.")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.HttpServerUtility.#Execute(System.String,System.IO.TextWriter,System.Boolean)", Justification = @"[....]: No security issues= non-ClsCompliant exceptions are ok to bubble up here.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.HttpServerUtility.#GetLastError()", Justification = @"[....]: Reviewed, and these are appropriate uses of methods.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.HttpServerUtility.#GetMachineNameInternal()", Justification = @"[....]: Reviewed for security vulnerabilities, none found.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.HttpServerUtility.#UrlTokenEncode(System.Byte[])", Justification = @"[....]: RolePrincipal.ToEncryptedTicket should work in partial trust")]
[module: SuppressMessage("Microsoft.Design", "CA1055:UriReturnValuesShouldNotBeStrings", Scope = "member", Target = "System.Web.HttpServerUtility.#UrlTokenEncode(System.Byte[])", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Naming", "CA1706:ShortAcronymsShouldBeUppercase", Scope = "member", Target = "System.Web.HttpServerUtilityBase.#CreateObject(System.String)", MessageId = "0#", Justification = @"[....]: it's already fixed")]
[module: SuppressMessage("Microsoft.Naming", "CA1706:ShortAcronymsShouldBeUppercase", Scope = "member", Target = "System.Web.HttpSessionStateBase.#SessionID", MessageId = "Member", Justification = @"[....]: legacy")]
[module: SuppressMessage("Microsoft.Globalization", "CA1305:SpecifyIFormatProvider", Scope = "member", Target = "System.Web.HttpUtility.#FormatPlainTextAsHtml(System.String)", Justification = @"[....]: culture behavior derived from thread")]
[module: SuppressMessage("Microsoft.Globalization", "CA1305:SpecifyIFormatProvider", Scope = "member", Target = "System.Web.HttpUtility.#FormatPlainTextSpacesAsHtml(System.String)", Justification = @"[....]: culture behavior derived from thread")]
[module: SuppressMessage("Microsoft.Globalization", "CA1305:SpecifyIFormatProvider", Scope = "member", Target = "System.Web.HttpUtility.#HtmlDecode(System.String)", Justification = @"[....]: culture behavior derived from thread")]
[module: SuppressMessage("Microsoft.Globalization", "CA1305:SpecifyIFormatProvider", Scope = "member", Target = "System.Web.HttpUtility.#HtmlDecode(System.String,System.IO.TextWriter)", Justification = @"[....]: culture behavior derived from thread")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.HttpUtility.#HtmlEncode(System.String)", Justification = @"[....]: Designer needs to call HtmlEncode and returns proper error message. The designer assembly does require full trust.")]
[module: SuppressMessage("Microsoft.Globalization", "CA1305:SpecifyIFormatProvider", Scope = "member", Target = "System.Web.HttpUtility.#HtmlEncode(System.String)", Justification = @"[....]: culture behavior derived from thread")]
[module: SuppressMessage("Microsoft.Design", "CA1012:AbstractTypesShouldNotHaveConstructors", Scope = "type", Target = "System.Web.HttpWorkerRequest", Justification = @"[....]: excluded for breaking change")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.HttpWorkerRequest.#.ctor()", Justification = @"[....]: There's a full demand on the ctor of ISAPIRuntime and the object is well-protected so a user should never get an instance, so these should not be a vulnerability.  [....] did the security review.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.HttpWorkerRequest.#GetAppPath()", Justification = @"[....]: Reviewed, and these are appropriate uses of methods.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.HttpWorkerRequest.#GetAppPathTranslated()", Justification = @"[....]: There's a full demand on the ctor of ISAPIRuntime and the object is well-protected so a user should never get an instance, so these should not be a vulnerability.  [....] did the security review.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.HttpWorkerRequest.#GetAppPathTranslated()", Justification = @"[....]: Reviewed, and these are appropriate uses of methods.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.HttpWorkerRequest.#GetAppPoolID()", Justification = @"[....]: Reviewed, and these are appropriate uses of methods.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.HttpWorkerRequest.#GetBytesRead()", Justification = @"[....]: Reviewed, and these are appropriate uses of methods.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.HttpWorkerRequest.#GetClientCertificateEncoding()", Justification = @"[....]: Reviewed, and these are appropriate uses of methods.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.HttpWorkerRequest.#GetClientCertificateValidFrom()", Justification = @"[....]: Reviewed, and these are appropriate uses of methods.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.HttpWorkerRequest.#GetClientCertificateValidUntil()", Justification = @"[....]: Reviewed, and these are appropriate uses of methods.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.HttpWorkerRequest.#GetConnectionID()", Justification = @"[....]: Reviewed, and these are appropriate uses of methods.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.HttpWorkerRequest.#GetFilePath()", Justification = @"[....]: Reviewed, and these are appropriate uses of methods.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.HttpWorkerRequest.#GetFilePathTranslated()", Justification = @"[....]: Reviewed, and these are appropriate uses of methods.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.HttpWorkerRequest.#GetHttpVerbName()", Justification = @"[....]: Reviewed, and these are appropriate uses of methods.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.HttpWorkerRequest.#GetHttpVersion()", Justification = @"[....]: Reviewed, and these are appropriate uses of methods.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.HttpWorkerRequest.#GetLocalAddress()", Justification = @"[....]: Reviewed, and these are appropriate uses of methods.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.HttpWorkerRequest.#GetLocalPort()", Justification = @"[....]: Reviewed, and these are appropriate uses of methods.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.HttpWorkerRequest.#GetPathInfo()", Justification = @"[....]: Reviewed, and these are appropriate uses of methods.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.HttpWorkerRequest.#GetPreloadedEntityBodyLength()", Justification = @"[....]: this is consistent with other members of HttpWorkerRequest class")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.HttpWorkerRequest.#GetProtocol()", Justification = @"[....]: Reviewed, and these are appropriate uses of methods.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.HttpWorkerRequest.#GetQueryString()", Justification = @"[....]: Reviewed, and these are appropriate uses of methods.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.HttpWorkerRequest.#GetRawUrl()", Justification = @"[....]: Reviewed, and these are appropriate uses of methods.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.HttpWorkerRequest.#GetRemoteAddress()", Justification = @"[....]: Reviewed, and these are appropriate uses of methods.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.HttpWorkerRequest.#GetRemoteName()", Justification = @"[....]: Reviewed, and these are appropriate uses of methods.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.HttpWorkerRequest.#GetRemotePort()", Justification = @"[....]: Reviewed, and these are appropriate uses of methods.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.HttpWorkerRequest.#GetRequestReason()", Justification = @"[....]: Reviewed, and these are appropriate uses of methods.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.HttpWorkerRequest.#GetServerName()", Justification = @"[....]: Reviewed, and these are appropriate uses of methods.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.HttpWorkerRequest.#GetTotalEntityBodyLength()", Justification = @"[....]: this is consistent with other members of HttpWorkerRequest class")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.HttpWorkerRequest.#GetUriPath()", Justification = @"[....]: Reviewed, and these are appropriate uses of methods.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.HttpWorkerRequest.#GetUrlContextID()", Justification = @"[....]: Reviewed, and these are appropriate uses of methods.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.HttpWorkerRequest.#GetUserToken()", Justification = @"[....]: Reviewed, and these are appropriate uses of methods.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.HttpWorkerRequest.#GetVirtualPathToken()", Justification = @"[....]: Reviewed, and these are appropriate uses of methods.")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope = "type", Target = "System.Web.HttpWorkerRequest+EndOfSendNotification", Justification = @"NO_JUSTIFICATION_PROVIDED")]
[module: SuppressMessage("Microsoft.Design", "CA1025:ReplaceRepetitiveArgumentsWithParamsArray", Scope = "member", Target = "System.Web.IHttpHandlerFactory.#GetHandler(System.Web.HttpContext,System.String,System.String,System.String)", Justification = @"[....]: distinct string arguments not being replaced with array of strings.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.IisTraceListener.#TraceData(System.Diagnostics.TraceEventCache,System.String,System.Diagnostics.TraceEventType,System.Int32,System.Object)", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.IisTraceListener.#TraceData(System.Diagnostics.TraceEventCache,System.String,System.Diagnostics.TraceEventType,System.Int32,System.Object[])", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "System.Web.IisTraceListener.#TraceEvent(System.Diagnostics.TraceEventCache,System.String,System.Diagnostics.TraceEventType,System.Int32,System.String)", MessageId = "System.String.Concat(System.Object[])", Justification = @"NO_JUSTIFICATION_PROVIDED")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.IisTraceListener.#TraceEvent(System.Diagnostics.TraceEventCache,System.String,System.Diagnostics.TraceEventType,System.Int32,System.String)", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.IisTraceListener.#TraceEvent(System.Diagnostics.TraceEventCache,System.String,System.Diagnostics.TraceEventType,System.Int32,System.String,System.Object[])", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.IisTraceListener.#Write(System.String)", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.IisTraceListener.#Write(System.String,System.String)", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.IisTraceListener.#WriteLine(System.String)", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.IisTraceListener.#WriteLine(System.String,System.String)", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope = "member", Target = "System.Web.ImpersonationContext.#_savedToken", Justification = @"[....]: finalizer is good enough here")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.ImpersonationContext.#GetCurrentToken()", Justification = @"[....]: Config should not be protected by link demands.")]
[module: SuppressMessage("Microsoft.Security", "CA2103:ReviewImperativeSecurity", Scope = "member", Target = "System.Web.InternalSecurityPermissions.#FileWriteAccess(System.String)", Justification = @"[....]: We need to allow buildproviders to write to only specific files in the codegen folder.")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.InternalSecurityPermissions.#get_Reflection()", Justification = @"[....]: already excluded, accidental duplication in merge")]
[module: SuppressMessage("Microsoft.Performance", "CA1812:AvoidUninstantiatedInternalClasses", Scope = "type", Target = "System.Web.ModName", Justification = @"[....]: Contains string constants that are used.")]
[module: SuppressMessage("Microsoft.Performance", "CA1812:AvoidUninstantiatedInternalClasses", Scope = "type", Target = "System.Web.NativeMethods", Justification = @"[....]: Don't know why the constructor is there, but since the constructor is private, it won't hurt.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.NativeMethods.#CreateAssemblyCache(System.Web.Configuration.IAssemblyCache&,System.UInt32)", Justification = @"[....]: Fusion.dll is there")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.PartitionManager.#GetPartition(System.Web.IPartitionResolver,System.String)", Justification = @"[....]: Disregarding this rule because it doesn't make sense for our code.")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope = "member", Target = "System.Web.PerfCounters.#_global", Justification = @"[....]: This IntPtr points to a memory blob, not a handle")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope = "member", Target = "System.Web.PerfCounters.#_instance", Justification = @"[....]: This IntPtr points to a memory blob, not a handle")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope = "member", Target = "System.Web.PerfCounters.#_stateService", Justification = @"[....]: The usage of the _stateService pointer is safe as is.  The perf counter memory block is created in unmanaged (and references kept to it), so it can be properly cleaned up at worker process shutdown.")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.PerfCounters.#OpenCounter(System.String)", Justification = @"[....]: Disregarding this rule because it doesn't make sense for our code.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.ProcessModelInfo.#GetCurrentProcessInfo()", Justification = @"[....]: Reviewed, and these are appropriate uses of methods.")]
[module: SuppressMessage("Microsoft.Naming", "CA1714:FlagsEnumsShouldHavePluralNames", Scope = "type", Target = "System.Web.RequestNotification", Justification = @"[....]: reviewed and excluded from beta2lhsd")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope = "type", Target = "System.Web.SafeStringResource", Justification = @"[....]: This violation is by design.")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope = "member", Target = "System.Web.SafeStringResource.#_stringResourcePointer", Justification = @"[....]: This IntPtr is to a handle to a memory resource.  We never want to unload it since it's par tof a loaded assembly.  I think we're better off leaving things as they are rather than take the chance to make a change.")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "type", Target = "System.Web.SiteMap", MessageId = "SiteMap", Justification = @"[....]: Spellings ok.")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "member", Target = "System.Web.SiteMap.#SiteMapResolve", MessageId = "SiteMap", Justification = @"[....]: Spellings ok.")]
[module: SuppressMessage("Microsoft.Design", "CA1009:DeclareEventHandlersCorrectly", Scope = "member", Target = "System.Web.SiteMap.#SiteMapResolve", Justification = @"[....]: Each registered event is called separately, we do not lose the result.")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "type", Target = "System.Web.SiteMapNode", MessageId = "SiteMap", Justification = @"[....]: Spellings ok.")]
[module: SuppressMessage("Microsoft.Design", "CA1054:UriParametersShouldNotBeStrings", Scope = "member", Target = "System.Web.SiteMapNode.#.ctor(System.Web.SiteMapProvider,System.String,System.String)", MessageId = "2#", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Design", "CA1054:UriParametersShouldNotBeStrings", Scope = "member", Target = "System.Web.SiteMapNode.#.ctor(System.Web.SiteMapProvider,System.String,System.String,System.String)", MessageId = "2#", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Design", "CA1054:UriParametersShouldNotBeStrings", Scope = "member", Target = "System.Web.SiteMapNode.#.ctor(System.Web.SiteMapProvider,System.String,System.String,System.String,System.String)", MessageId = "2#", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Design", "CA1054:UriParametersShouldNotBeStrings", Scope = "member", Target = "System.Web.SiteMapNode.#.ctor(System.Web.SiteMapProvider,System.String,System.String,System.String,System.String,System.Collections.IList,System.Collections.Specialized.NameValueCollection,System.Collections.Specialized.NameValueCollection,System.String)", MessageId = "2#", Justification = @"NO_JUSTIFICATION_PROVIDED")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope = "member", Target = "System.Web.SiteMapNode.#Attributes", Justification = @"[....]: This is intentional, providers need to have a way to change the collection entirely.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope = "member", Target = "System.Web.SiteMapNode.#ChildNodes", Justification = @"[....]: This is intentional, providers need to have a way to change the collection entirely.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.SiteMapNode.#GetAllNodes()", Justification = @"[....]: An expensive call should be a method.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.SiteMapNode.#GetHierarchicalDataSourceView()", Justification = @"[....]: These are all according to the spec.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope = "member", Target = "System.Web.SiteMapNode.#Roles", Justification = @"[....]: This is intentional, providers need to have a way to change the collection entirely.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.SiteMapNode.#System.ICloneable.Clone()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.SiteMapNode.#System.Web.UI.IHierarchyData.GetChildren()", Justification = @"[....]: This explicitly implemented interface method GetChildren() simply returns a virtual property ChildNodes defined on SiteMapNodeItem.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.SiteMapNode.#System.Web.UI.IHierarchyData.GetParent()", Justification = @"[....]: This will not be overridden by derived classes.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.SiteMapNode.#System.Web.UI.IHierarchyData.get_HasChildren()", Justification = @"[....]: IHierarchyData.HasChildren property already calls the virtual HasChildNodes property on the SiteMapNode.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.SiteMapNode.#System.Web.UI.IHierarchyData.get_Item()", Justification = @"[....]: IHierarchyData.Item property simply returns a reference to itself, does not require a virtual property.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.SiteMapNode.#System.Web.UI.IHierarchyData.get_Path()", Justification = @"[....]: IHierarchyData.Path property already calls the virtual Url property on the SiteMapNode.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.SiteMapNode.#System.Web.UI.IHierarchyData.get_Type()", Justification = @"[....]: IHierarchyData.Type property simply returns a const string, plus it does not make sense to declare a property directly on the SiteMapNode type.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.SiteMapNode.#System.Web.UI.INavigateUIData.get_Name()", Justification = @"[....]: INavigateUIData.Name property simply returns the virtual Title property defined on SiteMapNode.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.SiteMapNode.#System.Web.UI.INavigateUIData.get_NavigateUrl()", Justification = @"[....]: INavigateUIData.NavigateUrl property already calls the virtual Url property on the SiteMapNode.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.SiteMapNode.#System.Web.UI.INavigateUIData.get_Value()", Justification = @"[....]: INavigateUIData.Value property simply returns the virtual Title property defined on SiteMapNode.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.SiteMapNode.#ToString()", Justification = @"[....]: Assigned to [....]")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.SiteMapNode.#Url", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "type", Target = "System.Web.SiteMapNodeCollection", MessageId = "SiteMap", Justification = @"[....]: Spellings ok.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.SiteMapNodeCollection.#Clear()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.SiteMapNodeCollection.#get_Count()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.SiteMapNodeCollection.#GetEnumerator()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.SiteMapNodeCollection.#GetHierarchicalDataSourceView()", Justification = @"[....]: These are all according to the spec.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.SiteMapNodeCollection.#get_IsFixedSize()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.SiteMapNodeCollection.#get_IsReadOnly()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.SiteMapNodeCollection.#get_IsSynchronized()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.SiteMapNodeCollection.#RemoveAt(System.Int32)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.SiteMapNodeCollection.#get_SyncRoot()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.SiteMapNodeCollection.#System.Collections.ICollection.CopyTo(System.Array,System.Int32)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.SiteMapNodeCollection.#System.Collections.ICollection.get_Count()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.SiteMapNodeCollection.#System.Collections.ICollection.get_IsSynchronized()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.SiteMapNodeCollection.#System.Collections.ICollection.get_SyncRoot()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.SiteMapNodeCollection.#System.Collections.IEnumerable.GetEnumerator()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.SiteMapNodeCollection.#System.Collections.IList.Add(System.Object)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.SiteMapNodeCollection.#System.Collections.IList.Clear()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.SiteMapNodeCollection.#System.Collections.IList.Contains(System.Object)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.SiteMapNodeCollection.#System.Collections.IList.IndexOf(System.Object)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.SiteMapNodeCollection.#System.Collections.IList.Insert(System.Int32,System.Object)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.SiteMapNodeCollection.#System.Collections.IList.get_IsFixedSize()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.SiteMapNodeCollection.#System.Collections.IList.get_IsReadOnly()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.SiteMapNodeCollection.#System.Collections.IList.get_Item(System.Int32)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.SiteMapNodeCollection.#System.Collections.IList.set_Item(System.Int32,System.Object)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.SiteMapNodeCollection.#System.Collections.IList.Remove(System.Object)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.SiteMapNodeCollection.#System.Collections.IList.RemoveAt(System.Int32)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "type", Target = "System.Web.SiteMapProvider", MessageId = "SiteMap", Justification = @"[....]: Spellings ok.")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "member", Target = "System.Web.SiteMapProvider.#SiteMapResolve", MessageId = "SiteMap", Justification = @"[....]: Spellings ok.")]
[module: SuppressMessage("Microsoft.Design", "CA1009:DeclareEventHandlersCorrectly", Scope = "member", Target = "System.Web.SiteMapProvider.#SiteMapResolve", Justification = @"[....]: Each event handler is called separately, the result is not lost.")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "member", Target = "System.Web.SiteMapProvider.#FindSiteMapNode(System.String)", MessageId = "SiteMap", Justification = @"[....]: Spellings ok.")]
[module: SuppressMessage("Microsoft.Design", "CA1054:UriParametersShouldNotBeStrings", Scope = "member", Target = "System.Web.SiteMapProvider.#FindSiteMapNode(System.String)", MessageId = "0#", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "member", Target = "System.Web.SiteMapProvider.#FindSiteMapNode(System.Web.HttpContext)", MessageId = "SiteMap", Justification = @"[....]: Spellings ok.")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "member", Target = "System.Web.SiteMapProvider.#FindSiteMapNodeFromKey(System.String)", MessageId = "SiteMap", Justification = @"[....]: Spellings ok.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.SiteMapProvider.#GetRootNodeCore()", Justification = @"[....]: already excluded, accidental duplication in merge")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.SiteMapProvider.#Initialize(System.String,System.Collections.Specialized.NameValueCollection)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "member", Target = "System.Web.SiteMapProvider.#ResolveSiteMapNode(System.Web.HttpContext)", MessageId = "SiteMap", Justification = @"[....]: Spellings ok.")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "type", Target = "System.Web.SiteMapProviderCollection", MessageId = "SiteMap", Justification = @"[....]: Spellings ok.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.SiteMapProviderCollection.#Add(System.Configuration.Provider.ProviderBase)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "type", Target = "System.Web.SiteMapResolveEventArgs", MessageId = "SiteMap", Justification = @"[....]: Spellings ok.")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "type", Target = "System.Web.SiteMapResolveEventHandler", MessageId = "SiteMap", Justification = @"[....]: Spellings ok.")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.SR.#GetObject(System.String)", Justification = @"[....]: These violations are ok.")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.SR.#get_Resources()", Justification = @"[....]: These violations are ok.")]
[module: SuppressMessage("Microsoft.Performance", "CA1812:AvoidUninstantiatedInternalClasses", Scope = "type", Target = "System.Web.StaticErrorFormatterHelper", Justification = @"[....]: The class contains only constants.")]
[module: SuppressMessage("Microsoft.Performance", "CA1812:AvoidUninstantiatedInternalClasses", Scope = "type", Target = "System.Web.StaticFileHandler", Justification = @"[....]: It's referenced via config.")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.StaticFileHandler.#.ctor()", Justification = @"[....]: The class is referenced via config.")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.StaticFileHandler.#ProcessRequestInternal(System.Web.HttpContext)", Justification = @"[....]: Disregarding this rule because it doesn't make sense for our code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "type", Target = "System.Web.StaticSiteMapProvider", MessageId = "SiteMap", Justification = @"[....]: Spellings ok.")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "member", Target = "System.Web.StaticSiteMapProvider.#BuildSiteMap()", MessageId = "SiteMap", Justification = @"[....]: Spellings ok.")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "member", Target = "System.Web.StaticSiteMapProvider.#FindSiteMapNode(System.String)", MessageId = "SiteMap", Justification = @"[....]: Spellings ok.")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "member", Target = "System.Web.StaticSiteMapProvider.#FindSiteMapNodeFromKey(System.String)", MessageId = "SiteMap", Justification = @"[....]: Spellings ok.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1404:CallGetLastErrorImmediatelyAfterPInvoke", Scope = "member", Target = "System.Web.StringResourceManager.#ReadSafeStringResource(System.Type)", Justification = @"[....]: This looks fine.")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope = "member", Target = "System.Web.TraceContext.#InitRequest()", Justification = @"[....]: general exception catching is OK")]
[module: SuppressMessage("Microsoft.Globalization", "CA1305:SpecifyIFormatProvider", Scope = "member", Target = "System.Web.TraceContext.#InitRequest()", Justification = @"[....]: culture behavior derived from thread")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#AppDomainRestart(System.String)", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Security", "CA2118:ReviewSuppressUnmanagedCodeSecurityUsage", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#AppDomainRestart(System.String)", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#AspCompatIsApartmentComponent(System.Object)", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#AspCompatOnPageStart(System.Object)", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#AspCompatProcessRequest(System.Web.Util.AspCompatCallback,System.Object,System.Boolean,System.Int32)", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Security", "CA2101:SpecifyMarshalingForPInvokeStringArguments", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#AspCompatProcessRequest(System.Web.Util.AspCompatCallback,System.Object,System.Boolean,System.Int32)", Justification = @"[....]: BestFitMapping is already disabled")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#AttachDebugger(System.String,System.String,System.IntPtr)", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#BufferPoolGetBuffer(System.IntPtr)", Justification = @"[....]: fxcop fails to load aspnet_isapi.dll")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#BufferPoolGetPool(System.Int32,System.Int32)", Justification = @"[....]: fxcop fails to load aspnet_isapi.dll")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#ChangeAccessToKeyContainer(System.String,System.String,System.String,System.Int32)", Justification = @"NO_JUSTIFICATION_PROVIDED")]
[module: SuppressMessage("Microsoft.Security", "CA2118:ReviewSuppressUnmanagedCodeSecurityUsage", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#CloseHandle(System.IntPtr)", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#CreateUserToken(System.String,System.String,System.Int32,System.Text.StringBuilder,System.Int32)", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Security", "CA2118:ReviewSuppressUnmanagedCodeSecurityUsage", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#CreateUserToken(System.String,System.String,System.Int32,System.Text.StringBuilder,System.Int32)", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Security", "CA2118:ReviewSuppressUnmanagedCodeSecurityUsage", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#DeleteShadowCache(System.String,System.String)", Justification = @"[....]: The CodeAssemblies are used here in order to compile GlobalAsax type, they are not exposed externally.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#DirMonClose(System.Runtime.InteropServices.HandleRef)", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#DoesKeyContainerExist(System.String,System.String,System.Int32)", Justification = @"NO_JUSTIFICATION_PROVIDED")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#EcbAppendLogParameter(System.IntPtr,System.String)", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Security", "CA2101:SpecifyMarshalingForPInvokeStringArguments", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#EcbAppendLogParameter(System.IntPtr,System.String)", Justification = @"[....]: BestFitMapping is already disabled")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#EcbCallISAPI(System.IntPtr,System.Web.UnsafeNativeMethods+CallISAPIFunc,System.Byte[],System.Int32,System.Byte[],System.Int32)", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#EcbCloseConnection(System.IntPtr)", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#EcbGetAdditionalPostedContent(System.IntPtr,System.Byte[],System.Int32,System.Int32)", Justification = @"[....]: FxCop failure to load aspnet_isapi.dll")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#EcbGetBasics(System.IntPtr,System.Byte[],System.Int32,System.Int32[])", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#EcbGetBasicsContentInfo(System.IntPtr,System.Int32[])", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#EcbGetClientCertificate(System.IntPtr,System.Byte[],System.Int32,System.Int32[],System.Int64[])", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#EcbGetImpersonationToken(System.IntPtr,System.IntPtr)", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#EcbGetPreloadedPostedContent(System.IntPtr,System.Byte[],System.Int32,System.Int32)", Justification = @"[....]: FxCop failure to load aspnet_isapi.dll")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#EcbGetQueryString(System.IntPtr,System.Int32,System.Text.StringBuilder,System.Int32)", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Security", "CA2101:SpecifyMarshalingForPInvokeStringArguments", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#EcbGetQueryString(System.IntPtr,System.Int32,System.Text.StringBuilder,System.Int32)", Justification = @"[....]: BestFitMapping is already disabled")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#EcbGetQueryStringRawBytes(System.IntPtr,System.Byte[],System.Int32)", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#EcbGetServerVariable(System.IntPtr,System.String,System.Byte[],System.Int32)", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Security", "CA2101:SpecifyMarshalingForPInvokeStringArguments", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#EcbGetServerVariable(System.IntPtr,System.String,System.Byte[],System.Int32)", Justification = @"[....]: BestFitMapping is already disabled")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#EcbGetTraceContextId(System.IntPtr,System.Guid&)", Justification = @"[....]: fxcopy should be updated to ignore pinvokes for aspnet_isapi and aspnet_wp")]
[module: SuppressMessage("Microsoft.Security", "CA2118:ReviewSuppressUnmanagedCodeSecurityUsage", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#EcbGetTraceContextId(System.IntPtr,System.Guid&)", Justification = @"[....]: There's a full demand on the ctor of ISAPIRuntime and the object is well-protected so a user should never get an instance, so these should not be a vulnerability.  [....] did the security review.")]
[module: SuppressMessage("Microsoft.Security", "CA2118:ReviewSuppressUnmanagedCodeSecurityUsage", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#EcbGetTraceFlags(System.IntPtr,System.Int32[])", Justification = @"[....]: ok")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#EcbGetUnicodeServerVariable(System.IntPtr,System.String,System.IntPtr,System.Int32)", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Security", "CA2101:SpecifyMarshalingForPInvokeStringArguments", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#EcbGetUnicodeServerVariable(System.IntPtr,System.String,System.IntPtr,System.Int32)", Justification = @"[....]: BestFitMapping is already disabled")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#EcbGetUnicodeServerVariableByIndex(System.IntPtr,System.Int32,System.IntPtr,System.Int32)", Justification = @"[....]: fxcop should be reconfigured")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#EcbGetVersion(System.IntPtr)", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Security", "CA2118:ReviewSuppressUnmanagedCodeSecurityUsage", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#EcbGetVersion(System.IntPtr)", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#EcbGetVirtualPathToken(System.IntPtr,System.IntPtr)", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#EcbIsClientConnected(System.IntPtr)", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#EcbMapUrlToPath(System.IntPtr,System.String,System.Byte[],System.Int32)", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Security", "CA2101:SpecifyMarshalingForPInvokeStringArguments", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#EcbMapUrlToPath(System.IntPtr,System.String,System.Byte[],System.Int32)", Justification = @"[....]: BestFitMapping is already disabled")]
[module: SuppressMessage("Microsoft.Security", "CA2118:ReviewSuppressUnmanagedCodeSecurityUsage", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#FindClose(System.IntPtr)", Justification = @"[....]: Reviewed and exluded in beta2lhsd, porting changes")]
[module: SuppressMessage("Microsoft.Security", "CA2118:ReviewSuppressUnmanagedCodeSecurityUsage", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#FindFirstFile(System.String,System.Web.UnsafeNativeMethods+WIN32_FIND_DATA&)", Justification = @"[....]: Reviewed and exluded in beta2lhsd, porting changes")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#FreeFileSecurityDescriptor(System.IntPtr)", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#GetCredentialFromRegistry(System.String,System.Text.StringBuilder,System.Int32)", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Security", "CA2118:ReviewSuppressUnmanagedCodeSecurityUsage", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#GetCredentialFromRegistry(System.String,System.Text.StringBuilder,System.Int32)", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Security", "CA2118:ReviewSuppressUnmanagedCodeSecurityUsage", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#GetCurrentThread()", Justification = @"[....]: internal impersonation code calling pinvoke methods protected by link demands is ok - all public impersonation APIs are protected")]
[module: SuppressMessage("Microsoft.Security", "CA2118:ReviewSuppressUnmanagedCodeSecurityUsage", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#GetEcb(System.IntPtr)", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Security", "CA2118:ReviewSuppressUnmanagedCodeSecurityUsage", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#GetEtwValues(System.Int32&,System.Int32&)", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Security", "CA2118:ReviewSuppressUnmanagedCodeSecurityUsage", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#GetFileAttributesEx(System.String,System.Int32,System.Web.UnsafeNativeMethods+WIN32_FILE_ATTRIBUTE_DATA&)", Justification = @"[....]: Reviewed, no security issues found.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#GetFileHandleForTransmitFile(System.String)", Justification = @"[....]: I don't understand this rule.")]
[module: SuppressMessage("Microsoft.Security", "CA2118:ReviewSuppressUnmanagedCodeSecurityUsage", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#GetFileSecurity(System.String,System.Int32,System.Byte[],System.Int32,System.Int32&)", Justification = @"[....]: Reviewed for security vulnerabilities, none found.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#GetFileSecurityDescriptor(System.String)", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#GetGroupsForUser(System.IntPtr,System.Text.StringBuilder,System.Int32,System.Text.StringBuilder,System.Int32)", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Security", "CA2118:ReviewSuppressUnmanagedCodeSecurityUsage", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#GetHMACSHA1Hash(System.Byte[],System.Int32,System.Int32,System.Byte[],System.Int32,System.Byte[],System.Int32,System.Byte[],System.Int32,System.Byte[],System.Int32)", Justification = @"[....]: The call-stack is permitted in low trust scenarios")]
[module: SuppressMessage("Microsoft.Security", "CA2118:ReviewSuppressUnmanagedCodeSecurityUsage", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#GetModuleFileName(System.IntPtr,System.Text.StringBuilder,System.Int32)", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Security", "CA2118:ReviewSuppressUnmanagedCodeSecurityUsage", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#GetModuleHandle(System.String)", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Security", "CA2118:ReviewSuppressUnmanagedCodeSecurityUsage", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#GetSHA1Hash(System.Byte[],System.Int32,System.Byte[],System.Int32)", Justification = @"[....]: The call-stack is permitted in low trust scenarios")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#GetW3WPMemoryLimitInKB()", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#InitializeHealthMonitor(System.Int32,System.Int32)", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#InitializeLibrary()", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#InitializeWmiManager()", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#InstrumentedMutexCreate(System.String)", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#InstrumentedMutexDelete(System.Runtime.InteropServices.HandleRef)", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#InstrumentedMutexGetLock(System.Runtime.InteropServices.HandleRef,System.Int32)", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#InstrumentedMutexReleaseLock(System.Runtime.InteropServices.HandleRef)", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#InstrumentedMutexSetState(System.Runtime.InteropServices.HandleRef,System.Int32)", Justification = @"[....]: Called by CompilationMutex")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#InstrumentedMutexSetState(System.Runtime.InteropServices.HandleRef,System.Int32)", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#INVALID_HANDLE_VALUE", Justification = @"[....]: It's not a real handle.  Instead it's a constant for invalid handle value.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#InvalidateKernelCache(System.String)", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#IsAccessToFileAllowed(System.IntPtr,System.IntPtr,System.Int32)", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#IsapiAppHostGetSiteId(System.String,System.Text.StringBuilder,System.Int32)", Justification = @"[....]: The entry point exists, fxcop cannot load ASPNET_ISAPI.DLL.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#IsapiAppHostGetSiteName(System.String,System.Text.StringBuilder,System.Int32)", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#IsapiAppHostGetUncUser(System.String,System.Text.StringBuilder,System.Int32,System.Text.StringBuilder,System.Int32)", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#IsapiAppHostMapPath(System.String,System.String,System.Text.StringBuilder,System.Int32)", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#IsUserInRole(System.IntPtr,System.String,System.Text.StringBuilder,System.Int32)", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#IsValidResource(System.IntPtr,System.IntPtr,System.Int32)", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#LogonUser(System.String,System.String,System.String,System.Int32,System.Int32,System.IntPtr&)", Justification = @"[....]: These violations are ok.")]
[module: SuppressMessage("Microsoft.Security", "CA2118:ReviewSuppressUnmanagedCodeSecurityUsage", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#OpenThreadToken(System.IntPtr,System.Int32,System.Boolean,System.IntPtr&)", Justification = @"[....]: internal impersonation code calling pinvoke methods protected by link demands is ok - all public impersonation APIs are protected")]
[module: SuppressMessage("Microsoft.Security", "CA2101:SpecifyMarshalingForPInvokeStringArguments", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#OpenThreadToken(System.IntPtr,System.Int32,System.Boolean,System.IntPtr&)", Justification = @"[....]: BestFitMapping is already disabled")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#PassportAuthURL(System.IntPtr,System.String,System.Int32,System.Int32,System.String,System.Int32,System.String,System.Int32,System.Int32,System.Text.StringBuilder,System.Int32)", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#PassportAuthURL2(System.IntPtr,System.String,System.Int32,System.Int32,System.String,System.Int32,System.String,System.Int32,System.Int32,System.Text.StringBuilder,System.Int32)", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#PassportCreate(System.String,System.String,System.String,System.String,System.String,System.Text.StringBuilder,System.Text.StringBuilder,System.Int32,System.IntPtr&)", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#PassportCreateHttpRaw(System.String,System.String,System.Int32,System.Text.StringBuilder,System.Int32,System.IntPtr&)", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#PassportCrypt(System.Int32,System.String,System.Text.StringBuilder,System.Int32)", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#PassportCryptIsValid()", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#PassportCryptPut(System.Int32,System.String)", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#PassportDestroy(System.IntPtr)", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#PassportDomainFromMemberName(System.IntPtr,System.String,System.Text.StringBuilder,System.Int32)", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#PassportGetCurrentConfig(System.IntPtr,System.String,System.Object&)", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#PassportGetDomainAttribute(System.IntPtr,System.String,System.Int32,System.String,System.Text.StringBuilder,System.Int32)", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#PassportGetError(System.IntPtr)", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#PassportGetFromNetworkServer(System.IntPtr)", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#PassportGetHasSavedPassword(System.IntPtr)", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#PassportGetLoginChallenge(System.IntPtr,System.String,System.Int32,System.Int32,System.String,System.Int32,System.String,System.Int32,System.Int32,System.Object,System.Text.StringBuilder,System.Int32)", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#PassportGetOption(System.IntPtr,System.String,System.Object&)", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#PassportGetProfile(System.IntPtr,System.String,System.Object&)", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#PassportGetTicketAge(System.IntPtr)", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#PassportGetTimeSinceSignIn(System.IntPtr)", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#PassportHasConsent(System.IntPtr,System.Int32,System.Int32)", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#PassportHasFlag(System.IntPtr,System.Int32)", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#PassportHasProfile(System.IntPtr,System.String)", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#PassportHasTicket(System.IntPtr)", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#PassportHexPUID(System.IntPtr,System.Text.StringBuilder,System.Int32)", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#PassportIsAuthenticated(System.IntPtr,System.Int32,System.Int32,System.Int32)", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#PassportLogoTag(System.IntPtr,System.String,System.Int32,System.Int32,System.String,System.Int32,System.Int32,System.String,System.Int32,System.Int32,System.Text.StringBuilder,System.Int32)", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#PassportLogoTag2(System.IntPtr,System.String,System.Int32,System.Int32,System.String,System.Int32,System.Int32,System.String,System.Int32,System.Int32,System.Text.StringBuilder,System.Int32)", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#PassportLogoutURL(System.IntPtr,System.String,System.String,System.Int32,System.String,System.Int32,System.Text.StringBuilder,System.Int32)", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#PassportSetOption(System.IntPtr,System.String,System.Object)", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#PassportTicket(System.IntPtr,System.String,System.Object&)", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#PassportVersion()", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#PerfCloseAppCounters(System.IntPtr)", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Security", "CA2118:ReviewSuppressUnmanagedCodeSecurityUsage", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#PerfCloseAppCounters(System.IntPtr)", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#PerfDecrementCounter(System.IntPtr,System.Int32)", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Security", "CA2118:ReviewSuppressUnmanagedCodeSecurityUsage", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#PerfDecrementCounter(System.IntPtr,System.Int32)", Justification = @"[....]: Reviewed and exluded in beta2lhsd, porting changes")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#PerfGetCounter(System.IntPtr,System.Int32)", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#PerfIncrementCounter(System.IntPtr,System.Int32)", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Security", "CA2118:ReviewSuppressUnmanagedCodeSecurityUsage", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#PerfIncrementCounter(System.IntPtr,System.Int32)", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#PerfIncrementCounterEx(System.IntPtr,System.Int32,System.Int32)", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Security", "CA2118:ReviewSuppressUnmanagedCodeSecurityUsage", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#PerfIncrementCounterEx(System.IntPtr,System.Int32,System.Int32)", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#PerfOpenGlobalCounters()", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#PerfOpenStateCounters()", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#PerfSetCounter(System.IntPtr,System.Int32,System.Int32)", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Security", "CA2101:SpecifyMarshalingForPInvokeStringArguments", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#PMAppendLogParameter(System.IntPtr,System.String)", Justification = @"[....]: BestFitMapping is already disabled")]
[module: SuppressMessage("Microsoft.Security", "CA2118:ReviewSuppressUnmanagedCodeSecurityUsage", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#PMCallISAPI(System.IntPtr,System.Web.UnsafeNativeMethods+CallISAPIFunc,System.Byte[],System.Int32,System.Byte[],System.Int32)", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Security", "CA2101:SpecifyMarshalingForPInvokeStringArguments", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#PMGetQueryString(System.IntPtr,System.Int32,System.Text.StringBuilder,System.Int32)", Justification = @"[....]: BestFitMapping is already disabled")]
[module: SuppressMessage("Microsoft.Security", "CA2118:ReviewSuppressUnmanagedCodeSecurityUsage", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#PMGetTraceContextId(System.IntPtr,System.Guid&)", Justification = @"[....]: There's a full demand on the ctor of ISAPIRuntime and the object is well-protected so a user should never get an instance, so these should not be a vulnerability.  [....] did the security review.")]
[module: SuppressMessage("Microsoft.Security", "CA2101:SpecifyMarshalingForPInvokeStringArguments", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#PMMapUrlToPath(System.IntPtr,System.String,System.Byte[],System.Int32)", Justification = @"[....]: BestFitMapping is already disabled")]
[module: SuppressMessage("Microsoft.Security", "CA2118:ReviewSuppressUnmanagedCodeSecurityUsage", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#PMTraceRaiseEvent(System.Int32,System.IntPtr,System.String,System.String,System.String,System.String)", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#PostThreadPoolWorkItem(System.Web.Util.WorkItemCallback)", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#RaiseFileMonitoringEventlogEvent(System.String,System.String,System.String,System.Int32)", Justification = @"[....]: bogus warning")]
[module: SuppressMessage("Microsoft.Security", "CA2118:ReviewSuppressUnmanagedCodeSecurityUsage", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#RaiseFileMonitoringEventlogEvent(System.String,System.String,System.String,System.Int32)", Justification = @"[....]: CodeAssemblies are accessed here in order to compile the globalasax type, they are not exposed externally.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#ReportUnhandledException(System.String)", Justification = @"[....]: This is a bug in FxCop")]
[module: SuppressMessage("Microsoft.Security", "CA2118:ReviewSuppressUnmanagedCodeSecurityUsage", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#ReportUnhandledException(System.String)", Justification = @"[....]: There's a full demand on the ctor of ISAPIRuntime and the object is well-protected so a user should never get an instance, so these should not be a vulnerability.  [....] did the security review.")]
[module: SuppressMessage("Microsoft.Security", "CA2118:ReviewSuppressUnmanagedCodeSecurityUsage", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#RevertToSelf()", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#SessionNDCloseConnection(System.Runtime.InteropServices.HandleRef)", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#SessionNDConnectToService(System.String)", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#SessionNDMakeRequest(System.Runtime.InteropServices.HandleRef,System.String,System.Int32,System.Int32,System.Web.UnsafeNativeMethods+StateProtocolVerb,System.String,System.Web.UnsafeNativeMethods+StateProtocolExclusive,System.Int32,System.Int32,System.Int32,System.Byte[],System.Int32,System.Boolean,System.Web.UnsafeNativeMethods+SessionNDMakeRequestResults&)", Justification = @"NO_JUSTIFICATION_PROVIDED")]
[module: SuppressMessage("Microsoft.Security", "CA2101:SpecifyMarshalingForPInvokeStringArguments", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#SessionNDMakeRequest(System.Runtime.InteropServices.HandleRef,System.String,System.Int32,System.Int32,System.Web.UnsafeNativeMethods+StateProtocolVerb,System.String,System.Web.UnsafeNativeMethods+StateProtocolExclusive,System.Int32,System.Int32,System.Int32,System.Byte[],System.Int32,System.Boolean,System.Web.UnsafeNativeMethods+SessionNDMakeRequestResults&)", Justification = @"NO_JUSTIFICATION_PROVIDED")]
[module: SuppressMessage("Microsoft.Security", "CA2118:ReviewSuppressUnmanagedCodeSecurityUsage", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#SetDoneWithSessionCalled(System.IntPtr)", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Security", "CA2118:ReviewSuppressUnmanagedCodeSecurityUsage", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#SetThreadToken(System.IntPtr,System.IntPtr)", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Security", "CA2101:SpecifyMarshalingForPInvokeStringArguments", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#STWNDGetLocalAddress(System.IntPtr,System.Text.StringBuilder)", Justification = @"[....]: BestFitMapping is already disabled")]
[module: SuppressMessage("Microsoft.Security", "CA2101:SpecifyMarshalingForPInvokeStringArguments", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#STWNDGetRemoteAddress(System.IntPtr,System.Text.StringBuilder)", Justification = @"[....]: BestFitMapping is already disabled")]
[module: SuppressMessage("Microsoft.Security", "CA2118:ReviewSuppressUnmanagedCodeSecurityUsage", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#TraceRaiseEventMgdHandler(System.Int32,System.IntPtr,System.String,System.String,System.String,System.String)", Justification = @"[....]: ok")]
[module: SuppressMessage("Microsoft.Security", "CA2118:ReviewSuppressUnmanagedCodeSecurityUsage", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#TraceRaiseEventWithEcb(System.Int32,System.IntPtr,System.String,System.String,System.String,System.String)", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#TransactManagedCallback(System.Web.Util.TransactedExecCallback,System.Int32)", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1400:PInvokeEntryPointsShouldExist", Scope = "member", Target = "System.Web.UnsafeNativeMethods.#UpdateLastActivityTimeForHealthMonitor()", Justification = @"[....]: aspnet_isapi.dll is part of the setup and will be present when system.web.dll is running.  If not, many other things will break too.")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope = "type", Target = "System.Web.UnsafeNativeMethods+SessionNDMakeRequestResults", Justification = @"[....]: These violations are ok.")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope = "member", Target = "System.Web.UnsafeNativeMethods+SessionNDMakeRequestResults.#content", Justification = @"[....]: SessionNDMakeRequestResults.content is a memory pointer used internally between ssdirect.cxx and outofprocstateclientmanager.cs, and we control its lifetime.")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope = "member", Target = "System.Web.UnsafeNativeMethods+SessionNDMakeRequestResults.#socket", Justification = @"[....]: socket is a winsock that's used internally between ssdirect.cxx and outofprocstateclientmanage.cs, and we control its lifetime.")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope = "type", Target = "System.Web.UnsafeNativeMethods+SYSTEM_INFO", Justification = @"[....]: These violations are ok.")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope = "member", Target = "System.Web.UnsafeNativeMethods+SYSTEM_INFO.#dwActiveProcessorMask", Justification = @"[....]: The field is defined because it's part of the win32 struct.  The field itself is not used in managed code.")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope = "member", Target = "System.Web.UnsafeNativeMethods+SYSTEM_INFO.#lpMaximumApplicationAddress", Justification = @"[....]: The field is defined because it's part of the win32 struct.  The field itself is not used in managed code.")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope = "member", Target = "System.Web.UnsafeNativeMethods+SYSTEM_INFO.#lpMinimumApplicationAddress", Justification = @"[....]: The field is defined because it's part of the win32 struct.  The field itself is not used in managed code.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.VirtualPath.#GetDirectory()", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.VirtualPath.#get_IsWithinAppRoot()", Justification = @"[....]: Config should not be protected by a link demand.")]
[module: SuppressMessage("Microsoft.Security", "CA2106:SecureAsserts", Scope = "member", Target = "System.Web.VirtualPath.#LookUpRegForVerCompat()", Justification = @"[....]: ok")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.VirtualPath.#MapPathInternal(System.Boolean)", Justification = @"[....]: Config should not be protected by a link demand.")]
[module: SuppressMessage("Microsoft.Usage", "CA2208:InstantiateArgumentExceptionsCorrectly", Scope = "member", Target = "System.Web.VirtualPath.#System.IComparable.CompareTo(System.Object)", Justification = @"[....]: Deliberate.  Unlikely case, not worth the cost of a localized message.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.VirtualPath.#get_VirtualPathString()", Justification = @"[....]: Config should not be protected by a link demand.")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "type", Target = "System.Web.WebPageTraceListener", MessageId = "WebPage", Justification = @"[....]: Spellings ok.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.WebPageTraceListener.#TraceEvent(System.Diagnostics.TraceEventCache,System.String,System.Diagnostics.TraceEventType,System.Int32,System.String)", Justification = @"[....]: I think this should be firing the OverrideLinkDemands rule instead because TraceListener doesn't have a link demand, but both WebPageTraceListener and HttpContext do.  This is safe.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.WebPageTraceListener.#TraceEvent(System.Diagnostics.TraceEventCache,System.String,System.Diagnostics.TraceEventType,System.Int32,System.String)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.WebPageTraceListener.#TraceEvent(System.Diagnostics.TraceEventCache,System.String,System.Diagnostics.TraceEventType,System.Int32,System.String,System.Object[])", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.WebPageTraceListener.#Write(System.String)", Justification = @"[....]: I think this should be firing the OverrideLinkDemands rule instead because TraceListener doesn't have a link demand, but both WebPageTraceListener and HttpContext do.  This is safe.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.WebPageTraceListener.#Write(System.String)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.WebPageTraceListener.#Write(System.String,System.String)", Justification = @"[....]: I think this should be firing the OverrideLinkDemands rule instead because TraceListener doesn't have a link demand, but both WebPageTraceListener and HttpContext do.  This is safe.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.WebPageTraceListener.#Write(System.String,System.String)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.WebPageTraceListener.#WriteLine(System.String)", Justification = @"[....]: I think this should be firing the OverrideLinkDemands rule instead because TraceListener doesn't have a link demand, but both WebPageTraceListener and HttpContext do.  This is safe.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.WebPageTraceListener.#WriteLine(System.String)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.WebPageTraceListener.#WriteLine(System.String,System.String)", Justification = @"[....]: I think this should be firing the OverrideLinkDemands rule instead because TraceListener doesn't have a link demand, but both WebPageTraceListener and HttpContext do.  This is safe.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.WebPageTraceListener.#WriteLine(System.String,System.String)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope = "member", Target = "System.Web.WebSysDefaultValueAttribute.#get_Value()", Justification = @"[....]: We want to catch everything that can go wrong here")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "type", Target = "System.Web.XmlSiteMapProvider", MessageId = "SiteMap", Justification = @"[....]: Spellings ok.")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.XmlSiteMapProvider.#BuildSiteMap()", Justification = @"[....]: Disregarding this rule because it doesn't make sense for our code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "member", Target = "System.Web.XmlSiteMapProvider.#BuildSiteMap()", MessageId = "SiteMap", Justification = @"[....]: Spellings ok.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.XmlSiteMapProvider.#Dispose()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "member", Target = "System.Web.XmlSiteMapProvider.#FindSiteMapNode(System.String)", MessageId = "SiteMap", Justification = @"[....]: Spellings ok.")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "member", Target = "System.Web.XmlSiteMapProvider.#FindSiteMapNodeFromKey(System.String)", MessageId = "SiteMap", Justification = @"[....]: Spellings ok.")]
[module: SuppressMessage("Microsoft.Globalization", "CA1304:SpecifyCultureInfo", Scope = "member", Target = "System.Web.XmlSiteMapProvider.#ValidateResource(System.String,System.String)", MessageId = "System.Web.HttpContext.GetGlobalResourceObject(System.String,System.String)", Justification = @"[....]: By not specifying the culture, the current culture will be used.")]
[module: SuppressMessage("Microsoft.Performance", "CA1812:AvoidUninstantiatedInternalClasses", Scope = "type", Target = "System.Web.Administration.WebAdminConfigurationHelper", Justification = @"[....]: The type in question is being instantiated through the Hosting api.")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.Administration.WebAdminConfigurationHelper.#CallMembershipProviderMethod(System.String,System.Object[],System.Type[])", Justification = @"[....]: called by the webadmin site thru reflection.")]
[module: SuppressMessage("Microsoft.Security", "CA2107:ReviewDenyAndPermitOnlyUsage", Scope = "member", Target = "System.Web.Administration.WebAdminConfigurationHelper.#CallMembershipProviderMethod(System.String,System.Object[],System.Type[])", Justification = @"[....]: this was revied as needed.")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.Administration.WebAdminConfigurationHelper.#CallRoleProviderMethod(System.String,System.Object[],System.Type[])", Justification = @"[....]: called by the webadmin site thru reflection.")]
[module: SuppressMessage("Microsoft.Security", "CA2107:ReviewDenyAndPermitOnlyUsage", Scope = "member", Target = "System.Web.Administration.WebAdminConfigurationHelper.#CallRoleProviderMethod(System.String,System.Object[],System.Type[])", Justification = @"[....]: this was revied as needed.")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.Administration.WebAdminConfigurationHelper.#GetMembershipProviderProperty(System.String)", Justification = @"[....]: called by the webadmin site thru reflection.")]
[module: SuppressMessage("Microsoft.Security", "CA2107:ReviewDenyAndPermitOnlyUsage", Scope = "member", Target = "System.Web.Administration.WebAdminConfigurationHelper.#GetMembershipProviderProperty(System.String)", Justification = @"[....]: this was revied as needed.")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.Administration.WebAdminConfigurationHelper.#GetVirtualDirectory(System.String)", Justification = @"[....]: called by the webadmin site thru reflection.")]
[module: SuppressMessage("Microsoft.Security", "CA2107:ReviewDenyAndPermitOnlyUsage", Scope = "member", Target = "System.Web.Administration.WebAdminConfigurationHelper.#GetVirtualDirectory(System.String)", Justification = @"[....]: this was revied as needed.")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.Caching.Cache.#.ctor()", Justification = @"[....]: These are protected by a full declarative unmanaged code demand, which covers security on the methods.")]
[module: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "System.Web.Caching.CacheCommon.#AdjustTimer()", MessageId = "System.Threading.Timer.Change(System.Int32,System.Int32)", Justification = @"[....]: we do not care about the return value")]
[module: SuppressMessage("Microsoft.Reliability", "CA2001:AvoidCallingProblematicMethods", Scope = "member", Target = "System.Web.Caching.CacheCommon.#GcCollect()", MessageId = "System.GC.Collect", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Usage", "CA2214:DoNotCallOverridableMethodsInConstructors", Scope = "member", Target = "System.Web.Caching.CacheDependency.#.ctor()", Justification = @"[....]: DependencyDispose won't be called until DERIVED_INIT is set, which is set in Dispose() or FinishInit().")]
[module: SuppressMessage("Microsoft.Usage", "CA2214:DoNotCallOverridableMethodsInConstructors", Scope = "member", Target = "System.Web.Caching.CacheDependency.#.ctor(System.Int32,System.String)", Justification = @"[....]: DependencyDispose won't be called until DERIVED_INIT is set, which is set in Dispose() or FinishInit().")]
[module: SuppressMessage("Microsoft.Usage", "CA2214:DoNotCallOverridableMethodsInConstructors", Scope = "member", Target = "System.Web.Caching.CacheDependency.#.ctor(System.Int32,System.String,System.DateTime)", Justification = @"[....]: DependencyDispose won't be called until DERIVED_INIT is set, which is set in Dispose() or FinishInit().")]
[module: SuppressMessage("Microsoft.Usage", "CA2214:DoNotCallOverridableMethodsInConstructors", Scope = "member", Target = "System.Web.Caching.CacheDependency.#.ctor(System.Int32,System.String[])", Justification = @"[....]: DependencyDispose won't be called until DERIVED_INIT is set, which is set in Dispose() or FinishInit().")]
[module: SuppressMessage("Microsoft.Usage", "CA2214:DoNotCallOverridableMethodsInConstructors", Scope = "member", Target = "System.Web.Caching.CacheDependency.#.ctor(System.Int32,System.String[],System.DateTime)", Justification = @"[....]: DependencyDispose won't be called until DERIVED_INIT is set, which is set in Dispose() or FinishInit().")]
[module: SuppressMessage("Microsoft.Usage", "CA2214:DoNotCallOverridableMethodsInConstructors", Scope = "member", Target = "System.Web.Caching.CacheDependency.#.ctor(System.Int32,System.String[],System.String[])", Justification = @"[....]: DependencyDispose won't be called until DERIVED_INIT is set, which is set in Dispose() or FinishInit().")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Caching.CacheDependency.#.ctor(System.Int32,System.String[],System.String[])", Justification = @"[....]: WebConfigurationManager only invokes the HttpConfigurationSystem when the LinkDemand for AspNetHostingPermission would be satisfied.")]
[module: SuppressMessage("Microsoft.Usage", "CA2214:DoNotCallOverridableMethodsInConstructors", Scope = "member", Target = "System.Web.Caching.CacheDependency.#.ctor(System.Int32,System.String[],System.String[],System.DateTime)", Justification = @"[....]: DependencyDispose won't be called until DERIVED_INIT is set, which is set in Dispose() or FinishInit().")]
[module: SuppressMessage("Microsoft.Usage", "CA2214:DoNotCallOverridableMethodsInConstructors", Scope = "member", Target = "System.Web.Caching.CacheDependency.#.ctor(System.Int32,System.String[],System.String[],System.Web.Caching.CacheDependency)", Justification = @"[....]: DependencyDispose won't be called until DERIVED_INIT is set, which is set in Dispose() or FinishInit().")]
[module: SuppressMessage("Microsoft.Usage", "CA2214:DoNotCallOverridableMethodsInConstructors", Scope = "member", Target = "System.Web.Caching.CacheDependency.#.ctor(System.Int32,System.String[],System.String[],System.Web.Caching.CacheDependency,System.DateTime)", Justification = @"[....]: DependencyDispose won't be called until DERIVED_INIT is set, which is set in Dispose() or FinishInit().")]
[module: SuppressMessage("Microsoft.Usage", "CA2214:DoNotCallOverridableMethodsInConstructors", Scope = "member", Target = "System.Web.Caching.CacheDependency.#.ctor(System.String)", Justification = @"[....]: DependencyDispose won't be called until DERIVED_INIT is set, which is set in Dispose() or FinishInit().")]
[module: SuppressMessage("Microsoft.Usage", "CA2214:DoNotCallOverridableMethodsInConstructors", Scope = "member", Target = "System.Web.Caching.CacheDependency.#.ctor(System.String,System.DateTime)", Justification = @"[....]: DependencyDispose won't be called until DERIVED_INIT is set, which is set in Dispose() or FinishInit().")]
[module: SuppressMessage("Microsoft.Usage", "CA2214:DoNotCallOverridableMethodsInConstructors", Scope = "member", Target = "System.Web.Caching.CacheDependency.#.ctor(System.String[])", Justification = @"[....]: DependencyDispose won't be called until DERIVED_INIT is set, which is set in Dispose() or FinishInit().")]
[module: SuppressMessage("Microsoft.Usage", "CA2214:DoNotCallOverridableMethodsInConstructors", Scope = "member", Target = "System.Web.Caching.CacheDependency.#.ctor(System.String[],System.DateTime)", Justification = @"[....]: DependencyDispose won't be called until DERIVED_INIT is set, which is set in Dispose() or FinishInit().")]
[module: SuppressMessage("Microsoft.Usage", "CA2214:DoNotCallOverridableMethodsInConstructors", Scope = "member", Target = "System.Web.Caching.CacheDependency.#.ctor(System.String[],System.String[])", Justification = @"[....]: DependencyDispose won't be called until DERIVED_INIT is set, which is set in Dispose() or FinishInit().")]
[module: SuppressMessage("Microsoft.Usage", "CA2214:DoNotCallOverridableMethodsInConstructors", Scope = "member", Target = "System.Web.Caching.CacheDependency.#.ctor(System.String[],System.String[],System.DateTime)", Justification = @"[....]: DependencyDispose won't be called until DERIVED_INIT is set, which is set in Dispose() or FinishInit().")]
[module: SuppressMessage("Microsoft.Usage", "CA2214:DoNotCallOverridableMethodsInConstructors", Scope = "member", Target = "System.Web.Caching.CacheDependency.#.ctor(System.String[],System.String[],System.Web.Caching.CacheDependency)", Justification = @"[....]: DependencyDispose won't be called until DERIVED_INIT is set, which is set in Dispose() or FinishInit().")]
[module: SuppressMessage("Microsoft.Usage", "CA2214:DoNotCallOverridableMethodsInConstructors", Scope = "member", Target = "System.Web.Caching.CacheDependency.#.ctor(System.String[],System.String[],System.Web.Caching.CacheDependency,System.DateTime)", Justification = @"[....]: DependencyDispose won't be called until DERIVED_INIT is set, which is set in Dispose() or FinishInit().")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Caching.CacheDependency.#Dispose()", Justification = @"[....]: WebConfigurationManager only invokes the HttpConfigurationSystem when the LinkDemand for AspNetHostingPermission would be satisfied.")]
[module: SuppressMessage("Microsoft.Naming", "CA1706:ShortAcronymsShouldBeUppercase", Scope = "member", Target = "System.Web.Caching.CacheDependency.#GetUniqueID()", Justification = @"[....]: ID approved acronym.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.Caching.CacheDependency.#GetUniqueID()", Justification = @"[....]: Reviewed, and these are appropriate uses of methods.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.Caching.CacheDependency.#NotifyDependencyChanged(System.Object,System.EventArgs)", Justification = @"[....]: Reviewed for dangerous usage.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Caching.CacheDependency.#SetUtcLastModified(System.DateTime)", MessageId = "0#", Justification = @"[....]: Utc is used as an abbreviation throughout the BCL.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.Caching.CacheDependency.#SetUtcLastModified(System.DateTime)", Justification = @"[....]: The naming of this property follows already established pattern for cache policy (i.e. HttpCachePolicy).  Excluding it.")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.Caching.CacheEntry.#CallCacheItemRemovedCallback(System.Web.Caching.CacheItemRemovedCallback,System.Web.Caching.CacheItemRemovedReason)", Justification = @"[....]: Disregarding this rule because it doesn't make sense for our code.")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.Caching.CacheEntry.#DebugDescription(System.String)", Justification = @"[....]: already excluded, accidental duplication in merge")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.Caching.CacheExpires.#DebugDescription(System.String)", Justification = @"[....]: already excluded, accidental duplication in merge")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.Caching.CacheExpires.#DebugValidate()", Justification = @"[....]: already excluded, accidental duplication in merge")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope = "type", Target = "System.Web.Caching.CacheItemRemovedCallback", Justification = @"NO_JUSTIFICATION_PROVIDED")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.Caching.CacheUsage.#DebugDescription(System.String)", Justification = @"[....]: already excluded, accidental duplication in merge")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.Caching.CacheUsage.#DebugValidate()", Justification = @"[....]: already excluded, accidental duplication in merge")]
[module: SuppressMessage("Microsoft.Usage", "CA2213:DisposableFieldsShouldBeDisposed", Scope = "member", Target = "System.Web.Caching.DatabaseNotifState.#Dispose()", Justification = @"[....]: MSDN doc says SqlCommand.Dispose shouldn't be called by user.")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.Caching.ExpiresBucket.#DebugDescription(System.String)", Justification = @"[....]: already excluded, accidental duplication in merge")]
[module: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "System.Web.Caching.ExpiresBucket.#DebugDescription(System.String)", MessageId = "System.String.Concat(System.String,System.String)", Justification = @"[....]: Excluding since it's a debug only false alarm.")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.Caching.ExpiresBucket.#DebugValidate()", Justification = @"[....]: already excluded, accidental duplication in merge")]
[module: SuppressMessage("Microsoft.Portability", "CA1900:ValueTypeFieldsShouldBePortable", Scope = "type", Target = "System.Web.Caching.ExpiresEntry", MessageId = "_cacheEntry", Justification = @"[....]: This is a generated class.")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.Caching.ExpiresEntryRef.#op_Inequality(System.Web.Caching.ExpiresEntryRef,System.Web.Caching.ExpiresEntryRef)", Justification = @"[....]: Class overrides op_Equality (which is used) and can't remove this method, else compiler complaints.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope = "member", Target = "System.Web.Caching.IOutputCacheEntry.#HeaderElements", Justification = @"[....]: by design")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope = "member", Target = "System.Web.Caching.IOutputCacheEntry.#ResponseElements", Justification = @"[....]: by design")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope = "member", Target = "System.Web.Caching.MemoryResponseElement.#Buffer", Justification = @"[....]: by design")]
[module: SuppressMessage("Microsoft.Design", "CA1053:StaticHolderTypesShouldNotHaveConstructors", Scope = "type", Target = "System.Web.Caching.OutputCache", Justification = @"[....]: @!?")]
[module: SuppressMessage("Microsoft.Performance", "CA1812:AvoidUninstantiatedInternalClasses", Scope = "type", Target = "System.Web.Caching.OutputCacheModule", Justification = @"[....]: Internal HttpModule only instantiated through reflection.")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.Caching.OutputCacheModule.#.ctor()", Justification = @"[....]: A false alarm, the object is created via reflection.")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.Caching.OutputCacheModule.#CreateOutputCachedItemKey(System.String,System.Web.HttpVerb,System.Web.HttpContext,System.Web.Caching.CachedVary)", Justification = @"[....]: Disregarding this rule because it doesn't make sense for our code.")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope = "member", Target = "System.Web.Caching.OutputCacheModule.#CreateOutputCachedItemKey(System.String,System.Web.HttpVerb,System.Web.HttpContext,System.Web.Caching.CachedVary)", Justification = @"[....]: We want to catch all exceptions in this case.")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.Caching.OutputCacheModule.#OnEnter(System.Object,System.EventArgs)", Justification = @"[....]: Disregarding this rule because it doesn't make sense for our code.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Caching.OutputCacheProviderCollection.#Add(System.Configuration.Provider.ProviderBase)", Justification = @"[....]: by design")]
[module: SuppressMessage("Microsoft.Usage", "CA2208:InstantiateArgumentExceptionsCorrectly", Scope = "member", Target = "System.Web.Caching.SqlCacheDependency.#ParseSql7OutputCacheDependency(System.String)", Justification = @"[....]: from [....]: We have a higher level caller that catch ArgumentException and re-throw with a better exception message.")]
[module: SuppressMessage("Microsoft.Usage", "CA2208:InstantiateArgumentExceptionsCorrectly", Scope = "member", Target = "System.Web.Caching.SqlCacheDependency.#VerifyAndRemoveEscapeCharacters(System.String)", Justification = @"[....]: from [....]: We have a higher level caller that catch ArgumentException and re-throw with a better exception message.")]
[module: SuppressMessage("Microsoft.Naming", "CA1720:AvoidTypeNamesInParameters", Scope = "member", Target = "System.Web.Caching.SqlCacheDependencyAdmin.#DisableNotifications(System.String)", MessageId = "0#", Justification = @"[....]: connectionString is okay")]
[module: SuppressMessage("Microsoft.Naming", "CA1720:AvoidTypeNamesInParameters", Scope = "member", Target = "System.Web.Caching.SqlCacheDependencyAdmin.#DisableTableForNotifications(System.String,System.String)", MessageId = "0#", Justification = @"[....]: connectionString is okay")]
[module: SuppressMessage("Microsoft.Naming", "CA1720:AvoidTypeNamesInParameters", Scope = "member", Target = "System.Web.Caching.SqlCacheDependencyAdmin.#DisableTableForNotifications(System.String,System.String[])", MessageId = "0#", Justification = @"[....]: connectionString is okay")]
[module: SuppressMessage("Microsoft.Naming", "CA1720:AvoidTypeNamesInParameters", Scope = "member", Target = "System.Web.Caching.SqlCacheDependencyAdmin.#EnableNotifications(System.String)", MessageId = "0#", Justification = @"[....]: connectionString is okay")]
[module: SuppressMessage("Microsoft.Naming", "CA1720:AvoidTypeNamesInParameters", Scope = "member", Target = "System.Web.Caching.SqlCacheDependencyAdmin.#EnableTableForNotifications(System.String,System.String)", MessageId = "0#", Justification = @"[....]: connectionString is okay")]
[module: SuppressMessage("Microsoft.Naming", "CA1720:AvoidTypeNamesInParameters", Scope = "member", Target = "System.Web.Caching.SqlCacheDependencyAdmin.#EnableTableForNotifications(System.String,System.String[])", MessageId = "0#", Justification = @"[....]: connectionString is okay")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.Caching.SqlCacheDependencyAdmin.#GetEnabledTables(System.String)", Justification = @"[....]: Disregarding this rule because it doesn't make sense for our code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1720:AvoidTypeNamesInParameters", Scope = "member", Target = "System.Web.Caching.SqlCacheDependencyAdmin.#GetTablesEnabledForNotifications(System.String)", MessageId = "0#", Justification = @"[....]: connectionString is okay")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.Caching.SqlCacheDependencyAdmin.#SetupNotifications(System.Int32,System.String,System.String)", Justification = @"[....]: Disregarding this rule because it doesn't make sense for our code.")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.Caching.SqlCacheDependencyManager.#PollDatabaseForChanges(System.Web.Caching.DatabaseNotifState,System.Boolean)", Justification = @"[....]: Disregarding this rule because it doesn't make sense for our code.")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.Caching.UsageBucket.#DebugDescription(System.String)", Justification = @"[....]: already excluded, accidental duplication in merge")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.Caching.UsageBucket.#DebugValidate()", Justification = @"[....]: already excluded, accidental duplication in merge")]
[module: SuppressMessage("Microsoft.Portability", "CA1900:ValueTypeFieldsShouldBePortable", Scope = "type", Target = "System.Web.Caching.UsageEntry", MessageId = "_cacheEntry", Justification = @"[....]: This is a generated class.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Compilation.ApplicationBrowserCapabilitiesBuildProvider.#.ctor()", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Compilation.ApplicationBrowserCapabilitiesBuildProvider.#AddFile(System.String)", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Compilation.ApplicationBrowserCapabilitiesCodeGenerator.#.ctor(System.Web.Compilation.BuildProvider)", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.Compilation.AssemblyBuilder.#AddBuildProvider(System.Web.Compilation.BuildProvider)", Justification = @"[....]: It's fine in this case not to catch non Exception objects")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.Web.Compilation.AssemblyResolver.#CheckOutOfRangeDependencies(System.String,Microsoft.Build.Framework.ITaskItem)", Justification = @"[....]: Calling this non-aptca method here does not seem to cause security vulnerabilities.")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.Web.Compilation.AssemblyResolver.#GetPathToReferenceAssemblies(Microsoft.Build.Utilities.FrameworkName)", Justification = @"[....]: Calling this non-aptca method here does not seem to cause security vulnerabilities.")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.Web.Compilation.AssemblyResolver.#ResolveAssembly(System.String,System.Collections.Generic.IList`1<System.String>,System.Collections.Generic.IList`1<System.String>)", Justification = @"[....]: Calling this non-aptca method here does not seem to cause security vulnerabilities.")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.Compilation.BaseResourcesBuildProvider.#.ctor()", Justification = @"[....]: Internal type instantiated by config.")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.Web.Compilation.BaseResourcesBuildProvider.#GenerateStronglyTypedClass(System.Web.Compilation.AssemblyBuilder,System.Resources.IResourceReader)", Justification = @"[....]: Should be fine to call StronglyTypedResourceBuilder here.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Compilation.BrowserCapabilitiesCompiler.#GetBrowserCapabilitiesType()", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Security", "CA2106:SecureAsserts", Scope = "member", Target = "System.Web.Compilation.BrowserCapabilitiesCompiler.#GetBrowserCapabilitiesType()", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.Compilation.BuildManager.#EnsureTopLevelFilesCompiled()", Justification = @"[....]: It's fine in this case not to catch non Exception objects")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Compilation.BuildManager.#GetType(System.String,System.Boolean,System.Boolean)", Justification = @"[....]: No way to pass arbitrary types.")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.Compilation.BuildManager.#InitializeBuildManager()", Justification = @"[....]: Disregarding this rule because it doesn't make sense for our code.")]
[module: SuppressMessage("Microsoft.Globalization", "CA1303:DoNotPassLiteralsAsLocalizedParameters", Scope = "member", Target = "System.Web.Compilation.BuildManager.#OnWebHashFileChange(System.Object,System.Web.FileChangeEvent)", MessageId = "System.Web.HttpRuntime.ShutdownAppDomain(System.Web.ApplicationShutdownReason,System.String)", Justification = @"[....]: This is for debug trace message only, does not need to be localized.")]
[module: SuppressMessage("Microsoft.Performance", "CA1812:AvoidUninstantiatedInternalClasses", Scope = "type", Target = "System.Web.Compilation.BuildManagerHost", Justification = @"[....]: Created via appManager.CreateObject")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.Compilation.BuildManagerHost.#.ctor()", Justification = @"[....]: Created by CBM")]
[module: SuppressMessage("Microsoft.Reliability", "CA2001:AvoidCallingProblematicMethods", Scope = "member", Target = "System.Web.Compilation.BuildManagerHost.#ResolveAssembly(System.Object,System.ResolveEventArgs)", MessageId = "System.Reflection.Assembly.LoadFrom", Justification = @"[....]: By-design.")]
[module: SuppressMessage("Microsoft.Globalization", "CA1303:DoNotPassLiteralsAsLocalizedParameters", Scope = "member", Target = "System.Web.Compilation.BuildManagerHost.#UnloadAppDomain()", MessageId = "System.Web.HttpRuntime.ShutdownAppDomain(System.Web.ApplicationShutdownReason,System.String)", Justification = @"[....]: Internal trace only message doesn't have to be localized.")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope = "type", Target = "System.Web.Compilation.BuildManagerHostUnloadEventHandler", Justification = @"[....]: No unmanaged resource allocated")]
[module: SuppressMessage("Microsoft.Design", "CA1021:AvoidOutParameters", Scope = "member", Target = "System.Web.Compilation.BuildProvider.#GetCodeCompileUnit(System.Collections.IDictionary&)", MessageId = "0#", Justification = @"[....]: ok")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Compilation.BuildProvider.#GetCodeCompileUnit(System.Collections.IDictionary&)", MessageId = "Pragmas", Justification = @"[....]: ok")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.Compilation.BuildProvider.#GetDefaultCompilerType()", Justification = @"NO_JUSTIFICATION_PROVIDED")]
[module: SuppressMessage("Microsoft.Naming", "CA1714:FlagsEnumsShouldHavePluralNames", Scope = "type", Target = "System.Web.Compilation.FolderLevelBuildProviderAppliesTo", Justification = @"[....]: Following existing BuildProviderAppliesTo naming convention.")]
[module: SuppressMessage("Microsoft.Naming", "CA1714:FlagsEnumsShouldHavePluralNames", Scope = "type", Target = "System.Web.Compilation.BuildProviderAppliesTo", Justification = @"[....]: Already existed in config namespace")]
[module: SuppressMessage("Microsoft.Design", "CA1008:EnumsShouldHaveZeroValue", Scope = "type", Target = "System.Web.Compilation.BuildProviderResultFlags", Justification = @"[....]: Rule errors.")]
[module: SuppressMessage("Microsoft.Naming", "CA1711:IdentifiersShouldNotHaveIncorrectSuffix", Scope = "type", Target = "System.Web.Compilation.BuildProviderResultFlags", Justification = @"[....]: Rule errors.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Compilation.BuildProvidersCompiler.#.ctor(System.Web.VirtualPath,System.Boolean,System.String)", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Compilation.BuildProvidersCompiler.#PerformBuild()", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Compilation.BuildProvidersCompiler.#ProcessBuildProviders()", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Usage", "CA2214:DoNotCallOverridableMethodsInConstructors", Scope = "member", Target = "System.Web.Compilation.BuildResultMainCodeAssembly.#.ctor(System.Reflection.Assembly)", Justification = @"[....]: Fine in this case.")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.Compilation.ClientBuildManager.#CreateHost()", Justification = @"[....]: It's fine in this case not to catch non Exception objects")]
[module: SuppressMessage("Microsoft.Design", "CA1021:AvoidOutParameters", Scope = "member", Target = "System.Web.Compilation.ClientBuildManager.#GenerateCode(System.String,System.String,System.Collections.IDictionary&)", MessageId = "2#", Justification = @"[....]: New api consistent with other existing naming pattern.")]
[module: SuppressMessage("Microsoft.Naming", "CA1720:AvoidTypeNamesInParameters", Scope = "member", Target = "System.Web.Compilation.ClientBuildManager.#GenerateCode(System.String,System.String,System.Collections.IDictionary&)", MessageId = "1#", Justification = @"[....]: New api consistent with other existing naming pattern.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Compilation.ClientBuildManager.#GenerateCode(System.String,System.String,System.Collections.IDictionary&)", MessageId = "Pragmas", Justification = @"[....]: New api consistent with other existing naming pattern.")]
[module: SuppressMessage("Microsoft.Design", "CA1021:AvoidOutParameters", Scope = "member", Target = "System.Web.Compilation.ClientBuildManager.#GenerateCodeCompileUnit(System.String,System.String,System.Type&,System.CodeDom.Compiler.CompilerParameters&,System.Collections.IDictionary&)", MessageId = "2#", Justification = @"[....]: These methods are fine, used by ClientBuildManager")]
[module: SuppressMessage("Microsoft.Design", "CA1021:AvoidOutParameters", Scope = "member", Target = "System.Web.Compilation.ClientBuildManager.#GenerateCodeCompileUnit(System.String,System.String,System.Type&,System.CodeDom.Compiler.CompilerParameters&,System.Collections.IDictionary&)", MessageId = "3#", Justification = @"[....]: These methods are fine, used by ClientBuildManager")]
[module: SuppressMessage("Microsoft.Design", "CA1021:AvoidOutParameters", Scope = "member", Target = "System.Web.Compilation.ClientBuildManager.#GenerateCodeCompileUnit(System.String,System.String,System.Type&,System.CodeDom.Compiler.CompilerParameters&,System.Collections.IDictionary&)", MessageId = "4#", Justification = @"[....]: These methods are fine, used by ClientBuildManager")]
[module: SuppressMessage("Microsoft.Naming", "CA1720:AvoidTypeNamesInParameters", Scope = "member", Target = "System.Web.Compilation.ClientBuildManager.#GenerateCodeCompileUnit(System.String,System.String,System.Type&,System.CodeDom.Compiler.CompilerParameters&,System.Collections.IDictionary&)", MessageId = "1#", Justification = @"[....]: Type names are fine.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Compilation.ClientBuildManager.#GenerateCodeCompileUnit(System.String,System.String,System.Type&,System.CodeDom.Compiler.CompilerParameters&,System.Collections.IDictionary&)", MessageId = "4#", Justification = @"[....]: Param names are fine.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Compilation.ClientBuildManager.#GenerateCodeCompileUnit(System.String,System.String,System.Type&,System.CodeDom.Compiler.CompilerParameters&,System.Collections.IDictionary&)", MessageId = "Pragmas", Justification = @"[....]: Spellings ok")]
[module: SuppressMessage("Microsoft.Design", "CA1021:AvoidOutParameters", Scope = "member", Target = "System.Web.Compilation.ClientBuildManager.#GenerateCodeCompileUnit(System.String,System.Type&,System.CodeDom.Compiler.CompilerParameters&,System.Collections.IDictionary&)", MessageId = "1#", Justification = @"[....]: We decided that using an out param was ok in the CBM.")]
[module: SuppressMessage("Microsoft.Design", "CA1021:AvoidOutParameters", Scope = "member", Target = "System.Web.Compilation.ClientBuildManager.#GenerateCodeCompileUnit(System.String,System.Type&,System.CodeDom.Compiler.CompilerParameters&,System.Collections.IDictionary&)", MessageId = "2#", Justification = @"[....]: We decided that using an out param was ok in the CBM.")]
[module: SuppressMessage("Microsoft.Design", "CA1021:AvoidOutParameters", Scope = "member", Target = "System.Web.Compilation.ClientBuildManager.#GenerateCodeCompileUnit(System.String,System.Type&,System.CodeDom.Compiler.CompilerParameters&,System.Collections.IDictionary&)", MessageId = "3#", Justification = @"[....]: We decided that using an out param was ok in the CBM.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Compilation.ClientBuildManager.#GenerateCodeCompileUnit(System.String,System.Type&,System.CodeDom.Compiler.CompilerParameters&,System.Collections.IDictionary&)", MessageId = "3#", Justification = @"[....]: The name is fine")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Compilation.ClientBuildManager.#GenerateCodeCompileUnit(System.String,System.Type&,System.CodeDom.Compiler.CompilerParameters&,System.Collections.IDictionary&)", MessageId = "Pragmas", Justification = @"[....]: Spellings ok")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.Compilation.ClientBuildManager.#GetBrowserDefinitions()", Justification = @"[....]: An expensive call should be a method.")]
[module: SuppressMessage("Microsoft.Design", "CA1021:AvoidOutParameters", Scope = "member", Target = "System.Web.Compilation.ClientBuildManager.#GetCodeDirectoryInformation(System.String,System.Type&,System.CodeDom.Compiler.CompilerParameters&,System.String&)", MessageId = "1#", Justification = @"[....]: We decided that using an out param was ok in the CBM.")]
[module: SuppressMessage("Microsoft.Design", "CA1021:AvoidOutParameters", Scope = "member", Target = "System.Web.Compilation.ClientBuildManager.#GetCodeDirectoryInformation(System.String,System.Type&,System.CodeDom.Compiler.CompilerParameters&,System.String&)", MessageId = "2#", Justification = @"[....]: We decided that using an out param was ok in the CBM.")]
[module: SuppressMessage("Microsoft.Design", "CA1021:AvoidOutParameters", Scope = "member", Target = "System.Web.Compilation.ClientBuildManager.#GetCodeDirectoryInformation(System.String,System.Type&,System.CodeDom.Compiler.CompilerParameters&,System.String&)", MessageId = "3#", Justification = @"[....]: Assigned to [....]")]
[module: SuppressMessage("Microsoft.Reliability", "CA2001:AvoidCallingProblematicMethods", Scope = "member", Target = "System.Web.Compilation.ClientBuildManager.#GetCompiledType(System.String)", MessageId = "System.Reflection.Assembly.LoadFrom", Justification = @"[....]: By-design.")]
[module: SuppressMessage("Microsoft.Design", "CA1021:AvoidOutParameters", Scope = "member", Target = "System.Web.Compilation.ClientBuildManager.#GetCompilerParameters(System.String,System.Type&,System.CodeDom.Compiler.CompilerParameters&)", MessageId = "1#", Justification = @"[....]: We decided that using an out param was ok in the CBM.")]
[module: SuppressMessage("Microsoft.Design", "CA1021:AvoidOutParameters", Scope = "member", Target = "System.Web.Compilation.ClientBuildManager.#GetCompilerParameters(System.String,System.Type&,System.CodeDom.Compiler.CompilerParameters&)", MessageId = "2#", Justification = @"[....]: We decided that using an out param was ok in the CBM.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Compilation.ClientBuildManager.#PrecompileApplication()", Justification = @"[....]: 'Precompile' sounds like a word to me!")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Compilation.ClientBuildManager.#PrecompileApplication(System.Web.Compilation.ClientBuildManagerCallback)", MessageId = "Precompile", Justification = @"NO_JUSTIFICATION_PROVIDED")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Compilation.ClientBuildManager.#PrecompileApplication(System.Web.Compilation.ClientBuildManagerCallback,System.Boolean)", MessageId = "Precompile", Justification = @"[....]: Same namingconvention as other PrecompileApplication methods")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Compilation.ClientBuildManagerParameter.#PrecompilationFlags", MessageId = "Precompilation", Justification = @"[....]: Apllings ok.")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope = "member", Target = "System.Web.Compilation.CompilationMutex.#_mutexHandle", Justification = @"[....]: I think IntPtr is fine here.")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.Compilation.CompilationMutex.#get_MutexDebugName()", Justification = @"[....]: already excluded, accidental duplication in merge")]
[module: SuppressMessage("Microsoft.Naming", "CA1720:AvoidTypeNamesInParameters", Scope = "member", Target = "System.Web.Compilation.ConnectionStringsExpressionBuilder.#GetConnectionString(System.String)", MessageId = "0#", Justification = @"[....]: This is really the correct name for this")]
[module: SuppressMessage("Microsoft.Naming", "CA1720:AvoidTypeNamesInParameters", Scope = "member", Target = "System.Web.Compilation.ConnectionStringsExpressionBuilder.#GetConnectionStringProviderName(System.String)", MessageId = "0#", Justification = @"[....]: This is really the correct name for this")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Compilation.DesignTimeResourceProviderFactoryAttribute.#IsDefaultAttribute()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Globalization", "CA1303:DoNotPassLiteralsAsLocalizedParameters", Scope = "member", Target = "System.Web.Compilation.DiskBuildResultCache.#RemoveAssembly(System.IO.FileInfo)", MessageId = "System.Web.HttpRuntime.ShutdownAppDomain(System.Web.ApplicationShutdownReason,System.String)", Justification = @"[....]: Literal for internal trace only")]
[module: SuppressMessage("Microsoft.Globalization", "CA1303:DoNotPassLiteralsAsLocalizedParameters", Scope = "member", Target = "System.Web.Compilation.DiskBuildResultCache.#RemoveAssemblyAndRelatedFiles(System.String)", MessageId = "System.Web.HttpRuntime.ShutdownAppDomain(System.Web.ApplicationShutdownReason,System.String)", Justification = @"[....]: Used for internal trace only.")]
[module: SuppressMessage("Microsoft.Globalization", "CA1303:DoNotPassLiteralsAsLocalizedParameters", Scope = "member", Target = "System.Web.Compilation.DiskBuildResultCache.#ShutdownCallBack(System.Object)", MessageId = "System.Web.HttpRuntime.ShutdownAppDomain(System.Web.ApplicationShutdownReason,System.String)", Justification = @"[....]: This string is internal only, and does not need to be localized")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.Web.Compilation.ExpressionBuilder.#GetExpressionBuilder(System.String,System.Web.VirtualPath,System.ComponentModel.Design.IDesignerHost)", Justification = @"[....]: Was already excluded before, but reappeared due to signature change.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Compilation.ExpressionEditorAttribute.#get_EditorTypeName()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Compilation.ExpressionEditorAttribute.#Equals(System.Object)", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Compilation.ExpressionEditorAttribute.#GetHashCode()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Compilation.ExpressionPrefixAttribute.#get_ExpressionPrefix()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.Compilation.ForceCopyBuildProvider.#.ctor()", Justification = @"[....]: Used from config.")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "type", Target = "System.Web.Compilation.IAssemblyPostProcessor", MessageId = "PostProcessor", Justification = @"[....]: Spellings ok.")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.Compilation.IgnoreFileBuildProvider.#.ctor()", Justification = @"[....]: It's used from config.")]
[module: SuppressMessage("Microsoft.Design", "CA1051:DoNotDeclareVisibleInstanceFields", Scope = "member", Target = "System.Web.Compilation.ImplicitResourceKey.#Filter", Justification = @"[....]: These were previously excluded but the class changed.")]
[module: SuppressMessage("Microsoft.Design", "CA1051:DoNotDeclareVisibleInstanceFields", Scope = "member", Target = "System.Web.Compilation.ImplicitResourceKey.#KeyPrefix", Justification = @"[....]: These were previously excluded but the class changed.")]
[module: SuppressMessage("Microsoft.Design", "CA1051:DoNotDeclareVisibleInstanceFields", Scope = "member", Target = "System.Web.Compilation.ImplicitResourceKey.#Property", Justification = @"[....]: These were previously excluded but the class changed.")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.Compilation.InstantiateObject.#.ctor(System.Object,System.IntPtr)", Justification = @"[....]: This ctor is called through Delegate.CreateDelegate.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Compilation.IResourceProvider.#GetObject(System.String,System.Globalization.CultureInfo)", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Performance", "CA1812:AvoidUninstantiatedInternalClasses", Scope = "type", Target = "System.Web.Compilation.MasterPageBuildProvider", Justification = @"[....]: This type is late bound instantiated during parse time.")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.Compilation.MasterPageBuildProvider.#.ctor()", Justification = @"[....]: Instantiated from config.")]
[module: SuppressMessage("Microsoft.Globalization", "CA1303:DoNotPassLiteralsAsLocalizedParameters", Scope = "member", Target = "System.Web.Compilation.MemoryBuildResultCache.#OnCacheItemRemoved(System.String,System.Object,System.Web.Caching.CacheItemRemovedReason)", MessageId = "System.Web.HttpRuntime.SetShutdownReason(System.Web.ApplicationShutdownReason,System.String)", Justification = @"[....]: This is only used internally.")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.Web.Compilation.MultiTargetingUtil.#CreateFrameworkName(System.String)", Justification = @"[....]: Calling this non-aptca method here does not seem to cause security vulnerabilities.")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.Web.Compilation.MultiTargetingUtil.#FrameworkNamesAreEqual(Microsoft.Build.Utilities.FrameworkName,Microsoft.Build.Utilities.FrameworkName)", Justification = @"[....]: Calling this non-aptca method here does not seem to cause security vulnerabilities.")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.Web.Compilation.MultiTargetingUtil.#GetLatestCompilerDirectoryPath()", Justification = @"[....]: Calling this non-aptca method here does not seem to cause security vulnerabilities.")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.Web.Compilation.MultiTargetingUtil.#InitializeTargetFrameworkName()", Justification = @"[....]: Calling this non-aptca method here does not seem to cause security vulnerabilities.")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.Web.Compilation.MultiTargetingUtil.#ValidateTargetFrameworkMoniker(System.String)", Justification = @"[....]: Calling this non-aptca method here does not seem to cause security vulnerabilities.")]
[module: SuppressMessage("Microsoft.Performance", "CA1812:AvoidUninstantiatedInternalClasses", Scope = "type", Target = "System.Web.Compilation.PageBuildProvider", Justification = @"[....]: It's referenced via config.")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.Compilation.PageBuildProvider.#.ctor()", Justification = @"[....]: Instantiated from config.")]
[module: SuppressMessage("Microsoft.Design", "CA1008:EnumsShouldHaveZeroValue", Scope = "type", Target = "System.Web.Compilation.PrecompilationFlags", Justification = @"[....]: Rule errors.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "type", Target = "System.Web.Compilation.PrecompilationFlags", MessageId = "Precompilation", Justification = @"[....]: Apllings ok.")]
[module: SuppressMessage("Microsoft.Naming", "CA1711:IdentifiersShouldNotHaveIncorrectSuffix", Scope = "type", Target = "System.Web.Compilation.PrecompilationFlags", Justification = @"[....]: Rule errors.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Compilation.ResourceExpressionBuilder.#ParseExpression(System.String)", Justification = @"[....]: Designer only code path")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Compilation.ResourceExpressionFields.#get_ClassKey()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Compilation.ResourceExpressionFields.#get_ResourceKey()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Performance", "CA1812:AvoidUninstantiatedInternalClasses", Scope = "type", Target = "System.Web.Compilation.ResourcesBuildProvider", Justification = @"[....]: It's referenced via config.")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.Compilation.ResourcesBuildProvider.#.ctor()", Justification = @"[....]: Instantiated from config.")]
[module: SuppressMessage("Microsoft.Performance", "CA1812:AvoidUninstantiatedInternalClasses", Scope = "type", Target = "System.Web.Compilation.ResXBuildProvider", Justification = @"[....]: It's referenced via config.")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.Compilation.ResXBuildProvider.#.ctor()", Justification = @"[....]: Instantiated from config.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Compilation.RouteUrlExpressionBuilder.#TryParseRouteExpression(System.String,System.Web.Routing.RouteValueDictionary,System.String&)", MessageId = "Params", Justification = @"[....]: by design")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.Compilation.SimpleHandlerBuildProvider.#.ctor()", Justification = @"[....]: Instantiated from config.")]
[module: SuppressMessage("Microsoft.Performance", "CA1812:AvoidUninstantiatedInternalClasses", Scope = "type", Target = "System.Web.Compilation.SourceFileBuildProvider", Justification = @"[....]: It's referenced via config.")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.Compilation.SourceFileBuildProvider.#.ctor()", Justification = @"[....]: Instantiated from config.")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.Compilation.TemplateControlBuildProvider.#.ctor()", Justification = @"[....]: Instantiated from config.")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.Compilation.UserControlBuildProvider.#.ctor()", Justification = @"[....]: Instantiated from config.")]
[module: SuppressMessage("Microsoft.Performance", "CA1812:AvoidUninstantiatedInternalClasses", Scope = "type", Target = "System.Web.Compilation.WebHandlerBuildProvider", Justification = @"[....]: It's referenced via config.")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.Compilation.WebHandlerBuildProvider.#.ctor()", Justification = @"[....]: Instantiated from config.")]
[module: SuppressMessage("Microsoft.Performance", "CA1807:AvoidUnnecessaryStringCreation", Scope = "member", Target = "System.Web.Compilation.WebReferencesBuildProvider.#GenerateCode(System.Web.Compilation.AssemblyBuilder)", MessageId = "local9", Justification = @"[....]: No big deal.  Not worth changing.")]
[module: SuppressMessage("Microsoft.Performance", "CA1812:AvoidUninstantiatedInternalClasses", Scope = "type", Target = "System.Web.Compilation.WebServiceBuildProvider", Justification = @"[....]: It's referenced via config.")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.Compilation.WebServiceBuildProvider.#.ctor()", Justification = @"[....]: Instantiated from config.")]
[module: SuppressMessage("Microsoft.Performance", "CA1812:AvoidUninstantiatedInternalClasses", Scope = "type", Target = "System.Web.Compilation.WsdlBuildProvider", Justification = @"[....]: It's referenced via config.")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.Compilation.WsdlBuildProvider.#.ctor()", Justification = @"[....]: Used by buildmanager")]
[module: SuppressMessage("Microsoft.Performance", "CA1812:AvoidUninstantiatedInternalClasses", Scope = "type", Target = "System.Web.Compilation.XsdBuildProvider", Justification = @"[....]: It's referenced via config.")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.Compilation.XsdBuildProvider.#.ctor()", Justification = @"[....]: Instantiated from config.")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.Web.Compilation.XsdBuildProvider.#GenerateCode(System.Web.Compilation.AssemblyBuilder)", Justification = @"[....]: Should be fine to call the TypedDataSetGenerator here.")]
[module: SuppressMessage("Microsoft.Design", "CA1035:ICollectionImplementationsHaveStronglyTypedMembers", Scope = "type", Target = "System.Web.Configuration.AdapterDictionary", Justification = @"[....]: ICollection interface acquired through inheritance, a string strongly typed CopyTo is basically worthless for this simply convenience type.")]
[module: SuppressMessage("Microsoft.Naming", "CA1705:LongAcronymsShouldBePascalCased", Scope = "member", Target = "System.Web.Configuration.AnonymousIdentificationSection.#CookieRequireSSL", Justification = @"[....]: These are legacy public methods which would cause a break in customer's code if changed.")]
[module: SuppressMessage("Microsoft.Naming", "CA1705:LongAcronymsShouldBePascalCased", Scope = "member", Target = "System.Web.Configuration.AnonymousIdentificationSection.#get_CookieRequireSSL()", Justification = @"[....]: These are legacy public methods which would cause a break in customer's code if changed.")]
[module: SuppressMessage("Microsoft.Naming", "CA1705:LongAcronymsShouldBePascalCased", Scope = "member", Target = "System.Web.Configuration.AnonymousIdentificationSection.#set_CookieRequireSSL(System.Boolean)", Justification = @"[....]: These are legacy public methods which would cause a break in customer's code if changed.")]
[module: SuppressMessage("Microsoft.Design", "CA1035:ICollectionImplementationsHaveStronglyTypedMembers", Scope = "type", Target = "System.Web.Configuration.AssemblyCollection", Justification = @"[....]: The base type is used to determine the strong type.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.AssemblyCollection.#CreateNewElement()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.AssemblyCollection.#GetElementKey(System.Configuration.ConfigurationElement)", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.AssemblyInfo.#get_Properties()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.AuthorizationRule.#Equals(System.Object)", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Configuration.AuthorizationRule.#ExpandName(System.String)", Justification = @"[....]: Config should not be protected by link demands.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.AuthorizationRule.#GetHashCode()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.AuthorizationRule.#IsModified()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2107:ReviewDenyAndPermitOnlyUsage", Scope = "member", Target = "System.Web.Configuration.AuthorizationRule.#IsTheUserInAnyRole(System.Collections.Specialized.StringCollection,System.Security.Principal.IPrincipal)", Justification = @"[....]: See bug 428265 for detail.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.AuthorizationRule.#PostDeserialize()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.AuthorizationRule.#PreSerialize(System.Xml.XmlWriter)", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.AuthorizationRule.#get_Properties()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.AuthorizationRule.#Reset(System.Configuration.ConfigurationElement)", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.AuthorizationRule.#ResetModified()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.AuthorizationRule.#SerializeElement(System.Xml.XmlWriter,System.Boolean)", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.AuthorizationRule.#SetReadOnly()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.AuthorizationRule.#Unmerge(System.Configuration.ConfigurationElement,System.Configuration.ConfigurationElement,System.Configuration.ConfigurationSaveMode)", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Design", "CA1035:ICollectionImplementationsHaveStronglyTypedMembers", Scope = "type", Target = "System.Web.Configuration.AuthorizationRuleCollection", Justification = @"[....]: The base type is used to determine the strong type.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.AuthorizationRuleCollection.#get_CollectionType()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.AuthorizationRuleCollection.#CreateNewElement()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.AuthorizationRuleCollection.#CreateNewElement(System.String)", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.AuthorizationRuleCollection.#get_ElementName()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.AuthorizationRuleCollection.#GetElementKey(System.Configuration.ConfigurationElement)", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.AuthorizationRuleCollection.#IsElementName(System.String)", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesCodeGenerator.#Create()", Justification = @"[....]: The Methods require strong CAS permission than the type, therefore this is a false-positive.")]
[module: SuppressMessage("Microsoft.Performance", "CA1820:TestForEmptyStringsUsingStringLength", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesCodeGenerator.#GenerateProcessMethod(System.Web.Configuration.BrowserDefinition,System.CodeDom.CodeTypeDeclaration,System.String)", Justification = @"[....]: rule in error?  String.Empty is used, but for assignment only")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesCodeGenerator.#RestartW3SVCIfNecessary()", Justification = @"[....]: This method demands Unmanaged access, therefore should be secured.")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesCodeGenerator.#RestartW3SVCIfNecessary()", Justification = @"[....]: Disregarding this rule because it doesn't make sense for our code.")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesCodeGenerator.#Uninstall()", Justification = @"[....]: The Methods require strong CAS permission than the type, therefore this is a false-positive.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#AlavProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Alav", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#AlavProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#AlazProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Alaz", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#AlazProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#AumicProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Aumic", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#AumicProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: device identifiers")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#AuspalmProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Auspalm", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#AuspalmProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#AvantgoProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Avantgo", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#AvantgoProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#BenqathenaProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Benqathena", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#BenqathenaProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Benqathena", Justification = @"[....]: Generated browsercap methods.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#CasiopeiaProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Casiopeia", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#CasiopeiaProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#CharsetProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Charset", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#CharsetProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#DefaultXhtmlmpProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Xhtmlmp", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#DocomodefaultrenderingsizeProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Docomodefaultrenderingsize", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#DocomodefaultrenderingsizeProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: This is the correct name.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#DocomoProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Docomo", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#DocomoProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#DocomorenderingsizeProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Docomorenderingsize", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#DocomorenderingsizeProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Docomorenderingsize", Justification = @"[....]: browsercap generated methods.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#EudorawebmsieProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Eudorawebmsie", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#EudorawebmsieProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#EudorawebProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Eudoraweb", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#EudorawebProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#EzwapProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Ezwap", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#EzwapProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#GatablefalseProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Gatablefalse", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#GatablefalseProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#GatableProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Gatable", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#GatableProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#GatabletrueProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Gatabletrue", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#GatabletrueProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#GenericdownlevelProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Genericdownlevel", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#GenericdownlevelProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#GoamericanonuprimProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Goamericanonuprim", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#GoamericanonuprimProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Goamericanonuprim", Justification = @"[....]: Generated BrowserCaps methods")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#GoamericapalmProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Goamericapalm", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#GoamericapalmProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#GoamericaProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Goamerica", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#GoamericaProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#GoamericarimProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Goamericarim", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#GoamericarimProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#GoamericaupProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Goamericaup", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#GoamericaupProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#GoamericawinceProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Goamericawince", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#GoamericawinceProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#IeaolProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Ieaol", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#IeaolProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#IebetaProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Iebeta", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#IebetaProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1706:ShortAcronymsShouldBeUppercase", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#IeProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1706:ShortAcronymsShouldBeUppercase", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#IeProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: browser ids have two letter non-capitalized acronyms")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#IeupdateProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Ieupdate", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#IeupdateProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#IscolorfalseProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Iscolorfalse", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#IscolorfalseProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#IscolorProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Iscolor", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#IscolorProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#IscolortrueProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Iscolortrue", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#IscolortrueProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#JataayuppcProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Jataayuppc", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#JataayuppcProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#JataayuProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Jataayu", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#JataayuProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#JphonecoloriscolorProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Jphonecoloriscolor", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#JphonecoloriscolorProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#JphonecolorProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Jphonecolor", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#JphonecolorProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#JphonedensoProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Jphonedenso", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#JphonedensoProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#JphonedisplayProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Jphonedisplay", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#JphonedisplayProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#JphonekenwoodProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Jphonekenwood", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#JphonekenwoodProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#JphonemitsubishiProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Jphonemitsubishi", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#JphonemitsubishiProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#JphonenecProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Jphonenec", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#JphonenecProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#JphonepanasonicProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Jphonepanasonic", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#JphonepanasonicProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#JphonepioneerProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Jphonepioneer", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#JphonepioneerProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#JphoneProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Jphone", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#JphoneProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#JphonesanyoProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Jphonesanyo", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#JphonesanyoProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#JphonesharpProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Jphonesharp", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#JphonesharpProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#JphonetoshibaProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Jphonetoshiba", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#JphonetoshibaProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#JtelnateProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Jtelnate", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#JtelnateProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#MaxpagesizeProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Maxpagesize", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#MaxpagesizeProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#MccaProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Mcca", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#MccaProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#McccProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Mccc", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#McccProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#MmebenefonqProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Mmebenefonq", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#MmebenefonqProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#MmecellphoneProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Mmecellphone", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#MmecellphoneProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#MmegenericflipProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Mmegenericflip", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#MmegenericflipProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#MmegenericlargeProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Mmegenericlarge", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#MmegenericlargeProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#MmegenericsmallProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Mmegenericsmall", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#MmegenericsmallProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#MmemobileexplorerProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Mmemobileexplorer", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#MmemobileexplorerProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#MotafProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Motaf", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#MotafProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#MotbcProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Motbc", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#MotbcProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#MotcbProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Motcb", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#MotcbProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#MotcfProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Motcf", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#MotcfProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#MotdcProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Motdc", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#MotdcProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#MotpancProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Motpanc", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#MotpancProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#MozillabetaProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Mozillabeta", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#MozillabetaProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#MozillafirebirdProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Mozillafirebird", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#MozillafirebirdProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Mozillafirebird", Justification = @"NO_JUSTIFICATION_PROVIDED")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#MozillafirefoxProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Mozillafirefox", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#MozillafirefoxProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Mozillafirefox", Justification = @"[....]: Spelling ok")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#MozillagoldProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Mozillagold", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#MozillagoldProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#MozillaProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Mozilla", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#MozillaProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#MozillarvProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Mozillarv", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#MozillarvProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#MspieProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Mspie", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#MspieProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#MypalmProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Mypalm", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#MypalmProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#NetfrontProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Netfront", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#NetfrontProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: device identifiers")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#NetscapebetaProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Netscapebeta", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#NetscapebetaProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#NokiablueprintProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Nokiablueprint", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#NokiablueprintProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#NokiagatewayProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Nokiagateway", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#NokiagatewayProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#NokiamobilebrowserProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Nokiamobilebrowser", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#NokiamobilebrowserProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#NokiamobilebrowserrainbowProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Nokiamobilebrowserrainbow", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#NokiamobilebrowserrainbowProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#NokiawapsimulatorProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Nokiawapsimulator", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#NokiawapsimulatorProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#OperamobilebrowserProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Operamobilebrowser", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#OperamobilebrowserProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Operamobilebrowser", Justification = @"[....]: BrowserCap generated methods")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#OperamobileProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Operamobile", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#OperamobileProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Operamobile", Justification = @"[....]: Method names auto-generated by BrowserCaps")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#OperapsionProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Operapsion", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#OperapsionProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#OpwvsdkProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Opwvsdk", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#OpwvsdkProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#PalmscapeProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Palmscape", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#PalmscapeProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#PalmscapeversionProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Palmscapeversion", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#PalmscapeversionProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#PalmwebproProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Palmwebpro", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#PalmwebproProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids, not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#PanasonicexchangesupporteddeviceProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Panasonicexchangesupporteddevice", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#PanasonicexchangesupporteddeviceProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#PdqbrowserProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Pdqbrowser", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#PdqbrowserProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#PienodeviceidProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Pienodeviceid", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#PienodeviceidProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#PieppcProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Pieppc", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#PieppcProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#PiescreenbitdepthProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Piescreenbitdepth", Justification = @"[....]: These are browsercap generated methods.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#PiescreenbitdepthProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Piescreenbitdepth", Justification = @"[....]: These are browsercap generated methods.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#PiesmartphoneProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Piesmartphone", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#PiesmartphoneProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#PlatformmacppcProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Platformmacppc", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#PlatformmacppcProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#PlatformunixProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Platformunix", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#PlatformunixProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#PlatformwebtvProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Platformwebtv", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#PlatformwebtvProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#PlatformwinceProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Platformwince", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#PlatformwinceProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Globalization", "CA1302:DoNotHardcodeLocaleSpecificStrings", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#PlatformwinntProcess(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "WinNT", Justification = @"[....]: Platform string for generated browser caps factory.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#PlatformwinntProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Platformwinnt", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#PlatformwinntProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#PlatformwinxpProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Platformwinxp", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#PlatformwinxpProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#PowerbrowserProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Powerbrowser", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#PowerbrowserProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#PpatProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Ppat", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#PpatProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#SharppdaProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Sharppda", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#SharppdaProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#ShProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Sh", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1706:ShortAcronymsShouldBeUppercase", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#ShProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#ShProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1706:ShortAcronymsShouldBeUppercase", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#ShProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: browser ids have two letter non-capitalized acronyms")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#SktdevicescolordepthProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Sktdevicescolordepth", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#SktdevicescolordepthProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Sktdevicescolordepth", Justification = @"[....]: BrowserCap generated methods")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#SktdevicesericssonProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Sktdevicesericsson", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#SktdevicesericssonProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Sktdevicesericsson", Justification = @"[....]: BrowserCap generated methods")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#SktdeviceshanhwaProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Sktdeviceshanhwa", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#SktdeviceshanhwaProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Sktdeviceshanhwa", Justification = @"[....]: BrowserCap generated methods")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#SktdeviceshyundaiProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Sktdeviceshyundai", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#SktdeviceshyundaiProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Sktdeviceshyundai", Justification = @"[....]: BrowserCap generated methods")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#SktdevicesiscolorProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Sktdevicesiscolor", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#SktdevicesiscolorProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Sktdevicesiscolor", Justification = @"[....]: BrowserCap generated methods")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#SktdevicesjtelProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Sktdevicesjtel", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#SktdevicesjtelProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Sktdevicesjtel", Justification = @"[....]: BrowserCap generated methods")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#SktdeviceslgProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Sktdeviceslg", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#SktdeviceslgProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Sktdeviceslg", Justification = @"[....]: BrowserCap generated methods")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#SktdevicesmotorolaProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Sktdevicesmotorola", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#SktdevicesmotorolaProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Sktdevicesmotorola", Justification = @"[....]: BrowserCap generated methods")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#SktdevicesnokiaProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Sktdevicesnokia", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#SktdevicesnokiaProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Sktdevicesnokia", Justification = @"[....]: BrowserCap generated methods")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#SktdevicesProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Sktdevices", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#SktdevicesProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Sktdevices", Justification = @"[....]: BrowserCap generated methods")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#SktdevicessamsungProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Sktdevicessamsung", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#SktdevicessamsungProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Sktdevicessamsung", Justification = @"[....]: BrowserCap generated methods")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#SktdevicesscreencolumnProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Sktdevicesscreencolumn", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#SktdevicesscreencolumnProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Sktdevicesscreencolumn", Justification = @"[....]: BrowserCap generated methods")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#SktdevicesscreenheightProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Sktdevicesscreenheight", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#SktdevicesscreenheightProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Sktdevicesscreenheight", Justification = @"[....]: BrowserCap generated methods")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#SktdevicesscreenrowProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Sktdevicesscreenrow", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#SktdevicesscreenrowProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Sktdevicesscreenrow", Justification = @"[....]: BrowserCap generated methods")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#SktdevicesscreenwidthProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Sktdevicesscreenwidth", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#SktdevicesscreenwidthProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Sktdevicesscreenwidth", Justification = @"[....]: BrowserCap generated methods")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#SktdevicesskttProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Sktdevicessktt", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#SktdevicesskttProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Sktdevicessktt", Justification = @"[....]: BrowserCap generated methods")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#SonyericssonProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Sonyericsson", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#SonyericssonProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#TmobilesidekickProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Tmobilesidekick", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#TmobilesidekickProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids, not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#UpdefaultscreencharactersProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Updefaultscreencharacters", Justification = @"[....]: browsercaps generated methods")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#UpdefaultscreencharactersProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Updefaultscreencharacters", Justification = @"[....]: browsercaps generated methods")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#UpdefaultscreenpixelsProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Updefaultscreenpixels", Justification = @"[....]: browsercaps generated methods")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#UpdefaultscreenpixelsProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Updefaultscreenpixels", Justification = @"[....]: browsercaps generated methods")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#UpgatewayProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Upgateway", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#UpgatewayProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#UpmaxpduProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Upmaxpdu", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#UpmaxpduProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Upmaxpdu", Justification = @"[....]: browsercap generated methods.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#UpmsizeProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Upmsize", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#UpmsizeProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Upmsize", Justification = @"[....]: BrowserCap generated methods.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#UpnongogatewayProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Upnongogateway", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#UpnongogatewayProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#UpnumsoftkeysProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Upnumsoftkeys", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#UpnumsoftkeysProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Upnumsoftkeys", Justification = @"[....]: browsercap generated methods.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#UpscreencharsProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Upscreenchars", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#UpscreencharsProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Upscreenchars", Justification = @"[....]: browsercap generated methods.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#UpscreendepthProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Upscreendepth", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#UpscreendepthProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Upscreendepth", Justification = @"[....]: BrowserCap generated methods.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#UpscreenpixelsProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Upscreenpixels", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#UpscreenpixelsProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Upscreenpixels", Justification = @"[....]: browsercap generated methods.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#UpsoftkeysizeProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Upsoftkeysize", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#UpsoftkeysizeProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Upsoftkeysize", Justification = @"[....]: BrowserCap generated methods.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#UpversionProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Upversion", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#UpversionProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#VrnaProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Vrna", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#VrnaProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: device identifiers")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#WebtvbetaProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Webtvbeta", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#WebtvbetaProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#WinwapProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Winwap", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#WinwapProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#XeniumProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Xenium", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#XeniumProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#XiinoProcessBrowsers(System.Boolean,System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", MessageId = "Xiino", Justification = @"[....]: BrowserCap generated code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.BrowserCapabilitiesFactory.#XiinoProcessGateways(System.Collections.Specialized.NameValueCollection,System.Web.HttpBrowserCapabilities)", Justification = @"[....]: methods are generated from browser ids and are not in the dictionary")]
[module: SuppressMessage("Microsoft.Design", "CA1035:ICollectionImplementationsHaveStronglyTypedMembers", Scope = "type", Target = "System.Web.Configuration.BrowserDefinitionCollection", Justification = @"[....]: The base type determines the strong type")]
[module: SuppressMessage("Microsoft.Design", "CA1039:ListsAreStronglyTyped", Scope = "type", Target = "System.Web.Configuration.BrowserDefinitionCollection", Justification = @"[....]: The base type is used to determine the strong type")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.BufferModesCollection.#CreateNewElement()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.BufferModesCollection.#GetElementKey(System.Configuration.ConfigurationElement)", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.BufferModeSettings.#get_ElementProperty()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.BufferModeSettings.#get_Properties()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.BuildProvider.#Equals(System.Object)", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.BuildProvider.#GetHashCode()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.BuildProvider.#get_Properties()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Design", "CA1035:ICollectionImplementationsHaveStronglyTypedMembers", Scope = "type", Target = "System.Web.Configuration.BuildProviderCollection", Justification = @"[....]: The base type is used to determine the strong type.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.BuildProviderCollection.#CreateNewElement()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.BuildProviderCollection.#GetElementKey(System.Configuration.ConfigurationElement)", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "System.Web.Configuration.CheckPair.#.ctor(System.String,System.String)", MessageId = "System.Text.RegularExpressions.Regex", Justification = @"[....]: A Regex is constructed for the side effect of checking the validity of the match string.")]
[module: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "System.Web.Configuration.CheckPair.#.ctor(System.String,System.String,System.Boolean)", MessageId = "System.Text.RegularExpressions.Regex", Justification = @"[....]: Create an instance of Regex to validate the parameters at parse time.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.ClientTarget.#get_Properties()", Justification = @"[....]: Classes we don't own can't be changed.")]
[module: SuppressMessage("Microsoft.Naming", "CA1709:IdentifiersShouldBeCasedCorrectly", Scope = "member", Target = "System.Web.Configuration.ClientTargetCollection.#Add(System.Web.Configuration.ClientTarget)", MessageId = "0#", Justification = @"[....]: Spellings ok")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope = "member", Target = "System.Web.Configuration.ClientTargetCollection.#AllKeys", Justification = @"[....]: These return an array from the base class, which is copied fresh with each call.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.ClientTargetCollection.#CreateNewElement()", Justification = @"[....]: Classes we don't own can't be changed.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.ClientTargetCollection.#GetElementKey(System.Configuration.ConfigurationElement)", Justification = @"[....]: Classes we don't own can't be changed.")]
[module: SuppressMessage("Microsoft.Naming", "CA1709:IdentifiersShouldBeCasedCorrectly", Scope = "member", Target = "System.Web.Configuration.ClientTargetCollection.#Remove(System.Web.Configuration.ClientTarget)", MessageId = "0#", Justification = @"[....]: Spellings ok")]
[module: SuppressMessage("Microsoft.Performance", "CA1812:AvoidUninstantiatedInternalClasses", Scope = "type", Target = "System.Web.Configuration.COAUTHIDENTITY", Justification = @"[....]: will be used later")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope = "member", Target = "System.Web.Configuration.COAUTHINFO.#authidentitydata", Justification = @"[....]: COM Interop definitions")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope = "member", Target = "System.Web.Configuration.COAUTHINFO_X64.#authidentitydata", Justification = @"[....]: Excluding for checkin to unblock BMB until Manu has a chance to look at them, and either fix or update the exlusion reason.")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "type", Target = "System.Web.Configuration.CodeSubDirectoriesCollection", MessageId = "SubDirectories", Justification = @"[....]: Spellings ok")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "member", Target = "System.Web.Configuration.CodeSubDirectoriesCollection.#Add(System.Web.Configuration.CodeSubDirectory)", MessageId = "SubDirectory", Justification = @"[....]: Spellings ok")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.CodeSubDirectoriesCollection.#get_CollectionType()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.CodeSubDirectoriesCollection.#CreateNewElement()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.CodeSubDirectoriesCollection.#get_ElementName()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.CodeSubDirectoriesCollection.#GetElementKey(System.Configuration.ConfigurationElement)", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "type", Target = "System.Web.Configuration.CodeSubDirectory", MessageId = "SubDirectory", Justification = @"[....]: Spellings ok.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.CodeSubDirectory.#get_Properties()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "member", Target = "System.Web.Configuration.CompilationSection.#AssemblyPostProcessorType", MessageId = "PostProcessor", Justification = @"[....]: Spellings ok.")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "member", Target = "System.Web.Configuration.CompilationSection.#CodeSubDirectories", MessageId = "SubDirectories", Justification = @"[....]: Spellings ok.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Configuration.CompilationSection.#EnsureReferenceSet()", Justification = @"[....]: Config should not be protected by link demands.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.CompilationSection.#GetRuntimeObject()", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.Configuration.CompilationSection.#LoadAssemblyHelper(System.String,System.Boolean)", Justification = @"[....]: Disregarding this rule because it doesn't make sense for our code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.CompilationSection.#NumRecompilesBeforeAppRestart", MessageId = "Num", Justification = @"[....]: 'Num' must be preserved for back compat with Everett.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.CompilationSection.#UrlLinePragmas", Justification = @"[....]: ""Pragmas"" is spelled correctly.")]
[module: SuppressMessage("Microsoft.Naming", "CA1724:TypeNamesShouldNotMatchNamespaces", Scope = "type", Target = "System.Web.Configuration.Compiler", Justification = @"[....]: Too large of a breaking change.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.Compiler.#get_Properties()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Design", "CA1035:ICollectionImplementationsHaveStronglyTypedMembers", Scope = "type", Target = "System.Web.Configuration.CompilerCollection", Justification = @"[....]: The base type is used to determine the strong type.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope = "member", Target = "System.Web.Configuration.CompilerCollection.#AllKeys", Justification = @"[....]: This is designed behavior mimicking AllKeys in other collections")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.CompilerCollection.#get_CollectionType()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.CompilerCollection.#CreateNewElement()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.CompilerCollection.#get_ElementName()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.CompilerCollection.#GetElementKey(System.Configuration.ConfigurationElement)", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Performance", "CA1812:AvoidUninstantiatedInternalClasses", Scope = "type", Target = "System.Web.Configuration.ConfigsHelper", Justification = @"[....]: It's a helper class")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.Configuration.ConfigUtil.#GetType(System.String,System.String,System.Configuration.ConfigurationElement)", Justification = @"[....]: Disregarding this rule because it doesn't make sense for our code.")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope = "member", Target = "System.Web.Configuration.COSERVERINFO.#authinfo", Justification = @"[....]: COM Interop definitions")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope = "member", Target = "System.Web.Configuration.COSERVERINFO_X64.#authinfo", Justification = @"[....]: Excluding for checkin to unblock BMB until Manu has a chance to look at them, and either fix or update the exlusion reason.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.CustomError.#Equals(System.Object)", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.CustomError.#GetHashCode()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.CustomError.#get_Properties()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Design", "CA1035:ICollectionImplementationsHaveStronglyTypedMembers", Scope = "type", Target = "System.Web.Configuration.CustomErrorCollection", Justification = @"[....]: The base type is used to determine the strong type.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope = "member", Target = "System.Web.Configuration.CustomErrorCollection.#AllKeys", Justification = @"[....]: This is the designed behavior.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.CustomErrorCollection.#get_CollectionType()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.CustomErrorCollection.#CreateNewElement()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.CustomErrorCollection.#get_ElementName()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.CustomErrorCollection.#GetElementKey(System.Configuration.ConfigurationElement)", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.CustomErrorsSection.#DeserializeSection(System.Xml.XmlReader)", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.EventMappingSettings.#get_Properties()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.EventMappingSettingsCollection.#CreateNewElement()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.EventMappingSettingsCollection.#GetElementKey(System.Configuration.ConfigurationElement)", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.ExpressionBuilder.#get_Properties()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.ExpressionBuilderCollection.#CreateNewElement()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.ExpressionBuilderCollection.#GetElementKey(System.Configuration.ConfigurationElement)", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.Configuration.FormsAuthenticationConfiguration.#DefaultUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.FormsAuthenticationConfiguration.#get_ElementProperty()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.Configuration.FormsAuthenticationConfiguration.#LoginUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.FormsAuthenticationConfiguration.#get_Properties()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Naming", "CA1705:LongAcronymsShouldBePascalCased", Scope = "member", Target = "System.Web.Configuration.FormsAuthenticationConfiguration.#RequireSSL", Justification = @"[....]: Previously excluded but the class name changed")]
[module: SuppressMessage("Microsoft.Naming", "CA1705:LongAcronymsShouldBePascalCased", Scope = "member", Target = "System.Web.Configuration.FormsAuthenticationConfiguration.#get_RequireSSL()", Justification = @"[....]: This was previously excluded but the class name changed")]
[module: SuppressMessage("Microsoft.Naming", "CA1705:LongAcronymsShouldBePascalCased", Scope = "member", Target = "System.Web.Configuration.FormsAuthenticationConfiguration.#set_RequireSSL(System.Boolean)", Justification = @"[....]: This was previously excluded.  The class name changed")]
[module: SuppressMessage("Microsoft.Usage", "CA2208:InstantiateArgumentExceptionsCorrectly", Scope = "member", Target = "System.Web.Configuration.FormsAuthenticationConfiguration.#Validate(System.Object)", Justification = @"[....]: The parameter name 'value' is not helpful to the consumer of the message. The name of the section or element that 'value' represents is much more helpful.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.FormsAuthenticationCredentials.#get_Properties()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.FormsAuthenticationUser.#get_Properties()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Design", "CA1035:ICollectionImplementationsHaveStronglyTypedMembers", Scope = "type", Target = "System.Web.Configuration.FormsAuthenticationUserCollection", Justification = @"[....]: The base type is used to determine the strong type.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope = "member", Target = "System.Web.Configuration.FormsAuthenticationUserCollection.#AllKeys", Justification = @"[....]: This is designed behavior mimicking AllKeys in other collections")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.FormsAuthenticationUserCollection.#get_CollectionType()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.FormsAuthenticationUserCollection.#CreateNewElement()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.FormsAuthenticationUserCollection.#get_ElementName()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.FormsAuthenticationUserCollection.#GetElementKey(System.Configuration.ConfigurationElement)", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.FormsAuthenticationUserCollection.#get_ThrowOnDuplicate()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "System.Web.Configuration.GlobalizationSection.#CheckCulture(System.String)", MessageId = "System.Globalization.CultureInfo", Justification = @"[....]: An object is created for its side effect of throwing an exception if the object is invalid. Nothing need be done with the object.")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.Configuration.HandlerBase.#GetAndRemoveIntegerAttributeInternal(System.Xml.XmlNode,System.String,System.Boolean,System.Int32&)", Justification = @"[....]: Disregarding this rule because it doesn't make sense for our code.")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.Configuration.HandlerBase.#GetAndRemoveTypeAttributeInternal(System.Xml.XmlNode,System.String,System.Boolean,System.Type&)", Justification = @"[....]: Disregarding this rule because it doesn't make sense for our code.")]
[module: SuppressMessage("Microsoft.Performance", "CA1814:PreferJaggedArraysOverMultidimensional", Scope = "member", Target = "System.Web.Configuration.HealthMonitoringSectionHelper.#_cachedMatchedRules", Justification = @"[....]: We want to use a fixed size multidimensional table to lookup results.")]
[module: SuppressMessage("Microsoft.Performance", "CA1814:PreferJaggedArraysOverMultidimensional", Scope = "member", Target = "System.Web.Configuration.HealthMonitoringSectionHelper.#FindFiringRuleInfos(System.Type,System.Int32)", Justification = @"[....]: Multi-dimensional array is intentionally used for performance.")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.Configuration.HealthMonitoringSectionHelper.#InitCustomEvaluator(System.Web.Configuration.HealthMonitoringSectionHelper+RuleInfo)", Justification = @"[....]: Disregarding this rule because it doesn't make sense for our code.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope = "member", Target = "System.Web.Configuration.HttpCapabilitiesBase.#Adapters", Justification = @"[....]: This is the designed intent to allow the caller to provide its own collection")]
[module: SuppressMessage("Microsoft.Naming", "CA1705:LongAcronymsShouldBePascalCased", Scope = "member", Target = "System.Web.Configuration.HttpCapabilitiesBase.#AOL", Justification = @"[....]: These are legacy public methods which would cause a break in customer's code if changed.")]
[module: SuppressMessage("Microsoft.Naming", "CA1705:LongAcronymsShouldBePascalCased", Scope = "member", Target = "System.Web.Configuration.HttpCapabilitiesBase.#get_AOL()", Justification = @"[....]: These are legacy public methods which would cause a break in customer's code if changed.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.HttpCapabilitiesBase.#CanRenderOneventAndPrevElementsTogether", Justification = @"[....]: browser capabilities not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.HttpCapabilitiesBase.#CanRenderSetvarZeroWithMultiSelectionList", Justification = @"[....]: browser capabilities not in the dictionary")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope = "member", Target = "System.Web.Configuration.HttpCapabilitiesBase.#Capabilities", Justification = @"[....]: This is the designed intent to allow the user to provide its own collection.")]
[module: SuppressMessage("Microsoft.Naming", "CA1705:LongAcronymsShouldBePascalCased", Scope = "member", Target = "System.Web.Configuration.HttpCapabilitiesBase.#CDF", Justification = @"[....]: These are legacy public methods which would cause a break in customer's code if changed.")]
[module: SuppressMessage("Microsoft.Naming", "CA1705:LongAcronymsShouldBePascalCased", Scope = "member", Target = "System.Web.Configuration.HttpCapabilitiesBase.#get_CDF()", Justification = @"[....]: These are legacy public methods which would cause a break in customer's code if changed.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.HttpCapabilitiesBase.#EcmaScriptVersion", Justification = @"[....]: browser capabilities not in the dictionary")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Configuration.HttpCapabilitiesBase.#GetConfigCapabilities(System.String,System.Web.HttpRequest)", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.Configuration.HttpCapabilitiesBase.#GetConfigCapabilities(System.String,System.Web.HttpRequest)", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Security", "CA2106:SecureAsserts", Scope = "member", Target = "System.Web.Configuration.HttpCapabilitiesBase.#GetConfigCapabilities(System.String,System.Web.HttpRequest)", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "member", Target = "System.Web.Configuration.HttpCapabilitiesBase.#HidesRightAlignedMultiselectScrollbars", MessageId = "Scrollbars", Justification = @"[....]: Spellings ok.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.HttpCapabilitiesBase.#HidesRightAlignedMultiselectScrollbars", Justification = @"[....]: browser capabilities not in the dictionary")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Configuration.HttpCapabilitiesBase.#get_Id()", Justification = @"[....]: Id only accessed when HttpContext is available, which is only in our the LinkDemand would succeed.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Configuration.HttpCapabilitiesBase.#get_Item(System.String)", Justification = @"[....]: Item is only accessed when HttpContext is available, which is the same set of conditions as when the LinkDemand is present.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Configuration.HttpCapabilitiesBase.#get_MaximumRenderedPageSize()", Justification = @"[....]: IFormatProviders not passed for parsing browserCaps params from config")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.HttpCapabilitiesBase.#MaximumSoftkeyLabelLength", MessageId = "Softkey", Justification = @"[....]: Spelling ok")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.HttpCapabilitiesBase.#NumberOfSoftkeys", MessageId = "Softkeys", Justification = @"[....]: Spelling ok")]
[module: SuppressMessage("Microsoft.Naming", "CA1705:LongAcronymsShouldBePascalCased", Scope = "member", Target = "System.Web.Configuration.HttpCapabilitiesBase.#RequiresDBCSCharacter", Justification = @"[....]: These are legacy public methods which would cause a break in customer's code if changed.")]
[module: SuppressMessage("Microsoft.Naming", "CA1705:LongAcronymsShouldBePascalCased", Scope = "member", Target = "System.Web.Configuration.HttpCapabilitiesBase.#get_RequiresDBCSCharacter()", Justification = @"[....]: These are legacy public methods which would cause a break in customer's code if changed.")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "member", Target = "System.Web.Configuration.HttpCapabilitiesBase.#RequiresPhoneNumbersAsPlainText", MessageId = "PlainText", Justification = @"[....]: Spellings ok.")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "member", Target = "System.Web.Configuration.HttpCapabilitiesBase.#RequiresUniqueHtmlCheckboxNames", MessageId = "Checkbox", Justification = @"[....]: Spellings ok.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.HttpCapabilitiesBase.#RequiresUrlEncodedPostfieldValues", Justification = @"[....]: browser capabilities not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.HttpCapabilitiesBase.#SupportsAccesskeyAttribute", Justification = @"[....]: browser capabilities not in the dictionary")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "member", Target = "System.Web.Configuration.HttpCapabilitiesBase.#SupportsJPhoneMultiMediaAttributes", MessageId = "MultiMedia", Justification = @"[....]: Spellings ok.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.Configuration.HttpCapabilitiesBase.#System.Web.UI.IFilterResolutionService.CompareFilters(System.String,System.String)", Justification = @"[....]: These are not meant to be overridden.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.Configuration.HttpCapabilitiesBase.#System.Web.UI.IFilterResolutionService.EvaluateFilter(System.String)", Justification = @"[....]: These are not meant to be overridden.")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.Configuration.HttpCapabilitiesBase.#get_TagWriter()", Justification = @"[....]: Disregarding this rule because it doesn't make sense for our code.")]
[module: SuppressMessage("Microsoft.Performance", "CA1812:AvoidUninstantiatedInternalClasses", Scope = "type", Target = "System.Web.Configuration.HttpCapabilitiesSectionHandler", Justification = @"[....]: Config section handlers are used.")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.Configuration.HttpCapabilitiesSectionHandler.#.ctor()", Justification = @"[....]: An instance of this class is created via reflection.")]
[module: SuppressMessage("Microsoft.Design", "CA1059:MembersShouldNotExposeCertainConcreteTypes", Scope = "member", Target = "System.Web.Configuration.HttpCapabilitiesSectionHandler.#Create(System.Object,System.Object,System.Xml.XmlNode)", MessageId = "System.Xml.XmlNode", Justification = @"[....]: Breaking change")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.HttpCapabilitiesSectionHandler.#Create(System.Object,System.Object,System.Xml.XmlNode)", Justification = @"[....]: Classes we don't own can't be changed.")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.Configuration.HttpCapabilitiesSectionHandler.#ResolveFiles(System.Web.Configuration.HttpCapabilitiesSectionHandler+ParseState,System.Object)", Justification = @"[....]: Disregarding this rule because it doesn't make sense for our code.")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.Configuration.HttpCapabilitiesSectionHandler.#RuleFromElement(System.Web.Configuration.HttpCapabilitiesSectionHandler+ParseState,System.Xml.XmlNode)", Justification = @"[....]: Disregarding this rule because it doesn't make sense for our code.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Configuration.HttpConfigurationSystem.#GetSection(System.String)", Justification = @"[....]: Config should not be protected by a link demand.")]
[module: SuppressMessage("Microsoft.Naming", "CA1705:LongAcronymsShouldBePascalCased", Scope = "member", Target = "System.Web.Configuration.HttpCookiesSection.#RequireSSL", Justification = @"[....]: These are legacy public methods which would cause a break in customer's code if changed.")]
[module: SuppressMessage("Microsoft.Naming", "CA1705:LongAcronymsShouldBePascalCased", Scope = "member", Target = "System.Web.Configuration.HttpCookiesSection.#get_RequireSSL()", Justification = @"[....]: These are legacy public methods which would cause a break in customer's code if changed.")]
[module: SuppressMessage("Microsoft.Naming", "CA1705:LongAcronymsShouldBePascalCased", Scope = "member", Target = "System.Web.Configuration.HttpCookiesSection.#set_RequireSSL(System.Boolean)", Justification = @"[....]: These are legacy public methods which would cause a break in customer's code if changed.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.HttpHandlerAction.#get_Properties()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.HttpHandlerActionCollection.#get_CollectionType()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.HttpHandlerActionCollection.#CreateNewElement()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.HttpHandlerActionCollection.#GetElementKey(System.Configuration.ConfigurationElement)", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.HttpHandlerActionCollection.#get_ThrowOnDuplicate()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.HttpModuleAction.#get_ElementProperty()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.HttpModuleAction.#get_Properties()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Usage", "CA2208:InstantiateArgumentExceptionsCorrectly", Scope = "member", Target = "System.Web.Configuration.HttpModuleAction.#Validate(System.Object)", Justification = @"[....]: The parameter name 'value' is not helpful to the consumer of the message. The name of the section or element that 'value' represents is much more helpful.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.HttpModuleActionCollection.#CreateNewElement()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.HttpModuleActionCollection.#GetElementKey(System.Configuration.ConfigurationElement)", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.HttpModuleActionCollection.#IsElementRemovable(System.Configuration.ConfigurationElement)", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "member", Target = "System.Web.Configuration.HttpRuntimeSection.#UseFullyQualifiedRedirectUrl", MessageId = "UseFully", Justification = @"[....]: Spellings ok.")]
[module: SuppressMessage("Microsoft.Usage", "CA2221:FinalizersShouldBeProtected", Scope = "member", Target = "System.Web.Configuration.IAssemblyName.#Finalize()", Justification = @"[....]: This is com interface, not actual implementation.")]
[module: SuppressMessage("Microsoft.Naming", "CA1706:ShortAcronymsShouldBeUppercase", Scope = "member", Target = "System.Web.Configuration.IConfigMapPath.#GetAppPathForPath(System.String,System.String)", MessageId = "0#", Justification = @"[....]: reviewed and excluded in beta2lhsd")]
[module: SuppressMessage("Microsoft.Design", "CA1021:AvoidOutParameters", Scope = "member", Target = "System.Web.Configuration.IConfigMapPath.#GetDefaultSiteNameAndID(System.String&,System.String&)", MessageId = "0#", Justification = @"[....]: These are interfaces that interop with COM classic. Out params are easier.")]
[module: SuppressMessage("Microsoft.Design", "CA1021:AvoidOutParameters", Scope = "member", Target = "System.Web.Configuration.IConfigMapPath.#GetDefaultSiteNameAndID(System.String&,System.String&)", MessageId = "1#", Justification = @"[....]: These are interfaces that interop with COM classic. Out params are easier.")]
[module: SuppressMessage("Microsoft.Naming", "CA1706:ShortAcronymsShouldBeUppercase", Scope = "member", Target = "System.Web.Configuration.IConfigMapPath.#GetDefaultSiteNameAndID(System.String&,System.String&)", Justification = @"[....]: In System.Web, we use ID, not Id.")]
[module: SuppressMessage("Microsoft.Naming", "CA1706:ShortAcronymsShouldBeUppercase", Scope = "member", Target = "System.Web.Configuration.IConfigMapPath.#GetDefaultSiteNameAndID(System.String&,System.String&)", MessageId = "1#", Justification = @"[....]: In System.Web, we use ID, not Id.")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "member", Target = "System.Web.Configuration.IConfigMapPath.#GetMachineConfigFilename()", MessageId = "Filename", Justification = @"[....]: Reviewed and exluded in beta2lhsd, porting that change to rtmlhs")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.Configuration.IConfigMapPath.#GetMachineConfigFilename()", Justification = @"[....]: This interface has a native counterpart, so using a method here is better.")]
[module: SuppressMessage("Microsoft.Design", "CA1021:AvoidOutParameters", Scope = "member", Target = "System.Web.Configuration.IConfigMapPath.#GetPathConfigFilename(System.String,System.String,System.String&,System.String&)", MessageId = "2#", Justification = @"[....]: Reviewed and excluded in beta2lhsd, for efficient marshalling with native code")]
[module: SuppressMessage("Microsoft.Design", "CA1021:AvoidOutParameters", Scope = "member", Target = "System.Web.Configuration.IConfigMapPath.#GetPathConfigFilename(System.String,System.String,System.String&,System.String&)", MessageId = "3#", Justification = @"[....]: Reviewed and excluded in beta2lhsd, for efficient marshalling with native code")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "member", Target = "System.Web.Configuration.IConfigMapPath.#GetPathConfigFilename(System.String,System.String,System.String&,System.String&)", MessageId = "Filename", Justification = @"[....]: Reviewed and exluded in beta2lhsd, porting that change to rtmlhs")]
[module: SuppressMessage("Microsoft.Naming", "CA1706:ShortAcronymsShouldBeUppercase", Scope = "member", Target = "System.Web.Configuration.IConfigMapPath.#GetPathConfigFilename(System.String,System.String,System.String&,System.String&)", MessageId = "0#", Justification = @"[....]: reviewed and excluded in beta2lhsd")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "member", Target = "System.Web.Configuration.IConfigMapPath.#GetRootWebConfigFilename()", MessageId = "Filename", Justification = @"[....]: Reviewed and exluded in beta2lhsd, porting that change to rtmlhs")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.Configuration.IConfigMapPath.#GetRootWebConfigFilename()", Justification = @"[....]: This interface is exposed to COM, so it is more consistent across native and managed code to have a single method name.")]
[module: SuppressMessage("Microsoft.Naming", "CA1706:ShortAcronymsShouldBeUppercase", Scope = "member", Target = "System.Web.Configuration.IConfigMapPath.#MapPath(System.String,System.String)", MessageId = "0#", Justification = @"[....]: reviewed and excluded in beta2lhsd")]
[module: SuppressMessage("Microsoft.Design", "CA1021:AvoidOutParameters", Scope = "member", Target = "System.Web.Configuration.IConfigMapPath.#ResolveSiteArgument(System.String,System.String&,System.String&)", MessageId = "1#", Justification = @"[....]: These are interfaces that interop with COM classic. Out params are easier.")]
[module: SuppressMessage("Microsoft.Design", "CA1021:AvoidOutParameters", Scope = "member", Target = "System.Web.Configuration.IConfigMapPath.#ResolveSiteArgument(System.String,System.String&,System.String&)", MessageId = "2#", Justification = @"[....]: These are interfaces that interop with COM classic. Out params are easier.")]
[module: SuppressMessage("Microsoft.Naming", "CA1706:ShortAcronymsShouldBeUppercase", Scope = "member", Target = "System.Web.Configuration.IConfigMapPath.#ResolveSiteArgument(System.String,System.String&,System.String&)", MessageId = "2#", Justification = @"[....]: In System.Web, we use ID, not Id.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.IdentitySection.#GetRuntimeObject()", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Globalization", "CA1303:DoNotPassLiteralsAsLocalizedParameters", Scope = "member", Target = "System.Web.Configuration.IdentitySection.#ValidateCredentials()", MessageId = "System.Configuration.ConfigurationPropertyException.#ctor(System.String,System.String,System.String,System.Int32)", Justification = @"[....]: literal is a parameter name and will not be localized")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope = "member", Target = "System.Web.Configuration.ImpersonateTokenRef.#_handle", Justification = @"[....]: This class was moved verbatum to the Section API file.  I am leaving it exactly as I encounted it to minimize any impact in the conversion to using the Management API.")]
[module: SuppressMessage("Microsoft.Naming", "CA1720:AvoidTypeNamesInParameters", Scope = "member", Target = "System.Web.Configuration.IRemoteWebConfigurationHostServer.#DoEncryptOrDecrypt(System.Boolean,System.String,System.String,System.String,System.String[],System.String[])", MessageId = "1#", Justification = @"NO_JUSTIFICATION_PROVIDED")]
[module: SuppressMessage("Microsoft.Design", "CA1021:AvoidOutParameters", Scope = "member", Target = "System.Web.Configuration.IRemoteWebConfigurationHostServer.#GetData(System.String,System.Boolean,System.Int64&)", MessageId = "2#", Justification = @"[....]: GetData is an internal method used in remote config.  It's okay to have an out param.")]
[module: SuppressMessage("Microsoft.Design", "CA1021:AvoidOutParameters", Scope = "member", Target = "System.Web.Configuration.IRemoteWebConfigurationHostServer.#GetFileDetails(System.String,System.Boolean&,System.Int64&,System.Int64&,System.Int64&)", MessageId = "1#", Justification = @"NO_JUSTIFICATION_PROVIDED")]
[module: SuppressMessage("Microsoft.Design", "CA1021:AvoidOutParameters", Scope = "member", Target = "System.Web.Configuration.IRemoteWebConfigurationHostServer.#GetFileDetails(System.String,System.Boolean&,System.Int64&,System.Int64&,System.Int64&)", MessageId = "2#", Justification = @"NO_JUSTIFICATION_PROVIDED")]
[module: SuppressMessage("Microsoft.Design", "CA1021:AvoidOutParameters", Scope = "member", Target = "System.Web.Configuration.IRemoteWebConfigurationHostServer.#GetFileDetails(System.String,System.Boolean&,System.Int64&,System.Int64&,System.Int64&)", MessageId = "3#", Justification = @"NO_JUSTIFICATION_PROVIDED")]
[module: SuppressMessage("Microsoft.Design", "CA1021:AvoidOutParameters", Scope = "member", Target = "System.Web.Configuration.IRemoteWebConfigurationHostServer.#GetFileDetails(System.String,System.Boolean&,System.Int64&,System.Int64&,System.Int64&)", MessageId = "4#", Justification = @"NO_JUSTIFICATION_PROVIDED")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "type", Target = "System.Web.Configuration.LowerCaseStringConverter", MessageId = "LowerCase", Justification = @"[....]: Spellings ok")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.LowerCaseStringConverter.#CanConvertFrom(System.ComponentModel.ITypeDescriptorContext,System.Type)", Justification = @"[....]: We don't own TypeConverter.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.LowerCaseStringConverter.#CanConvertTo(System.ComponentModel.ITypeDescriptorContext,System.Type)", Justification = @"[....]: We don't own TypeConverter.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.LowerCaseStringConverter.#ConvertFrom(System.ComponentModel.ITypeDescriptorContext,System.Globalization.CultureInfo,System.Object)", Justification = @"[....]: We don't own TypeConverter.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.LowerCaseStringConverter.#ConvertTo(System.ComponentModel.ITypeDescriptorContext,System.Globalization.CultureInfo,System.Object,System.Type)", Justification = @"[....]: We don't own TypeConverter.")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.Configuration.MachineKeySection.#SetKeyOnSymAlgorithm(System.Security.Cryptography.SymmetricAlgorithm,System.Byte[])", Justification = @"[....]: Disregarding this rule because it doesn't make sense for our code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1705:LongAcronymsShouldBePascalCased", Scope = "member", Target = "System.Web.Configuration.MachineKeyValidation.#AES", Justification = @"[....]: AES is a common abbreviation.")]
[module: SuppressMessage("Microsoft.Naming", "CA1705:LongAcronymsShouldBePascalCased", Scope = "member", Target = "System.Web.Configuration.MachineKeyValidation.#TripleDES", Justification = @"[....]: These are legacy public methods which would cause a break in customer's code if changed.")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope = "member", Target = "System.Web.Configuration.MULTI_QI.#piid", Justification = @"[....]: COM Interop definitions")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope = "member", Target = "System.Web.Configuration.MULTI_QI.#pItf", Justification = @"[....]: COM Interop definitions")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope = "member", Target = "System.Web.Configuration.MULTI_QI_X64.#piid", Justification = @"[....]: Excluding for checkin to unblock BMB until Manu has a chance to look at them, and either fix or update the exlusion reason.")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope = "member", Target = "System.Web.Configuration.MULTI_QI_X64.#pItf", Justification = @"[....]: Excluding for checkin to unblock BMB until Manu has a chance to look at them, and either fix or update the exlusion reason.")]
[module: SuppressMessage("Microsoft.Design", "CA1035:ICollectionImplementationsHaveStronglyTypedMembers", Scope = "type", Target = "System.Web.Configuration.NamespaceCollection", Justification = @"[....]: The base type is used to determine the strong type.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.NamespaceCollection.#CreateNewElement()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.NamespaceCollection.#GetElementKey(System.Configuration.ConfigurationElement)", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.NamespaceInfo.#Equals(System.Object)", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.NamespaceInfo.#GetHashCode()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.NamespaceInfo.#get_Properties()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.OutputCacheProfile.#get_Properties()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.OutputCacheProfile.#VaryByParam", MessageId = "Param", Justification = @"[....]: Spelling ok (V1 precedence)")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope = "member", Target = "System.Web.Configuration.OutputCacheProfileCollection.#AllKeys", Justification = @"[....]: This mimics other usages of AllKeys in the code.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.OutputCacheProfileCollection.#CreateNewElement()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.OutputCacheProfileCollection.#GetElementKey(System.Configuration.ConfigurationElement)", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.PagesSection.#AutoEventWireup", Justification = @"[....]: The rule break is to support the legacy name with the same casing as previous versions of the property.  This comes directly from Defect report 178939 where Shanku and Bobbyv approved the FXCOP break to make the name match legacy code.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.PagesSection.#DeserializeSection(System.Xml.XmlReader)", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.PassportAuthentication.#get_ElementProperty()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.PassportAuthentication.#get_Properties()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.Configuration.PassportAuthentication.#RedirectUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Usage", "CA2208:InstantiateArgumentExceptionsCorrectly", Scope = "member", Target = "System.Web.Configuration.PassportAuthentication.#Validate(System.Object)", Justification = @"[....]: The parameter name 'value' is not helpful to the consumer of the message. The name of the section or element that 'value' represents is much more helpful.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.ProcessModelComAuthenticationLevel.#Pkt", Justification = @"[....]: These match legacy values used in previous version of the config.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.ProcessModelComAuthenticationLevel.#PktIntegrity", Justification = @"[....]: These match legacy values used in previous version of the config.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.ProcessModelComAuthenticationLevel.#PktPrivacy", Justification = @"[....]: These match legacy values used in previous version of the config.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.ProfileGroupSettings.#Equals(System.Object)", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.ProfileGroupSettings.#GetHashCode()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.ProfileGroupSettings.#get_Properties()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope = "member", Target = "System.Web.Configuration.ProfileGroupSettingsCollection.#AllKeys", Justification = @"[....]: This is designed behavior mimicking AllKeys in other collections")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.ProfileGroupSettingsCollection.#CreateNewElement()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.ProfileGroupSettingsCollection.#GetElementKey(System.Configuration.ConfigurationElement)", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.ProfileGroupSettingsCollection.#IsModified()", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.ProfileGroupSettingsCollection.#ResetModified()", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.ProfilePropertySettings.#get_Properties()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope = "member", Target = "System.Web.Configuration.ProfilePropertySettingsCollection.#AllKeys", Justification = @"[....]: This is designed behavior mimicking AllKeys in other collections")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.ProfilePropertySettingsCollection.#CreateNewElement()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.ProfilePropertySettingsCollection.#GetElementKey(System.Configuration.ConfigurationElement)", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.ProfilePropertySettingsCollection.#OnDeserializeUnrecognizedElement(System.String,System.Xml.XmlReader)", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.ProfilePropertySettingsCollection.#get_ThrowOnDuplicate()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.ProfileSettings.#get_Properties()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.ProfileSettingsCollection.#CreateNewElement()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.ProfileSettingsCollection.#GetElementKey(System.Configuration.ConfigurationElement)", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope = "member", Target = "System.Web.Configuration.ProtocolCollection.#AllKeys", Justification = @"[....]: reviewed and excluded in beta2lhsd")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.ProtocolCollection.#CreateNewElement()", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.ProtocolCollection.#GetElementKey(System.Configuration.ConfigurationElement)", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.ProtocolElement.#PostDeserialize()", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.ProtocolElement.#get_Properties()", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.ProtocolsConfigurationHandler.#Create(System.Object,System.Object,System.Xml.XmlNode)", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Performance", "CA1812:AvoidUninstantiatedInternalClasses", Scope = "type", Target = "System.Web.Configuration.ProvidersHelper", Justification = @"[....]: Class will be used in near future.  File was checked in to unblock another dev.")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.Configuration.ProvidersHelper.#InstantiateProvider(System.Configuration.ProviderSettings,System.Type)", Justification = @"[....]: Class will be used in near future.  File was checked in to unblock another dev.")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.Configuration.ProvidersHelper.#InstantiateProvider(System.Configuration.ProviderSettings,System.Type)", Justification = @"[....]: Disregarding this rule because it doesn't make sense for our code.")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.Configuration.ProvidersHelper.#InstantiateProviders(System.Configuration.ProviderSettingsCollection,System.Configuration.Provider.ProviderCollection,System.Type)", Justification = @"[....]: Class will be used in near future.  File was checked in to unblock another dev.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Configuration.RegexWorker.#Lookup(System.String)", Justification = @"[....]: Config should not be protected by link demands.")]
[module: SuppressMessage("Microsoft.Performance", "CA1812:AvoidUninstantiatedInternalClasses", Scope = "type", Target = "System.Web.Configuration.RemoteWebConfigurationHost", Justification = @"[....]: Instantiated via reflection.")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.Configuration.RemoteWebConfigurationHost.#GetDomainFromFullName(System.String)", Justification = @"NO_JUSTIFICATION_PROVIDED")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.Configuration.RemoteWebConfigurationHost.#GetUserNameFromFullName(System.String)", Justification = @"NO_JUSTIFICATION_PROVIDED")]
[module: SuppressMessage("Microsoft.Globalization", "CA1303:DoNotPassLiteralsAsLocalizedParameters", Scope = "member", Target = "System.Web.Configuration.RemoteWebConfigurationHost.#Init(System.Configuration.Internal.IInternalConfigRoot,System.Object[])", MessageId = "System.InvalidOperationException.#ctor(System.String)", Justification = @"[....]: A literal is not passed, fxcop is confused.")]
[module: SuppressMessage("Microsoft.Security", "CA2124:WrapVulnerableFinallyClausesInOuterTry", Scope = "member", Target = "System.Web.Configuration.RemoteWebConfigurationHost.#InitForConfiguration(System.String&,System.String&,System.String&,System.Configuration.Internal.IInternalConfigRoot,System.Object[])", Justification = @"[....]: The wrapping is done, fxcop is confused.")]
[module: SuppressMessage("Microsoft.Performance", "CA1812:AvoidUninstantiatedInternalClasses", Scope = "type", Target = "System.Web.Configuration.RemoteWebConfigurationHostServer", Justification = @"[....]: Called via reflection")]
[module: SuppressMessage("Microsoft.Interoperability", "CA1408:DoNotUseAutoDualClassInterfaceType", Scope = "type", Target = "System.Web.Configuration.RemoteWebConfigurationHostServer", Justification = @"[....]: will remove later")]
[module: SuppressMessage("Microsoft.Naming", "CA1720:AvoidTypeNamesInParameters", Scope = "member", Target = "System.Web.Configuration.RemoteWebConfigurationHostServer.#DoEncryptOrDecrypt(System.Boolean,System.String,System.String,System.String,System.String[],System.String[])", MessageId = "1#", Justification = @"NO_JUSTIFICATION_PROVIDED")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.Configuration.RemoteWebConfigurationHostServer.#WriteData(System.String,System.String,System.Byte[],System.Int64&)", Justification = @"[....]: Disregarding this rule because it doesn't make sense for our code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1705:LongAcronymsShouldBePascalCased", Scope = "member", Target = "System.Web.Configuration.RoleManagerSection.#CookieRequireSSL", Justification = @"[....]: These are legacy public methods which would cause a break in customer's code if changed.")]
[module: SuppressMessage("Microsoft.Naming", "CA1705:LongAcronymsShouldBePascalCased", Scope = "member", Target = "System.Web.Configuration.RoleManagerSection.#get_CookieRequireSSL()", Justification = @"[....]: These are legacy public methods which would cause a break in customer's code if changed.")]
[module: SuppressMessage("Microsoft.Naming", "CA1705:LongAcronymsShouldBePascalCased", Scope = "member", Target = "System.Web.Configuration.RoleManagerSection.#set_CookieRequireSSL(System.Boolean)", Justification = @"[....]: These are legacy public methods which would cause a break in customer's code if changed.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.RuleSettings.#get_Properties()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.RuleSettingsCollection.#CreateNewElement()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.RuleSettingsCollection.#GetElementKey(System.Configuration.ConfigurationElement)", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2106:SecureAsserts", Scope = "member", Target = "System.Web.Configuration.RuntimeConfig.#GetSectionObject(System.String)", Justification = @"[....]: RolePrincipal.ToEncryptedTicket should work in partial trust")]
[module: SuppressMessage("Microsoft.Security", "CA2112:SecuredTypesShouldNotExposeFields", Scope = "type", Target = "System.Web.Configuration.SessionPageStateSection", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Performance", "CA1803:AvoidCostlyCallsWherePossible", Scope = "member", Target = "System.Web.Configuration.SessionStateSection.#ConvertToCookieMode(System.String)", Justification = @"[....]: By design because we want to map ""true"" and ""false"" into one of the enum values as well.  So we must first check if the incoming string is part of the enum or not.")]
[module: SuppressMessage("Microsoft.Naming", "CA1706:ShortAcronymsShouldBeUppercase", Scope = "member", Target = "System.Web.Configuration.SessionStateSection.#SessionIDManagerType", Justification = @"[....]: ""ID"" ok for ASP.NET")]
[module: SuppressMessage("Microsoft.Usage", "CA2208:InstantiateArgumentExceptionsCorrectly", Scope = "member", Target = "System.Web.Configuration.SessionStateSection.#Validate(System.Object)", Justification = @"[....]: The parameter name 'value' is not helpful to the consumer of the message. The name of the section or element that 'value' represents is much more helpful.")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "type", Target = "System.Web.Configuration.SiteMapSection", MessageId = "SiteMap", Justification = @"[....]: Spellings ok.")]
[module: SuppressMessage("Microsoft.Naming", "CA1720:AvoidTypeNamesInParameters", Scope = "member", Target = "System.Web.Configuration.SqlCacheDependencyDatabase.#.ctor(System.String,System.String)", MessageId = "1#", Justification = @"[....]: By design.")]
[module: SuppressMessage("Microsoft.Naming", "CA1720:AvoidTypeNamesInParameters", Scope = "member", Target = "System.Web.Configuration.SqlCacheDependencyDatabase.#.ctor(System.String,System.String,System.Int32)", MessageId = "1#", Justification = @"[....]: By design.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.SqlCacheDependencyDatabase.#get_ElementProperty()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.SqlCacheDependencyDatabase.#get_Properties()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Usage", "CA2208:InstantiateArgumentExceptionsCorrectly", Scope = "member", Target = "System.Web.Configuration.SqlCacheDependencyDatabase.#Validate(System.Object)", Justification = @"[....]: The parameter name 'value' is not helpful to the consumer of the message. The name of the section or element that 'value' represents is much more helpful.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope = "member", Target = "System.Web.Configuration.SqlCacheDependencyDatabaseCollection.#AllKeys", Justification = @"[....]: This is designed behavior mimicking AllKeys in other collections")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.SqlCacheDependencyDatabaseCollection.#CreateNewElement()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.SqlCacheDependencyDatabaseCollection.#GetElementKey(System.Configuration.ConfigurationElement)", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope = "member", Target = "System.Web.Configuration.SqlCacheDependencySection.#Databases", Justification = @"[....]: Config property must be settable.")]
[module: SuppressMessage("Microsoft.Usage", "CA2208:InstantiateArgumentExceptionsCorrectly", Scope = "member", Target = "System.Web.Configuration.SqlCacheDependencySection.#Validate(System.Object)", Justification = @"[....]: The parameter name 'value' is not helpful to the consumer of the message. The name of the section or element that 'value' represents is much more helpful.")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "member", Target = "System.Web.Configuration.SystemWebSectionGroup.#SiteMap", MessageId = "SiteMap", Justification = @"[....]: Spellings ok")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.TagMapCollection.#CreateNewElement()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.TagMapCollection.#GetElementKey(System.Configuration.ConfigurationElement)", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.Configuration.TagMapCollection.#get_TagTypeMappingInternal()", Justification = @"[....]: Disregarding this rule because it doesn't make sense for our code.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.TagMapInfo.#Equals(System.Object)", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.TagMapInfo.#GetHashCode()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.TagMapInfo.#get_Properties()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.TagMapInfo.#SerializeElement(System.Xml.XmlWriter,System.Boolean)", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Design", "CA1035:ICollectionImplementationsHaveStronglyTypedMembers", Scope = "type", Target = "System.Web.Configuration.TagPrefixCollection", Justification = @"[....]: The base type is used to determine the strong type.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.TagPrefixCollection.#get_CollectionType()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.TagPrefixCollection.#CreateNewElement()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.TagPrefixCollection.#get_ElementName()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.TagPrefixCollection.#GetElementKey(System.Configuration.ConfigurationElement)", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.TagPrefixCollection.#get_ThrowOnDuplicate()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "member", Target = "System.Web.Configuration.TagPrefixInfo.#.ctor(System.String,System.String,System.String,System.String,System.String)", MessageId = "nameSpace", Justification = @"[....]: namespace is a reserved keyword. Use nameSpace instead.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.TagPrefixInfo.#get_ElementProperty()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.TagPrefixInfo.#Equals(System.Object)", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.TagPrefixInfo.#GetHashCode()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.TagPrefixInfo.#get_Properties()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Usage", "CA2208:InstantiateArgumentExceptionsCorrectly", Scope = "member", Target = "System.Web.Configuration.TagPrefixInfo.#Validate(System.Object)", Justification = @"[....]: The parameter name 'value' is not helpful to the consumer of the message. The name of the section or element that 'value' represents is much more helpful.")]
[module: SuppressMessage("Microsoft.Design", "CA1008:EnumsShouldHaveZeroValue", Scope = "type", Target = "System.Web.Configuration.TraceDisplayMode", Justification = @"[....]: Everett enum")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.TransformerInfo.#Equals(System.Object)", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.TransformerInfo.#GetHashCode()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.TransformerInfo.#get_Properties()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.TransformerInfoCollection.#CreateNewElement()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.TransformerInfoCollection.#GetElementKey(System.Configuration.ConfigurationElement)", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.Configuration.TransformerInfoCollection.#GetTransformerEntries()", Justification = @"[....]: Disregarding this rule because it doesn't make sense for our code.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.TrustLevel.#get_Properties()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Design", "CA1035:ICollectionImplementationsHaveStronglyTypedMembers", Scope = "type", Target = "System.Web.Configuration.TrustLevelCollection", Justification = @"[....]: The base type is used to determine the strong type.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.TrustLevelCollection.#get_CollectionType()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.TrustLevelCollection.#CreateNewElement()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.TrustLevelCollection.#get_ElementName()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.TrustLevelCollection.#GetElementKey(System.Configuration.ConfigurationElement)", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.TrustLevelCollection.#IsElementName(System.String)", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.TrustLevelCollection.#get_ThrowOnDuplicate()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.Configuration.TrustSection.#OriginUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Design", "CA1054:UriParametersShouldNotBeStrings", Scope = "member", Target = "System.Web.Configuration.UrlMapping.#.ctor(System.String,System.String)", MessageId = "0#", Justification = @"[....]: Our url properties are commonly strings.")]
[module: SuppressMessage("Microsoft.Design", "CA1054:UriParametersShouldNotBeStrings", Scope = "member", Target = "System.Web.Configuration.UrlMapping.#.ctor(System.String,System.String)", MessageId = "1#", Justification = @"[....]: Our url properties are commonly strings.")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.Configuration.UrlMapping.#MappedUrl", Justification = @"[....]: Our url properties are commonly strings.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.UrlMapping.#get_Properties()", Justification = @"[....]: Classes we don't own can't be changed.")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.Configuration.UrlMapping.#Url", Justification = @"[....]: Our url properties are commonly strings.")]
[module: SuppressMessage("Microsoft.Naming", "CA1709:IdentifiersShouldBeCasedCorrectly", Scope = "member", Target = "System.Web.Configuration.UrlMappingCollection.#Add(System.Web.Configuration.UrlMapping)", MessageId = "0#", Justification = @"[....]: Spellings ok")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope = "member", Target = "System.Web.Configuration.UrlMappingCollection.#AllKeys", Justification = @"[....]: These return an array from the base class, which is copied fresh with each call.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.UrlMappingCollection.#CreateNewElement()", Justification = @"[....]: Classes we don't own can't be changed.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.UrlMappingCollection.#GetElementKey(System.Configuration.ConfigurationElement)", Justification = @"[....]: Classes we don't own can't be changed.")]
[module: SuppressMessage("Microsoft.Naming", "CA1709:IdentifiersShouldBeCasedCorrectly", Scope = "member", Target = "System.Web.Configuration.UrlMappingCollection.#Remove(System.Web.Configuration.UrlMapping)", MessageId = "0#", Justification = @"[....]: Spellings ok")]
[module: SuppressMessage("Microsoft.Usage", "CA2208:InstantiateArgumentExceptionsCorrectly", Scope = "member", Target = "System.Web.Configuration.VirtualDirectoryMapping.#set_ConfigFileBaseName(System.String)", Justification = @"[....]: The exception is correctly instantiated, fxcop is confused by HttpRuntime.FormatResourceString")]
[module: SuppressMessage("Microsoft.Usage", "CA2237:MarkISerializableTypesWithSerializable", Scope = "type", Target = "System.Web.Configuration.VirtualDirectoryMappingCollection", Justification = @"[....]: Class is marked as Serializable, fxcop is confused.")]
[module: SuppressMessage("Microsoft.Globalization", "CA1303:DoNotPassLiteralsAsLocalizedParameters", Scope = "member", Target = "System.Web.Configuration.VirtualDirectoryMappingCollection.#Add(System.String,System.Web.Configuration.VirtualDirectoryMapping)", MessageId = "System.ArgumentException.#ctor(System.String)", Justification = @"[....]: A literal is not passed, fxcop is confused by HttpFormatString as part of the argument.")]
[module: SuppressMessage("Microsoft.Globalization", "CA1303:DoNotPassLiteralsAsLocalizedParameters", Scope = "member", Target = "System.Web.Configuration.VirtualDirectoryMappingCollection.#Add(System.String,System.Web.Configuration.VirtualDirectoryMapping)", MessageId = "System.InvalidOperationException.#ctor(System.String)", Justification = @"[....]: A literal is not passed, fxcop is confused by HttpFormatString as part of the argument.")]
[module: SuppressMessage("Microsoft.Usage", "CA2208:InstantiateArgumentExceptionsCorrectly", Scope = "member", Target = "System.Web.Configuration.VirtualDirectoryMappingCollection.#Add(System.String,System.Web.Configuration.VirtualDirectoryMapping)", Justification = @"[....]: The exception is correctly instantiated, fxcop is confused by HttpRuntime.FormatResourceString")]
[module: SuppressMessage("Microsoft.Design", "CA1008:EnumsShouldHaveZeroValue", Scope = "type", Target = "System.Web.Configuration.WebApplicationLevel", Justification = @"[....]: This was a conscious decision by [....] because there's no reasonable default value.  The expectation is that there may be new interspersed values in the future.")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.Configuration.WebBaseEventKeyComparer.#Compare(System.Object,System.Object)", Justification = @"[....]: It's used by HealthMonitoringSectionHelper.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.WebConfigurationFileMap.#Clone()", Justification = @"[....]: Classes we don't own can't be changed.")]
[module: SuppressMessage("Microsoft.Performance", "CA1812:AvoidUninstantiatedInternalClasses", Scope = "type", Target = "System.Web.Configuration.WebConfigurationHost", Justification = @"[....]: WebConfigurationHost is instantiated by System.dll through reflection. It is not referenced directly in order to avoid loading System.Web.dll every time System.dll is loaded.")]
[module: SuppressMessage("Microsoft.Security", "CA2106:SecureAsserts", Scope = "member", Target = "System.Web.Configuration.WebConfigurationHost.#get_ConfigurationFactory()", Justification = @"[....]: We're creating a hardcoded class that lives in system.configuration.dll.  It's safe.")]
[module: SuppressMessage("Microsoft.Usage", "CA2208:InstantiateArgumentExceptionsCorrectly", Scope = "member", Target = "System.Web.Configuration.WebConfigurationHost.#InitForConfiguration(System.String&,System.String&,System.String&,System.Configuration.Internal.IInternalConfigRoot,System.Object[])", Justification = @"[....]: The 'site' argument is provided in an order params array. The original public method responsible for the argument has an argument named 'site'.")]
[module: SuppressMessage("Microsoft.Globalization", "CA1303:DoNotPassLiteralsAsLocalizedParameters", Scope = "member", Target = "System.Web.Configuration.WebConfigurationHost.#IsDefinitionAllowed(System.String,System.Configuration.ConfigurationAllowDefinition,System.Configuration.ConfigurationAllowExeDefinition)", MessageId = "System.InvalidOperationException.#ctor(System.String)", Justification = @"[....]: A literal is not passed, fxcop is confused by HttpFormatString as part of the argument.")]
[module: SuppressMessage("Microsoft.Globalization", "CA1303:DoNotPassLiteralsAsLocalizedParameters", Scope = "member", Target = "System.Web.Configuration.WebConfigurationHost.#VerifyDefinitionAllowed(System.String,System.Configuration.ConfigurationAllowDefinition,System.Configuration.ConfigurationAllowExeDefinition,System.Configuration.Internal.IConfigErrorInfo)", MessageId = "System.InvalidOperationException.#ctor(System.String)", Justification = @"[....]: A literal is not passed, fxcop is confused by HttpFormatString as part of the argument.")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.Configuration.WebConfigurationManager.#OpenMachineConfiguration(System.String,System.String,System.IntPtr)", Justification = @"[....]: ok")]
[module: SuppressMessage("Microsoft.Design", "CA1011:ConsiderPassingBaseTypesAsParameters", Scope = "member", Target = "System.Web.Configuration.WebConfigurationManager.#OpenMappedWebConfiguration(System.Web.Configuration.WebConfigurationFileMap,System.String)", Justification = @"[....]: The intention appears to be to force this to be a WebConfigurationFileMap.")]
[module: SuppressMessage("Microsoft.Design", "CA1011:ConsiderPassingBaseTypesAsParameters", Scope = "member", Target = "System.Web.Configuration.WebConfigurationManager.#OpenMappedWebConfiguration(System.Web.Configuration.WebConfigurationFileMap,System.String,System.String)", Justification = @"[....]: The intention appears to be to force this to be a WebConfigurationFileMap.")]
[module: SuppressMessage("Microsoft.Design", "CA1011:ConsiderPassingBaseTypesAsParameters", Scope = "member", Target = "System.Web.Configuration.WebConfigurationManager.#OpenMappedWebConfiguration(System.Web.Configuration.WebConfigurationFileMap,System.String,System.String,System.String)", Justification = @"[....]: The intention appears to be to force this to be a WebConfigurationFileMap.")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.Configuration.WebConfigurationManager.#OpenWebConfiguration(System.String,System.String,System.String,System.String,System.IntPtr)", Justification = @"[....]: ok")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Configuration.WebConfigurationManager.#OpenWebConfigurationImpl(System.Web.Configuration.WebLevel,System.Configuration.ConfigurationFileMap,System.String,System.String,System.String,System.String,System.String,System.String,System.IntPtr)", Justification = @"[....]: Config should not be protected by link demands.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.WebControlsSection.#GetRuntimeObject()", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.WebPartsPersonalization.#get_Properties()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.WebPartsPersonalizationAuthorization.#get_Properties()", Justification = @"[....]: Classes we don't own can't be changed.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Configuration.WebPartsSection.#GetRuntimeObject()", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.MSInternal", "CA903:InternalNamespaceShouldNotContainPublicTypes", Scope = "type", Target = "System.Web.Configuration.Internal.IInternalConfigWebHost", Justification = @"[....]: This interface is public so other assemblies can get to it, but no one outside of Microsoft should ever use it.  This is the alternative to reflecting on the assembly to get the interface.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.Internal.IInternalConfigWebHost.#GetConfigPathFromSiteIDAndVPath(System.String,System.String)", MessageId = "vpath", Justification = @"[....]: Apllings ok.")]
[module: SuppressMessage("Microsoft.Naming", "CA1706:ShortAcronymsShouldBeUppercase", Scope = "member", Target = "System.Web.Configuration.Internal.IInternalConfigWebHost.#GetConfigPathFromSiteIDAndVPath(System.String,System.String)", Justification = @"[....]: ID approved acronym.")]
[module: SuppressMessage("Microsoft.Naming", "CA1706:ShortAcronymsShouldBeUppercase", Scope = "member", Target = "System.Web.Configuration.Internal.IInternalConfigWebHost.#GetConfigPathFromSiteIDAndVPath(System.String,System.String)", MessageId = "0#", Justification = @"[....]: ID approved acronym.")]
[module: SuppressMessage("Microsoft.Design", "CA1021:AvoidOutParameters", Scope = "member", Target = "System.Web.Configuration.Internal.IInternalConfigWebHost.#GetSiteIDAndVPathFromConfigPath(System.String,System.String&,System.String&)", MessageId = "1#", Justification = @"[....]: Already using a return parameter or more than one out parameter.")]
[module: SuppressMessage("Microsoft.Design", "CA1021:AvoidOutParameters", Scope = "member", Target = "System.Web.Configuration.Internal.IInternalConfigWebHost.#GetSiteIDAndVPathFromConfigPath(System.String,System.String&,System.String&)", MessageId = "2#", Justification = @"[....]: Already using a return parameter or more than one out parameter.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Configuration.Internal.IInternalConfigWebHost.#GetSiteIDAndVPathFromConfigPath(System.String,System.String&,System.String&)", MessageId = "vpath", Justification = @"[....]: Apllings ok.")]
[module: SuppressMessage("Microsoft.Naming", "CA1706:ShortAcronymsShouldBeUppercase", Scope = "member", Target = "System.Web.Configuration.Internal.IInternalConfigWebHost.#GetSiteIDAndVPathFromConfigPath(System.String,System.String&,System.String&)", Justification = @"[....]: ID approved acronym.")]
[module: SuppressMessage("Microsoft.Naming", "CA1706:ShortAcronymsShouldBeUppercase", Scope = "member", Target = "System.Web.Configuration.Internal.IInternalConfigWebHost.#GetSiteIDAndVPathFromConfigPath(System.String,System.String&,System.String&)", MessageId = "1#", Justification = @"[....]: ID approved acronym.")]
[module: SuppressMessage("Microsoft.Security", "CA2107:ReviewDenyAndPermitOnlyUsage", Scope = "member", Target = "System.Web.DataAccess.DataConnectionHelper.#GetCurrentName()", Justification = @"[....]: This comes out of the security code review.")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.Handlers.AssemblyResourceLoader.#GetAssemblyInfoWithAssertInternal(System.Reflection.Assembly)", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.Handlers.AssemblyResourceLoader.#GetDiskResourcePath(System.String)", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.Handlers.TraceHandler.#.ctor()", Justification = @"[....]: These are protected by a full declarative unmanaged code demand, which covers security on the methods.")]
[module: SuppressMessage("Microsoft.Globalization", "CA1303:DoNotPassLiteralsAsLocalizedParameters", Scope = "member", Target = "System.Web.Handlers.TraceHandler.#CreateControlTable(System.Data.DataTable)", MessageId = "System.Web.Handlers.TraceHandler.AddCell(System.Web.UI.WebControls.TableRow,System.String)", Justification = @"[....]: HTML strings")]
[module: SuppressMessage("Microsoft.Globalization", "CA1303:DoNotPassLiteralsAsLocalizedParameters", Scope = "member", Target = "System.Web.Handlers.TraceHandler.#CreateControlTable(System.Data.DataTable)", MessageId = "System.Web.Handlers.TraceHandler.AddHeaderCell(System.Web.UI.WebControls.TableRow,System.String)", Justification = @"[....]: html strings")]
[module: SuppressMessage("Microsoft.Globalization", "CA1303:DoNotPassLiteralsAsLocalizedParameters", Scope = "member", Target = "System.Web.Handlers.TraceHandler.#CreateDetailsTable(System.Data.DataTable)", MessageId = "System.Web.Handlers.TraceHandler.AddHeaderCell(System.Web.UI.WebControls.TableRow,System.String)", Justification = @"[....]: html strings")]
[module: SuppressMessage("Microsoft.Globalization", "CA1303:DoNotPassLiteralsAsLocalizedParameters", Scope = "member", Target = "System.Web.Handlers.TraceHandler.#CreateTable(System.Data.DataTable,System.Boolean)", MessageId = "System.Web.Handlers.TraceHandler.AddCell(System.Web.UI.WebControls.TableRow,System.String)", Justification = @"[....]: HTML strings")]
[module: SuppressMessage("Microsoft.Globalization", "CA1303:DoNotPassLiteralsAsLocalizedParameters", Scope = "member", Target = "System.Web.Handlers.TraceHandler.#CreateTable(System.Data.DataTable,System.Boolean)", MessageId = "System.Web.Handlers.TraceHandler.AddHeaderCell(System.Web.UI.WebControls.TableRow,System.String)", Justification = @"[....]: html strings")]
[module: SuppressMessage("Microsoft.Usage", "CA2204:LiteralsShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Handlers.TraceHandler.#CreateTable(System.Data.DataTable,System.Boolean)", MessageId = "nbsp", Justification = @"[....]: HTML strings")]
[module: SuppressMessage("Microsoft.Globalization", "CA1303:DoNotPassLiteralsAsLocalizedParameters", Scope = "member", Target = "System.Web.Handlers.TraceHandler.#CreateTraceTable(System.Data.DataTable)", MessageId = "System.Web.Handlers.TraceHandler.AddHeaderCell(System.Web.UI.WebControls.TableRow,System.String)", Justification = @"[....]: html strings")]
[module: SuppressMessage("Microsoft.Globalization", "CA1303:DoNotPassLiteralsAsLocalizedParameters", Scope = "member", Target = "System.Web.Handlers.TraceHandler.#ShowRequests(System.Collections.IList)", MessageId = "System.Web.Handlers.TraceHandler.AddCell(System.Web.UI.WebControls.TableRow,System.String)", Justification = @"[....]: html strings")]
[module: SuppressMessage("Microsoft.Globalization", "CA1303:DoNotPassLiteralsAsLocalizedParameters", Scope = "member", Target = "System.Web.Handlers.TraceHandler.#ShowRequests(System.Collections.IList)", MessageId = "System.Web.Handlers.TraceHandler.AddHeaderCell(System.Web.UI.WebControls.TableRow,System.String)", Justification = @"[....]: html strings")]
[module: SuppressMessage("Microsoft.Usage", "CA2204:LiteralsShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Handlers.TraceHandler.#ShowRequests(System.Collections.IList)", MessageId = "axd", Justification = @"[....]: html strings")]
[module: SuppressMessage("Microsoft.Usage", "CA2204:LiteralsShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Handlers.TraceHandler.#ShowRequests(System.Collections.IList)", MessageId = "nbsp", Justification = @"[....]: html strings")]
[module: SuppressMessage("Microsoft.Naming", "CA1711:IdentifiersShouldNotHaveIncorrectSuffix", Scope = "type", Target = "System.Web.Hosting.AppDomainInfoEnum", Justification = @"[....]: reviewed and exluded in beta2lhsd")]
[module: SuppressMessage("Microsoft.Security", "CA2126:TypeLinkDemandsRequireInheritanceDemands", Scope = "type", Target = "System.Web.Hosting.AppDomainProtocolHandler", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.Hosting.AppDomainProtocolHandler.#InitializeLifetimeService()", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Hosting.AppDomainProtocolHandler.#InitializeLifetimeService()", Justification = @"[....]: Reviewed and exluded in beta2lhsd")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.Hosting.ApplicationHost.#CreateApplicationHost(System.Type,System.String,System.String)", Justification = @"[....]: These are protected by a full declarative unmanaged code demand, which covers security on the methods.")]
[module: SuppressMessage("Microsoft.Globalization", "CA1305:SpecifyIFormatProvider", Scope = "member", Target = "System.Web.Hosting.ApplicationHost.#CreateApplicationHost(System.Type,System.String,System.String)", Justification = @"[....]: ToString() is used to generate string IDs for internal use, it is not displayed to the user")]
[module: SuppressMessage("Microsoft.Naming", "CA1706:ShortAcronymsShouldBeUppercase", Scope = "member", Target = "System.Web.Hosting.ApplicationInfo.#ID", Justification = @"[....]: ""ID"" ok for ASP.NET")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.Hosting.ApplicationManager.#Close()", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Globalization", "CA1305:SpecifyIFormatProvider", Scope = "member", Target = "System.Web.Hosting.ApplicationManager.#ConstructAppDomainId(System.String)", Justification = @"[....]: ToString() is used to generate string IDs for internal use, it is not displayed to the user")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.Hosting.ApplicationManager.#CreateAppDomainWithHostingEnvironment(System.String,System.Web.Hosting.IApplicationHost,System.Web.Hosting.HostingEnvironmentParameters)", Justification = @"[....]: No security issues= non-ClsCompliant exceptions are ok to bubble up here.")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.Hosting.ApplicationManager.#CreateAppDomainWithHostingEnvironmentAndReportErrors(System.String,System.Web.Hosting.IApplicationHost,System.Web.Hosting.HostingEnvironmentParameters)", Justification = @"[....]: No security issues= non-ClsCompliant exceptions are ok to bubble up here.")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.Hosting.ApplicationManager.#CreateObject(System.String,System.Type,System.String,System.String,System.Boolean)", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.Hosting.ApplicationManager.#CreateObject(System.String,System.Type,System.String,System.String,System.Boolean,System.Boolean)", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.Hosting.ApplicationManager.#CreateObject(System.Web.Hosting.IApplicationHost,System.Type)", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.Hosting.ApplicationManager.#CreateObjectInternal(System.String,System.Type,System.Web.Hosting.IApplicationHost,System.Boolean)", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.Hosting.ApplicationManager.#CreateObjectWithDefaultAppHostAndAppId(System.String,System.String,System.Type,System.String&)", Justification = @"[....]: new method, will be used by web admin")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.Hosting.ApplicationManager.#CreateObjectWithDefaultAppHostAndAppId(System.String,System.Web.VirtualPath,System.Type,System.String&)", Justification = @"[....]: Called by reflection.")]
[module: SuppressMessage("Microsoft.Reliability", "CA2002:DoNotLockOnObjectsWithWeakIdentity", Scope = "member", Target = "System.Web.Hosting.ApplicationManager.#GetAppDomainInfos()", Justification = @"[....]: reviewed")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.Hosting.ApplicationManager.#GetApplicationManager()", Justification = @"[....]: per spec")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.Hosting.ApplicationManager.#GetObject(System.String,System.Type)", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.Hosting.ApplicationManager.#GetRunningApplications()", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Reliability", "CA2002:DoNotLockOnObjectsWithWeakIdentity", Scope = "member", Target = "System.Web.Hosting.ApplicationManager.#HostingEnvironmentShutdownInitiated(System.String,System.Web.Hosting.HostingEnvironment)", Justification = @"[....]: ignore")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Hosting.ApplicationManager.#InitializeLifetimeService()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.Hosting.ApplicationManager.#Open()", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.Hosting.ApplicationManager.#ShutdownAll()", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.Hosting.ApplicationManager.#ShutdownApplication(System.String)", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.Hosting.ApplicationManager.#StopObject(System.String,System.Type)", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.Hosting.AppManagerAppDomainFactory.#Create(System.String,System.String)", Justification = @"[....]: No security issues= non-ClsCompliant exceptions are ok to bubble up here.")]
[module: SuppressMessage("Microsoft.Performance", "CA1812:AvoidUninstantiatedInternalClasses", Scope = "type", Target = "System.Web.Hosting.ContextBase", Justification = @"[....]: static methods are used")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Hosting.ContextBase.#SwitchContext(System.Object)", Justification = @"[....]: from whidbey")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope = "type", Target = "System.Web.Hosting.HostingEnvironment", Justification = @"[....]: HostingEnvironment has the lifetime of app domain and is never disposed before app domain is gone")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.Hosting.HostingEnvironment.#.ctor()", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope = "member", Target = "System.Web.Hosting.HostingEnvironment.#_configToken", Justification = @"[....]: HostingEnvironment (which is never GC'd) controls the lifetime of this handle")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Hosting.HostingEnvironment.#get_AppConfigPath()", Justification = @"[....]: If ASP.NET is not hosted, and thus the link demand not satisifed, this code path is not followed.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Hosting.HostingEnvironment.#get_AppDomainsCount()", Justification = @"[....]: AspNet Link Demand is on all public classes in System.Web")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.Hosting.HostingEnvironment.#get_ApplicationHost()", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Naming", "CA1706:ShortAcronymsShouldBeUppercase", Scope = "member", Target = "System.Web.Hosting.HostingEnvironment.#ApplicationID", Justification = @"[....]: ID ok for ASP.NET (from Phuffs comments on similar rules)")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Hosting.HostingEnvironment.#get_ApplicationIdentityToken()", Justification = @"[....]: config system classes don't have the demand for apsnethostingpermisiion but still calls into impersonation code - this is ok")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Hosting.HostingEnvironment.#get_ApplicationVirtualPath()", Justification = @"[....]: In cases where HostingEnvironment methods are called and the LinkDemand is not satisfied, the methods return null or 0.")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.Hosting.HostingEnvironment.#Impersonate()", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.Hosting.HostingEnvironment.#Impersonate(System.IntPtr)", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.Hosting.HostingEnvironment.#Impersonate(System.IntPtr,System.String)", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.Hosting.HostingEnvironment.#Initialize(System.Web.Hosting.ApplicationManager,System.Web.Hosting.IApplicationHost,System.Web.Configuration.IConfigMapPathFactory,System.Web.Hosting.HostingEnvironmentParameters)", Justification = @"[....]: No security issues= non-ClsCompliant exceptions are ok to bubble up here.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Hosting.HostingEnvironment.#InitializeLifetimeService()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.Hosting.HostingEnvironment.#InitiateShutdown()", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Globalization", "CA1303:DoNotPassLiteralsAsLocalizedParameters", Scope = "member", Target = "System.Web.Hosting.HostingEnvironment.#InitiateShutdownInternal()", MessageId = "System.Web.HttpRuntime.SetShutdownReason(System.Web.ApplicationShutdownReason,System.String)", Justification = @"[....]: This is only used internally.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Hosting.HostingEnvironment.#get_IsHosted()", Justification = @"[....]: In cases where HostingEnvironment methods are called and the LinkDemand is not satisfied, the methods return null or 0.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Hosting.HostingEnvironment.#MapPathInternal(System.String)", Justification = @"[....]: AspNet Link Demand is on all public classes in System.Web")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Hosting.HostingEnvironment.#MapPathInternal(System.String,System.Boolean)", Justification = @"[....]: When the LinkDemand is not satisfied, the method returns either null or the value passed in, so there is no security vulnerability.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Hosting.HostingEnvironment.#MapPathInternal(System.Web.VirtualPath,System.Boolean)", Justification = @"[....]: This was already excluded but popped up again because of small signature change.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Hosting.HostingEnvironment.#RegisterObject(System.Web.Hosting.IRegisteredObject)", Justification = @"[....]: AspNet Link Demand is on all public classes in System.Web")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.Hosting.HostingEnvironment.#RegisterObject(System.Web.Hosting.IRegisteredObject)", Justification = @"[....]: The method security is a full demand of the same permission the class's link demand covers.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Hosting.HostingEnvironment.#get_SiteID()", Justification = @"[....]: In cases where HostingEnvironment methods are called and the LinkDemand is not satisfied, the methods return null or 0.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Hosting.HostingEnvironment.#get_SiteName()", Justification = @"[....]: AspNet Link Demand is on all public classes in System.Web")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Hosting.HostingEnvironment.#get_SiteNameNoDemand()", Justification = @"[....]: In cases where HostingEnvironment methods are called and the LinkDemand is not satisfied, the methods return null or 0.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Hosting.HostingEnvironment.#UnregisterObject(System.Web.Hosting.IRegisteredObject)", Justification = @"[....]: AspNet Link Demand is on all public classes in System.Web")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.Hosting.HostingEnvironment.#UnregisterObject(System.Web.Hosting.IRegisteredObject)", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Usage", "CA2235:MarkAllNonSerializableFields", Scope = "member", Target = "System.Web.Hosting.HostingEnvironmentParameters.#_hostingFlags", Justification = @"[....]: This is an fxcop bug (403281).  The field noted above actually is serializable because it's an enum.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "type", Target = "System.Web.Hosting.IAdphManager", MessageId = "Adph", Justification = @"[....]: Reviewed and excluded from beta2lhsd")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.Hosting.IAppDomainInfo.#GetId()", Justification = @"[....]: Reviewed and exluded in beta2lhsd, interfaces used with native COM clients, methods preferred after review")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.Hosting.IAppDomainInfo.#GetPhysicalPath()", Justification = @"[....]: Reviewed and exluded in beta2lhsd, interfaces used with native COM clients, methods preferred after review")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.Hosting.IAppDomainInfo.#GetSiteId()", Justification = @"[....]: Reviewed and exluded in beta2lhsd, interfaces used with native COM clients, methods preferred after review")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.Hosting.IAppDomainInfo.#GetVirtualPath()", Justification = @"[....]: Reviewed and exluded in beta2lhsd, interfaces used with native COM clients, methods preferred after review")]
[module: SuppressMessage("Microsoft.Naming", "CA1711:IdentifiersShouldNotHaveIncorrectSuffix", Scope = "type", Target = "System.Web.Hosting.IAppDomainInfoEnum", Justification = @"[....]: reviewed and exluded in beta2lhsd")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.Hosting.IAppDomainInfoEnum.#GetData()", Justification = @"[....]: Reviewed and exluded in beta2lhsd, interfaces used with native COM clients, methods preferred after review")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.Hosting.IApplicationHost.#GetConfigMapPathFactory()", Justification = @"[....]: This interface has a native counterpart, so using a method here is better.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.Hosting.IApplicationHost.#GetConfigToken()", Justification = @"[....]: This WebHost interface is used to Interop only - it is implemented by IIS in unmanaged code")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.Hosting.IApplicationHost.#GetPhysicalPath()", Justification = @"[....]: This WebHost interface is used to Interop only - it is implemented by IIS in unmanaged code")]
[module: SuppressMessage("Microsoft.Naming", "CA1706:ShortAcronymsShouldBeUppercase", Scope = "member", Target = "System.Web.Hosting.IApplicationHost.#GetSiteID()", Justification = @"[....]: In System.Web, we use ID, not Id.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.Hosting.IApplicationHost.#GetSiteID()", Justification = @"[....]: In System.Web, we use ID, not Id.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.Hosting.IApplicationHost.#GetSiteName()", Justification = @"[....]: This WebHost interface is used to Interop only - it is implemented by IIS in unmanaged code")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.Hosting.IApplicationHost.#GetVirtualPath()", Justification = @"[....]: Reviewed and exluded in beta2lhsd, interfaces used with native COM clients, methods preferred after review")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Hosting.IIS7WorkerRequest.#InitAppVars()", Justification = @"[....]: Reviewed and exluded in beta2lhsd, porting that to rtmlhs")]
[module: SuppressMessage("Microsoft.Design", "CA1021:AvoidOutParameters", Scope = "member", Target = "System.Web.Hosting.IListenerChannelCallback.#GetBlob(System.Byte[],System.Int32&)", MessageId = "0#", Justification = @"[....]: Reviewed and excluded in beta2lhsd, for efficient marshalling with native code")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.Hosting.IListenerChannelCallback.#GetBlobLength()", Justification = @"[....]: Reviewed and exluded in beta2lhsd, interfaces used with native COM clients, methods preferred after review")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.Hosting.IListenerChannelCallback.#GetId()", Justification = @"[....]: Reviewed and exluded in beta2lhsd, interfaces used with native COM clients, methods preferred after review")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.Hosting.IPipelineRuntime.#GetDisposeDelegate()", Justification = @"[....]: Reviewed and exluded in beta2lhsd, interfaces used with native COM clients, methods preferred after review")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.Hosting.IPipelineRuntime.#GetExecuteDelegate()", Justification = @"[....]: Reviewed and exluded in beta2lhsd, interfaces used with native COM clients, methods preferred after review")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.Hosting.IPipelineRuntime.#GetRoleDelegate()", Justification = @"[....]: Reviewed and exluded in beta2lhsd, interfaces used with native COM clients, methods preferred after review")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "type", Target = "System.Web.Hosting.IPphManager", MessageId = "Pph", Justification = @"[....]: Reviewed and excluded from beta2lhsd")]
[module: SuppressMessage("Microsoft.Design", "CA1021:AvoidOutParameters", Scope = "member", Target = "System.Web.Hosting.IProcessHost.#EnumerateAppDomains(System.Web.Hosting.IAppDomainInfoEnum&)", MessageId = "0#", Justification = @"[....]: Reviewed and excluded in beta2lhsd, for efficient marshalling with native code")]
[module: SuppressMessage("Microsoft.Design", "CA1021:AvoidOutParameters", Scope = "member", Target = "System.Web.Hosting.IProcessHost.#StartApplication(System.String,System.String,System.Object&)", MessageId = "2#", Justification = @"[....]: Reviewed and excluded in beta2lhsd, for efficient marshalling with native code")]
[module: SuppressMessage("Microsoft.Security", "CA2118:ReviewSuppressUnmanagedCodeSecurityUsage", Scope = "type", Target = "System.Web.Hosting.IProcessHostSupportFunctions", Justification = @"[....]: We need to use unmanaged code to access native configuration APIs.")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "member", Target = "System.Web.Hosting.IProcessHostSupportFunctions.#GetAppHostConfigFilename()", MessageId = "Filename", Justification = @"[....]: Reviewed and exluded in beta2lhsd, porting that change to rtmlhs")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.Hosting.IProcessHostSupportFunctions.#GetAppHostConfigFilename()", Justification = @"[....]: Reviewed and exluded in beta2lhsd, interfaces used with native COM clients, methods preferred after review")]
[module: SuppressMessage("Microsoft.Design", "CA1021:AvoidOutParameters", Scope = "member", Target = "System.Web.Hosting.IProcessHostSupportFunctions.#GetApplicationProperties(System.String,System.String&,System.String&,System.String&,System.String&)", MessageId = "1#", Justification = @"[....]: Reviewed and excluded in beta2lhsd, for efficient marshalling with native code")]
[module: SuppressMessage("Microsoft.Design", "CA1021:AvoidOutParameters", Scope = "member", Target = "System.Web.Hosting.IProcessHostSupportFunctions.#GetApplicationProperties(System.String,System.String&,System.String&,System.String&,System.String&)", MessageId = "2#", Justification = @"[....]: Reviewed and excluded in beta2lhsd, for efficient marshalling with native code")]
[module: SuppressMessage("Microsoft.Design", "CA1021:AvoidOutParameters", Scope = "member", Target = "System.Web.Hosting.IProcessHostSupportFunctions.#GetApplicationProperties(System.String,System.String&,System.String&,System.String&,System.String&)", MessageId = "3#", Justification = @"[....]: Reviewed and excluded in beta2lhsd, for efficient marshalling with native code")]
[module: SuppressMessage("Microsoft.Design", "CA1021:AvoidOutParameters", Scope = "member", Target = "System.Web.Hosting.IProcessHostSupportFunctions.#GetApplicationProperties(System.String,System.String&,System.String&,System.String&,System.String&)", MessageId = "4#", Justification = @"[....]: Reviewed and excluded in beta2lhsd, for efficient marshalling with native code")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.Hosting.IProcessHostSupportFunctions.#GetNativeConfigurationSystem()", Justification = @"[....]: Reviewed and exluded in beta2lhsd, interfaces used with native COM clients, methods preferred after review")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "member", Target = "System.Web.Hosting.IProcessHostSupportFunctions.#GetRootWebConfigFilename()", MessageId = "Filename", Justification = @"[....]: Reviewed and exluded in beta2lhsd, porting that change to rtmlhs")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.Hosting.IProcessHostSupportFunctions.#GetRootWebConfigFilename()", Justification = @"[....]: Reviewed and exluded in beta2lhsd, interfaces used with native COM clients, methods preferred after review")]
[module: SuppressMessage("Microsoft.Design", "CA1021:AvoidOutParameters", Scope = "member", Target = "System.Web.Hosting.IProcessHostSupportFunctions.#MapPath(System.String,System.String,System.String&)", MessageId = "2#", Justification = @"[....]: Reviewed and excluded in beta2lhsd, for efficient marshalling with native code")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope = "member", Target = "System.Web.Hosting.ISAPIApplicationHost.#System.Web.Hosting.IApplicationHost.GetConfigToken()", Justification = @"[....]: no outer catch around the code to display the nice error to the client (would lead to server unavailable)")]
[module: SuppressMessage("Microsoft.Reliability", "CA2001:AvoidCallingProblematicMethods", Scope = "member", Target = "System.Web.Hosting.ISAPIRuntime.#DoGCCollect()", MessageId = "System.GC.Collect", Justification = @"[....]: Required by partners using the API so it's present in spite of risks.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Hosting.ISAPIRuntime.#InitializeLifetimeService()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Hosting.ISAPIRuntime.#System.Web.Hosting.IRegisteredObject.Stop(System.Boolean)", Justification = @"[....]: These paths were verified by [....].")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Hosting.ISAPIRuntime.#System.Web.Hosting.IRegisteredObject.Stop(System.Boolean)", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope = "type", Target = "System.Web.Hosting.ISAPIWorkerRequest", Justification = @"[....]: The lifetime of this object is managed explicitly and is tied to the request object.  Adding IDisposable isn't viable for Whidbey.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Hosting.ISAPIWorkerRequest.#.ctor(System.IntPtr)", Justification = @"[....]: These paths were verified by [....].")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope = "member", Target = "System.Web.Hosting.ISAPIWorkerRequest.#_ecb", Justification = @"[....]: this is not an OS resource handle, but a pointer to a structure supplied by IIS.  IIS controls its lifetime,  ASP.NET neither allocate nor free it.")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope = "member", Target = "System.Web.Hosting.ISAPIWorkerRequest.#_token", Justification = @"[....]: This handle comes from IIS and IIS does its lifetime management.  Potentially we could've duplicated it and stored as a SafeHandle (a little risky) but there is already a public API that exposes it as IntPtr.")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope = "member", Target = "System.Web.Hosting.ISAPIWorkerRequest.#CallEndOfRequestCallbackOnceAfterAllIoComplete()", Justification = @"[....]: no outer catch")]
[module: SuppressMessage("Microsoft.Globalization", "CA1305:SpecifyIFormatProvider", Scope = "member", Target = "System.Web.Hosting.ISAPIWorkerRequest.#GetKnownRequestHeader(System.Int32)", Justification = @"[....]: the default behavior is the desired one")]
[module: SuppressMessage("Microsoft.Globalization", "CA1305:SpecifyIFormatProvider", Scope = "member", Target = "System.Web.Hosting.ISAPIWorkerRequest.#GetLocalPort()", Justification = @"[....]: the incoming string is from IIS and it does not contain anything but digits")]
[module: SuppressMessage("Microsoft.Globalization", "CA1305:SpecifyIFormatProvider", Scope = "member", Target = "System.Web.Hosting.ISAPIWorkerRequest.#SendCalculatedContentLength(System.Int32)", Justification = @"[....]: the default behavior is the desired one")]
[module: SuppressMessage("Microsoft.Globalization", "CA1305:SpecifyIFormatProvider", Scope = "member", Target = "System.Web.Hosting.ISAPIWorkerRequest.#SendStatus(System.Int32,System.String)", Justification = @"[....]: the default behavior is the desired one")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope = "member", Target = "System.Web.Hosting.ISAPIWorkerRequest.#UnlockCachedResponseBytesOnceAfterIoComplete()", Justification = @"[....]: no outer catch")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope = "type", Target = "System.Web.Hosting.ISAPIWorkerRequestInProcForIIS6", Justification = @"[....]: this is by design")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope = "member", Target = "System.Web.Hosting.ISAPIWorkerRequestInProcForIIS6.#_entity", Justification = @"[....]: this is by design")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope = "type", Target = "System.Web.Hosting.MemoryBytes", Justification = @"[....]: The lifetime of this object is managed explicitly and is tied to the request object.  Adding IDisposable isn't viable for Whidbey.")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope = "member", Target = "System.Web.Hosting.MemoryBytes.#_fileHandle", Justification = @"[....]: Dmitry did not want HandleRef to be used here.")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope = "member", Target = "System.Web.Hosting.MemoryBytes.#_intptrData", Justification = @"[....]: this is not an OS resource handle, but an memory address of unmanaged memory. It is neither allocated nor freed in managed code.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Hosting.PipelineRuntime.#DisposeHandler(System.IntPtr)", Justification = @"[....]: Reviewed and exluded in beta2lhsd, porting that to rtmlhs")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Hosting.PipelineRuntime.#GetDisposeDelegate()", Justification = @"[....]: Reviewed and exluded in beta2lhsd, porting that to rtmlhs")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Hosting.PipelineRuntime.#GetExecuteDelegate()", Justification = @"[....]: Reviewed and exluded in beta2lhsd, porting that to rtmlhs")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Hosting.PipelineRuntime.#GetRoleDelegate()", Justification = @"[....]: Reviewed and exluded in beta2lhsd, porting that to rtmlhs")]
[module: SuppressMessage("Microsoft.Globalization", "CA1303:DoNotPassLiteralsAsLocalizedParameters", Scope = "member", Target = "System.Web.Hosting.PipelineRuntime.#RemoveThisAppDomainFromUnmanagedTable()", MessageId = "System.Web.HttpRuntime.AddAppDomainTraceMessage(System.String)", Justification = @"[....]: this is for internal use")]
[module: SuppressMessage("Microsoft.Usage", "CA2204:LiteralsShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Hosting.PipelineRuntime.#RemoveThisAppDomainFromUnmanagedTable()", MessageId = "Mgd", Justification = @"[....]: this if for internal use")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Hosting.PipelineRuntime.#StopProcessing()", Justification = @"[....]: Reviewed and exluded in beta2lhsd, porting that to rtmlhs")]
[module: SuppressMessage("Microsoft.Globalization", "CA1303:DoNotPassLiteralsAsLocalizedParameters", Scope = "member", Target = "System.Web.Hosting.PipelineRuntime.#StopProcessing()", MessageId = "System.Web.HttpRuntime.SetShutdownReason(System.Web.ApplicationShutdownReason,System.String)", Justification = @"[....]: ok")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Hosting.PipelineRuntime.#UnwrapContext(System.IntPtr)", Justification = @"[....]: Reviewed and exluded in beta2lhsd, porting that to rtmlhs")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.Hosting.ProcessHost.#InitializeLifetimeService()", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Hosting.ProcessHost.#InitializeLifetimeService()", Justification = @"[....]: Reviewed and exluded in beta2lhsd")]
[module: SuppressMessage("Microsoft.Reliability", "CA2002:DoNotLockOnObjectsWithWeakIdentity", Scope = "member", Target = "System.Web.Hosting.ProcessHost.#Shutdown()", Justification = @"[....]: The goal of these locks is for cross-app domain synchronization.  May need further review but excluding for now")]
[module: SuppressMessage("Microsoft.Reliability", "CA2002:DoNotLockOnObjectsWithWeakIdentity", Scope = "member", Target = "System.Web.Hosting.ProcessHost.#StartAppDomainProtocolListenerChannel(System.String,System.String,System.Web.Hosting.IListenerChannelCallback)", Justification = @"[....]: The goal of these locks is for cross-app domain synchronization.  May need further review but excluding for now")]
[module: SuppressMessage("Microsoft.Reliability", "CA2002:DoNotLockOnObjectsWithWeakIdentity", Scope = "member", Target = "System.Web.Hosting.ProcessHost.#StartApplication(System.String,System.String,System.Object&)", Justification = @"[....]: The goal of these locks is for cross-app domain synchronization.  May need further review but excluding for now")]
[module: SuppressMessage("Microsoft.Reliability", "CA2002:DoNotLockOnObjectsWithWeakIdentity", Scope = "member", Target = "System.Web.Hosting.ProcessHost.#StartProcessProtocolListenerChannel(System.String,System.Web.Hosting.IListenerChannelCallback)", Justification = @"[....]: The goal of these locks is for cross-app domain synchronization.  May need further review but excluding for now")]
[module: SuppressMessage("Microsoft.Reliability", "CA2002:DoNotLockOnObjectsWithWeakIdentity", Scope = "member", Target = "System.Web.Hosting.ProcessHost.#StopAppDomainProtocol(System.String,System.String,System.Boolean)", Justification = @"[....]: The goal of these locks is for cross-app domain synchronization.  May need further review but excluding for now")]
[module: SuppressMessage("Microsoft.Reliability", "CA2002:DoNotLockOnObjectsWithWeakIdentity", Scope = "member", Target = "System.Web.Hosting.ProcessHost.#StopAppDomainProtocolListenerChannel(System.String,System.String,System.Int32,System.Boolean)", Justification = @"[....]: The goal of these locks is for cross-app domain synchronization.  May need further review but excluding for now")]
[module: SuppressMessage("Microsoft.Reliability", "CA2002:DoNotLockOnObjectsWithWeakIdentity", Scope = "member", Target = "System.Web.Hosting.ProcessHost.#StopProcessProtocol(System.String,System.Boolean)", Justification = @"[....]: The goal of these locks is for cross-app domain synchronization.  May need further review but excluding for now")]
[module: SuppressMessage("Microsoft.Reliability", "CA2002:DoNotLockOnObjectsWithWeakIdentity", Scope = "member", Target = "System.Web.Hosting.ProcessHost.#StopProcessProtocolListenerChannel(System.String,System.Int32,System.Boolean)", Justification = @"[....]: The goal of these locks is for cross-app domain synchronization.  May need further review but excluding for now")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.Hosting.ProcessHostFactoryHelper.#InitializeLifetimeService()", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Hosting.ProcessHostFactoryHelper.#InitializeLifetimeService()", Justification = @"[....]: Reviewed and exluded in beta2lhsd")]
[module: SuppressMessage("Microsoft.Security", "CA2126:TypeLinkDemandsRequireInheritanceDemands", Scope = "type", Target = "System.Web.Hosting.ProcessProtocolHandler", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.Hosting.ProcessProtocolHandler.#InitializeLifetimeService()", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Hosting.ProcessProtocolHandler.#InitializeLifetimeService()", Justification = @"[....]: Reviewed and exluded in beta2lhsd")]
[module: SuppressMessage("Microsoft.Naming", "CA1709:IdentifiersShouldBeCasedCorrectly", Scope = "member", Target = "System.Web.Hosting.ProcessProtocolHandler.#StartListenerChannel(System.Web.Hosting.IListenerChannelCallback,System.Web.Hosting.IAdphManager)", MessageId = "1#", Justification = @"[....]: Reviewed and excluded from beta2lhsd")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Hosting.ProcessProtocolHandler.#StartListenerChannel(System.Web.Hosting.IListenerChannelCallback,System.Web.Hosting.IAdphManager)", MessageId = "Adph", Justification = @"[....]: Reviewed and excluded from beta2lhsd")]
[module: SuppressMessage("Microsoft.Performance", "CA1812:AvoidUninstantiatedInternalClasses", Scope = "type", Target = "System.Web.Hosting.RecyclableArrayHelper", Justification = @"[....]: BAD RULE: the class has static methods that are called")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope = "type", Target = "System.Web.Hosting.ServerVarCharBuffer", Justification = @"[....]: The lifetime of this object is managed explicitly and is tied to the request object.  Adding IDisposable isn't viable for Whidbey.")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope = "member", Target = "System.Web.Hosting.ServerVarCharBuffer.#_pinnedAddr", Justification = @"[....]: this is not an OS resource handle, but an memory address of a pinned object (the duration of pinning is controlled ASP.NET)")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Hosting.ServerVarCharBuffer.#Dispose()", Justification = @"[....]: Reviewed and exluded in beta2lhsd, porting that to rtmlhs")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Hosting.ServerVarCharBuffer.#get_PinnedAddress()", Justification = @"[....]: Reviewed and exluded in beta2lhsd, porting that to rtmlhs")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Hosting.SimpleApplicationHost.#InitializeLifetimeService()", Justification = @"[....]: Reviewed and exluded in beta2lhsd")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.Hosting.SimpleApplicationHost.#System.Web.Hosting.IApplicationHost.GetConfigToken()", Justification = @"[....]: We expose corresponding protected properties to derived classes.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.Hosting.SimpleApplicationHost.#System.Web.Hosting.IApplicationHost.GetPhysicalPath()", Justification = @"[....]: We expose corresponding protected properties to derived classes.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.Hosting.SimpleApplicationHost.#System.Web.Hosting.IApplicationHost.GetSiteID()", Justification = @"[....]: Following the pattern of GetSiteName.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.Hosting.SimpleApplicationHost.#System.Web.Hosting.IApplicationHost.GetSiteName()", Justification = @"[....]: We expose corresponding protected properties to derived classes.")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.Hosting.SimpleWorkerRequest.#.ctor(System.String,System.String,System.IO.TextWriter)", Justification = @"[....]: These are protected by a full declarative unmanaged code demand, which covers security on the methods.")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.Hosting.SimpleWorkerRequest.#.ctor(System.String,System.String,System.String,System.String,System.IO.TextWriter)", Justification = @"[....]: These are protected by a full declarative unmanaged code demand, which covers security on the methods.")]
[module: SuppressMessage("Microsoft.Security", "CA2118:ReviewSuppressUnmanagedCodeSecurityUsage", Scope = "member", Target = "System.Web.Hosting.UnsafeIISMethods.#MgdEtwGetTraceConfig(System.IntPtr,System.Boolean&,System.Int32&,System.Int32&)", Justification = @"[....]: ok")]
[module: SuppressMessage("Microsoft.Security", "CA2118:ReviewSuppressUnmanagedCodeSecurityUsage", Scope = "member", Target = "System.Web.Hosting.UnsafeIISMethods.#MgdGetApplicationInfo(System.IntPtr,System.IntPtr&,System.Int32&,System.IntPtr&,System.Int32&)", Justification = @"[....]: reviewed")]
[module: SuppressMessage("Microsoft.Security", "CA2118:ReviewSuppressUnmanagedCodeSecurityUsage", Scope = "member", Target = "System.Web.Hosting.UnsafeIISMethods.#MgdGetCurrentModuleIndex(System.IntPtr)", Justification = @"[....]: reviewed as per other pipeline runtime entry points")]
[module: SuppressMessage("Microsoft.Security", "CA2118:ReviewSuppressUnmanagedCodeSecurityUsage", Scope = "member", Target = "System.Web.Hosting.UnsafeIISMethods.#MgdGetCurrentNotification(System.IntPtr)", Justification = @"[....]: Reviewed and exluded in beta2lhsd, porting changes")]
[module: SuppressMessage("Microsoft.Security", "CA2118:ReviewSuppressUnmanagedCodeSecurityUsage", Scope = "member", Target = "System.Web.Hosting.UnsafeIISMethods.#MgdGetNextNotification(System.IntPtr,System.Web.RequestNotificationStatus)", Justification = @"[....]: Reviewed and exluded in beta2lhsd, porting changes")]
[module: SuppressMessage("Microsoft.Security", "CA2118:ReviewSuppressUnmanagedCodeSecurityUsage", Scope = "member", Target = "System.Web.Hosting.UnsafeIISMethods.#MgdGetRequestTraceGuid(System.IntPtr,System.Guid&)", Justification = @"[....]: Reviewed and exluded in beta2lhsd, porting changes")]
[module: SuppressMessage("Microsoft.Security", "CA2118:ReviewSuppressUnmanagedCodeSecurityUsage", Scope = "member", Target = "System.Web.Hosting.UnsafeIISMethods.#MgdIsCurrentNotificationPost(System.IntPtr)", Justification = @"[....]: Reviewed and exluded in beta2lhsd, porting changes")]
[module: SuppressMessage("Microsoft.Security", "CA2118:ReviewSuppressUnmanagedCodeSecurityUsage", Scope = "member", Target = "System.Web.Hosting.UnsafeIISMethods.#MgdRegisterEventSubscription(System.IntPtr,System.String,System.Web.RequestNotification,System.Web.RequestNotification,System.String,System.String,System.IntPtr,System.Boolean)", Justification = @"[....]: k")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Hosting.VirtualFileBase.#InitializeLifetimeService()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Hosting.VirtualPathProvider.#InitializeLifetimeService()", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Design", "CA1025:ReplaceRepetitiveArgumentsWithParamsArray", Scope = "member", Target = "System.Web.Mail.SmtpMail.#Send(System.String,System.String,System.String,System.String)", Justification = @"[....]: Method is more usable with named parameters than a string array.  Also would be a breaking change.")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.Mail.SmtpMail+LateBoundAccessHelper.#CallMethod(System.Object,System.String,System.Object[])", Justification = @"[....]: Disregarding this rule because it doesn't make sense for our code.")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.Mail.SmtpMail+LateBoundAccessHelper.#GetProp(System.Object,System.String)", Justification = @"[....]: Disregarding this rule because it doesn't make sense for our code.")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope = "member", Target = "System.Web.Mail.SmtpMail+LateBoundAccessHelper.#get_LateBoundType()", Justification = @"[....]: Per DmityrR, we should exclude all violations of this rule since the framework makes no guarantee about what exceptions may be thrown.")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.Mail.SmtpMail+LateBoundAccessHelper.#SetProp(System.Object,System.String,System.Object)", Justification = @"[....]: Disregarding this rule because it doesn't make sense for our code.")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.Mail.SmtpMail+LateBoundAccessHelper.#SetProp(System.Object,System.String,System.Object,System.Object)", Justification = @"[....]: Disregarding this rule because it doesn't make sense for our code.")]
[module: SuppressMessage("Microsoft.Usage", "CA2208:InstantiateArgumentExceptionsCorrectly", Scope = "member", Target = "System.Web.Mail.SmtpMail+LateBoundAccessHelper.#SetProp(System.Type,System.Object,System.String,System.Object)", Justification = @"[....]: ok")]
[module: SuppressMessage("Microsoft.Usage", "CA2208:InstantiateArgumentExceptionsCorrectly", Scope = "member", Target = "System.Web.Mail.SmtpMail+LateBoundAccessHelper.#SetProp(System.Type,System.Object,System.String,System.Object,System.Object)", Justification = @"[....]: ok")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Management.EventNotificationType.#Unbuffered", Justification = @"[....]: The word 'unbuffered' is used frequently in other computer document.  E.g. there are 79 occurence of this word in MSDN library.  Will ask PM to think of a better name, if possible.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "type", Target = "System.Web.Management.IRegiisUtility", Justification = @"[....]: This was excluded before the namespace change")]
[module: SuppressMessage("Microsoft.Design", "CA1021:AvoidOutParameters", Scope = "member", Target = "System.Web.Management.IRegiisUtility.#ProtectedConfigAction(System.Int64,System.String,System.String,System.String,System.String,System.String,System.String,System.Int32,System.IntPtr&)", MessageId = "8#", Justification = @"[....]: These shipped in Whidbey and we are simply reverting them to their original state.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Management.IRegiisUtility.#ProtectedConfigAction(System.Int64,System.String,System.String,System.String,System.String,System.String,System.String,System.Int32,System.IntPtr&)", MessageId = "csp", Justification = @"[....]: These shipped in Whidbey and we are simply reverting them to their original state.")]
[module: SuppressMessage("Microsoft.Design", "CA1021:AvoidOutParameters", Scope = "member", Target = "System.Web.Management.IRegiisUtility.#RegisterAsnetMmcAssembly(System.Int32,System.String,System.String,System.IntPtr&)", MessageId = "3#", Justification = @"[....]: IRegiisUtility is an internal interface used by aspnet_regiis.exe and Asp.net MMC")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Management.IRegiisUtility.#RegisterAsnetMmcAssembly(System.Int32,System.String,System.String,System.IntPtr&)", MessageId = "Asnet", Justification = @"[....]: IRegiisUtility is an internal interface used by aspnet_regiis.exe and Asp.net MMC")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Management.IRegiisUtility.#RegisterAsnetMmcAssembly(System.Int32,System.String,System.String,System.IntPtr&)", MessageId = "Mmc", Justification = @"[....]: IRegiisUtility is an internal interface used by aspnet_regiis.exe and Asp.net MMC")]
[module: SuppressMessage("Microsoft.Design", "CA1021:AvoidOutParameters", Scope = "member", Target = "System.Web.Management.IRegiisUtility.#RegisterSystemWebAssembly(System.Int32,System.IntPtr&)", MessageId = "1#", Justification = @"[....]: IRegiisUtility is an internal interface used by aspnet_regiis.exe and Asp.net MMC")]
[module: SuppressMessage("Microsoft.Design", "CA1021:AvoidOutParameters", Scope = "member", Target = "System.Web.Management.IRegiisUtility.#RemoveBrowserCaps(System.IntPtr&)", MessageId = "0#", Justification = @"[....]: It's an ""internal"" method used by aspnet_regiis.  The 'out' param is needed.")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.Management.MailWebEventProvider.#SendMail(System.Net.Mail.MailMessage)", Justification = @"[....]: It is okay to not catch non compliant exceptions in this case (No security implications)")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.Management.MailWebEventProvider.#SendMail(System.Net.Mail.MailMessage)", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "type", Target = "System.Web.Management.RegiisUtility", Justification = @"[....]: This was excluded before the namespace change")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.Management.RegiisUtility.#RegisterAsnetMmcAssembly(System.Int32,System.String,System.String,System.IntPtr&)", Justification = @"[....]: It is okay to not catch non compliant exceptions. There is no security clean up involved and the whole purpose for catching the exception if just to get the exception info to return to caller.")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.Management.RegiisUtility.#RegisterAsnetMmcAssembly(System.Int32,System.String,System.String,System.IntPtr&)", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.Management.RegiisUtility.#RegisterSystemWebAssembly(System.Int32,System.IntPtr&)", Justification = @"[....]: It is fine to not catch non compliant exceptions, it does not present a security risk")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.Management.RegiisUtility.#RemoveBrowserCaps(System.IntPtr&)", Justification = @"[....]: It is fine to not catch non compliant exceptions in this case.  There is no security clean up involved.")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.Management.SqlExecutionException.#GetObjectData(System.Runtime.Serialization.SerializationInfo,System.Runtime.Serialization.StreamingContext)", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Usage", "CA2217:DoNotMarkEnumsWithFlags", Scope = "type", Target = "System.Web.Management.SqlFeatures", Justification = @"[....]: This was excluded before the namespace change")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.Management.SqlServices.#get_ApplicationServiceTables()", Justification = @"[....]: called by suite")]
[module: SuppressMessage("Microsoft.Security", "CA2100:ReviewSqlQueriesForSecurityVulnerabilities", Scope = "member", Target = "System.Web.Management.SqlServices.#ExecuteFile(System.String,System.String,System.String,System.String,System.Data.SqlClient.SqlConnection,System.Boolean,System.Boolean,System.Web.Management.SessionStateType)", Justification = @"[....]: No user input")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.Management.SqlServices.#GetSqlConnection(System.String,System.String,System.String,System.Boolean,System.String)", Justification = @"[....]: It is okay to not catch non compliant exceptions. There is no security clean up involved and the whole purpose for catching the exception if just to get the exception info to return to caller.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Management.SqlServices.#Install(System.String,System.String,System.String)", Justification = @"[....]: The callstack it contains is incorrect.")]
[module: SuppressMessage("Microsoft.Naming", "CA1720:AvoidTypeNamesInParameters", Scope = "member", Target = "System.Web.Management.SqlServices.#Install(System.String,System.Web.Management.SqlFeatures,System.String)", MessageId = "2#", Justification = @"[....]: This was excluded before the namespace change")]
[module: SuppressMessage("Microsoft.Naming", "CA1720:AvoidTypeNamesInParameters", Scope = "member", Target = "System.Web.Management.SqlServices.#InstallSessionState(System.String,System.Web.Management.SessionStateType,System.String)", MessageId = "2#", Justification = @"[....]: This was excluded before the namespace change")]
[module: SuppressMessage("Microsoft.Naming", "CA1720:AvoidTypeNamesInParameters", Scope = "member", Target = "System.Web.Management.SqlServices.#Uninstall(System.String,System.Web.Management.SqlFeatures,System.String)", MessageId = "2#", Justification = @"[....]: This was excluded before the namespace change")]
[module: SuppressMessage("Microsoft.Naming", "CA1720:AvoidTypeNamesInParameters", Scope = "member", Target = "System.Web.Management.SqlServices.#UninstallSessionState(System.String,System.Web.Management.SessionStateType,System.String)", MessageId = "2#", Justification = @"[....]: This was excluded before the namespace change")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.Management.SqlWebEventProvider.#WriteToSQL(System.Web.Management.WebBaseEventCollection,System.Int32,System.DateTime)", Justification = @"[....]: It is okay to not catch non compliant exceptions. There is no security clean up involved and the whole purpose for catching the exception if just to get the exception info to return to caller.")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.Management.SqlWebEventProvider.#WriteToSQL(System.Web.Management.WebBaseEventCollection,System.Int32,System.DateTime)", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.Management.WebApplicationInformation.#GetMachineNameWithAssert()", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Design", "CA1052:StaticHolderTypesShouldBeSealed", Scope = "type", Target = "System.Web.Management.WebApplicationLifetimeEvent", Justification = @"[....]: This was excluded before the namespace change")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Management.WebApplicationLifetimeEvent.#IncrementPerfCounters()", MessageId = "Perf", Justification = @"[....]: IncrementPerfCounters is an internal method.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Management.WebBaseErrorEvent.#IncrementPerfCounters()", MessageId = "Perf", Justification = @"[....]: IncrementPerfCounters is an internal method.")]
[module: SuppressMessage("Microsoft.Naming", "CA1706:ShortAcronymsShouldBeUppercase", Scope = "member", Target = "System.Web.Management.WebBaseEvent.#EventID", Justification = @"[....]: ID ok for ASP.NET (from Phuffs comments on similar rules)")]
[module: SuppressMessage("Microsoft.Globalization", "CA1305:SpecifyIFormatProvider", Scope = "member", Target = "System.Web.Management.WebBaseEvent.#FormatResourceStringWithCache(System.String,System.String)", MessageId = "System.String.Format(System.String,System.Object)", Justification = @"NO_JUSTIFICATION_PROVIDED")]
[module: SuppressMessage("Microsoft.Performance", "CA1814:PreferJaggedArraysOverMultidimensional", Scope = "member", Target = "System.Web.Management.WebBaseEvent.#GetSystemEventTypeInfo(System.Int32,System.Int32,System.Int32,System.Web.Management.WebBaseEvent+SystemEventTypeInfo&,System.Web.Management.WebBaseEvent+SystemEventType&)", Justification = @"[....]: Multi-dimensional arrays are needed here for perf.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Management.WebBaseEvent.#IncrementPerfCounters()", MessageId = "Perf", Justification = @"[....]: IncrementPerfCounters is an internal method.")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.Management.WebBaseEvent.#Raise()", Justification = @"[....]: This was excluded before the namespace change")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.Management.WebBaseEvent.#Raise(System.Web.Management.WebBaseEvent)", Justification = @"[....]: This was excluded before the namespace change")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.Management.WebBaseEvent.#RaiseInternal(System.Web.Management.WebBaseEvent,System.Collections.ArrayList,System.Int32,System.Int32)", Justification = @"[....]: It is okay to not catch non compliant exceptions. There is no security clean up involved and the whole purpose for catching the exception if just to get the exception info to return to caller.")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.Management.WebBaseEvent.#RaiseSystemEventInternal(System.String,System.Object,System.Int32,System.Int32,System.Exception,System.String)", Justification = @"NO_JUSTIFICATION_PROVIDED")]
[module: SuppressMessage("Microsoft.Performance", "CA1814:PreferJaggedArraysOverMultidimensional", Scope = "member", Target = "System.Web.Management.WebBaseEvent.#s_eventCodeOccurrence", Justification = @"[....]: Multi-dimensional arrays are needed here for perf.")]
[module: SuppressMessage("Microsoft.Performance", "CA1814:PreferJaggedArraysOverMultidimensional", Scope = "member", Target = "System.Web.Management.WebBaseEvent.#s_eventCodeToSystemEventTypeMappings", Justification = @"[....]: Multi-dimensional arrays are needed here for perf.")]
[module: SuppressMessage("Microsoft.Design", "CA1035:ICollectionImplementationsHaveStronglyTypedMembers", Scope = "type", Target = "System.Web.Management.WebBaseEventCollection", Justification = @"[....]: This was excluded before the namespace change")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Management.WebErrorEvent.#IncrementPerfCounters()", MessageId = "Perf", Justification = @"[....]: IncrementPerfCounters is an internal method.")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.Management.WebEventBuffer.#PrintTime(System.DateTime)", Justification = @"[....]: already excluded, accidental duplication in merge")]
[module: SuppressMessage("Microsoft.Security", "CA2112:SecuredTypesShouldNotExposeFields", Scope = "type", Target = "System.Web.Management.WebEventCodes", Justification = @"[....]: WebEventCodes.ApplicationCodeBase is just a ""public const int"" to be used by caller. We don't care if it's protected by LinkDemands or Demands.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Management.WebEventCodes.#ApplicationShutdownChangeInGlobalAsax", MessageId = "Asax", Justification = @"[....]: Spellings ok")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "member", Target = "System.Web.Management.WebEventCodes.#ApplicationShutdownChangeInSecurityPolicyFile", MessageId = "InSecurity", Justification = @"[....]: Spellings ok")]
[module: SuppressMessage("Microsoft.Design", "CA1053:StaticHolderTypesShouldNotHaveConstructors", Scope = "type", Target = "System.Web.Management.WebEventManager", Justification = @"[....]: This was excluded before the namespace change")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.Management.WebEventManager.#Flush()", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.Management.WebEventManager.#Flush(System.String)", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Management.WebFailureAuditEvent.#IncrementPerfCounters()", MessageId = "Perf", Justification = @"[....]: IncrementPerfCounters is an internal method.")]
[module: SuppressMessage("Microsoft.Naming", "CA1706:ShortAcronymsShouldBeUppercase", Scope = "member", Target = "System.Web.Management.WebProcessInformation.#ProcessID", Justification = @"[....]: ID ok for ASP.NET (from Phuffs comments on similar rules)")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Management.WebRequestErrorEvent.#IncrementPerfCounters()", MessageId = "Perf", Justification = @"[....]: IncrementPerfCounters is an internal method.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Management.WebRequestEvent.#IncrementPerfCounters()", MessageId = "Perf", Justification = @"[....]: IncrementPerfCounters is an internal method.")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.Management.WebRequestInformation.#RequestUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.Management.WebSuccessAuditEvent.#IncrementPerfCounters()", MessageId = "Perf", Justification = @"[....]: IncrementPerfCounters is an internal method.")]
[module: SuppressMessage("Microsoft.Naming", "CA1706:ShortAcronymsShouldBeUppercase", Scope = "member", Target = "System.Web.Management.WebThreadInformation.#ThreadID", Justification = @"[....]: ID ok for ASP.NET (from Phuffs comments on similar rules)")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.Management.WmiWebEventProvider.#ProcessEvent(System.Web.Management.WebBaseEvent)", Justification = @"[....]: The catch is in debug code only and does not present a security risk.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Profile.CustomProviderDataAttribute.#IsDefaultAttribute()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.Profile.ProfileBase.#AddPropertySettingsFromConfig(System.Type,System.Boolean,System.Boolean,System.Web.Configuration.ProfilePropertySettingsCollection,System.String)", Justification = @"[....]: Disregarding this rule because it doesn't make sense for our code.")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.Profile.ProfileBase.#GetInternal(System.String)", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.Profile.ProfileBase.#GetPropType(System.String)", Justification = @"[....]: Disregarding this rule because it doesn't make sense for our code.")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.Profile.ProfileBase.#InitializeStatic()", Justification = @"[....]: Disregarding this rule because it doesn't make sense for our code.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Profile.ProfileBase.#get_Item(System.String)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2107:ReviewDenyAndPermitOnlyUsage", Scope = "member", Target = "System.Web.Profile.ProfileBase.#get_Item(System.String)", Justification = @"[....]: Done for VSWhidbey 427541")]
[module: SuppressMessage("Microsoft.Security", "CA2106:SecureAsserts", Scope = "member", Target = "System.Web.Profile.ProfileBase.#get_Item(System.String)", Justification = @"[....]: non-full-trust code is allowed to call these APIs.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Profile.ProfileBase.#set_Item(System.String,System.Object)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2107:ReviewDenyAndPermitOnlyUsage", Scope = "member", Target = "System.Web.Profile.ProfileBase.#set_Item(System.String,System.Object)", Justification = @"[....]: Done for VSWhidbey 427541")]
[module: SuppressMessage("Microsoft.Security", "CA2106:SecureAsserts", Scope = "member", Target = "System.Web.Profile.ProfileBase.#set_Item(System.String,System.Object)", Justification = @"[....]: non-full-trust code is allowed to call these APIs.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Profile.ProfileBase.#Save()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2107:ReviewDenyAndPermitOnlyUsage", Scope = "member", Target = "System.Web.Profile.ProfileBase.#Save()", Justification = @"[....]: Done for VSWhidbey 427541")]
[module: SuppressMessage("Microsoft.Security", "CA2106:SecureAsserts", Scope = "member", Target = "System.Web.Profile.ProfileBase.#Save()", Justification = @"[....]: non-full-trust code is allowed to call these APIs.")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.Profile.ProfileBase.#SaveWithAssert()", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.Profile.ProfileBase.#SetInternal(System.String,System.Object)", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope = "type", Target = "System.Web.Profile.ProfileEventHandler", Justification = @"[....]: Same as other Event handlers")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Profile.ProfileInfoCollection.#CopyTo(System.Array,System.Int32)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Profile.ProfileInfoCollection.#get_Count()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Profile.ProfileInfoCollection.#GetEnumerator()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Profile.ProfileInfoCollection.#get_IsSynchronized()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Profile.ProfileInfoCollection.#get_SyncRoot()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Design", "CA1021:AvoidOutParameters", Scope = "member", Target = "System.Web.Profile.ProfileManager.#FindInactiveProfilesByUserName(System.Web.Profile.ProfileAuthenticationOption,System.String,System.DateTime,System.Int32,System.Int32,System.Int32&)", MessageId = "5#", Justification = @"[....]: as per spec")]
[module: SuppressMessage("Microsoft.Design", "CA1021:AvoidOutParameters", Scope = "member", Target = "System.Web.Profile.ProfileManager.#FindProfilesByUserName(System.Web.Profile.ProfileAuthenticationOption,System.String,System.Int32,System.Int32,System.Int32&)", MessageId = "4#", Justification = @"[....]: as per spec")]
[module: SuppressMessage("Microsoft.Design", "CA1021:AvoidOutParameters", Scope = "member", Target = "System.Web.Profile.ProfileManager.#GetAllInactiveProfiles(System.Web.Profile.ProfileAuthenticationOption,System.DateTime,System.Int32,System.Int32,System.Int32&)", MessageId = "4#", Justification = @"[....]: as per spec")]
[module: SuppressMessage("Microsoft.Design", "CA1021:AvoidOutParameters", Scope = "member", Target = "System.Web.Profile.ProfileManager.#GetAllProfiles(System.Web.Profile.ProfileAuthenticationOption,System.Int32,System.Int32,System.Int32&)", MessageId = "3#", Justification = @"[....]: as per spec")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.Profile.ProfileManager.#Initialize(System.Boolean)", Justification = @"[....]: Disregarding this rule because it doesn't make sense for our code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1706:ShortAcronymsShouldBeUppercase", Scope = "member", Target = "System.Web.Profile.ProfileMigrateEventArgs.#AnonymousID", Justification = @"[....]: ID ok for ASP.NET (from Phuffs comments on similar rules)")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope = "type", Target = "System.Web.Profile.ProfileMigrateEventHandler", Justification = @"[....]: Same as other Event handlers")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.Profile.ProfileModule.#.ctor()", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.Profile.ProfileModule.#ParseDataFromDB(System.String[],System.String,System.Byte[],System.Configuration.SettingsPropertyValueCollection)", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.Profile.ProfileModule.#PrepareDataForSaving(System.String&,System.String&,System.Byte[]&,System.Boolean,System.Configuration.SettingsPropertyValueCollection,System.Boolean)", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Design", "CA1021:AvoidOutParameters", Scope = "member", Target = "System.Web.Profile.ProfileProvider.#FindInactiveProfilesByUserName(System.Web.Profile.ProfileAuthenticationOption,System.String,System.DateTime,System.Int32,System.Int32,System.Int32&)", MessageId = "5#", Justification = @"[....]: as per spec")]
[module: SuppressMessage("Microsoft.Design", "CA1021:AvoidOutParameters", Scope = "member", Target = "System.Web.Profile.ProfileProvider.#FindProfilesByUserName(System.Web.Profile.ProfileAuthenticationOption,System.String,System.Int32,System.Int32,System.Int32&)", MessageId = "4#", Justification = @"[....]: as per spec")]
[module: SuppressMessage("Microsoft.Design", "CA1021:AvoidOutParameters", Scope = "member", Target = "System.Web.Profile.ProfileProvider.#GetAllInactiveProfiles(System.Web.Profile.ProfileAuthenticationOption,System.DateTime,System.Int32,System.Int32,System.Int32&)", MessageId = "4#", Justification = @"[....]: as per spec")]
[module: SuppressMessage("Microsoft.Design", "CA1021:AvoidOutParameters", Scope = "member", Target = "System.Web.Profile.ProfileProvider.#GetAllProfiles(System.Web.Profile.ProfileAuthenticationOption,System.Int32,System.Int32,System.Int32&)", MessageId = "3#", Justification = @"[....]: as per spec")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Profile.ProfileProviderCollection.#Add(System.Configuration.Provider.ProviderBase)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Profile.SettingsAllowAnonymousAttribute.#IsDefaultAttribute()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Security.ActiveDirectoryMembershipProvider.#get_ApplicationName()", Justification = @"[....]: These methods all have full declarative demands for the DirectoryServicesPermission, so they are covered.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Security.ActiveDirectoryMembershipProvider.#set_ApplicationName(System.String)", Justification = @"[....]: These methods all have full declarative demands for the DirectoryServicesPermission, so they are covered.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Security.ActiveDirectoryMembershipProvider.#ChangePassword(System.String,System.String,System.String)", Justification = @"[....]: These methods all have full declarative demands for the DirectoryServicesPermission, so they are covered.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Security.ActiveDirectoryMembershipProvider.#ChangePasswordQuestionAndAnswer(System.String,System.String,System.String,System.String)", Justification = @"[....]: These methods all have full declarative demands for the DirectoryServicesPermission, so they are covered.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Security.ActiveDirectoryMembershipProvider.#CreateUser(System.String,System.String,System.String,System.String,System.String,System.Boolean,System.Object,System.Web.Security.MembershipCreateStatus&)", Justification = @"[....]: These methods all have full declarative demands for the DirectoryServicesPermission, so they are covered.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Security.ActiveDirectoryMembershipProvider.#DeleteUser(System.String,System.Boolean)", Justification = @"[....]: These methods all have full declarative demands for the DirectoryServicesPermission, so they are covered.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Security.ActiveDirectoryMembershipProvider.#get_EnablePasswordReset()", Justification = @"[....]: These methods all have full declarative demands for the DirectoryServicesPermission, so they are covered.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Security.ActiveDirectoryMembershipProvider.#get_EnablePasswordRetrieval()", Justification = @"[....]: These methods all have full declarative demands for the DirectoryServicesPermission, so they are covered.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Security.ActiveDirectoryMembershipProvider.#FindUsersByEmail(System.String,System.Int32,System.Int32,System.Int32&)", Justification = @"[....]: These methods all have full declarative demands for the DirectoryServicesPermission, so they are covered.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Security.ActiveDirectoryMembershipProvider.#FindUsersByName(System.String,System.Int32,System.Int32,System.Int32&)", Justification = @"[....]: These methods all have full declarative demands for the DirectoryServicesPermission, so they are covered.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Security.ActiveDirectoryMembershipProvider.#GetAllUsers(System.Int32,System.Int32,System.Int32&)", Justification = @"[....]: These methods all have full declarative demands for the DirectoryServicesPermission, so they are covered.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Security.ActiveDirectoryMembershipProvider.#GetNumberOfUsersOnline()", Justification = @"[....]: These methods all have full declarative demands for the DirectoryServicesPermission, so they are covered.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Security.ActiveDirectoryMembershipProvider.#GetPassword(System.String,System.String)", Justification = @"[....]: These methods all have full declarative demands for the DirectoryServicesPermission, so they are covered.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Security.ActiveDirectoryMembershipProvider.#GetUser(System.Object,System.Boolean)", Justification = @"[....]: These methods all have full declarative demands for the DirectoryServicesPermission, so they are covered.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Security.ActiveDirectoryMembershipProvider.#GetUser(System.String,System.Boolean)", Justification = @"[....]: These methods all have full declarative demands for the DirectoryServicesPermission, so they are covered.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Security.ActiveDirectoryMembershipProvider.#GetUserNameByEmail(System.String)", Justification = @"[....]: These methods all have full declarative demands for the DirectoryServicesPermission, so they are covered.")]
[module: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "System.Web.Security.ActiveDirectoryMembershipProvider.#Initialize(System.String,System.Collections.Specialized.NameValueCollection)", MessageId = "System.Text.RegularExpressions.Regex", Justification = @"[....]: We want to do a sanity check on the regular expression configuration property.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Security.ActiveDirectoryMembershipProvider.#get_MaxInvalidPasswordAttempts()", Justification = @"[....]: These methods all have full declarative demands for the DirectoryServicesPermission, so they are covered.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Security.ActiveDirectoryMembershipProvider.#get_MinRequiredNonAlphanumericCharacters()", Justification = @"[....]: These methods all have full declarative demands for the DirectoryServicesPermission, so they are covered.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Security.ActiveDirectoryMembershipProvider.#get_MinRequiredPasswordLength()", Justification = @"[....]: These methods all have full declarative demands for the DirectoryServicesPermission, so they are covered.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Security.ActiveDirectoryMembershipProvider.#get_PasswordAttemptWindow()", Justification = @"[....]: These methods all have full declarative demands for the DirectoryServicesPermission, so they are covered.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Security.ActiveDirectoryMembershipProvider.#get_PasswordFormat()", Justification = @"[....]: These methods all have full declarative demands for the DirectoryServicesPermission, so they are covered.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Security.ActiveDirectoryMembershipProvider.#get_PasswordStrengthRegularExpression()", Justification = @"[....]: These methods all have full declarative demands for the DirectoryServicesPermission, so they are covered.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Security.ActiveDirectoryMembershipProvider.#get_RequiresQuestionAndAnswer()", Justification = @"[....]: These methods all have full declarative demands for the DirectoryServicesPermission, so they are covered.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Security.ActiveDirectoryMembershipProvider.#get_RequiresUniqueEmail()", Justification = @"[....]: These methods all have full declarative demands for the DirectoryServicesPermission, so they are covered.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Security.ActiveDirectoryMembershipProvider.#ResetPassword(System.String,System.String)", Justification = @"[....]: These methods all have full declarative demands for the DirectoryServicesPermission, so they are covered.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Security.ActiveDirectoryMembershipProvider.#UnlockUser(System.String)", Justification = @"[....]: These methods all have full declarative demands for the DirectoryServicesPermission, so they are covered.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Security.ActiveDirectoryMembershipProvider.#UpdateUser(System.Web.Security.MembershipUser)", Justification = @"[....]: These methods all have full declarative demands for the DirectoryServicesPermission, so they are covered.")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.Security.ActiveDirectoryMembershipProvider.#ValidateUser(System.String,System.String)", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Security.ActiveDirectoryMembershipProvider.#ValidateUser(System.String,System.String)", Justification = @"[....]: These methods all have full declarative demands for the DirectoryServicesPermission, so they are covered.")]
[module: SuppressMessage("Microsoft.Naming", "CA1706:ShortAcronymsShouldBeUppercase", Scope = "member", Target = "System.Web.Security.AnonymousIdentificationEventArgs.#AnonymousID", Justification = @"[....]: ID ok for ASP.NET (from Phuffs comments on similar rules)")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope = "type", Target = "System.Web.Security.AnonymousIdentificationEventHandler", Justification = @"NO_JUSTIFICATION_PROVIDED")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.Security.AnonymousIdentificationModule.#.ctor()", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Security.AuthorizationStoreRoleProvider.#get_CacheRefreshInterval()", Justification = @"[....]: I believe this does not apply anymore with my last checkin.")]
[module: SuppressMessage("Microsoft.Security", "CA2106:SecureAsserts", Scope = "member", Target = "System.Web.Security.AuthorizationStoreRoleProvider.#CallMethod(System.Object,System.String,System.Object[])", Justification = @"[....]: This should apply anymore.")]
[module: SuppressMessage("Microsoft.Security", "CA2106:SecureAsserts", Scope = "member", Target = "System.Web.Security.AuthorizationStoreRoleProvider.#CallProperty(System.Object,System.String,System.Object[])", Justification = @"[....]: This should apply anymore.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Security.AuthorizationStoreRoleProvider.#GetAllRoles()", Justification = @"[....]: I believe this does not apply anymore.")]
[module: SuppressMessage("Microsoft.Security", "CA2106:SecureAsserts", Scope = "member", Target = "System.Web.Security.AuthorizationStoreRoleProvider.#GetAllRoles()", Justification = @"[....]: This should apply anymore.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Security.AuthorizationStoreRoleProvider.#GetRole(System.String)", Justification = @"[....]: I believe this does not apply anymore with my last checkin.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Security.AuthorizationStoreRoleProvider.#GetUsersInRole(System.String)", Justification = @"[....]: I believe this does not apply anymore.")]
[module: SuppressMessage("Microsoft.Security", "CA2106:SecureAsserts", Scope = "member", Target = "System.Web.Security.AuthorizationStoreRoleProvider.#GetUsersInRole(System.String)", Justification = @"[....]: This should apply anymore.")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.Security.AuthorizationStoreRoleProvider.#GetWindowsTokenWithAssert(System.String)", Justification = @"[....]: Method is required to get the current user token.")]
[module: SuppressMessage("Microsoft.Security", "CA2106:SecureAsserts", Scope = "member", Target = "System.Web.Security.AuthorizationStoreRoleProvider.#InitApp()", Justification = @"[....]: This should apply anymore.")]
[module: SuppressMessage("Microsoft.Performance", "CA1812:AvoidUninstantiatedInternalClasses", Scope = "type", Target = "System.Web.Security.CookieProtectionHelper", Justification = @"[....]: Has static methods called by different classes.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Security.CookieProtectionHelper.#Encode(System.Web.Security.CookieProtection,System.Byte[],System.Int32)", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope = "type", Target = "System.Web.Security.DefaultAuthenticationEventHandler", Justification = @"NO_JUSTIFICATION_PROVIDED")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.Security.DefaultAuthenticationModule.#.ctor()", Justification = @"[....]: These are protected by a full declarative unmanaged code demand, which covers security on the methods.")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.Security.FileAuthorizationModule.#.ctor()", Justification = @"[....]: These are protected by a full declarative unmanaged code demand, which covers security on the methods.")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.Security.FileAuthorizationModule.#CheckFileAccessForUser(System.String,System.IntPtr,System.String)", Justification = @"[....]: Added the security check per security code review.")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope = "member", Target = "System.Web.Security.FileSecurityDescriptorWrapper.#_securityDescriptor", Justification = @"[....]: Its a memory block, not a handle")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.Security.FormsAuthentication.#DefaultUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.Security.FormsAuthentication.#LoginUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Naming", "CA1720:AvoidTypeNamesInParameters", Scope = "member", Target = "System.Web.Security.FormsAuthentication.#RedirectToLoginPage(System.String)", MessageId = "0#", Justification = @"[....]: QueryString is well defined in web")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.Security.FormsAuthenticationEventArgs.#set_User(System.Security.Principal.IPrincipal)", Justification = @"[....]: These are protected by a full declarative unmanaged code demand, which covers security on the methods.")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope = "type", Target = "System.Web.Security.FormsAuthenticationEventHandler", Justification = @"NO_JUSTIFICATION_PROVIDED")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.Security.FormsAuthenticationModule.#.ctor()", Justification = @"[....]: These are protected by a full declarative unmanaged code demand, which covers security on the methods.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Security.Membership.#get_ApplicationName()", Justification = @"[....]: excluding fxcop errors for DevDiv Bugs 31461")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Security.Membership.#set_ApplicationName(System.String)", Justification = @"[....]: excluding fxcop errors for DevDiv Bugs 31461")]
[module: SuppressMessage("Microsoft.Design", "CA1021:AvoidOutParameters", Scope = "member", Target = "System.Web.Security.Membership.#CreateUser(System.String,System.String,System.String,System.String,System.String,System.Boolean,System.Object,System.Web.Security.MembershipCreateStatus&)", MessageId = "7#", Justification = @"[....]: This is by design. We can't make changes to the API at this late stage.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Security.Membership.#CreateUser(System.String,System.String,System.String,System.String,System.String,System.Boolean,System.Object,System.Web.Security.MembershipCreateStatus&)", Justification = @"[....]: excluding fxcop errors for DevDiv Bugs 31461")]
[module: SuppressMessage("Microsoft.Design", "CA1021:AvoidOutParameters", Scope = "member", Target = "System.Web.Security.Membership.#CreateUser(System.String,System.String,System.String,System.String,System.String,System.Boolean,System.Web.Security.MembershipCreateStatus&)", MessageId = "6#", Justification = @"[....]: By Design, as per PM")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Security.Membership.#DeleteUser(System.String)", Justification = @"[....]: excluding fxcop errors for DevDiv Bugs 31461")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Security.Membership.#DeleteUser(System.String,System.Boolean)", Justification = @"[....]: excluding fxcop errors for DevDiv Bugs 31461")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Security.Membership.#add_ValidatingPassword(System.Web.Security.MembershipValidatePasswordEventHandler)", Justification = @"[....]: excluding fxcop errors for DevDiv Bugs 31461")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Security.Membership.#remove_ValidatingPassword(System.Web.Security.MembershipValidatePasswordEventHandler)", Justification = @"[....]: excluding fxcop errors for DevDiv Bugs 31461")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Security.Membership.#get_EnablePasswordReset()", Justification = @"[....]: excluding fxcop errors for DevDiv Bugs 31461")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Security.Membership.#get_EnablePasswordRetrieval()", Justification = @"[....]: excluding fxcop errors for DevDiv Bugs 31461")]
[module: SuppressMessage("Microsoft.Design", "CA1021:AvoidOutParameters", Scope = "member", Target = "System.Web.Security.Membership.#FindUsersByEmail(System.String,System.Int32,System.Int32,System.Int32&)", MessageId = "3#", Justification = @"[....]: as per spec")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Security.Membership.#FindUsersByEmail(System.String,System.Int32,System.Int32,System.Int32&)", Justification = @"[....]: excluding fxcop errors for DevDiv Bugs 31461")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Security.Membership.#FindUsersByName(System.String)", Justification = @"[....]: excluding fxcop errors for DevDiv Bugs 31461")]
[module: SuppressMessage("Microsoft.Design", "CA1021:AvoidOutParameters", Scope = "member", Target = "System.Web.Security.Membership.#FindUsersByName(System.String,System.Int32,System.Int32,System.Int32&)", MessageId = "3#", Justification = @"[....]: Per spec")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Security.Membership.#FindUsersByName(System.String,System.Int32,System.Int32,System.Int32&)", Justification = @"[....]: excluding fxcop errors for DevDiv Bugs 31461")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.Security.Membership.#GetAllUsers()", Justification = @"[....]: Implemented as per spec")]
[module: SuppressMessage("Microsoft.Design", "CA1021:AvoidOutParameters", Scope = "member", Target = "System.Web.Security.Membership.#GetAllUsers(System.Int32,System.Int32,System.Int32&)", MessageId = "2#", Justification = @"[....]: as per spec")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Security.Membership.#GetAllUsers(System.Int32,System.Int32,System.Int32&)", Justification = @"[....]: excluding fxcop errors for DevDiv Bugs 31461")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Security.Membership.#GetCurrentUserName()", Justification = @"[....]: excluding fxcop errors for DevDiv Bugs 31461")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Security.Membership.#GetNumberOfUsersOnline()", Justification = @"[....]: excluding fxcop errors for DevDiv Bugs 31461")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.Security.Membership.#GetNumberOfUsersOnline()", Justification = @"[....]: Implemented as per spec")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.Security.Membership.#GetUser()", Justification = @"[....]: Implemented as per spec")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Security.Membership.#GetUser(System.Object,System.Boolean)", Justification = @"[....]: excluding fxcop errors for DevDiv Bugs 31461")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Security.Membership.#GetUser(System.String,System.Boolean)", Justification = @"[....]: excluding fxcop errors for DevDiv Bugs 31461")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Security.Membership.#GetUserNameByEmail(System.String)", Justification = @"[....]: excluding fxcop errors for DevDiv Bugs 31461")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.Security.Membership.#Initialize()", Justification = @"[....]: Disregarding this rule because it doesn't make sense for our code.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Security.Membership.#Initialize()", Justification = @"[....]: excluding fxcop errors for DevDiv Bugs 31461")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Security.Membership.#get_MaxInvalidPasswordAttempts()", Justification = @"[....]: excluding fxcop errors for DevDiv Bugs 31461")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Security.Membership.#get_MinRequiredNonAlphanumericCharacters()", Justification = @"[....]: excluding fxcop errors for DevDiv Bugs 31461")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Security.Membership.#get_MinRequiredPasswordLength()", Justification = @"[....]: excluding fxcop errors for DevDiv Bugs 31461")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Security.Membership.#get_PasswordAttemptWindow()", Justification = @"[....]: excluding fxcop errors for DevDiv Bugs 31461")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Security.Membership.#get_PasswordStrengthRegularExpression()", Justification = @"[....]: excluding fxcop errors for DevDiv Bugs 31461")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Security.Membership.#get_RequiresQuestionAndAnswer()", Justification = @"[....]: excluding fxcop errors for DevDiv Bugs 31461")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Security.Membership.#UpdateUser(System.Web.Security.MembershipUser)", Justification = @"[....]: excluding fxcop errors for DevDiv Bugs 31461")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Security.Membership.#ValidateUser(System.String,System.String)", Justification = @"[....]: excluding fxcop errors for DevDiv Bugs 31461")]
[module: SuppressMessage("Microsoft.Security", "CA2126:TypeLinkDemandsRequireInheritanceDemands", Scope = "type", Target = "System.Web.Security.MembershipCreateUserException", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.Security.MembershipCreateUserException.#GetObjectData(System.Runtime.Serialization.SerializationInfo,System.Runtime.Serialization.StreamingContext)", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Security.MembershipCreateUserException.#GetObjectData(System.Runtime.Serialization.SerializationInfo,System.Runtime.Serialization.StreamingContext)", Justification = @"[....]: The Exception class doesn't get the ASPNetHostingPermission link demand.")]
[module: SuppressMessage("Microsoft.Design", "CA1021:AvoidOutParameters", Scope = "member", Target = "System.Web.Security.MembershipProvider.#CreateUser(System.String,System.String,System.String,System.String,System.String,System.Boolean,System.Object,System.Web.Security.MembershipCreateStatus&)", MessageId = "7#", Justification = @"[....]: This is by design. We can't make changes to the API at this late stage.")]
[module: SuppressMessage("Microsoft.Design", "CA1021:AvoidOutParameters", Scope = "member", Target = "System.Web.Security.MembershipProvider.#FindUsersByEmail(System.String,System.Int32,System.Int32,System.Int32&)", MessageId = "3#", Justification = @"[....]: as per spec")]
[module: SuppressMessage("Microsoft.Design", "CA1021:AvoidOutParameters", Scope = "member", Target = "System.Web.Security.MembershipProvider.#FindUsersByName(System.String,System.Int32,System.Int32,System.Int32&)", MessageId = "3#", Justification = @"[....]: Result of changing Provider interface to ABC.")]
[module: SuppressMessage("Microsoft.Design", "CA1021:AvoidOutParameters", Scope = "member", Target = "System.Web.Security.MembershipProvider.#GetAllUsers(System.Int32,System.Int32,System.Int32&)", MessageId = "2#", Justification = @"[....]: as per spec")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.Security.MembershipProvider.#GetNumberOfUsersOnline()", Justification = @"[....]: Result of changing Provider interface to ABC.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.Security.MembershipProvider.#OnValidatingPassword(System.Web.Security.ValidatePasswordEventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Security.MembershipProviderCollection.#Add(System.Configuration.Provider.ProviderBase)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.Security.MembershipUser.#GetPassword()", Justification = @"[....]: Implemented as per spec")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Security.MembershipUserCollection.#get_Count()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Security.MembershipUserCollection.#GetEnumerator()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Security.MembershipUserCollection.#get_IsSynchronized()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Security.MembershipUserCollection.#get_SyncRoot()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Security.MembershipUserCollection.#System.Collections.ICollection.CopyTo(System.Array,System.Int32)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Portability", "CA1901:PInvokeDeclarationsShouldBePortable", Scope = "member", Target = "System.Web.Security.NativeMethods.#FormatMessageW(System.Int32,System.Int32,System.Int32,System.Int32,System.Text.StringBuilder,System.Int32,System.Int32)", MessageId = "1", Justification = @"[....]: These are native methods for pinvokes.")]
[module: SuppressMessage("Microsoft.Portability", "CA1901:PInvokeDeclarationsShouldBePortable", Scope = "member", Target = "System.Web.Security.NativeMethods.#FormatMessageW(System.Int32,System.Int32,System.Int32,System.Int32,System.Text.StringBuilder,System.Int32,System.Int32)", MessageId = "6", Justification = @"[....]: These are native methods for pinvokes.")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.Security.PassportAuthenticationEventArgs.#set_User(System.Security.Principal.IPrincipal)", Justification = @"[....]: These are protected by a full declarative unmanaged code demand, which covers security on the methods.")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope = "type", Target = "System.Web.Security.PassportAuthenticationEventHandler", Justification = @"NO_JUSTIFICATION_PROVIDED")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.Security.PassportAuthenticationModule.#.ctor()", Justification = @"[....]: These are protected by a full declarative unmanaged code demand, which covers security on the methods.")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.Security.PassportIdentity.#.ctor()", Justification = @"[....]: These are protected by a full declarative unmanaged code demand, which covers security on the methods.")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope = "member", Target = "System.Web.Security.PassportIdentity.#_iPassport", Justification = @"[....]: I've review the code and i am pretty confident that we won't leak anything here.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Security.PassportIdentity.#System.IDisposable.Dispose()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope = "type", Target = "System.Web.Security.RoleManagerEventHandler", Justification = @"NO_JUSTIFICATION_PROVIDED")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.Security.RoleManagerModule.#.ctor()", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Usage", "CA2235:MarkAllNonSerializableFields", Scope = "member", Target = "System.Web.Security.RolePrincipal.#_Identity", Justification = @"[....]: This is by design. See bug 436540.")]
[module: SuppressMessage("Microsoft.Security", "CA2110:SecureGetObjectDataOverrides", Scope = "member", Target = "System.Web.Security.RolePrincipal.#GetObjectData(System.Runtime.Serialization.SerializationInfo,System.Runtime.Serialization.StreamingContext)", Justification = @"[....]: This exclusion is required due to Dev10 bug 790444, as a security demand would break Cassini and IIS scenarios.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Security.RolePrincipal.#get_Identity()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Security.RolePrincipal.#IsInRole(System.String)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Security.RolePrincipal.#System.Runtime.Serialization.ISerializable.GetObjectData(System.Runtime.Serialization.SerializationInfo,System.Runtime.Serialization.StreamingContext)", Justification = @"[....]: Can't change the link demand on the base")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.Security.RolePrincipal.#ToEncryptedTicket()", Justification = @"[....]: RolePrincipal.ToEncryptedTicket should work in partial trust")]
[module: SuppressMessage("Microsoft.Security", "CA2106:SecureAsserts", Scope = "member", Target = "System.Web.Security.RolePrincipal.#ToEncryptedTicket()", Justification = @"[....]: RolePrincipal.ToEncryptedTicket should work in partial trust")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.Security.RoleProviderCollection.#Add(System.Configuration.Provider.ProviderBase)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Security.Roles.#AddUsersToRole(System.String[],System.String)", Justification = @"[....]: exlcuding fxcop errors for DevDiv Bugs 31461")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Security.Roles.#AddUsersToRoles(System.String[],System.String[])", Justification = @"[....]: exlcuding fxcop errors for DevDiv Bugs 31461")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Security.Roles.#AddUserToRole(System.String,System.String)", Justification = @"[....]: exlcuding fxcop errors for DevDiv Bugs 31461")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Security.Roles.#AddUserToRoles(System.String,System.String[])", Justification = @"[....]: exlcuding fxcop errors for DevDiv Bugs 31461")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Security.Roles.#get_ApplicationName()", Justification = @"[....]: exlcuding fxcop errors for DevDiv Bugs 31461")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Security.Roles.#set_ApplicationName(System.String)", Justification = @"[....]: exlcuding fxcop errors for DevDiv Bugs 31461")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Security.Roles.#get_CookieProtectionValue()", Justification = @"[....]: RolePrincipal.ToEncryptedTicket should work in partial trust")]
[module: SuppressMessage("Microsoft.Naming", "CA1705:LongAcronymsShouldBePascalCased", Scope = "member", Target = "System.Web.Security.Roles.#CookieRequireSSL", Justification = @"[....]: Implemented as per spec")]
[module: SuppressMessage("Microsoft.Naming", "CA1705:LongAcronymsShouldBePascalCased", Scope = "member", Target = "System.Web.Security.Roles.#get_CookieRequireSSL()", Justification = @"[....]: Implemented as per spec")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Security.Roles.#CreateRole(System.String)", Justification = @"[....]: exlcuding fxcop errors for DevDiv Bugs 31461")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Security.Roles.#DeleteCookie()", Justification = @"[....]: exlcuding fxcop errors for DevDiv Bugs 31461")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Security.Roles.#DeleteRole(System.String,System.Boolean)", Justification = @"[....]: exlcuding fxcop errors for DevDiv Bugs 31461")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Security.Roles.#get_Enabled()", Justification = @"[....]: RolePrincipal.ToEncryptedTicket should work in partial trust")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Security.Roles.#FindUsersInRole(System.String,System.String)", Justification = @"[....]: exlcuding fxcop errors for DevDiv Bugs 31461")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Security.Roles.#GetAllRoles()", Justification = @"[....]: exlcuding fxcop errors for DevDiv Bugs 31461")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Security.Roles.#GetCurrentUser()", Justification = @"[....]: exlcuding fxcop errors for DevDiv Bugs 31461")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Security.Roles.#GetRolesForUser(System.String)", Justification = @"[....]: exlcuding fxcop errors for DevDiv Bugs 31461")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Security.Roles.#GetUsersInRole(System.String)", Justification = @"[....]: exlcuding fxcop errors for DevDiv Bugs 31461")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.Security.Roles.#Initialize()", Justification = @"[....]: Disregarding this rule because it doesn't make sense for our code.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Security.Roles.#Initialize()", Justification = @"[....]: exlcuding fxcop errors for DevDiv Bugs 31461")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Security.Roles.#IsUserInRole(System.String,System.String)", Justification = @"[....]: exlcuding fxcop errors for DevDiv Bugs 31461")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Security.Roles.#get_MaxCachedResults()", Justification = @"[....]: RolePrincipal.ToEncryptedTicket should work in partial trust")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Security.Roles.#RemoveUserFromRole(System.String,System.String)", Justification = @"[....]: exlcuding fxcop errors for DevDiv Bugs 31461")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Security.Roles.#RemoveUserFromRoles(System.String,System.String[])", Justification = @"[....]: exlcuding fxcop errors for DevDiv Bugs 31461")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Security.Roles.#RemoveUsersFromRole(System.String[],System.String)", Justification = @"[....]: exlcuding fxcop errors for DevDiv Bugs 31461")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Security.Roles.#RemoveUsersFromRoles(System.String[],System.String[])", Justification = @"[....]: exlcuding fxcop errors for DevDiv Bugs 31461")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.Security.Roles.#RoleExists(System.String)", Justification = @"[....]: exlcuding fxcop errors for DevDiv Bugs 31461")]
[module: SuppressMessage("Microsoft.Design", "CA1025:ReplaceRepetitiveArgumentsWithParamsArray", Scope = "member", Target = "System.Web.Security.SqlMembershipProvider.#ChangePasswordQuestionAndAnswer(System.String,System.String,System.String,System.String)", Justification = @"[....]: Implemented as per spec")]
[module: SuppressMessage("Microsoft.Design", "CA1021:AvoidOutParameters", Scope = "member", Target = "System.Web.Security.SqlMembershipProvider.#FindUsersByName(System.String,System.Int32,System.Int32,System.Int32&)", MessageId = "3#", Justification = @"[....]: As per spec")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.Security.SqlMembershipProvider.#GetNumberOfUsersOnline()", Justification = @"[....]: Implemented as per spec")]
[module: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "System.Web.Security.SqlMembershipProvider.#Initialize(System.String,System.Collections.Specialized.NameValueCollection)", MessageId = "System.Text.RegularExpressions.Regex", Justification = @"[....]: We want to do a sanity check on the regular expression configuration property.")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.Security.UrlAuthorizationModule.#.ctor()", Justification = @"[....]: These are protected by a full declarative unmanaged code demand, which covers security on the methods.")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.Security.UrlAuthorizationModule.#CheckUrlAccessForPrincipal(System.String,System.Security.Principal.IPrincipal,System.String)", Justification = @"[....]: These are protected by a full declarative unmanaged code demand, which covers security on the methods.")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.Security.WindowsAuthenticationEventArgs.#set_User(System.Security.Principal.IPrincipal)", Justification = @"[....]: These are protected by a full declarative unmanaged code demand, which covers security on the methods.")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope = "type", Target = "System.Web.Security.WindowsAuthenticationEventHandler", Justification = @"NO_JUSTIFICATION_PROVIDED")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.Security.WindowsAuthenticationModule.#.ctor()", Justification = @"[....]: These are protected by a full declarative unmanaged code demand, which covers security on the methods.")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope = "type", Target = "System.Web.SessionState.CachedContent", Justification = @"[....]: The native content is owned by the native part of aspnet_state.exe.")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope = "member", Target = "System.Web.SessionState.CachedContent.#_stateItem", Justification = @"[....]: _stateItem is a pointer to a native StateItem object, and is used between the managed and native sides of State Server.  It's safe to use IntPtr here.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.SessionState.HttpSessionState.#CopyTo(System.Array,System.Int32)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.SessionState.HttpSessionState.#get_Count()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.SessionState.HttpSessionState.#get_IsSynchronized()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Naming", "CA1705:LongAcronymsShouldBePascalCased", Scope = "member", Target = "System.Web.SessionState.HttpSessionState.#LCID", Justification = @"[....]: Can't change it because it was named like this since V1.")]
[module: SuppressMessage("Microsoft.Naming", "CA1706:ShortAcronymsShouldBeUppercase", Scope = "member", Target = "System.Web.SessionState.HttpSessionState.#SessionID", Justification = @"[....]: ""ID"" ok for ASP.NET")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.SessionState.HttpSessionState.#get_SyncRoot()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Naming", "CA1705:LongAcronymsShouldBePascalCased", Scope = "member", Target = "System.Web.SessionState.IHttpSessionState.#LCID", Justification = @"[....]: This interface should map almost identical to the v1 class HttpSessionState, which already uses LCID as the name.")]
[module: SuppressMessage("Microsoft.Naming", "CA1705:LongAcronymsShouldBePascalCased", Scope = "member", Target = "System.Web.SessionState.IHttpSessionState.#get_LCID()", Justification = @"[....]: This interface should map almost identical to the v1 class HttpSessionState, which already uses LCID as the name.")]
[module: SuppressMessage("Microsoft.Naming", "CA1705:LongAcronymsShouldBePascalCased", Scope = "member", Target = "System.Web.SessionState.IHttpSessionState.#set_LCID(System.Int32)", Justification = @"[....]: This interface should map almost identical to the v1 class HttpSessionState, which already uses LCID as the name.")]
[module: SuppressMessage("Microsoft.Naming", "CA1706:ShortAcronymsShouldBeUppercase", Scope = "member", Target = "System.Web.SessionState.IHttpSessionState.#SessionID", Justification = @"[....]: ""ID"" ok for ASP.NET")]
[module: SuppressMessage("Microsoft.Naming", "CA1706:ShortAcronymsShouldBeUppercase", Scope = "type", Target = "System.Web.SessionState.ISessionIDManager", Justification = @"[....]: ID approved acronym.")]
[module: SuppressMessage("Microsoft.Naming", "CA1706:ShortAcronymsShouldBeUppercase", Scope = "member", Target = "System.Web.SessionState.ISessionIDManager.#CreateSessionID(System.Web.HttpContext)", Justification = @"[....]: ID approved acronym.")]
[module: SuppressMessage("Microsoft.Naming", "CA1706:ShortAcronymsShouldBeUppercase", Scope = "member", Target = "System.Web.SessionState.ISessionIDManager.#GetSessionID(System.Web.HttpContext)", Justification = @"[....]: ID approved acronym.")]
[module: SuppressMessage("Microsoft.Design", "CA1021:AvoidOutParameters", Scope = "member", Target = "System.Web.SessionState.ISessionIDManager.#InitializeRequest(System.Web.HttpContext,System.Boolean,System.Boolean&)", MessageId = "2#", Justification = @"[....]: Already using a return parameter or more than one out parameter.")]
[module: SuppressMessage("Microsoft.Naming", "CA1706:ShortAcronymsShouldBeUppercase", Scope = "member", Target = "System.Web.SessionState.ISessionIDManager.#InitializeRequest(System.Web.HttpContext,System.Boolean,System.Boolean&)", MessageId = "2#", Justification = @"[....]: ID approved acronym.")]
[module: SuppressMessage("Microsoft.Naming", "CA1706:ShortAcronymsShouldBeUppercase", Scope = "member", Target = "System.Web.SessionState.ISessionIDManager.#RemoveSessionID(System.Web.HttpContext)", Justification = @"[....]: ID approved acronym.")]
[module: SuppressMessage("Microsoft.Design", "CA1021:AvoidOutParameters", Scope = "member", Target = "System.Web.SessionState.ISessionIDManager.#SaveSessionID(System.Web.HttpContext,System.String,System.Boolean&,System.Boolean&)", MessageId = "2#", Justification = @"[....]: Both return values needed.")]
[module: SuppressMessage("Microsoft.Design", "CA1021:AvoidOutParameters", Scope = "member", Target = "System.Web.SessionState.ISessionIDManager.#SaveSessionID(System.Web.HttpContext,System.String,System.Boolean&,System.Boolean&)", MessageId = "3#", Justification = @"[....]: Both return values needed.")]
[module: SuppressMessage("Microsoft.Naming", "CA1706:ShortAcronymsShouldBeUppercase", Scope = "member", Target = "System.Web.SessionState.ISessionIDManager.#SaveSessionID(System.Web.HttpContext,System.String,System.Boolean&,System.Boolean&)", Justification = @"[....]: ID approved acronym.")]
[module: SuppressMessage("Microsoft.Design", "CA1054:UriParametersShouldNotBeStrings", Scope = "member", Target = "System.Web.SessionState.IStateRuntime.#ProcessRequest(System.IntPtr,System.Int32,System.String,System.Int32,System.Int32,System.Int32,System.Int32,System.Int32,System.Int32,System.IntPtr)", MessageId = "2#", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Globalization", "CA1303:DoNotPassLiteralsAsLocalizedParameters", Scope = "member", Target = "System.Web.SessionState.OutOfProcSessionStateStore.#CreatePartitionInfo(System.String)", MessageId = "System.ArgumentException.#ctor(System.String)", Justification = @"[....]: This exception is only used to trigger an outer catch, the string/message is never used.")]
[module: SuppressMessage("Microsoft.Usage", "CA2208:InstantiateArgumentExceptionsCorrectly", Scope = "member", Target = "System.Web.SessionState.OutOfProcSessionStateStore.#CreatePartitionInfo(System.String)", Justification = @"[....]: This exception is only used to trigger an outer catch, the string/message is never used.")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope = "member", Target = "System.Web.SessionState.OutOfProcSessionStateStore.#INVALID_SOCKET", Justification = @"[....]: INVALID_SOCKET isn't a real resource.  It's a marker for an invalid socket.")]
[module: SuppressMessage("Microsoft.Globalization", "CA1305:SpecifyIFormatProvider", Scope = "member", Target = "System.Web.SessionState.OutOfProcSessionStateStore.#MakeRequest(System.Web.UnsafeNativeMethods+StateProtocolVerb,System.String,System.Web.UnsafeNativeMethods+StateProtocolExclusive,System.Int32,System.Int32,System.Int32,System.Byte[],System.Int32,System.Int32,System.Web.UnsafeNativeMethods+SessionNDMakeRequestResults&)", MessageId = "System.String.Format(System.String,System.Object)", Justification = @"[....]: Debug-only trace code")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope = "member", Target = "System.Web.SessionState.OutOfProcSessionStateStore+OutOfProcConnection.#_socketHandle", Justification = @"[....]: _socketHandler is a winsock handle used between ssdirect.cxx and outofprocstateclientmanager.cs.  Its lifetime is controlled by both the managed code and the native code.  It's okay to use IntPtr.")]
[module: SuppressMessage("Microsoft.Naming", "CA1706:ShortAcronymsShouldBeUppercase", Scope = "type", Target = "System.Web.SessionState.SessionIDManager", Justification = @"[....]: ID approved acronym.")]
[module: SuppressMessage("Microsoft.Naming", "CA1706:ShortAcronymsShouldBeUppercase", Scope = "member", Target = "System.Web.SessionState.SessionIDManager.#SessionIDMaxLength", Justification = @"[....]: ID approved acronym.")]
[module: SuppressMessage("Microsoft.Design", "CA1035:ICollectionImplementationsHaveStronglyTypedMembers", Scope = "type", Target = "System.Web.SessionState.SessionStateItemCollection", Justification = @"[....]: Items stored are generic objects")]
[module: SuppressMessage("Microsoft.Usage", "CA2237:MarkISerializableTypesWithSerializable", Scope = "type", Target = "System.Web.SessionState.SessionStateItemCollection", Justification = @"[....]: This collection isn't intended to be serialized.")]
[module: SuppressMessage("Microsoft.Security", "CA2107:ReviewDenyAndPermitOnlyUsage", Scope = "member", Target = "System.Web.SessionState.SessionStateItemCollection.#DeserializeItem(System.String,System.Boolean)", Justification = @"[....]: Needed to sandbox deserialization for Session")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.SessionState.SessionStateItemCollection.#GetEnumerator()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.SessionState.SessionStateItemCollection.#get_Keys()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.SessionState.SessionStateItemCollection.#ReadValueFromStreamWithAssert()", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Security", "CA2107:ReviewDenyAndPermitOnlyUsage", Scope = "member", Target = "System.Web.SessionState.SessionStateItemCollection.#Serialize(System.IO.BinaryWriter)", Justification = @"[....]: Fix for 491458")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.SessionState.SessionStateItemCollection.#WriteValueToStreamWithAssert(System.Object,System.IO.BinaryWriter)", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope = "type", Target = "System.Web.SessionState.SessionStateItemExpireCallback", Justification = @"NO_JUSTIFICATION_PROVIDED")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.SessionState.SessionStateModule.#.ctor()", Justification = @"[....]: These are protected by a full declarative unmanaged code demand, which covers security on the methods.")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.SessionState.SessionStateModule.#LookUpRegForPollInterval()", Justification = @"[....]: this is necessary in order to read a config setting in the registry")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.SessionState.SessionStateModule.#PollLockedSessionCallback(System.Object)", Justification = @"[....]: Disregarding this rule because it doesn't make sense for our code.")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope = "member", Target = "System.Web.SessionState.SessionStateModule.#PollLockedSessionCallback(System.Object)", Justification = @"[....]: We want to catch all error because we will pass the exception to an HttpAsyncResult object.")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.SessionState.SessionStateModule.#RaiseOnStart(System.EventArgs)", Justification = @"[....]: Internal method.")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.SessionState.SessionStateModule.#ResetPollTimer()", Justification = @"[....]: Called by PollLockedSessionCallback()")]
[module: SuppressMessage("Microsoft.Design", "CA1021:AvoidOutParameters", Scope = "member", Target = "System.Web.SessionState.SessionStateStoreProviderBase.#GetItem(System.Web.HttpContext,System.String,System.Boolean&,System.TimeSpan&,System.Object&,System.Web.SessionState.SessionStateActions&)", MessageId = "2#", Justification = @"[....]: By-design")]
[module: SuppressMessage("Microsoft.Design", "CA1021:AvoidOutParameters", Scope = "member", Target = "System.Web.SessionState.SessionStateStoreProviderBase.#GetItem(System.Web.HttpContext,System.String,System.Boolean&,System.TimeSpan&,System.Object&,System.Web.SessionState.SessionStateActions&)", MessageId = "3#", Justification = @"[....]: By-design")]
[module: SuppressMessage("Microsoft.Design", "CA1021:AvoidOutParameters", Scope = "member", Target = "System.Web.SessionState.SessionStateStoreProviderBase.#GetItem(System.Web.HttpContext,System.String,System.Boolean&,System.TimeSpan&,System.Object&,System.Web.SessionState.SessionStateActions&)", MessageId = "4#", Justification = @"[....]: By-design")]
[module: SuppressMessage("Microsoft.Design", "CA1021:AvoidOutParameters", Scope = "member", Target = "System.Web.SessionState.SessionStateStoreProviderBase.#GetItem(System.Web.HttpContext,System.String,System.Boolean&,System.TimeSpan&,System.Object&,System.Web.SessionState.SessionStateActions&)", MessageId = "5#", Justification = @"[....]: By-design")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "member", Target = "System.Web.SessionState.SessionStateStoreProviderBase.#GetItem(System.Web.HttpContext,System.String,System.Boolean&,System.TimeSpan&,System.Object&,System.Web.SessionState.SessionStateActions&)", MessageId = "lockAge", Justification = @"[....]: By-design.  What we mean is ""lock age"".")]
[module: SuppressMessage("Microsoft.Design", "CA1021:AvoidOutParameters", Scope = "member", Target = "System.Web.SessionState.SessionStateStoreProviderBase.#GetItemExclusive(System.Web.HttpContext,System.String,System.Boolean&,System.TimeSpan&,System.Object&,System.Web.SessionState.SessionStateActions&)", MessageId = "2#", Justification = @"[....]: By-design")]
[module: SuppressMessage("Microsoft.Design", "CA1021:AvoidOutParameters", Scope = "member", Target = "System.Web.SessionState.SessionStateStoreProviderBase.#GetItemExclusive(System.Web.HttpContext,System.String,System.Boolean&,System.TimeSpan&,System.Object&,System.Web.SessionState.SessionStateActions&)", MessageId = "3#", Justification = @"[....]: By-design")]
[module: SuppressMessage("Microsoft.Design", "CA1021:AvoidOutParameters", Scope = "member", Target = "System.Web.SessionState.SessionStateStoreProviderBase.#GetItemExclusive(System.Web.HttpContext,System.String,System.Boolean&,System.TimeSpan&,System.Object&,System.Web.SessionState.SessionStateActions&)", MessageId = "4#", Justification = @"[....]: By-design")]
[module: SuppressMessage("Microsoft.Design", "CA1021:AvoidOutParameters", Scope = "member", Target = "System.Web.SessionState.SessionStateStoreProviderBase.#GetItemExclusive(System.Web.HttpContext,System.String,System.Boolean&,System.TimeSpan&,System.Object&,System.Web.SessionState.SessionStateActions&)", MessageId = "5#", Justification = @"[....]: By-design")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "member", Target = "System.Web.SessionState.SessionStateStoreProviderBase.#GetItemExclusive(System.Web.HttpContext,System.String,System.Boolean&,System.TimeSpan&,System.Object&,System.Web.SessionState.SessionStateActions&)", MessageId = "lockAge", Justification = @"[....]: By-design.  What we mean is ""lock age"".")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.SessionState.SessionStateUtility.#RaiseSessionEnd(System.Web.SessionState.IHttpSessionState,System.Object,System.EventArgs)", MessageId = "2#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.SessionState.SessionStateUtility.#RaiseSessionEnd(System.Web.SessionState.IHttpSessionState,System.Object,System.EventArgs)", Justification = @"[....]: Assigned to [....]")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.SessionState.SqlSessionStateStore.#CreatePartitionInfo(System.String)", Justification = @"[....]: Disregarding this rule because it doesn't make sense for our code.")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.SessionState.SqlSessionStateStore.#CreateUninitializedItem(System.Web.HttpContext,System.String,System.Int32)", Justification = @"[....]: Disregarding this rule because it doesn't make sense for our code.")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.SessionState.SqlSessionStateStore.#DoGet(System.Web.HttpContext,System.String,System.Boolean,System.Boolean&,System.TimeSpan&,System.Object&,System.Web.SessionState.SessionStateActions&)", Justification = @"[....]: Disregarding this rule because it doesn't make sense for our code.")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.SessionState.SqlSessionStateStore.#ReleaseItemExclusive(System.Web.HttpContext,System.String,System.Object)", Justification = @"[....]: Disregarding this rule because it doesn't make sense for our code.")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.SessionState.SqlSessionStateStore.#RemoveItem(System.Web.HttpContext,System.String,System.Object,System.Web.SessionState.SessionStateStoreData)", Justification = @"[....]: Disregarding this rule because it doesn't make sense for our code.")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.SessionState.SqlSessionStateStore.#ResetItemTimeout(System.Web.HttpContext,System.String)", Justification = @"[....]: Disregarding this rule because it doesn't make sense for our code.")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.SessionState.SqlSessionStateStore.#SetAndReleaseItemExclusive(System.Web.HttpContext,System.String,System.Web.SessionState.SessionStateStoreData,System.Object,System.Boolean)", Justification = @"[....]: Disregarding this rule because it doesn't make sense for our code.")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.SessionState.SqlSessionStateStore+SqlPartitionInfo.#GetServerSupportOptions(System.Data.SqlClient.SqlConnection)", Justification = @"[....]: Disregarding this rule because it doesn't make sense for our code.")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.SessionState.SqlSessionStateStore+SqlStateConnection.#.ctor(System.Web.SessionState.SqlSessionStateStore+SqlPartitionInfo)", Justification = @"[....]: Disregarding this rule because it doesn't make sense for our code.")]
[module: SuppressMessage("Microsoft.Usage", "CA2213:DisposableFieldsShouldBeDisposed", Scope = "member", Target = "System.Web.SessionState.SqlSessionStateStore+SqlStateConnection.#Dispose()", Justification = @"[....]: The doc of SqlCommand.IDispose.Dispose said ""This member supports the .NET Framework infrastructure and is not intended to be used directly from your code.""")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope = "type", Target = "System.Web.SessionState.StateHttpWorkerRequest", Justification = @"[....]: The lifetime of all the native resources ownd by StateHttpWorkerRequest is controlled by the native aspnet_state.exe.")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope = "member", Target = "System.Web.SessionState.StateHttpWorkerRequest.#_tracker", Justification = @"[....]: _tracker is a pointer to a Tracker object in native StateServer code, and its lifetime is controlled by the native side.")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope = "member", Target = "System.Web.SessionState.StateHttpWorkerRequest.#_unmanagedState", Justification = @"[....]: _unmanagedState is a pointer to a StateItem native object and is used internally between the managed side and native side of the State Server.  It's safe to use IntPtr here.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.ApplicationFileParser.#.ctor()", Justification = @"[....]: Reviewed and exluded in beta2lhsd, porting that to rtmlhs")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.AttributeCollection.#set_Item(System.String,System.String)", Justification = @"[....]: Designers run in full trust.")]
[module: SuppressMessage("Microsoft.Usage", "CA2213:DisposableFieldsShouldBeDisposed", Scope = "member", Target = "System.Web.UI.BasePartialCachingControl.#Dispose()", Justification = @"[....]: David Ebbo reviewed and feels that it's dangerous to dispose of ""_cachedCtrl"" here since this object is not the owner of it.  That object will be disposed at a later point.")]
[module: SuppressMessage("Microsoft.Globalization", "CA1305:SpecifyIFormatProvider", Scope = "member", Target = "System.Web.UI.BasePartialCachingControl.#Render(System.Web.UI.HtmlTextWriter)", MessageId = "System.IO.StringWriter.#ctor", Justification = @"[....]: This is correct.  It would be wrong here to specify neutral culture.")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope = "member", Target = "System.Web.UI.BaseTemplateParser.#GetDesignTimeUserControlType(System.String,System.String)", Justification = @"[....]: It's fine here to catch all exceptions.")]
[module: SuppressMessage("Microsoft.Naming", "CA1706:ShortAcronymsShouldBeUppercase", Scope = "member", Target = "System.Web.UI.BoundPropertyEntry.#ControlID", Justification = @"[....]: We use ID in our code.")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope = "type", Target = "System.Web.UI.BuildMethod", Justification = @"NO_JUSTIFICATION_PROVIDED")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope = "type", Target = "System.Web.UI.BuildTemplateMethod", Justification = @"NO_JUSTIFICATION_PROVIDED")]
[module: SuppressMessage("Microsoft.Naming", "CA1720:AvoidTypeNamesInParameters", Scope = "member", Target = "System.Web.UI.ChtmlTextWriter.#.ctor(System.IO.TextWriter,System.String)", MessageId = "1#", Justification = @"[....]: This parameter name (""tabString"") was used in V1 in the HtmlTextWriter constructor.  Better to maintain the parameter name for consistency with HtmlTextWriter in V1.")]
[module: SuppressMessage("Microsoft.Design", "CA1055:UriReturnValuesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.ClientScriptManager.#GetWebResourceUrl(System.Type,System.String)", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Design", "CA1054:UriParametersShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.ClientScriptManager.#RegisterClientScriptInclude(System.String,System.String)", MessageId = "1#", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Design", "CA1054:UriParametersShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.ClientScriptManager.#RegisterClientScriptInclude(System.Type,System.String,System.String)", MessageId = "2#", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Naming", "CA1706:ShortAcronymsShouldBeUppercase", Scope = "member", Target = "System.Web.UI.Control.#ClientIDSeparator", Justification = @"[....]: ID approved acronym.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.Control.#get_Controls()", Justification = @"[....]: The designer needs to use ControlsCollection, since it requires full trust, this is not a security issue.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.Control.#DataBind()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Usage", "CA2213:DisposableFieldsShouldBeDisposed", Scope = "member", Target = "System.Web.UI.Control.#Dispose()", Justification = @"[....]: bug 148739 for follow-up")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.UI.Control.#EnableTheming", MessageId = "Theming", Justification = @"[....]: Spellings ok")]
[module: SuppressMessage("Microsoft.Naming", "CA1706:ShortAcronymsShouldBeUppercase", Scope = "member", Target = "System.Web.UI.Control.#EnsureID()", Justification = @"[....]: ""ID"" ok for ASP.NET")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.UI.Control.#GetDesignModeState()", Justification = @"[....]: The method security attribute is more restrictive than type attribute. The LinkDemand is not required.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.Control.#GetDesignModeState()", Justification = @"[....]: The method security attribute is more restrictive than type attribute. The LinkDemand is not required.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.UI.Control.#GetDesignModeState()", Justification = @"[....]: This method implies non-trivial work, so it is a method.")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.UI.Control.#GetRareFieldStatistics(System.Int32&,System.Int32&,System.Int32&)", Justification = @"[....]: already excluded, accidental duplication in merge")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.Control.#get_ID()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.Control.#set_ID(System.String)", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Naming", "CA1706:ShortAcronymsShouldBeUppercase", Scope = "member", Target = "System.Web.UI.Control.#LoadViewStateByID", Justification = @"[....]: ID approved acronym.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.Control.#OnBubbleEvent(System.Object,System.EventArgs)", MessageId = "1#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.Control.#OnDataBinding(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.Control.#OnInit(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.Control.#OnLoad(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.Control.#OnPreRender(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.Control.#OnUnload(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.Control.#RaiseBubbleEvent(System.Object,System.EventArgs)", MessageId = "1#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.UI.Control.#RaiseBubbleEvent(System.Object,System.EventArgs)", Justification = @"[....]: legacy event exposure")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.UI.Control.#ResetVisible()", Justification = @"[....]: code may be used for debug purposes and through reflection")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.UI.Control.#ShouldSerializeVisible()", Justification = @"[....]: code may be used for debug purposes and through reflection")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.Control.#get_Site()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.Control.#set_Site(System.ComponentModel.ISite)", Justification = @"[....]: Designers are run in full-trust, so this will always be okay.")]
[module: SuppressMessage("Microsoft.Naming", "CA1706:ShortAcronymsShouldBeUppercase", Scope = "member", Target = "System.Web.UI.Control.#SkinID", Justification = @"[....]: ""ID"" ok for ASP.NET")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.Control.#System.Web.UI.IControlBuilderAccessor.get_ControlBuilder()", Justification = @"[....]: explicit implementations by design for information hiding")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.Control.#System.Web.UI.IControlDesignerAccessor.SetOwnerControl(System.Web.UI.Control)", Justification = @"[....]: By design")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.Control.#System.Web.UI.IControlDesignerAccessor.get_UserData()", Justification = @"[....]: This is not meant to be overidden.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.Control.#System.Web.UI.IDataBindingsAccessor.get_DataBindings()", Justification = @"[....]: explicit implementations by design for information hiding")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.Control.#System.Web.UI.IDataBindingsAccessor.get_HasDataBindings()", Justification = @"[....]: explicit implementations by design for information hiding")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.Control.#System.Web.UI.IExpressionsAccessor.get_Expressions()", Justification = @"[....]: Don't know where these come from. Will check with Polita.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.Control.#System.Web.UI.IExpressionsAccessor.get_HasExpressions()", Justification = @"[....]: Don't know where these come from. Will check with Polita.")]
[module: SuppressMessage("Microsoft.Security", "CA2112:SecuredTypesShouldNotExposeFields", Scope = "type", Target = "System.Web.UI.ControlBuilder", Justification = @"[....]: Needed by system.design.")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.Web.UI.ControlBuilder.#AttachTypeDescriptionProvider(System.Object)", Justification = @"[....]: Calling this non-aptca method here does not seem to cause security vulnerabilities.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.UI.ControlBuilder.#GetObjectPersistData()", Justification = @"[....]: methods are preferred here")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.UI.ControlBuilder.#GetResourceKey()", Justification = @"[....]: The method name is correct.")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.UI.ControlBuilder.#InitBoundProperty(System.Object,System.Web.UI.BoundPropertyEntry,System.Web.UI.DataBindingCollection&,System.Web.UI.IAttributeAccessor&)", Justification = @"[....]: Disregarding this rule because it doesn't make sense for our code.")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.UI.ControlBuilder.#InitCollectionsComplexProperties(System.Object)", Justification = @"[....]: Disregarding this rule because it doesn't make sense for our code.")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.UI.ControlBuilder.#InitComplexProperties(System.Object)", Justification = @"[....]: Disregarding this rule because it doesn't make sense for our code.")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.UI.ControlBuilder.#InitTemplateProperties(System.Object)", Justification = @"[....]: Disregarding this rule because it doesn't make sense for our code.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.UI.ControlBuilder.#SetResourceKey(System.String)", Justification = @"[....]: We want to keep these setters separate from the getters since they can have side effects.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.UI.ControlBuilder.#SetServiceProvider(System.IServiceProvider)", Justification = @"[....]: We want to keep these setters separate from the getters since they can have side effects.")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.UI.ControlBuilder.#SetSimpleProperty(System.Web.UI.SimplePropertyEntry,System.Object)", Justification = @"[....]: Disregarding this rule because it doesn't make sense for our code.")]
[module: SuppressMessage("Microsoft.Security", "CA2104:DoNotDeclareReadOnlyMutableReferenceTypes", Scope = "member", Target = "System.Web.UI.ControlBuilderAttribute.#Default", Justification = @"[....]: the properties of the referenced types are also not settable")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.UI.ControlCachePolicy.#SetExpires(System.DateTime)", Justification = @"[....]: The naming of methods on this class follows an established pattern for cache control policy (i.e. HttpCachePolicy), and is thus excluded.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.UI.ControlCachePolicy.#SetSlidingExpiration(System.Boolean)", Justification = @"[....]: The naming of methods on this class follows an established pattern for cache control policy (i.e. HttpCachePolicy), and is thus excluded.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.UI.ControlCachePolicy.#SetVaryByCustom(System.String)", Justification = @"[....]: The naming of methods on this class follows an established pattern for cache control policy (i.e. HttpCachePolicy), and is thus excluded.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.UI.ControlCachePolicy.#VaryByParams", Justification = @"[....]: This is the name as speced.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.ControlCollection.#get_Item(System.Int32)", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Naming", "CA1711:IdentifiersShouldNotHaveIncorrectSuffix", Scope = "type", Target = "System.Web.UI.ControlSkinDelegate", Justification = @"[....]: This is a delegate.")]
[module: SuppressMessage("Microsoft.Design", "CA1019:DefineAccessorsForAttributeArguments", Scope = "type", Target = "System.Web.UI.ControlValuePropertyAttribute", Justification = @"[....]: The Type parameter in the constructor is just a hint for parsing, it has no other use.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.ControlValuePropertyAttribute.#Equals(System.Object)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.ControlValuePropertyAttribute.#GetHashCode()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.ControlValuePropertyAttribute.#get_Name()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Globalization", "CA1305:SpecifyIFormatProvider", Scope = "member", Target = "System.Web.UI.CssStyleCollection.#BuildString()", Justification = @"[....]: We don't do culture-sensitive conversions.")]
[module: SuppressMessage("Microsoft.Design", "CA1043:UseIntegralOrStringArgumentForIndexers", Scope = "member", Target = "System.Web.UI.CssStyleCollection.#Item[System.Web.UI.HtmlTextWriterStyle]", Justification = @"[....]: This is a v1 API.")]
[module: SuppressMessage("Microsoft.Globalization", "CA1305:SpecifyIFormatProvider", Scope = "member", Target = "System.Web.UI.CssTextWriter.#.ctor(System.IO.TextWriter)", Justification = @"[....]: We don't do culture-sensitive conversions.")]
[module: SuppressMessage("Microsoft.Globalization", "CA1305:SpecifyIFormatProvider", Scope = "member", Target = "System.Web.UI.DataBinder.#Eval(System.Object,System.String,System.String)", MessageId = "System.String.Format(System.String,System.Object)", Justification = @"[....]: These calls should use the default current culture.")]
[module: SuppressMessage("Microsoft.Design", "CA1021:AvoidOutParameters", Scope = "member", Target = "System.Web.UI.DataBinder.#GetDataItem(System.Object,System.Boolean&)", MessageId = "1#", Justification = @"[....]: The out parameter is required to help differentiate between the DataItem found and was null vs. the DataItem was not found at all cases")]
[module: SuppressMessage("Microsoft.Globalization", "CA1305:SpecifyIFormatProvider", Scope = "member", Target = "System.Web.UI.DataBinder.#GetIndexedPropertyValue(System.Object,System.String,System.String)", MessageId = "System.String.Format(System.String,System.Object)", Justification = @"[....]: These calls should use the default current culture.")]
[module: SuppressMessage("Microsoft.Globalization", "CA1305:SpecifyIFormatProvider", Scope = "member", Target = "System.Web.UI.DataBinder.#GetPropertyValue(System.Object,System.String,System.String)", MessageId = "System.String.Format(System.String,System.Object)", Justification = @"[....]: These calls should use the default current culture.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.DataBinding.#.ctor(System.String,System.Type,System.String)", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.DataBinding.#get_Expression()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.DataBinding.#set_Expression(System.String)", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.DataBindingCollection.#Add(System.Web.UI.DataBinding)", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.DataBindingCollection.#get_Item(System.String)", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.DataBindingCollection.#Remove(System.String)", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Security", "CA2104:DoNotDeclareReadOnlyMutableReferenceTypes", Scope = "member", Target = "System.Web.UI.DataBindingHandlerAttribute.#Default", Justification = @"[....]: This is appropriate for attributes")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.DataBindingHandlerAttribute.#Equals(System.Object)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.DataBindingHandlerAttribute.#GetHashCode()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.UI.DataSourceControl.#remove_DataSourceChangedInternal(System.EventHandler)", Justification = @"[....]: This is definitely callable.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.DataSourceControl.#System.Web.UI.IDataSource.add_DataSourceChanged(System.EventHandler)", Justification = @"[....]: Components should only use these events through the IDataSource and IHierarchicalDataSource interfaces.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.DataSourceControl.#System.Web.UI.IDataSource.remove_DataSourceChanged(System.EventHandler)", Justification = @"[....]: Components should only use these events through the IDataSource and IHierarchicalDataSource interfaces.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.UI.DataSourceControl.#GetViewNames()", Justification = @"[....]: This is a potentially expensive operation so it is a method instead of a property")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.DataSourceControl.#RaiseDataSourceChangedEvent(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.UI.DataSourceControl.#RaiseDataSourceChangedEvent(System.EventArgs)", Justification = @"[....]: By design - this calls multiple event delegates.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.DataSourceControl.#System.ComponentModel.IListSource.get_ContainsListCollection()", Justification = @"[....]: These would never need to be overridden by a derived class. They are mostly just there for v1 controls to use.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.DataSourceControl.#System.ComponentModel.IListSource.get_ContainsListCollection()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.DataSourceControl.#System.ComponentModel.IListSource.GetList()", Justification = @"[....]: These would never need to be overridden by a derived class. They are mostly just there for v1 controls to use.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.DataSourceControl.#System.ComponentModel.IListSource.GetList()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2112:SecuredTypesShouldNotExposeFields", Scope = "type", Target = "System.Web.UI.DataSourceSelectArguments", Justification = @"[....]: Empty is a static readonly.")]
[module: SuppressMessage("Microsoft.Security", "CA2104:DoNotDeclareReadOnlyMutableReferenceTypes", Scope = "member", Target = "System.Web.UI.DataSourceSelectArguments.#Empty", Justification = @"[....]: The type is immutable.")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.UI.DataSourceSelectArguments.#RaiseUnsupportedCapabilitiesError(System.Web.UI.DataSourceView)", Justification = @"[....]: This is a better design for this instance so that the base class can take care of most errors.")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.UI.DataSourceView.#Delete(System.Collections.IDictionary,System.Collections.IDictionary,System.Web.UI.DataSourceViewOperationCallback)", Justification = @"[....]: Disregarding this rule because it doesn't make sense for our code.")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.UI.DataSourceView.#Insert(System.Collections.IDictionary,System.Web.UI.DataSourceViewOperationCallback)", Justification = @"[....]: Disregarding this rule because it doesn't make sense for our code.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.DataSourceView.#OnDataSourceViewChanged(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.UI.DataSourceView.#RaiseUnsupportedCapabilityError(System.Web.UI.DataSourceCapabilities)", Justification = @"[....]: This model works best for this API.")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.UI.DataSourceView.#Update(System.Collections.IDictionary,System.Collections.IDictionary,System.Collections.IDictionary,System.Web.UI.DataSourceViewOperationCallback)", Justification = @"[....]: Disregarding this rule because it doesn't make sense for our code.")]
[module: SuppressMessage("Microsoft.Reliability", "CA2003:DoNotTreatFibersAsThreads", Scope = "member", Target = "System.Web.UI.DependencyParser.#GetVirtualPathDependencies()", Justification = @"[....]: That's what we want here.")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.UI.DesignTimeTemplateParser.#ParseControlsInternal(System.Web.UI.DesignTimeParseData,System.Boolean)", Justification = @"[....]: No issue here")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.UI.DesignTimeTemplateParser.#ParseTemplate(System.Web.UI.DesignTimeParseData)", Justification = @"[....]: These are protected by a full declarative unmanaged code demand, which covers security on the methods.")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.UI.DesignTimeTemplateParser.#ParseTheme(System.ComponentModel.Design.IDesignerHost,System.String,System.String)", Justification = @"[....]: Disregarding this rule because it doesn't make sense for our code.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.ExpressionBindingCollection.#CopyTo(System.Array,System.Int32)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.ExpressionBindingCollection.#get_Count()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.ExpressionBindingCollection.#GetEnumerator()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.ExpressionBindingCollection.#get_IsSynchronized()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.ExpressionBindingCollection.#get_SyncRoot()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope = "type", Target = "System.Web.UI.ExtractTemplateValuesMethod", Justification = @"[....]: Don't know where these come from. Will check with Polita.")]
[module: SuppressMessage("Microsoft.Security", "CA2112:SecuredTypesShouldNotExposeFields", Scope = "type", Target = "System.Web.UI.FileLevelControlBuilderAttribute", Justification = @"[....]: It is ok to expose these static readonly fields even though the LinkDemand does not apply to them.")]
[module: SuppressMessage("Microsoft.Security", "CA2104:DoNotDeclareReadOnlyMutableReferenceTypes", Scope = "member", Target = "System.Web.UI.FileLevelControlBuilderAttribute.#Default", Justification = @"[....]: This is fine, and fxcop complains about something else if I change it as it suggests...")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.FileLevelControlBuilderAttribute.#Equals(System.Object)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.FileLevelControlBuilderAttribute.#GetHashCode()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.FileLevelControlBuilderAttribute.#IsDefaultAttribute()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2112:SecuredTypesShouldNotExposeFields", Scope = "type", Target = "System.Web.UI.FilterableAttribute", Justification = @"[....]: It is ok to expose these static readonly fields even though the LinkDemand does not apply to them.")]
[module: SuppressMessage("Microsoft.Security", "CA2104:DoNotDeclareReadOnlyMutableReferenceTypes", Scope = "member", Target = "System.Web.UI.FilterableAttribute.#Default", Justification = @"[....]: These are immutable.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.FilterableAttribute.#Equals(System.Object)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.FilterableAttribute.#GetHashCode()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.FilterableAttribute.#IsDefaultAttribute()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Design", "CA1011:ConsiderPassingBaseTypesAsParameters", Scope = "member", Target = "System.Web.UI.FilterableAttribute.#IsPropertyFilterable(System.ComponentModel.PropertyDescriptor)", Justification = @"[....]: FilterableAttribute only applies to Properties therefore using PropertyDescriptor is correct.")]
[module: SuppressMessage("Microsoft.Security", "CA2104:DoNotDeclareReadOnlyMutableReferenceTypes", Scope = "member", Target = "System.Web.UI.FilterableAttribute.#No", Justification = @"[....]: These are immutable.")]
[module: SuppressMessage("Microsoft.Security", "CA2104:DoNotDeclareReadOnlyMutableReferenceTypes", Scope = "member", Target = "System.Web.UI.FilterableAttribute.#Yes", Justification = @"[....]: These are immutable.")]
[module: SuppressMessage("Microsoft.Design", "CA1035:ICollectionImplementationsHaveStronglyTypedMembers", Scope = "type", Target = "System.Web.UI.FilteredAttributeDictionary", Justification = @"[....]: This takes objects as values, so we can't make a strongly typed version.")]
[module: SuppressMessage("Microsoft.Usage", "CA2208:InstantiateArgumentExceptionsCorrectly", Scope = "member", Target = "System.Web.UI.FilteredAttributeDictionary.#System.Collections.IDictionary.Add(System.Object,System.Object)", Justification = @"[....]: The string parameters (1st is error message and 2nd is param name) are set correctly for the ArgumentException construction in the code.")]
[module: SuppressMessage("Microsoft.Usage", "CA2208:InstantiateArgumentExceptionsCorrectly", Scope = "member", Target = "System.Web.UI.FilteredAttributeDictionary.#System.Collections.IDictionary.Contains(System.Object)", Justification = @"[....]: The string parameters (1st is error message and 2nd is param name) are set correctly for the ArgumentException construction in the code.")]
[module: SuppressMessage("Microsoft.Usage", "CA2208:InstantiateArgumentExceptionsCorrectly", Scope = "member", Target = "System.Web.UI.FilteredAttributeDictionary.#System.Collections.IDictionary.get_Item(System.Object)", Justification = @"[....]: The string parameters (1st is error message and 2nd is param name) are set correctly for the ArgumentException construction in the code.")]
[module: SuppressMessage("Microsoft.Usage", "CA2208:InstantiateArgumentExceptionsCorrectly", Scope = "member", Target = "System.Web.UI.FilteredAttributeDictionary.#System.Collections.IDictionary.set_Item(System.Object,System.Object)", Justification = @"[....]: The string parameters (1st is error message and 2nd is param name) are set correctly for the ArgumentException construction in the code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "type", Target = "System.Web.UI.HiddenFieldPageStatePersister", MessageId = "Persister", Justification = @"[....]: Spellings ok")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.UI.HiddenFieldPageStatePersister.#Load()", Justification = @"[....]: Disregarding this rule because it doesn't make sense for our code.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.HierarchicalDataSourceControl.#System.Web.UI.IHierarchicalDataSource.add_DataSourceChanged(System.EventHandler)", Justification = @"[....]: Components should only use these events through the IDataSource and IHierarchicalDataSource interfaces.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.HierarchicalDataSourceControl.#System.Web.UI.IHierarchicalDataSource.remove_DataSourceChanged(System.EventHandler)", Justification = @"[....]: Components should only use these events through the IDataSource and IHierarchicalDataSource interfaces.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.HierarchicalDataSourceControl.#OnDataSourceChanged(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Naming", "CA1720:AvoidTypeNamesInParameters", Scope = "member", Target = "System.Web.UI.Html32TextWriter.#.ctor(System.IO.TextWriter,System.String)", MessageId = "1#", Justification = @"[....]: Breaking changes")]
[module: SuppressMessage("Microsoft.Naming", "CA1720:AvoidTypeNamesInParameters", Scope = "member", Target = "System.Web.UI.HtmlTextWriter.#.ctor(System.IO.TextWriter,System.String)", MessageId = "1#", Justification = @"[....]: Breaking changes")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.UI.HtmlTextWriter.#AddAttribute(System.String,System.String,System.Boolean)", MessageId = "Endode", Justification = @"[....]: must use fEndode bad spelling for backwards compat")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.HtmlTextWriter.#Close()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Design", "CA1054:UriParametersShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.HtmlTextWriter.#EncodeUrl(System.String)", MessageId = "0#", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Design", "CA1055:UriReturnValuesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.HtmlTextWriter.#EncodeUrl(System.String)", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.HtmlTextWriter.#Flush()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Design", "CA1021:AvoidOutParameters", Scope = "member", Target = "System.Web.UI.HtmlTextWriter.#IsAttributeDefined(System.Web.UI.HtmlTextWriterAttribute,System.String&)", MessageId = "1#", Justification = @"[....]: legacy names")]
[module: SuppressMessage("Microsoft.Design", "CA1021:AvoidOutParameters", Scope = "member", Target = "System.Web.UI.HtmlTextWriter.#IsStyleAttributeDefined(System.Web.UI.HtmlTextWriterStyle,System.String&)", MessageId = "1#", Justification = @"[....]: legacy names")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.HtmlTextWriter.#Write(System.Boolean)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.HtmlTextWriter.#Write(System.Char)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.HtmlTextWriter.#Write(System.Char[])", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.HtmlTextWriter.#Write(System.Double)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.HtmlTextWriter.#Write(System.Int32)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.HtmlTextWriter.#Write(System.Int64)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.HtmlTextWriter.#Write(System.Object)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.HtmlTextWriter.#Write(System.Single)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.HtmlTextWriter.#Write(System.String)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Design", "CA1054:UriParametersShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.HtmlTextWriter.#WriteEncodedUrl(System.String)", MessageId = "0#", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Design", "CA1054:UriParametersShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.HtmlTextWriter.#WriteEncodedUrlParameter(System.String)", MessageId = "0#", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.HtmlTextWriter.#WriteLine()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.HtmlTextWriter.#WriteLine(System.Boolean)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.HtmlTextWriter.#WriteLine(System.Char)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.HtmlTextWriter.#WriteLine(System.Char[])", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.HtmlTextWriter.#WriteLine(System.Double)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.HtmlTextWriter.#WriteLine(System.Int32)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.HtmlTextWriter.#WriteLine(System.Int64)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.HtmlTextWriter.#WriteLine(System.Object)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.HtmlTextWriter.#WriteLine(System.Single)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.HtmlTextWriter.#WriteLine(System.String)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.HtmlTextWriter.#WriteLine(System.UInt32)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.UI.HtmlTextWriterAttribute.#Abbr", Justification = @"[....]: We have to make this enum member name the same as the attribute name.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.UI.HtmlTextWriterAttribute.#Coords", Justification = @"[....]: HtmlTextWriterAttribute enum names come from html attributes. (We can't change this anyway, since it was this way in V1.)")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.UI.HtmlTextWriterAttribute.#Longdesc", Justification = @"[....]: HtmlTextWriterAttribute enum names come from html attributes. (We can't change this anyway, since it was this way in V1.)")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.UI.HtmlTextWriterAttribute.#Rel", Justification = @"[....]: HtmlTextWriterAttribute enum names come from html attributes. (We can't change this anyway, since it was this way in V1.)")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.UI.HtmlTextWriterAttribute.#Usemap", Justification = @"[....]: HtmlTextWriterAttribute enum names come from html attributes. (We can't change this anyway, since it was this way in V1.)")]
[module: SuppressMessage("Microsoft.Naming", "CA1711:IdentifiersShouldNotHaveIncorrectSuffix", Scope = "type", Target = "System.Web.UI.ICallbackEventHandler", Justification = @"[....]: Decided to keep the name")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.UI.ICallbackEventHandler.#GetCallbackResult()", Justification = @"[....]: Naming is appropriate for this interface")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.UI.ICallbackEventHandler.#RaiseCallbackEvent(System.String)", Justification = @"[....]: Naming is appropriate for this interface")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.IControlDesignerAccessor.#GetDesignModeState()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.UI.IControlDesignerAccessor.#GetDesignModeState()", Justification = @"[....]: This method implies non-trivial work, so it is a method.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.IControlDesignerAccessor.#SetDesignModeState(System.Collections.IDictionary)", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.UI.IControlDesignerAccessor.#SetDesignModeState(System.Collections.IDictionary)", Justification = @"[....]: A method is the logical choice here.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.UI.IControlDesignerAccessor.#SetOwnerControl(System.Web.UI.Control)", Justification = @"[....]: A method is the logical choice here.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.UI.IDataSource.#GetViewNames()", Justification = @"[....]: This is a potentially expensive operation so it is a method instead of a property")]
[module: SuppressMessage("Microsoft.Naming", "CA1706:ShortAcronymsShouldBeUppercase", Scope = "type", Target = "System.Web.UI.IDReferencePropertyAttribute", Justification = @"[....]: We use ID in our code.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.IDReferencePropertyAttribute.#Equals(System.Object)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.IDReferencePropertyAttribute.#GetHashCode()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Naming", "CA1710:IdentifiersShouldHaveCorrectSuffix", Scope = "type", Target = "System.Web.UI.IHierarchicalEnumerable", Justification = @"[....]: This is bogus, it doesn't implement ICollection.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.UI.IHierarchyData.#GetChildren()", Justification = @"[....]: These are methods to imply that they do more than trivial work.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.UI.IHierarchyData.#GetParent()", Justification = @"[....]: This is a signature change of an old excluded method. The operation can be expensive.")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope = "type", Target = "System.Web.UI.ImageClickEventHandler", Justification = @"NO_JUSTIFICATION_PROVIDED")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.INavigateUIData.#NavigateUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.UI.IPostBackDataHandler.#RaisePostDataChangedEvent()", Justification = @"[....]: These are not events but methods that raise events.")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.UI.IPostBackEventHandler.#RaisePostBackEvent(System.String)", Justification = @"[....]: These are not events but methods that raise events.")]
[module: SuppressMessage("Microsoft.Design", "CA1055:UriReturnValuesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.IResourceUrlGenerator.#GetResourceUrl(System.Type,System.String)", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.IThemeResolutionService.#GetStylesheetThemeProvider()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.UI.IThemeResolutionService.#GetStylesheetThemeProvider()", Justification = @"NO_JUSTIFICATION_PROVIDED")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.IThemeResolutionService.#GetThemeProvider()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.UI.IThemeResolutionService.#GetThemeProvider()", Justification = @"[....]: This is meant to be a method.")]
[module: SuppressMessage("Microsoft.Design", "CA1054:UriParametersShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.IUrlResolutionService.#ResolveClientUrl(System.String)", MessageId = "0#", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Design", "CA1055:UriReturnValuesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.IUrlResolutionService.#ResolveClientUrl(System.String)", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.UI.MainTagNameToTypeMapper.#ProcessTagNamespaceRegistration(System.Collections.ArrayList)", Justification = @"[....]: It's fine in this case not to catch non Exception objects")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.UI.MainTagNameToTypeMapper.#TryUserControlRegisterDirectives(System.String)", Justification = @"[....]: It's fine in this case not to catch non Exception objects")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "member", Target = "System.Web.UI.MasterPage.#ContentPlaceHolders", MessageId = "PlaceHolders", Justification = @"[....]: Spellings ok.")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "member", Target = "System.Web.UI.MasterPage.#InstantiateInContentPlaceHolder(System.Web.UI.Control,System.Web.UI.ITemplate)", MessageId = "PlaceHolder", Justification = @"[....]: ContentPlaceHolder is the name of the existing public class.")]
[module: SuppressMessage("Microsoft.Performance", "CA1812:AvoidUninstantiatedInternalClasses", Scope = "type", Target = "System.Web.UI.MinimizableAttributeTypeConverter", Justification = @"[....]: This is used as a TypeConverter in metadata.")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.UI.MinimizableAttributeTypeConverter.#.ctor()", Justification = @"[....]: This method is called thru reflection when the attributed management code is invoked.")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.Web.UI.NamespaceTagNameToTypeMapper.#GetControlType(System.String,System.Collections.IDictionary,System.Boolean)", Justification = @"[....]: Only happens in designer, which is always full trust.")]
[module: SuppressMessage("Microsoft.Security", "CA2112:SecuredTypesShouldNotExposeFields", Scope = "type", Target = "System.Web.UI.NonVisualControlAttribute", Justification = @"[....]: It is ok to expose these static readonly fields even though the LinkDemand does not apply to them.")]
[module: SuppressMessage("Microsoft.Security", "CA2104:DoNotDeclareReadOnlyMutableReferenceTypes", Scope = "member", Target = "System.Web.UI.NonVisualControlAttribute.#Default", Justification = @"[....]: Fields are not mutable")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.NonVisualControlAttribute.#Equals(System.Object)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.NonVisualControlAttribute.#GetHashCode()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.NonVisualControlAttribute.#IsDefaultAttribute()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2104:DoNotDeclareReadOnlyMutableReferenceTypes", Scope = "member", Target = "System.Web.UI.NonVisualControlAttribute.#NonVisual", Justification = @"[....]: Fields are not mutable")]
[module: SuppressMessage("Microsoft.Security", "CA2104:DoNotDeclareReadOnlyMutableReferenceTypes", Scope = "member", Target = "System.Web.UI.NonVisualControlAttribute.#Visual", Justification = @"[....]: Fields are not mutable")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.UI.ObjectStateFormatter.#Deserialize(System.IO.Stream)", Justification = @"[....]: No security issues if non-CLSCompliant exceptions bubble up here.")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope = "member", Target = "System.Web.UI.ObjectStateFormatter.#Deserialize(System.IO.Stream)", Justification = @"[....]: We're keeping track of the exception object, so it's fine.")]
[module: SuppressMessage("Microsoft.Security", "CA2106:SecureAsserts", Scope = "member", Target = "System.Web.UI.ObjectStateFormatter.#Deserialize(System.IO.Stream)", Justification = @"[....]: These asserts are here because we run under PermitOnly, which won't permit creation of the BinaryReader and Writer.  Calling this method through another method is safe.")]
[module: SuppressMessage("Microsoft.Naming", "CA1720:AvoidTypeNamesInParameters", Scope = "member", Target = "System.Web.UI.ObjectStateFormatter.#Deserialize(System.String)", MessageId = "0#", Justification = @"[....]: This is fine")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.UI.ObjectStateFormatter.#Deserialize(System.String)", Justification = @"[....]: No security issues if non-CLSCompliant exceptions bubble up here.")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.UI.ObjectStateFormatter.#DeserializeType(System.Web.UI.ObjectStateFormatter+SerializerBinaryReader)", Justification = @"[....]: No security issues if non-CLSCompliant exceptions bubble up here.")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.UI.ObjectStateFormatter.#DeserializeValue(System.Web.UI.ObjectStateFormatter+SerializerBinaryReader)", Justification = @"[....]: No security issues if non-CLSCompliant exceptions bubble up here.")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.UI.ObjectStateFormatter.#DeserializeWithAssert(System.IO.Stream)", Justification = @"[....]: These are internal methods, so the LinkDemand from the class does not apply.")]
[module: SuppressMessage("Microsoft.Security", "CA2106:SecureAsserts", Scope = "member", Target = "System.Web.UI.ObjectStateFormatter.#Serialize(System.IO.Stream,System.Object)", Justification = @"[....]: These asserts are here because we run under PermitOnly, which won't permit creation of the BinaryReader and Writer.  Calling this method through another method is safe.")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.UI.ObjectStateFormatter.#SerializeValue(System.Web.UI.ObjectStateFormatter+SerializerBinaryWriter,System.Object)", Justification = @"[....]: No security issues if non-CLSCompliant exceptions bubble up here.")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.UI.ObjectStateFormatter.#SerializeWithAssert(System.IO.Stream,System.Object)", Justification = @"[....]: These are internal methods, so the LinkDemand from the class does not apply.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.ObjectStateFormatter.#System.Runtime.Serialization.IFormatter.get_Binder()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.ObjectStateFormatter.#System.Runtime.Serialization.IFormatter.set_Binder(System.Runtime.Serialization.SerializationBinder)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.ObjectStateFormatter.#System.Runtime.Serialization.IFormatter.get_Context()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.ObjectStateFormatter.#System.Runtime.Serialization.IFormatter.set_Context(System.Runtime.Serialization.StreamingContext)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.ObjectStateFormatter.#System.Runtime.Serialization.IFormatter.Deserialize(System.IO.Stream)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.ObjectStateFormatter.#System.Runtime.Serialization.IFormatter.Serialize(System.IO.Stream,System.Object)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.ObjectStateFormatter.#System.Runtime.Serialization.IFormatter.get_SurrogateSelector()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.ObjectStateFormatter.#System.Runtime.Serialization.IFormatter.set_SurrogateSelector(System.Runtime.Serialization.ISurrogateSelector)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Performance", "CA1812:AvoidUninstantiatedInternalClasses", Scope = "type", Target = "System.Web.UI.ObjectTag", Justification = @"[....]: It's huge to hookup the ControlBuilder")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.UI.OutputCacheParameters.#VaryByParam", MessageId = "Param", Justification = @"[....]: Consistent with V1 page directive.")]
[module: SuppressMessage("Microsoft.Security", "CA2112:SecuredTypesShouldNotExposeFields", Scope = "type", Target = "System.Web.UI.Page", Justification = @"[....]: Breaking change")]
[module: SuppressMessage("Microsoft.Usage", "CA2214:DoNotCallOverridableMethodsInConstructors", Scope = "member", Target = "System.Web.UI.Page.#.ctor()", Justification = @"[....]: virtual ID called from constructor")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.UI.Page.#AddOnPreRenderCompleteAsync(System.Web.BeginEventHandler,System.Web.EndEventHandler)", Justification = @"[....]: the is async 'event', not a true event")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.UI.Page.#AddOnPreRenderCompleteAsync(System.Web.BeginEventHandler,System.Web.EndEventHandler,System.Object)", Justification = @"[....]: this is an 'async' event which does not fit the standard event pattern")]
[module: SuppressMessage("Microsoft.Design", "CA1044:PropertiesShouldNotBeWriteOnly", Scope = "member", Target = "System.Web.UI.Page.#AspCompatMode", Justification = @"[....]: bug 148739 for follow-up, suggestion to add setters to page directive related properties")]
[module: SuppressMessage("Microsoft.Design", "CA1044:PropertiesShouldNotBeWriteOnly", Scope = "member", Target = "System.Web.UI.Page.#AsyncMode", Justification = @"[....]: pattern similar to other code-generated page properties")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.UI.Page.#AsyncPageBeginProcessRequest(System.Web.HttpContext,System.AsyncCallback,System.Object)", Justification = @"[....]: Disregarding this rule because it doesn't make sense for our code.")]
[module: SuppressMessage("Microsoft.Design", "CA1044:PropertiesShouldNotBeWriteOnly", Scope = "member", Target = "System.Web.UI.Page.#Buffer", Justification = @"[....]: bug 148739 for follow-up, suggestion to add setters to page directive related properties")]
[module: SuppressMessage("Microsoft.Design", "CA1044:PropertiesShouldNotBeWriteOnly", Scope = "member", Target = "System.Web.UI.Page.#CodePage", Justification = @"[....]: bug 148739 for follow-up, suggestion to add setters to page directive related properties")]
[module: SuppressMessage("Microsoft.Design", "CA1044:PropertiesShouldNotBeWriteOnly", Scope = "member", Target = "System.Web.UI.Page.#ContentType", Justification = @"[....]: bug 148739 for follow-up, suggestion to add setters to page directive related properties")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.UI.Page.#CreateHtmlTextWriterFromType(System.IO.TextWriter,System.Type)", MessageId = "0#", Justification = @"[....]: legacy name")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.UI.Page.#CreateHtmlTextWriterFromType(System.IO.TextWriter,System.Type)", MessageId = "tw", Justification = @"[....]: consistent with v1")]
[module: SuppressMessage("Microsoft.Design", "CA1044:PropertiesShouldNotBeWriteOnly", Scope = "member", Target = "System.Web.UI.Page.#Culture", Justification = @"[....]: bug 148739 for follow-up, suggestion to add setters to page directive related properties")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.UI.Page.#DisplayRareFieldStatistics()", Justification = @"[....]: already excluded, accidental duplication in merge")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "member", Target = "System.Web.UI.Page.#PreLoad", MessageId = "PreLoad", Justification = @"[....]: Spellings ok.")]
[module: SuppressMessage("Microsoft.Design", "CA1044:PropertiesShouldNotBeWriteOnly", Scope = "member", Target = "System.Web.UI.Page.#FileDependencies", Justification = @"[....]: bug 148739 for follow-up, suggestion to add setters to page directive related properties")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.UI.Page.#GetDataItem()", Justification = @"[....]: This is a complex operation that should be a method, not a property.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.UI.Page.#GetTypeHashCode()", Justification = @"[....]: Reviewed, and these are appropriate uses of methods.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.UI.Page.#GetValidators(System.String)", Justification = @"[....]: browser capabilities not in the dictionary")]
[module: SuppressMessage("Microsoft.Globalization", "CA1305:SpecifyIFormatProvider", Scope = "member", Target = "System.Web.UI.Page.#HandleError(System.Exception)", Justification = @"[....]: culture behavior derived from thread")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.UI.Page.#InitOutputCache(System.Int32,System.String,System.String,System.String,System.Web.UI.OutputCacheLocation,System.String)", MessageId = "Param", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.UI.Page.#get_IsAsync()", Justification = @"[....]: pattern similar to other code-generated page properties")]
[module: SuppressMessage("Microsoft.Design", "CA1044:PropertiesShouldNotBeWriteOnly", Scope = "member", Target = "System.Web.UI.Page.#LCID", Justification = @"[....]: bug 148739 for follow-up, suggestion to add setters to page directive related properties")]
[module: SuppressMessage("Microsoft.Naming", "CA1705:LongAcronymsShouldBePascalCased", Scope = "member", Target = "System.Web.UI.Page.#get_LCID()", Justification = @"[....]: LCID setter already exists, getter is grandfathered in")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.Page.#OnInit(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.Page.#OnInitComplete(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.Page.#OnLoadComplete(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.Page.#OnPreInit(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "member", Target = "System.Web.UI.Page.#OnPreLoad(System.EventArgs)", MessageId = "PreLoad", Justification = @"[....]: Spellings ok.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.Page.#OnPreLoad(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.Page.#OnPreRenderComplete(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.Page.#OnSaveStateComplete(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.UI.Page.#PageStatePersister", MessageId = "Persister", Justification = @"[....]: Apllings ok.")]
[module: SuppressMessage("Microsoft.Security", "CA2107:ReviewDenyAndPermitOnlyUsage", Scope = "member", Target = "System.Web.UI.Page.#ProcessRequest(System.Web.HttpContext)", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope = "member", Target = "System.Web.UI.Page.#ProcessRequestMain()", Justification = @"[....]: general exception catching is OK")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.UI.Page.#ProcessRequestMain(System.Boolean,System.Boolean)", Justification = @"[....]: Disregarding this rule because it doesn't make sense for our code.")]
[module: SuppressMessage("Microsoft.Globalization", "CA1303:DoNotPassLiteralsAsLocalizedParameters", Scope = "member", Target = "System.Web.UI.Page.#ProcessRequestMain(System.Boolean,System.Boolean)", MessageId = "System.Web.TraceContext.Write(System.String,System.String)", Justification = @"[....]: non localized tracing string")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.UI.Page.#ProcessRequestTransacted()", Justification = @"[....]: Disregarding this rule because it doesn't make sense for our code.")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.UI.Page.#ProcessRequestWithAssert(System.Web.HttpContext)", Justification = @"[....]: The method is a private non-virtual method.  Rule error.")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.UI.Page.#RaisePostBackEvent(System.Collections.Specialized.NameValueCollection)", Justification = @"[....]: legacy event exposure")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.UI.Page.#RaisePostBackEvent(System.Web.UI.IPostBackEventHandler,System.String)", Justification = @"[....]: legacy event exposure")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.UI.Page.#get_RequestViewStateString()", Justification = @"[....]: Disregarding this rule because it doesn't make sense for our code.")]
[module: SuppressMessage("Microsoft.Design", "CA1044:PropertiesShouldNotBeWriteOnly", Scope = "member", Target = "System.Web.UI.Page.#ResponseEncoding", Justification = @"[....]: bug 148739 for follow-up, suggestion to add setters to page directive related properties")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope = "member", Target = "System.Web.UI.Page.#get_Session()", Justification = @"[....]: general exception catching is OK")]
[module: SuppressMessage("Microsoft.Reliability", "CA2003:DoNotTreatFibersAsThreads", Scope = "member", Target = "System.Web.UI.Page.#SetCulture(System.Threading.Thread,System.Globalization.CultureInfo,System.Globalization.CultureInfo)", Justification = @"[....]: we know we're working with managed threads")]
[module: SuppressMessage("Microsoft.Reliability", "CA2003:DoNotTreatFibersAsThreads", Scope = "member", Target = "System.Web.UI.Page.#SetCultureWithAssert(System.Threading.Thread,System.Globalization.CultureInfo,System.Globalization.CultureInfo)", Justification = @"[....]: we know we're working with managed threads")]
[module: SuppressMessage("Microsoft.Naming", "CA1706:ShortAcronymsShouldBeUppercase", Scope = "member", Target = "System.Web.UI.Page.#SetFocus(System.String)", MessageId = "0#", Justification = @"[....]: ""ID"" ok for ASP.NET")]
[module: SuppressMessage("Microsoft.Design", "CA1044:PropertiesShouldNotBeWriteOnly", Scope = "member", Target = "System.Web.UI.Page.#TraceEnabled", Justification = @"[....]: bug 148739 for follow-up, suggestion to add setters to page directive related properties")]
[module: SuppressMessage("Microsoft.Design", "CA1044:PropertiesShouldNotBeWriteOnly", Scope = "member", Target = "System.Web.UI.Page.#TraceModeValue", Justification = @"[....]: bug 148739 for follow-up, suggestion to add setters to page directive related properties")]
[module: SuppressMessage("Microsoft.Design", "CA1044:PropertiesShouldNotBeWriteOnly", Scope = "member", Target = "System.Web.UI.Page.#TransactionMode", Justification = @"[....]: bug 148739 for follow-up, suggestion to add setters to page directive related properties")]
[module: SuppressMessage("Microsoft.Design", "CA1044:PropertiesShouldNotBeWriteOnly", Scope = "member", Target = "System.Web.UI.Page.#UICulture", Justification = @"[....]: bug 148739 for follow-up, suggestion to add setters to page directive related properties")]
[module: SuppressMessage("Microsoft.Naming", "CA1721:PropertyNamesShouldNotMatchGetMethods", Scope = "member", Target = "System.Web.UI.Page.#Validators", Justification = @"[....]: GetValidators takes a validatorGroup, which filters down the collection returned.")]
[module: SuppressMessage("Microsoft.Globalization", "CA1305:SpecifyIFormatProvider", Scope = "member", Target = "System.Web.UI.Page.#WalkViewState(System.Object,System.Web.UI.Control,System.Int32)", Justification = @"[....]: already excluded, accidental duplication in merge")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.UI.Page+PageAsyncInfo.#CallHandlers(System.Boolean)", Justification = @"[....]: Disregarding this rule because it doesn't make sense for our code.")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.UI.Page+PageAsyncInfo.#CallHandlersPossiblyUnderLock(System.Boolean)", Justification = @"[....]: Disregarding this rule because it doesn't make sense for our code.")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.UI.Page+PageAsyncInfo.#OnAsyncHandlerCompletion(System.IAsyncResult)", Justification = @"[....]: Disregarding this rule because it doesn't make sense for our code.")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.UI.PageAsyncTask.#CompleteTask(System.Boolean)", Justification = @"[....]: Disregarding this rule because it doesn't make sense for our code.")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.UI.PageAsyncTask.#Start(System.Web.UI.PageAsyncTaskManager,System.Object,System.EventArgs)", Justification = @"[....]: Disregarding this rule because it doesn't make sense for our code.")]
[module: SuppressMessage("Microsoft.Performance", "CA1812:AvoidUninstantiatedInternalClasses", Scope = "type", Target = "System.Web.UI.PageHandlerFactory", Justification = @"[....]: It's referenced via config.")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.UI.PageParser.#GetCompiledPageInstance(System.String,System.String,System.Web.HttpContext)", Justification = @"[....]: These are protected by a full declarative unmanaged code demand, which covers security on the methods.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.UI.PageParserFilter.#GetNoCompileUserControlType()", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "type", Target = "System.Web.UI.PageStatePersister", Justification = @"[....]: Persister is fine")]
[module: SuppressMessage("Microsoft.Naming", "CA1706:ShortAcronymsShouldBeUppercase", Scope = "member", Target = "System.Web.UI.PageTheme.#CreateSkinKey(System.Type,System.String)", MessageId = "1#", Justification = @"[....]: ""ID"" ok for ASP.NET")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.UI.PageTheme.#Eval(System.String)", Justification = @"[....]: This conform to V1 naming conventions and V2 specs")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.UI.PageTheme.#Eval(System.String,System.String)", Justification = @"[....]: This conform to V1 naming conventions and V2 specs")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope = "member", Target = "System.Web.UI.PageTheme.#LinkedStyleSheets", Justification = @"[....]: This property is only meant to be accessed internally and it's cheaper to use an array.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.UI.PageTheme.#XPath(System.String)", MessageId = "x", Justification = @"[....]: Spellings ok")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.UI.PageTheme.#XPath(System.String,System.String)", MessageId = "x", Justification = @"[....]: Spellings ok")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.UI.PageTheme.#XPath(System.String,System.String,System.Xml.IXmlNamespaceResolver)", MessageId = "x", Justification = @"[....]: Spellings ok")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.UI.PageTheme.#XPath(System.String,System.Xml.IXmlNamespaceResolver)", MessageId = "x", Justification = @"[....]: Spellings ok")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.UI.PageTheme.#XPathSelect(System.String)", MessageId = "x", Justification = @"[....]: Spellings ok")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.UI.PageTheme.#XPathSelect(System.String,System.Xml.IXmlNamespaceResolver)", MessageId = "x", Justification = @"[....]: Spellings ok")]
[module: SuppressMessage("Microsoft.Security", "CA2104:DoNotDeclareReadOnlyMutableReferenceTypes", Scope = "member", Target = "System.Web.UI.ParseChildrenAttribute.#Default", Justification = @"[....]: the properties of the referenced types are also not settable")]
[module: SuppressMessage("Microsoft.Security", "CA2104:DoNotDeclareReadOnlyMutableReferenceTypes", Scope = "member", Target = "System.Web.UI.ParseChildrenAttribute.#ParseAsChildren", Justification = @"[....]: the properties of the referenced types are also not settable")]
[module: SuppressMessage("Microsoft.Security", "CA2104:DoNotDeclareReadOnlyMutableReferenceTypes", Scope = "member", Target = "System.Web.UI.ParseChildrenAttribute.#ParseAsProperties", Justification = @"[....]: the properties of the referenced types are also not settable")]
[module: SuppressMessage("Microsoft.Design", "CA1035:ICollectionImplementationsHaveStronglyTypedMembers", Scope = "type", Target = "System.Web.UI.ParsedAttributeCollection", Justification = @"[....]: This takes objects so there can't be a strongly-typed version.")]
[module: SuppressMessage("Microsoft.Naming", "CA1710:IdentifiersShouldHaveCorrectSuffix", Scope = "type", Target = "System.Web.UI.ParsedAttributeCollection", Justification = @"[....]: breaking change to rename class with Dictionary suffix")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.UI.ParsedAttributeCollection.#GetFilteredAttributeDictionaries()", Justification = @"[....]: methods are preferred here")]
[module: SuppressMessage("Microsoft.Design", "CA1025:ReplaceRepetitiveArgumentsWithParamsArray", Scope = "member", Target = "System.Web.UI.PartialCachingAttribute.#.ctor(System.Int32,System.String,System.String,System.String)", Justification = @"[....]: The 3 different string parameters are unique.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.UI.PartialCachingAttribute.#.ctor(System.Int32,System.String,System.String,System.String,System.String,System.Boolean)", MessageId = "1#", Justification = @"[....]: Params is used as an abbreviation throughout the caching apis.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.UI.PartialCachingAttribute.#.ctor(System.Int32,System.String,System.String,System.String,System.String,System.Boolean)", MessageId = "Params", Justification = @"[....]: Spellings ok")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.UI.PartialCachingAttribute.#.ctor(System.Int32,System.String,System.String,System.String,System.String,System.String,System.Boolean)", MessageId = "Params", Justification = @"[....]: legacy")]
[module: SuppressMessage("Microsoft.Security", "CA2104:DoNotDeclareReadOnlyMutableReferenceTypes", Scope = "member", Target = "System.Web.UI.PersistChildrenAttribute.#Default", Justification = @"[....]: the properties of the referenced types are also not settable")]
[module: SuppressMessage("Microsoft.Security", "CA2104:DoNotDeclareReadOnlyMutableReferenceTypes", Scope = "member", Target = "System.Web.UI.PersistChildrenAttribute.#No", Justification = @"[....]: the properties of the referenced types are also not settable")]
[module: SuppressMessage("Microsoft.Security", "CA2104:DoNotDeclareReadOnlyMutableReferenceTypes", Scope = "member", Target = "System.Web.UI.PersistChildrenAttribute.#Yes", Justification = @"[....]: the properties of the referenced types are also not settable")]
[module: SuppressMessage("Microsoft.Security", "CA2104:DoNotDeclareReadOnlyMutableReferenceTypes", Scope = "member", Target = "System.Web.UI.PersistenceModeAttribute.#Attribute", Justification = @"[....]: the properties of the referenced types are also not settable")]
[module: SuppressMessage("Microsoft.Security", "CA2104:DoNotDeclareReadOnlyMutableReferenceTypes", Scope = "member", Target = "System.Web.UI.PersistenceModeAttribute.#Default", Justification = @"[....]: the properties of the referenced types are also not settable")]
[module: SuppressMessage("Microsoft.Security", "CA2104:DoNotDeclareReadOnlyMutableReferenceTypes", Scope = "member", Target = "System.Web.UI.PersistenceModeAttribute.#EncodedInnerDefaultProperty", Justification = @"[....]: the properties of the referenced types are also not settable")]
[module: SuppressMessage("Microsoft.Security", "CA2104:DoNotDeclareReadOnlyMutableReferenceTypes", Scope = "member", Target = "System.Web.UI.PersistenceModeAttribute.#InnerDefaultProperty", Justification = @"[....]: the properties of the referenced types are also not settable")]
[module: SuppressMessage("Microsoft.Security", "CA2104:DoNotDeclareReadOnlyMutableReferenceTypes", Scope = "member", Target = "System.Web.UI.PersistenceModeAttribute.#InnerProperty", Justification = @"[....]: the properties of the referenced types are also not settable")]
[module: SuppressMessage("Microsoft.Design", "CA1054:UriParametersShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.PostBackOptions.#.ctor(System.Web.UI.Control,System.String,System.String,System.Boolean,System.Boolean,System.Boolean,System.Boolean,System.Boolean,System.String)", MessageId = "2#", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.PostBackOptions.#ActionUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope = "member", Target = "System.Web.UI.PropertyConverter.#EnumFromString(System.Type,System.String)", Justification = @"[....]: general exception catching is OK")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.PropertyConverter.#EnumToString(System.Type,System.Object)", Justification = @"[....]: This class is safe for external use.")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope = "member", Target = "System.Web.UI.PropertyConverter.#ObjectFromString(System.Type,System.Reflection.MemberInfo,System.String)", Justification = @"[....]: general exception catching is OK")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope = "type", Target = "System.Web.UI.RenderMethod", Justification = @"NO_JUSTIFICATION_PROVIDED")]
[module: SuppressMessage("Microsoft.Usage", "CA2214:DoNotCallOverridableMethodsInConstructors", Scope = "member", Target = "System.Web.UI.ResourceBasedLiteralControl.#.ctor(System.Web.UI.TemplateControl,System.Int32,System.Int32,System.Boolean)", Justification = @"[....]: Technically not correct, but safe in this case.  Not worth taking the risk to change it.")]
[module: SuppressMessage("Microsoft.Usage", "CA2208:InstantiateArgumentExceptionsCorrectly", Scope = "member", Target = "System.Web.UI.ResourceBasedLiteralControl.#.ctor(System.Web.UI.TemplateControl,System.Int32,System.Int32,System.Boolean)", Justification = @"[....]: Very unlikely case.  No need for a special message.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "type", Target = "System.Web.UI.SessionPageStatePersister", Justification = @"[....]: Give me a break, Persister is a word! :-)")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope = "member", Target = "System.Web.UI.SessionPageStatePersister.#.ctor(System.Web.UI.Page)", Justification = @"[....]: It's fine here to catch all exceptions.")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.UI.SessionPageStatePersister.#Load()", Justification = @"[....]: Disregarding this rule because it doesn't make sense for our code.")]
[module: SuppressMessage("Microsoft.Performance", "CA1812:AvoidUninstantiatedInternalClasses", Scope = "type", Target = "System.Web.UI.SimpleHandlerFactory", Justification = @"[....]: code may be used for debug purposes and through reflection")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.UI.SimpleHandlerFactory.#.ctor()", Justification = @"[....]: Instantiated via config.")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.UI.SimpleWebHandlerParser.#.ctor(System.Web.HttpContext,System.String,System.String)", Justification = @"[....]: These are protected by a full declarative unmanaged code demand, which covers security on the methods.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.UI.SimpleWebHandlerParser.#GetCompiledTypeFromCache()", Justification = @"[....]: This existed in v1.")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.UI.SimpleWebHandlerParser.#GetType(System.String)", Justification = @"[....]: No need for a generic catch in this case.")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.UI.SimpleWebHandlerParser.#GetTypeToCache(System.Reflection.Assembly)", Justification = @"[....]: No need for a generic catch in this case.")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.UI.SimpleWebHandlerParser.#ParseReader()", Justification = @"[....]: No need for a generic catch in this case.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.SimpleWebHandlerParser.#System.Web.UI.IAssemblyDependencyParser.get_AssemblyDependencies()", Justification = @"[....]: IAssemblyDependencyParser is an internal interface, the property is not meant to be overriden.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.UI.StateBag.#SetDirty(System.Boolean)", Justification = @"[....]: SetDirty is accepted pattern for method name")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.StateBag.#System.Collections.ICollection.get_IsSynchronized()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.StateBag.#System.Collections.ICollection.get_SyncRoot()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.StateBag.#System.Collections.IDictionary.get_IsFixedSize()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.StateBag.#System.Collections.IDictionary.get_IsReadOnly()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.StateBag.#System.Collections.IDictionary.get_Item(System.Object)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.StateBag.#System.Collections.IDictionary.set_Item(System.Object,System.Object)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.StateManagedCollection.#CopyTo(System.Array,System.Int32)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.StateManagedCollection.#get_Count()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.StateManagedCollection.#GetEnumerator()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.UI.StateManagedCollection.#SetDirtyObject(System.Object)", Justification = @"[....]: A method is the logical choice here.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.StateManagedCollection.#System.Collections.ICollection.get_Count()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.StateManagedCollection.#System.Collections.ICollection.get_IsSynchronized()", Justification = @"[....]: Derived classes should never need to override these methods, and they should only be called via the interfaces.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.StateManagedCollection.#System.Collections.ICollection.get_IsSynchronized()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.StateManagedCollection.#System.Collections.ICollection.get_SyncRoot()", Justification = @"[....]: Derived classes should never need to override these methods, and they should only be called via the interfaces.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.StateManagedCollection.#System.Collections.ICollection.get_SyncRoot()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.StateManagedCollection.#System.Collections.IEnumerable.GetEnumerator()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.StateManagedCollection.#System.Collections.IList.Add(System.Object)", Justification = @"[....]: Derived collections should never need to change any of this functionality. Customization can be done via the OnXyz methods.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.StateManagedCollection.#System.Collections.IList.Add(System.Object)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.StateManagedCollection.#System.Collections.IList.Clear()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.StateManagedCollection.#System.Collections.IList.Contains(System.Object)", Justification = @"[....]: Derived collections should never need to change any of this functionality. Customization can be done via the OnXyz methods.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.StateManagedCollection.#System.Collections.IList.Contains(System.Object)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.StateManagedCollection.#System.Collections.IList.IndexOf(System.Object)", Justification = @"[....]: Derived collections should never need to change any of this functionality. Customization can be done via the OnXyz methods.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.StateManagedCollection.#System.Collections.IList.IndexOf(System.Object)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.StateManagedCollection.#System.Collections.IList.Insert(System.Int32,System.Object)", Justification = @"[....]: Derived collections should never need to change any of this functionality. Customization can be done via the OnXyz methods.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.StateManagedCollection.#System.Collections.IList.Insert(System.Int32,System.Object)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.StateManagedCollection.#System.Collections.IList.get_IsFixedSize()", Justification = @"[....]: Derived collections should never need to change any of this functionality. Customization can be done via the OnXyz methods.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.StateManagedCollection.#System.Collections.IList.get_IsFixedSize()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.StateManagedCollection.#System.Collections.IList.get_IsReadOnly()", Justification = @"[....]: Derived collections should never need to change any of this functionality. Customization can be done via the OnXyz methods.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.StateManagedCollection.#System.Collections.IList.get_IsReadOnly()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.StateManagedCollection.#System.Collections.IList.get_Item(System.Int32)", Justification = @"[....]: Derived collections should never need to change any of this functionality. Customization can be done via the OnXyz methods.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.StateManagedCollection.#System.Collections.IList.get_Item(System.Int32)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.StateManagedCollection.#System.Collections.IList.set_Item(System.Int32,System.Object)", Justification = @"[....]: Derived collections should never need to change any of this functionality. Customization can be done via the OnXyz methods.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.StateManagedCollection.#System.Collections.IList.set_Item(System.Int32,System.Object)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.StateManagedCollection.#System.Collections.IList.Remove(System.Object)", Justification = @"[....]: Derived collections should never need to change any of this functionality. Customization can be done via the OnXyz methods.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.StateManagedCollection.#System.Collections.IList.Remove(System.Object)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.StateManagedCollection.#System.Collections.IList.RemoveAt(System.Int32)", Justification = @"[....]: Derived collections should never need to change any of this functionality. Customization can be done via the OnXyz methods.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.StateManagedCollection.#System.Collections.IList.RemoveAt(System.Int32)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.StateManagedCollection.#System.Web.UI.IStateManager.get_IsTrackingViewState()", Justification = @"[....]: Derived classes should never need to override these methods, and they should only be called via the interfaces.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.StateManagedCollection.#System.Web.UI.IStateManager.LoadViewState(System.Object)", Justification = @"[....]: Derived classes should never need to override these methods, and they should only be called via the interfaces.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.StateManagedCollection.#System.Web.UI.IStateManager.SaveViewState()", Justification = @"[....]: Derived classes should never need to override these methods, and they should only be called via the interfaces.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.StateManagedCollection.#System.Web.UI.IStateManager.TrackViewState()", Justification = @"[....]: Derived classes should never need to override these methods, and they should only be called via the interfaces.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.UI.StaticPartialCachingControl.#.ctor(System.String,System.String,System.Int32,System.String,System.String,System.String,System.String,System.Web.UI.BuildMethod,System.String)", MessageId = "Params", Justification = @"[....]: legacy")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.UI.StaticPartialCachingControl.#.ctor(System.String,System.String,System.Int32,System.String,System.String,System.String,System.String,System.Web.UI.BuildMethod)", MessageId = "3#", Justification = @"[....]: parameter names not in the dictionary, but OK")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.UI.StaticPartialCachingControl.#.ctor(System.String,System.String,System.Int32,System.String,System.String,System.String,System.String,System.Web.UI.BuildMethod)", MessageId = "Params", Justification = @"[....]: Spellings ok")]
[module: SuppressMessage("Microsoft.Naming", "CA1706:ShortAcronymsShouldBeUppercase", Scope = "member", Target = "System.Web.UI.StaticPartialCachingControl.#.ctor(System.String,System.String,System.Int32,System.String,System.String,System.String,System.String,System.Web.UI.BuildMethod)", MessageId = "0#", Justification = @"[....]: ""ID"" ok for ASP.NET")]
[module: SuppressMessage("Microsoft.Design", "CA1011:ConsiderPassingBaseTypesAsParameters", Scope = "member", Target = "System.Web.UI.StaticPartialCachingControl.#BuildCachedControl(System.Web.UI.Control,System.String,System.String,System.Int32,System.String,System.String,System.String,System.String,System.Web.UI.BuildMethod,System.String)", Justification = @"[....]: legacy")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.UI.StaticPartialCachingControl.#BuildCachedControl(System.Web.UI.Control,System.String,System.String,System.Int32,System.String,System.String,System.String,System.String,System.Web.UI.BuildMethod,System.String)", MessageId = "Params", Justification = @"[....]: legacy")]
[module: SuppressMessage("Microsoft.Naming", "CA1706:ShortAcronymsShouldBeUppercase", Scope = "member", Target = "System.Web.UI.StaticPartialCachingControl.#BuildCachedControl(System.Web.UI.Control,System.String,System.String,System.Int32,System.String,System.String,System.String,System.String,System.Web.UI.BuildMethod,System.String)", MessageId = "1#", Justification = @"[....]: legacy")]
[module: SuppressMessage("Microsoft.Design", "CA1011:ConsiderPassingBaseTypesAsParameters", Scope = "member", Target = "System.Web.UI.StaticPartialCachingControl.#BuildCachedControl(System.Web.UI.Control,System.String,System.String,System.Int32,System.String,System.String,System.String,System.String,System.Web.UI.BuildMethod)", Justification = @"[....]: Method is an addition to an existing public method (excluded previously), so we should exclude this one as well.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.UI.StaticPartialCachingControl.#BuildCachedControl(System.Web.UI.Control,System.String,System.String,System.Int32,System.String,System.String,System.String,System.String,System.Web.UI.BuildMethod)", MessageId = "4#", Justification = @"[....]: parameter names not in the dictionary, but OK")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.UI.StaticPartialCachingControl.#BuildCachedControl(System.Web.UI.Control,System.String,System.String,System.Int32,System.String,System.String,System.String,System.String,System.Web.UI.BuildMethod)", MessageId = "Params", Justification = @"[....]: Spellings ok")]
[module: SuppressMessage("Microsoft.Naming", "CA1706:ShortAcronymsShouldBeUppercase", Scope = "member", Target = "System.Web.UI.StaticPartialCachingControl.#BuildCachedControl(System.Web.UI.Control,System.String,System.String,System.Int32,System.String,System.String,System.String,System.String,System.Web.UI.BuildMethod)", MessageId = "1#", Justification = @"[....]: ""ID"" ok for ASP.NET")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.Web.UI.TargetFrameworkUtil.#GetTypeDescriptionProvider(System.Object)", Justification = @"[....]: Calling this non-aptca method here does not seem to cause security vulnerabilities.")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.Web.UI.TargetFrameworkUtil.#GetTypeDescriptionProvider(System.Type)", Justification = @"[....]: Calling this non-aptca method here does not seem to cause security vulnerabilities.")]
[module: SuppressMessage("Microsoft.Usage", "CA2214:DoNotCallOverridableMethodsInConstructors", Scope = "member", Target = "System.Web.UI.TemplateControl.#.ctor()", Justification = @"[....]: I already excluded this earlier.  Not sure why it's back on the list.")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope = "member", Target = "System.Web.UI.TemplateControl.#_stringResourcePointer", Justification = @"[....]: I think IntPtr is fine here.")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.UI.TemplateControl.#AddStackContextToHashCode(System.Web.Util.HashCodeCombiner)", Justification = @"[....]: Seems like a bogus violation since the method is private")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.UI.TemplateControl.#Eval(System.String)", MessageId = "Eval", Justification = @"[....]: Spelling ok (V1 precedence)")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.UI.TemplateControl.#Eval(System.String,System.String)", MessageId = "Eval", Justification = @"[....]: Spelling ok (V1 precedence)")]
[module: SuppressMessage("Microsoft.Security", "CA2107:ReviewDenyAndPermitOnlyUsage", Scope = "member", Target = "System.Web.UI.TemplateControl.#FrameworkInitialize()", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.UI.TemplateControl.#GetDelegateInformationWithAssert(System.Collections.IDictionary)", Justification = @"[....]: This is an internal method so linkdemand does not apply here.")]
[module: SuppressMessage("Microsoft.Globalization", "CA1305:SpecifyIFormatProvider", Scope = "member", Target = "System.Web.UI.TemplateControl.#LoadControl(System.Type,System.Object[])", Justification = @"[....]: This is incorrect, there is no such call.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.TemplateControl.#OnAbortTransaction(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.TemplateControl.#OnCommitTransaction(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.TemplateControl.#OnError(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.TemplateControl.#System.Web.UI.IFilterResolutionService.CompareFilters(System.String,System.String)", Justification = @"[....]: These are not meant to be overridden.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.TemplateControl.#System.Web.UI.IFilterResolutionService.EvaluateFilter(System.String)", Justification = @"[....]: These are not meant to be overridden.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.UI.TemplateControl.#XPath(System.String)", MessageId = "x", Justification = @"[....]: Spellings ok")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.UI.TemplateControl.#XPath(System.String,System.String)", MessageId = "x", Justification = @"[....]: Spellings ok")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.UI.TemplateControl.#XPath(System.String,System.String,System.Xml.IXmlNamespaceResolver)", MessageId = "x", Justification = @"[....]: Apllings ok.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.UI.TemplateControl.#XPath(System.String,System.Xml.IXmlNamespaceResolver)", MessageId = "x", Justification = @"[....]: Apllings ok.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.UI.TemplateControl.#XPathSelect(System.String)", MessageId = "x", Justification = @"[....]: Spellings ok")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.UI.TemplateControl.#XPathSelect(System.String,System.Xml.IXmlNamespaceResolver)", MessageId = "x", Justification = @"[....]: Apllings ok.")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope = "type", Target = "System.Web.UI.TemplateControl+EventMethodInfo", Justification = @"[....]: Does not contain any unmanaged resources")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.UI.TemplateControlParser.#ProcessMainDirective(System.Collections.IDictionary)", Justification = @"[....]: Disregarding this rule because it doesn't make sense for our code.")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.UI.TemplateControlParser.#ProcessUnknownMainDirectiveAttribute(System.String,System.String,System.String)", Justification = @"[....]: Disregarding this rule because it doesn't make sense for our code.")]
[module: SuppressMessage("Microsoft.Security", "CA2112:SecuredTypesShouldNotExposeFields", Scope = "type", Target = "System.Web.UI.TemplateInstanceAttribute", Justification = @"[....]: It is ok to expose these static readonly fields even though the LinkDemand does not apply to them.")]
[module: SuppressMessage("Microsoft.Security", "CA2104:DoNotDeclareReadOnlyMutableReferenceTypes", Scope = "member", Target = "System.Web.UI.TemplateInstanceAttribute.#Default", Justification = @"[....]: These classes are immutable.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.TemplateInstanceAttribute.#Equals(System.Object)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.TemplateInstanceAttribute.#GetHashCode()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.TemplateInstanceAttribute.#IsDefaultAttribute()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2104:DoNotDeclareReadOnlyMutableReferenceTypes", Scope = "member", Target = "System.Web.UI.TemplateInstanceAttribute.#Multiple", Justification = @"[....]: These classes are immutable.")]
[module: SuppressMessage("Microsoft.Security", "CA2104:DoNotDeclareReadOnlyMutableReferenceTypes", Scope = "member", Target = "System.Web.UI.TemplateInstanceAttribute.#Single", Justification = @"[....]: These classes are immutable.")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.UI.TemplateParser.#MaybeTerminateControl(System.String,System.Int32)", Justification = @"[....]: It's fine in this case not to catch non Exception objects")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.UI.TemplateParser.#ParseStringInternal(System.String,System.Text.Encoding)", Justification = @"[....]: It's fine in this case not to catch non Exception objects")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.UI.TemplateParser.#PostProcessMainDirectiveAttributes(System.Collections.IDictionary)", Justification = @"[....]: It's fine in this case not to catch non Exception objects")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.UI.TemplateParser.#ProcessAttributes(System.Text.RegularExpressions.Match,System.Web.UI.ParsedAttributeCollection&,System.Boolean,System.String&)", Justification = @"[....]: It's fine in this case not to catch non Exception objects")]
[module: SuppressMessage("Microsoft.Performance", "CA1820:TestForEmptyStringsUsingStringLength", Scope = "member", Target = "System.Web.UI.TemplateParser.#ProcessAttributes(System.Text.RegularExpressions.Match,System.Web.UI.ParsedAttributeCollection&,System.Boolean,System.String&)", Justification = @"[....]: I changed it, but for some reaosn the violation remains...")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.UI.TemplateParser.#ProcessBeginTag(System.Text.RegularExpressions.Match,System.String)", Justification = @"[....]: It's fine in this case not to catch non Exception objects")]
[module: SuppressMessage("Microsoft.Performance", "CA1820:TestForEmptyStringsUsingStringLength", Scope = "member", Target = "System.Web.UI.TemplateParser.#ProcessDirective(System.String,System.Collections.IDictionary)", Justification = @"[....]: I changed it, but for some reaosn the violation remains...")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.UI.TemplateParser.#ProcessLiteral()", Justification = @"[....]: It's fine in this case not to catch non Exception objects")]
[module: SuppressMessage("Microsoft.Globalization", "CA1303:DoNotPassLiteralsAsLocalizedParameters", Scope = "member", Target = "System.Web.UI.TemplateParser.#ProcessLiteral()", MessageId = "System.Web.UI.TemplateParser.UpdateTypeHashCode(System.String)", Justification = @"[....]: Not a localizable string.")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.UI.TemplateParser.#ProcessMainDirective(System.Collections.IDictionary)", Justification = @"[....]: It's fine in this case not to catch non Exception objects")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.UI.TemplateParser.#ProcessMainDirectiveAttribute(System.String,System.String,System.String,System.Collections.IDictionary)", Justification = @"[....]: It's fine in this case not to catch non Exception objects")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.TemplateParser.#System.Web.UI.IAssemblyDependencyParser.get_AssemblyDependencies()", Justification = @"[....]: IAssemblyDependencyParser is an internal interface, the property is not meant to be overriden.")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.UI.TemplateParser.#get_Text()", Justification = @"[....]: That's a mistake, it is used.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "type", Target = "System.Web.UI.ThemeableAttribute", MessageId = "Themeable", Justification = @"[....]: Spellings ok")]
[module: SuppressMessage("Microsoft.Security", "CA2112:SecuredTypesShouldNotExposeFields", Scope = "type", Target = "System.Web.UI.ThemeableAttribute", Justification = @"[....]: It is ok to expose these static readonly fields even though the LinkDemand does not apply to them.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.UI.ThemeableAttribute.#.ctor(System.Boolean)", MessageId = "themeable", Justification = @"[....]: Spellings ok")]
[module: SuppressMessage("Microsoft.Security", "CA2104:DoNotDeclareReadOnlyMutableReferenceTypes", Scope = "member", Target = "System.Web.UI.ThemeableAttribute.#Default", Justification = @"[....]: ThemeableAttribute is an immutal types, the object state cannot be changed after initialized.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.ThemeableAttribute.#Equals(System.Object)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.ThemeableAttribute.#GetHashCode()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.ThemeableAttribute.#IsDefaultAttribute()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.UI.ThemeableAttribute.#IsObjectThemeable(System.Object)", MessageId = "Themeable", Justification = @"[....]: Spellings ok")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.UI.ThemeableAttribute.#IsTypeThemeable(System.Type)", MessageId = "Themeable", Justification = @"[....]: Spellings ok")]
[module: SuppressMessage("Microsoft.Security", "CA2104:DoNotDeclareReadOnlyMutableReferenceTypes", Scope = "member", Target = "System.Web.UI.ThemeableAttribute.#No", Justification = @"[....]: ThemeableAttribute is an immutal types, the object state cannot be changed after initialized.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.UI.ThemeableAttribute.#Themeable", MessageId = "Themeable", Justification = @"[....]: Spellings ok")]
[module: SuppressMessage("Microsoft.Security", "CA2104:DoNotDeclareReadOnlyMutableReferenceTypes", Scope = "member", Target = "System.Web.UI.ThemeableAttribute.#Yes", Justification = @"[....]: ThemeableAttribute is an immutal types, the object state cannot be changed after initialized.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.ThemeProvider.#GetSkinsForControl(System.Type)", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Security", "CA2104:DoNotDeclareReadOnlyMutableReferenceTypes", Scope = "member", Target = "System.Web.UI.ToolboxDataAttribute.#Default", Justification = @"[....]: Field is not mutable")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.UrlPropertyAttribute.#Equals(System.Object)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.UrlPropertyAttribute.#GetHashCode()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.UserControl.#OnInit(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.UserControl.#System.Web.UI.IAttributeAccessor.GetAttribute(System.String)", Justification = @"[....]: explicit implementations by design for information hiding")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.UserControl.#System.Web.UI.IAttributeAccessor.SetAttribute(System.String,System.String)", Justification = @"[....]: explicit implementations by design for information hiding")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.UserControl.#System.Web.UI.IUserControlDesignerAccessor.get_InnerText()", Justification = @"[....]: We don't want these to be overridden by anyone.  They are strictly a design-time accessor used for internal purposes.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.UserControl.#System.Web.UI.IUserControlDesignerAccessor.set_InnerText(System.String)", Justification = @"[....]: We don't want these to be overridden by anyone.  They are strictly a design-time accessor used for internal purposes.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.UserControl.#System.Web.UI.IUserControlDesignerAccessor.get_TagName()", Justification = @"[....]: We don't want these to be overridden by anyone.  They are strictly a design-time accessor used for internal purposes.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.UserControl.#System.Web.UI.IUserControlDesignerAccessor.set_TagName(System.String)", Justification = @"[....]: We don't want these to be overridden by anyone.  They are strictly a design-time accessor used for internal purposes.")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope = "member", Target = "System.Web.UI.Util.#DeleteFileNoException(System.String)", Justification = @"NO_JUSTIFICATION_PROVIDED")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.UI.Util.#DumpArrayList(System.String,System.Collections.ArrayList)", Justification = @"[....]: already excluded, accidental duplication in merge")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.UI.Util.#DumpDictionary(System.String,System.Collections.IDictionary)", Justification = @"[....]: already excluded, accidental duplication in merge")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.UI.Util.#DumpString(System.String,System.String)", Justification = @"[....]: already excluded, accidental duplication in merge")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope = "member", Target = "System.Web.UI.Util.#GetCurrentAccountName()", Justification = @"[....]: We want to catch everything that can go wrong here")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope = "member", Target = "System.Web.UI.Util.#HasWriteAccessToDirectory(System.String)", Justification = @"[....]: We want to catch everything that can go wrong here")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope = "member", Target = "System.Web.UI.Util.#IsNonEmptyDirectory(System.String)", Justification = @"NO_JUSTIFICATION_PROVIDED")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.UI.Util.#RemoveOrRenameFile(System.IO.FileInfo)", Justification = @"[....]: It's fine in this case not to catch non Exception objects")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope = "member", Target = "System.Web.UI.Util.#RemoveOrRenameFile(System.IO.FileInfo)", Justification = @"[....]: We want to catch everything that can go wrong here")]
[module: SuppressMessage("Microsoft.Design", "CA1054:UriParametersShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.VerificationAttribute.#.ctor(System.String,System.String,System.Web.UI.VerificationReportLevel,System.Int32,System.String,System.Web.UI.VerificationRule,System.String,System.Web.UI.VerificationConditionalOperator,System.String,System.String)", MessageId = "9#", Justification = @"[....]: Our url properties are commonly strings.")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.VerificationAttribute.#GuidelineUrl", Justification = @"[....]: Our url properties are commonly strings.")]
[module: SuppressMessage("Microsoft.Design", "CA1032:ImplementStandardExceptionConstructors", Scope = "type", Target = "System.Web.UI.ViewStateException", Justification = @"[....]: this exception can only be created internally")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.UI.ViewStateException.#GetObjectData(System.Runtime.Serialization.SerializationInfo,System.Runtime.Serialization.StreamingContext)", Justification = @"[....]: Interfaces and classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.ViewStateException.#GetObjectData(System.Runtime.Serialization.SerializationInfo,System.Runtime.Serialization.StreamingContext)", Justification = @"[....]: The AspNetHostingPermission link demand is applied only to AspNet classes.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.ViewStateException.#get_Message()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.UI.ViewStateException.#Referer", Justification = @"[....]: spelling is correct")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.UI.WebServiceParser.#GetCompiledType(System.String,System.Web.HttpContext)", Justification = @"[....]: That's ok because the demand on the method is stronger than the ones on the type.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "type", Target = "System.Web.UI.XhtmlMobileDocType", Justification = @"[....]: Xhtml is a word.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "type", Target = "System.Web.UI.XhtmlTextWriter", Justification = @"[....]: Xhtml is a word.")]
[module: SuppressMessage("Microsoft.Naming", "CA1720:AvoidTypeNamesInParameters", Scope = "member", Target = "System.Web.UI.XhtmlTextWriter.#.ctor(System.IO.TextWriter,System.String)", MessageId = "1#", Justification = @"[....]: Parameter name is for consistency with corresponding HtmlTextWriter constructor parameter from V1.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.UI.XhtmlTextWriter.#SetDocType(System.Web.UI.XhtmlMobileDocType)", Justification = @"[....]: explicit set action exposed as method instead of property by design")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.UI.XPathBinder.#Eval(System.Object,System.String)", Justification = @"[....]: This conforms to the v1.0 naming convention of DataBinder.Eval")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.UI.XPathBinder.#Eval(System.Object,System.String,System.String)", Justification = @"[....]: This conforms to the v1.0 naming convention of DataBinder.Eval")]
[module: SuppressMessage("Microsoft.Globalization", "CA1305:SpecifyIFormatProvider", Scope = "member", Target = "System.Web.UI.XPathBinder.#Eval(System.Object,System.String,System.String)", MessageId = "System.String.Format(System.String,System.Object)", Justification = @"[....]: The default current culture is supposed to be used here.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.UI.XPathBinder.#Eval(System.Object,System.String,System.String,System.Xml.IXmlNamespaceResolver)", MessageId = "x", Justification = @"[....]: Spellings ok")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.UI.XPathBinder.#Eval(System.Object,System.String,System.String,System.Xml.IXmlNamespaceResolver)", MessageId = "Eval", Justification = @"[....]: Spellings ok")]
[module: SuppressMessage("Microsoft.Globalization", "CA1305:SpecifyIFormatProvider", Scope = "member", Target = "System.Web.UI.XPathBinder.#Eval(System.Object,System.String,System.String,System.Xml.IXmlNamespaceResolver)", MessageId = "System.String.Format(System.String,System.Object)", Justification = @"[....]: The default current culture is supposed to be used here.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.UI.XPathBinder.#Eval(System.Object,System.String,System.Xml.IXmlNamespaceResolver)", MessageId = "x", Justification = @"[....]: Spellings ok")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.UI.XPathBinder.#Eval(System.Object,System.String,System.Xml.IXmlNamespaceResolver)", MessageId = "Eval", Justification = @"[....]: Spellings ok")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.UI.XPathBinder.#Select(System.Object,System.String)", MessageId = "x", Justification = @"[....]: Spellings ok")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.UI.XPathBinder.#Select(System.Object,System.String,System.Xml.IXmlNamespaceResolver)", MessageId = "x", Justification = @"[....]: Spellings ok")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.Adapters.ControlAdapter.#OnInit(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.Adapters.ControlAdapter.#OnLoad(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.Adapters.ControlAdapter.#OnPreRender(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.Adapters.ControlAdapter.#OnUnload(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.UI.Adapters.PageAdapter.#CacheVaryByParams", Justification = @"[....]: name is consistent with already public members")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.UI.Adapters.PageAdapter.#GetStatePersister()", Justification = @"[....]: Persister is a word.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.UI.Adapters.PageAdapter.#GetStatePersister()", Justification = @"[....]: GetStatePersister() is specified as a method.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.UI.Adapters.PageAdapter.#RenderBeginHyperlink(System.Web.UI.HtmlTextWriter,System.String,System.Boolean,System.String)", MessageId = "softkey", Justification = @"[....]: Spellings ok")]
[module: SuppressMessage("Microsoft.Design", "CA1054:UriParametersShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.Adapters.PageAdapter.#RenderBeginHyperlink(System.Web.UI.HtmlTextWriter,System.String,System.Boolean,System.String)", MessageId = "1#", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.UI.Adapters.PageAdapter.#RenderBeginHyperlink(System.Web.UI.HtmlTextWriter,System.String,System.Boolean,System.String,System.String)", MessageId = "softkey", Justification = @"[....]: Spellings ok")]
[module: SuppressMessage("Microsoft.Design", "CA1054:UriParametersShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.Adapters.PageAdapter.#RenderBeginHyperlink(System.Web.UI.HtmlTextWriter,System.String,System.Boolean,System.String,System.String)", MessageId = "1#", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.UI.Adapters.PageAdapter.#RenderPostBackEvent(System.Web.UI.HtmlTextWriter,System.String,System.String,System.String,System.String)", MessageId = "softkey", Justification = @"[....]: Spellings ok")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.UI.Adapters.PageAdapter.#RenderPostBackEvent(System.Web.UI.HtmlTextWriter,System.String,System.String,System.String,System.String,System.String,System.String)", MessageId = "softkey", Justification = @"[....]: Spellings ok")]
[module: SuppressMessage("Microsoft.Design", "CA1054:UriParametersShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.Adapters.PageAdapter.#RenderPostBackEvent(System.Web.UI.HtmlTextWriter,System.String,System.String,System.String,System.String,System.String,System.String)", MessageId = "5#", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.UI.Adapters.PageAdapter.#RenderPostBackEvent(System.Web.UI.HtmlTextWriter,System.String,System.String,System.String,System.String,System.String,System.String,System.Boolean)", MessageId = "softkey", Justification = @"[....]: Spellings ok")]
[module: SuppressMessage("Microsoft.Design", "CA1054:UriParametersShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.Adapters.PageAdapter.#RenderPostBackEvent(System.Web.UI.HtmlTextWriter,System.String,System.String,System.String,System.String,System.String,System.String,System.Boolean)", MessageId = "5#", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.HtmlControls.HtmlAnchor.#OnPreRender(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.HtmlControls.HtmlAnchor.#OnServerClick(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.UI.HtmlControls.HtmlAnchor.#RaisePostBackEvent(System.String)", Justification = @"[....]: Events are being used correctly for RaisePostBackEvent and RaisePostDataChangedEvent.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.HtmlControls.HtmlButton.#OnPreRender(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.HtmlControls.HtmlButton.#OnServerClick(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.UI.HtmlControls.HtmlButton.#RaisePostBackEvent(System.String)", Justification = @"[....]: Events are being used correctly for RaisePostBackEvent and RaisePostDataChangedEvent.")]
[module: SuppressMessage("Microsoft.Design", "CA1012:AbstractTypesShouldNotHaveConstructors", Scope = "type", Target = "System.Web.UI.HtmlControls.HtmlContainerControl", Justification = @"[....]: excluded for breaking change")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.UI.HtmlControls.HtmlControl.#PreProcessRelativeReferenceAttribute(System.Web.UI.HtmlTextWriter,System.String)", Justification = @"[....]: Disregarding this rule because it doesn't make sense for our code.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.HtmlControls.HtmlForm.#OnInit(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.HtmlControls.HtmlForm.#OnPreRender(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.HtmlControls.HtmlHead.#OnInit(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.HtmlControls.HtmlInputButton.#OnPreRender(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.HtmlControls.HtmlInputButton.#OnServerClick(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.UI.HtmlControls.HtmlInputButton.#RaisePostBackEvent(System.String)", Justification = @"[....]: Events are being used correctly for RaisePostBackEvent and RaisePostDataChangedEvent.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.HtmlControls.HtmlInputCheckBox.#OnPreRender(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.HtmlControls.HtmlInputCheckBox.#OnServerChange(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.UI.HtmlControls.HtmlInputCheckBox.#RaisePostDataChangedEvent()", Justification = @"[....]: Events are being used correctly for RaisePostBackEvent and RaisePostDataChangedEvent.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.HtmlControls.HtmlInputFile.#OnPreRender(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.UI.HtmlControls.HtmlInputFile.#RaisePostDataChangedEvent()", Justification = @"[....]: Events are being used correctly for RaisePostBackEvent and RaisePostDataChangedEvent.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.HtmlControls.HtmlInputHidden.#OnPreRender(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.HtmlControls.HtmlInputHidden.#OnServerChange(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.UI.HtmlControls.HtmlInputHidden.#RaisePostDataChangedEvent()", Justification = @"[....]: Events are being used correctly for RaisePostBackEvent and RaisePostDataChangedEvent.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.HtmlControls.HtmlInputImage.#OnPreRender(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.HtmlControls.HtmlInputImage.#OnServerClick(System.Web.UI.ImageClickEventArgs)", MessageId = "0#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.UI.HtmlControls.HtmlInputImage.#RaisePostBackEvent(System.String)", Justification = @"[....]: Events are being used correctly for RaisePostBackEvent and RaisePostDataChangedEvent.")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.UI.HtmlControls.HtmlInputImage.#RaisePostDataChangedEvent()", Justification = @"[....]: Events are being used correctly for RaisePostBackEvent and RaisePostDataChangedEvent.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.HtmlControls.HtmlInputRadioButton.#OnPreRender(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.HtmlControls.HtmlInputRadioButton.#OnServerChange(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.UI.HtmlControls.HtmlInputRadioButton.#RaisePostDataChangedEvent()", Justification = @"[....]: Events are being used correctly for RaisePostBackEvent and RaisePostDataChangedEvent.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.HtmlControls.HtmlInputText.#OnPreRender(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.HtmlControls.HtmlInputText.#OnServerChange(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.UI.HtmlControls.HtmlInputText.#RaisePostDataChangedEvent()", Justification = @"[....]: Events are being used correctly for RaisePostBackEvent and RaisePostDataChangedEvent.")]
[module: SuppressMessage("Microsoft.Naming", "CA1706:ShortAcronymsShouldBeUppercase", Scope = "member", Target = "System.Web.UI.HtmlControls.HtmlSelect.#DataSourceID", Justification = @"[....]: ""ID"" ok for ASP.NET")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.UI.HtmlControls.HtmlSelect.#GetData()", Justification = @"[....]: These are all according to the spec.")]
[module: SuppressMessage("Microsoft.Naming", "CA1706:ShortAcronymsShouldBeUppercase", Scope = "member", Target = "System.Web.UI.HtmlControls.HtmlSelect.#IsBoundUsingDataSourceID", Justification = @"[....]: ""ID"" ok for ASP.NET")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.HtmlControls.HtmlSelect.#OnDataBinding(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.HtmlControls.HtmlSelect.#OnDataSourceViewChanged(System.Object,System.EventArgs)", MessageId = "1#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.HtmlControls.HtmlSelect.#OnInit(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.HtmlControls.HtmlSelect.#OnLoad(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.HtmlControls.HtmlSelect.#OnPreRender(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.HtmlControls.HtmlSelect.#OnServerChange(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.UI.HtmlControls.HtmlSelect.#RaisePostDataChangedEvent()", Justification = @"[....]: Events are being used correctly for RaisePostBackEvent and RaisePostDataChangedEvent.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.HtmlControls.HtmlTable+HtmlTableRowControlCollection.#Add(System.Web.UI.Control)", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.HtmlControls.HtmlTable+HtmlTableRowControlCollection.#AddAt(System.Int32,System.Web.UI.Control)", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.HtmlControls.HtmlTableRow+HtmlTableCellControlCollection.#Add(System.Web.UI.Control)", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.HtmlControls.HtmlTableRow+HtmlTableCellControlCollection.#AddAt(System.Int32,System.Web.UI.Control)", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.HtmlControls.HtmlTextArea.#OnPreRender(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.HtmlControls.HtmlTextArea.#OnServerChange(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.UI.HtmlControls.HtmlTextArea.#RaisePostDataChangedEvent()", Justification = @"[....]: Events are being used correctly for RaisePostBackEvent and RaisePostDataChangedEvent.")]
[module: SuppressMessage("Microsoft.Usage", "CA2214:DoNotCallOverridableMethodsInConstructors", Scope = "member", Target = "System.Web.UI.WebControls.AccessDataSource.#.ctor(System.String,System.String)", Justification = @"[....]: These are just helper constructors, and it is unlikely that any bad behavior will result.")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope = "type", Target = "System.Web.UI.WebControls.AdCreatedEventHandler", Justification = @"NO_JUSTIFICATION_PROVIDED")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.UI.WebControls.AdRotator.#GetFileData(System.String)", Justification = @"[....]: Disregarding this rule because it doesn't make sense for our code.")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.AdRotator.#ImageUrlField", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.UI.WebControls.AdRotator.#LoadStream(System.IO.Stream)", Justification = @"[....]: Disregarding this rule because it doesn't make sense for our code.")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.AdRotator.#NavigateUrlField", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.AdRotator.#OnAdCreated(System.Web.UI.WebControls.AdCreatedEventArgs)", MessageId = "0#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.AdRotator.#OnInit(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.AdRotator.#OnPreRender(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope = "type", Target = "System.Web.UI.WebControls.AuthenticateEventHandler", Justification = @"NO_JUSTIFICATION_PROVIDED")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.AutoGeneratedField.#OnDataBindField(System.Object,System.EventArgs)", Justification = @"[....]: This method can be called at any time by anyone without a security risk.")]
[module: SuppressMessage("Microsoft.Design", "CA1021:AvoidOutParameters", Scope = "member", Target = "System.Web.UI.WebControls.BaseCompareValidator.#Convert(System.String,System.Web.UI.WebControls.ValidationDataType,System.Boolean,System.Object&)", MessageId = "3#", Justification = @"[....]: This has been the design from V1 that we need to return a bool as well as the  converted value.")]
[module: SuppressMessage("Microsoft.Design", "CA1021:AvoidOutParameters", Scope = "member", Target = "System.Web.UI.WebControls.BaseCompareValidator.#Convert(System.String,System.Web.UI.WebControls.ValidationDataType,System.Object&)", MessageId = "2#", Justification = @"[....]: Breaking change")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.UI.WebControls.BaseCompareValidator.#GetDateElementOrder()", Justification = @"[....]: Reviewed, and these are appropriate uses of methods.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.BaseDataBoundControl.#get_DataSource()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.BaseDataBoundControl.#set_DataSource(System.Object)", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Naming", "CA1706:ShortAcronymsShouldBeUppercase", Scope = "member", Target = "System.Web.UI.WebControls.BaseDataBoundControl.#DataSourceID", Justification = @"[....]: ""ID"" ok for ASP.NET")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.BaseDataBoundControl.#get_DataSourceID()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.BaseDataBoundControl.#set_DataSourceID(System.String)", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Naming", "CA1706:ShortAcronymsShouldBeUppercase", Scope = "member", Target = "System.Web.UI.WebControls.BaseDataBoundControl.#IsBoundUsingDataSourceID", Justification = @"[....]: ""ID"" ok for ASP.NET")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.BaseDataBoundControl.#OnDataBound(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.BaseDataBoundControl.#OnInit(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "member", Target = "System.Web.UI.WebControls.BaseDataBoundControl.#OnPagePreLoad(System.Object,System.EventArgs)", MessageId = "PreLoad", Justification = @"[....]: Spellings ok.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.BaseDataBoundControl.#OnPagePreLoad(System.Object,System.EventArgs)", MessageId = "1#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.BaseDataBoundControl.#OnPreRender(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Naming", "CA1706:ShortAcronymsShouldBeUppercase", Scope = "member", Target = "System.Web.UI.WebControls.BaseDataList.#DataSourceID", Justification = @"[....]: ""ID"" ok for ASP.NET")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.UI.WebControls.BaseDataList.#GetData()", Justification = @"[....]: These are all according to the spec")]
[module: SuppressMessage("Microsoft.Naming", "CA1706:ShortAcronymsShouldBeUppercase", Scope = "member", Target = "System.Web.UI.WebControls.BaseDataList.#IsBoundUsingDataSourceID", Justification = @"[....]: ""ID"" ok for ASP.NET")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.BaseDataList.#OnDataBinding(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.BaseDataList.#OnDataSourceViewChanged(System.Object,System.EventArgs)", MessageId = "1#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.BaseDataList.#OnInit(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.BaseDataList.#OnLoad(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.BaseDataList.#OnPreRender(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.BaseDataList.#OnSelectedIndexChanged(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Usage", "CA2214:DoNotCallOverridableMethodsInConstructors", Scope = "member", Target = "System.Web.UI.WebControls.BaseValidator.#.ctor()", Justification = @"[....]: Do not expect this would be broken by derived classes.  Also this code is from earlier version.  If it is changed it would introduce breaking changes.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.BaseValidator.#OnInit(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.BaseValidator.#OnPreRender(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.BaseValidator.#OnUnload(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Security", "CA2112:SecuredTypesShouldNotExposeFields", Scope = "type", Target = "System.Web.UI.WebControls.BoundField", Justification = @"[....]: thisExpr is not a security risk.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.UI.WebControls.BoundField.#GetDesignTimeValue()", Justification = @"[....]: GetDesignTimeHtml does an operation that makes more sense as a method.")]
[module: SuppressMessage("Microsoft.Design", "CA1011:ConsiderPassingBaseTypesAsParameters", Scope = "member", Target = "System.Web.UI.WebControls.BoundField.#InitializeDataCell(System.Web.UI.WebControls.DataControlFieldCell,System.Web.UI.WebControls.DataControlRowState)", Justification = @"[....]: We want to enforce that this is instantiated inside a cell.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.BoundField.#OnDataBindField(System.Object,System.EventArgs)", Justification = @"[....]: This method can be called at any time by anyone without a security risk.")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.BulletedList.#BulletImageUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.BulletedList.#OnClick(System.Web.UI.WebControls.BulletedListEventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.UI.WebControls.BulletedList.#RaisePostBackEvent(System.String)", Justification = @"[....]: This method raises events, but is not an event.")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "member", Target = "System.Web.UI.WebControls.BulletedListDisplayMode.#HyperLink", MessageId = "HyperLink", Justification = @"[....]: Spellings ok.")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope = "type", Target = "System.Web.UI.WebControls.BulletedListEventHandler", Justification = @"NO_JUSTIFICATION_PROVIDED")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.UI.WebControls.Button.#GetPostBackOptions()", Justification = @"[....]: This makes sense as a function because it's doing complex work.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.Button.#OnClick(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.Button.#OnCommand(System.Web.UI.WebControls.CommandEventArgs)", MessageId = "0#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.Button.#OnPreRender(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Reviewed the method for trying to find security issues per the instructions of the FxCop rule.  All this method does if to register client-side script if necessary.  There is no security issue.")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.UI.WebControls.Button.#RaisePostBackEvent(System.String)", Justification = @"[....]: RaisePostBackEvent and RaiseDataChangedEvent are correctly following the .Net event model.")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.ButtonField.#ImageUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.Calendar.#OnPreRender(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.UI.WebControls.Calendar.#RaisePostBackEvent(System.String)", Justification = @"[....]: This is not an event, but raises events.")]
[module: SuppressMessage("Microsoft.Performance", "CA1803:AvoidCostlyCallsWherePossible", Scope = "member", Target = "System.Web.UI.WebControls.Calendar.#Render(System.Web.UI.HtmlTextWriter)", Justification = @"[....]: This rule fails to recognize System.Web.UI.WebControls.Unit which is a struct and has already overridden Object.Equals(bool).  It still complains the usage in System.Web.UI.WebControls.Calendar.Render(HtmlTextWriter).  I have reported this to FxCop bug report alias.")]
[module: SuppressMessage("Microsoft.Security", "CA2112:SecuredTypesShouldNotExposeFields", Scope = "type", Target = "System.Web.UI.WebControls.ChangePassword", Justification = @"[....]: These are just public readonly strings.")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.ChangePassword.#CancelButtonImageUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.ChangePassword.#CancelDestinationPageUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.ChangePassword.#ChangePasswordButtonImageUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.ChangePassword.#ContinueButtonImageUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.ChangePassword.#ContinueDestinationPageUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.ChangePassword.#CreateUserIconUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.ChangePassword.#CreateUserUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.ChangePassword.#EditProfileIconUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.ChangePassword.#EditProfileUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.ChangePassword.#HelpPageIconUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.ChangePassword.#HelpPageUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "member", Target = "System.Web.UI.WebControls.ChangePassword.#HyperLinkStyle", MessageId = "HyperLink", Justification = @"[....]: Spellings ok.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.ChangePassword.#OnBubbleEvent(System.Object,System.EventArgs)", MessageId = "1#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.ChangePassword.#OnCancelButtonClick(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.ChangePassword.#OnChangedPassword(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.ChangePassword.#OnChangePasswordError(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.ChangePassword.#OnChangingPassword(System.Web.UI.WebControls.LoginCancelEventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.ChangePassword.#OnContinueButtonClick(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.ChangePassword.#OnInit(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.ChangePassword.#OnPreRender(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.ChangePassword.#OnSendingMail(System.Web.UI.WebControls.MailMessageEventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.ChangePassword.#OnSendMailError(System.Web.UI.WebControls.SendMailErrorEventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.ChangePassword.#PasswordRecoveryIconUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.ChangePassword.#PasswordRecoveryUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.UI.WebControls.ChangePassword.#SetDesignModeState(System.Collections.IDictionary)", Justification = @"[....]: The security attribute at the method level is more secured than the type one, therefore the LinkDemand is not necessary.")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.ChangePassword.#SuccessPageUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Globalization", "CA1303:DoNotPassLiteralsAsLocalizedParameters", Scope = "member", Target = "System.Web.UI.WebControls.ChangePassword+DefaultChangePasswordTemplate.#LayoutControls(System.Web.UI.WebControls.ChangePassword+ChangePasswordContainer)", MessageId = "System.Web.UI.LiteralControl.set_Text(System.String)", Justification = @"[....]: html strings")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.CheckBox.#OnCheckedChanged(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.CheckBox.#OnPreRender(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.UI.WebControls.CheckBox.#RaisePostDataChangedEvent()", Justification = @"[....]: RaisePostBackEvent and RaiseDataChangedEvent are correctly following the .Net event model.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.CheckBoxField.#OnDataBindField(System.Object,System.EventArgs)", Justification = @"[....]: This method can be called at any time by anyone without a security risk.")]
[module: SuppressMessage("Microsoft.Usage", "CA2214:DoNotCallOverridableMethodsInConstructors", Scope = "member", Target = "System.Web.UI.WebControls.CheckBoxList.#.ctor()", Justification = @"[....]: I sealed the virtual property (Controls) that is called in the ctor.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.CheckBoxList.#OnPreRender(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.UI.WebControls.CheckBoxList.#RaisePostDataChangedEvent()", Justification = @"[....]: RaisePostBackEvent and RaiseDataChangedEvent are correctly following the .Net event model.")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "type", Target = "System.Web.UI.WebControls.CircleHotSpot", MessageId = "HotSpot", Justification = @"[....]: Spellings ok.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.CommandEventArgs.#.ctor(System.Web.UI.WebControls.CommandEventArgs)", MessageId = "0#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope = "type", Target = "System.Web.UI.WebControls.CommandEventHandler", Justification = @"NO_JUSTIFICATION_PROVIDED")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.CommandField.#CancelImageUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.CommandField.#DeleteImageUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.CommandField.#EditImageUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Globalization", "CA1303:DoNotPassLiteralsAsLocalizedParameters", Scope = "member", Target = "System.Web.UI.WebControls.CommandField.#InitializeCell(System.Web.UI.WebControls.DataControlFieldCell,System.Web.UI.WebControls.DataControlCellType,System.Web.UI.WebControls.DataControlRowState,System.Int32)", MessageId = "System.Web.UI.LiteralControl.#ctor(System.String)", Justification = @"[....]: &nbsp; is an acceptable spelling and string for non-breaking space.")]
[module: SuppressMessage("Microsoft.Usage", "CA2204:LiteralsShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.UI.WebControls.CommandField.#InitializeCell(System.Web.UI.WebControls.DataControlFieldCell,System.Web.UI.WebControls.DataControlCellType,System.Web.UI.WebControls.DataControlRowState,System.Int32)", MessageId = "nbsp", Justification = @"[....]: &nbsp; is an acceptable spelling and string for non-breaking space.")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.CommandField.#InsertImageUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.CommandField.#NewImageUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.CommandField.#SelectImageUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.CommandField.#get_ShowDeleteButton()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.CommandField.#get_ShowEditButton()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.CommandField.#get_ShowInsertButton()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.CommandField.#get_ShowSelectButton()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.CommandField.#UpdateImageUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.WebControls.CompositeControl.#System.Web.UI.WebControls.ICompositeControlDesignerAccessor.RecreateChildControls()", Justification = @"[....]: This is an internal plumbing interface.")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "member", Target = "System.Web.UI.WebControls.Content.#ContentPlaceHolderID", MessageId = "PlaceHolder", Justification = @"[....]: Spellings ok.")]
[module: SuppressMessage("Microsoft.Naming", "CA1706:ShortAcronymsShouldBeUppercase", Scope = "member", Target = "System.Web.UI.WebControls.Content.#ContentPlaceHolderID", Justification = @"[....]: ""ID"" ok for ASP.NET")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "type", Target = "System.Web.UI.WebControls.ContentPlaceHolder", MessageId = "PlaceHolder", Justification = @"[....]: Spellings ok.")]
[module: SuppressMessage("Microsoft.Naming", "CA1706:ShortAcronymsShouldBeUppercase", Scope = "type", Target = "System.Web.UI.WebControls.ControlIDConverter", Justification = @"[....]: We use ID in our code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1706:ShortAcronymsShouldBeUppercase", Scope = "member", Target = "System.Web.UI.WebControls.ControlParameter.#.ctor(System.String,System.String)", MessageId = "1#", Justification = @"[....]: ""ID"" ok for ASP.NET")]
[module: SuppressMessage("Microsoft.Naming", "CA1706:ShortAcronymsShouldBeUppercase", Scope = "member", Target = "System.Web.UI.WebControls.ControlParameter.#.ctor(System.String,System.String,System.String)", MessageId = "1#", Justification = @"[....]: ""ID"" ok for ASP.NET")]
[module: SuppressMessage("Microsoft.Naming", "CA1706:ShortAcronymsShouldBeUppercase", Scope = "member", Target = "System.Web.UI.WebControls.ControlParameter.#.ctor(System.String,System.TypeCode,System.String,System.String)", MessageId = "2#", Justification = @"[....]: ""ID"" ok for ASP.NET")]
[module: SuppressMessage("Microsoft.Naming", "CA1706:ShortAcronymsShouldBeUppercase", Scope = "member", Target = "System.Web.UI.WebControls.ControlParameter.#ControlID", Justification = @"[....]: ""ID"" ok for ASP.NET")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.ControlParameter.#get_ControlID()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.ControlParameter.#get_PropertyName()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.CookieParameter.#get_CookieName()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope = "type", Target = "System.Web.UI.WebControls.CreateUserErrorEventHandler", Justification = @"NO_JUSTIFICATION_PROVIDED")]
[module: SuppressMessage("Microsoft.Security", "CA2112:SecuredTypesShouldNotExposeFields", Scope = "type", Target = "System.Web.UI.WebControls.CreateUserWizard", Justification = @"[....]: These are static readonly strings that do not expose any security threats.")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.CreateUserWizard.#ContinueButtonImageUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.CreateUserWizard.#ContinueDestinationPageUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.CreateUserWizard.#CreateUserButtonImageUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "member", Target = "System.Web.UI.WebControls.CreateUserWizard.#DisplaySideBar", MessageId = "SideBar", Justification = @"[....]: Spellings ok.")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.CreateUserWizard.#EditProfileIconUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.CreateUserWizard.#EditProfileUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.UI.WebControls.CreateUserWizard.#GetDesignModeState()", Justification = @"[....]: The security attribute at the method level is more secured than the type one, therefore the LinkDemand is not necessary.")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.CreateUserWizard.#HelpPageIconUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.CreateUserWizard.#HelpPageUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "member", Target = "System.Web.UI.WebControls.CreateUserWizard.#HyperLinkStyle", MessageId = "HyperLink", Justification = @"[....]: Spellings ok.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.CreateUserWizard.#OnBubbleEvent(System.Object,System.EventArgs)", MessageId = "1#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.CreateUserWizard.#OnContinueButtonClick(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.CreateUserWizard.#OnCreatedUser(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.CreateUserWizard.#OnCreateUserError(System.Web.UI.WebControls.CreateUserErrorEventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.CreateUserWizard.#OnCreatingUser(System.Web.UI.WebControls.LoginCancelEventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.CreateUserWizard.#OnNextButtonClick(System.Web.UI.WebControls.WizardNavigationEventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.CreateUserWizard.#OnPreRender(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.CreateUserWizard.#OnSendingMail(System.Web.UI.WebControls.MailMessageEventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.CreateUserWizard.#OnSendMailError(System.Web.UI.WebControls.SendMailErrorEventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.UI.WebControls.CreateUserWizard.#SetDesignModeState(System.Collections.IDictionary)", Justification = @"[....]: The security attribute at the method level is more secured than the type one, therefore the LinkDemand is not necessary.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.DataBoundControl.#get_DataMember()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.DataBoundControl.#set_DataMember(System.String)", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.UI.WebControls.DataBoundControl.#GetData()", Justification = @"[....]: These are all according to the spec")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.UI.WebControls.DataBoundControl.#GetDataSource()", Justification = @"[....]: These are all according to the spec")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.DataBoundControl.#OnDataSourceViewChanged(System.Object,System.EventArgs)", MessageId = "1#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.DataBoundControl.#OnLoad(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "member", Target = "System.Web.UI.WebControls.DataBoundControl.#OnPagePreLoad(System.Object,System.EventArgs)", MessageId = "PreLoad", Justification = @"[....]: Spellings ok.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.DataBoundControl.#OnPagePreLoad(System.Object,System.EventArgs)", MessageId = "1#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2112:SecuredTypesShouldNotExposeFields", Scope = "type", Target = "System.Web.UI.WebControls.DataControlCommands", Justification = @"[....]: These fields are benign")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.DataControlField.#get_FooterStyle()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.DataControlField.#HeaderImageUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.DataControlField.#get_HeaderStyle()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.DataControlField.#get_HeaderText()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Design", "CA1011:ConsiderPassingBaseTypesAsParameters", Scope = "member", Target = "System.Web.UI.WebControls.DataControlField.#InitializeCell(System.Web.UI.WebControls.DataControlFieldCell,System.Web.UI.WebControls.DataControlCellType,System.Web.UI.WebControls.DataControlRowState,System.Int32)", Justification = @"[....]: We want to enforce that this is instantiated inside a cell.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.DataControlField.#get_ItemStyle()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.WebControls.DataControlField.#System.Web.UI.IDataSourceViewSchemaAccessor.get_DataSourceViewSchema()", Justification = @"[....]: We don't want these to be overridable, so they are strictly privately implemented.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.WebControls.DataControlField.#System.Web.UI.IDataSourceViewSchemaAccessor.set_DataSourceViewSchema(System.Object)", Justification = @"[....]: We don't want these to be overridable, so they are strictly privately implemented.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.WebControls.DataControlField.#ToString()", Justification = @"[....]: Object::ToString() has no link demand, but our class does.  Benign.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.WebControls.DataControlFieldCollection.#CreateKnownType(System.Int32)", Justification = @"[....]: A sealed class does not need an Inheritance demand.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.WebControls.DataControlFieldCollection.#GetKnownTypes()", Justification = @"[....]: A sealed class does not need an Inheritance demand.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.DataControlFieldCollection.#get_Item(System.Int32)", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.WebControls.DataControlFieldCollection.#OnClearComplete()", Justification = @"[....]: A sealed class does not need an Inheritance demand.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.WebControls.DataControlFieldCollection.#OnInsertComplete(System.Int32,System.Object)", Justification = @"[....]: A sealed class does not need an Inheritance demand.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.WebControls.DataControlFieldCollection.#OnRemoveComplete(System.Int32,System.Object)", Justification = @"[....]: A sealed class does not need an Inheritance demand.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.WebControls.DataControlFieldCollection.#OnValidate(System.Object)", Justification = @"[....]: A sealed class does not need an Inheritance demand.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.WebControls.DataControlFieldCollection.#SetDirtyObject(System.Object)", Justification = @"[....]: A sealed class does not need an Inheritance demand.")]
[module: SuppressMessage("Microsoft.Design", "CA1008:EnumsShouldHaveZeroValue", Scope = "type", Target = "System.Web.UI.WebControls.DataControlRowState", Justification = @"[....]: Normal describes the state better than None.")]
[module: SuppressMessage("Microsoft.Naming", "CA1714:FlagsEnumsShouldHavePluralNames", Scope = "type", Target = "System.Web.UI.WebControls.DataControlRowState", Justification = @"[....]: Since it represents a state, I don't think this needs to be pluralized.")]
[module: SuppressMessage("Microsoft.Globalization", "CA1303:DoNotPassLiteralsAsLocalizedParameters", Scope = "member", Target = "System.Web.UI.WebControls.DataGrid.#InitializePager(System.Web.UI.WebControls.DataGridItem,System.Int32,System.Web.UI.WebControls.PagedDataSource)", MessageId = "System.Web.UI.LiteralControl.#ctor(System.String)", Justification = @"[....]: This is the correct spelling for non-breaking space, and not localized.")]
[module: SuppressMessage("Microsoft.Globalization", "CA1303:DoNotPassLiteralsAsLocalizedParameters", Scope = "member", Target = "System.Web.UI.WebControls.DataGrid.#InitializePager(System.Web.UI.WebControls.DataGridItem,System.Int32,System.Web.UI.WebControls.PagedDataSource)", MessageId = "System.Web.UI.WebControls.IButtonControl.set_Text(System.String)", Justification = @"[....]: The ""..."" is acceptable for all languages")]
[module: SuppressMessage("Microsoft.Globalization", "CA1303:DoNotPassLiteralsAsLocalizedParameters", Scope = "member", Target = "System.Web.UI.WebControls.DataGrid.#InitializePager(System.Web.UI.WebControls.DataGridItem,System.Int32,System.Web.UI.WebControls.PagedDataSource)", MessageId = "System.Web.UI.WebControls.LinkButton.set_Text(System.String)", Justification = @"[....]: This is the correct spelling for non-breaking space, and not localized.")]
[module: SuppressMessage("Microsoft.Usage", "CA2204:LiteralsShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.UI.WebControls.DataGrid.#InitializePager(System.Web.UI.WebControls.DataGridItem,System.Int32,System.Web.UI.WebControls.PagedDataSource)", MessageId = "nbsp", Justification = @"[....]: This is the correct spelling for non-breaking space.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.DataGrid.#OnBubbleEvent(System.Object,System.EventArgs)", MessageId = "1#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.DataGrid.#OnCancelCommand(System.Web.UI.WebControls.DataGridCommandEventArgs)", MessageId = "0#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.DataGrid.#OnDeleteCommand(System.Web.UI.WebControls.DataGridCommandEventArgs)", MessageId = "0#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.DataGrid.#OnEditCommand(System.Web.UI.WebControls.DataGridCommandEventArgs)", MessageId = "0#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.DataGrid.#OnItemCommand(System.Web.UI.WebControls.DataGridCommandEventArgs)", MessageId = "0#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.DataGrid.#OnItemCreated(System.Web.UI.WebControls.DataGridItemEventArgs)", MessageId = "0#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.DataGrid.#OnItemDataBound(System.Web.UI.WebControls.DataGridItemEventArgs)", MessageId = "0#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.DataGrid.#OnPageIndexChanged(System.Web.UI.WebControls.DataGridPageChangedEventArgs)", MessageId = "0#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.DataGrid.#OnSortCommand(System.Web.UI.WebControls.DataGridSortCommandEventArgs)", MessageId = "0#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.DataGrid.#OnUpdateCommand(System.Web.UI.WebControls.DataGridCommandEventArgs)", MessageId = "0#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.DataGridCommandEventArgs.#.ctor(System.Web.UI.WebControls.DataGridItem,System.Object,System.Web.UI.WebControls.CommandEventArgs)", MessageId = "2#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope = "type", Target = "System.Web.UI.WebControls.DataGridCommandEventHandler", Justification = @"NO_JUSTIFICATION_PROVIDED")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.DataGridItem.#OnBubbleEvent(System.Object,System.EventArgs)", MessageId = "1#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.UI.WebControls.DataGridItem.#SetItemType(System.Web.UI.WebControls.ListItemType)", Justification = @"[....]: Reviewed, and these are appropriate uses of methods.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.WebControls.DataGridItem.#System.Web.UI.IDataItemContainer.get_DataItemIndex()", Justification = @"[....]: These are overridable by overriding properties on the control.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.WebControls.DataGridItem.#System.Web.UI.IDataItemContainer.get_DisplayIndex()", Justification = @"[....]: These are overridable by overriding properties on the control.")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope = "type", Target = "System.Web.UI.WebControls.DataGridItemEventHandler", Justification = @"NO_JUSTIFICATION_PROVIDED")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope = "type", Target = "System.Web.UI.WebControls.DataGridPageChangedEventHandler", Justification = @"NO_JUSTIFICATION_PROVIDED")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.DataGridSortCommandEventArgs.#.ctor(System.Object,System.Web.UI.WebControls.DataGridCommandEventArgs)", MessageId = "1#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope = "type", Target = "System.Web.UI.WebControls.DataGridSortCommandEventHandler", Justification = @"NO_JUSTIFICATION_PROVIDED")]
[module: SuppressMessage("Microsoft.Naming", "CA1710:IdentifiersShouldHaveCorrectSuffix", Scope = "type", Target = "System.Web.UI.WebControls.DataKeyArray", Justification = @"[....]: Unfortunately, we already shipped a DataKeyCollection class, so we needed a new name.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.WebControls.DataKeyArray.#get_Count()", Justification = @"[....]: Sealed classes do not require an inheritance demand.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.WebControls.DataKeyArray.#GetEnumerator()", Justification = @"[....]: Sealed classes do not require an inheritance demand.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.WebControls.DataKeyArray.#get_IsSynchronized()", Justification = @"[....]: Sealed classes do not require an inheritance demand.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.WebControls.DataKeyArray.#get_SyncRoot()", Justification = @"[....]: Sealed classes do not require an inheritance demand.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.WebControls.DataKeyArray.#System.Collections.ICollection.CopyTo(System.Array,System.Int32)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.DataList.#OnBubbleEvent(System.Object,System.EventArgs)", MessageId = "1#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.DataList.#OnCancelCommand(System.Web.UI.WebControls.DataListCommandEventArgs)", MessageId = "0#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.DataList.#OnDeleteCommand(System.Web.UI.WebControls.DataListCommandEventArgs)", MessageId = "0#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.DataList.#OnEditCommand(System.Web.UI.WebControls.DataListCommandEventArgs)", MessageId = "0#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.DataList.#OnInit(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.DataList.#OnItemCommand(System.Web.UI.WebControls.DataListCommandEventArgs)", MessageId = "0#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.DataList.#OnItemCreated(System.Web.UI.WebControls.DataListItemEventArgs)", MessageId = "0#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.DataList.#OnItemDataBound(System.Web.UI.WebControls.DataListItemEventArgs)", MessageId = "0#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.DataList.#OnUpdateCommand(System.Web.UI.WebControls.DataListCommandEventArgs)", MessageId = "0#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.WebControls.DataList.#System.Web.UI.WebControls.IRepeatInfoUser.GetItemStyle(System.Web.UI.WebControls.ListItemType,System.Int32)", Justification = @"[....]: We won't change DataList's OM.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.WebControls.DataList.#System.Web.UI.WebControls.IRepeatInfoUser.get_HasFooter()", Justification = @"[....]: We won't change DataList's OM.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.WebControls.DataList.#System.Web.UI.WebControls.IRepeatInfoUser.get_HasHeader()", Justification = @"[....]: We won't change DataList's OM.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.WebControls.DataList.#System.Web.UI.WebControls.IRepeatInfoUser.get_HasSeparators()", Justification = @"[....]: We won't change DataList's OM.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.WebControls.DataList.#System.Web.UI.WebControls.IRepeatInfoUser.RenderItem(System.Web.UI.WebControls.ListItemType,System.Int32,System.Web.UI.WebControls.RepeatInfo,System.Web.UI.HtmlTextWriter)", Justification = @"[....]: We won't change DataList's OM.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.WebControls.DataList.#System.Web.UI.WebControls.IRepeatInfoUser.get_RepeatedItemCount()", Justification = @"[....]: We won't change DataList's OM.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.DataListCommandEventArgs.#.ctor(System.Web.UI.WebControls.DataListItem,System.Object,System.Web.UI.WebControls.CommandEventArgs)", MessageId = "2#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope = "type", Target = "System.Web.UI.WebControls.DataListCommandEventHandler", Justification = @"NO_JUSTIFICATION_PROVIDED")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.DataListItem.#OnBubbleEvent(System.Object,System.EventArgs)", MessageId = "1#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.UI.WebControls.DataListItem.#SetItemType(System.Web.UI.WebControls.ListItemType)", Justification = @"[....]: Reviewed, and these are appropriate uses of methods.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.WebControls.DataListItem.#System.Web.UI.IDataItemContainer.get_DataItemIndex()", Justification = @"[....]: These are overridable by overriding the corresponding properties on the control.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.WebControls.DataListItem.#System.Web.UI.IDataItemContainer.get_DisplayIndex()", Justification = @"[....]: These are overridable by overriding the corresponding properties on the control.")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope = "type", Target = "System.Web.UI.WebControls.DataListItemEventHandler", Justification = @"NO_JUSTIFICATION_PROVIDED")]
[module: SuppressMessage("Microsoft.Design", "CA1054:UriParametersShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.DayRenderEventArgs.#.ctor(System.Web.UI.WebControls.TableCell,System.Web.UI.WebControls.CalendarDay,System.String)", MessageId = "2#", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.DayRenderEventArgs.#SelectUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope = "type", Target = "System.Web.UI.WebControls.DayRenderEventHandler", Justification = @"NO_JUSTIFICATION_PROVIDED")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.DetailsView.#get_AllowPaging()", Justification = @"[....]: Designers run under full trust.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.DetailsView.#get_AlternatingRowStyle()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.DetailsView.#get_AutoGenerateDeleteButton()", Justification = @"[....]: Designers run under full trust.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.DetailsView.#get_AutoGenerateEditButton()", Justification = @"[....]: Designers run under full trust.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.DetailsView.#get_AutoGenerateInsertButton()", Justification = @"[....]: Designers run under full trust.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.DetailsView.#get_AutoGenerateRows()", Justification = @"[....]: Designers run under full trust.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.DetailsView.#set_AutoGenerateRows(System.Boolean)", Justification = @"[....]: Designers run under full trust.")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.DetailsView.#BackImageUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Globalization", "CA1303:DoNotPassLiteralsAsLocalizedParameters", Scope = "member", Target = "System.Web.UI.WebControls.DetailsView.#CreateNumericPager(System.Web.UI.WebControls.TableRow,System.Web.UI.WebControls.PagedDataSource,System.Boolean)", MessageId = "System.Web.UI.WebControls.IButtonControl.set_Text(System.String)", Justification = @"[....]: The ""..."" is acceptable for all languages")]
[module: SuppressMessage("Microsoft.Globalization", "CA1303:DoNotPassLiteralsAsLocalizedParameters", Scope = "member", Target = "System.Web.UI.WebControls.DetailsView.#CreateNumericPager(System.Web.UI.WebControls.TableRow,System.Web.UI.WebControls.PagedDataSource,System.Boolean)", MessageId = "System.Web.UI.WebControls.LinkButton.set_Text(System.String)", Justification = @"[....]: We use ""..."", unlocalized.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.DetailsView.#get_CurrentMode()", Justification = @"[....]: Designers run in full trust.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope = "member", Target = "System.Web.UI.WebControls.DetailsView.#DataKeyNames", Justification = @"[....]: Making these array properties lets you set them declaratively with a comma-separated list.  We would use an immutable array if possible.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope = "member", Target = "System.Web.UI.WebControls.DetailsView.#DataKeyNames", Justification = @"[....]: Making these array properties lets you set them declaratively with a comma-separated list.  We would use an immutable array if possible.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.DetailsView.#get_DataKeyNames()", Justification = @"[....]: Designers run under full trust.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.DetailsView.#set_DataKeyNames(System.String[])", Justification = @"[....]: Designers run under full trust.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.DetailsView.#get_EditRowStyle()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.DetailsView.#get_EmptyDataRowStyle()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.DetailsView.#get_Fields()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.DetailsView.#get_FooterStyle()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.UI.WebControls.DetailsView.#GetCallbackResult()", Justification = @"[....]: Naming is appropriate for this interface")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.DetailsView.#get_HeaderStyle()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Design", "CA1011:ConsiderPassingBaseTypesAsParameters", Scope = "member", Target = "System.Web.UI.WebControls.DetailsView.#InitializePager(System.Web.UI.WebControls.DetailsViewRow,System.Web.UI.WebControls.PagedDataSource)", Justification = @"[....]: We want to enforce the type of the row.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.DetailsView.#get_InsertRowStyle()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.DetailsView.#OnBubbleEvent(System.Object,System.EventArgs)", Justification = @"[....]: DetailsView is just overriding Control's OnBubbleEvent.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.DetailsView.#OnDataSourceViewChanged(System.Object,System.EventArgs)", MessageId = "1#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.DetailsView.#OnInit(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.DetailsView.#OnItemCommand(System.Web.UI.WebControls.DetailsViewCommandEventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.DetailsView.#OnItemCreated(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.DetailsView.#OnItemDeleted(System.Web.UI.WebControls.DetailsViewDeletedEventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.DetailsView.#OnItemDeleting(System.Web.UI.WebControls.DetailsViewDeleteEventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.DetailsView.#OnItemInserted(System.Web.UI.WebControls.DetailsViewInsertedEventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.DetailsView.#OnItemInserting(System.Web.UI.WebControls.DetailsViewInsertEventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.DetailsView.#OnItemUpdated(System.Web.UI.WebControls.DetailsViewUpdatedEventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.DetailsView.#OnItemUpdating(System.Web.UI.WebControls.DetailsViewUpdateEventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.DetailsView.#OnModeChanged(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.DetailsView.#OnModeChanging(System.Web.UI.WebControls.DetailsViewModeEventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.DetailsView.#OnPageIndexChanged(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.DetailsView.#OnPageIndexChanging(System.Web.UI.WebControls.DetailsViewPageEventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.DetailsView.#OnPagePreLoad(System.Object,System.EventArgs)", MessageId = "1#", Justification = @"[....]: Safe handling of PagePreLoad.  The event handler is protected,")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.DetailsView.#OnPreRender(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.DetailsView.#get_PagerSettings()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.DetailsView.#get_PagerStyle()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.UI.WebControls.DetailsView.#RaiseCallbackEvent(System.String)", Justification = @"[....]: Naming is appropriate for this interface")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.UI.WebControls.DetailsView.#RaisePostBackEvent(System.String)", Justification = @"[....]: legacy pattern for exposting IPostbackEventHandler -[....]")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.DetailsView.#get_Rows()", Justification = @"[....]: Designers run under full trust.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.DetailsView.#get_RowStyle()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.WebControls.DetailsView.#System.Web.UI.IDataItemContainer.get_DisplayIndex()", Justification = @"[....]: These are overridable by overriding the corresponding properties on the control.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.WebControls.DetailsView.#System.Web.UI.WebControls.ICallbackContainer.GetCallbackScript(System.Web.UI.WebControls.IButtonControl,System.String)", Justification = @"[....]: These interface implementations should only be overridden by controls that wish to completely take over the implementation.  They should not be able to call our implementation any more.  They can do this by explicitly reimplementing the interface.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.WebControls.DetailsView.#System.Web.UI.WebControls.IPostBackContainer.GetPostBackOptions(System.Web.UI.WebControls.IButtonControl)", Justification = @"[....]: Inheritors should reimplement the interface completely.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.DetailsViewCommandEventArgs.#.ctor(System.Object,System.Web.UI.WebControls.CommandEventArgs)", MessageId = "1#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope = "type", Target = "System.Web.UI.WebControls.DetailsViewCommandEventHandler", Justification = @"NO_JUSTIFICATION_PROVIDED")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope = "type", Target = "System.Web.UI.WebControls.DetailsViewDeleteEventHandler", Justification = @"NO_JUSTIFICATION_PROVIDED")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope = "type", Target = "System.Web.UI.WebControls.DetailsViewInsertEventHandler", Justification = @"NO_JUSTIFICATION_PROVIDED")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope = "type", Target = "System.Web.UI.WebControls.DetailsViewModeEventHandler", Justification = @"NO_JUSTIFICATION_PROVIDED")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.DetailsViewRow.#OnBubbleEvent(System.Object,System.EventArgs)", Justification = @"[....]: DetailsViewRow just overrides Control::OnBubbleEvent")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.DetailsViewRowCollection.#get_Count()", Justification = @"[....]: Designers run in full trust.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.WebControls.DetailsViewRowCollection.#get_Count()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.WebControls.DetailsViewRowCollection.#GetEnumerator()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.WebControls.DetailsViewRowCollection.#get_IsSynchronized()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.DetailsViewRowCollection.#get_Item(System.Int32)", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.WebControls.DetailsViewRowCollection.#get_SyncRoot()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.WebControls.DetailsViewRowCollection.#System.Collections.ICollection.CopyTo(System.Array,System.Int32)", Justification = @"[....]: An inheritor should not have to override CopyTo on these collections.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.WebControls.DetailsViewRowCollection.#System.Collections.ICollection.CopyTo(System.Array,System.Int32)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope = "type", Target = "System.Web.UI.WebControls.DetailsViewUpdateEventHandler", Justification = @"NO_JUSTIFICATION_PROVIDED")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.UI.WebControls.DropDownList.#RaisePostDataChangedEvent()", Justification = @"[....]: Events are being used correctly for RaisePostBackEvent and RaisePostDataChangedEvent.")]
[module: SuppressMessage("Microsoft.Globalization", "CA1303:DoNotPassLiteralsAsLocalizedParameters", Scope = "member", Target = "System.Web.UI.WebControls.EditCommandColumn.#InitializeCell(System.Web.UI.WebControls.TableCell,System.Int32,System.Web.UI.WebControls.ListItemType)", MessageId = "System.Web.UI.LiteralControl.#ctor(System.String)", Justification = @"[....]: &nbsp; is an acceptable spelling and string for non-breaking space.")]
[module: SuppressMessage("Microsoft.Usage", "CA2204:LiteralsShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.UI.WebControls.EditCommandColumn.#InitializeCell(System.Web.UI.WebControls.TableCell,System.Int32,System.Web.UI.WebControls.ListItemType)", MessageId = "nbsp", Justification = @"[....]: &nbsp; is an acceptable spelling and string for non-breaking space.")]
[module: SuppressMessage("Microsoft.Design", "CA1035:ICollectionImplementationsHaveStronglyTypedMembers", Scope = "type", Target = "System.Web.UI.WebControls.EmbeddedMailObjectsCollection", Justification = @"NO_JUSTIFICATION_PROVIDED")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.WebControls.EmbeddedMailObjectsCollection.#OnValidate(System.Object)", Justification = @"[....]: We can't do much here since we don't own the base class.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope = "member", Target = "System.Web.UI.WebControls.FileUpload.#FileBytes", Justification = @"[....]: We made this a property so it could be set by a databinding statement in the persistance.")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope = "member", Target = "System.Web.UI.WebControls.FileUpload.#get_FileName()", Justification = @"[....]: Per DmityrR, we should exclude all violations of this rule since the framework makes no guarantee about what exceptions may be thrown.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.FileUpload.#OnPreRender(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.UI.WebControls.FontInfo.#ResetBold()", Justification = @"[....]: Called by designer through reflection.")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.UI.WebControls.FontInfo.#ResetItalic()", Justification = @"[....]: Called by designer through reflection.")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.UI.WebControls.FontInfo.#ResetOverline()", Justification = @"[....]: Called by designer through reflection.")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.UI.WebControls.FontInfo.#ResetStrikeout()", Justification = @"[....]: Called by designer through reflection.")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.UI.WebControls.FontInfo.#ResetUnderline()", Justification = @"[....]: Called by designer through reflection.")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.UI.WebControls.FontInfo.#ShouldSerializeBold()", Justification = @"[....]: Called by designer through reflection.")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.UI.WebControls.FontInfo.#ShouldSerializeItalic()", Justification = @"[....]: Called by designer through reflection.")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.UI.WebControls.FontInfo.#ShouldSerializeOverline()", Justification = @"[....]: Called by designer through reflection.")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.UI.WebControls.FontInfo.#ShouldSerializeStrikeout()", Justification = @"[....]: Called by designer through reflection.")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.UI.WebControls.FontInfo.#ShouldSerializeUnderline()", Justification = @"[....]: Called by designer through reflection.")]
[module: SuppressMessage("Microsoft.Design", "CA1011:ConsiderPassingBaseTypesAsParameters", Scope = "member", Target = "System.Web.UI.WebControls.FontUnit.#ToString(System.Globalization.CultureInfo)", Justification = @"[....]: Breaking changes")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.FontUnit.#ToString(System.IFormatProvider)", Justification = @"[....]: Safe")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.WebControls.FontUnitConverter.#CanConvertTo(System.ComponentModel.ITypeDescriptorContext,System.Type)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.FormParameter.#get_FormField()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.FormView.#BackImageUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Globalization", "CA1303:DoNotPassLiteralsAsLocalizedParameters", Scope = "member", Target = "System.Web.UI.WebControls.FormView.#CreateNumericPager(System.Web.UI.WebControls.TableRow,System.Web.UI.WebControls.PagedDataSource,System.Boolean)", MessageId = "System.Web.UI.WebControls.IButtonControl.set_Text(System.String)", Justification = @"[....]: The ""..."" is acceptable for all languages")]
[module: SuppressMessage("Microsoft.Globalization", "CA1303:DoNotPassLiteralsAsLocalizedParameters", Scope = "member", Target = "System.Web.UI.WebControls.FormView.#CreateNumericPager(System.Web.UI.WebControls.TableRow,System.Web.UI.WebControls.PagedDataSource,System.Boolean)", MessageId = "System.Web.UI.WebControls.LinkButton.set_Text(System.String)", Justification = @"[....]: We use ""..."", unlocalized.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.FormView.#get_CurrentMode()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope = "member", Target = "System.Web.UI.WebControls.FormView.#DataKeyNames", Justification = @"[....]: Implemented this way to let the user declaratively set the data keys.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope = "member", Target = "System.Web.UI.WebControls.FormView.#DataKeyNames", Justification = @"[....]: Implemented this way to let the user declaratively set the data keys.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.FormView.#get_DataKeyNames()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.FormView.#set_DataKeyNames(System.String[])", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.FormView.#get_EditItemTemplate()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.FormView.#get_EditRowStyle()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.FormView.#get_EmptyDataRowStyle()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.FormView.#get_FooterStyle()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.FormView.#get_HeaderStyle()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Design", "CA1011:ConsiderPassingBaseTypesAsParameters", Scope = "member", Target = "System.Web.UI.WebControls.FormView.#InitializePager(System.Web.UI.WebControls.FormViewRow,System.Web.UI.WebControls.PagedDataSource)", Justification = @"[....]: We want to enforce the type of the row.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.FormView.#get_InsertItemTemplate()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.FormView.#get_InsertRowStyle()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.FormView.#get_ItemTemplate()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.FormView.#OnBubbleEvent(System.Object,System.EventArgs)", MessageId = "1#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.FormView.#OnInit(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.FormView.#OnItemCommand(System.Web.UI.WebControls.FormViewCommandEventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.FormView.#OnItemCreated(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.FormView.#OnItemDeleted(System.Web.UI.WebControls.FormViewDeletedEventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.FormView.#OnItemDeleting(System.Web.UI.WebControls.FormViewDeleteEventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.FormView.#OnItemInserted(System.Web.UI.WebControls.FormViewInsertedEventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.FormView.#OnItemInserting(System.Web.UI.WebControls.FormViewInsertEventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.FormView.#OnItemUpdated(System.Web.UI.WebControls.FormViewUpdatedEventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.FormView.#OnItemUpdating(System.Web.UI.WebControls.FormViewUpdateEventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.FormView.#OnModeChanged(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.FormView.#OnModeChanging(System.Web.UI.WebControls.FormViewModeEventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.FormView.#OnPageIndexChanged(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.FormView.#OnPageIndexChanging(System.Web.UI.WebControls.FormViewPageEventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.FormView.#get_PagerStyle()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.UI.WebControls.FormView.#RaisePostBackEvent(System.String)", Justification = @"[....]: legacy pattern for exposting IPostbackEventHandler - [....]")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.FormView.#get_RowStyle()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.WebControls.FormView.#System.Web.UI.IDataItemContainer.get_DisplayIndex()", Justification = @"[....]: These are overridable by overriding the corresponding properties on the control.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.WebControls.FormView.#System.Web.UI.WebControls.IPostBackContainer.GetPostBackOptions(System.Web.UI.WebControls.IButtonControl)", Justification = @"[....]: Inheritors should reimplement the interface completely.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.FormViewCommandEventArgs.#.ctor(System.Object,System.Web.UI.WebControls.CommandEventArgs)", MessageId = "1#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.FormViewRow.#OnBubbleEvent(System.Object,System.EventArgs)", MessageId = "1#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.GridView.#get_AllowPaging()", Justification = @"[....]: Designers run under full trust.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.GridView.#get_AllowSorting()", Justification = @"[....]: Designers run under full trust.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.GridView.#get_AlternatingRowStyle()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.GridView.#get_AutoGenerateColumns()", Justification = @"[....]: Designers run under full trust.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.GridView.#set_AutoGenerateColumns(System.Boolean)", Justification = @"[....]: Designers run under full trust.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.GridView.#get_AutoGenerateDeleteButton()", Justification = @"[....]: Designers run under full trust.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.GridView.#get_AutoGenerateEditButton()", Justification = @"[....]: Designers run under full trust.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.GridView.#get_AutoGenerateSelectButton()", Justification = @"[....]: Designers run under full trust.")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.GridView.#BackImageUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.GridView.#get_Columns()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Globalization", "CA1303:DoNotPassLiteralsAsLocalizedParameters", Scope = "member", Target = "System.Web.UI.WebControls.GridView.#CreateNumericPager(System.Web.UI.WebControls.TableRow,System.Web.UI.WebControls.PagedDataSource,System.Boolean)", MessageId = "System.Web.UI.WebControls.IButtonControl.set_Text(System.String)", Justification = @"[....]: The ""..."" is acceptable for all languages")]
[module: SuppressMessage("Microsoft.Globalization", "CA1303:DoNotPassLiteralsAsLocalizedParameters", Scope = "member", Target = "System.Web.UI.WebControls.GridView.#CreateNumericPager(System.Web.UI.WebControls.TableRow,System.Web.UI.WebControls.PagedDataSource,System.Boolean)", MessageId = "System.Web.UI.WebControls.LinkButton.set_Text(System.String)", Justification = @"[....]: We use ""..."", unlocalized.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope = "member", Target = "System.Web.UI.WebControls.GridView.#DataKeyNames", Justification = @"[....]: Making these array properties lets you set them declaratively with a comma-separated list.  We would use an immutable array if possible.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope = "member", Target = "System.Web.UI.WebControls.GridView.#DataKeyNames", Justification = @"[....]: Making these array properties lets you set them declaratively with a comma-separated list.  We would use an immutable array if possible.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.GridView.#get_DataKeyNames()", Justification = @"[....]: Designers run under full trust.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.GridView.#set_DataKeyNames(System.String[])", Justification = @"[....]: Designers run under full trust.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.GridView.#add_RowDataBound(System.Web.UI.WebControls.GridViewRowEventHandler)", Justification = @"[....]: Designers run under full trust.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.GridView.#remove_RowDataBound(System.Web.UI.WebControls.GridViewRowEventHandler)", Justification = @"[....]: Designers run under full trust.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.GridView.#get_EditRowStyle()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.GridView.#get_EmptyDataRowStyle()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.GridView.#get_FooterRow()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.GridView.#get_FooterStyle()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.UI.WebControls.GridView.#GetCallbackResult()", Justification = @"[....]: Naming is appropriate for this interface")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.GridView.#get_HeaderRow()", Justification = @"[....]: Designers run under full trust.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.GridView.#get_HeaderStyle()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Performance", "CA1820:TestForEmptyStringsUsingStringLength", Scope = "member", Target = "System.Web.UI.WebControls.GridView.#LoadHiddenFieldState(System.String,System.String,System.String,System.String)", Justification = @"[....]: Rule in error?")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.GridView.#OnBubbleEvent(System.Object,System.EventArgs)", Justification = @"[....]: GridView is just overriding Control's OnBubbleEvent.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.GridView.#OnDataSourceViewChanged(System.Object,System.EventArgs)", MessageId = "1#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.GridView.#OnInit(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.GridView.#OnPageIndexChanged(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.GridView.#OnPageIndexChanging(System.Web.UI.WebControls.GridViewPageEventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.GridView.#OnPagePreLoad(System.Object,System.EventArgs)", MessageId = "1#", Justification = @"[....]: Safe handling of PagePreLoad.  The event handler is protected,")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.GridView.#OnPreRender(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.GridView.#OnRowCancelingEdit(System.Web.UI.WebControls.GridViewCancelEditEventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.GridView.#OnRowCommand(System.Web.UI.WebControls.GridViewCommandEventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.GridView.#OnRowCreated(System.Web.UI.WebControls.GridViewRowEventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.GridView.#OnRowDataBound(System.Web.UI.WebControls.GridViewRowEventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.GridView.#OnRowDeleted(System.Web.UI.WebControls.GridViewDeletedEventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.GridView.#OnRowDeleting(System.Web.UI.WebControls.GridViewDeleteEventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.GridView.#OnRowEditing(System.Web.UI.WebControls.GridViewEditEventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.GridView.#OnRowUpdated(System.Web.UI.WebControls.GridViewUpdatedEventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.GridView.#OnRowUpdating(System.Web.UI.WebControls.GridViewUpdateEventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.GridView.#OnSelectedIndexChanged(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.GridView.#OnSelectedIndexChanging(System.Web.UI.WebControls.GridViewSelectEventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.GridView.#OnSorted(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.GridView.#OnSorting(System.Web.UI.WebControls.GridViewSortEventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.GridView.#get_PagerStyle()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.GridView.#get_PageSize()", Justification = @"[....]: Designers run under full trust.")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.UI.WebControls.GridView.#RaiseCallbackEvent(System.String)", Justification = @"[....]: Naming is appropriate for this interface")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.UI.WebControls.GridView.#RaisePostBackEvent(System.String)", Justification = @"[....]: legacy pattern for exposting IPostbackEventHandler - [....]")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.GridView.#get_Rows()", Justification = @"[....]: Designers run under full trust.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.GridView.#get_RowStyle()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.WebControls.GridView.#System.Web.UI.WebControls.ICallbackContainer.GetCallbackScript(System.Web.UI.WebControls.IButtonControl,System.String)", Justification = @"[....]: These interface implementations should only be overridden by controls that wish to completely take over the implementation.  They should not be able to call our implementation any more.  They can do this by explicitly reimplementing the interface.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.WebControls.GridView.#System.Web.UI.WebControls.IPostBackContainer.GetPostBackOptions(System.Web.UI.WebControls.IButtonControl)", Justification = @"[....]: Inheritors should reimplement the interface completely.")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope = "type", Target = "System.Web.UI.WebControls.GridViewCancelEditEventHandler", Justification = @"NO_JUSTIFICATION_PROVIDED")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.GridViewCommandEventArgs.#.ctor(System.Object,System.Web.UI.WebControls.CommandEventArgs)", MessageId = "1#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.GridViewCommandEventArgs.#.ctor(System.Web.UI.WebControls.GridViewRow,System.Object,System.Web.UI.WebControls.CommandEventArgs)", MessageId = "2#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope = "type", Target = "System.Web.UI.WebControls.GridViewCommandEventHandler", Justification = @"NO_JUSTIFICATION_PROVIDED")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope = "type", Target = "System.Web.UI.WebControls.GridViewDeleteEventHandler", Justification = @"NO_JUSTIFICATION_PROVIDED")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope = "type", Target = "System.Web.UI.WebControls.GridViewEditEventHandler", Justification = @"NO_JUSTIFICATION_PROVIDED")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope = "type", Target = "System.Web.UI.WebControls.GridViewPageEventHandler", Justification = @"NO_JUSTIFICATION_PROVIDED")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.GridViewRow.#OnBubbleEvent(System.Object,System.EventArgs)", Justification = @"[....]: GridViewRow is overriding Control::OnBubbleEvent")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.WebControls.GridViewRow.#System.Web.UI.IDataItemContainer.get_DisplayIndex()", Justification = @"[....]: These are overridable by overriding the corresponding properties on the control.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.GridViewRowCollection.#get_Count()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.WebControls.GridViewRowCollection.#get_Count()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.GridViewRowCollection.#GetEnumerator()", Justification = @"[....]: Designers run under full trust.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.WebControls.GridViewRowCollection.#GetEnumerator()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.WebControls.GridViewRowCollection.#get_IsSynchronized()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.GridViewRowCollection.#get_Item(System.Int32)", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.WebControls.GridViewRowCollection.#get_SyncRoot()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.WebControls.GridViewRowCollection.#System.Collections.ICollection.CopyTo(System.Array,System.Int32)", Justification = @"[....]: An inheritor should not have to override CopyTo on these collections.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.WebControls.GridViewRowCollection.#System.Collections.ICollection.CopyTo(System.Array,System.Int32)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope = "type", Target = "System.Web.UI.WebControls.GridViewRowEventHandler", Justification = @"NO_JUSTIFICATION_PROVIDED")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope = "type", Target = "System.Web.UI.WebControls.GridViewSelectEventHandler", Justification = @"NO_JUSTIFICATION_PROVIDED")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope = "type", Target = "System.Web.UI.WebControls.GridViewSortEventHandler", Justification = @"NO_JUSTIFICATION_PROVIDED")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope = "type", Target = "System.Web.UI.WebControls.GridViewUpdateEventHandler", Justification = @"NO_JUSTIFICATION_PROVIDED")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.HiddenField.#OnPreRender(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.HiddenField.#OnValueChanged(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.UI.WebControls.HiddenField.#RaisePostDataChangedEvent()", Justification = @"[....]: This is not an event, but raises events.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.UI.WebControls.HierarchicalDataBoundControl.#GetDataSource()", Justification = @"[....]: These are all according to the spec")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.HierarchicalDataBoundControl.#OnDataSourceChanged(System.Object,System.EventArgs)", MessageId = "1#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.HierarchicalDataBoundControl.#OnLoad(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "member", Target = "System.Web.UI.WebControls.HierarchicalDataBoundControl.#OnPagePreLoad(System.Object,System.EventArgs)", MessageId = "PreLoad", Justification = @"[....]: Spellings ok.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.HierarchicalDataBoundControl.#OnPagePreLoad(System.Object,System.EventArgs)", MessageId = "1#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Performance", "CA1812:AvoidUninstantiatedInternalClasses", Scope = "type", Target = "System.Web.UI.WebControls.HorizontalAlignConverter", Justification = @"[....]: Used as converters in attribites.")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.UI.WebControls.HorizontalAlignConverter.#.ctor()", Justification = @"[....]: Called by reflection")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "type", Target = "System.Web.UI.WebControls.HotSpot", MessageId = "HotSpot", Justification = @"[....]: Spellings ok.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.UI.WebControls.HotSpot.#GetCoordinates()", Justification = @"[....]: Use of method is intentional.  It formats the coordinates, which are specified by other properties.  Various properties get/set would have order dependencies with the property get.")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "member", Target = "System.Web.UI.WebControls.HotSpot.#HotSpotMode", MessageId = "HotSpot", Justification = @"[....]: Spellings ok.")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.HotSpot.#NavigateUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "type", Target = "System.Web.UI.WebControls.HotSpotCollection", MessageId = "HotSpot", Justification = @"[....]: Spellings ok.")]
[module: SuppressMessage("Microsoft.Design", "CA1035:ICollectionImplementationsHaveStronglyTypedMembers", Scope = "type", Target = "System.Web.UI.WebControls.HotSpotCollection", Justification = @"[....]: CopyTo is inherited from StateManagedCollection, and it is not for external use.")]
[module: SuppressMessage("Microsoft.Design", "CA1039:ListsAreStronglyTyped", Scope = "type", Target = "System.Web.UI.WebControls.HotSpotCollection", Justification = @"[....]: IndexOf is inherited from StateManagedCollection, and it is not for external use.")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "type", Target = "System.Web.UI.WebControls.HotSpotMode", MessageId = "HotSpot", Justification = @"[....]: Spellings ok.")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "type", Target = "System.Web.UI.WebControls.HyperLinkField", MessageId = "HyperLink", Justification = @"[....]: Spellings ok.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope = "member", Target = "System.Web.UI.WebControls.HyperLinkField.#DataNavigateUrlFields", Justification = @"[....]: This property is a string array because it's the only way we can make it declaratively settable.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope = "member", Target = "System.Web.UI.WebControls.HyperLinkField.#DataNavigateUrlFields", Justification = @"[....]: This property is a string array because it's the only way we can make it declaratively settable.")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.HyperLinkField.#DataNavigateUrlFormatString", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Design", "CA1055:UriReturnValuesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.HyperLinkField.#FormatDataNavigateUrlValue(System.Object[])", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.HyperLinkField.#NavigateUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.IButtonControl.#PostBackUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.Image.#DescriptionUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.WebControls.ImageButton.#System.Web.UI.WebControls.IButtonControl.add_Click(System.EventHandler)", Justification = @"[....]: IButtonControl Click event should not be overridable in derived classes.  Explicit implementation is intentional here.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.WebControls.ImageButton.#System.Web.UI.WebControls.IButtonControl.remove_Click(System.EventHandler)", Justification = @"[....]: IButtonControl Click event should not be overridable in derived classes.  Explicit implementation is intentional here.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.UI.WebControls.ImageButton.#GetPostBackOptions()", Justification = @"[....]: Reviewed, and these are appropriate uses of methods.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.ImageButton.#OnClick(System.Web.UI.ImageClickEventArgs)", MessageId = "0#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.ImageButton.#OnCommand(System.Web.UI.WebControls.CommandEventArgs)", MessageId = "0#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.ImageButton.#OnPreRender(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.UI.WebControls.ImageButton.#RaisePostBackEvent(System.String)", Justification = @"[....]: Events are being used correctly here.  RaisePostBackEvent and RaisePostDataChangedEvent are members of IPostBackEventHandler and IPostBackDataHandler.")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.UI.WebControls.ImageButton.#RaisePostDataChangedEvent()", Justification = @"[....]: Events are being used correctly here.  RaisePostBackEvent and RaisePostDataChangedEvent are members of IPostBackEventHandler and IPostBackDataHandler.")]
[module: SuppressMessage("Microsoft.Security", "CA2112:SecuredTypesShouldNotExposeFields", Scope = "type", Target = "System.Web.UI.WebControls.ImageField", Justification = @"[....]: ThisExpression used for safe purposes.  It's a readonly static.")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.ImageField.#DataImageUrlField", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.ImageField.#DataImageUrlFormatString", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Design", "CA1055:UriReturnValuesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.ImageField.#FormatImageUrlValue(System.Object)", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.UI.WebControls.ImageField.#GetDesignTimeValue()", Justification = @"[....]: This makes more sense as a function than as a property, since it may not be a simple property retrieve.")]
[module: SuppressMessage("Microsoft.Design", "CA1045:DoNotPassTypesByReference", Scope = "member", Target = "System.Web.UI.WebControls.ImageField.#GetValue(System.Web.UI.Control,System.String,System.ComponentModel.PropertyDescriptor&)", MessageId = "2#", Justification = @"[....]: Need this to cache type descriptor")]
[module: SuppressMessage("Microsoft.Design", "CA1011:ConsiderPassingBaseTypesAsParameters", Scope = "member", Target = "System.Web.UI.WebControls.ImageField.#InitializeDataCell(System.Web.UI.WebControls.DataControlFieldCell,System.Web.UI.WebControls.DataControlRowState)", Justification = @"[....]: We want to enforce that this is instantiated inside a cell.")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.ImageField.#NullImageUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.ImageField.#OnDataBindField(System.Object,System.EventArgs)", Justification = @"[....]: This method is used to override databinding on derived fields.")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "member", Target = "System.Web.UI.WebControls.ImageMap.#HotSpotMode", MessageId = "HotSpot", Justification = @"[....]: Spellings ok.")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "member", Target = "System.Web.UI.WebControls.ImageMap.#HotSpots", MessageId = "HotSpots", Justification = @"[....]: Spellings ok.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.ImageMap.#OnClick(System.Web.UI.WebControls.ImageMapEventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.UI.WebControls.ImageMap.#RaisePostBackEvent(System.String)", Justification = @"[....]: Events are being used correctly here.  RaisePostBackEvent and RaisePostDataChangedEvent are members of IPostBackEventHandler and IPostBackDataHandler.")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope = "type", Target = "System.Web.UI.WebControls.ImageMapEventHandler", Justification = @"NO_JUSTIFICATION_PROVIDED")]
[module: SuppressMessage("Microsoft.Naming", "CA1706:ShortAcronymsShouldBeUppercase", Scope = "member", Target = "System.Web.UI.WebControls.Label.#AssociatedControlID", Justification = @"[....]: We use ID in our code.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.UI.WebControls.LinkButton.#GetPostBackOptions()", Justification = @"[....]: This makes sense as a function because it's doing complex work.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.LinkButton.#OnClick(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.LinkButton.#OnCommand(System.Web.UI.WebControls.CommandEventArgs)", MessageId = "0#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.LinkButton.#OnPreRender(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.UI.WebControls.LinkButton.#RaisePostBackEvent(System.String)", Justification = @"[....]: Events are being used correctly here.  RaisePostBackEvent and RaisePostDataChangedEvent are members of IPostBackEventHandler and IPostBackDataHandler.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.ListBox.#OnPreRender(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.UI.WebControls.ListBox.#RaisePostDataChangedEvent()", Justification = @"[....]: Events are being used correctly for RaisePostBackEvent and RaisePostDataChangedEvent.")]
[module: SuppressMessage("Microsoft.Design", "CA1012:AbstractTypesShouldNotHaveConstructors", Scope = "type", Target = "System.Web.UI.WebControls.ListControl", Justification = @"[....]: This ctor does something.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.ListControl.#OnDataBinding(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.ListControl.#OnPreRender(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.ListControl.#OnSelectedIndexChanged(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.ListControl.#OnTextChanged(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.UI.WebControls.ListItem.#get_Dirty()", Justification = @"[....]: Called by designer through reflection.")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope = "member", Target = "System.Web.UI.WebControls.ListItem.#LoadViewState(System.Object)", Justification = @"[....]: by email thread, ignore this violation.")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.UI.WebControls.ListItem.#ResetText()", Justification = @"[....]: Called by designer through reflection.")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.UI.WebControls.ListItem.#ResetValue()", Justification = @"[....]: Called by designer through reflection.")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.UI.WebControls.ListItem.#ShouldSerializeText()", Justification = @"[....]: Called by designer through reflection.")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.UI.WebControls.ListItem.#ShouldSerializeValue()", Justification = @"[....]: Called by designer through reflection.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.WebControls.ListItemCollection.#System.Collections.IList.get_IsFixedSize()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.WebControls.ListItemCollection.#System.Collections.IList.get_Item(System.Int32)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.WebControls.ListItemCollection.#System.Collections.IList.set_Item(System.Int32,System.Object)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2112:SecuredTypesShouldNotExposeFields", Scope = "type", Target = "System.Web.UI.WebControls.Login", Justification = @"[....]: These are just public readonly strings.")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.Login.#CreateUserIconUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.Login.#CreateUserUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.Login.#DestinationPageUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.Login.#HelpPageIconUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.Login.#HelpPageUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "member", Target = "System.Web.UI.WebControls.Login.#HyperLinkStyle", MessageId = "HyperLink", Justification = @"[....]: Spellings ok.")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.Login.#LoginButtonImageUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.Login.#OnAuthenticate(System.Web.UI.WebControls.AuthenticateEventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.Login.#OnBubbleEvent(System.Object,System.EventArgs)", Justification = @"[....]: OnBubbleEvent is defined as protected in Control, and was present in v1 so cannot be changed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.Login.#OnLoggedIn(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.Login.#OnLoggingIn(System.Web.UI.WebControls.LoginCancelEventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.Login.#OnLoginError(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.Login.#OnPreRender(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.Login.#PasswordRecoveryIconUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.Login.#PasswordRecoveryUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.UI.WebControls.Login.#SetDesignModeState(System.Collections.IDictionary)", Justification = @"[....]: The security attribute at the method level is more secured than the type one, therefore the LinkDemand is not necessary.")]
[module: SuppressMessage("Microsoft.Globalization", "CA1303:DoNotPassLiteralsAsLocalizedParameters", Scope = "member", Target = "System.Web.UI.WebControls.Login+LoginTemplate.#LayoutHorizontalTextOnLeft(System.Web.UI.WebControls.Login+LoginContainer)", MessageId = "System.Web.UI.LiteralControl.set_Text(System.String)", Justification = @"[....]: html strings")]
[module: SuppressMessage("Microsoft.Globalization", "CA1303:DoNotPassLiteralsAsLocalizedParameters", Scope = "member", Target = "System.Web.UI.WebControls.Login+LoginTemplate.#LayoutHorizontalTextOnTop(System.Web.UI.WebControls.Login+LoginContainer)", MessageId = "System.Web.UI.LiteralControl.set_Text(System.String)", Justification = @"[....]: html strings")]
[module: SuppressMessage("Microsoft.Globalization", "CA1303:DoNotPassLiteralsAsLocalizedParameters", Scope = "member", Target = "System.Web.UI.WebControls.Login+LoginTemplate.#LayoutVerticalTextOnLeft(System.Web.UI.WebControls.Login+LoginContainer)", MessageId = "System.Web.UI.LiteralControl.set_Text(System.String)", Justification = @"[....]: html strings")]
[module: SuppressMessage("Microsoft.Globalization", "CA1303:DoNotPassLiteralsAsLocalizedParameters", Scope = "member", Target = "System.Web.UI.WebControls.Login+LoginTemplate.#LayoutVerticalTextOnTop(System.Web.UI.WebControls.Login+LoginContainer)", MessageId = "System.Web.UI.LiteralControl.set_Text(System.String)", Justification = @"[....]: html strings")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.LoginStatus.#LoginImageUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.LoginStatus.#LogoutImageUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.LoginStatus.#LogoutPageUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.LoginStatus.#OnLoggedOut(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.LoginStatus.#OnLoggingOut(System.Web.UI.WebControls.LoginCancelEventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.LoginStatus.#OnPreRender(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.UI.WebControls.LoginStatus.#SetDesignModeState(System.Collections.IDictionary)", Justification = @"[....]: The security attribute at the method level is more secured than the type one, therefore the LinkDemand is not necessary.")]
[module: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "System.Web.UI.WebControls.LoginUtil.#SendPasswordMail(System.String,System.String,System.String,System.Web.UI.WebControls.MailDefinition,System.String,System.String,System.Web.UI.WebControls.LoginUtil+OnSendingMailDelegate,System.Web.UI.WebControls.LoginUtil+OnSendMailErrorDelegate,System.Web.UI.Control)", MessageId = "System.Net.Mail.MailAddress", Justification = @"[....]: We need to call the MailMessage() constructor with the email string to determine if the email address is a valid format.  We do not need to use the MailMessage that is constructed.")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.UI.WebControls.LoginUtil+GenericContainer`1.#FindControl(System.String,System.Boolean,System.String)", Justification = @"[....]: Rule error on generic types with generic methods.")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.UI.WebControls.LoginUtil+GenericContainer`1.#FindOptionalControl(System.String)", Justification = @"[....]: Rule error on generic types with generic methods.")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.UI.WebControls.LoginUtil+GenericContainer`1.#FindRequiredControl(System.String,System.String)", Justification = @"[....]: Rule error on generic types with generic methods.")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.UI.WebControls.LoginUtil+GenericContainer`1.#VerifyControlNotPresent(System.String,System.String)", Justification = @"[....]: Rule error on generic types with generic methods.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.UI.WebControls.LoginView.#EnableTheming", MessageId = "Theming", Justification = @"NO_JUSTIFICATION_PROVIDED")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.LoginView.#OnInit(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.LoginView.#OnPreRender(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.LoginView.#OnViewChanged(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.LoginView.#OnViewChanging(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.UI.WebControls.LoginView.#SetDesignModeState(System.Collections.IDictionary)", Justification = @"[....]: The security attribute at the method level is more secured than the type one, therefore the LinkDemand is not necessary.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.WebControls.LoginView.#SetDesignModeState(System.Collections.IDictionary)", Justification = @"[....]: The security attribute at the method level is more secured than the type one, therefore the LinkDemand is not necessary.")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope = "type", Target = "System.Web.UI.WebControls.MailMessageEventHandler", Justification = @"NO_JUSTIFICATION_PROVIDED")]
[module: SuppressMessage("Microsoft.Security", "CA2112:SecuredTypesShouldNotExposeFields", Scope = "type", Target = "System.Web.UI.WebControls.Menu", Justification = @"[....]: It is ok to expose these static readonly fields even though the LinkDemand does not apply to them.")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.Menu.#DynamicBottomSeparatorImageUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.Menu.#get_DynamicMenuStyle()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.Menu.#DynamicPopOutImageUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.Menu.#DynamicTopSeparatorImageUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.UI.WebControls.Menu.#GetDesignModeState()", Justification = @"[....]: The security attribute at the method level is more secured than the type one, therefore the LinkDemand is not necessary.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.Menu.#get_Items()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "member", Target = "System.Web.UI.WebControls.Menu.#LevelSubMenuStyles", MessageId = "SubMenu", Justification = @"[....]: Spellings ok.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.Menu.#get_MaximumDynamicDisplayLevels()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.Menu.#set_MaximumDynamicDisplayLevels(System.Int32)", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.Menu.#OnBubbleEvent(System.Object,System.EventArgs)", MessageId = "1#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.Menu.#OnDataBinding(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.Menu.#OnInit(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.Menu.#OnMenuItemClick(System.Web.UI.WebControls.MenuEventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.Menu.#OnMenuItemDataBound(System.Web.UI.WebControls.MenuEventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.Menu.#OnPreRender(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.UI.WebControls.Menu.#RaisePostBackEvent(System.String)", Justification = @"[....]: This is not an event, but is here to raise events.")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.Menu.#ScrollDownImageUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.Menu.#ScrollUpImageUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.UI.WebControls.Menu.#SetDesignModeState(System.Collections.IDictionary)", Justification = @"[....]: The security attribute at the method level is more secured than the type one, therefore the LinkDemand is not necessary.")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.Menu.#StaticBottomSeparatorImageUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.Menu.#get_StaticDisplayLevels()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.Menu.#get_StaticMenuStyle()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.Menu.#StaticPopOutImageUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "member", Target = "System.Web.UI.WebControls.Menu.#StaticSubMenuIndent", MessageId = "SubMenu", Justification = @"[....]: Spellings ok.")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.Menu.#StaticTopSeparatorImageUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.MenuEventArgs.#.ctor(System.Web.UI.WebControls.MenuItem,System.Object,System.Web.UI.WebControls.CommandEventArgs)", MessageId = "2#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Design", "CA1054:UriParametersShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.MenuItem.#.ctor(System.String,System.String,System.String)", MessageId = "2#", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Design", "CA1054:UriParametersShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.MenuItem.#.ctor(System.String,System.String,System.String,System.String)", MessageId = "2#", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Design", "CA1054:UriParametersShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.MenuItem.#.ctor(System.String,System.String,System.String,System.String)", MessageId = "3#", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Design", "CA1054:UriParametersShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.MenuItem.#.ctor(System.String,System.String,System.String,System.String,System.String)", MessageId = "2#", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Design", "CA1054:UriParametersShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.MenuItem.#.ctor(System.String,System.String,System.String,System.String,System.String)", MessageId = "3#", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.MenuItem.#ImageUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.MenuItem.#NavigateUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.MenuItem.#PopOutImageUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.MenuItem.#SeparatorImageUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.WebControls.MenuItem.#System.ICloneable.Clone()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.MenuItemBinding.#ImageUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.MenuItemBinding.#ImageUrlField", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.MenuItemBinding.#NavigateUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.MenuItemBinding.#NavigateUrlField", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.MenuItemBinding.#PopOutImageUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.MenuItemBinding.#PopOutImageUrlField", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.MenuItemBinding.#SeparatorImageUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.MenuItemBinding.#SeparatorImageUrlField", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.WebControls.MenuItemBinding.#System.ICloneable.Clone()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.MenuItemCollection.#Clear()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.WebControls.MenuItemCollection.#CopyTo(System.Array,System.Int32)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.MenuItemCollection.#get_Count()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.WebControls.MenuItemCollection.#get_Count()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.WebControls.MenuItemCollection.#GetEnumerator()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.WebControls.MenuItemCollection.#get_IsSynchronized()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.WebControls.MenuItemCollection.#get_SyncRoot()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.MenuItemTemplateContainer.#OnBubbleEvent(System.Object,System.EventArgs)", MessageId = "1#", Justification = @"[....]: Benign code in the handler.")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope = "type", Target = "System.Web.UI.WebControls.MonthChangedEventHandler", Justification = @"NO_JUSTIFICATION_PROVIDED")]
[module: SuppressMessage("Microsoft.Security", "CA2112:SecuredTypesShouldNotExposeFields", Scope = "type", Target = "System.Web.UI.WebControls.MultiView", Justification = @"[....]: These are just public readonly strings.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.UI.WebControls.MultiView.#GetActiveView()", Justification = @"[....]: Replacing GetActiveView() with a property would create an order dependency between set_ActiveViewIndex and get_ActiveView.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.MultiView.#OnActiveViewChanged(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.MultiView.#OnBubbleEvent(System.Object,System.EventArgs)", Justification = @"[....]: OnBubbleEvent is Inherited from Control, where it has been protected virtual since V1.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.MultiView.#OnInit(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Design", "CA1011:ConsiderPassingBaseTypesAsParameters", Scope = "member", Target = "System.Web.UI.WebControls.MultiView.#SetActiveView(System.Web.UI.WebControls.View)", Justification = @"[....]: SetActiveView is a MultiView/View only API.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.UI.WebControls.MultiView.#SetActiveView(System.Web.UI.WebControls.View)", Justification = @"[....]: By-design. We don't want to expose too many properties that do the same thing.")]
[module: SuppressMessage("Microsoft.Naming", "CA1706:ShortAcronymsShouldBeUppercase", Scope = "member", Target = "System.Web.UI.WebControls.MultiView.#SwitchViewByIDCommandName", Justification = @"[....]: ""ID"" ok for ASP.NET")]
[module: SuppressMessage("Microsoft.Usage", "CA2214:DoNotCallOverridableMethodsInConstructors", Scope = "member", Target = "System.Web.UI.WebControls.ObjectDataSource.#.ctor(System.String,System.String)", Justification = @"[....]: These are just helper constructors, and it is unlikely that any bad behavior will result.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.ObjectDataSource.#OnInit(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Naming", "CA1720:AvoidTypeNamesInParameters", Scope = "member", Target = "System.Web.UI.WebControls.ObjectDataSourceDisposingEventArgs.#.ctor(System.Object)", MessageId = "0#", Justification = @"[....]: Not a reference to the type name.")]
[module: SuppressMessage("Microsoft.Naming", "CA1720:AvoidTypeNamesInParameters", Scope = "member", Target = "System.Web.UI.WebControls.ObjectDataSourceEventArgs.#.ctor(System.Object)", MessageId = "0#", Justification = @"[....]: Incorrect error, this is by design.")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.UI.WebControls.ObjectDataSourceView.#InvokeMethod(System.Web.UI.WebControls.ObjectDataSourceView+ObjectDataSourceMethod,System.Boolean,System.Object&)", Justification = @"[....]: Disregarding this rule because it doesn't make sense for our code.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.ObjectDataSourceView.#OnDeleted(System.Web.UI.WebControls.ObjectDataSourceStatusEventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.ObjectDataSourceView.#OnDeleting(System.Web.UI.WebControls.ObjectDataSourceMethodEventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.ObjectDataSourceView.#OnFiltering(System.Web.UI.WebControls.ObjectDataSourceFilteringEventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.ObjectDataSourceView.#OnInserted(System.Web.UI.WebControls.ObjectDataSourceStatusEventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.ObjectDataSourceView.#OnInserting(System.Web.UI.WebControls.ObjectDataSourceMethodEventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.ObjectDataSourceView.#OnObjectCreated(System.Web.UI.WebControls.ObjectDataSourceEventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.ObjectDataSourceView.#OnObjectCreating(System.Web.UI.WebControls.ObjectDataSourceEventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.ObjectDataSourceView.#OnObjectDisposing(System.Web.UI.WebControls.ObjectDataSourceDisposingEventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.ObjectDataSourceView.#OnSelected(System.Web.UI.WebControls.ObjectDataSourceStatusEventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.ObjectDataSourceView.#OnSelecting(System.Web.UI.WebControls.ObjectDataSourceSelectingEventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.ObjectDataSourceView.#OnUpdated(System.Web.UI.WebControls.ObjectDataSourceStatusEventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.ObjectDataSourceView.#OnUpdating(System.Web.UI.WebControls.ObjectDataSourceMethodEventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.PagerSettings.#FirstPageImageUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.PagerSettings.#LastPageImageUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.PagerSettings.#NextPageImageUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.PagerSettings.#get_Position()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.PagerSettings.#PreviousPageImageUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.WebControls.PagerSettings.#ToString()", Justification = @"[....]: Object::ToString() does not have any link demands.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.Panel.#get_Direction()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.Panel.#get_GroupingText()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.PanelStyle.#BackImageUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Naming", "CA1706:ShortAcronymsShouldBeUppercase", Scope = "member", Target = "System.Web.UI.WebControls.Parameter.#ConvertDbTypeToTypeCode(System.Data.DbType)", MessageId = "Member", Justification = @"[....]: Casing matches the associated System.Data.DbType enum")]
[module: SuppressMessage("Microsoft.Naming", "CA1706:ShortAcronymsShouldBeUppercase", Scope = "member", Target = "System.Web.UI.WebControls.Parameter.#ConvertTypeCodeToDbType(System.TypeCode)", MessageId = "Member", Justification = @"[....]: Casing matches the associated System.Data.DbType enum")]
[module: SuppressMessage("Microsoft.Naming", "CA1706:ShortAcronymsShouldBeUppercase", Scope = "member", Target = "System.Web.UI.WebControls.Parameter.#DbType", MessageId = "Member", Justification = @"[....]: Casing matches the associated System.Data.DbType enum")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.Parameter.#get_DefaultValue()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.UI.WebControls.Parameter.#GetDatabaseType()", Justification = @"[....]: GetDatabaseType is getting a value based on the settings of two other properties, DbType and Type.  It is used to determine the DbType that should be used for a DbCommand and should not be confused with the DbType and Type properties that a typical user would interact with.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.Parameter.#get_Name()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.WebControls.Parameter.#System.ICloneable.Clone()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.ParameterCollection.#OnParametersChanged(System.EventArgs)", MessageId = "0#", Justification = @"[....]: This event handler is specifically visible so that people can override it to add functionality.")]
[module: SuppressMessage("Microsoft.Security", "CA2112:SecuredTypesShouldNotExposeFields", Scope = "type", Target = "System.Web.UI.WebControls.PasswordRecovery", Justification = @"[....]: These are just public readonly strings.")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.PasswordRecovery.#HelpPageIconUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.PasswordRecovery.#HelpPageUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "member", Target = "System.Web.UI.WebControls.PasswordRecovery.#HyperLinkStyle", MessageId = "HyperLink", Justification = @"[....]: Spellings ok.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.PasswordRecovery.#OnAnswerLookupError(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.PasswordRecovery.#OnBubbleEvent(System.Object,System.EventArgs)", Justification = @"[....]: OnBubbleEvent is defined as protected in Control, and was present in v1 so cannot be changed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.PasswordRecovery.#OnInit(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.PasswordRecovery.#OnPreRender(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.PasswordRecovery.#OnSendingMail(System.Web.UI.WebControls.MailMessageEventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.PasswordRecovery.#OnSendMailError(System.Web.UI.WebControls.SendMailErrorEventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.PasswordRecovery.#OnUserLookupError(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.PasswordRecovery.#OnVerifyingAnswer(System.Web.UI.WebControls.LoginCancelEventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.PasswordRecovery.#OnVerifyingUser(System.Web.UI.WebControls.LoginCancelEventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.UI.WebControls.PasswordRecovery.#SetDesignModeState(System.Collections.IDictionary)", Justification = @"[....]: The security attribute at the method level is more secured than the type one, therefore the LinkDemand is not necessary.")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.PasswordRecovery.#SubmitButtonImageUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.PasswordRecovery.#SuccessPageUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "type", Target = "System.Web.UI.WebControls.PolygonHotSpot", MessageId = "HotSpot", Justification = @"[....]: Spellings ok.")]
[module: SuppressMessage("Microsoft.Naming", "CA1721:PropertyNamesShouldNotMatchGetMethods", Scope = "member", Target = "System.Web.UI.WebControls.PolygonHotSpot.#Coordinates", Justification = @"[....]: GetCoordinates is inherited.  Need property get/set for property grid support.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.ProfileParameter.#get_PropertyName()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Naming", "CA1720:AvoidTypeNamesInParameters", Scope = "member", Target = "System.Web.UI.WebControls.QueryStringParameter.#.ctor(System.String,System.Data.DbType,System.String)", MessageId = "2#", Justification = @"[....]: Parameter name matches existing constructors")]
[module: SuppressMessage("Microsoft.Naming", "CA1720:AvoidTypeNamesInParameters", Scope = "member", Target = "System.Web.UI.WebControls.QueryStringParameter.#.ctor(System.String,System.String)", MessageId = "1#", Justification = @"[....]: This is not a reference to the type")]
[module: SuppressMessage("Microsoft.Naming", "CA1720:AvoidTypeNamesInParameters", Scope = "member", Target = "System.Web.UI.WebControls.QueryStringParameter.#.ctor(System.String,System.TypeCode,System.String)", MessageId = "2#", Justification = @"[....]: This is not a reference to the type")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.QueryStringParameter.#get_QueryStringField()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.RadioButton.#OnPreRender(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.UI.WebControls.RadioButton.#RaisePostDataChangedEvent()", Justification = @"[....]: This method name is to match the interface IPostBackDataHandler's method.  And its name is consistent across other controls.")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.UI.WebControls.RadioButtonList.#RaisePostDataChangedEvent()", Justification = @"[....]: Events are being used correctly here.  RaisePostBackEvent and RaisePostDataChangedEvent are members of IPostBackEventHandler and IPostBackDataHandler.")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "type", Target = "System.Web.UI.WebControls.RectangleHotSpot", MessageId = "HotSpot", Justification = @"[....]: Spellings ok.")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.UI.WebControls.RegularExpressionValidator.#set_ValidationExpression(System.String)", Justification = @"[....]: Disregarding this rule because it doesn't make sense for our code.")]
[module: SuppressMessage("Microsoft.Naming", "CA1706:ShortAcronymsShouldBeUppercase", Scope = "member", Target = "System.Web.UI.WebControls.Repeater.#DataSourceID", Justification = @"[....]: ""ID"" ok for ASP.NET")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.UI.WebControls.Repeater.#GetData()", Justification = @"[....]: These are all according to the spec")]
[module: SuppressMessage("Microsoft.Naming", "CA1706:ShortAcronymsShouldBeUppercase", Scope = "member", Target = "System.Web.UI.WebControls.Repeater.#IsBoundUsingDataSourceID", Justification = @"[....]: ""ID"" ok for ASP.NET")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.Repeater.#OnBubbleEvent(System.Object,System.EventArgs)", MessageId = "1#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.Repeater.#OnDataBinding(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.Repeater.#OnDataSourceViewChanged(System.Object,System.EventArgs)", MessageId = "1#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.Repeater.#OnInit(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.Repeater.#OnItemCommand(System.Web.UI.WebControls.RepeaterCommandEventArgs)", MessageId = "0#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.Repeater.#OnItemCreated(System.Web.UI.WebControls.RepeaterItemEventArgs)", MessageId = "0#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.Repeater.#OnItemDataBound(System.Web.UI.WebControls.RepeaterItemEventArgs)", MessageId = "0#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.Repeater.#OnLoad(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.Repeater.#OnPreRender(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.RepeaterCommandEventArgs.#.ctor(System.Web.UI.WebControls.RepeaterItem,System.Object,System.Web.UI.WebControls.CommandEventArgs)", MessageId = "2#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope = "type", Target = "System.Web.UI.WebControls.RepeaterCommandEventHandler", Justification = @"NO_JUSTIFICATION_PROVIDED")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.RepeaterItem.#OnBubbleEvent(System.Object,System.EventArgs)", MessageId = "1#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.WebControls.RepeaterItem.#System.Web.UI.IDataItemContainer.get_DataItemIndex()", Justification = @"[....]: These are overridable by overriding properties on the control.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.WebControls.RepeaterItem.#System.Web.UI.IDataItemContainer.get_DisplayIndex()", Justification = @"[....]: These are overridable by overriding properties on the control.")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope = "type", Target = "System.Web.UI.WebControls.RepeaterItemEventHandler", Justification = @"NO_JUSTIFICATION_PROVIDED")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope = "member", Target = "System.Web.UI.WebControls.RoleGroup.#Roles", Justification = @"[....]: These are read/write array properties so they can be set in the persistence format as a comma-separated list of strings.")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope = "member", Target = "System.Web.UI.WebControls.RoleGroup.#Roles", Justification = @"[....]: These are read/write array properties so they can be set in the persistence format as a comma-separated list of strings.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.WebControls.RoleGroupCollection.#OnValidate(System.Object)", Justification = @"[....]: We don't own CollectionBase, so we can't protect it.")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope = "type", Target = "System.Web.UI.WebControls.SendMailErrorEventHandler", Justification = @"NO_JUSTIFICATION_PROVIDED")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope = "type", Target = "System.Web.UI.WebControls.ServerValidateEventHandler", Justification = @"NO_JUSTIFICATION_PROVIDED")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.SessionParameter.#get_SessionField()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "type", Target = "System.Web.UI.WebControls.SiteMapDataSource", MessageId = "SiteMap", Justification = @"[....]: Spellings ok.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.WebControls.SiteMapDataSource.#get_ContainsListCollection()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.WebControls.SiteMapDataSource.#System.Web.UI.IDataSource.add_DataSourceChanged(System.EventHandler)", Justification = @"[....]: Derived classes have other ways of extending these events")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.WebControls.SiteMapDataSource.#System.Web.UI.IDataSource.remove_DataSourceChanged(System.EventHandler)", Justification = @"[....]: Derived classes have other ways of extending these events")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.WebControls.SiteMapDataSource.#GetList()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.UI.WebControls.SiteMapDataSource.#GetList()", Justification = @"[....]: An expensive call should be a method. This method is also consistent with the interface IListSource method.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.UI.WebControls.SiteMapDataSource.#GetViewNames()", Justification = @"[....]: An expensive call should be a method. This method is also consistent with the interface IListSource method.")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "member", Target = "System.Web.UI.WebControls.SiteMapDataSource.#SiteMapProvider", MessageId = "SiteMap", Justification = @"[....]: Spellings ok.")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.SiteMapDataSource.#StartingNodeUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.WebControls.SiteMapDataSource.#System.ComponentModel.IListSource.get_ContainsListCollection()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.WebControls.SiteMapDataSource.#System.ComponentModel.IListSource.GetList()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "type", Target = "System.Web.UI.WebControls.SiteMapDataSourceView", MessageId = "SiteMap", Justification = @"[....]: Spellings ok.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.SiteMapDataSourceView.#OnDataSourceViewChanged(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "type", Target = "System.Web.UI.WebControls.SiteMapHierarchicalDataSourceView", MessageId = "SiteMap", Justification = @"[....]: Spellings ok.")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "type", Target = "System.Web.UI.WebControls.SiteMapNodeItem", MessageId = "SiteMap", Justification = @"[....]: Spellings ok.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.UI.WebControls.SiteMapNodeItem.#SetItemType(System.Web.UI.WebControls.SiteMapNodeItemType)", Justification = @"[....]: I looked at it with Ting together and he said that this is a set only action so due to coding guideline we should keep it as a method instead of a property.")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "member", Target = "System.Web.UI.WebControls.SiteMapNodeItem.#SiteMapNode", MessageId = "SiteMap", Justification = @"[....]: Spellings ok.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.WebControls.SiteMapNodeItem.#System.Web.UI.IDataItemContainer.get_DataItem()", Justification = @"[....]: This explicitly implemented interface property DataItem simply returns a virtual property SiteMapNode defined on SiteMapNodeItem.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.WebControls.SiteMapNodeItem.#System.Web.UI.IDataItemContainer.get_DataItemIndex()", Justification = @"[....]: These can be overridden by overriding their corresponding properties.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.WebControls.SiteMapNodeItem.#System.Web.UI.IDataItemContainer.get_DisplayIndex()", Justification = @"[....]: These can be overridden by overriding their corresponding properties.")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "type", Target = "System.Web.UI.WebControls.SiteMapNodeItemEventArgs", MessageId = "SiteMap", Justification = @"[....]: Spellings ok.")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "type", Target = "System.Web.UI.WebControls.SiteMapNodeItemEventHandler", MessageId = "SiteMap", Justification = @"[....]: Spellings ok.")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope = "type", Target = "System.Web.UI.WebControls.SiteMapNodeItemEventHandler", Justification = @"NO_JUSTIFICATION_PROVIDED")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "type", Target = "System.Web.UI.WebControls.SiteMapNodeItemType", MessageId = "SiteMap", Justification = @"[....]: Spellings ok.")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "type", Target = "System.Web.UI.WebControls.SiteMapPath", MessageId = "SiteMap", Justification = @"[....]: Spellings ok.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.SiteMapPath.#OnDataBinding(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.SiteMapPath.#OnItemCreated(System.Web.UI.WebControls.SiteMapNodeItemEventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.SiteMapPath.#OnItemDataBound(System.Web.UI.WebControls.SiteMapNodeItemEventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "member", Target = "System.Web.UI.WebControls.SiteMapPath.#SiteMapProvider", MessageId = "SiteMap", Justification = @"[....]: Spellings ok.")]
[module: SuppressMessage("Microsoft.Naming", "CA1720:AvoidTypeNamesInParameters", Scope = "member", Target = "System.Web.UI.WebControls.SqlDataSource.#.ctor(System.String,System.String)", MessageId = "0#", Justification = @"[....]: This is not a reference to the type")]
[module: SuppressMessage("Microsoft.Naming", "CA1720:AvoidTypeNamesInParameters", Scope = "member", Target = "System.Web.UI.WebControls.SqlDataSource.#.ctor(System.String,System.String,System.String)", MessageId = "1#", Justification = @"[....]: ConnectionString is perfectly valid, calling it just Connection is inappropriate.")]
[module: SuppressMessage("Microsoft.Naming", "CA1706:ShortAcronymsShouldBeUppercase", Scope = "member", Target = "System.Web.UI.WebControls.SqlDataSource.#GetDbProviderFactory()", Justification = @"[....]: This is consistent with ADO.net")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.UI.WebControls.SqlDataSource.#GetDbProviderFactory()", Justification = @"[....]: This is potentially expensive so it is a method")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.UI.WebControls.SqlDataSource.#LoadTotalRowCountFromCache()", Justification = @"[....]: This code is here because it will be used in the near future or it will be removed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.SqlDataSource.#OnInit(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope = "type", Target = "System.Web.UI.WebControls.SqlDataSourceCommandEventHandler", Justification = @"NO_JUSTIFICATION_PROVIDED")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope = "type", Target = "System.Web.UI.WebControls.SqlDataSourceStatusEventHandler", Justification = @"NO_JUSTIFICATION_PROVIDED")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.UI.WebControls.SqlDataSourceView.#ExecuteDbCommand(System.Data.Common.DbCommand,System.Web.UI.DataSourceOperation)", Justification = @"[....]: Disregarding this rule because it doesn't make sense for our code.")]
[module: SuppressMessage("Microsoft.Security", "CA2102:CatchNonClsCompliantExceptionsInGeneralHandlers", Scope = "member", Target = "System.Web.UI.WebControls.SqlDataSourceView.#ExecuteSelect(System.Web.UI.DataSourceSelectArguments)", Justification = @"[....]: Disregarding this rule because it doesn't make sense for our code.")]
[module: SuppressMessage("Microsoft.Globalization", "CA1306:SetLocaleForDataTypes", Scope = "member", Target = "System.Web.UI.WebControls.SqlDataSourceView.#ExecuteSelect(System.Web.UI.DataSourceSelectArguments)", Justification = @"[....]: The locale of the server should be used, which is the default if no locale is specified.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.SqlDataSourceView.#OnDeleted(System.Web.UI.WebControls.SqlDataSourceStatusEventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.SqlDataSourceView.#OnDeleting(System.Web.UI.WebControls.SqlDataSourceCommandEventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.SqlDataSourceView.#OnFiltering(System.Web.UI.WebControls.SqlDataSourceFilteringEventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.SqlDataSourceView.#OnInserted(System.Web.UI.WebControls.SqlDataSourceStatusEventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.SqlDataSourceView.#OnInserting(System.Web.UI.WebControls.SqlDataSourceCommandEventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.SqlDataSourceView.#OnSelected(System.Web.UI.WebControls.SqlDataSourceStatusEventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.SqlDataSourceView.#OnSelecting(System.Web.UI.WebControls.SqlDataSourceSelectingEventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.SqlDataSourceView.#OnUpdated(System.Web.UI.WebControls.SqlDataSourceStatusEventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.SqlDataSourceView.#OnUpdating(System.Web.UI.WebControls.SqlDataSourceCommandEventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.UI.WebControls.SqlDataSourceView.#RaiseUnsupportedCapabilityError(System.Web.UI.DataSourceCapabilities)", Justification = @"[....]: This model works best for this API.")]
[module: SuppressMessage("Microsoft.Globalization", "CA1306:SetLocaleForDataTypes", Scope = "member", Target = "System.Web.UI.WebControls.SqlDataSourceView.#Select(System.Web.UI.DataSourceSelectArguments)", Justification = @"[....]: The locale property isn't needed.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.WebControls.StringArrayConverter.#CanConvertFrom(System.ComponentModel.ITypeDescriptorContext,System.Type)", Justification = @"[....]: We don't own TypeConverter")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.WebControls.StringArrayConverter.#ConvertFrom(System.ComponentModel.ITypeDescriptorContext,System.Globalization.CultureInfo,System.Object)", Justification = @"[....]: We don't own TypeConverter")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.WebControls.StringArrayConverter.#ConvertTo(System.ComponentModel.ITypeDescriptorContext,System.Globalization.CultureInfo,System.Object,System.Type)", Justification = @"[....]: We don't own TypeConverter")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.Style.#.ctor()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Design", "CA1011:ConsiderPassingBaseTypesAsParameters", Scope = "member", Target = "System.Web.UI.WebControls.Style.#AddAttributesToRender(System.Web.UI.HtmlTextWriter,System.Web.UI.WebControls.WebControl)", Justification = @"[....]: Breaking changes")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.UI.WebControls.Style.#ClearBit(System.Int32)", Justification = @"[....]: Style.ClearBit is called by FontInfo methods.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.Style.#CopyFrom(System.Web.UI.WebControls.Style)", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.Style.#get_Height()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.Style.#set_Height(System.Web.UI.WebControls.Unit)", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "System.Web.UI.WebControls.Style.#SetBit(System.Int32)", Justification = @"[....]: Reviewed, and these are appropriate uses of methods.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.Style.#get_Width()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.Style.#set_Width(System.Web.UI.WebControls.Unit)", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Design", "CA1035:ICollectionImplementationsHaveStronglyTypedMembers", Scope = "type", Target = "System.Web.UI.WebControls.StyleCollection", Justification = @"[....]: ICollection and IList implementations are inherited from StateManagedCollection.  ICollection.CopyTo() and IList.IndexOf() are for internal use only.")]
[module: SuppressMessage("Microsoft.Design", "CA1039:ListsAreStronglyTyped", Scope = "type", Target = "System.Web.UI.WebControls.StyleCollection", Justification = @"[....]: ICollection and IList implementations are inherited from StateManagedCollection.  ICollection.CopyTo() and IList.IndexOf() are for internal use only.")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "type", Target = "System.Web.UI.WebControls.SubMenuStyle", MessageId = "SubMenu", Justification = @"[....]: Spellings ok.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.WebControls.SubMenuStyle.#System.ComponentModel.ICustomTypeDescriptor.GetAttributes()", Justification = @"[....]: Derived classes can still have their own implementation and there's nothing in the base class that they can't do. We do not want implicit implementation of this interface, and we don't want to seal.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.WebControls.SubMenuStyle.#System.ComponentModel.ICustomTypeDescriptor.GetAttributes()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.WebControls.SubMenuStyle.#System.ComponentModel.ICustomTypeDescriptor.GetClassName()", Justification = @"[....]: Derived classes can still have their own implementation and there's nothing in the base class that they can't do. We do not want implicit implementation of this interface, and we don't want to seal.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.WebControls.SubMenuStyle.#System.ComponentModel.ICustomTypeDescriptor.GetClassName()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.WebControls.SubMenuStyle.#System.ComponentModel.ICustomTypeDescriptor.GetComponentName()", Justification = @"[....]: Derived classes can still have their own implementation and there's nothing in the base class that they can't do. We do not want implicit implementation of this interface, and we don't want to seal.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.WebControls.SubMenuStyle.#System.ComponentModel.ICustomTypeDescriptor.GetComponentName()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.WebControls.SubMenuStyle.#System.ComponentModel.ICustomTypeDescriptor.GetConverter()", Justification = @"[....]: Derived classes can still have their own implementation and there's nothing in the base class that they can't do. We do not want implicit implementation of this interface, and we don't want to seal.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.WebControls.SubMenuStyle.#System.ComponentModel.ICustomTypeDescriptor.GetConverter()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.WebControls.SubMenuStyle.#System.ComponentModel.ICustomTypeDescriptor.GetDefaultEvent()", Justification = @"[....]: Derived classes can still have their own implementation and there's nothing in the base class that they can't do. We do not want implicit implementation of this interface, and we don't want to seal.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.WebControls.SubMenuStyle.#System.ComponentModel.ICustomTypeDescriptor.GetDefaultEvent()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.WebControls.SubMenuStyle.#System.ComponentModel.ICustomTypeDescriptor.GetDefaultProperty()", Justification = @"[....]: Derived classes can still have their own implementation and there's nothing in the base class that they can't do. We do not want implicit implementation of this interface, and we don't want to seal.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.WebControls.SubMenuStyle.#System.ComponentModel.ICustomTypeDescriptor.GetDefaultProperty()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.WebControls.SubMenuStyle.#System.ComponentModel.ICustomTypeDescriptor.GetEditor(System.Type)", Justification = @"[....]: Derived classes can still have their own implementation and there's nothing in the base class that they can't do. We do not want implicit implementation of this interface, and we don't want to seal.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.WebControls.SubMenuStyle.#System.ComponentModel.ICustomTypeDescriptor.GetEditor(System.Type)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.WebControls.SubMenuStyle.#System.ComponentModel.ICustomTypeDescriptor.GetEvents()", Justification = @"[....]: Derived classes can still have their own implementation and there's nothing in the base class that they can't do. We do not want implicit implementation of this interface, and we don't want to seal.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.WebControls.SubMenuStyle.#System.ComponentModel.ICustomTypeDescriptor.GetEvents()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.WebControls.SubMenuStyle.#System.ComponentModel.ICustomTypeDescriptor.GetEvents(System.Attribute[])", Justification = @"[....]: Derived classes can still have their own implementation and there's nothing in the base class that they can't do. We do not want implicit implementation of this interface, and we don't want to seal.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.WebControls.SubMenuStyle.#System.ComponentModel.ICustomTypeDescriptor.GetEvents(System.Attribute[])", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.WebControls.SubMenuStyle.#System.ComponentModel.ICustomTypeDescriptor.GetProperties()", Justification = @"[....]: Derived classes can still have their own implementation and there's nothing in the base class that they can't do. We do not want implicit implementation of this interface, and we don't want to seal.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.WebControls.SubMenuStyle.#System.ComponentModel.ICustomTypeDescriptor.GetProperties()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.WebControls.SubMenuStyle.#System.ComponentModel.ICustomTypeDescriptor.GetProperties(System.Attribute[])", Justification = @"[....]: Derived classes can still have their own implementation and there's nothing in the base class that they can't do. We do not want implicit implementation of this interface, and we don't want to seal.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.WebControls.SubMenuStyle.#System.ComponentModel.ICustomTypeDescriptor.GetProperties(System.Attribute[])", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes", Scope = "member", Target = "System.Web.UI.WebControls.SubMenuStyle.#System.ComponentModel.ICustomTypeDescriptor.GetPropertyOwner(System.ComponentModel.PropertyDescriptor)", Justification = @"[....]: Derived classes can still have their own implementation and there's nothing in the base class that they can't do. We do not want implicit implementation of this interface, and we don't want to seal.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.WebControls.SubMenuStyle.#System.ComponentModel.ICustomTypeDescriptor.GetPropertyOwner(System.ComponentModel.PropertyDescriptor)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "type", Target = "System.Web.UI.WebControls.SubMenuStyleCollection", MessageId = "SubMenu", Justification = @"[....]: Spellings ok.")]
[module: SuppressMessage("Microsoft.Security", "CA2114:MethodSecurityShouldBeASupersetOfType", Scope = "member", Target = "System.Web.UI.WebControls.Substitution.#GetDelegate(System.Type,System.String)", Justification = @"[....]: The security action on the private method should not conflict with the one on the type-level.  And we do intend to assert the reflection permission when getting delegate to support the control in partial trust apps.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.Substitution.#OnPreRender(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Our event handlers are purposely exposed.")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.UI.WebControls.Table.#RaisePostBackEvent(System.String)", Justification = @"[....]: RaisePostBackEvent is consistent across controls.  Event model is being used correctly.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.Table.#get_Rows()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.Table+RowControlCollection.#Add(System.Web.UI.Control)", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.Table+RowControlCollection.#AddAt(System.Int32,System.Web.UI.Control)", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope = "member", Target = "System.Web.UI.WebControls.TableCell.#AssociatedHeaderCellID", Justification = @"[....]: The design was reviewed by [....] and others, and it is consistent with the design of other controls in asp.net (e.g. gridview).")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope = "member", Target = "System.Web.UI.WebControls.TableCell.#AssociatedHeaderCellID", Justification = @"[....]: The design was reviewed by [....] and others, and it is consistent with the design of other controls in asp.net (e.g. gridview).")]
[module: SuppressMessage("Microsoft.Naming", "CA1706:ShortAcronymsShouldBeUppercase", Scope = "member", Target = "System.Web.UI.WebControls.TableCell.#AssociatedHeaderCellID", Justification = @"[....]: ""ID"" ok for ASP.NET")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.TableCellCollection.#get_Count()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.TableCellCollection.#GetEnumerator()", Justification = @"[....]: Designers run in full trust.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.TableCellCollection.#get_Item(System.Int32)", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.WebControls.TableCellCollection.#System.Collections.IList.get_IsFixedSize()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.WebControls.TableCellCollection.#System.Collections.IList.get_Item(System.Int32)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.WebControls.TableCellCollection.#System.Collections.IList.set_Item(System.Int32,System.Object)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope = "member", Target = "System.Web.UI.WebControls.TableHeaderCell.#CategoryText", Justification = @"[....]: The design was reviewed by [....] and others, and it is consistent with the design of other controls in asp.net (e.g. gridview).")]
[module: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope = "member", Target = "System.Web.UI.WebControls.TableHeaderCell.#CategoryText", Justification = @"[....]: The design was reviewed by [....] and others, and it is consistent with the design of other controls in asp.net (e.g. gridview).")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.UI.WebControls.TableItemStyle.#ResetWrap()", Justification = @"[....]: Called by designer through reflection.")]
[module: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "System.Web.UI.WebControls.TableItemStyle.#ShouldSerializeWrap()", Justification = @"[....]: Called by designer through reflection.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.TableRow.#get_Cells()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.TableRow+CellControlCollection.#Add(System.Web.UI.Control)", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.TableRow+CellControlCollection.#AddAt(System.Int32,System.Web.UI.Control)", Justification = @"[....]: okay")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.TableRowCollection.#get_Count()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.TableRowCollection.#get_Item(System.Int32)", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.WebControls.TableRowCollection.#System.Collections.IList.get_IsFixedSize()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.WebControls.TableRowCollection.#System.Collections.IList.get_Item(System.Int32)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.WebControls.TableRowCollection.#System.Collections.IList.set_Item(System.Int32,System.Object)", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Globalization", "CA1303:DoNotPassLiteralsAsLocalizedParameters", Scope = "member", Target = "System.Web.UI.WebControls.TemplateColumn.#InitializeCell(System.Web.UI.WebControls.TableCell,System.Int32,System.Web.UI.WebControls.ListItemType)", MessageId = "System.Web.UI.WebControls.TableCell.set_Text(System.String)", Justification = @"[....]: &nbsp; is an acceptable spelling and string for non-breaking space.")]
[module: SuppressMessage("Microsoft.Usage", "CA2204:LiteralsShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.UI.WebControls.TemplateColumn.#InitializeCell(System.Web.UI.WebControls.TableCell,System.Int32,System.Web.UI.WebControls.ListItemType)", MessageId = "nbsp", Justification = @"[....]: &nbsp; is an acceptable spelling and string for non-breaking space.")]
[module: SuppressMessage("Microsoft.Globalization", "CA1303:DoNotPassLiteralsAsLocalizedParameters", Scope = "member", Target = "System.Web.UI.WebControls.TemplateField.#InitializeCell(System.Web.UI.WebControls.DataControlFieldCell,System.Web.UI.WebControls.DataControlCellType,System.Web.UI.WebControls.DataControlRowState,System.Int32)", MessageId = "System.Web.UI.WebControls.TableCell.set_Text(System.String)", Justification = @"[....]: &nbsp; is an acceptable spelling and string for non-breaking space.")]
[module: SuppressMessage("Microsoft.Usage", "CA2204:LiteralsShouldBeSpelledCorrectly", Scope = "member", Target = "System.Web.UI.WebControls.TemplateField.#InitializeCell(System.Web.UI.WebControls.DataControlFieldCell,System.Web.UI.WebControls.DataControlCellType,System.Web.UI.WebControls.DataControlRowState,System.Int32)", MessageId = "nbsp", Justification = @"[....]: &nbsp; is an acceptable spelling and string for non-breaking space.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.TextBox.#OnPreRender(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope = "member", Target = "System.Web.UI.WebControls.TextBox.#OnTextChanged(System.EventArgs)", MessageId = "0#", Justification = @"[....]: Reviewed.")]
[module: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "System.Web.UI.WebControls.TextBox.#RaisePostDataChangedEvent()", Justification = @"[....]: Events are being used correctly here.  RaisePostBackEvent and RaisePostDataChangedEvent are members of IPostBackEventHandler and IPostBackDataHandler.")]
[module: SuppressMessage("Microsoft.Design", "CA1054:UriParametersShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.TreeNode.#.ctor(System.String,System.String,System.String)", MessageId = "2#", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Design", "CA1025:ReplaceRepetitiveArgumentsWithParamsArray", Scope = "member", Target = "System.Web.UI.WebControls.TreeNode.#.ctor(System.String,System.String,System.String,System.String,System.String)", Justification = @"[....]: These are distinct arguments.")]
[module: SuppressMessage("Microsoft.Design", "CA1054:UriParametersShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.TreeNode.#.ctor(System.String,System.String,System.String,System.String,System.String)", MessageId = "2#", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Design", "CA1054:UriParametersShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.TreeNode.#.ctor(System.String,System.String,System.String,System.String,System.String)", MessageId = "3#", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.TreeNode.#get_ChildNodes()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.WebControls.TreeNode.#Clone()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "System.Web.UI.WebControls.TreeNode.#get_Depth()", Justification = @"[....]: System.Design is not APTCA.")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.TreeNode.#ImageUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.TreeNode.#NavigateUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", Scope = "member", Target = "System.Web.UI.WebControls.TreeNode.#RenderPreText(System.Web.UI.HtmlTextWriter)", MessageId = "PreText", Justification = @"[....]: Spellings ok.")]
[module: SuppressMessage("Microsoft.Security", "CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope = "member", Target = "System.Web.UI.WebControls.TreeNode.#System.ICloneable.Clone()", Justification = @"[....]: Interfaces and base classes we don't own and can't add link demands to.")]
[module: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "System.Web.UI.WebControls.TreeNodeBinding.#ImageUrl", Justification = @"[....]: Urls ok as strings")]
[module: SuppressMessage("Microsoft.Design", "CA1056:Ur