/*
 *  Author: bwilliams
 *  Created: April 6, 2012
 *
 *  Copyright (C) 2012-2016 VMware, Inc.  All rights reserved. -- VMware Confidential
 *
 *  This code was generated by the script "build/dev/codeGen/genCppXml". Please
 *  speak to Brian W. before modifying it by hand.
 *
 */

#include "stdafx.h"

#include "Doc/DocXml/CafCoreTypesXml/ParameterCollectionXml.h"

#include "Doc/CafCoreTypesDoc/CParameterCollectionDoc.h"
#include "Doc/ProviderRequestDoc/CProviderCollectInstancesDoc.h"
#include "Xml/XmlUtils/CXmlElement.h"
#include "Doc/DocXml/ProviderRequestXml/ProviderCollectInstancesXml.h"

using namespace Caf;

void ProviderCollectInstancesXml::add(
	const SmartPtrCProviderCollectInstancesDoc providerCollectInstancesDoc,
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("ProviderCollectInstancesXml", "add");

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(providerCollectInstancesDoc);
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const std::string classNamespaceVal = providerCollectInstancesDoc->getClassNamespace();
		CAF_CM_VALIDATE_STRING(classNamespaceVal);
		thisXml->addAttribute("classNamespace", classNamespaceVal);

		const std::string classNameVal = providerCollectInstancesDoc->getClassName();
		CAF_CM_VALIDATE_STRING(classNameVal);
		thisXml->addAttribute("className", classNameVal);

		const std::string classVersionVal = providerCollectInstancesDoc->getClassVersion();
		CAF_CM_VALIDATE_STRING(classVersionVal);
		thisXml->addAttribute("classVersion", classVersionVal);

		const std::string jobIdVal =
			BasePlatform::UuidToString(providerCollectInstancesDoc->getJobId());
		CAF_CM_VALIDATE_STRING(jobIdVal);
		thisXml->addAttribute("jobId", jobIdVal);

		const std::string outputDirVal = providerCollectInstancesDoc->getOutputDir();
		CAF_CM_VALIDATE_STRING(outputDirVal);
		thisXml->addAttribute("outputDir", outputDirVal);

		const SmartPtrCParameterCollectionDoc parameterCollectionVal =
			providerCollectInstancesDoc->getParameterCollection();
		if (! parameterCollectionVal.IsNull()) {
			const SmartPtrCXmlElement parameterCollectionXml =
				thisXml->createAndAddElement("parameterCollection");
			ParameterCollectionXml::add(parameterCollectionVal, parameterCollectionXml);
		}
	}
	CAF_CM_EXIT;
}

SmartPtrCProviderCollectInstancesDoc ProviderCollectInstancesXml::parse(
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("ProviderCollectInstancesXml", "parse");

	SmartPtrCProviderCollectInstancesDoc providerCollectInstancesDoc;

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const std::string classNamespaceStrVal =
			thisXml->findRequiredAttribute("classNamespace");
		const std::string classNamespaceVal = classNamespaceStrVal;

		const std::string classNameStrVal =
			thisXml->findRequiredAttribute("className");
		const std::string classNameVal = classNameStrVal;

		const std::string classVersionStrVal =
			thisXml->findRequiredAttribute("classVersion");
		const std::string classVersionVal = classVersionStrVal;

		const std::string jobIdStrVal =
			thisXml->findRequiredAttribute("jobId");
		UUID jobIdVal = CAFCOMMON_GUID_NULL;
		if (! jobIdStrVal.empty()) {
			BasePlatform::UuidFromString(jobIdStrVal.c_str(), jobIdVal);
		}

		const std::string outputDirStrVal =
			thisXml->findRequiredAttribute("outputDir");
		const std::string outputDirVal = outputDirStrVal;

		const SmartPtrCXmlElement parameterCollectionXml =
			thisXml->findOptionalChild("parameterCollection");

		SmartPtrCParameterCollectionDoc parameterCollectionVal;
		if (! parameterCollectionXml.IsNull()) {
			parameterCollectionVal = ParameterCollectionXml::parse(parameterCollectionXml);
		}

		providerCollectInstancesDoc.CreateInstance();
		providerCollectInstancesDoc->initialize(
			classNamespaceVal,
			classNameVal,
			classVersionVal,
			jobIdVal,
			outputDirVal,
			parameterCollectionVal);
	}
	CAF_CM_EXIT;

	return providerCollectInstancesDoc;
}

