/*
 * Copyright (c) 2013, 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 *
 */

#ifndef CPU_ZERO_VM_VM_VERSION_EXT_ZERO_HPP
#define CPU_ZERO_VM_VM_VERSION_EXT_ZERO_HPP

#include "utilities/macros.hpp"
#include "vm_version_zero.hpp"

class VM_Version_Ext : public VM_Version {
 private:
  static const size_t      CPU_TYPE_DESC_BUF_SIZE = 256;

  static int               _no_of_threads;
  static int               _no_of_cores;
  static int               _no_of_sockets;
  static bool              _initialized;
  static char              _cpu_name[CPU_TYPE_DESC_BUF_SIZE];

 public:
  static int number_of_threads(void);
  static int number_of_cores(void);
  static int number_of_sockets(void);

  static const char* cpu_name(void);
  static const char* cpu_description(void);
  static void initialize_cpu_information(void);

};

#endif // CPU_ZERO_VM_VM_VERSION_EXT_ZERO_HPP
