/* DatabaseSourceCollection.c generated by valac 0.40.4, the Vala compiler
 * generated from DatabaseSourceCollection.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;

#define TYPE_DATA_COLLECTION (data_collection_get_type ())
#define DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_COLLECTION, DataCollection))
#define DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_COLLECTION, DataCollectionClass))
#define IS_DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_COLLECTION))
#define IS_DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_COLLECTION))
#define DATA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_COLLECTION, DataCollectionClass))

typedef struct _DataCollection DataCollection;
typedef struct _DataCollectionClass DataCollectionClass;
typedef struct _DataCollectionPrivate DataCollectionPrivate;

#define TYPE_ALTERATION (alteration_get_type ())
#define ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALTERATION, Alteration))
#define ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALTERATION, AlterationClass))
#define IS_ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALTERATION))
#define IS_ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALTERATION))
#define ALTERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALTERATION, AlterationClass))

typedef struct _Alteration Alteration;
typedef struct _AlterationClass AlterationClass;

#define TYPE_MARKER (marker_get_type ())
#define MARKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MARKER, Marker))
#define IS_MARKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MARKER))
#define MARKER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MARKER, MarkerIface))

typedef struct _Marker Marker;
typedef struct _MarkerIface MarkerIface;

#define TYPE_SOURCE_COLLECTION (source_collection_get_type ())
#define SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_COLLECTION, SourceCollection))
#define SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_COLLECTION, SourceCollectionClass))
#define IS_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_COLLECTION))
#define IS_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_COLLECTION))
#define SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_COLLECTION, SourceCollectionClass))

typedef struct _SourceCollection SourceCollection;
typedef struct _SourceCollectionClass SourceCollectionClass;
typedef struct _SourceCollectionPrivate SourceCollectionPrivate;

#define TYPE_SOURCE_BACKLINK (source_backlink_get_type ())
#define SOURCE_BACKLINK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_BACKLINK, SourceBacklink))
#define SOURCE_BACKLINK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_BACKLINK, SourceBacklinkClass))
#define IS_SOURCE_BACKLINK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_BACKLINK))
#define IS_SOURCE_BACKLINK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_BACKLINK))
#define SOURCE_BACKLINK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_BACKLINK, SourceBacklinkClass))

typedef struct _SourceBacklink SourceBacklink;
typedef struct _SourceBacklinkClass SourceBacklinkClass;

#define TYPE_DATABASE_SOURCE_COLLECTION (database_source_collection_get_type ())
#define DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollection))
#define DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))
#define IS_DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_SOURCE_COLLECTION))
#define IS_DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_SOURCE_COLLECTION))
#define DATABASE_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))

typedef struct _DatabaseSourceCollection DatabaseSourceCollection;
typedef struct _DatabaseSourceCollectionClass DatabaseSourceCollectionClass;
typedef struct _DatabaseSourceCollectionPrivate DatabaseSourceCollectionPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_SOURCE_HOLDING_TANK (source_holding_tank_get_type ())
#define SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_HOLDING_TANK, SourceHoldingTank))
#define SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_HOLDING_TANK, SourceHoldingTankClass))
#define IS_SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_HOLDING_TANK))
#define IS_SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_HOLDING_TANK))
#define SOURCE_HOLDING_TANK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_HOLDING_TANK, SourceHoldingTankClass))

typedef struct _SourceHoldingTank SourceHoldingTank;
typedef struct _SourceHoldingTankClass SourceHoldingTankClass;
typedef struct _SourceHoldingTankPrivate SourceHoldingTankPrivate;

#define TYPE_DATABASE_SOURCE_HOLDING_TANK (database_source_holding_tank_get_type ())
#define DATABASE_SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_SOURCE_HOLDING_TANK, DatabaseSourceHoldingTank))
#define DATABASE_SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_SOURCE_HOLDING_TANK, DatabaseSourceHoldingTankClass))
#define IS_DATABASE_SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_SOURCE_HOLDING_TANK))
#define IS_DATABASE_SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_SOURCE_HOLDING_TANK))
#define DATABASE_SOURCE_HOLDING_TANK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_SOURCE_HOLDING_TANK, DatabaseSourceHoldingTankClass))

typedef struct _DatabaseSourceHoldingTank DatabaseSourceHoldingTank;
typedef struct _DatabaseSourceHoldingTankClass DatabaseSourceHoldingTankClass;
typedef struct _DatabaseSourceHoldingTankPrivate DatabaseSourceHoldingTankPrivate;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef gint64 (*GetSourceDatabaseKey) (DataSource* source, void* user_data);
typedef gint64 (*Comparator) (void* a, void* b, void* user_data);
typedef gboolean (*ComparatorPredicate) (DataObject* object, Alteration* alteration, void* user_data);
typedef gboolean (*ProgressMonitor) (guint64 current, guint64 total, gboolean do_event_loop, void* user_data);
struct _MarkerIface {
	GTypeInterface parent_iface;
	void (*mark) (Marker* self, DataObject* object);
	void (*unmark) (Marker* self, DataObject* object);
	gboolean (*toggle) (Marker* self, DataObject* object);
	void (*mark_many) (Marker* self, GeeCollection* list);
	void (*unmark_many) (Marker* self, GeeCollection* list);
	void (*mark_all) (Marker* self);
	gint (*get_count) (Marker* self);
	GeeCollection* (*get_all) (Marker* self);
};

struct _DataCollection {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DataCollectionPrivate * priv;
};

struct _DataCollectionClass {
	GTypeClass parent_class;
	void (*finalize) (DataCollection *self);
	gchar* (*to_string) (DataCollection* self);
	void (*notify_items_added) (DataCollection* self, GeeIterable* added);
	void (*notify_items_removed) (DataCollection* self, GeeIterable* removed);
	void (*notify_contents_altered) (DataCollection* self, GeeIterable* added, GeeIterable* removed);
	void (*notify_items_altered) (DataCollection* self, GeeMap* items);
	void (*notify_ordering_changed) (DataCollection* self);
	void (*notify_property_set) (DataCollection* self, const gchar* name, GValue* old, GValue* val);
	void (*notify_property_cleared) (DataCollection* self, const gchar* name);
	gboolean (*valid_type) (DataCollection* self, DataObject* object);
	void (*set_comparator) (DataCollection* self, Comparator comparator, void* comparator_target, ComparatorPredicate predicate, void* predicate_target);
	void (*reset_comparator) (DataCollection* self);
	GeeCollection* (*get_all) (DataCollection* self);
	gint (*get_count) (DataCollection* self);
	DataObject* (*get_at) (DataCollection* self, gint index);
	gint (*index_of) (DataCollection* self, DataObject* object);
	gboolean (*contains) (DataCollection* self, DataObject* object);
	gboolean (*add) (DataCollection* self, DataObject* object);
	GeeCollection* (*add_many) (DataCollection* self, GeeCollection* objects, ProgressMonitor monitor, void* monitor_target);
	void (*remove_marked) (DataCollection* self, Marker* m);
	void (*clear) (DataCollection* self);
	void (*close) (DataCollection* self);
	void (*notify_frozen) (DataCollection* self);
	void (*notify_thawed) (DataCollection* self);
	void (*items_added) (DataCollection* self, GeeIterable* added);
	void (*items_removed) (DataCollection* self, GeeIterable* removed);
	void (*contents_altered) (DataCollection* self, GeeIterable* added, GeeIterable* removed);
	void (*items_altered) (DataCollection* self, GeeMap* items);
	void (*ordering_changed) (DataCollection* self);
	void (*property_set) (DataCollection* self, const gchar* name, GValue* old, GValue* val);
	void (*property_cleared) (DataCollection* self, const gchar* name);
	void (*frozen) (DataCollection* self);
	void (*thawed) (DataCollection* self);
};

struct _SourceCollection {
	DataCollection parent_instance;
	SourceCollectionPrivate * priv;
};

struct _SourceCollectionClass {
	DataCollectionClass parent_class;
	gboolean (*holds_type_of_source) (SourceCollection* self, DataSource* source);
	void (*notify_items_unlinking) (SourceCollection* self, GeeCollection* unlinking);
	void (*notify_items_relinked) (SourceCollection* self, GeeCollection* relinked);
	void (*notify_item_destroyed) (SourceCollection* self, DataSource* source);
	void (*notify_items_destroyed) (SourceCollection* self, GeeCollection* destroyed);
	void (*notify_unlinked_destroyed) (SourceCollection* self, DataSource* unlinked);
	void (*notify_backlink_removed) (SourceCollection* self, SourceBacklink* backlink, GeeCollection* sources);
	gboolean (*has_backlink) (SourceCollection* self, SourceBacklink* backlink);
	void (*remove_backlink) (SourceCollection* self, SourceBacklink* backlink);
	void (*items_unlinking) (SourceCollection* self, GeeCollection* unlinking);
	void (*items_relinked) (SourceCollection* self, GeeCollection* relinked);
	void (*item_destroyed) (SourceCollection* self, DataSource* source);
	void (*items_destroyed) (SourceCollection* self, GeeCollection* destroyed);
	void (*unlinked_destroyed) (SourceCollection* self, DataSource* source);
	void (*backlink_removed) (SourceCollection* self, SourceBacklink* backlink, GeeCollection* sources);
};

struct _DatabaseSourceCollection {
	SourceCollection parent_instance;
	DatabaseSourceCollectionPrivate * priv;
};

struct _DatabaseSourceCollectionClass {
	SourceCollectionClass parent_class;
};

struct _DatabaseSourceCollectionPrivate {
	GetSourceDatabaseKey source_key_func;
	gpointer source_key_func_target;
	GeeHashMap* map;
};

struct _SourceHoldingTank {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SourceHoldingTankPrivate * priv;
};

struct _SourceHoldingTankClass {
	GTypeClass parent_class;
	void (*finalize) (SourceHoldingTank *self);
	void (*notify_contents_altered) (SourceHoldingTank* self, GeeCollection* added, GeeCollection* removed);
	void (*contents_altered) (SourceHoldingTank* self, GeeCollection* added, GeeCollection* removed);
};

struct _DatabaseSourceHoldingTank {
	SourceHoldingTank parent_instance;
	DatabaseSourceHoldingTankPrivate * priv;
};

struct _DatabaseSourceHoldingTankClass {
	SourceHoldingTankClass parent_class;
};

struct _DatabaseSourceHoldingTankPrivate {
	GetSourceDatabaseKey get_key;
	gpointer get_key_target;
	GeeHashMap* map;
};

typedef gboolean (*SourceHoldingTankCheckToKeep) (DataSource* source, Alteration* alteration, void* user_data);

static gpointer database_source_collection_parent_class = NULL;
static gpointer database_source_holding_tank_parent_class = NULL;

GType data_object_get_type (void) G_GNUC_CONST;
GType data_source_get_type (void) G_GNUC_CONST;
gpointer data_collection_ref (gpointer instance);
void data_collection_unref (gpointer instance);
GParamSpec* param_spec_data_collection (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
void value_set_data_collection (GValue* value,
                                gpointer v_object);
void value_take_data_collection (GValue* value,
                                 gpointer v_object);
gpointer value_get_data_collection (const GValue* value);
GType data_collection_get_type (void) G_GNUC_CONST;
gpointer alteration_ref (gpointer instance);
void alteration_unref (gpointer instance);
GParamSpec* param_spec_alteration (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags);
void value_set_alteration (GValue* value,
                           gpointer v_object);
void value_take_alteration (GValue* value,
                            gpointer v_object);
gpointer value_get_alteration (const GValue* value);
GType alteration_get_type (void) G_GNUC_CONST;
GType marker_get_type (void) G_GNUC_CONST;
GType source_collection_get_type (void) G_GNUC_CONST;
gpointer source_backlink_ref (gpointer instance);
void source_backlink_unref (gpointer instance);
GParamSpec* param_spec_source_backlink (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
void value_set_source_backlink (GValue* value,
                                gpointer v_object);
void value_take_source_backlink (GValue* value,
                                 gpointer v_object);
gpointer value_get_source_backlink (const GValue* value);
GType source_backlink_get_type (void) G_GNUC_CONST;
GType database_source_collection_get_type (void) G_GNUC_CONST;
#define DATABASE_SOURCE_COLLECTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionPrivate))
guint int64_hash (gint64* n);
static guint _int64_hash_gee_hash_data_func (gconstpointer v,
                                      gpointer self);
gboolean int64_equal (gint64* a,
                      gint64* b);
static gboolean _int64_equal_gee_equal_data_func (gconstpointer a,
                                           gconstpointer b,
                                           gpointer self);
static gint64* _int64_dup (gint64* self);
DatabaseSourceCollection* database_source_collection_construct (GType object_type,
                                                                const gchar* name,
                                                                GetSourceDatabaseKey source_key_func,
                                                                void* source_key_func_target);
SourceCollection* source_collection_construct (GType object_type,
                                               const gchar* name);
static void database_source_collection_real_notify_items_added (DataCollection* base,
                                                         GeeIterable* added);
void data_collection_notify_items_added (DataCollection* self,
                                         GeeIterable* added);
static void database_source_collection_real_notify_items_removed (DataCollection* base,
                                                           GeeIterable* removed);
void data_collection_notify_items_removed (DataCollection* self,
                                           GeeIterable* removed);
DataSource* database_source_collection_fetch_by_key (DatabaseSourceCollection* self,
                                                     gint64 key);
static void database_source_collection_finalize (DataCollection * obj);
gpointer source_holding_tank_ref (gpointer instance);
void source_holding_tank_unref (gpointer instance);
GParamSpec* param_spec_source_holding_tank (const gchar* name,
                                            const gchar* nick,
                                            const gchar* blurb,
                                            GType object_type,
                                            GParamFlags flags);
void value_set_source_holding_tank (GValue* value,
                                    gpointer v_object);
void value_take_source_holding_tank (GValue* value,
                                     gpointer v_object);
gpointer value_get_source_holding_tank (const GValue* value);
GType source_holding_tank_get_type (void) G_GNUC_CONST;
GType database_source_holding_tank_get_type (void) G_GNUC_CONST;
#define DATABASE_SOURCE_HOLDING_TANK_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DATABASE_SOURCE_HOLDING_TANK, DatabaseSourceHoldingTankPrivate))
DatabaseSourceHoldingTank* database_source_holding_tank_new (SourceCollection* sources,
                                                             SourceHoldingTankCheckToKeep check_to_keep,
                                                             void* check_to_keep_target,
                                                             GetSourceDatabaseKey get_key,
                                                             void* get_key_target);
DatabaseSourceHoldingTank* database_source_holding_tank_construct (GType object_type,
                                                                   SourceCollection* sources,
                                                                   SourceHoldingTankCheckToKeep check_to_keep,
                                                                   void* check_to_keep_target,
                                                                   GetSourceDatabaseKey get_key,
                                                                   void* get_key_target);
SourceHoldingTank* source_holding_tank_new (SourceCollection* sources,
                                            SourceHoldingTankCheckToKeep check_to_keep,
                                            void* check_to_keep_target);
SourceHoldingTank* source_holding_tank_construct (GType object_type,
                                                  SourceCollection* sources,
                                                  SourceHoldingTankCheckToKeep check_to_keep,
                                                  void* check_to_keep_target);
DataSource* database_source_holding_tank_get_by_id (DatabaseSourceHoldingTank* self,
                                                    gint64 id);
static void database_source_holding_tank_real_notify_contents_altered (SourceHoldingTank* base,
                                                                GeeCollection* added,
                                                                GeeCollection* removed);
void source_holding_tank_notify_contents_altered (SourceHoldingTank* self,
                                                  GeeCollection* added,
                                                  GeeCollection* removed);
static void database_source_holding_tank_finalize (SourceHoldingTank * obj);


static guint
_int64_hash_gee_hash_data_func (gconstpointer v,
                                gpointer self)
{
	guint result;
	result = int64_hash ((gint64*) v);
#line 17 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
	return result;
#line 381 "DatabaseSourceCollection.c"
}


static gboolean
_int64_equal_gee_equal_data_func (gconstpointer a,
                                  gconstpointer b,
                                  gpointer self)
{
	gboolean result;
	result = int64_equal ((gint64*) a, (gint64*) b);
#line 17 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
	return result;
#line 394 "DatabaseSourceCollection.c"
}


static gint64*
_int64_dup (gint64* self)
{
	gint64* dup;
#line 17 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
	dup = g_new0 (gint64, 1);
#line 17 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
	memcpy (dup, self, sizeof (gint64));
#line 17 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
	return dup;
#line 408 "DatabaseSourceCollection.c"
}


DatabaseSourceCollection*
database_source_collection_construct (GType object_type,
                                      const gchar* name,
                                      GetSourceDatabaseKey source_key_func,
                                      void* source_key_func_target)
{
	DatabaseSourceCollection* self = NULL;
#line 20 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 21 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
	self = (DatabaseSourceCollection*) source_collection_construct (object_type, name);
#line 23 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
	self->priv->source_key_func = source_key_func;
#line 23 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
	self->priv->source_key_func_target = source_key_func_target;
#line 20 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
	return self;
#line 429 "DatabaseSourceCollection.c"
}


static gpointer
_g_object_ref0 (gpointer self)
{
#line 28 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
	return self ? g_object_ref (self) : NULL;
#line 438 "DatabaseSourceCollection.c"
}


static void
database_source_collection_real_notify_items_added (DataCollection* base,
                                                    GeeIterable* added)
{
	DatabaseSourceCollection * self;
#line 26 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollection);
#line 26 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
	g_return_if_fail (GEE_IS_ITERABLE (added));
#line 451 "DatabaseSourceCollection.c"
	{
		GeeIterator* _object_it = NULL;
		GeeIterator* _tmp0_;
#line 27 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
		_tmp0_ = gee_iterable_iterator (added);
#line 27 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
		_object_it = _tmp0_;
#line 27 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
		while (TRUE) {
#line 461 "DatabaseSourceCollection.c"
			GeeIterator* _tmp1_;
			DataObject* object = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			DataSource* source = NULL;
			DataObject* _tmp4_;
			DataSource* _tmp5_;
			gint64 key = 0LL;
			GetSourceDatabaseKey _tmp6_;
			void* _tmp6__target;
			DataSource* _tmp7_;
			GeeHashMap* _tmp8_;
			gint64 _tmp9_;
			GeeHashMap* _tmp10_;
			gint64 _tmp11_;
			DataSource* _tmp12_;
#line 27 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
			_tmp1_ = _object_it;
#line 27 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
			if (!gee_iterator_next (_tmp1_)) {
#line 27 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
				break;
#line 484 "DatabaseSourceCollection.c"
			}
#line 27 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
			_tmp2_ = _object_it;
#line 27 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
			_tmp3_ = gee_iterator_get (_tmp2_);
#line 27 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
			object = (DataObject*) _tmp3_;
#line 28 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
			_tmp4_ = object;
#line 28 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
			_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_DATA_SOURCE, DataSource));
#line 28 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
			source = _tmp5_;
#line 29 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
			_tmp6_ = self->priv->source_key_func;
#line 29 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
			_tmp6__target = self->priv->source_key_func_target;
#line 29 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
			_tmp7_ = source;
#line 29 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
			key = _tmp6_ (_tmp7_, _tmp6__target);
#line 31 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
			_tmp8_ = self->priv->map;
#line 31 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
			_tmp9_ = key;
#line 31 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
			_vala_assert (!gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), &_tmp9_), "!map.has_key(key)");
#line 33 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
			_tmp10_ = self->priv->map;
#line 33 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
			_tmp11_ = key;
#line 33 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
			_tmp12_ = source;
#line 33 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
			gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), &_tmp11_, _tmp12_);
#line 27 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
			_g_object_unref0 (source);
#line 27 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
			_g_object_unref0 (object);
#line 524 "DatabaseSourceCollection.c"
		}
#line 27 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
		_g_object_unref0 (_object_it);
#line 528 "DatabaseSourceCollection.c"
	}
#line 36 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
	DATA_COLLECTION_CLASS (database_source_collection_parent_class)->notify_items_added (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SOURCE_COLLECTION, SourceCollection), TYPE_DATA_COLLECTION, DataCollection), added);
#line 532 "DatabaseSourceCollection.c"
}


static void
database_source_collection_real_notify_items_removed (DataCollection* base,
                                                      GeeIterable* removed)
{
	DatabaseSourceCollection * self;
#line 39 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollection);
#line 39 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
	g_return_if_fail (GEE_IS_ITERABLE (removed));
#line 545 "DatabaseSourceCollection.c"
	{
		GeeIterator* _object_it = NULL;
		GeeIterator* _tmp0_;
#line 40 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
		_tmp0_ = gee_iterable_iterator (removed);
#line 40 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
		_object_it = _tmp0_;
#line 40 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
		while (TRUE) {
#line 555 "DatabaseSourceCollection.c"
			GeeIterator* _tmp1_;
			DataObject* object = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			gint64 key = 0LL;
			GetSourceDatabaseKey _tmp4_;
			void* _tmp4__target;
			DataObject* _tmp5_;
			gboolean is_removed = FALSE;
			GeeHashMap* _tmp6_;
			gint64 _tmp7_;
			gboolean _tmp8_;
			gboolean _tmp9_;
#line 40 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
			_tmp1_ = _object_it;
#line 40 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
			if (!gee_iterator_next (_tmp1_)) {
#line 40 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
				break;
#line 575 "DatabaseSourceCollection.c"
			}
#line 40 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
			_tmp2_ = _object_it;
#line 40 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
			_tmp3_ = gee_iterator_get (_tmp2_);
#line 40 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
			object = (DataObject*) _tmp3_;
#line 41 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
			_tmp4_ = self->priv->source_key_func;
#line 41 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
			_tmp4__target = self->priv->source_key_func_target;
#line 41 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
			_tmp5_ = object;
#line 41 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
			key = _tmp4_ (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_DATA_SOURCE, DataSource), _tmp4__target);
#line 43 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
			_tmp6_ = self->priv->map;
#line 43 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
			_tmp7_ = key;
#line 43 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
			_tmp8_ = gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), &_tmp7_, NULL);
#line 43 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
			is_removed = _tmp8_;
#line 44 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
			_tmp9_ = is_removed;
#line 44 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
			_vala_assert (_tmp9_, "is_removed");
#line 40 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
			_g_object_unref0 (object);
#line 605 "DatabaseSourceCollection.c"
		}
#line 40 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
		_g_object_unref0 (_object_it);
#line 609 "DatabaseSourceCollection.c"
	}
#line 47 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
	DATA_COLLECTION_CLASS (database_source_collection_parent_class)->notify_items_removed (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SOURCE_COLLECTION, SourceCollection), TYPE_DATA_COLLECTION, DataCollection), removed);
#line 613 "DatabaseSourceCollection.c"
}


DataSource*
database_source_collection_fetch_by_key (DatabaseSourceCollection* self,
                                         gint64 key)
{
	DataSource* result = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
#line 50 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
	g_return_val_if_fail (IS_DATABASE_SOURCE_COLLECTION (self), NULL);
#line 51 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
	_tmp0_ = self->priv->map;
#line 51 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
	_tmp1_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), &key);
#line 51 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
	result = (DataSource*) _tmp1_;
#line 51 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
	return result;
#line 634 "DatabaseSourceCollection.c"
}


static void
database_source_collection_class_init (DatabaseSourceCollectionClass * klass)
{
#line 15 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
	database_source_collection_parent_class = g_type_class_peek_parent (klass);
#line 15 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
	((DataCollectionClass *) klass)->finalize = database_source_collection_finalize;
#line 15 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
	g_type_class_add_private (klass, sizeof (DatabaseSourceCollectionPrivate));
#line 15 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
	((DataCollectionClass *) klass)->notify_items_added = (void (*) (DataCollection *, GeeIterable*)) database_source_collection_real_notify_items_added;
#line 15 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
	((DataCollectionClass *) klass)->notify_items_removed = (void (*) (DataCollection *, GeeIterable*)) database_source_collection_real_notify_items_removed;
#line 651 "DatabaseSourceCollection.c"
}


static void
database_source_collection_instance_init (DatabaseSourceCollection * self)
{
	GeeHashMap* _tmp0_;
#line 15 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
	self->priv = DATABASE_SOURCE_COLLECTION_GET_PRIVATE (self);
#line 17 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
	_tmp0_ = gee_hash_map_new (G_TYPE_INT64, (GBoxedCopyFunc) _int64_dup, (GDestroyNotify) g_free, TYPE_DATA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _int64_hash_gee_hash_data_func, NULL, NULL, _int64_equal_gee_equal_data_func, NULL, NULL, NULL, NULL, NULL);
#line 17 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
	self->priv->map = _tmp0_;
#line 665 "DatabaseSourceCollection.c"
}


static void
database_source_collection_finalize (DataCollection * obj)
{
	DatabaseSourceCollection * self;
#line 15 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollection);
#line 17 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
	_g_object_unref0 (self->priv->map);
#line 15 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
	DATA_COLLECTION_CLASS (database_source_collection_parent_class)->finalize (obj);
#line 679 "DatabaseSourceCollection.c"
}


GType
database_source_collection_get_type (void)
{
	static volatile gsize database_source_collection_type_id__volatile = 0;
	if (g_once_init_enter (&database_source_collection_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DatabaseSourceCollectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) database_source_collection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DatabaseSourceCollection), 0, (GInstanceInitFunc) database_source_collection_instance_init, NULL };
		GType database_source_collection_type_id;
		database_source_collection_type_id = g_type_register_static (TYPE_SOURCE_COLLECTION, "DatabaseSourceCollection", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&database_source_collection_type_id__volatile, database_source_collection_type_id);
	}
	return database_source_collection_type_id__volatile;
}


DatabaseSourceHoldingTank*
database_source_holding_tank_construct (GType object_type,
                                        SourceCollection* sources,
                                        SourceHoldingTankCheckToKeep check_to_keep,
                                        void* check_to_keep_target,
                                        GetSourceDatabaseKey get_key,
                                        void* get_key_target)
{
	DatabaseSourceHoldingTank* self = NULL;
#line 60 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
	g_return_val_if_fail (IS_SOURCE_COLLECTION (sources), NULL);
#line 62 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
	self = (DatabaseSourceHoldingTank*) source_holding_tank_construct (object_type, sources, check_to_keep, check_to_keep_target);
#line 64 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
	self->priv->get_key = get_key;
#line 64 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
	self->priv->get_key_target = get_key_target;
#line 60 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
	return self;
#line 716 "DatabaseSourceCollection.c"
}


DatabaseSourceHoldingTank*
database_source_holding_tank_new (SourceCollection* sources,
                                  SourceHoldingTankCheckToKeep check_to_keep,
                                  void* check_to_keep_target,
                                  GetSourceDatabaseKey get_key,
                                  void* get_key_target)
{
#line 60 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
	return database_source_holding_tank_construct (TYPE_DATABASE_SOURCE_HOLDING_TANK, sources, check_to_keep, check_to_keep_target, get_key, get_key_target);
#line 729 "DatabaseSourceCollection.c"
}


DataSource*
database_source_holding_tank_get_by_id (DatabaseSourceHoldingTank* self,
                                        gint64 id)
{
	DataSource* result = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
#line 67 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
	g_return_val_if_fail (IS_DATABASE_SOURCE_HOLDING_TANK (self), NULL);
#line 68 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
	_tmp0_ = self->priv->map;
#line 68 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
	_tmp1_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), &id);
#line 68 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
	result = (DataSource*) _tmp1_;
#line 68 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
	return result;
#line 750 "DatabaseSourceCollection.c"
}


static void
database_source_holding_tank_real_notify_contents_altered (SourceHoldingTank* base,
                                                           GeeCollection* added,
                                                           GeeCollection* removed)
{
	DatabaseSourceHoldingTank * self;
#line 71 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DATABASE_SOURCE_HOLDING_TANK, DatabaseSourceHoldingTank);
#line 71 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
	g_return_if_fail ((added == NULL) || GEE_IS_COLLECTION (added));
#line 71 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
	g_return_if_fail ((removed == NULL) || GEE_IS_COLLECTION (removed));
#line 73 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
	if (added != NULL) {
#line 768 "DatabaseSourceCollection.c"
		{
			GeeIterator* _source_it = NULL;
			GeeIterator* _tmp0_;
#line 74 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
			_tmp0_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (added, GEE_TYPE_ITERABLE, GeeIterable));
#line 74 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
			_source_it = _tmp0_;
#line 74 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
			while (TRUE) {
#line 778 "DatabaseSourceCollection.c"
				GeeIterator* _tmp1_;
				DataSource* source = NULL;
				GeeIterator* _tmp2_;
				gpointer _tmp3_;
				GeeHashMap* _tmp4_;
				GetSourceDatabaseKey _tmp5_;
				void* _tmp5__target;
				DataSource* _tmp6_;
				gint64 _tmp7_;
				DataSource* _tmp8_;
#line 74 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
				_tmp1_ = _source_it;
#line 74 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
				if (!gee_iterator_next (_tmp1_)) {
#line 74 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
					break;
#line 795 "DatabaseSourceCollection.c"
				}
#line 74 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
				_tmp2_ = _source_it;
#line 74 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
				_tmp3_ = gee_iterator_get (_tmp2_);
#line 74 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
				source = (DataSource*) _tmp3_;
#line 75 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
				_tmp4_ = self->priv->map;
#line 75 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
				_tmp5_ = self->priv->get_key;
#line 75 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
				_tmp5__target = self->priv->get_key_target;
#line 75 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
				_tmp6_ = source;
#line 75 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
				_tmp7_ = _tmp5_ (_tmp6_, _tmp5__target);
#line 75 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
				_tmp8_ = source;
#line 75 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
				gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), &_tmp7_, _tmp8_);
#line 74 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
				_g_object_unref0 (source);
#line 819 "DatabaseSourceCollection.c"
			}
#line 74 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
			_g_object_unref0 (_source_it);
#line 823 "DatabaseSourceCollection.c"
		}
	}
#line 78 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
	if (removed != NULL) {
#line 828 "DatabaseSourceCollection.c"
		{
			GeeIterator* _source_it = NULL;
			GeeIterator* _tmp9_;
#line 79 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
			_tmp9_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (removed, GEE_TYPE_ITERABLE, GeeIterable));
#line 79 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
			_source_it = _tmp9_;
#line 79 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
			while (TRUE) {
#line 838 "DatabaseSourceCollection.c"
				GeeIterator* _tmp10_;
				DataSource* source = NULL;
				GeeIterator* _tmp11_;
				gpointer _tmp12_;
				GeeHashMap* _tmp13_;
				GetSourceDatabaseKey _tmp14_;
				void* _tmp14__target;
				DataSource* _tmp15_;
				gint64 _tmp16_;
#line 79 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
				_tmp10_ = _source_it;
#line 79 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
				if (!gee_iterator_next (_tmp10_)) {
#line 79 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
					break;
#line 854 "DatabaseSourceCollection.c"
				}
#line 79 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
				_tmp11_ = _source_it;
#line 79 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
				_tmp12_ = gee_iterator_get (_tmp11_);
#line 79 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
				source = (DataSource*) _tmp12_;
#line 80 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
				_tmp13_ = self->priv->map;
#line 80 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
				_tmp14_ = self->priv->get_key;
#line 80 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
				_tmp14__target = self->priv->get_key_target;
#line 80 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
				_tmp15_ = source;
#line 80 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
				_tmp16_ = _tmp14_ (_tmp15_, _tmp14__target);
#line 80 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
				gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), &_tmp16_, NULL);
#line 79 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
				_g_object_unref0 (source);
#line 876 "DatabaseSourceCollection.c"
			}
#line 79 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
			_g_object_unref0 (_source_it);
#line 880 "DatabaseSourceCollection.c"
		}
	}
#line 83 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
	SOURCE_HOLDING_TANK_CLASS (database_source_holding_tank_parent_class)->notify_contents_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SOURCE_HOLDING_TANK, SourceHoldingTank), added, removed);
#line 885 "DatabaseSourceCollection.c"
}


static void
database_source_holding_tank_class_init (DatabaseSourceHoldingTankClass * klass)
{
#line 55 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
	database_source_holding_tank_parent_class = g_type_class_peek_parent (klass);
#line 55 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
	((SourceHoldingTankClass *) klass)->finalize = database_source_holding_tank_finalize;
#line 55 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
	g_type_class_add_private (klass, sizeof (DatabaseSourceHoldingTankPrivate));
#line 55 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
	((SourceHoldingTankClass *) klass)->notify_contents_altered = (void (*) (SourceHoldingTank *, GeeCollection*, GeeCollection*)) database_source_holding_tank_real_notify_contents_altered;
#line 900 "DatabaseSourceCollection.c"
}


static void
database_source_holding_tank_instance_init (DatabaseSourceHoldingTank * self)
{
	GeeHashMap* _tmp0_;
#line 55 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
	self->priv = DATABASE_SOURCE_HOLDING_TANK_GET_PRIVATE (self);
#line 57 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
	_tmp0_ = gee_hash_map_new (G_TYPE_INT64, (GBoxedCopyFunc) _int64_dup, (GDestroyNotify) g_free, TYPE_DATA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _int64_hash_gee_hash_data_func, NULL, NULL, _int64_equal_gee_equal_data_func, NULL, NULL, NULL, NULL, NULL);
#line 57 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
	self->priv->map = _tmp0_;
#line 914 "DatabaseSourceCollection.c"
}


static void
database_source_holding_tank_finalize (SourceHoldingTank * obj)
{
	DatabaseSourceHoldingTank * self;
#line 55 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DATABASE_SOURCE_HOLDING_TANK, DatabaseSourceHoldingTank);
#line 57 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
	_g_object_unref0 (self->priv->map);
#line 55 "/home/jens/Source/shotwell/src/core/DatabaseSourceCollection.vala"
	SOURCE_HOLDING_TANK_CLASS (database_source_holding_tank_parent_class)->finalize (obj);
#line 928 "DatabaseSourceCollection.c"
}


GType
database_source_holding_tank_get_type (void)
{
	static volatile gsize database_source_holding_tank_type_id__volatile = 0;
	if (g_once_init_enter (&database_source_holding_tank_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DatabaseSourceHoldingTankClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) database_source_holding_tank_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DatabaseSourceHoldingTank), 0, (GInstanceInitFunc) database_source_holding_tank_instance_init, NULL };
		GType database_source_holding_tank_type_id;
		database_source_holding_tank_type_id = g_type_register_static (TYPE_SOURCE_HOLDING_TANK, "DatabaseSourceHoldingTank", &g_define_type_info, 0);
		g_once_init_leave (&database_source_holding_tank_type_id__volatile, database_source_holding_tank_type_id);
	}
	return database_source_holding_tank_type_id__volatile;
}



