### This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.

## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.

## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

import os
from sos.plugins import Plugin, RedHatPlugin, DebianPlugin, UbuntuPlugin

class Block(Plugin, RedHatPlugin, DebianPlugin, UbuntuPlugin):
    """Block device related information
    """

    plugin_name = 'block'

    def setup(self):
        self.add_copy_spec("/proc/partitions")
        
        self.add_cmd_output("lsblk")
        self.add_cmd_output("blkid -c /dev/null")
        self.add_cmd_output("ls -lanR /dev")
        self.add_cmd_output("ls -lanR /sys/block")

        # legacy location for non-/run distributions
        self.add_copy_spec("/etc/blkid.tab")
        self.add_copy_spec("/run/blkid/blkid.tab")

        if os.path.isdir("/sys/block"):
            for disk in os.listdir("/sys/block"):
                if disk in [ ".",  ".." ] or disk.startswith("ram"):
                    continue
                disk_path = os.path.join('/dev/', disk)
                self.add_cmd_output("udevadm info -ap /sys/block/%s" % (disk))
                self.add_cmd_output("parted -s %s print" % (disk_path))
                self.add_cmd_output("fdisk -l %s" % disk_path)
