/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay.driver;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.sql.Statement;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.replay.OracleDataSource;
import oracle.jdbc.replay.driver.FailoverManager;
import oracle.jdbc.replay.driver.NonTxnReplayableBase;
import oracle.jdbc.replay.driver.ReplayLoggerFactory;
import oracle.jdbc.replay.driver.Replayable;
import oracle.jdbc.replay.internal.ConnectionInitializationCallback;

class FailoverManagerImpl
implements FailoverManager {
    private static final String MNGR_FEATURE_LOGGER_NAME = "oracle.jdbc.internal.replay.FailoverManagerImpl";
    private static Logger MNGR_REPLAY_LOGGER = null;
    private static final String MONITOR_TXN = "BEGIN DBMS_APP_CONT_PRVT.MONITOR_TXN; END;";
    private static final String BEGIN_REPLAY = "BEGIN DBMS_APP_CONT_PRVT.BEGIN_REPLAY; END;";
    private static final String END_REPLAY = "BEGIN DBMS_APP_CONT_PRVT.END_REPLAY; END;";
    private CallHistoryEntry head;
    private CallHistoryEntry tail;
    private ReplayLifecycle lifecycle = ReplayLifecycle.INTERNALLY_DISABLED;
    private boolean replayInCurrentMode = false;
    private Object replayResult;
    private long requestStartTime;
    private long replayInitiationTimeout = 900L;
    private static final int REPLAY_RETRIES = 3;
    private int replayRetries = 0;
    private OracleDataSource replayDataSource = null;
    private NonTxnReplayableBase connectionProxy;
    private Thread requestThread = null;
    private Method callCausingReplayError;
    private int replayErrorCode;
    private String replayErrorMessage;
    private static final ExecutorService executor = Executors.newSingleThreadExecutor(new ThreadFactory(){
        private static final String THREAD_NAME = "OJDBC-AC-WORKER-THREAD";

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(null, runnable, THREAD_NAME);
            thread.setPriority(5);
            thread.setDaemon(true);
            return thread;
        }
    });

    private FailoverManagerImpl(NonTxnReplayableBase nonTxnReplayableBase, OracleDataSource oracleDataSource) throws SQLException {
        this.connectionProxy = nonTxnReplayableBase;
        this.replayDataSource = oracleDataSource;
        this.requestThread = null;
        this.enableTxnMonitoring((OracleConnection)this.connectionProxy.getDelegate());
    }

    static FailoverManager getFailoverManager(NonTxnReplayableBase nonTxnReplayableBase, OracleDataSource oracleDataSource) throws SQLException {
        return new FailoverManagerImpl(nonTxnReplayableBase, oracleDataSource);
    }

    private void append(CallHistoryEntry callHistoryEntry) {
        callHistoryEntry.prevEntry = this.tail;
        callHistoryEntry.nextEntry = null;
        if (this.tail != null) {
            this.tail.nextEntry = callHistoryEntry;
        }
        this.tail = callHistoryEntry;
        if (this.head == null) {
            this.head = callHistoryEntry;
        }
        Replayable replayable = (Replayable)callHistoryEntry.jdbcProxy;
        replayable.addToSameProxyList(callHistoryEntry);
    }

    private void remove(CallHistoryEntry callHistoryEntry) {
        if (callHistoryEntry.nextEntry != null) {
            callHistoryEntry.nextEntry.prevEntry = callHistoryEntry.prevEntry;
        }
        if (callHistoryEntry.prevEntry != null) {
            callHistoryEntry.prevEntry.nextEntry = callHistoryEntry.nextEntry;
        }
        if (this.head == callHistoryEntry) {
            this.head = callHistoryEntry.nextEntry;
        }
        if (this.tail == callHistoryEntry) {
            this.tail = callHistoryEntry.prevEntry;
        }
        Replayable replayable = (Replayable)callHistoryEntry.jdbcProxy;
        replayable.removeFromSameProxyList(callHistoryEntry);
    }

    synchronized CallHistoryEntry record(Object object, Method method, Object[] objectArray, String string) {
        if (this.requestThread != Thread.currentThread()) {
            return null;
        }
        String string2 = method == null ? "NULL METHOD" : method.getName();
        StringBuilder stringBuilder = new StringBuilder();
        if (objectArray != null && objectArray.length > 0) {
            for (int i2 = 0; i2 < objectArray.length - 1; ++i2) {
                stringBuilder.append(objectArray[i2]);
                stringBuilder.append(",");
            }
            stringBuilder.append(objectArray[objectArray.length - 1]);
        }
        MNGR_REPLAY_LOGGER.log(Level.FINEST, "On connection {0}, recording method {1}({2})", new Object[]{this.connectionProxy, string2, stringBuilder.toString()});
        CallHistoryEntry callHistoryEntry = new CallHistoryEntry(object, method, objectArray, string);
        this.append(callHistoryEntry);
        MNGR_REPLAY_LOGGER.log(Level.FINEST, "On connection {0}, recorded method {1}", new Object[]{this.connectionProxy, string2});
        return callHistoryEntry;
    }

    synchronized void update(Object object, CallHistoryEntry callHistoryEntry, Object object2, String string, long l2, long l3, SQLException sQLException) {
        if (this.requestThread != Thread.currentThread()) {
            return;
        }
        CallHistoryEntry callHistoryEntry2 = callHistoryEntry == null ? this.tail : callHistoryEntry;
        String string2 = callHistoryEntry2 == null || callHistoryEntry2.method == null ? "NULL METHOD" : callHistoryEntry2.method.getName();
        MNGR_REPLAY_LOGGER.log(Level.FINEST, "On connection {0}, updating entry for method {1}", new Object[]{this.connectionProxy, string2});
        callHistoryEntry2.result = object2;
        callHistoryEntry2.checksum = l2;
        callHistoryEntry2.scn = l3;
        callHistoryEntry2.callException = sQLException;
        callHistoryEntry2.callStatus = string;
        MNGR_REPLAY_LOGGER.log(Level.FINEST, "On connection {0}, updated entry for method {1} - result: {2}, checksum: {3}, SCN: {4}, SQLException: {5}", new Object[]{this.connectionProxy, string2, object2, l2, l3, sQLException});
    }

    synchronized void purge() {
        if (this.requestThread != Thread.currentThread()) {
            return;
        }
        MNGR_REPLAY_LOGGER.log(Level.FINER, "On connection {0}, calling explicit purge", this.connectionProxy);
        CallHistoryEntry callHistoryEntry = this.head;
        while (callHistoryEntry != null) {
            this.remove(callHistoryEntry);
            callHistoryEntry = callHistoryEntry.nextEntry;
        }
        MNGR_REPLAY_LOGGER.log(Level.FINER, "On connection {0}, calling explicit purge succeeds", this.connectionProxy);
    }

    synchronized void purgeForSameProxy(Set<Object> set, CallHistoryEntry callHistoryEntry) {
        if (this.requestThread != Thread.currentThread()) {
            return;
        }
        Object object = callHistoryEntry == null ? null : callHistoryEntry.jdbcProxy;
        MNGR_REPLAY_LOGGER.log(Level.FINER, "On connection {0}, calling implicit purge for {1}", new Object[]{this.connectionProxy, object});
        CallHistoryEntry callHistoryEntry2 = callHistoryEntry;
        while (callHistoryEntry2 != null) {
            Object object2 = callHistoryEntry2.result;
            if (object2 != null && object2 instanceof Replayable && !set.contains(object2)) {
                Replayable replayable = (Replayable)object2;
                replayable.purgeSameProxyList();
                set.add(replayable);
            }
            MNGR_REPLAY_LOGGER.log(Level.FINEST, "On connection {0}, implicit purge {1}", new Object[]{this.connectionProxy, callHistoryEntry2.method});
            this.remove(callHistoryEntry2);
            callHistoryEntry2 = callHistoryEntry2.nextEntrySameProxy;
        }
        MNGR_REPLAY_LOGGER.log(Level.FINER, "On connection {0}, calling implicit purge for {1} succeeds", new Object[]{this.connectionProxy, object});
    }

    synchronized boolean isEmpty() {
        return this.head == null;
    }

    synchronized void fillInAllChecksums() throws SQLException {
        if (this.requestThread != Thread.currentThread()) {
            return;
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        CallHistoryEntry callHistoryEntry = this.tail.prevEntry;
        while (callHistoryEntry != null) {
            if (!hashSet.contains(callHistoryEntry.jdbcProxy)) {
                NonTxnReplayableBase nonTxnReplayableBase = (NonTxnReplayableBase)callHistoryEntry.jdbcProxy;
                nonTxnReplayableBase.fillInChecksum(callHistoryEntry);
                hashSet.add(callHistoryEntry.jdbcProxy);
                if (callHistoryEntry.jdbcProxy instanceof ResultSet) {
                    hashSet.add(nonTxnReplayableBase.getCreator());
                }
            }
            callHistoryEntry = callHistoryEntry.prevEntry;
        }
    }

    synchronized Object replayAll(SQLRecoverableException sQLRecoverableException) throws SQLException {
        if (this.requestThread != Thread.currentThread()) {
            throw sQLRecoverableException;
        }
        this.replayRetries = 0;
        do {
            ReplayLifecycle replayLifecycle;
            try {
                return this.replayAllInternal(sQLRecoverableException, this.replayRetries);
            }
            catch (SQLRecoverableException sQLRecoverableException2) {
                replayLifecycle = this.lifecycle;
                MNGR_REPLAY_LOGGER.log(Level.FINEST, "replayAll caught new exception: {0}, current lifecycle: {1}", new Object[]{sQLRecoverableException2, replayLifecycle});
                switch (replayLifecycle) {
                    case REPLAYING: 
                    case REPLAYING_CALLBACK: 
                    case REPLAYING_LASTCALL: {
                        ++this.replayRetries;
                        MNGR_REPLAY_LOGGER.log(Level.FINEST, "NEW replay attempt {0}", this.replayRetries);
                        break;
                    }
                }
            }
            catch (SQLException sQLException) {
                replayLifecycle = this.lifecycle;
                MNGR_REPLAY_LOGGER.log(Level.FINEST, "replayAll caught new exception: {0}, current lifecycle: {1}", new Object[]{sQLException, replayLifecycle});
                switch (replayLifecycle) {
                    case INTERNALLY_FAILED: {
                        ++this.replayRetries;
                        this.lifecycle = ReplayLifecycle.REPLAYING;
                        MNGR_REPLAY_LOGGER.log(Level.FINEST, "NEW replay attempt {0} after failed replay", this.replayRetries);
                        break;
                    }
                    case ALWAYS_DISABLED: 
                    case INTERNALLY_DISABLED: 
                    case EXTERNALLY_DISABLED: {
                        this.throwOriginalExceptionWithReplayError(this.replayErrorCode, this.replayErrorMessage, sQLRecoverableException);
                    }
                    case REPLAYING_LASTCALL: {
                        MNGR_REPLAY_LOGGER.log(Level.FINEST, "Replaying last call throws: {0}, rethrowing back", sQLException);
                        throw sQLException;
                    }
                }
            }
        } while (this.replayRetries <= 3);
        MNGR_REPLAY_LOGGER.log(Level.WARNING, "Maximum replay retries exceeded");
        this.disableReplayAndThrowOriginalError(null, 378, "Replay disabled because maximum number of retries is exceeded", sQLRecoverableException);
        return null;
    }

    synchronized Object replayAllInternal(SQLRecoverableException sQLRecoverableException, int n2) throws SQLException {
        OracleConnection oracleConnection;
        MNGR_REPLAY_LOGGER.log(Level.FINER, "Entering replayAllInternal(connection proxy={0}, original error={1})", new Object[]{this.connectionProxy, sQLRecoverableException});
        ReplayLifecycle replayLifecycle = this.lifecycle;
        MNGR_REPLAY_LOGGER.log(Level.FINEST, "current lifecycle:{0}", (Object)replayLifecycle);
        if (this.lifecycle != ReplayLifecycle.ENABLED_NOT_REPLAYING && this.lifecycle != ReplayLifecycle.REPLAYING && this.lifecycle != ReplayLifecycle.REPLAYING_LASTCALL && this.lifecycle != ReplayLifecycle.REPLAYING_CALLBACK) {
            this.throwReplayExceptionInternal(this.replayErrorCode, this.replayErrorMessage, sQLRecoverableException);
        }
        if ((oracleConnection = (OracleConnection)this.replayDataSource.getConnectionNoProxy()) == null) {
            MNGR_REPLAY_LOGGER.log(Level.FINE, "FAILOVER_RETRIES exceeded");
            this.disableReplayAndThrowException(null, 382, "Replay disabled because Failover_Retries is exceeded", sQLRecoverableException);
        }
        MNGR_REPLAY_LOGGER.log(Level.FINER, "Reconnect succeeded, new connection={0}", oracleConnection);
        long l2 = System.currentTimeMillis();
        MNGR_REPLAY_LOGGER.log(Level.FINEST, "timestamp at replay start: {0}", l2);
        if (this.requestStartTime + this.replayInitiationTimeout * 1000L < l2) {
            MNGR_REPLAY_LOGGER.log(Level.WARNING, "ReplayInitiationTimeout exceeded");
            this.disableReplayAndThrowException(null, 377, "Replay disabled because ReplayInitiationTimeout is exceeded", sQLRecoverableException);
        }
        this.connectionProxy.setDelegate(oracleConnection);
        this.lifecycle = ReplayLifecycle.REPLAYING_CALLBACK;
        ConnectionInitializationCallback connectionInitializationCallback = this.replayDataSource.getConnectionInitializationCallback();
        if (connectionInitializationCallback != null) {
            try {
                MNGR_REPLAY_LOGGER.log(Level.FINER, "Invoking Replay Driver initialization callback with {0}", this.connectionProxy);
                connectionInitializationCallback.initialize((Connection)((Object)this.connectionProxy));
                MNGR_REPLAY_LOGGER.log(Level.FINER, "Invoking initialization callback with {0} succeeded", this.connectionProxy);
            }
            catch (SQLException sQLException) {
                MNGR_REPLAY_LOGGER.log(Level.FINER, "Invoking initialization callback with {0} failed", this.connectionProxy);
                this.disableReplayAndThrowException(null, 379, "Replay disabled because Init callback failed", sQLRecoverableException);
            }
            EnumSet<OracleConnection.TransactionState> enumSet = oracleConnection.getTransactionState();
            MNGR_REPLAY_LOGGER.log(Level.FINER, "On connection {0}, after init-callback, transaction state={1}", new Object[]{this.connectionProxy, enumSet});
            if (enumSet.contains((Object)OracleConnection.TransactionState.TRANSACTION_STARTED)) {
                this.disableReplayAndThrowException(null, 380, "Replay disabled because of open transaction in Init callback", sQLRecoverableException);
            }
        }
        this.lifecycle = ReplayLifecycle.REPLAYING;
        if (n2 == 0) {
            this.fillInAllChecksums();
        }
        this.beginReplay(oracleConnection, sQLRecoverableException);
        this.replayResult = this.replayAllBeforeLastCall(sQLRecoverableException);
        this.endReplay(oracleConnection, sQLRecoverableException);
        MNGR_REPLAY_LOGGER.log(Level.FINEST, "On connection {0}, replaying last call", this.connectionProxy);
        if (this.tail != null) {
            this.replayResult = ((Replayable)this.tail.jdbcProxy).replayOneCall(this.tail, sQLRecoverableException);
        }
        this.lifecycle = ReplayLifecycle.ENABLED_NOT_REPLAYING;
        MNGR_REPLAY_LOGGER.log(Level.FINER, "On connection {0}, replay succeeds", this.connectionProxy);
        MNGR_REPLAY_LOGGER.log(Level.FINER, "Exiting replayAll(connection proxy={0}, original error={1}), result={2}", new Object[]{this.connectionProxy, sQLRecoverableException, this.replayResult});
        return this.replayResult;
    }

    private synchronized Object replayAllBeforeLastCall(SQLRecoverableException sQLRecoverableException) throws SQLException {
        Object object = null;
        CallHistoryEntry callHistoryEntry = this.head;
        while (callHistoryEntry != this.tail) {
            Replayable replayable = (Replayable)callHistoryEntry.jdbcProxy;
            MNGR_REPLAY_LOGGER.log(Level.FINEST, "On proxy {0}, replaying {1}", new Object[]{replayable, callHistoryEntry.method});
            object = replayable.replayOneCall(callHistoryEntry, sQLRecoverableException);
            if (this.lifecycle != ReplayLifecycle.ENABLED_NOT_REPLAYING && this.lifecycle != ReplayLifecycle.REPLAYING && this.lifecycle != ReplayLifecycle.REPLAYING_LASTCALL && this.lifecycle != ReplayLifecycle.REPLAYING_CALLBACK) {
                this.throwReplayExceptionInternal(this.replayErrorCode, this.replayErrorMessage, sQLRecoverableException);
            }
            callHistoryEntry = callHistoryEntry.nextEntry;
        }
        return object;
    }

    boolean isReplayInCurrentMode() {
        return this.replayInCurrentMode;
    }

    void setReplayInCurrentMode() {
        this.replayInCurrentMode = true;
    }

    ReplayLifecycle getReplayLifecycle() {
        return this.lifecycle;
    }

    void setDataSource(OracleDataSource oracleDataSource) {
        this.replayDataSource = oracleDataSource;
    }

    void setReplayInitiationTimeout(int n2) throws SQLException {
        this.replayInitiationTimeout = n2;
    }

    void beginRequest() throws SQLException {
        MNGR_REPLAY_LOGGER.log(Level.FINER, "On connection {0}, Entering beginRequest()", this.connectionProxy);
        if (this.lifecycle == ReplayLifecycle.ALWAYS_DISABLED) {
            MNGR_REPLAY_LOGGER.log(Level.FINER, "Exiting beginRequest(), MONITOR_TXN failed, no-op");
            return;
        }
        if (this.lifecycle != ReplayLifecycle.INTERNALLY_DISABLED) {
            throw DatabaseError.createSqlException(390);
        }
        this.requestStartTime = System.currentTimeMillis();
        MNGR_REPLAY_LOGGER.log(Level.FINEST, "Request start timestamp: {0}", this.requestStartTime);
        OracleConnection oracleConnection = (OracleConnection)this.connectionProxy.getDelegate();
        EnumSet<OracleConnection.TransactionState> enumSet = oracleConnection.getTransactionState();
        MNGR_REPLAY_LOGGER.log(Level.FINER, "transaction state: {0}", enumSet);
        if (enumSet.contains((Object)OracleConnection.TransactionState.TRANSACTION_STARTED) && !enumSet.contains((Object)OracleConnection.TransactionState.TRANSACTION_READONLY)) {
            SQLException sQLException = DatabaseError.createSqlException(391);
            MNGR_REPLAY_LOGGER.throwing(this.getClass().getName(), "beginRequest", sQLException);
            throw sQLException;
        }
        this.replayErrorCode = 0;
        this.replayErrorMessage = "";
        this.callCausingReplayError = null;
        this.lifecycle = ReplayLifecycle.ENABLED_NOT_REPLAYING;
        this.requestThread = Thread.currentThread();
        MNGR_REPLAY_LOGGER.log(Level.FINER, "Recording begins on connection {0}", this.connectionProxy);
        MNGR_REPLAY_LOGGER.log(Level.FINER, "Exiting beginRequest()");
    }

    void endRequest() throws SQLException {
        MNGR_REPLAY_LOGGER.log(Level.FINER, "Entering endRequest()");
        if (this.lifecycle == ReplayLifecycle.ALWAYS_DISABLED) {
            MNGR_REPLAY_LOGGER.log(Level.FINER, "Exiting endRequest(), MONITOR_TXN failed, no-op");
            return;
        }
        if (this.lifecycle == ReplayLifecycle.INTERNALLY_DISABLED || this.lifecycle == ReplayLifecycle.EXTERNALLY_DISABLED) {
            MNGR_REPLAY_LOGGER.log(Level.FINER, "Exiting endRequest(), replay already disabled");
            this.lifecycle = ReplayLifecycle.INTERNALLY_DISABLED;
            return;
        }
        OracleConnection oracleConnection = (OracleConnection)this.connectionProxy.getDelegate();
        EnumSet<OracleConnection.TransactionState> enumSet = oracleConnection.getTransactionState();
        MNGR_REPLAY_LOGGER.log(Level.FINER, "transaction state: {0}", enumSet);
        if (enumSet.contains((Object)OracleConnection.TransactionState.TRANSACTION_STARTED) && !enumSet.contains((Object)OracleConnection.TransactionState.TRANSACTION_READONLY)) {
            SQLException sQLException = DatabaseError.createSqlException(392);
            MNGR_REPLAY_LOGGER.throwing(this.getClass().getName(), "endRequest", sQLException);
            throw sQLException;
        }
        this.disableReplayInternal(null, 381, "Replay disabled after endRequest is called", null);
        this.requestThread = null;
        MNGR_REPLAY_LOGGER.log(Level.FINER, "Exiting endRequest()");
    }

    void disableReplay() throws SQLException {
        MNGR_REPLAY_LOGGER.log(Level.FINER, "Entering disableReplay");
        if (this.lifecycle == ReplayLifecycle.ALWAYS_DISABLED) {
            MNGR_REPLAY_LOGGER.log(Level.FINER, "Exiting disableReplay(), MONITOR_TXN failed, no-op");
            return;
        }
        this.disableReplayInternal(null, 370, "Replay disabled", null);
        this.lifecycle = ReplayLifecycle.EXTERNALLY_DISABLED;
        MNGR_REPLAY_LOGGER.log(Level.FINER, "On connection {0}, replay is externally disabled", this.connectionProxy);
        MNGR_REPLAY_LOGGER.log(Level.FINER, "Exiting disableReplay");
    }

    void disableReplayInternal(Method method, int n2, String string, SQLRecoverableException sQLRecoverableException) {
        if (this.requestThread != Thread.currentThread()) {
            return;
        }
        MNGR_REPLAY_LOGGER.log(Level.FINER, "Entering disableReplayInternal");
        ReplayLifecycle replayLifecycle = this.lifecycle;
        if (this.lifecycle != ReplayLifecycle.ALWAYS_DISABLED) {
            this.lifecycle = ReplayLifecycle.INTERNALLY_DISABLED;
        }
        this.purge();
        this.replayErrorCode = n2;
        this.replayErrorMessage = string;
        this.callCausingReplayError = method;
        MNGR_REPLAY_LOGGER.log(Level.FINER, "On connection {0}, replay is internally disabled", this.connectionProxy);
        MNGR_REPLAY_LOGGER.log(Level.FINER, "Exiting disableReplayInternal");
    }

    void failReplayInternal(Method method, int n2, String string, SQLRecoverableException sQLRecoverableException) {
        if (this.requestThread != Thread.currentThread()) {
            return;
        }
        MNGR_REPLAY_LOGGER.log(Level.FINER, "Entering failReplayInternal");
        ReplayLifecycle replayLifecycle = this.lifecycle;
        if (this.lifecycle == ReplayLifecycle.REPLAYING || this.lifecycle == ReplayLifecycle.REPLAYING_CALLBACK || this.lifecycle == ReplayLifecycle.REPLAYING_LASTCALL) {
            this.lifecycle = ReplayLifecycle.INTERNALLY_FAILED;
        }
        this.replayErrorCode = n2;
        this.replayErrorMessage = string;
        this.callCausingReplayError = method;
        MNGR_REPLAY_LOGGER.log(Level.FINER, "On connection {0}, replay failed", this.connectionProxy);
        MNGR_REPLAY_LOGGER.log(Level.FINER, "Exiting failReplayInternal");
    }

    void throwReplayExceptionInternal(int n2, String string, SQLRecoverableException sQLRecoverableException) throws SQLException {
        if (n2 == 0) {
            return;
        }
        String string2 = this.callCausingReplayError == null ? "" : this.callCausingReplayError.getName();
        SQLException sQLException = DatabaseError.createSqlException(this.replayErrorCode, string2);
        throw sQLException;
    }

    void disableReplayAndThrowException(Method method, int n2, String string, SQLRecoverableException sQLRecoverableException) throws SQLException {
        this.disableReplayInternal(method, n2, string, sQLRecoverableException);
        this.throwReplayExceptionInternal(n2, string, sQLRecoverableException);
    }

    void disableReplayAndThrowOriginalError(Method method, int n2, String string, SQLRecoverableException sQLRecoverableException) throws SQLException {
        this.disableReplayInternal(method, n2, string, sQLRecoverableException);
        this.throwOriginalExceptionWithReplayError(n2, string, sQLRecoverableException);
    }

    void failReplayAndThrowException(Method method, int n2, String string, SQLRecoverableException sQLRecoverableException) throws SQLException {
        this.failReplayInternal(method, n2, string, sQLRecoverableException);
        this.throwReplayExceptionInternal(n2, string, sQLRecoverableException);
    }

    void throwOriginalExceptionWithReplayError(int n2, String string, SQLRecoverableException sQLRecoverableException) throws SQLRecoverableException {
        this.killConnectionBeforeReplayDisabledException();
        String string2 = this.callCausingReplayError == null ? "" : this.callCausingReplayError.getName();
        SQLException sQLException = DatabaseError.createSqlException(this.replayErrorCode, string2);
        sQLRecoverableException.setNextException(sQLException);
        throw sQLRecoverableException;
    }

    void killConnectionBeforeReplayDisabledException() {
        final OracleConnection oracleConnection = (OracleConnection)this.connectionProxy.getDelegate();
        try {
            oracleConnection.abort();
        }
        catch (SQLException sQLException) {
            MNGR_REPLAY_LOGGER.log(Level.FINE, "Aborting connection failed before throwing replay-disabled exception");
        }
        try {
            executor.submit(new Runnable(){

                @Override
                public void run() {
                    FailoverManagerImpl.this.closePhysicalConnection(oracleConnection);
                }
            });
        }
        catch (Exception exception) {
            MNGR_REPLAY_LOGGER.log(Level.FINER, "On connection {0}, ASYNC close() submission during replay failed", this.connectionProxy);
        }
    }

    void enableTxnMonitoring(OracleConnection oracleConnection) throws SQLException {
        try {
            Statement statement = oracleConnection.createStatement();
            MNGR_REPLAY_LOGGER.log(Level.FINER, "Calling MONITOR_TXN");
            statement.execute(MONITOR_TXN);
            MNGR_REPLAY_LOGGER.log(Level.FINER, "Calling MONITOR_TXN succeeded");
            statement.close();
        }
        catch (SQLException sQLException) {
            MNGR_REPLAY_LOGGER.log(Level.FINER, "Calling MONITOR_TXN failed");
            this.disableReplayInternal(null, 374, "Replay disabled because transaction monitoring failed to be enabled", null);
            this.lifecycle = ReplayLifecycle.ALWAYS_DISABLED;
            throw DatabaseError.createSqlException(394);
        }
    }

    void beginReplay(OracleConnection oracleConnection, SQLRecoverableException sQLRecoverableException) throws SQLException {
        try {
            Statement statement = oracleConnection.createStatement();
            MNGR_REPLAY_LOGGER.log(Level.FINER, "Calling BEGIN_REPLAY");
            statement.execute(BEGIN_REPLAY);
            MNGR_REPLAY_LOGGER.log(Level.FINER, "Calling BEGIN_REPLAY succeeded");
            statement.close();
            this.lifecycle = ReplayLifecycle.REPLAYING;
        }
        catch (SQLException sQLException) {
            MNGR_REPLAY_LOGGER.log(Level.FINER, "Calling BEGIN_REPLAY failed");
            this.disableReplayAndThrowException(null, 375, "Replay disabled because server begin_replay call failed", sQLRecoverableException);
        }
    }

    void endReplay(OracleConnection oracleConnection, SQLRecoverableException sQLRecoverableException) throws SQLException {
        try {
            Statement statement = oracleConnection.createStatement();
            MNGR_REPLAY_LOGGER.log(Level.FINER, "Calling END_REPLAY");
            statement.execute(END_REPLAY);
            MNGR_REPLAY_LOGGER.log(Level.FINER, "Calling END_REPLAY succeeded");
            statement.close();
            this.lifecycle = ReplayLifecycle.REPLAYING_LASTCALL;
        }
        catch (SQLException sQLException) {
            MNGR_REPLAY_LOGGER.log(Level.FINER, "Calling END_REPLAY failed");
            this.disableReplayAndThrowException(null, 376, "Replay disabled because server end_replay call failed", sQLRecoverableException);
        }
    }

    Replayable getConnectionProxy() {
        return this.connectionProxy;
    }

    private boolean isReplayFailure(SQLException sQLException) {
        int n2;
        boolean bl = false;
        if (sQLException instanceof SQLException && (n2 = sQLException.getErrorCode()) >= 370 && n2 < 400) {
            bl = true;
        }
        return bl;
    }

    private void closePhysicalConnection(Connection connection) {
        try {
            connection.close();
        }
        catch (SQLException sQLException) {
            MNGR_REPLAY_LOGGER.log(Level.FINER, "On connection {0}, connection close() during replay failed", this.connectionProxy);
        }
    }

    static {
        if (MNGR_REPLAY_LOGGER == null) {
            MNGR_REPLAY_LOGGER = ReplayLoggerFactory.getLogger(MNGR_FEATURE_LOGGER_NAME);
        }
    }

    static enum ReplayLifecycle {
        ENABLED_NOT_REPLAYING,
        INTERNALLY_FAILED,
        INTERNALLY_DISABLED,
        ALWAYS_DISABLED,
        EXTERNALLY_DISABLED,
        REPLAYING_CALLBACK,
        REPLAYING,
        REPLAYING_LASTCALL;

    }

    static class CallHistoryEntry {
        Object jdbcProxy;
        Method method;
        Object[] args;
        Object result;
        String callStatus;
        long scn;
        long checksum;
        SQLException callException;
        CallHistoryEntry nextEntry = null;
        CallHistoryEntry prevEntry = null;
        CallHistoryEntry nextEntrySameProxy = null;
        CallHistoryEntry prevEntrySameProxy = null;

        CallHistoryEntry(Object object, Method method, Object[] objectArray, String string) {
            this.jdbcProxy = object;
            this.method = method;
            this.args = objectArray;
            this.result = null;
            this.callStatus = string;
        }
    }
}

