/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.peephole;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.DoubleConstant;
import proguard.classfile.constant.FloatConstant;
import proguard.classfile.constant.IntegerConstant;
import proguard.classfile.constant.LongConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.editor.ConstantAdder;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.LookUpSwitchInstruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.TableSwitchInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.InstructionSequenceMatcher;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.optimize.peephole.BranchTargetFinder;

public class InstructionSequenceReplacer
extends SimplifiedVisitor
implements InstructionVisitor,
ConstantVisitor {
    private static final boolean DEBUG = false;
    public static final int X = 0x40000000;
    public static final int Y = 0x40000001;
    public static final int Z = 0x40000002;
    public static final int A = 0x40000003;
    public static final int B = 0x40000004;
    public static final int C = 0x40000005;
    public static final int D = 0x40000006;
    public static final int E = 0x40000007;
    public static final int F = 0x40000008;
    public static final int G = 0x40000009;
    public static final int H = 0x4000000A;
    public static final int I = 0x4000000B;
    public static final int J = 0x4000000C;
    public static final int K = 0x4000000D;
    public static final int L = 0x4000000E;
    public static final int M = 0x4000000F;
    public static final int N = 0x40000010;
    public static final int O = 0x40000011;
    public static final int P = 1073741842;
    public static final int Q = 1073741843;
    public static final int R = 0x40000014;
    private static final int LABEL_FLAG = 0x20000000;
    private static final int BOOLEAN_STRING = 1;
    private static final int CHAR_STRING = 2;
    private static final int INT_STRING = 3;
    private static final int LONG_STRING = 4;
    private static final int FLOAT_STRING = 5;
    private static final int DOUBLE_STRING = 6;
    private static final int STRING_STRING = 7;
    public static final int STRING_A_LENGTH = 0x20000000;
    public static final int BOOLEAN_A_STRING = 0x20000001;
    public static final int CHAR_A_STRING = 0x20000002;
    public static final int INT_A_STRING = 0x20000003;
    public static final int LONG_A_STRING = 0x20000004;
    public static final int FLOAT_A_STRING = 0x20000005;
    public static final int DOUBLE_A_STRING = 0x20000006;
    public static final int STRING_A_STRING = 0x20000007;
    public static final int BOOLEAN_B_STRING = 0x20000010;
    public static final int CHAR_B_STRING = 0x20000020;
    public static final int INT_B_STRING = 0x20000030;
    public static final int LONG_B_STRING = 0x20000040;
    public static final int FLOAT_B_STRING = 0x20000050;
    public static final int DOUBLE_B_STRING = 0x20000060;
    public static final int STRING_B_STRING = 0x20000070;
    private static int labelCounter;
    private final InstructionSequenceMatcher instructionSequenceMatcher;
    private final Constant[] patternConstants;
    private final Instruction[] replacementInstructions;
    private final BranchTargetFinder branchTargetFinder;
    private final CodeAttributeEditor codeAttributeEditor;
    private final InstructionVisitor extraInstructionVisitor;
    private final MyReplacementInstructionFactory replacementInstructionFactory = new MyReplacementInstructionFactory();

    public InstructionSequenceReplacer(Constant[] constantArray, Instruction[] instructionArray, Constant[] constantArray2, Instruction[] instructionArray2, BranchTargetFinder branchTargetFinder, CodeAttributeEditor codeAttributeEditor) {
        this(constantArray, instructionArray, constantArray2, instructionArray2, branchTargetFinder, codeAttributeEditor, null);
    }

    public InstructionSequenceReplacer(Constant[] constantArray, Instruction[] instructionArray, Constant[] constantArray2, Instruction[] instructionArray2, BranchTargetFinder branchTargetFinder, CodeAttributeEditor codeAttributeEditor, InstructionVisitor instructionVisitor) {
        this(new InstructionSequenceMatcher(constantArray, instructionArray), constantArray, instructionArray, constantArray2, instructionArray2, branchTargetFinder, codeAttributeEditor, instructionVisitor);
    }

    protected InstructionSequenceReplacer(InstructionSequenceMatcher instructionSequenceMatcher, Constant[] constantArray, Instruction[] instructionArray, Constant[] constantArray2, Instruction[] instructionArray2, BranchTargetFinder branchTargetFinder, CodeAttributeEditor codeAttributeEditor, InstructionVisitor instructionVisitor) {
        this.instructionSequenceMatcher = instructionSequenceMatcher;
        this.patternConstants = constantArray;
        this.replacementInstructions = instructionArray2;
        this.branchTargetFinder = branchTargetFinder;
        this.codeAttributeEditor = codeAttributeEditor;
        this.extraInstructionVisitor = instructionVisitor;
    }

    @Override
    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction) {
        if (this.branchTargetFinder != null && this.branchTargetFinder.isTarget(n) || this.codeAttributeEditor.isModified(n)) {
            this.instructionSequenceMatcher.reset();
        }
        instruction.accept(clazz, method, codeAttribute, n, this.instructionSequenceMatcher);
        if (this.instructionSequenceMatcher.isMatching() && this.matchedInstructionsUnmodified()) {
            int n2 = this.replacementInstructions.length;
            int n3 = this.instructionSequenceMatcher.instructionCount();
            if (n2 <= n3) {
                int n4;
                for (n4 = 0; n4 < n2; ++n4) {
                    this.codeAttributeEditor.replaceInstruction(this.instructionSequenceMatcher.matchedInstructionOffset(n4), this.replacementInstructionFactory.create(clazz, codeAttribute, n4));
                }
                for (n4 = n2; n4 < n3; ++n4) {
                    this.codeAttributeEditor.deleteInstruction(this.instructionSequenceMatcher.matchedInstructionOffset(n4));
                }
            } else {
                for (int i = 0; i < n3; ++i) {
                    this.codeAttributeEditor.replaceInstruction(this.instructionSequenceMatcher.matchedInstructionOffset(i), this.replacementInstructionFactory.create(clazz, codeAttribute, i));
                }
                Instruction[] instructionArray = new Instruction[n2 - n3];
                for (int i = 0; i < instructionArray.length; ++i) {
                    instructionArray[i] = this.replacementInstructionFactory.create(clazz, codeAttribute, n3 + i);
                }
                this.codeAttributeEditor.insertAfterInstruction(this.instructionSequenceMatcher.matchedInstructionOffset(n3 - 1), instructionArray);
            }
            if (this.extraInstructionVisitor != null) {
                instruction.accept(clazz, method, codeAttribute, n, this.extraInstructionVisitor);
            }
        }
    }

    private boolean matchedInstructionsUnmodified() {
        for (int i = 0; i < this.instructionSequenceMatcher.instructionCount(); ++i) {
            if (!this.codeAttributeEditor.isModified(this.instructionSequenceMatcher.matchedInstructionOffset(i))) continue;
            return false;
        }
        return true;
    }

    protected int matchedArgument(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, int n2) {
        return this.matchedArgument(clazz, n2);
    }

    protected int matchedArgument(Clazz clazz, int n) {
        if (n == 0x20000000) {
            return clazz.getStringString(this.instructionSequenceMatcher.matchedArgument(0x40000003)).length();
        }
        return this.instructionSequenceMatcher.matchedArgument(n);
    }

    protected int matchedConstantIndex(ProgramClass programClass, int n) {
        if (n >= 0x20000001 && n <= 0x20000077) {
            return new ConstantPoolEditor(programClass).addStringConstant(this.argumentAsString(programClass, n & 0xF, 0x40000003) + this.argumentAsString(programClass, n >>> 4 & 0xF, 0x40000004), null, null);
        }
        int n2 = this.instructionSequenceMatcher.matchedConstantIndex(n);
        if (n2 > 0) {
            return n2;
        }
        ProgramClass programClass2 = new ProgramClass();
        programClass2.constantPool = this.patternConstants;
        return new ConstantAdder(programClass).addConstant((Clazz)programClass2, n);
    }

    protected int matchedBranchOffset(int n, int n2) {
        if (InstructionSequenceReplacer.isLabel(n2)) {
            return this.uniqueLabel(n2);
        }
        return this.instructionSequenceMatcher.matchedBranchOffset(n, n2);
    }

    protected int[] matchedJumpOffsets(int n, int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            if (!InstructionSequenceReplacer.isLabel(nArray[i])) continue;
            nArray[i] = this.uniqueLabel(nArray[i]);
        }
        return this.instructionSequenceMatcher.matchedJumpOffsets(n, nArray);
    }

    private String argumentAsString(ProgramClass programClass, int n, int n2) {
        switch (n) {
            case 1: {
                return Boolean.toString((this.wasConstant(n2) ? ((IntegerConstant)this.matchedConstant(programClass, n2)).getValue() : this.matchedArgument(n2)) != 0);
            }
            case 2: {
                return Character.toString((char)(this.wasConstant(n2) ? ((IntegerConstant)this.matchedConstant(programClass, n2)).getValue() : this.matchedArgument(n2)));
            }
            case 3: {
                return Integer.toString(this.wasConstant(n2) ? ((IntegerConstant)this.matchedConstant(programClass, n2)).getValue() : this.matchedArgument(n2));
            }
            case 4: {
                return Long.toString(this.wasConstant(n2) ? ((LongConstant)this.matchedConstant(programClass, n2)).getValue() : (long)this.matchedArgument(n2));
            }
            case 5: {
                return Float.toString(this.wasConstant(n2) ? ((FloatConstant)this.matchedConstant(programClass, n2)).getValue() : (float)this.matchedArgument(n2));
            }
            case 6: {
                return Double.toString(this.wasConstant(n2) ? ((DoubleConstant)this.matchedConstant(programClass, n2)).getValue() : (double)this.matchedArgument(n2));
            }
            case 7: {
                return programClass.getStringString(this.instructionSequenceMatcher.matchedConstantIndex(n2));
            }
        }
        return "";
    }

    protected InstructionSequenceMatcher getInstructionSequenceMatcher() {
        return this.instructionSequenceMatcher;
    }

    protected boolean wasConstant(int n) {
        return this.instructionSequenceMatcher.wasConstant(n);
    }

    protected Constant matchedConstant(ProgramClass programClass, int n) {
        return programClass.getConstant(this.instructionSequenceMatcher.matchedConstantIndex(n));
    }

    protected int matchedArgument(int n) {
        return this.instructionSequenceMatcher.matchedArgument(n);
    }

    private int uniqueLabel(int n) {
        return n | this.instructionSequenceMatcher.matchedInstructionOffset(0) << 8;
    }

    public static Label label() {
        return new Label(labelCounter++);
    }

    public static Label catch_(int n, int n2, int n3) {
        return new Catch(labelCounter++, n, n2, n3);
    }

    private static boolean isLabel(int n) {
        return (n & 0xFF000000) == 0x20000000;
    }

    private static class Catch
    extends Label {
        private final int startOfffset;
        private final int endOffset;
        private final int catchType;

        private Catch(int n, int n2, int n3, int n4) {
            super(n);
            this.startOfffset = n2;
            this.endOffset = n3;
            this.catchType = n4;
        }

        @Override
        public Instruction shrink() {
            return this;
        }

        @Override
        public void write(byte[] byArray, int n) {
        }

        @Override
        protected void readInfo(byte[] byArray, int n) {
            throw new UnsupportedOperationException("Can't read catch instruction");
        }

        @Override
        protected void writeInfo(byte[] byArray, int n) {
            throw new UnsupportedOperationException("Can't write catch instruction");
        }

        @Override
        public int length(int n) {
            return super.length(n);
        }

        @Override
        public void accept(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, InstructionVisitor instructionVisitor) {
            MyReplacementInstructionFactory myReplacementInstructionFactory = (MyReplacementInstructionFactory)instructionVisitor;
            myReplacementInstructionFactory.visitCatchInstruction(clazz, method, codeAttribute, n, this);
        }

        @Override
        public String toString() {
            return "catch " + (InstructionSequenceReplacer.isLabel(this.startOfffset) ? "label_" : "") + this.startOfffset + ", " + (InstructionSequenceReplacer.isLabel(this.endOffset) ? "label_" : "") + this.endOffset + ", #" + this.catchType;
        }
    }

    public static class Label
    extends Instruction {
        protected final int identifier;

        private Label(int n) {
            this.identifier = n;
        }

        public int offset() {
            return 0x20000000 | this.identifier;
        }

        @Override
        public Instruction shrink() {
            return this;
        }

        @Override
        public void write(byte[] byArray, int n) {
        }

        @Override
        protected void readInfo(byte[] byArray, int n) {
            throw new UnsupportedOperationException("Can't read label instruction");
        }

        @Override
        protected void writeInfo(byte[] byArray, int n) {
            throw new UnsupportedOperationException("Can't write label instruction");
        }

        @Override
        public int length(int n) {
            return 0;
        }

        @Override
        public void accept(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, InstructionVisitor instructionVisitor) {
            MyReplacementInstructionFactory myReplacementInstructionFactory = (MyReplacementInstructionFactory)instructionVisitor;
            myReplacementInstructionFactory.visitLabelInstruction(clazz, method, codeAttribute, n, this);
        }

        public String toString() {
            return "label_" + this.offset();
        }
    }

    private class MyReplacementInstructionFactory
    implements InstructionVisitor {
        private Instruction replacementInstruction;

        private MyReplacementInstructionFactory() {
        }

        public Instruction create(Clazz clazz, CodeAttribute codeAttribute, int n) {
            int n2 = n < InstructionSequenceReplacer.this.instructionSequenceMatcher.instructionCount() ? n : InstructionSequenceReplacer.this.instructionSequenceMatcher.instructionCount() - 1;
            int n3 = InstructionSequenceReplacer.this.instructionSequenceMatcher.matchedInstructionOffset(n2);
            InstructionSequenceReplacer.this.replacementInstructions[n].accept(clazz, null, codeAttribute, n3, this);
            return this.replacementInstruction;
        }

        @Override
        public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, SimpleInstruction simpleInstruction) {
            this.replacementInstruction = new SimpleInstruction(simpleInstruction.opcode, InstructionSequenceReplacer.this.matchedArgument(clazz, method, codeAttribute, n, simpleInstruction.constant));
        }

        @Override
        public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, VariableInstruction variableInstruction) {
            this.replacementInstruction = new VariableInstruction(variableInstruction.opcode, InstructionSequenceReplacer.this.matchedArgument(clazz, method, codeAttribute, n, variableInstruction.variableIndex), InstructionSequenceReplacer.this.instructionSequenceMatcher.matchedArgument(variableInstruction.constant));
        }

        @Override
        public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, ConstantInstruction constantInstruction) {
            this.replacementInstruction = new ConstantInstruction(constantInstruction.opcode, InstructionSequenceReplacer.this.matchedConstantIndex((ProgramClass)clazz, constantInstruction.constantIndex), InstructionSequenceReplacer.this.instructionSequenceMatcher.matchedArgument(constantInstruction.constant));
        }

        @Override
        public void visitBranchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, BranchInstruction branchInstruction) {
            this.replacementInstruction = new BranchInstruction(branchInstruction.opcode, InstructionSequenceReplacer.this.matchedBranchOffset(n, branchInstruction.branchOffset));
        }

        @Override
        public void visitTableSwitchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, TableSwitchInstruction tableSwitchInstruction) {
            this.replacementInstruction = new TableSwitchInstruction(tableSwitchInstruction.opcode, InstructionSequenceReplacer.this.matchedBranchOffset(n, tableSwitchInstruction.defaultOffset), InstructionSequenceReplacer.this.instructionSequenceMatcher.matchedArgument(tableSwitchInstruction.lowCase), InstructionSequenceReplacer.this.instructionSequenceMatcher.matchedArgument(tableSwitchInstruction.highCase), InstructionSequenceReplacer.this.matchedJumpOffsets(n, tableSwitchInstruction.jumpOffsets));
        }

        @Override
        public void visitLookUpSwitchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, LookUpSwitchInstruction lookUpSwitchInstruction) {
            this.replacementInstruction = new LookUpSwitchInstruction(lookUpSwitchInstruction.opcode, InstructionSequenceReplacer.this.matchedBranchOffset(n, lookUpSwitchInstruction.defaultOffset), InstructionSequenceReplacer.this.instructionSequenceMatcher.matchedArguments(lookUpSwitchInstruction.cases), InstructionSequenceReplacer.this.matchedJumpOffsets(n, lookUpSwitchInstruction.jumpOffsets));
        }

        public void visitLabelInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Label label) {
            this.replacementInstruction = InstructionSequenceReplacer.this.codeAttributeEditor.label(InstructionSequenceReplacer.this.uniqueLabel(label.identifier));
        }

        public void visitCatchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Catch catch_) {
            this.replacementInstruction = InstructionSequenceReplacer.this.codeAttributeEditor.catch_(InstructionSequenceReplacer.this.uniqueLabel(catch_.identifier), InstructionSequenceReplacer.this.uniqueLabel(catch_.startOfffset), InstructionSequenceReplacer.this.uniqueLabel(catch_.endOffset), InstructionSequenceReplacer.this.matchedConstantIndex((ProgramClass)clazz, catch_.catchType));
        }
    }
}

