/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.babelfish;

import java.io.File;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import oracle.jdbc.babelfish.TranslationCache;
import oracle.jdbc.babelfish.Translator;
import oracle.jdbc.driver.DatabaseError;

public class TranslationManager {
    private static final ConcurrentHashMap<String, TranslationCache> translationCacheRegistry = new ConcurrentHashMap();
    private static Map<String, String> defaultErrorFile = new ConcurrentHashMap<String, String>();
    private static final String SEPARATOR = "\u0000";
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
    public static final boolean TRACE = false;

    public static Translator getTranslator(String string, String string2, String string3, String string4) throws SQLException {
        if (string4 == null && defaultErrorFile.containsKey(string3)) {
            string4 = defaultErrorFile.get(string3);
        }
        File file = null;
        if (string4 != null && !(file = new File(string4)).exists()) {
            SQLException sQLException = DatabaseError.createSqlException(null, 277);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        assert (!(".*\u0000.*".matches(string) || ".*\u0000.*".matches(string2) || ".*\u0000.*".matches(string3)));
        String string5 = string + SEPARATOR + string2 + SEPARATOR + string3;
        TranslationCache translationCache = translationCacheRegistry.get(string5);
        if (translationCache == null) {
            translationCache = new TranslationCache(file);
            translationCacheRegistry.putIfAbsent(string5, translationCache);
        }
        Translator translator = new Translator(string3, file, translationCache);
        return translator;
    }
}

