/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.xml;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;

public class XmlDeclStream
extends FilterInputStream {
    private static final int CR = 13;
    private static final int LF = 10;
    private StringBuffer declBuf = null;
    private StringBuffer refBuf;
    private boolean seenChars = false;
    private String _version;
    private String _encoding;
    private String _standalone;
    private List _charRefs = new LinkedList();
    protected boolean _lineEndCR = false;
    protected boolean _lineEndLF = false;
    protected boolean _lineEndCRLF = false;
    protected int _prevChar = 0;

    public XmlDeclStream(InputStream inputStream) {
        super(inputStream);
    }

    @Override
    public int read() throws IOException {
        int n = super.read();
        if (n > 0) {
            this.process(n);
        }
        return n;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        int n = super.read(byArray);
        for (int i = 0; i < n; ++i) {
            this.process(byArray[i]);
        }
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = super.read(byArray, n, n2);
        for (int i = n; i < n + n3; ++i) {
            this.process(byArray[i]);
        }
        return n3;
    }

    public List getCharacterReferences() {
        return this._charRefs;
    }

    public String getVersion() {
        return this._version;
    }

    public String getEncoding() {
        return this._encoding;
    }

    public String getStandalone() {
        return this._standalone;
    }

    private void process(int n) {
        this.checkLineEnd(n);
        this._prevChar = n;
        if (!this.seenChars || this.declBuf != null) {
            if (this.declBuf == null && n == 60) {
                this.declBuf = new StringBuffer("<");
            } else if (this.declBuf != null) {
                this.declBuf.append((char)n);
                if ((char)n == '>') {
                    this.processDecl();
                    this.declBuf = null;
                }
            }
        }
        if (this.refBuf == null && n == 38) {
            this.refBuf = new StringBuffer("&");
        } else if (this.refBuf != null) {
            if (this.refBuf.length() == 1 && n != 35) {
                this.refBuf = null;
            } else if (n == 59) {
                this.processRef();
                this.refBuf = null;
            } else {
                this.refBuf.append((char)n);
            }
        }
        this.seenChars = true;
    }

    private void processDecl() {
        String string = this.declBuf.toString();
        if (!string.startsWith("<?xml") || !string.endsWith("?>")) {
            this.declBuf = null;
        } else {
            int n = 0;
            int n2 = string.indexOf("version");
            if (n2 > 0) {
                this._version = this.extractParam(string, n2);
                n = n2;
            }
            if ((n2 = string.indexOf("encoding", n)) > 0) {
                this._encoding = this.extractParam(string, n2);
                n = n2;
            }
            if ((n2 = string.indexOf("standalone", n)) > 0) {
                this._standalone = this.extractParam(string, n2);
            }
        }
    }

    private void processRef() {
        boolean bl = this.refBuf.charAt(2) == 'x';
        int n = 0;
        StringBuffer stringBuffer = this.refBuf;
        this.refBuf = null;
        if (bl) {
            for (int i = 3; i < stringBuffer.length(); ++i) {
                char c = Character.toUpperCase(stringBuffer.charAt(i));
                if (c >= 'A' && c <= 'F') {
                    n = 16 * n + (c - 65 + 10);
                    continue;
                }
                if (c >= '0' && c <= '9') {
                    n = 16 * n + (c - 48);
                    continue;
                }
                return;
            }
        } else {
            for (int i = 2; i < stringBuffer.length(); ++i) {
                char c = stringBuffer.charAt(i);
                if (c < '0' || c > '9') {
                    return;
                }
                n = 10 * n + (c - 48);
            }
        }
        this._charRefs.add(new Integer(n));
    }

    private String extractParam(String string, int n) {
        int n2 = string.indexOf(61, n);
        if (n2 == -1) {
            return null;
        }
        boolean bl = false;
        boolean bl2 = false;
        int n3 = -1;
        for (int i = n2 + 1; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isWhitespace(c)) {
                if (n3 < 0 || bl || bl2) continue;
                return string.substring(n3, i + 1);
            }
            if (c == '\'' && !bl2) {
                if (!bl) {
                    bl = true;
                    n3 = i + 1;
                    continue;
                }
                return string.substring(n3, i);
            }
            if (c == '\"' && !bl) {
                if (!bl2) {
                    bl2 = true;
                    n3 = i + 1;
                    continue;
                }
                return string.substring(n3, i);
            }
            if (n3 >= 0) continue;
            n3 = i;
        }
        return null;
    }

    protected void checkLineEnd(int n) {
        if (n == 10) {
            if (this._prevChar == 13) {
                this._lineEndCRLF = true;
            } else {
                this._lineEndLF = true;
            }
        } else if (this._prevChar == 13) {
            this._lineEndCR = true;
        }
    }

    public String getKindOfLineEnd() {
        if (this._lineEndCR || this._lineEndLF || this._lineEndCRLF) {
            if (this._lineEndCRLF) {
                return "CRLF";
            }
            if (this._lineEndCR) {
                return "CR";
            }
            if (this._lineEndLF) {
                return "LF";
            }
        }
        return null;
    }
}

