/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.module.jpeg2000.BoxHolder;
import edu.harvard.hul.ois.jhove.module.jpeg2000.CompositionBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2Box;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;

public class InstructionSetBox
extends JP2Box {
    public InstructionSetBox(RandomAccessFile randomAccessFile, BoxHolder boxHolder) {
        super(randomAccessFile, boxHolder);
    }

    @Override
    public boolean readBox() throws IOException {
        if (!(this._parentBox instanceof CompositionBox)) {
            this.wrongBoxContext();
            return false;
        }
        this.initBytesRead();
        int n = this._module.readUnsignedShort(this._dstrm);
        boolean bl = (n & 1) != 0;
        boolean bl2 = (n & 2) != 0;
        boolean bl3 = (n & 8) != 0;
        boolean bl4 = (n & 0x20) != 0;
        int n2 = this._module.readUnsignedShort(this._dstrm);
        long l = this._module.readUnsignedInt(this._dstrm);
        int n3 = (int)this._boxHeader.getDataLength() - 8;
        if ((n & 0x2B) == 0) {
            if (n3 != 0) {
                this._repInfo.setMessage(new ErrorMessage("Data underrun in Instruction Set Box", this._module.getFilePos()));
                this._repInfo.setWellFormed(false);
                return false;
            }
        } else {
            ArrayList<Property> arrayList = new ArrayList<Property>(11);
            while (n3 >= 0) {
                long l2;
                long l3;
                if (bl) {
                    l3 = this._module.readUnsignedInt(this._dstrm);
                    arrayList.add(new Property("HorizontalOffset", PropertyType.LONG, new Long(l3)));
                    l2 = this._module.readUnsignedInt(this._dstrm);
                    arrayList.add(new Property("VerticalOffset", PropertyType.LONG, new Long(l2)));
                    n3 -= 8;
                }
                if (bl2) {
                    l3 = this._module.readUnsignedInt(this._dstrm);
                    arrayList.add(new Property("Width", PropertyType.LONG, new Long(l3)));
                    l2 = this._module.readUnsignedInt(this._dstrm);
                    arrayList.add(new Property("Height", PropertyType.LONG, new Long(l2)));
                    n3 -= 8;
                }
                if (bl3) {
                    l3 = this._module.readUnsignedInt(this._dstrm);
                    boolean bl5 = (l3 & Integer.MIN_VALUE) != 0L;
                    arrayList.add(new Property("Persist", PropertyType.BOOLEAN, new Boolean(bl5)));
                    arrayList.add(new Property("Life", PropertyType.LONG, new Long(l3 &= Integer.MAX_VALUE)));
                    long l4 = this._module.readUnsignedInt(this._dstrm);
                    arrayList.add(new Property("NextUse", PropertyType.LONG, new Long(l4)));
                    n3 -= 8;
                }
                if (bl4) {
                    l3 = this._module.readUnsignedInt(this._dstrm);
                    arrayList.add(new Property("HorizontalCropOffset", PropertyType.LONG, new Long(l3)));
                    long l5 = this._module.readUnsignedInt(this._dstrm);
                    arrayList.add(new Property("VerticalCropOffset", PropertyType.LONG, new Long(l5)));
                    long l6 = this._module.readUnsignedInt(this._dstrm);
                    arrayList.add(new Property("CroppedWidth", PropertyType.LONG, new Long(l6)));
                    long l7 = this._module.readUnsignedInt(this._dstrm);
                    arrayList.add(new Property("CroppedHeight", PropertyType.LONG, new Long(l7)));
                    n3 -= 16;
                }
                if (n3 >= 0) continue;
                this._repInfo.setMessage(new ErrorMessage("Data overrun in Instruction Set Box", this._module.getFilePos()));
                this._repInfo.setWellFormed(false);
                return false;
            }
        }
        this.finalizeBytesRead();
        return true;
    }
}

