#!/bin/ksh ~/.mgltools/pythonsh
########################################################################
#
#    Vision Network - Python source code - file generated by vision
#    Thursday 24 February 2011 02:04:28 
#    
#       The Scripps Research Institute (TSRI)
#       Molecular Graphics Lab
#       La Jolla, CA 92037, USA
#
# Copyright: Daniel Stoffler, Michel Sanner and TSRI
#   
# revision: Guillaume Vareille
#  
#########################################################################
#
# $Header: /opt/cvs/CADD/workflows/docking/AutoDockSL_0.1_net.py,v 1.1 2011/04/15 16:16:48 nadya Exp $
#
# $Id: AutoDockSL_0.1_net.py,v 1.1 2011/04/15 16:16:48 nadya Exp $
#


if __name__=='__main__':
    from sys import argv
    if '--help' in argv or '-h' in argv or '-w' in argv: # run without Vision
        withoutVision = True
        from Vision.VPE import NoGuiExec
        ed = NoGuiExec()
        from NetworkEditor.net import Network
        import os
        masterNet = Network("process-"+str(os.getpid()))
        ed.addNetwork(masterNet)
    else: # run as a stand alone application while vision is hidden
        withoutVision = False
        from Vision import launchVisionToRunNetworkAsApplication, mainLoopVisionToRunNetworkAsApplication
	if '-noSplash' in argv:
	    splash = False
	else:
	    splash = True
        masterNet = launchVisionToRunNetworkAsApplication(splash=splash)
        import os
        masterNet.filename = os.path.abspath(__file__)
from traceback import print_exc
## loading libraries ##
from Vision.StandardNodes import stdlib
from WebServices.VisionInterface.WSNodes import wslib
try:
    masterNet
except (NameError, AttributeError): # we run the network outside Vision
    from NetworkEditor.net import Network
    masterNet = Network()

masterNet.getEditor().addLibraryInstance(stdlib,"Vision.StandardNodes", "stdlib")

masterNet.getEditor().addLibraryInstance(wslib,"WebServices.VisionInterface.WSNodes", "wslib")

from WebServices.VisionInterface.WSNodes import addOpalServerAsCategory
try:
    addOpalServerAsCategory("http://kryptonite.nbcr.net/opal2", replace=False)
except:
    pass
try:
    ## saving node AutodockOpalService_kryptonite_nbcr_net ##
    from NetworkEditor.items import FunctionNode
    AutodockOpalService_kryptonite_nbcr_net_0 = FunctionNode(functionOrString='AutodockOpalService_kryptonite_nbcr_net', host="http://kryptonite.nbcr.net/opal2", namedArgs={'i': False, 'k': False, 'l': '', 'o': False, 'pdbq': '', 'p': '', 't': False, 'url': '', 'localRun': False, 'execPath': ''}, constrkw={'functionOrString': "'AutodockOpalService_kryptonite_nbcr_net'", 'host': '"http://kryptonite.nbcr.net/opal2"', 'namedArgs': {'i': False, 'k': False, 'l': '', 'o': False, 'pdbq': '', 'p': '', 't': False, 'url': '', 'localRun': False, 'execPath': ''}}, name='AutodockOpalService_kryptonite_nbcr_net', library=wslib)
    masterNet.addNode(AutodockOpalService_kryptonite_nbcr_net_0,173,245)
    apply(AutodockOpalService_kryptonite_nbcr_net_0.inputPortByName['l'].configure, (), {'defaultValue': None})
    apply(AutodockOpalService_kryptonite_nbcr_net_0.inputPortByName['pdbq'].configure, (), {'defaultValue': None})
    apply(AutodockOpalService_kryptonite_nbcr_net_0.inputPortByName['p'].configure, (), {'defaultValue': None})
    apply(AutodockOpalService_kryptonite_nbcr_net_0.inputPortByName['url'].configure, (), {'defaultValue': None})
    AutodockOpalService_kryptonite_nbcr_net_0.inputPortByName['i'].widget.set(0, run=False)
    AutodockOpalService_kryptonite_nbcr_net_0.inputPortByName['k'].widget.set(0, run=False)
    AutodockOpalService_kryptonite_nbcr_net_0.inputPortByName['l'].rebindWidget()
    AutodockOpalService_kryptonite_nbcr_net_0.inputPortByName['l'].widget.set(r"", run=False)
    AutodockOpalService_kryptonite_nbcr_net_0.inputPortByName['l'].unbindWidget()
    AutodockOpalService_kryptonite_nbcr_net_0.inputPortByName['o'].widget.set(0, run=False)
    AutodockOpalService_kryptonite_nbcr_net_0.inputPortByName['pdbq'].rebindWidget()
    AutodockOpalService_kryptonite_nbcr_net_0.inputPortByName['pdbq'].widget.set(r"", run=False)
    AutodockOpalService_kryptonite_nbcr_net_0.inputPortByName['pdbq'].unbindWidget()
    AutodockOpalService_kryptonite_nbcr_net_0.inputPortByName['p'].rebindWidget()
    AutodockOpalService_kryptonite_nbcr_net_0.inputPortByName['p'].widget.set(r"", run=False)
    AutodockOpalService_kryptonite_nbcr_net_0.inputPortByName['p'].unbindWidget()
    AutodockOpalService_kryptonite_nbcr_net_0.inputPortByName['t'].widget.set(0, run=False)
    AutodockOpalService_kryptonite_nbcr_net_0.inputPortByName['url'].rebindWidget()
    AutodockOpalService_kryptonite_nbcr_net_0.inputPortByName['url'].widget.set(r"", run=False)
    AutodockOpalService_kryptonite_nbcr_net_0.inputPortByName['url'].unbindWidget()
    AutodockOpalService_kryptonite_nbcr_net_0.inputPortByName['localRun'].widget.set(0, run=False)
    AutodockOpalService_kryptonite_nbcr_net_0.inputPortByName['execPath'].widget.set(r"", run=False)
    apply(AutodockOpalService_kryptonite_nbcr_net_0.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
except:
    print "WARNING: failed to restore FunctionNode named AutodockOpalService_kryptonite_nbcr_net in network masterNet"
    print_exc()
    AutodockOpalService_kryptonite_nbcr_net_0=None

try:
    ## saving node Ligand File Browser ##
    from Vision.StandardNodes import FileBrowserNE
    Ligand_File_Browser_1 = FileBrowserNE(constrkw={}, name='Ligand File Browser', library=stdlib)
    masterNet.addNode(Ligand_File_Browser_1,191,22)
    Ligand_File_Browser_1.inputPortByName['filename'].widget.set(r"AutoDockSL_0.1_input/diversity0001.pdbqt", run=False)
    apply(Ligand_File_Browser_1.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore FileBrowserNE named Ligand File Browser in network masterNet"
    print_exc()
    Ligand_File_Browser_1=None

try:
    ## saving node DLG output name ##
    from Vision.StandardNodes import EntryNE
    DLG_output_name_2 = EntryNE(constrkw={}, name='DLG output name', library=stdlib)
    masterNet.addNode(DLG_output_name_2,11,25)
    DLG_output_name_2.inputPortByName['entry'].widget.set(r"out.dlg", run=False)
    apply(DLG_output_name_2.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore EntryNE named DLG output name in network masterNet"
    print_exc()
    DLG_output_name_2=None

try:
    ## saving node DPF File Browser ##
    from Vision.StandardNodes import FileBrowserNE
    DPF_File_Browser_3 = FileBrowserNE(constrkw={}, name='DPF File Browser', library=stdlib)
    masterNet.addNode(DPF_File_Browser_3,532,23)
    DPF_File_Browser_3.inputPortByName['filename'].widget.set(r"AutoDockSL_0.1_input/diversity0001.dpf", run=False)
    apply(DPF_File_Browser_3.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore FileBrowserNE named DPF File Browser in network masterNet"
    print_exc()
    DPF_File_Browser_3=None

try:
    ## saving node URL to Autogrid Result ##
    from Vision.StandardNodes import EntryNE
    URL_to_Autogrid_Result_4 = EntryNE(constrkw={}, name='URL to Autogrid Result', library=stdlib)
    masterNet.addNode(URL_to_Autogrid_Result_4,868,24)
    URL_to_Autogrid_Result_4.inputPortByName['entry'].widget.set(r"http://kryptonite.nbcr.net/appautogrid12974626948721880795374", run=False)
    apply(URL_to_Autogrid_Result_4.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore EntryNE named URL to Autogrid Result in network masterNet"
    print_exc()
    URL_to_Autogrid_Result_4=None

try:
    ## saving node DownloadSaveDir ##
    from WebServices.VisionInterface.WSNodes import DownloadSaveDirNode
    DownloadSaveDir_5 = DownloadSaveDirNode(constrkw={}, name='DownloadSaveDir', library=wslib)
    masterNet.addNode(DownloadSaveDir_5,283,416)
    apply(DownloadSaveDir_5.inputPortByName['url'].configure, (), {'defaultValue': None})
    DownloadSaveDir_5.inputPortByName['url'].rebindWidget()
    DownloadSaveDir_5.inputPortByName['url'].widget.set(r"", run=False)
    DownloadSaveDir_5.inputPortByName['url'].unbindWidget()
    apply(DownloadSaveDir_5.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore DownloadSaveDirNode named DownloadSaveDir in network masterNet"
    print_exc()
    DownloadSaveDir_5=None

try:
    ## saving node Output Directory Browser ##
    from Vision.StandardNodes import DirBrowserNE
    Output_Directory_Browser_6 = DirBrowserNE(constrkw={}, name='Output Directory Browser', library=stdlib)
    masterNet.addNode(Output_Directory_Browser_6,456,245)
    Output_Directory_Browser_6.inputPortByName['directory'].widget.set(r"AutoDockSL_0.1_output", run=False)
    apply(Output_Directory_Browser_6.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore DirBrowserNE named Output Directory Browser in network masterNet"
    print_exc()
    Output_Directory_Browser_6=None

try:
    ## saving node GetMainURLFromList ##
    from WebServices.VisionInterface.WSNodes import GetMainURLFromListNode
    GetMainURLFromList_7 = GetMainURLFromListNode(constrkw={}, name='GetMainURLFromList', library=wslib)
    masterNet.addNode(GetMainURLFromList_7,173,308)
    apply(GetMainURLFromList_7.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
except:
    print "WARNING: failed to restore GetMainURLFromListNode named GetMainURLFromList in network masterNet"
    print_exc()
    GetMainURLFromList_7=None

#masterNet.run()
masterNet.freeze()

## saving connections for network AutoDockSL-0.1 ##
if Ligand_File_Browser_1 is not None and AutodockOpalService_kryptonite_nbcr_net_0 is not None:
    try:
        masterNet.connectNodes(
            Ligand_File_Browser_1, AutodockOpalService_kryptonite_nbcr_net_0, "filename", "pdbq", blocking=True
            , splitratio=[0.71138355030400446, 0.62231101649397191])
    except:
        print "WARNING: failed to restore connection between Ligand_File_Browser_1 and AutodockOpalService_kryptonite_nbcr_net_0 in network masterNet"
if DLG_output_name_2 is not None and AutodockOpalService_kryptonite_nbcr_net_0 is not None:
    try:
        masterNet.connectNodes(
            DLG_output_name_2, AutodockOpalService_kryptonite_nbcr_net_0, "string", "l", blocking=True
            , splitratio=[0.4369858136075192, 0.37322550913177743])
    except:
        print "WARNING: failed to restore connection between DLG_output_name_2 and AutodockOpalService_kryptonite_nbcr_net_0 in network masterNet"
if DPF_File_Browser_3 is not None and AutodockOpalService_kryptonite_nbcr_net_0 is not None:
    try:
        masterNet.connectNodes(
            DPF_File_Browser_3, AutodockOpalService_kryptonite_nbcr_net_0, "filename", "p", blocking=True
            , splitratio=[0.54730399618861592, 0.52567146449693436])
    except:
        print "WARNING: failed to restore connection between DPF_File_Browser_3 and AutodockOpalService_kryptonite_nbcr_net_0 in network masterNet"
if URL_to_Autogrid_Result_4 is not None and AutodockOpalService_kryptonite_nbcr_net_0 is not None:
    try:
        masterNet.connectNodes(
            URL_to_Autogrid_Result_4, AutodockOpalService_kryptonite_nbcr_net_0, "string", "url", blocking=True
            , splitratio=[0.62246659074928434, 0.68063227147486771])
    except:
        print "WARNING: failed to restore connection between URL_to_Autogrid_Result_4 and AutodockOpalService_kryptonite_nbcr_net_0 in network masterNet"
if Output_Directory_Browser_6 is not None and DownloadSaveDir_5 is not None:
    try:
        masterNet.connectNodes(
            Output_Directory_Browser_6, DownloadSaveDir_5, "directory", "path", blocking=True
            , splitratio=[0.28058019228598285, 0.56425219059753229])
    except:
        print "WARNING: failed to restore connection between Output_Directory_Browser_6 and DownloadSaveDir_5 in network masterNet"
if AutodockOpalService_kryptonite_nbcr_net_0 is not None and GetMainURLFromList_7 is not None:
    try:
        masterNet.connectNodes(
            AutodockOpalService_kryptonite_nbcr_net_0, GetMainURLFromList_7, "result", "urls", blocking=True
            , splitratio=[0.21313197200223491, 0.72817109908351818])
    except:
        print "WARNING: failed to restore connection between AutodockOpalService_kryptonite_nbcr_net_0 and GetMainURLFromList_7 in network masterNet"
if GetMainURLFromList_7 is not None and DownloadSaveDir_5 is not None:
    try:
        masterNet.connectNodes(
            GetMainURLFromList_7, DownloadSaveDir_5, "newurl", "url", blocking=True
            , splitratio=[0.29872300291532017, 0.45388702427477351])
    except:
        print "WARNING: failed to restore connection between GetMainURLFromList_7 and DownloadSaveDir_5 in network masterNet"
masterNet.runOnNewData.value = True

if __name__=='__main__':
    from sys import argv
    lNodePortValues = []
    if (len(argv) > 1) and argv[1].startswith('-'):
        lArgIndex = 2
    else:
        lArgIndex = 1
    while lArgIndex < len(argv) and argv[lArgIndex][-3:]!='.py':
        lNodePortValues.append(argv[lArgIndex])
        lArgIndex += 1
    masterNet.setNodePortValues(lNodePortValues)
    if '--help' in argv or '-h' in argv: # show help
        masterNet.helpForNetworkAsApplication()
    elif '-w' in argv: # run without Vision and exit
         # create communicator
        from NetworkEditor.net import Communicator
        masterNet.communicator = Communicator(masterNet)
        print 'Communicator listening on port:', masterNet.communicator.port

        import socket
        f = open(argv[0]+'.sock', 'w')
        f.write("%s %i"%(socket.gethostbyname(socket.gethostname()),
                         masterNet.communicator.port))
        f.close()

        masterNet.run()

    else: # stand alone application while vision is hidden
        if '-e' in argv: # run and exit
            masterNet.run()
        elif '-r' in argv or len(masterNet.userPanels) == 0: # no user panel => run
            masterNet.run()
            mainLoopVisionToRunNetworkAsApplication(masterNet.editor)
        else: # user panel
            mainLoopVisionToRunNetworkAsApplication(masterNet.editor)

