## Automatically adapted for numpy.oldnumeric Jul 23, 2007 by 

import numpy.oldnumeric as Numeric

arrInt = Numeric.ones( (5,5,5), 'i')
arrFloat = Numeric.ones( (5,5,5), 'i')
arrValues = Numeric.arange(125)
arrValues.shape = (5,5,5)

from Volume.Operators.MapData import MapGridData
mapper = MapGridData()

def test_mapIntToFloat():
    result = mapper(arrInt, datatype=Numeric.Float32)
    assert result.dtype.char==Numeric.Float32
    assert result.shape==(5,5,5)

def test_mapFloatToInt():
    result = mapper(arrFloat, datatype=Numeric.Int32)
    assert result.dtype.char==Numeric.Int32
    assert result.shape==(5,5,5)
    
def test_mapPowerOf2():
    result = mapper(arrValues, powerOf2=True)
    #assert result.dtype.char==arrFloat.dtype.char
    assert result.shape==(8,8,8)

def test_fromlist():
    arrlist = arrFloat.tolist()
    result = mapper(arrInt, datatype=Numeric.Float32)
    assert result.dtype.char==Numeric.Float32
    assert result.shape==(5,5,5)
    
def test_mapping1():
    datamap = {}
    datamap['src_min'] = None
    datamap['src_max'] = None
    datamap['dst_min'] = 0
    datamap['dst_max'] = 248
    datamap['map_type'] = 'linear'
    result = mapper(arrValues, datamap=datamap)
    assert result.dtype.char==arrValues.dtype.char
    assert Numeric.maximum.reduce(result.ravel())==248
    assert Numeric.minimum.reduce(result.ravel())==0

def test_mapping2():
    datamap = {}
    datamap['src_min'] = 50
    datamap['src_max'] = 100
    datamap['dst_min'] = 0
    datamap['dst_max'] = 248
    datamap['map_type'] = 'linear'
    result = mapper(arrValues, datamap=datamap)
    assert result.dtype.char==arrValues.dtype.char
    assert Numeric.maximum.reduce(result.ravel())==248
    assert Numeric.minimum.reduce(result.ravel())==0
    assert result[2,0,0] == 0 and arrValues[2,0,0]==50
    assert Numeric.minimum.reduce(result[:2,0,0]) == 0
    assert Numeric.maximum.reduce(result[:2,0,0]) == 0
    assert Numeric.maximum.reduce(result[4:,0,0]) == 248
    assert Numeric.minimum.reduce(result[4:,0,0]) == 248


def test_mapAndConvert():
    datamap = {}
    datamap['src_min'] = 50
    datamap['src_max'] = 100
    datamap['dst_min'] = 0
    datamap['dst_max'] = 248
    datamap['map_type'] = 'linear'
    result = mapper(arrValues, datamap=datamap, datatype=Numeric.Float32)
    assert result.dtype.char==Numeric.Float32
    assert Numeric.maximum.reduce(result.ravel())==248.
    assert Numeric.minimum.reduce(result.ravel())==0.
    assert result[2,0,0] == 0 and arrValues[2,0,0] == 50.
    assert Numeric.minimum.reduce(result[:2,0,0]) == 0.
    assert Numeric.maximum.reduce(result[:2,0,0]) == 0.
    assert Numeric.maximum.reduce(result[4:,0,0]) == 248.
    assert Numeric.minimum.reduce(result[4:,0,0]) == 248.

