/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.build.ui;

import com.nvidia.common.util.CoreUtil;
import com.nvidia.cuda.ide.build.core.Architecture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.PlatformUI;

public abstract class SourceEditingArchitectureFieldEditor {
    private final Combo sourceEditingTarget;
    private final AtomicBoolean updatingCombo = new AtomicBoolean(false);

    private static Control setHelp(Control control) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp(control, "com.nvidia.cuda.ide.build.editor-compute-capability");
        return control;
    }

    public SourceEditingArchitectureFieldEditor(Composite usercomp) {
        Label label = new Label(usercomp, 0);
        label.setText("Source editor compute capability:");
        SourceEditingArchitectureFieldEditor.setHelp((Control)label);
        this.sourceEditingTarget = new Combo(usercomp, 8);
        SourceEditingArchitectureFieldEditor.setHelp((Control)this.sourceEditingTarget);
        this.sourceEditingTarget.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String string = SourceEditingArchitectureFieldEditor.this.sourceEditingTarget.getText();
                Architecture[] architectures = Architecture.all();
                int i = 0;
                while (i < architectures.length) {
                    Architecture arch = architectures[i];
                    if (arch.getLabel().equals(string)) {
                        SourceEditingArchitectureFieldEditor.this.setArchitecture(arch);
                    }
                    ++i;
                }
            }
        });
    }

    public void checkSourceTargets() {
        Collection<String> architectures = SourceEditingArchitectureFieldEditor.toLabels(this.getAvailableArchitectures());
        if (!architectures.contains(this.sourceEditingTarget.getText())) {
            this.resetArchToDefault();
        } else {
            this.updateSourceTarget();
        }
    }

    protected abstract Architecture getArchitecture();

    protected abstract int getAvailableArchitectures();

    private void resetArchToDefault() {
        int architectures = CoreUtil.getLowestSetBit((int)this.getAvailableArchitectures());
        this.setArchitecture(architectures == 0 ? null : Architecture.decode(architectures)[0]);
        this.updateSourceTarget();
    }

    protected abstract void setArchitecture(Architecture var1);

    private static Collection<String> toLabels(int availableArchitectures) {
        ArrayList<String> labels = new ArrayList<String>();
        Architecture[] architectureArray = Architecture.decode(availableArchitectures);
        int n = architectureArray.length;
        int n2 = 0;
        while (n2 < n) {
            Architecture architecture = architectureArray[n2];
            labels.add(architecture.getLabel());
            ++n2;
        }
        return labels;
    }

    public void updateSourceTarget() {
        Collection<String> values = SourceEditingArchitectureFieldEditor.toLabels(this.getAvailableArchitectures());
        if (values.isEmpty()) {
            values = Collections.singletonList(Architecture.all()[0].getLabel());
        }
        boolean isRecursionTop = false;
        try {
            boolean isChecked;
            isRecursionTop = this.updatingCombo.compareAndSet(false, true);
            this.sourceEditingTarget.setItems(values.toArray(new String[values.size()]));
            this.sourceEditingTarget.getParent().layout(true);
            Architecture editorArch = this.getArchitecture();
            boolean bl = isChecked = editorArch != null && values.contains(editorArch.getLabel());
            if (!isChecked) {
                if (isRecursionTop) {
                    this.resetArchToDefault();
                }
            } else {
                String currentText = editorArch.getLabel();
                this.sourceEditingTarget.setText(currentText);
            }
            this.sourceEditingTarget.getParent().layout();
        }
        finally {
            if (isRecursionTop) {
                this.updatingCombo.set(false);
            }
        }
    }
}

