/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.remote.internal.commands;

import com.nvidia.common.util.CoreUtil;
import com.nvidia.common.util.SWTUtil;
import com.nvidia.cuda.ide.remote.internal.ui.build.BuildConfigurationsMenuBuilder;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ptp.rdt.sync.core.SyncConfig;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate2;
import org.eclipse.ui.statushandlers.StatusManager;

public final class SelectBuildConfigMenu
implements IMenuCreator,
IObjectActionDelegate,
IWorkbenchWindowPulldownDelegate2 {
    private final Collection<IContributionItem> items = new LinkedList<IContributionItem>();
    private Menu menu;
    private IProject project;
    private IWorkbenchPart targetPart;
    private IWorkbenchWindow window;

    public void dispose() {
        for (IContributionItem item : this.items) {
            item.dispose();
        }
        this.items.clear();
        this.menu = (Menu)SWTUtil.safeDispose((Widget)this.menu);
    }

    private void fillMenu(Menu menu) {
        IAction[] actions;
        IAction[] iActionArray = actions = new BuildConfigurationsMenuBuilder(){

            @Override
            protected IAction createMenuItem(String label, SyncConfig target, String configuration) {
                return new SetBuildConfigAction(label, SelectBuildConfigMenu.this.project, target, configuration);
            }
        }.buildMenu(this.project);
        int n = actions.length;
        int n2 = 0;
        while (n2 < n) {
            IAction action = iActionArray[n2];
            ActionContributionItem item = new ActionContributionItem(action);
            this.items.add((IContributionItem)item);
            item.fill(menu, -1);
            ++n2;
        }
    }

    public Menu getMenu(Control parent) {
        throw new UnsupportedOperationException();
    }

    public Menu getMenu(Menu parent) {
        if (SWTUtil.isDisposed((Widget)this.menu)) {
            this.menu = new Menu(parent);
            this.menu.addMenuListener(new MenuListener(){

                public void menuHidden(MenuEvent e) {
                }

                public void menuShown(MenuEvent e) {
                    SelectBuildConfigMenu.this.refreshMenu(SelectBuildConfigMenu.this.menu);
                }
            });
        }
        return this.menu;
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    private void refreshMenu(Menu menu) {
        if (!SWTUtil.isDisposed((Widget)menu)) {
            for (IContributionItem item : this.items) {
                item.dispose();
            }
            this.items.clear();
            MenuItem[] menuItemArray = menu.getItems();
            int n = menuItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                MenuItem menuItem = menuItemArray[n2];
                SWTUtil.safeDispose((Widget)menuItem);
                ++n2;
            }
            this.fillMenu(menu);
        }
    }

    public void run(IAction action) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.project = BuildConfigurationsMenuBuilder.getSelectedProject(selection, this.targetPart, this.window);
        action.setEnabled(this.project != null);
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        IWorkbenchWindow window;
        ISelection selection;
        this.targetPart = targetPart;
        if (targetPart == null) {
            selection = null;
            window = null;
        } else {
            IWorkbenchPartSite site = targetPart.getSite();
            selection = site.getSelectionProvider().getSelection();
            window = site.getWorkbenchWindow();
        }
        this.project = BuildConfigurationsMenuBuilder.getSelectedProject(selection, targetPart, window);
        action.setMenuCreator((IMenuCreator)this);
    }

    private static final class SetBuildConfigAction
    extends Action {
        private final SyncConfig config;
        private final String configurationName;
        private final IProject project;

        public SetBuildConfigAction(String label, IProject project, SyncConfig config, String configurationName) {
            super(label, 2);
            this.config = config;
            this.configurationName = configurationName;
            this.project = project;
        }

        public void run() {
            try {
                BuildConfigurationsMenuBuilder.updateCurrentBuildConfigurationAndTarget(this.project, this.config, this.configurationName);
            }
            catch (CoreException e) {
                StatusManager.getManager().handle(CoreUtil.errorStatus((Throwable)e, (String)"Unable to update project %s configuration", (Object[])new Object[]{this.project.getName()}));
            }
        }
    }
}

