/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.remote.internal.wizard;

import com.nvidia.common.util.DataBindingUtil;
import com.nvidia.common.wizards.WizardContext;
import com.nvidia.cuda.ide.remote.internal.wizard.IDebugWizardProperties;
import com.nvidia.cuda.ide.remote.ui.launch.LaunchMode;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.DecoratingObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public final class LaunchConfigurationPage
extends WizardPage
implements IWizardPage {
    private final WizardContext wizardContext;
    private Text text;
    private Button btnStartDebugger;
    private Button btnEditLaunchConfiguration;
    private final boolean immediate;

    public LaunchConfigurationPage(WizardContext wizardContext, boolean immediate) {
        super("Launch Configuration Settings", "Launch Configuration Settings", null);
        this.wizardContext = wizardContext;
        this.setDescription("Set launch configuration name and other attributes");
        this.immediate = immediate;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.setControl((Control)composite);
        composite.setLayout((Layout)new GridLayout(2, false));
        Label lblLaunchConfigurationName = new Label(composite, 0);
        lblLaunchConfigurationName.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblLaunchConfigurationName.setText("Launch configuration name:");
        this.text = new Text(composite, 2048);
        this.text.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        if (!this.immediate) {
            new Label(composite, 0);
            new Label(composite, 0);
            new Label(composite, 0);
            this.btnStartDebugger = new Button(composite, 32);
            this.btnStartDebugger.setText(this.getRunLabel());
            new Label(composite, 0);
            this.btnEditLaunchConfiguration = new Button(composite, 32);
            this.btnEditLaunchConfiguration.setText("Edit launch configuration using dialog");
        }
        this.bindValues();
    }

    private String getRunLabel() {
        LaunchMode mode = (LaunchMode)((Object)this.wizardContext.getProperty(IDebugWizardProperties.PROPERTY_LAUNCH_MODE));
        return mode.visit(new LaunchMode.Visitor<String>(){

            @Override
            public String debug() {
                return "Start debugging after wizard completion";
            }

            @Override
            public String profile() {
                return "Run the application after wizard completion";
            }

            @Override
            public String run() {
                return "Start profiling after wizard completion";
            }
        });
    }

    private void bindValues() {
        DataBindingContext ctx = new DataBindingContext(SWTObservables.getRealm((Display)this.getContainer().getShell().getDisplay()));
        IObservableValue name = this.wizardContext.observeProperty(IDebugWizardProperties.PROPERTY_LAUNCH_CONFIGURATION_NAME);
        ctx.bindValue((IObservableValue)SWTObservables.observeText((Control)this.text, (int)24), name);
        final IObservableValue start = this.wizardContext.observeProperty(IDebugWizardProperties.PROPERTY_START_IMMEDIATELY);
        final IObservableValue openDialog = this.wizardContext.observeProperty(IDebugWizardProperties.PROPERTY_OPEN_LC_DIALOG);
        if (this.btnStartDebugger != null) {
            ctx.bindValue((IObservableValue)SWTObservables.observeSelection((Control)this.btnStartDebugger), start);
        }
        ComputedValue openDialogCheck = new ComputedValue(Boolean.class){

            protected Object calculate() {
                if (!((Boolean)start.getValue()).booleanValue() && ((Boolean)openDialog.getValue()).booleanValue()) {
                    return true;
                }
                return false;
            }
        };
        if (this.btnEditLaunchConfiguration != null) {
            ISWTObservableValue sel = SWTObservables.observeSelection((Control)this.btnEditLaunchConfiguration);
            ctx.bindValue((IObservableValue)SWTObservables.observeEnabled((Control)this.btnEditLaunchConfiguration), start, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), DataBindingUtil.booleanNotBinding());
            ctx.bindValue((IObservableValue)sel, (IObservableValue)new DecoratingObservableValue(openDialog, true){

                public void setValue(Object value) {
                    if (!((Boolean)LaunchConfigurationPage.this.wizardContext.getProperty(IDebugWizardProperties.PROPERTY_START_IMMEDIATELY)).booleanValue()) {
                        super.setValue(value);
                    }
                }
            }, new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE), new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER));
            ctx.bindValue((IObservableValue)sel, (IObservableValue)openDialogCheck, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE));
        }
    }
}

