/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.memory.floatingpoint;

import java.math.BigInteger;
import org.eclipse.cdt.debug.ui.memory.floatingpoint.CopyAction;
import org.eclipse.cdt.debug.ui.memory.floatingpoint.FPDataPane;
import org.eclipse.cdt.debug.ui.memory.floatingpoint.FPRenderingMessages;
import org.eclipse.cdt.debug.ui.memory.floatingpoint.FPRenderingPlugin;
import org.eclipse.cdt.debug.ui.memory.floatingpoint.FPutilities;
import org.eclipse.cdt.debug.ui.memory.floatingpoint.Rendering;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;

public abstract class FPAbstractPane
extends Canvas {
    protected Rendering fRendering;
    protected boolean fSelectionStarted = false;
    protected boolean fSelectionInProgress = false;
    protected BigInteger fSelectionStartAddress = null;
    protected int fSelectionStartAddressSubPosition;
    protected Caret fCaret = null;
    protected int fSubCellCaretPosition = 0;
    protected int fOldSubCellCaretPosition = 0;
    protected boolean fCaretEnabled = false;
    protected BigInteger fCaretAddress = null;
    protected int fRowCount = 0;
    protected boolean fPaneVisible = true;
    private int fCellHeight = -1;
    private int fCharacterWidth = -1;
    private int fTextHeight = -1;

    public FPAbstractPane(Rendering rendering) {
        super((Composite)rendering, 0x20000000);
        this.fRendering = rendering;
        try {
            this.fCaretAddress = rendering.getBigBaseAddress();
        }
        catch (Exception exception) {}
        this.setFont(this.fRendering.getFont());
        GC gc = new GC((Drawable)this);
        gc.setFont(this.getFont());
        this.fCaret = new Caret((Canvas)this, 0);
        this.fCaret.setSize(1, gc.stringExtent((String)"|").y);
        gc.dispose();
        this.addPaintListener(this.createPaintListener());
        this.addMouseListener(this.createMouseListener());
        this.addMouseMoveListener(this.createMouseMoveListener());
        this.addKeyListener(this.createKeyListener());
        this.addFocusListener(this.createFocusListener());
    }

    protected MouseListener createMouseListener() {
        return new AbstractPaneMouseListener();
    }

    protected MouseMoveListener createMouseMoveListener() {
        return new AbstractPaneMouseMoveListener();
    }

    protected FocusListener createFocusListener() {
        return new AbstractPaneFocusListener();
    }

    protected KeyListener createKeyListener() {
        return new AbstractPaneKeyListener();
    }

    protected PaintListener createPaintListener() {
        return new AbstractPanePaintListener();
    }

    protected void handleRightArrowKey() {
        ++this.fSubCellCaretPosition;
        if (this.fSubCellCaretPosition >= this.getCellCharacterCount()) {
            this.handleCarriageReturn();
            this.fSubCellCaretPosition = 0;
            BigInteger newCaretAddress = this.fCaretAddress.add(BigInteger.valueOf(this.fRendering.getFPDataType().getByteLength()));
            if (newCaretAddress.compareTo(this.fRendering.getMemoryBlockEndAddress()) > 0) {
                this.fSubCellCaretPosition = this.getCellCharacterCount();
            } else {
                this.setCaretAddress(newCaretAddress);
            }
        }
        this.updateTheCaret();
        this.ensureCaretWithinViewport();
    }

    protected void handleLeftArrowKey() {
        --this.fSubCellCaretPosition;
        if (this.fSubCellCaretPosition < 0) {
            this.handleCarriageReturn();
            this.fSubCellCaretPosition = this.getCellCharacterCount() - 1;
            BigInteger newCaretAddress = this.fCaretAddress.subtract(BigInteger.valueOf(this.fRendering.getFPDataType().getByteLength()));
            if (newCaretAddress.compareTo(this.fRendering.getMemoryBlockStartAddress()) < 0) {
                this.fSubCellCaretPosition = 0;
            } else {
                this.setCaretAddress(newCaretAddress);
            }
        }
        this.updateTheCaret();
        this.ensureCaretWithinViewport();
    }

    protected void handleDownArrowKey() {
        this.handleCarriageReturn();
        BigInteger newCaretAddress = this.fCaretAddress.add(BigInteger.valueOf(this.fRendering.getFPDataType().getByteLength() * this.fRendering.getColumnCount()));
        this.setCaretAddress(newCaretAddress);
        this.updateTheCaret();
        this.ensureCaretWithinViewport();
    }

    protected void handleUpArrowKey() {
        this.handleCarriageReturn();
        BigInteger newCaretAddress = this.fCaretAddress.subtract(BigInteger.valueOf(this.fRendering.getFPDataType().getByteLength() * this.fRendering.getColumnCount()));
        this.setCaretAddress(newCaretAddress);
        this.updateTheCaret();
        this.ensureCaretWithinViewport();
    }

    protected void handlePageDownKey() {
        this.handleCarriageReturn();
        BigInteger newCaretAddress = this.fCaretAddress.add(BigInteger.valueOf(this.fRendering.getAddressableCellsPerRow() * (this.fRendering.getRowCount() - 1)));
        this.setCaretAddress(newCaretAddress);
        this.updateTheCaret();
        this.ensureCaretWithinViewport();
    }

    protected void handlePageUpKey() {
        this.handleCarriageReturn();
        BigInteger newCaretAddress = this.fCaretAddress.subtract(BigInteger.valueOf(this.fRendering.getAddressableCellsPerRow() * (this.fRendering.getRowCount() - 1)));
        this.setCaretAddress(newCaretAddress);
        this.updateTheCaret();
        this.ensureCaretWithinViewport();
    }

    protected void handleInsertKey() {
        if (this instanceof FPDataPane) {
            if (!this.fRendering.isEditingCell()) {
                this.fRendering.setInsertMode(!this.fRendering.insertMode());
            }
            this.fRendering.displayEditModeIndicator(true);
        } else {
            this.fRendering.displayEditModeIndicator(false);
        }
    }

    protected void handleMouseDoubleClick(MouseEvent me) {
        try {
            BigInteger address = this.getViewportAddress(me.x / this.getCellWidth(), me.y / this.getCellHeight());
            this.fRendering.getSelection().clear();
            this.fRendering.getSelection().setStart(address.add(BigInteger.valueOf(this.fRendering.getAddressesPerColumn())), address);
            this.fRendering.getSelection().setEnd(address.add(BigInteger.valueOf(this.fRendering.getAddressesPerColumn())), address);
        }
        catch (DebugException debugException) {}
    }

    protected void handleCarriageReturn() {
        if (!this.fRendering.isEditingCell() || this.fRendering.getEditBuffer() == null) {
            this.fRendering.endCellEditing();
            return;
        }
        this.fRendering.setEditBuffer(new StringBuffer(this.fRendering.getEditBuffer().toString().trim().replaceAll(" ", "")));
        if (FPutilities.isValidFormat(this.fRendering.getEditBuffer().toString())) {
            this.fRendering.convertAndUpdateCell(this.fRendering.getCellEditAddress(), this.fRendering.getEditBuffer().toString());
        } else {
            String errorText = NLS.bind((String)FPRenderingMessages.getString("FPRendering.ERROR_FPENTRY_POPUP_TEXT"), (Object)this.fRendering.getEditBuffer().toString());
            try {
                this.fRendering.setEditBuffer(new StringBuffer(this.fRendering.fDataPane.bytesToSciNotation(this.fRendering.getBytes(this.fCaretAddress, this.fRendering.getFPDataType().getByteLength()))));
            }
            catch (DebugException e) {
                e.printStackTrace();
            }
            String statusString = FPRenderingMessages.getString("FPRendering.ERROR_FPENTRY_STATUS");
            Status status = new Status(4, FPRenderingPlugin.getUniqueIdentifier(), statusString);
            FPutilities.popupMessage(FPRenderingMessages.getString("FPRendering.ERROR_FPENTRY_POPUP_TITLE"), errorText, status);
        }
        this.fRendering.endCellEditing();
    }

    protected void handleCTRLZ() {
        try {
            this.fRendering.setEditBuffer(new StringBuffer(this.fRendering.fDataPane.bytesToSciNotation(this.fRendering.getBytes(this.fCaretAddress, this.fRendering.getFPDataType().getByteLength()))));
        }
        catch (DebugException e) {
            e.printStackTrace();
        }
        this.fRendering.endCellEditing();
    }

    protected boolean isPaneVisible() {
        return this.fPaneVisible;
    }

    protected void setPaneVisible(boolean visible) {
        this.fPaneVisible = visible;
        this.setVisible(visible);
    }

    protected int getNumberOfBytesRepresentedByColumn() {
        return this.fRendering.getCharsPerColumn();
    }

    protected void editCell(BigInteger cellAddress, int subCellPosition, char character) {
    }

    protected void setCaretAddress(BigInteger caretAddress) {
        if (caretAddress.compareTo(this.fRendering.getMemoryBlockStartAddress()) >= 0 && caretAddress.compareTo(this.fRendering.getMemoryBlockEndAddress()) <= 0) {
            this.fCaretAddress = caretAddress;
        } else if (caretAddress.compareTo(this.fRendering.getMemoryBlockStartAddress()) < 0) {
            int cellOffset = this.fCaretAddress.subtract(this.fRendering.getViewportStartAddress()).intValue();
            int row = cellOffset / (this.fRendering.getBytesPerRow() / this.fRendering.getBytesPerCharacter());
            this.fCaretAddress = this.fRendering.getMemoryBlockStartAddress().add(BigInteger.valueOf((cellOffset -= row * this.fRendering.getBytesPerRow() / this.fRendering.getBytesPerCharacter()) / this.fRendering.getAddressableSize()));
        } else if (caretAddress.compareTo(this.fRendering.getMemoryBlockEndAddress()) > 0) {
            int cellOffset = this.fCaretAddress.subtract(this.fRendering.getViewportEndAddress()).intValue() + 1;
            int row = cellOffset / (this.fRendering.getBytesPerRow() / this.fRendering.getBytesPerCharacter());
            this.fCaretAddress = this.fRendering.getMemoryBlockEndAddress().add(BigInteger.valueOf((cellOffset -= row * this.fRendering.getBytesPerRow() / this.fRendering.getBytesPerCharacter()) / this.fRendering.getAddressableSize()));
        }
        this.fRendering.setCaretAddress(this.fCaretAddress);
    }

    protected boolean isOdd(int value) {
        return value / 2 * 2 == value;
    }

    protected void updateTheCaret() {
        try {
            Point cellPosition;
            if (this.fCaretAddress != null && (cellPosition = this.getCellLocation(this.fCaretAddress)) != null) {
                this.fCaret.setLocation(cellPosition.x + this.fSubCellCaretPosition * this.getCellCharacterWidth(), cellPosition.y);
            }
        }
        catch (Exception e) {
            this.fRendering.logError(FPRenderingMessages.getString("FPRendering.FAILURE_POSITION_CURSOR"), e);
        }
    }

    protected void ensureCaretWithinViewport() {
        BigInteger rowCount = BigInteger.valueOf(this.getRowCount());
        BigInteger rowMemBytes = BigInteger.valueOf(this.fRendering.getFPDataType().getByteLength() * this.fRendering.getColumnCount());
        BigInteger viewableBytes = rowCount.multiply(rowMemBytes);
        BigInteger viewableEnd = this.fRendering.getViewportStartAddress().add(viewableBytes);
        if (this.fCaretAddress.compareTo(this.fRendering.getViewportStartAddress()) < 0) {
            this.fRendering.setViewportStartAddress(this.fRendering.getViewportStartAddress().subtract(rowMemBytes));
            this.fRendering.ensureViewportAddressDisplayable();
            this.fRendering.gotoAddress(this.fRendering.getViewportStartAddress());
        } else if (this.fCaretAddress.compareTo(viewableEnd) >= 0) {
            this.fRendering.setViewportStartAddress(this.fRendering.getViewportStartAddress().add(rowMemBytes));
            this.fRendering.ensureViewportAddressDisplayable();
            this.fRendering.gotoAddress(this.fRendering.getViewportStartAddress());
        }
        this.fRendering.setCaretAddress(this.fCaretAddress);
    }

    protected void advanceCursor() {
        this.handleRightArrowKey();
    }

    protected void positionCaret(int x, int y) {
    }

    protected int getRowCount() {
        return this.fRowCount;
    }

    protected void setRowCount() {
        this.fRowCount = this.getBounds().height / this.getCellHeight();
    }

    protected void settingsChanged() {
        this.fSubCellCaretPosition = 0;
    }

    protected void startSelection(int x, int y) {
        try {
            BigInteger address = this.getViewportAddress(x / this.getCellWidth(), y / this.getCellHeight());
            if (address != null) {
                this.fSelectionStartAddress = address;
                Point cellPosition = this.getCellLocation(address);
                if (cellPosition != null) {
                    int offset = x - cellPosition.x;
                    this.fSelectionStartAddressSubPosition = offset / this.getCellCharacterWidth();
                }
                this.fRendering.getSelection().clear();
                this.fRendering.getSelection().setStart(address.add(BigInteger.valueOf(this.fRendering.getFPDataType().getByteLength())), address);
                this.fSelectionStarted = true;
                new CopyAction(this.fRendering, 2).run();
            }
        }
        catch (DebugException e) {
            this.fRendering.logError(FPRenderingMessages.getString("FPRendering.FAILURE_START_SELECTION"), (Exception)((Object)e));
        }
    }

    protected void endSelection(int x, int y) {
        this.appendSelection(x, y);
        this.fSelectionInProgress = false;
    }

    protected void appendSelection(int x, int y) {
        try {
            if (this.fSelectionStartAddress == null) {
                return;
            }
            BigInteger address = this.getViewportAddress(x / this.getCellWidth(), y / this.getCellHeight());
            if (address.compareTo(this.fSelectionStartAddress) == 0) {
                Point cellPosition = this.getCellLocation(address);
                int offset = x - cellPosition.x;
                int subCellCharacterPosition = offset / this.getCellCharacterWidth();
                if (Math.abs(subCellCharacterPosition - this.fSelectionStartAddressSubPosition) > this.getCellCharacterCount() / 4) {
                    this.fRendering.getSelection().setEnd(address.add(BigInteger.valueOf(this.fRendering.getFPDataType().getByteLength())), address);
                } else {
                    this.fRendering.getSelection().setEnd(null, null);
                }
            } else {
                this.fRendering.getSelection().setEnd(address.add(BigInteger.valueOf(this.fRendering.getFPDataType().getByteLength())), address);
            }
            if (this.fRendering.getSelection().getEnd() != null) {
                this.fCaretAddress = this.fRendering.getSelection().getEnd();
                this.fSubCellCaretPosition = 0;
            }
            this.updateTheCaret();
            new CopyAction(this.fRendering, 2).run();
        }
        catch (Exception e) {
            this.fRendering.logError(FPRenderingMessages.getString("FPRendering.FAILURE_APPEND_SELECTION"), e);
        }
    }

    protected void paint(PaintEvent pe) {
        this.fRowCount = this.getBounds().height / this.getCellHeight();
        if (this.fRendering.isDirty()) {
            this.fRendering.setDirty(false);
            this.fRendering.refresh();
        }
    }

    protected abstract BigInteger getViewportAddress(int var1, int var2) throws DebugException;

    protected Point getCellLocation(BigInteger address) {
        return null;
    }

    protected String getCellText(MemoryByte[] bytes) {
        return null;
    }

    protected abstract int getCellWidth();

    protected abstract int getCellCharacterCount();

    public void setFont(Font font) {
        super.setFont(font);
        this.fCharacterWidth = -1;
        this.fCellHeight = -1;
        this.fTextHeight = -1;
    }

    protected int getCellHeight() {
        if (this.fCellHeight == -1) {
            this.fCellHeight = this.getCellTextHeight() + this.fRendering.getCellPadding() * 2;
        }
        return this.fCellHeight;
    }

    protected int getCellCharacterWidth() {
        if (this.fCharacterWidth == -1) {
            GC gc = new GC((Drawable)this);
            gc.setFont(this.fRendering.getFont());
            this.fCharacterWidth = gc.getAdvanceWidth('F');
            gc.dispose();
        }
        return this.fCharacterWidth;
    }

    protected int getCellTextHeight() {
        if (this.fTextHeight == -1) {
            GC gc = new GC((Drawable)this);
            gc.setFont(this.fRendering.getFont());
            FontMetrics fontMetrics = gc.getFontMetrics();
            this.fTextHeight = fontMetrics.getHeight();
            gc.dispose();
        }
        return this.fTextHeight;
    }

    class AbstractPaneFocusListener
    implements FocusListener {
        AbstractPaneFocusListener() {
        }

        public void focusLost(FocusEvent fe) {
            IPreferenceStore store = FPRenderingPlugin.getDefault().getPreferenceStore();
            if ("saveOnEnterCancelOnFocusLost".equals(store.getString("memoryEditBufferSave"))) {
                FPAbstractPane.this.fRendering.getViewportCache().clearEditBuffer();
            } else {
                FPAbstractPane.this.fRendering.getViewportCache().writeEditBuffer();
            }
            FPAbstractPane.this.fSelectionStartAddress = null;
        }

        public void focusGained(FocusEvent fe) {
            if (FPAbstractPane.this instanceof FPDataPane) {
                FPAbstractPane.this.fRendering.displayEditModeIndicator(true);
            } else {
                FPAbstractPane.this.fRendering.displayEditModeIndicator(false);
            }
        }
    }

    class AbstractPaneKeyListener
    implements KeyListener {
        AbstractPaneKeyListener() {
        }

        public void keyPressed(KeyEvent ke) {
            FPAbstractPane.this.fOldSubCellCaretPosition = FPAbstractPane.this.fSubCellCaretPosition;
            if ((ke.stateMask & 0x20000) != 0) {
                switch (ke.keyCode) {
                    case 0x1000001: 
                    case 0x1000002: 
                    case 0x1000003: 
                    case 0x1000004: 
                    case 0x1000005: 
                    case 0x1000006: {
                        if (FPAbstractPane.this.fRendering.getSelection().getStart() != null) break;
                        FPAbstractPane.this.fRendering.getSelection().setStart(FPAbstractPane.this.fCaretAddress.add(BigInteger.valueOf(FPAbstractPane.this.fRendering.getAddressesPerColumn())), FPAbstractPane.this.fCaretAddress);
                    }
                }
            }
            if (ke.keyCode == 0x1000004) {
                FPAbstractPane.this.handleRightArrowKey();
            } else if (ke.keyCode == 0x1000003 || ke.keyCode == 8) {
                FPAbstractPane.this.handleLeftArrowKey();
            } else if (ke.keyCode == 0x1000002) {
                FPAbstractPane.this.handleDownArrowKey();
            } else if (ke.keyCode == 0x1000001) {
                FPAbstractPane.this.handleUpArrowKey();
            } else if (ke.keyCode == 0x1000006) {
                FPAbstractPane.this.handlePageDownKey();
            } else if (ke.keyCode == 0x1000005) {
                FPAbstractPane.this.handlePageUpKey();
            } else if (ke.keyCode == 0x1000009) {
                FPAbstractPane.this.handleInsertKey();
            } else if (ke.keyCode == 27) {
                FPAbstractPane.this.fRendering.getViewportCache().clearEditBuffer();
                FPAbstractPane.this.handleCTRLZ();
            } else if (ke.character == '\r') {
                FPAbstractPane.this.fRendering.getViewportCache().writeEditBuffer();
                FPAbstractPane.this.handleCarriageReturn();
            } else if (FPutilities.validEditCharacter(ke.character)) {
                if (FPAbstractPane.this.fRendering.getSelection().hasSelection()) {
                    FPAbstractPane.this.setCaretAddress(FPAbstractPane.this.fRendering.getSelection().getLow());
                    FPAbstractPane.this.fSubCellCaretPosition = 0;
                }
                FPAbstractPane.this.editCell(FPAbstractPane.this.fCaretAddress, FPAbstractPane.this.fSubCellCaretPosition, ke.character);
            }
            if ((ke.stateMask & 0x40000) != 0 && (ke.keyCode == 122 || ke.keyCode == 90)) {
                FPAbstractPane.this.handleCTRLZ();
            }
            int cfr_ignored_0 = ke.stateMask;
            if ((ke.stateMask & 0x20000) != 0) {
                switch (ke.keyCode) {
                    case 0x1000001: 
                    case 0x1000002: 
                    case 0x1000003: 
                    case 0x1000004: 
                    case 0x1000005: 
                    case 0x1000006: {
                        FPAbstractPane.this.fRendering.getSelection().setEnd(FPAbstractPane.this.fCaretAddress.add(BigInteger.valueOf(FPAbstractPane.this.fRendering.getAddressesPerColumn())), FPAbstractPane.this.fCaretAddress);
                    }
                }
            } else if (ke.keyCode != 131072) {
                FPAbstractPane.this.fRendering.getSelection().clear();
            }
        }

        public void keyReleased(KeyEvent ke) {
        }
    }

    class AbstractPaneMouseListener
    implements MouseListener {
        AbstractPaneMouseListener() {
        }

        public void mouseUp(MouseEvent me) {
            FPAbstractPane.this.positionCaret(me.x, me.y);
            FPAbstractPane.this.fCaret.setVisible(true);
            if (FPAbstractPane.this.fSelectionInProgress && me.button == 1) {
                FPAbstractPane.this.endSelection(me.x, me.y);
            }
            FPAbstractPane.this.fSelectionStarted = false;
            FPAbstractPane.this.fSelectionInProgress = false;
        }

        public void mouseDown(MouseEvent me) {
            FPAbstractPane.this.handleCarriageReturn();
            FPAbstractPane.this.forceFocus();
            FPAbstractPane.this.positionCaret(me.x, me.y);
            FPAbstractPane.this.fCaret.setVisible(false);
            if (me.button == 1) {
                if ((me.stateMask & 0x20000) != 0 && FPAbstractPane.this.fRendering.getSelection().getStart() != null) {
                    if (FPAbstractPane.this.fSelectionStartAddress == null) {
                        FPAbstractPane.this.fSelectionStartAddress = FPAbstractPane.this.fRendering.getSelection().getStart();
                    }
                    FPAbstractPane.this.fSelectionStarted = true;
                    FPAbstractPane.this.appendSelection(me.x, me.y);
                } else {
                    FPAbstractPane.this.startSelection(me.x, me.y);
                }
            }
        }

        public void mouseDoubleClick(MouseEvent me) {
            FPAbstractPane.this.handleMouseDoubleClick(me);
        }
    }

    class AbstractPaneMouseMoveListener
    implements MouseMoveListener {
        AbstractPaneMouseMoveListener() {
        }

        public void mouseMove(MouseEvent me) {
            if (FPAbstractPane.this.fSelectionStarted) {
                FPAbstractPane.this.fSelectionInProgress = true;
                FPAbstractPane.this.appendSelection(me.x, me.y);
            }
        }
    }

    class AbstractPanePaintListener
    implements PaintListener {
        AbstractPanePaintListener() {
        }

        public void paintControl(PaintEvent pe) {
            FPAbstractPane.this.paint(pe);
        }
    }
}

