/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper;

import com.nvidia.viper.Activator;
import com.nvidia.viper.ViperRunMode;
import com.nvidia.viper.ui.ViperMessageDialog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class ViperExceptionHandler {
    public static void handle(final String title, String message, Exception e) {
        ViperExceptionHandler.logError(message, e);
        if (PlatformUI.isWorkbenchRunning()) {
            final String msg = String.valueOf(message) + (e != null ? "\n" + e : "");
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    ViperMessageDialog.openError(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), title, msg);
                }
            });
        }
    }

    public static void logError(String message) {
        ViperExceptionHandler.logError(message, null);
    }

    public static void logError(String message, Throwable e) {
        Activator.getDefault().getLog().log((IStatus)new Status(4, "com.nvidia.viper", message, e));
        if (ViperRunMode.getRunMode() == ViperRunMode.RunMode.TEST) {
            System.err.println("ViperExceptionHandler.logError:: " + message);
            if (e != null) {
                e.printStackTrace();
            }
        }
        ViperRunMode.recordException(message);
    }
}

