/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.ui.viewmodel.launch;

import java.util.concurrent.ExecutionException;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.IStack;
import org.eclipse.cdt.dsf.internal.ui.DsfUIPlugin;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelSelectionPolicy;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;

public class DefaultDsfSelectionPolicy
implements IModelSelectionPolicy {
    private IDMContext fDMContext;

    public DefaultDsfSelectionPolicy(IDMContext dmContext) {
        this.fDMContext = dmContext;
    }

    public boolean contains(ISelection selection, IPresentationContext context) {
        IDMVMContext dmvmContext;
        IDMContext dmContext;
        IStructuredSelection ss;
        Object element;
        if ("org.eclipse.debug.ui.DebugView".equals(context.getId()) && selection instanceof IStructuredSelection && (element = (ss = (IStructuredSelection)selection).getFirstElement()) instanceof IDMVMContext && (dmContext = (dmvmContext = (IDMVMContext)element).getDMContext()) != null) {
            return this.fDMContext.getSessionId().equals(dmContext.getSessionId());
        }
        return false;
    }

    public boolean isSticky(ISelection selection, IPresentationContext context) {
        if ("org.eclipse.debug.ui.DebugView".equals(context.getId()) && selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            Object element = ss.getFirstElement();
            return this.isSticky(element);
        }
        return false;
    }

    protected boolean isSticky(Object element) {
        IRunControl.IExecutionDMContext execContext;
        IDMVMContext dmvmContext;
        IDMContext dmContext;
        if (element instanceof IDMVMContext && (dmContext = (dmvmContext = (IDMVMContext)element).getDMContext()) instanceof IStack.IFrameDMContext && (execContext = (IRunControl.IExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)dmContext, IRunControl.IExecutionDMContext.class)) != null) {
            Query<Boolean> query = new Query<Boolean>(){

                protected void execute(DataRequestMonitor<Boolean> rm) {
                    DsfServicesTracker servicesTracker = new DsfServicesTracker(DsfUIPlugin.getBundleContext(), dmContext.getSessionId());
                    try {
                        IRunControl runControl = (IRunControl)servicesTracker.getService(IRunControl.class);
                        if (runControl != null) {
                            rm.setData((Object)runControl.isSuspended(execContext));
                        } else {
                            rm.setData((Object)false);
                        }
                    }
                    finally {
                        servicesTracker.dispose();
                        rm.done();
                    }
                }
            };
            DsfSession session = DsfSession.getSession((String)dmContext.getSessionId());
            if (session != null) {
                if (session.getExecutor().isInExecutorThread()) {
                    query.run();
                } else {
                    session.getExecutor().execute((Runnable)query);
                }
                try {
                    Boolean result = (Boolean)query.get();
                    return result != null && result != false;
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException exc) {
                    DsfUIPlugin.log(exc);
                }
            }
        }
        return false;
    }

    public boolean overrides(ISelection existing, ISelection candidate, IPresentationContext context) {
        if ("org.eclipse.debug.ui.DebugView".equals(context.getId()) && existing instanceof IStructuredSelection && candidate instanceof IStructuredSelection) {
            IStructuredSelection ssExisting = (IStructuredSelection)existing;
            IStructuredSelection ssCandidate = (IStructuredSelection)candidate;
            return this.overrides(ssExisting.getFirstElement(), ssCandidate.getFirstElement());
        }
        return true;
    }

    protected boolean overrides(Object existing, Object candidate) {
        if (existing == null || existing.equals(candidate)) {
            return true;
        }
        if (existing instanceof IDMVMContext && candidate instanceof IDMVMContext) {
            IRunControl.IExecutionDMContext currExecContext;
            IDMContext curr = ((IDMVMContext)existing).getDMContext();
            IDMContext cand = ((IDMVMContext)candidate).getDMContext();
            if (curr instanceof IStack.IFrameDMContext && cand instanceof IStack.IFrameDMContext && (currExecContext = (IRunControl.IExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)curr, IRunControl.IExecutionDMContext.class)) != null) {
                IRunControl.IExecutionDMContext candExecContext = (IRunControl.IExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)cand, IRunControl.IExecutionDMContext.class);
                return currExecContext.equals(candExecContext) || !this.isSticky(existing) || this.frameOverrides((IStack.IFrameDMContext)curr, (IStack.IFrameDMContext)cand);
            }
        }
        return !this.isSticky(existing);
    }

    private boolean frameOverrides(final IStack.IFrameDMContext curr, IStack.IFrameDMContext cand) {
        final IRunControl.IContainerDMContext currContContext = (IRunControl.IContainerDMContext)DMContexts.getAncestorOfType((IDMContext)curr, IRunControl.IContainerDMContext.class);
        IRunControl.IContainerDMContext candContContext = (IRunControl.IContainerDMContext)DMContexts.getAncestorOfType((IDMContext)cand, IRunControl.IContainerDMContext.class);
        if (currContContext == null || !currContContext.equals(candContContext)) {
            return false;
        }
        Query<Boolean> query = new Query<Boolean>(){

            protected void execute(final DataRequestMonitor<Boolean> rm) {
                DsfServicesTracker servicesTracker = new DsfServicesTracker(DsfUIPlugin.getBundleContext(), curr.getSessionId());
                IRunControl runControl = (IRunControl)servicesTracker.getService(IRunControl.class);
                if (runControl != null && runControl.isSuspended((IRunControl.IExecutionDMContext)currContContext)) {
                    IRunControl.IExecutionDMContext execDmc = (IRunControl.IExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)curr, IRunControl.IExecutionDMContext.class);
                    runControl.getExecutionData(execDmc, (DataRequestMonitor)new DataRequestMonitor<IRunControl.IExecutionDMData>(ImmediateExecutor.getInstance(), rm){

                        protected void handleSuccess() {
                            rm.setData((Object)(((IRunControl.IExecutionDMData)this.getData()).getStateChangeReason() == IRunControl.StateChangeReason.CONTAINER ? 1 : 0));
                            rm.done();
                        }
                    });
                } else {
                    rm.setData((Object)false);
                    rm.done();
                }
                servicesTracker.dispose();
            }
        };
        DsfSession session = DsfSession.getSession((String)curr.getSessionId());
        if (session != null) {
            if (session.getExecutor().isInExecutorThread()) {
                query.run();
            } else {
                session.getExecutor().execute((Runnable)query);
            }
            try {
                Boolean result = (Boolean)query.get();
                return result != null && result != false;
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException exc) {
                DsfUIPlugin.log(exc);
            }
        }
        return false;
    }

    public ISelection replaceInvalidSelection(ISelection invalidSelection, ISelection newSelection) {
        TreePath path;
        ITreeSelection treeSelection;
        if (invalidSelection instanceof ITreeSelection && (treeSelection = (ITreeSelection)invalidSelection).getPaths().length == 1 && (path = treeSelection.getPaths()[0]).getSegmentCount() > 1) {
            return new TreeSelection(path.getParentPath());
        }
        return newSelection;
    }
}

