/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.formatter.align;

import java.util.Arrays;
import org.eclipse.cdt.internal.formatter.Location;
import org.eclipse.cdt.internal.formatter.Scribe;
import org.eclipse.cdt.internal.formatter.align.AlignmentException;

public class Alignment {
    public static final String ASSIGNMENT_EXPRESSION = "assignmentExpression";
    public static final String BINARY_EXPRESSION = "binaryExpression";
    public static final String COMPACT_IF = "compactIf";
    public static final String CONDITIONAL_EXPRESSION = "conditionalExpression";
    public static final String CONDITIONAL_EXPRESSION_CHAIN = "conditionalExpressionChain";
    public static final String DECLARATION_INITIALIZER = "declarationInitializer";
    public static final String DESIGNATED_INITIALIZER = "designatedInitializer";
    public static final String EXCEPTION_SPECIFICATION = "exceptionSpecification";
    public static final String FIELD_REFERENCE = "fieldReference";
    public static final String FOR = "for";
    public static final String LIST_ELEMENTS_PREFIX = "listElements_";
    public static final String MACRO_ARGUMENTS = "macroArguments";
    public static final String OVERLOADED_LEFT_SHIFT_CHAIN = "overloadedLeftShiftChain";
    public static final String TRAILING_TEXT = "trailingText";
    public String name;
    public Alignment enclosing;
    public Location location;
    public Runnable tailFormatter;
    public int fragmentIndex;
    public int fragmentCount;
    public int[] fragmentIndentations;
    public boolean needRedoColumnAlignment;
    public int chunkStartIndex;
    public int chunkKind;
    public int originalIndentationLevel;
    public int breakIndentationLevel;
    public int alternativeBreakIndentationLevel;
    public int[] fragmentBreaks;
    public boolean wasSplit;
    public int currentFragmentStartLine;
    public final Scribe scribe;
    public static final int M_FORCE = 1;
    public static final int M_INDENT_ON_COLUMN = 2;
    public static final int M_INDENT_BY_ONE = 4;
    public static final int M_COMPACT_SPLIT = 16;
    public static final int M_COMPACT_FIRST_BREAK_SPLIT = 32;
    public static final int M_ONE_PER_LINE_SPLIT = 48;
    public static final int M_NEXT_SHIFTED_SPLIT = 64;
    public static final int M_NEXT_PER_LINE_SPLIT = 80;
    public static final int M_MULTICOLUMN = 256;
    public static final int M_NO_ALIGNMENT = 0;
    public int mode;
    public static final int SPLIT_MASK = 112;
    public static final int R_OUTERMOST = 1;
    public static final int R_INNERMOST = 2;
    public int tieBreakRule;
    public static final int BREAK_NOT_ALLOWED = -1;
    public static final int NONE = 0;
    public static final int BREAK = 2;
    public static final int CHUNK_FIELD = 1;
    public static final int CHUNK_METHOD = 2;
    public static final int CHUNK_TYPE = 3;
    public static final int CHUNK_ENUM = 4;

    public Alignment(String name, int mode, int tieBreakRule, Scribe scribe, int fragmentCount, int sourceRestart, int continuationIndent) {
        this.name = name;
        this.location = new Location(scribe, sourceRestart);
        this.mode = mode;
        this.tieBreakRule = tieBreakRule;
        this.fragmentCount = fragmentCount;
        this.scribe = scribe;
        this.originalIndentationLevel = this.scribe.indentationLevel;
        this.wasSplit = false;
        this.fragmentIndentations = new int[this.fragmentCount];
        this.fragmentBreaks = new int[this.fragmentCount];
        Arrays.fill(this.fragmentBreaks, (this.mode & 1) == 0 ? -1 : 0);
        this.currentFragmentStartLine = this.scribe.line;
        int currentColumn = this.location.outputColumn;
        if (currentColumn == 1) {
            currentColumn = this.location.outputIndentationLevel + 1;
        }
        int indentSize = this.scribe.indentationSize;
        if ((mode & 2) != 0) {
            this.breakIndentationLevel = this.scribe.getNextIndentationLevel(currentColumn);
            this.alternativeBreakIndentationLevel = this.location.outputIndentationLevel + continuationIndent * indentSize;
        } else {
            int baseIndentationLevel = this.location.outputIndentationLevel;
            if (name != TRAILING_TEXT && this.scribe.currentAlignment != null && (this.scribe.currentAlignment.mode & 2) != 0 && this.scribe.currentAlignment.fragmentCount > 1) {
                baseIndentationLevel = this.scribe.currentAlignment.breakIndentationLevel;
            }
            this.breakIndentationLevel = (mode & 4) != 0 ? baseIndentationLevel + indentSize : baseIndentationLevel + continuationIndent * indentSize;
            this.alternativeBreakIndentationLevel = this.breakIndentationLevel;
        }
        if ((this.mode & 1) != 0) {
            this.fragmentBreaks[this.fragmentIndex] = 0;
            this.couldBreak();
        }
    }

    public boolean checkChunkStart(int kind, int startIndex, int sourceRestart) {
        if (this.chunkKind != kind) {
            this.chunkKind = kind;
            if (startIndex != this.chunkStartIndex) {
                this.chunkStartIndex = startIndex;
                this.location.update(this.scribe, sourceRestart);
                this.reset();
            }
            return true;
        }
        return false;
    }

    public void checkColumn() {
        if ((this.mode & 0x100) != 0) {
            int fragmentIndentation;
            int currentIndentation = this.scribe.getNextIndentationLevel(this.scribe.column + (this.scribe.needSpace ? 1 : 0));
            if (currentIndentation > (fragmentIndentation = this.fragmentIndentations[this.fragmentIndex])) {
                this.fragmentIndentations[this.fragmentIndex] = currentIndentation;
                if (fragmentIndentation != 0) {
                    int i = this.fragmentIndex + 1;
                    while (i < this.fragmentCount) {
                        this.fragmentIndentations[i] = 0;
                        ++i;
                    }
                    this.needRedoColumnAlignment = true;
                }
            }
            if (this.needRedoColumnAlignment && this.fragmentIndex == this.fragmentCount - 1) {
                this.needRedoColumnAlignment = false;
                int relativeDepth = 0;
                Alignment targetAlignment = this.scribe.memberAlignment;
                while (targetAlignment != null) {
                    if (targetAlignment == this) {
                        throw new AlignmentException(2, relativeDepth);
                    }
                    targetAlignment = targetAlignment.enclosing;
                    ++relativeDepth;
                }
            }
        }
    }

    public boolean couldBreak() {
        block0 : switch (this.mode & 0x70) {
            case 32: {
                if (this.fragmentBreaks[0] == 0) {
                    if ((this.mode & 2) != 0) {
                        if (this.breakIndentationLevel <= this.alternativeBreakIndentationLevel) break;
                        this.breakIndentationLevel = this.alternativeBreakIndentationLevel;
                        this.eraseExistingBreaks(0);
                    }
                    this.fragmentBreaks[0] = 2;
                    this.fragmentIndentations[0] = this.breakIndentationLevel;
                    this.wasSplit = true;
                    return true;
                }
                int i = this.fragmentIndex;
                do {
                    if (this.fragmentBreaks[i] != 0) continue;
                    this.fragmentBreaks[i] = 2;
                    this.fragmentIndentations[i] = this.breakIndentationLevel;
                    this.wasSplit = true;
                    return true;
                } while (--i >= 0);
                break;
            }
            case 16: {
                int i = this.fragmentIndex;
                do {
                    if (this.fragmentBreaks[i] != 0) continue;
                    if ((this.mode & 2) != 0 && this.isFirstBreakableFragment(i)) {
                        if (this.breakIndentationLevel <= this.alternativeBreakIndentationLevel) break block0;
                        this.breakIndentationLevel = this.alternativeBreakIndentationLevel;
                        this.eraseExistingBreaks(i);
                    }
                    this.fragmentBreaks[i] = 2;
                    this.fragmentIndentations[i] = this.breakIndentationLevel;
                    this.wasSplit = true;
                    return true;
                } while ((this.fragmentBreaks[i] != 2 || (this.mode & 2) != 0) && --i >= 0);
                break;
            }
            case 64: {
                if (this.fragmentBreaks[0] != 0) break;
                this.fragmentBreaks[0] = 2;
                this.fragmentIndentations[0] = this.breakIndentationLevel;
                int i = 1;
                while (i < this.fragmentCount) {
                    this.fragmentBreaks[i] = 2;
                    this.fragmentIndentations[i] = this.breakIndentationLevel + this.scribe.indentationSize;
                    ++i;
                }
                this.wasSplit = true;
                return true;
            }
            case 48: {
                if (this.fragmentBreaks[0] != 0) break;
                int i = 0;
                while (i < this.fragmentCount) {
                    this.fragmentBreaks[i] = 2;
                    this.fragmentIndentations[i] = this.breakIndentationLevel;
                    ++i;
                }
                this.wasSplit = true;
                return true;
            }
            case 80: {
                if (this.fragmentBreaks[0] == 2 || this.fragmentCount <= 1 || this.fragmentBreaks[1] != 0) break;
                if ((this.mode & 2) != 0) {
                    this.fragmentIndentations[0] = this.breakIndentationLevel;
                }
                int i = 1;
                while (i < this.fragmentCount) {
                    this.fragmentBreaks[i] = 2;
                    this.fragmentIndentations[i] = this.breakIndentationLevel;
                    ++i;
                }
                this.wasSplit = true;
                return true;
            }
        }
        return false;
    }

    private boolean isFirstBreakableFragment(int i) {
        while (--i >= 0) {
            if (this.fragmentBreaks[i] == -1) continue;
            return false;
        }
        return true;
    }

    private void eraseExistingBreaks(int startFragmentIndex) {
        int j = startFragmentIndex + 1;
        while (j < this.fragmentIndentations.length) {
            if (this.fragmentBreaks[j] == 2) {
                this.fragmentBreaks[j] = 0;
                this.fragmentIndentations[j] = 0;
            }
            ++j;
        }
    }

    public Alignment getAlignment(String targetName) {
        if (targetName.equals(this.name)) {
            return this;
        }
        if (this.enclosing == null) {
            return null;
        }
        return this.enclosing.getAlignment(targetName);
    }

    public void alignFragment(int fragmentIndex) {
        this.fragmentIndex = fragmentIndex;
        if (this.fragmentBreaks[fragmentIndex] == -1) {
            this.fragmentBreaks[fragmentIndex] = 0;
        }
        switch (this.mode & 0x70) {
            case 48: 
            case 80: {
                int i = fragmentIndex + 1;
                while (i < this.fragmentBreaks.length) {
                    if (this.fragmentBreaks[i] == -1) {
                        this.fragmentBreaks[i] = 0;
                    }
                    ++i;
                }
                break;
            }
        }
        this.checkColumn();
        this.performFragmentEffect();
    }

    public void performFragmentEffect() {
        if ((this.mode & 0x100) == 0) {
            switch (this.mode & 0x70) {
                case 16: 
                case 32: 
                case 48: 
                case 64: 
                case 80: {
                    break;
                }
                default: {
                    return;
                }
            }
        }
        if ((this.mode & 2) != 0 && this.fragmentIndex > 0 && this.scribe.line > this.currentFragmentStartLine) {
            this.fragmentBreaks[this.fragmentIndex] = 2;
            this.fragmentIndentations[this.fragmentIndex] = this.breakIndentationLevel;
            this.wasSplit = true;
        }
        if (this.fragmentBreaks[this.fragmentIndex] == 2) {
            this.scribe.startNewLine();
        }
        if (this.fragmentIndentations[this.fragmentIndex] > 0) {
            this.scribe.indentationLevel = this.fragmentIndentations[this.fragmentIndex];
        }
        this.currentFragmentStartLine = this.scribe.line;
    }

    public boolean isIndentOnColumn(int column) {
        return (this.mode & 2) != 0 && this.breakIndentationLevel == column - 1;
    }

    public void reset() {
        if (this.fragmentCount > 0) {
            this.fragmentIndentations = new int[this.fragmentCount];
            this.fragmentBreaks = new int[this.fragmentCount];
        }
        if ((this.mode & 1) != 0) {
            this.couldBreak();
        }
    }

    public void toFragmentsString(StringBuffer buffer) {
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(10);
        buffer.append(this.getClass().getName()).append(':').append("<name: ").append(this.name).append(">");
        if (this.enclosing != null) {
            buffer.append("<enclosingName: ").append(this.enclosing.name).append('>');
        }
        buffer.append('\n');
        int i = 0;
        while (i < this.fragmentCount) {
            buffer.append(" - fragment ").append(i).append(": ").append("<break: ").append(this.fragmentBreaks[i] > 0 ? "YES" : "NO").append(">").append("<indent: ").append(this.fragmentIndentations[i]).append(">\n");
            ++i;
        }
        buffer.append('\n');
        return buffer.toString();
    }

    public void update() {
        int i = 1;
        while (i < this.fragmentCount) {
            if (this.fragmentBreaks[i] == 2) {
                this.fragmentIndentations[i] = this.breakIndentationLevel;
            }
            ++i;
        }
    }

    public boolean isWrapped() {
        int i = 0;
        int max = this.fragmentCount;
        while (i < max) {
            if (this.fragmentBreaks[i] == 2) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

