/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.contentassist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.IASTCompletionNode;
import org.eclipse.cdt.core.dom.ast.IASTFieldReference;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.model.ICLanguageKeywords;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.text.contentassist.CCompletionProposal;
import org.eclipse.cdt.internal.ui.text.contentassist.CContentAssistInvocationContext;
import org.eclipse.cdt.internal.ui.text.contentassist.ParsingBasedProposalComputer;
import org.eclipse.cdt.internal.ui.viewsupport.CElementImageProvider;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.swt.graphics.Image;

public class KeywordCompletionProposalComputer
extends ParsingBasedProposalComputer {
    private static final int MIN_KEYWORD_LENGTH = 5;

    @Override
    protected List<ICompletionProposal> computeCompletionProposals(CContentAssistInvocationContext context, IASTCompletionNode completionNode, String prefix) throws CoreException {
        ArrayList<ICompletionProposal> proposals;
        block17: {
            ICLanguageKeywords languageKeywords;
            int prefixLength;
            block13: {
                ILanguage language;
                if (prefix.length() == 0) {
                    try {
                        prefix = context.computeIdentifierPrefix().toString();
                    }
                    catch (BadLocationException exc) {
                        CUIPlugin.log(exc);
                    }
                }
                if ((prefixLength = prefix.length()) == 0 || context.isContextInformationStyle()) {
                    return Collections.emptyList();
                }
                proposals = new ArrayList<ICompletionProposal>();
                languageKeywords = null;
                ITranslationUnit tu = context.getTranslationUnit();
                if (tu != null && (language = tu.getLanguage()) != null) {
                    languageKeywords = (ICLanguageKeywords)language.getAdapter(ICLanguageKeywords.class);
                }
                if (languageKeywords == null) {
                    return Collections.emptyList();
                }
                if (!this.inPreprocessorDirective(context)) break block13;
                boolean needDirectiveKeyword = this.inPreprocessorKeyword(context);
                ImageDescriptor imagedesc = CElementImageProvider.getKeywordImageDescriptor();
                Image image = imagedesc != null ? CUIPlugin.getImageDescriptorRegistry().get(imagedesc) : null;
                String[] stringArray = languageKeywords.getPreprocessorKeywords();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    block14: {
                        int repOffset;
                        int repLength;
                        String repString;
                        String keyword;
                        block16: {
                            block15: {
                                keyword = stringArray[n2];
                                if (!keyword.startsWith(prefix) || keyword.length() <= prefixLength) break block14;
                                repString = String.valueOf(keyword) + ' ';
                                repLength = prefixLength;
                                repOffset = context.getInvocationOffset() - repLength;
                                if (prefix.charAt(0) != '#') break block15;
                                --repLength;
                                ++repOffset;
                                repString = repString.substring(1);
                                break block16;
                            }
                            if (needDirectiveKeyword) break block14;
                        }
                        proposals.add(new CCompletionProposal(repString, repOffset, repLength, image, keyword, 1010, context.getViewer()));
                    }
                    ++n2;
                }
                break block17;
            }
            if (!this.isValidContext(completionNode)) {
                return Collections.emptyList();
            }
            ImageDescriptor imagedesc = CElementImageProvider.getKeywordImageDescriptor();
            Image image = imagedesc != null ? CUIPlugin.getImageDescriptorRegistry().get(imagedesc) : null;
            String[] stringArray = languageKeywords.getKeywords();
            int n = stringArray.length;
            int n3 = 0;
            while (n3 < n) {
                String keyword = stringArray[n3];
                if (keyword.startsWith(prefix) && keyword.length() > prefixLength && keyword.length() >= 5) {
                    int repLength = prefixLength;
                    int repOffset = context.getInvocationOffset() - repLength;
                    proposals.add(new CCompletionProposal(keyword, repOffset, repLength, image, keyword, 1010, context.getViewer()));
                }
                ++n3;
            }
        }
        return proposals;
    }

    private boolean isValidContext(IASTCompletionNode completionNode) {
        IASTName[] names = completionNode.getNames();
        int i = 0;
        while (i < names.length) {
            IASTName name = names[i];
            if (name.getTranslationUnit() != null && !(name.getParent() instanceof IASTFieldReference)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean inPreprocessorKeyword(CContentAssistInvocationContext context) {
        IDocument doc = context.getDocument();
        int offset = context.getInvocationOffset();
        try {
            String ppPrefix;
            ITypedRegion partition = TextUtilities.getPartition((IDocument)doc, (String)"___c_partitioning", (int)offset, (boolean)true);
            if ("__c_preprocessor".equals(partition.getType()) && (ppPrefix = doc.get(partition.getOffset(), offset - partition.getOffset())).matches("\\s*#\\s*\\w*")) {
                return true;
            }
        }
        catch (BadLocationException badLocationException) {}
        return false;
    }

    private boolean inPreprocessorDirective(CContentAssistInvocationContext context) {
        IDocument doc = context.getDocument();
        int offset = context.getInvocationOffset();
        try {
            ITypedRegion partition = TextUtilities.getPartition((IDocument)doc, (String)"___c_partitioning", (int)offset, (boolean)true);
            if ("__c_preprocessor".equals(partition.getType())) {
                return true;
            }
        }
        catch (BadLocationException badLocationException) {}
        return false;
    }
}

