/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ide.launch;

import com.nvidia.common.util.CoreUtil;
import com.nvidia.viper.ide.Activator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;

public final class ViperLaunchConfigurationsTracker
implements ILaunchConfigurationListener {
    private final Map<String, Boolean> trackedConfigurations = new ConcurrentHashMap<String, Boolean>();

    public boolean isDirty(String name) {
        return Boolean.TRUE.equals(this.trackedConfigurations.get(name));
    }

    public void launchConfigurationAdded(ILaunchConfiguration configuration) {
    }

    public void launchConfigurationChanged(ILaunchConfiguration configuration) {
        try {
            if (!configuration.isWorkingCopy() && "org.eclipse.cdt.launch.applicationLaunchType".equals(configuration.getType().getIdentifier()) && this.trackedConfigurations.containsKey(configuration.getName())) {
                this.trackedConfigurations.put(configuration.getName(), true);
            }
        }
        catch (CoreException e) {
            Activator.log(e);
        }
    }

    public void launchConfigurationRemoved(ILaunchConfiguration configuration) {
    }

    public void markClean(String name) {
        if (name != null) {
            this.trackedConfigurations.put(name, false);
        }
    }

    public void startTracking(String name) {
        if (!CoreUtil.isNullOrEmpty((String)name)) {
            this.trackedConfigurations.put(name, false);
        }
    }

    public void stopTracking(String name) {
        if (name != null) {
            this.trackedConfigurations.remove(name);
        }
    }
}

