/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.persistence;

import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.SystemResourceManager;
import org.eclipse.rse.internal.persistence.PFPersistenceLocation;

class PFWorkspaceLocation
implements PFPersistenceLocation {
    IFolder baseFolder = null;

    public PFWorkspaceLocation(IFolder baseResource) {
        this.baseFolder = baseResource;
    }

    public boolean exists() {
        return this.baseFolder.exists();
    }

    public void ensure() {
        this.ensure((IContainer)this.baseFolder);
    }

    public PFPersistenceLocation getChild(String childName) {
        Path path = new Path(childName);
        IFolder member = this.baseFolder.getFolder((IPath)path);
        PFWorkspaceLocation result = new PFWorkspaceLocation(member);
        return result;
    }

    public PFPersistenceLocation[] getChildren() {
        IResource[] members;
        try {
            members = this.baseFolder.members();
        }
        catch (CoreException e) {
            this.logException((Exception)((Object)e));
            members = new IResource[]{};
        }
        ArrayList<PFWorkspaceLocation> children = new ArrayList<PFWorkspaceLocation>(members.length);
        int i = 0;
        while (i < members.length) {
            IResource member = members[i];
            if (member.getType() == 2) {
                PFWorkspaceLocation child = new PFWorkspaceLocation((IFolder)member);
                children.add(child);
            }
            ++i;
        }
        PFPersistenceLocation[] result = new PFPersistenceLocation[children.size()];
        children.toArray(result);
        return result;
    }

    public URI getLocator() {
        return this.baseFolder.getLocationURI();
    }

    public String getName() {
        return this.baseFolder.getName();
    }

    public boolean hasContents() {
        Path propertiesFileName = new Path("node.properties");
        IFile propertiesFile = this.baseFolder.getFile((IPath)propertiesFileName);
        boolean result = propertiesFile.exists();
        return result;
    }

    public void keepChildren(Set keepSet) {
        try {
            IResource[] children = this.baseFolder.members();
            int i = 0;
            while (i < children.length) {
                String childFolderName;
                IResource child = children[i];
                if (child.getType() == 2 && !keepSet.contains(childFolderName = child.getName())) {
                    child.delete(true, null);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            this.logException((Exception)((Object)e));
        }
    }

    public void setContents(InputStream stream) {
        Path propertiesFileName = new Path("node.properties");
        IFile propertiesFile = this.baseFolder.getFile((IPath)propertiesFileName);
        try {
            if (propertiesFile.exists()) {
                propertiesFile.setContents(stream, 3, null);
            } else {
                propertiesFile.create(stream, 3, null);
            }
        }
        catch (CoreException e) {
            this.logException((Exception)((Object)e));
        }
    }

    public InputStream getContents() {
        InputStream result = null;
        Path propertiesFileName = new Path("node.properties");
        IFile propertiesFile = this.baseFolder.getFile((IPath)propertiesFileName);
        if (propertiesFile.exists()) {
            try {
                result = propertiesFile.getContents();
            }
            catch (CoreException e) {
                this.logException((Exception)((Object)e));
            }
        }
        return result;
    }

    private void ensure(IContainer resource) {
        if (!resource.isAccessible()) {
            if (resource.getType() == 4) {
                SystemResourceManager.getRemoteSystemsProject(true);
            } else {
                IFolder folder = (IFolder)resource;
                this.ensure(folder.getParent());
                try {
                    folder.create(true, true, null);
                }
                catch (CoreException e) {
                    this.logException((Exception)((Object)e));
                }
            }
        }
    }

    private void logException(Exception e) {
        RSECorePlugin.getDefault().getLogger().logError("unexpected exception", e);
    }
}

