/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.language.settings.providers;

import java.net.URL;
import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsProvider;
import org.eclipse.cdt.core.language.settings.providers.LanguageSettingsManager;
import org.eclipse.cdt.internal.ui.language.settings.providers.LanguageSettingsProviderAssociationManager;
import org.eclipse.cdt.internal.ui.newui.Messages;
import org.eclipse.cdt.ui.CDTSharedImages;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;

public class LanguageSettingsProvidersLabelProvider
extends LabelProvider {
    private static final String TEST_PLUGIN_ID_PATTERN = "org.eclipse.cdt.*.tests.*";
    private static final String OOPS = "OOPS";

    protected String getBaseKey(ILanguageSettingsProvider provider) {
        ILanguageSettingsProvider rawProvider;
        String imageKey = null;
        String id = provider.getId();
        URL url = LanguageSettingsProviderAssociationManager.getImageUrl(id);
        if (url == null && (rawProvider = LanguageSettingsManager.getRawProvider((ILanguageSettingsProvider)provider)) != null) {
            url = LanguageSettingsProviderAssociationManager.getImage(rawProvider.getClass());
        }
        if (url != null) {
            imageKey = url.toString();
        }
        if (imageKey == null) {
            imageKey = id.matches(TEST_PLUGIN_ID_PATTERN) ? "icons/obj16/flask.png" : "icons/obj16/extension_obj.gif";
        }
        return imageKey;
    }

    protected String[] getOverlayKeys(ILanguageSettingsProvider provider) {
        String[] overlayKeys = new String[5];
        if (provider.getName() == null) {
            overlayKeys[2] = "icons/ovr16/error_co.gif";
        }
        return overlayKeys;
    }

    public Image getImage(Object element) {
        if (element instanceof ILanguageSettingsProvider) {
            ILanguageSettingsProvider provider = (ILanguageSettingsProvider)element;
            String imageKey = this.getBaseKey(provider);
            String[] overlayKeys = this.getOverlayKeys(provider);
            return CDTSharedImages.getImageOverlaid(imageKey, overlayKeys);
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof ILanguageSettingsProvider) {
            ILanguageSettingsProvider provider = (ILanguageSettingsProvider)element;
            String name = provider.getName();
            if (name != null) {
                if (LanguageSettingsManager.isWorkspaceProvider((ILanguageSettingsProvider)provider)) {
                    name = String.valueOf(name) + Messages.LanguageSettingsProvidersLabelProvider_TextDecorator_Shared;
                }
                return name;
            }
            return NLS.bind((String)Messages.GeneralMessages_NonAccessibleID, (Object)provider.getId());
        }
        return OOPS;
    }
}

