/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.ui.viewmodel.numberformat;

import java.util.ArrayList;
import org.eclipse.cdt.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.actions.VMHandlerUtils;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.numberformat.FormattedValueVMUtil;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.numberformat.IElementFormatProvider;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.numberformat.MessagesForNumberFormat;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.numberformat.NumberFormatsContribution;
import org.eclipse.cdt.dsf.ui.concurrent.SimpleDisplayExecutor;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMContext;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.ui.AbstractDebugView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class ElementNumberFormatsContribution
extends NumberFormatsContribution {
    protected static IContributionItem[] NO_ITEMS = new IContributionItem[]{new ContributionItem(){

        public void fill(Menu menu, int index) {
            MenuItem item = new MenuItem(menu, 0);
            item.setEnabled(false);
            item.setText(MessagesForNumberFormat.NumberFormatContribution_EmptyFormatsList_label);
        }

        public boolean isEnabled() {
            return false;
        }
    }};

    @Override
    protected IContributionItem[] getContributionItems() {
        Viewer viewer;
        ISelection selection = VMHandlerUtils.getSelection(this.fServiceLocator);
        if (selection == null || selection.isEmpty() || !(selection instanceof ITreeSelection)) {
            return NO_ITEMS;
        }
        IVMProvider provider = VMHandlerUtils.getVMProviderForSelection(selection);
        if (FORMATS.size() == 0) {
            return NO_ITEMS;
        }
        IPresentationContext context = provider.getPresentationContext();
        TreePath[] elementPaths = ((ITreeSelection)selection).getPaths();
        IVMNode[] nodes = new IVMNode[elementPaths.length];
        final String[] formats = new String[elementPaths.length];
        Object viewerInput = null;
        if (context.getPart() instanceof AbstractDebugView && (viewer = ((AbstractDebugView)context.getPart()).getViewer()) != null) {
            viewerInput = viewer.getInput();
        }
        final ArrayList<SelectFormatAction> actions = new ArrayList<SelectFormatAction>(FORMATS.size());
        for (String formatId : FORMATS) {
            actions.add(new SelectFormatAction((IElementFormatProvider)((Object)provider), context, nodes, viewerInput, elementPaths, formatId));
        }
        CountingRequestMonitor crm = new CountingRequestMonitor(SimpleDisplayExecutor.getSimpleDisplayExecutor(Display.getDefault()), null){

            protected void handleCompleted() {
                String activeFormat = null;
                int i = 0;
                while (i < formats.length) {
                    if (i == 0) {
                        activeFormat = formats[i];
                    } else if (activeFormat != null && !activeFormat.equals(formats[i])) {
                        activeFormat = null;
                        break;
                    }
                    ++i;
                }
                if (activeFormat != null) {
                    i = 0;
                    while (i < actions.size()) {
                        if (activeFormat.equals(((SelectFormatAction)((Object)actions.get(i))).fFormatId)) {
                            ((SelectFormatAction)((Object)actions.get(i))).setChecked(true);
                            break;
                        }
                        ++i;
                    }
                }
            }
        };
        int i = 0;
        while (i < elementPaths.length) {
            Object segment = elementPaths[i].getLastSegment();
            nodes[i] = segment instanceof IVMContext ? ((IVMContext)segment).getVMNode() : null;
            final int index = i;
            ((IElementFormatProvider)((Object)provider)).getActiveFormat(context, nodes[i], viewerInput, elementPaths[i], new DataRequestMonitor<String>(ImmediateExecutor.getInstance(), (RequestMonitor)crm){

                protected void handleSuccess() {
                    formats[index] = (String)this.getData();
                    super.handleSuccess();
                }
            });
            ++i;
        }
        crm.setDoneCount(elementPaths.length);
        int count = actions.size();
        IContributionItem[] items = new IContributionItem[count];
        int i2 = 0;
        while (i2 < actions.size()) {
            items[i2] = new ActionContributionItem((IAction)actions.get(i2));
            ++i2;
        }
        return items;
    }

    static class SelectFormatAction
    extends Action {
        private final IElementFormatProvider fProvider;
        private final IPresentationContext fContext;
        private final IVMNode[] fNodes;
        private final Object fViewerInput;
        private final TreePath[] fElementPaths;
        private final String fFormatId;

        SelectFormatAction(IElementFormatProvider provider, IPresentationContext context, IVMNode[] nodes, Object viewerInput, TreePath[] elementPaths, String formatId) {
            super(formatId == null ? "Restore To Preference" : FormattedValueVMUtil.getFormatLabel(formatId), formatId == null ? 1 : 8);
            this.fProvider = provider;
            this.fContext = context;
            this.fNodes = nodes;
            this.fViewerInput = viewerInput;
            this.fElementPaths = elementPaths;
            this.fFormatId = formatId;
        }

        public void run() {
            if (this.fFormatId == null) {
                this.fProvider.setActiveFormat(this.fContext, this.fNodes, this.fViewerInput, this.fElementPaths, this.fFormatId);
                return;
            }
            if (this.isChecked()) {
                this.fProvider.setActiveFormat(this.fContext, this.fNodes, this.fViewerInput, this.fElementPaths, this.fFormatId);
            }
        }
    }
}

