/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.editor;

import com.nvidia.viper.editor.ISourceMappingRule;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.statushandlers.StatusManager;

public final class PrefixMapping
implements ISourceMappingRule {
    private final IPath prefix;
    private final URI uri;

    public PrefixMapping(IPath prefix, URI uri) {
        this.prefix = prefix;
        this.uri = uri;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ISourceMappingRule.SourceMapping map(URI sourceFile) {
        try {
            Path configured;
            IPath p;
            Path path = new Path(sourceFile.getPath());
            Object object = path.isAbsolute() ? (this.prefix != null ? this.prefix.makeAbsolute() : null) : (p = this.prefix);
            if (path.equals((Object)p)) {
                return new ISourceMappingRule.SourceMapping(this.uri, Integer.MAX_VALUE, true);
            }
            Path path2 = configured = this.uri == null ? null : new Path(this.uri.getPath());
            do {
                if (p.isPrefixOf((IPath)path)) {
                    URI result;
                    if (configured != null) {
                        result = new URI(this.uri.getScheme(), this.uri.getUserInfo(), this.uri.getHost(), this.uri.getPort(), configured.append(path.removeFirstSegments(p.segmentCount())).toString(), this.uri.getQuery(), this.uri.getFragment());
                        if (!PrefixMapping.isFileURI(result) || new File(result).exists()) return new ISourceMappingRule.SourceMapping(result, p.segmentCount(), false);
                        return null;
                    } else {
                        result = null;
                    }
                    return new ISourceMappingRule.SourceMapping(result, p.segmentCount(), false);
                }
                if (configured == null || !p.lastSegment().equals(configured.lastSegment())) {
                    return null;
                }
                configured = configured.removeLastSegments(1);
            } while ((p = p.removeLastSegments(1)).segmentCount() > 0 && configured != null && configured.segmentCount() > 0);
            return null;
        }
        catch (URISyntaxException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "com.nvidia.viper", sourceFile.toString(), (Throwable)e), 1);
            return null;
        }
    }

    public static boolean isFileURI(URI result) {
        String scheme = result.getScheme();
        return scheme == null || "file".equals(scheme);
    }

    public String toString() {
        return String.format("Map %s to %s", this.prefix, this.uri);
    }
}

