/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.remote.ui.connection;

import com.nvidia.common.util.CoreUtil;
import com.nvidia.common.util.DataBindingUtil;
import com.nvidia.common.util.SWTUtil;
import com.nvidia.common.wizards.PropertyDescriptor;
import com.nvidia.common.wizards.WizardContext;
import com.nvidia.cuda.ide.remote.connection.IRemoteConnection;
import com.nvidia.cuda.ide.remote.internal.connection.Activator;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.statushandlers.StatusManager;

public class ConnectionStateLabel {
    private final CLabel notConnectedLabel;
    private final Button connectButton;
    private final IObservableValue connectionObservable;
    private final IRunnableContext context;

    public ConnectionStateLabel(Composite parent, WizardContext context, PropertyDescriptor<IRemoteConnection> property) {
        this(parent, (IRunnableContext)context, context.observeProperty(property));
    }

    public ConnectionStateLabel(Composite parent, IRunnableContext context, IObservableValue connectionObservable) {
        this.context = context;
        this.connectionObservable = connectionObservable;
        this.notConnectedLabel = new CLabel(parent, 0);
        this.notConnectedLabel.setImage(SWTUtil.getImage((String)"IMG_OBJS_INFO_TSK"));
        Layout layout = parent.getLayout();
        if (layout instanceof GridLayout) {
            this.notConnectedLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, ((GridLayout)layout).numColumns - 1, 1));
        }
        this.notConnectedLabel.setText(String.format("Connection to %s was not established. Press connect to enable validation.", "haha"));
        this.connectButton = new Button(parent, 0);
        this.connectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConnectionStateLabel.this.connect();
            }
        });
        this.connectButton.setLayoutData((Object)new GridData(256));
        this.connectButton.setText("Connect");
    }

    public void bind(DataBindingContext bindingContext) {
        ComputedValue connectionState = new ComputedValue(String.class){

            protected Object calculate() {
                IRemoteConnection connection = ConnectionStateLabel.this.getConnection();
                if (connection == null) {
                    return "No remote connection established";
                }
                if (connection.isConnected(IRemoteConnection.Service.Files)) {
                    return null;
                }
                return String.format("%s is not connected. Remote paths will not be validated.", connection.getName());
            }
        };
        DataBindingUtil.bindBooleanToNotNull((DataBindingContext)bindingContext, (IObservableValue)connectionState, (IObservableValue[])new IObservableValue[]{SWTObservables.observeVisible((Control)this.notConnectedLabel), SWTObservables.observeVisible((Control)this.connectButton)});
        bindingContext.bindValue((IObservableValue)SWTObservables.observeText((Control)this.notConnectedLabel), (IObservableValue)connectionState);
    }

    protected void connect() {
        block4: {
            final IRemoteConnection connection = this.getConnection();
            if (connection != null && !connection.isConnected(IRemoteConnection.Service.Files)) {
                try {
                    this.context.run(true, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            try {
                                connection.connect(IRemoteConnection.Service.Files, monitor);
                            }
                            catch (CoreException e) {
                                if (e.getCause() instanceof OperationCanceledException) {
                                    CoreUtil.throwInterruptedException((Throwable)e.getCause());
                                }
                                IStatus status = CoreUtil.errorStatus((Throwable)e, (String)e.getMessage(), (Object[])new Object[0]);
                                StatusManager.getManager().handle(status, 3);
                            }
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    Activator.log(e);
                }
                catch (InterruptedException e) {
                    if (e.getCause() instanceof OperationCanceledException) break block4;
                    Activator.log(e);
                }
            }
        }
    }

    private IRemoteConnection getConnection() {
        return (IRemoteConnection)this.connectionObservable.getValue();
    }
}

