/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.actions;

import java.io.IOException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IResource;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.CompareUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.actions.RepositoryActionHandler;
import org.eclipse.egit.ui.internal.dialogs.CompareTargetSelectionDialog;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class CompareWithRefActionHandler
extends RepositoryActionHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Repository repo = this.getRepository(true, event);
        if (repo == null) {
            return null;
        }
        IResource[] resources = this.getSelectedResources(event);
        CompareTargetSelectionDialog dlg = new CompareTargetSelectionDialog(this.getShell(event), repo, resources.length == 1 ? resources[0].getFullPath().lastSegment() : null);
        if (dlg.open() != 0) {
            return null;
        }
        String refName = dlg.getRefName();
        IWorkbenchPage workBenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            CompareUtils.compare(resources, repo, "HEAD", refName, true, workBenchPage);
        }
        catch (IOException e) {
            Activator.handleError(UIText.CompareWithRefAction_errorOnSynchronize, e, true);
        }
        return null;
    }

    public boolean isEnabled() {
        return this.selectionMapsToSingleRepository();
    }
}

