/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history.command;

import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.egit.ui.internal.history.GitHistoryPage;
import org.eclipse.egit.ui.internal.history.command.AbstractHistoryCommandHandler;
import org.eclipse.egit.ui.internal.repository.CreateBranchWizard;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revplot.PlotCommit;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.ui.handlers.HandlerUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateBranchOnCommitHandler
extends AbstractHistoryCommandHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Repository repo = this.getRepository(event);
        IStructuredSelection selection = this.getSelection(event);
        CreateBranchWizard wiz = null;
        List<Ref> branches = this.getBranches(selection, repo);
        if (branches.isEmpty()) {
            PlotCommit commit = (PlotCommit)selection.getFirstElement();
            wiz = new CreateBranchWizard(repo, commit.name());
        } else {
            Collections.sort(branches, new Comparator<Ref>(){

                @Override
                public int compare(Ref o1, Ref o2) {
                    String refName1 = o1.getName();
                    String refName2 = o2.getName();
                    if (refName1.startsWith("refs/remotes/")) {
                        if (refName2.startsWith("refs/heads/")) {
                            return -1;
                        }
                        return refName1.compareTo(refName2);
                    }
                    if (refName2.startsWith("refs/remotes/")) {
                        return 1;
                    }
                    return refName1.compareTo(refName2);
                }
            });
            Ref branch = branches.get(0).getLeaf();
            wiz = new CreateBranchWizard(repo, branch.getName());
        }
        WizardDialog dlg = new WizardDialog(HandlerUtil.getActiveShellChecked((ExecutionEvent)event), (IWizard)wiz);
        dlg.setHelpAvailable(false);
        dlg.open();
        return null;
    }

    private List<Ref> getBranches(IStructuredSelection selection, Repository repo) {
        try {
            return this.getBranchesOfCommit(selection, repo, false);
        }
        catch (IOException iOException) {
            return Collections.emptyList();
        }
    }

    public boolean isEnabled() {
        GitHistoryPage page = this.getPage();
        if (page == null) {
            return false;
        }
        IStructuredSelection sel = this.getSelection(page);
        return sel.size() == 1 && sel.getFirstElement() instanceof RevCommit;
    }
}

