/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.debug.core.ICDebugger;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDISession;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.mi.core.IMILaunchConfigurationConstants;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MIPlugin;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.SharedLibraryManager;
import org.eclipse.cdt.debug.mi.core.cdi.model.Target;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;

public class GDBDebugger
implements ICDebugger {
    protected void initializeLibraries(ILaunchConfiguration config, Session session) throws CDIException {
        try {
            SharedLibraryManager mgr = session.getSharedLibraryManager();
            boolean autolib = config.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_AUTO_SOLIB, true);
            boolean stopOnSolibEvents = config.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_STOP_ON_SOLIB_EVENTS, false);
            List p = config.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_SOLIB_PATH, Collections.EMPTY_LIST);
            ICDITarget[] dtargets = session.getTargets();
            int i = 0;
            while (i < dtargets.length) {
                Target target = (Target)dtargets[i];
                try {
                    mgr.setAutoLoadSymbols(target, autolib);
                    mgr.setStopOnSolibEvents(target, stopOnSolibEvents);
                    if (autolib && !stopOnSolibEvents) {
                        mgr.setStopOnSolibEvents(target, true);
                        mgr.setDeferredBreakpoint(target, true);
                    }
                }
                catch (CDIException cDIException) {}
                if (p.size() > 0) {
                    String[] oldPaths = mgr.getSharedLibraryPaths(target);
                    String[] paths = new String[oldPaths.length + p.size()];
                    System.arraycopy(p.toArray(new String[p.size()]), 0, paths, 0, p.size());
                    System.arraycopy(oldPaths, 0, paths, p.size(), oldPaths.length);
                    mgr.setSharedLibraryPaths(target, paths);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            throw new CDIException(String.valueOf(MIPlugin.getResourceString("src.GDBDebugger.Error_initializing_shared_lib_options")) + e.getMessage());
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ICDISession createLaunchSession(ILaunchConfiguration config, IFile exe) throws CDIException {
        Session session;
        Session session2 = null;
        boolean failed = false;
        try {
            String gdb = config.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUG_NAME, "gdb");
            String miVersion = config.getAttribute("org.eclipse.cdt.launch.protocol", "mi");
            File cwd = exe.getProject().getLocation().toFile();
            String gdbinit = config.getAttribute(IMILaunchConfigurationConstants.ATTR_GDB_INIT, ".gdbinit");
            session2 = MIPlugin.getDefault().createCSession(gdb, miVersion, exe.getLocation().toFile(), cwd, gdbinit, null);
            this.initializeLibraries(config, session2);
            session = session2;
            if (!failed) return session;
            if (session2 == null) return session;
        }
        catch (IOException e) {
            try {
                failed = true;
                throw new CDIException(String.valueOf(MIPlugin.getResourceString("src.GDBDebugger.Error_creating_session")) + e.getMessage());
                catch (MIException e2) {
                    failed = true;
                    throw new CDIException(String.valueOf(MIPlugin.getResourceString("src.GDBDebugger.Error_creating_session")) + e2.getMessage());
                }
                catch (CoreException e3) {
                    failed = true;
                    throw new CDIException(String.valueOf(MIPlugin.getResourceString("src.GDBDebugger.Error_creating_session")) + e3.getMessage());
                }
            }
            catch (Throwable throwable) {
                if (!failed) throw throwable;
                if (session2 == null) throw throwable;
                try {
                    session2.terminate();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
        }
        try {
            session2.terminate();
            return session;
        }
        catch (Exception exception) {}
        return session;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ICDISession createAttachSession(ILaunchConfiguration config, IFile exe, int pid) throws CDIException {
        Session session;
        Session session2 = null;
        boolean failed = false;
        try {
            String gdb = config.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUG_NAME, "gdb");
            String miVersion = config.getAttribute("org.eclipse.cdt.launch.protocol", "mi");
            File cwd = exe.getProject().getLocation().toFile();
            String gdbinit = config.getAttribute(IMILaunchConfigurationConstants.ATTR_GDB_INIT, ".gdbinit");
            session2 = MIPlugin.getDefault().createCSession(gdb, miVersion, exe.getLocation().toFile(), pid, null, cwd, gdbinit, null);
            this.initializeLibraries(config, session2);
            session = session2;
            if (!failed) return session;
            if (session2 == null) return session;
        }
        catch (IOException e) {
            try {
                failed = true;
                throw new CDIException(String.valueOf(MIPlugin.getResourceString("src.GDBDebugger.Error_creating_session")) + e.getMessage());
                catch (MIException e2) {
                    failed = true;
                    throw new CDIException(String.valueOf(MIPlugin.getResourceString("src.GDBDebugger.Error_creating_session")) + e2.getMessage());
                }
                catch (CoreException e3) {
                    failed = true;
                    throw new CDIException(String.valueOf(MIPlugin.getResourceString("src.GDBDebugger.Error_creating_session")) + e3.getMessage());
                }
            }
            catch (Throwable throwable) {
                if (!failed) throw throwable;
                if (session2 == null) throw throwable;
                try {
                    session2.terminate();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
        }
        try {
            session2.terminate();
            return session;
        }
        catch (Exception exception) {}
        return session;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ICDISession createCoreSession(ILaunchConfiguration config, IFile exe, IPath corefile) throws CDIException {
        Session session;
        Session session2 = null;
        boolean failed = false;
        try {
            String gdb = config.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUG_NAME, "gdb");
            String miVersion = config.getAttribute("org.eclipse.cdt.launch.protocol", "mi");
            File cwd = exe.getProject().getLocation().toFile();
            String gdbinit = config.getAttribute(IMILaunchConfigurationConstants.ATTR_GDB_INIT, ".gdbinit");
            session2 = MIPlugin.getDefault().createCSession(gdb, miVersion, exe.getLocation().toFile(), corefile.toFile(), cwd, gdbinit, null);
            this.initializeLibraries(config, session2);
            session = session2;
            if (!failed) return session;
            if (session2 == null) return session;
        }
        catch (IOException e) {
            try {
                failed = true;
                throw new CDIException(String.valueOf(MIPlugin.getResourceString("src.GDBDebugger.Error_creating_session")) + e.getMessage());
                catch (MIException e2) {
                    failed = true;
                    throw new CDIException(String.valueOf(MIPlugin.getResourceString("src.GDBDebugger.Error_creating_session")) + e2.getMessage());
                }
                catch (CoreException e3) {
                    failed = true;
                    throw new CDIException(String.valueOf(MIPlugin.getResourceString("src.GDBDebugger.Error_creating_session")) + e3.getMessage());
                }
            }
            catch (Throwable throwable) {
                if (!failed) throw throwable;
                if (session2 == null) throw throwable;
                try {
                    session2.terminate();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
        }
        try {
            session2.terminate();
            return session;
        }
        catch (Exception exception) {}
        return session;
    }
}

