/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.util;

import org.eclipse.birt.report.model.api.IVersionInfo;
import org.eclipse.birt.report.model.i18n.ModelMessages;

public class VersionInfo
implements IVersionInfo {
    private String version = null;
    private int infoCode = -1;
    private static final String INVALID_DESIGN_FILE_MSG = "Info.VersionInfo.INVALID_DESIGN_FILE";
    private static final String CONVERT_INFO_MSG = "Info.VersionInfo.CONVERT_INFO";
    private static final String EXTENSION_COMPATIBILITY_MSG = "Info.VersionInfo.EXTENSION_COMPATIBILITY";
    public static final int INVALID_DESIGN_FILE = 0;
    public static final int CONVERT_FOR_COLUMN_BINDING = 1;
    public static final int INVALID_VERSION = 2;
    public static final int LATER_VERSION = 3;
    public static final int EXTENSION_COMPATIBILITY = 4;
    private static final String INVALID_VERSION_MSG = "Info.VersionInfo.INVALID_VERSION";
    private static final String LATER_VERSION_MSG = "Info.VersionInfo.LATER_VERSION";
    public static final int COLUMN_BINDING_FROM_VERSION = 3000000;
    public static final String COLUMN_BINDING_FEATURE = "column binding";

    public VersionInfo(String version, int convertCode) {
        this.version = version;
        this.infoCode = convertCode;
    }

    @Override
    public String getLocalizedMessage() {
        switch (this.infoCode) {
            case 1: {
                return ModelMessages.getMessage(CONVERT_INFO_MSG);
            }
            case 0: {
                return ModelMessages.getMessage(INVALID_DESIGN_FILE_MSG);
            }
            case 2: {
                return ModelMessages.getMessage(INVALID_VERSION_MSG, new String[]{this.version});
            }
            case 3: {
                return ModelMessages.getMessage(LATER_VERSION_MSG);
            }
            case 4: {
                return ModelMessages.getMessage(EXTENSION_COMPATIBILITY_MSG);
            }
        }
        assert (false);
        return null;
    }

    @Override
    public String getDesignFileVersion() {
        return this.version;
    }

    public int getInfoCode() {
        return this.infoCode;
    }
}

