/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.wizard.samples;

import com.nvidia.cuda.ide.wizard.samples.ProjectSample;
import com.nvidia.cuda.ide.wizard.samples.SamplesModel;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;

public final class SamplesCategory {
    private final String label;
    private final SamplesModel model;
    private final int weight;
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public SamplesCategory(SamplesModel model) {
        this.model = model;
        this.weight = Integer.MIN_VALUE;
        this.label = "All Samples";
    }

    public SamplesCategory(SamplesModel model, String string) {
        this.model = model;
        String label = string.trim();
        int underscore = label.indexOf("_");
        if (underscore < 0) {
            this.weight = Integer.MAX_VALUE;
            this.label = label.trim();
        } else {
            this.weight = Integer.parseInt(label.substring(0, underscore).trim());
            this.label = label.substring(underscore + 1).trim();
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SamplesCategory other = (SamplesCategory)obj;
        if (this.label == null) {
            return other.label == null;
        }
        return this.label.equals(other.label);
    }

    public String getLabel() {
        return this.label;
    }

    public Collection<ProjectSample> getSamples() {
        return this.innerGetSamples();
    }

    protected Set<ProjectSample> innerGetSamples() {
        Collection<ProjectSample> allSamples = this.model.getSamples();
        if (this.weight == Integer.MIN_VALUE) {
            return new TreeSet<ProjectSample>(allSamples);
        }
        TreeSet<ProjectSample> categorized = new TreeSet<ProjectSample>();
        for (ProjectSample projectSample : allSamples) {
            if (!projectSample.getCategory().equals(this)) continue;
            categorized.add(projectSample);
        }
        return categorized;
    }

    public String toString() {
        return this.weight > Integer.MIN_VALUE ? String.format("%d_%s", this.weight, this.label) : this.label;
    }

    public int getWeight() {
        return this.weight;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
        return result;
    }

    public void refresh() {
        this.propertyChangeSupport.firePropertyChange("samples", null, null);
        this.propertyChangeSupport.firePropertyChange("empty", null, null);
    }

    public final void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public final void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public boolean isEmpty() {
        return this.getSamples().isEmpty();
    }
}

