/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IArrayType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.ISemanticProblem;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTAliasDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTAmbiguousTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTExplicitTemplateInstantiation;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNameSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTSimpleTypeTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplatedTypeTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPAliasTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPAliasTemplateInstance;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplatePartialSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPEnumeration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPEnumerationSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameterPackType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPPointerToMemberType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateInstance;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateNonTypeParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateTypeParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPUnaryTypeTransformation;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPUsingDeclaration;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.CharArraySet;
import org.eclipse.cdt.core.parser.util.ObjectMap;
import org.eclipse.cdt.internal.core.dom.parser.ASTAmbiguousNode;
import org.eclipse.cdt.internal.core.dom.parser.ASTInternal;
import org.eclipse.cdt.internal.core.dom.parser.ASTQueries;
import org.eclipse.cdt.internal.core.dom.parser.IASTInternalScope;
import org.eclipse.cdt.internal.core.dom.parser.ITypeContainer;
import org.eclipse.cdt.internal.core.dom.parser.ProblemBinding;
import org.eclipse.cdt.internal.core.dom.parser.ProblemType;
import org.eclipse.cdt.internal.core.dom.parser.Value;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPAliasTemplateInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPArrayType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPClassInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPClassSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPClassTemplatePartialSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPClassTemplatePartialSpecializationSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPClassTemplateSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPConstructorInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPConstructorSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPConstructorTemplateSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPDeferredClassInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPDeferredFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPEnumerationSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPEnumeratorSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFieldSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFunctionInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFunctionSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFunctionTemplateSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFunctionType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPMethodInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPMethodSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPMethodTemplateSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPParameterPackType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPParameterSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPPointerToMemberType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPPointerType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateDefinition;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateNonTypeArgument;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateNonTypeParameter;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateNonTypeParameterSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateParameterMap;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateTemplateParameter;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateTemplateParameterSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateTypeArgument;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateTypeParameter;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateTypeParameterSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTypedefSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPUnknownClassInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPUnknownMemberClass;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPUnknownMethod;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPUsingDeclarationSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPASTInternalTemplateDeclaration;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPDeferredClassInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInstanceCache;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalClassTemplate;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownMember;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownMemberClass;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownMemberClassInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPFunctionSet;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.Conversions;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.Cost;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.FunctionSetType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.InitializerListType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.TemplateArgumentDeduction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.TypeOfDependentExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.TypeTraits;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.UniqueType;

public class CPPTemplates {
    static final int PACK_SIZE_DEFER = -1;
    static final int PACK_SIZE_FAIL = -2;
    static final int PACK_SIZE_NOT_FOUND = Integer.MAX_VALUE;

    public static IBinding instantiate(ICPPClassTemplate template, ICPPTemplateArgument[] args, IASTNode point) {
        return CPPTemplates.instantiate(template, args, false, false, point);
    }

    private static IBinding instantiate(ICPPClassTemplate template, ICPPTemplateArgument[] args, boolean isDefinition, boolean isExplicitSpecialization, IASTNode point) {
        try {
            IBinding result;
            ICPPTemplateInstance prim;
            ICPPTemplateArgument[] arguments = SemanticUtil.getSimplifiedArguments(args);
            arguments = CPPTemplates.addDefaultArguments(template, arguments, point);
            if (arguments == null) {
                return CPPTemplates.createProblem(template, 15, point);
            }
            if (template instanceof ICPPTemplateTemplateParameter || CPPTemplates.hasDependentArgument(arguments)) {
                return CPPTemplates.deferredInstance(template, arguments);
            }
            if (template instanceof ICPPClassTemplatePartialSpecialization) {
                return CPPTemplates.instantiatePartialSpecialization((ICPPClassTemplatePartialSpecialization)template, arguments, isDefinition, null, point);
            }
            ICPPTemplateParameter[] parameters = template.getTemplateParameters();
            int numArgs = arguments.length;
            int numParams = parameters.length;
            int length = Math.max(numArgs, numParams);
            CPPTemplateParameterMap map = new CPPTemplateParameterMap(numParams);
            boolean isPack = false;
            ICPPTemplateParameter param = null;
            int i = 0;
            while (i < length) {
                if (!isPack || param == null) {
                    if (i < numParams) {
                        param = parameters[i];
                        isPack = param.isParameterPack();
                    } else {
                        return CPPTemplates.createProblem(template, 15, point);
                    }
                }
                if (i < numArgs) {
                    ICPPTemplateArgument arg = arguments[i];
                    ICPPTemplateArgument newArg = CPPTemplates.matchTemplateParameterAndArgument(template, param, arg, map, point);
                    if (newArg == null) {
                        return CPPTemplates.createProblem(template, 15, point);
                    }
                    if (newArg != arg) {
                        if (arguments == args) {
                            arguments = (ICPPTemplateArgument[])args.clone();
                        }
                        arguments[i] = newArg;
                    }
                    if (!isPack) {
                        map.put(param, newArg);
                    }
                } else assert (isPack);
                ++i;
            }
            if (isPack) {
                int packOffset = numParams - 1;
                int packSize = numArgs - packOffset;
                ICPPTemplateArgument[] pack = new ICPPTemplateArgument[packSize];
                System.arraycopy(arguments, packOffset, pack, 0, packSize);
                map.put(param, pack);
            }
            if ((prim = CPPTemplates.getInstance(template, arguments, isDefinition)) != null && (isExplicitSpecialization || prim.isExplicitSpecialization())) {
                return prim;
            }
            if (!isExplicitSpecialization && (result = CPPTemplates.selectSpecialization(template, arguments, isDefinition, point)) != null) {
                return result;
            }
            return CPPTemplates.instantiatePrimaryTemplate(template, arguments, map, isDefinition, point);
        }
        catch (DOMException e) {
            return e.getProblem();
        }
    }

    private static IBinding createProblem(ICPPClassTemplate template, int id, IASTNode point) {
        return new ProblemBinding(point, id, template.getNameCharArray());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static IBinding isUsedInClassTemplateScope(ICPPClassTemplate ct, IASTName name) {
        try {
            IScope scope = null;
            IASTNode node = name;
            while (node != null) {
                if (node.getPropertyInParent() == IASTCompositeTypeSpecifier.TYPE_NAME) {
                    return null;
                }
                if (node instanceof IASTFunctionDefinition) {
                    IASTName functionName = ASTQueries.findInnermostDeclarator(((IASTFunctionDefinition)node).getDeclarator()).getName().getLastName();
                    if (functionName.getParent() instanceof ICPPASTQualifiedName && ASTQueries.isAncestorOf(functionName.getParent(), name)) {
                        return null;
                    }
                    scope = CPPVisitor.getContainingScope(functionName);
                    break;
                }
                if (node instanceof ICPPASTCompositeTypeSpecifier) {
                    scope = ((ICPPASTCompositeTypeSpecifier)node).getScope();
                    break;
                }
                node = node.getParent();
            }
            while (scope != null) {
                if (scope instanceof ISemanticProblem) {
                    return null;
                }
                if (scope instanceof ICPPClassScope) {
                    ICPPClassSpecialization specialization;
                    ICPPClassType b = ((ICPPClassScope)scope).getClassType();
                    if (b != null && ct.isSameType(b)) {
                        return ct;
                    }
                    if (b instanceof ICPPClassTemplatePartialSpecialization) {
                        ICPPClassTemplatePartialSpecialization pspec = (ICPPClassTemplatePartialSpecialization)b;
                        if (ct.isSameType(pspec.getPrimaryClassTemplate())) {
                            return pspec;
                        }
                    } else if (b instanceof ICPPClassSpecialization && ct.isSameType((specialization = (ICPPClassSpecialization)b).getSpecializedBinding())) {
                        return specialization;
                    }
                }
                if (scope instanceof IASTInternalScope) {
                    IASTInternalScope internalScope = (IASTInternalScope)scope;
                    IASTNode physicalNode = internalScope.getPhysicalNode();
                    if (physicalNode instanceof ICPPASTCompositeTypeSpecifier && ((ICPPASTCompositeTypeSpecifier)physicalNode).getName() instanceof ICPPASTQualifiedName) {
                        scope = scope.getParent();
                        continue;
                    }
                    scope = CPPVisitor.getContainingScope(physicalNode);
                    if (scope != internalScope) continue;
                    return null;
                }
                scope = scope.getParent();
            }
            return null;
        }
        catch (DOMException dOMException) {}
        return null;
    }

    private static IBinding instantiateFunctionTemplate(ICPPFunctionTemplate template, ICPPTemplateArgument[] arguments, CPPTemplateParameterMap map, IASTNode point) throws DOMException {
        ICPPTemplateInstance instance = CPPTemplates.getInstance(template, arguments, false);
        if (instance != null) {
            return instance;
        }
        IBinding owner = template.getOwner();
        instance = CPPTemplates.createInstance(owner, template, map, arguments, point);
        if (instance instanceof ICPPFunction && SemanticUtil.isValidType(((ICPPFunction)((Object)instance)).getType())) {
            CPPTemplates.addInstance(template, arguments, instance);
        }
        return instance;
    }

    private static IBinding instantiatePartialSpecialization(ICPPClassTemplatePartialSpecialization partialSpec, ICPPTemplateArgument[] args, boolean isDef, CPPTemplateParameterMap tpMap, IASTNode point) throws DOMException {
        ICPPTemplateInstance instance = CPPTemplates.getInstance(partialSpec, args, isDef);
        if (instance != null) {
            return instance;
        }
        if (tpMap == null) {
            tpMap = new CPPTemplateParameterMap(args.length);
            if (!TemplateArgumentDeduction.fromTemplateArguments(partialSpec.getTemplateParameters(), partialSpec.getTemplateArguments(), args, tpMap, point)) {
                return null;
            }
        }
        instance = CPPTemplates.createInstance(partialSpec.getOwner(), partialSpec, tpMap, args, point);
        CPPTemplates.addInstance(partialSpec, args, instance);
        return instance;
    }

    private static IBinding instantiatePrimaryTemplate(ICPPClassTemplate template, ICPPTemplateArgument[] arguments, CPPTemplateParameterMap map, boolean isDef, IASTNode point) throws DOMException {
        assert (!(template instanceof ICPPClassTemplatePartialSpecialization));
        ICPPTemplateInstance instance = CPPTemplates.getInstance(template, arguments, isDef);
        if (instance != null) {
            return instance;
        }
        IBinding owner = template.getOwner();
        instance = CPPTemplates.createInstance(owner, template, map, arguments, point);
        CPPTemplates.addInstance(template, arguments, instance);
        return instance;
    }

    private static ICPPTemplateInstance getInstance(ICPPTemplateDefinition template, ICPPTemplateArgument[] args, boolean forDefinition) {
        if (template instanceof ICPPInstanceCache) {
            ICPPTemplateInstance result = ((ICPPInstanceCache)((Object)template)).getInstance(args);
            if (forDefinition && result instanceof IIndexBinding) {
                return null;
            }
            return result;
        }
        return null;
    }

    private static void addInstance(ICPPTemplateDefinition template, ICPPTemplateArgument[] args, ICPPTemplateInstance instance) {
        if (template instanceof ICPPInstanceCache) {
            ((ICPPInstanceCache)((Object)template)).addInstance(args, instance);
        }
    }

    private static IBinding deferredInstance(ICPPClassTemplate template, ICPPTemplateArgument[] arguments) throws DOMException {
        ICPPTemplateInstance instance = CPPTemplates.getInstance(template, arguments, false);
        if (instance != null) {
            return instance;
        }
        instance = new CPPDeferredClassInstance(template, arguments);
        CPPTemplates.addInstance(template, arguments, instance);
        return instance;
    }

    private static ICPPTemplateArgument[] addDefaultArguments(ICPPTemplateDefinition template, ICPPTemplateArgument[] arguments, IASTNode point) throws DOMException {
        int argCount;
        if (template instanceof ICPPClassTemplatePartialSpecialization) {
            return arguments;
        }
        boolean havePackExpansion = false;
        int i = 0;
        while (i < arguments.length) {
            ICPPTemplateArgument arg = arguments[i];
            if (arg.isPackExpansion()) {
                if (i != arguments.length - 1) {
                    return arguments;
                }
                havePackExpansion = true;
            }
            ++i;
        }
        ICPPTemplateParameter[] tpars = template.getTemplateParameters();
        int tparCount = tpars.length;
        if (tparCount == (argCount = arguments.length)) {
            return arguments;
        }
        if (tparCount == 0) {
            return null;
        }
        if (tparCount < argCount) {
            if (tpars[tparCount - 1].isParameterPack()) {
                return arguments;
            }
            if (havePackExpansion && tparCount + 1 == argCount) {
                return arguments;
            }
            return null;
        }
        if (havePackExpansion) {
            return arguments;
        }
        if (tpars[tparCount - 1].isParameterPack()) {
            --tparCount;
        }
        if (tparCount == argCount) {
            return arguments;
        }
        ICPPTemplateArgument[] completeArgs = new ICPPTemplateArgument[tparCount];
        CPPTemplateParameterMap map = new CPPTemplateParameterMap(tparCount);
        int i2 = 0;
        while (i2 < tparCount) {
            ICPPTemplateArgument arg;
            ICPPTemplateParameter tpar = tpars[i2];
            if (tpar.isParameterPack()) {
                return null;
            }
            if (i2 < argCount) {
                arg = arguments[i2];
            } else {
                ICPPTemplateArgument defaultArg = tpar.getDefaultValue();
                if (defaultArg == null && template instanceof ICPPInternalClassTemplate) {
                    defaultArg = ((ICPPInternalClassTemplate)((Object)template)).getDefaultArgFromIndex(i2);
                }
                if (defaultArg == null) {
                    return null;
                }
                arg = CPPTemplates.instantiateArgument(defaultArg, map, -1, null, point);
                if (!CPPTemplates.isValidArgument(arg = SemanticUtil.getSimplifiedArgument(arg))) {
                    return null;
                }
            }
            map.put(tpar, arg);
            completeArgs[i2] = arg;
            ++i2;
        }
        return completeArgs;
    }

    public static ICPPDeferredClassInstance createDeferredInstance(ICPPClassTemplate ct) {
        ICPPTemplateArgument[] args = ct instanceof ICPPClassTemplatePartialSpecialization ? ((ICPPClassTemplatePartialSpecialization)ct).getTemplateArguments() : CPPTemplates.templateParametersAsArguments(ct);
        return new CPPDeferredClassInstance(ct, args, (ICPPScope)ct.getCompositeScope());
    }

    public static ICPPTemplateArgument[] templateParametersAsArguments(ICPPClassTemplate template) {
        ICPPTemplateParameter[] tpars = template.getTemplateParameters();
        ICPPTemplateArgument[] args = new ICPPTemplateArgument[tpars.length];
        int i = 0;
        while (i < tpars.length) {
            ICPPTemplateParameter tp = tpars[i];
            if (tp instanceof IType) {
                IType t = (IType)((Object)tp);
                if (tp.isParameterPack()) {
                    t = new CPPParameterPackType(t);
                }
                args[i] = new CPPTemplateTypeArgument(t);
            } else if (tp instanceof ICPPTemplateNonTypeParameter) {
                ICPPTemplateNonTypeParameter nttp = (ICPPTemplateNonTypeParameter)tp;
                args[i] = new CPPTemplateNonTypeArgument(Value.create(template, nttp), nttp.getType());
            } else assert (false);
            ++i;
        }
        return args;
    }

    public static IASTName getTemplateParameterName(ICPPASTTemplateParameter param) {
        if (param instanceof ICPPASTSimpleTypeTemplateParameter) {
            return ((ICPPASTSimpleTypeTemplateParameter)param).getName();
        }
        if (param instanceof ICPPASTTemplatedTypeTemplateParameter) {
            return ((ICPPASTTemplatedTypeTemplateParameter)param).getName();
        }
        if (param instanceof ICPPASTParameterDeclaration) {
            return ASTQueries.findInnermostDeclarator(((ICPPASTParameterDeclaration)param).getDeclarator()).getName();
        }
        return null;
    }

    public static ICPPTemplateDefinition getContainingTemplate(ICPPASTTemplateParameter param) {
        IASTNode parent = param.getParent();
        IBinding binding = null;
        if (parent instanceof ICPPASTTemplateDeclaration) {
            ICPPASTTemplateDeclaration[] templates = new ICPPASTTemplateDeclaration[]{(ICPPASTTemplateDeclaration)parent};
            while (parent.getParent() instanceof ICPPASTTemplateDeclaration) {
                parent = parent.getParent();
                templates = ArrayUtil.append(ICPPASTTemplateDeclaration.class, templates, (ICPPASTTemplateDeclaration)parent);
            }
            templates = ArrayUtil.trim(ICPPASTTemplateDeclaration.class, templates);
            ICPPASTTemplateDeclaration templateDeclaration = templates[0];
            IASTDeclaration decl = templateDeclaration.getDeclaration();
            while (decl instanceof ICPPASTTemplateDeclaration) {
                decl = ((ICPPASTTemplateDeclaration)decl).getDeclaration();
            }
            IASTName name = null;
            if (decl instanceof IASTSimpleDeclaration) {
                IASTSimpleDeclaration simpleDecl = (IASTSimpleDeclaration)decl;
                IASTDeclarator[] dtors = ((IASTSimpleDeclaration)decl).getDeclarators();
                if (dtors.length == 0) {
                    IASTDeclSpecifier spec = simpleDecl.getDeclSpecifier();
                    if (spec instanceof ICPPASTCompositeTypeSpecifier) {
                        name = ((ICPPASTCompositeTypeSpecifier)spec).getName();
                    } else if (spec instanceof ICPPASTElaboratedTypeSpecifier) {
                        name = ((ICPPASTElaboratedTypeSpecifier)spec).getName();
                    }
                } else {
                    IASTDeclarator dtor = dtors[0];
                    dtor = ASTQueries.findInnermostDeclarator(dtor);
                    name = dtor.getName();
                }
            } else if (decl instanceof IASTFunctionDefinition) {
                IASTDeclarator dtor = ((IASTFunctionDefinition)decl).getDeclarator();
                dtor = ASTQueries.findInnermostDeclarator(dtor);
                name = dtor.getName();
            } else if (decl instanceof ICPPASTAliasDeclaration) {
                name = ((ICPPASTAliasDeclaration)decl).getAlias();
            }
            if (name == null) {
                return null;
            }
            if (name instanceof ICPPASTQualifiedName) {
                ICPPASTNameSpecifier[] qualifier;
                int idx = templates.length;
                int i = 0;
                ICPPASTNameSpecifier[] iCPPASTNameSpecifierArray = qualifier = ((ICPPASTQualifiedName)name).getQualifier();
                int n = qualifier.length;
                int n2 = 0;
                while (n2 < n) {
                    ICPPASTNameSpecifier element = iCPPASTNameSpecifierArray[n2];
                    if (element instanceof ICPPASTTemplateId && ++i == idx) {
                        binding = ((ICPPASTTemplateId)element).resolveBinding();
                        break;
                    }
                    ++n2;
                }
                if (binding == null) {
                    binding = name.getLastName().resolveBinding();
                }
            } else {
                binding = name.resolveBinding();
            }
        } else if (parent instanceof ICPPASTTemplatedTypeTemplateParameter) {
            ICPPASTTemplatedTypeTemplateParameter templatedParam = (ICPPASTTemplatedTypeTemplateParameter)parent;
            binding = templatedParam.getName().resolveBinding();
        }
        return binding instanceof ICPPTemplateDefinition ? (ICPPTemplateDefinition)binding : null;
    }

    public static IBinding createBinding(ICPPASTTemplateParameter tp) {
        if (tp instanceof ICPPASTSimpleTypeTemplateParameter) {
            return new CPPTemplateTypeParameter(((ICPPASTSimpleTypeTemplateParameter)tp).getName(), tp.isParameterPack());
        }
        if (tp instanceof ICPPASTTemplatedTypeTemplateParameter) {
            return new CPPTemplateTemplateParameter(((ICPPASTTemplatedTypeTemplateParameter)tp).getName(), tp.isParameterPack());
        }
        assert (tp instanceof ICPPASTParameterDeclaration);
        ICPPASTDeclarator dtor = ((ICPPASTParameterDeclaration)tp).getDeclarator();
        return new CPPTemplateNonTypeParameter(ASTQueries.findInnermostDeclarator(dtor).getName());
    }

    public static IBinding createBinding(ICPPASTTemplateId id) {
        IASTNode declaration;
        if (!CPPTemplates.isClassTemplate(id)) {
            IBinding result = CPPVisitor.createBinding(id);
            IASTName templateName = id.getTemplateName();
            if (result instanceof ICPPClassTemplate) {
                templateName.setBinding(result);
                id.setBinding(null);
            } else {
                if (result instanceof ICPPTemplateInstance) {
                    templateName.setBinding(((ICPPTemplateInstance)result).getTemplateDefinition());
                } else {
                    templateName.setBinding(result);
                }
                return result;
            }
        }
        IASTNode parentOfName = id.getParent();
        boolean isLastName = true;
        if (parentOfName instanceof ICPPASTQualifiedName) {
            isLastName = ((ICPPASTQualifiedName)parentOfName).getLastName() == id;
            parentOfName = parentOfName.getParent();
        }
        boolean isDeclaration = false;
        boolean isDefinition = false;
        boolean isExplicitSpecialization = false;
        if (isLastName && parentOfName != null && (declaration = parentOfName.getParent()) instanceof IASTSimpleDeclaration) {
            if (parentOfName instanceof ICPPASTElaboratedTypeSpecifier) {
                isDeclaration = true;
            } else if (parentOfName instanceof ICPPASTCompositeTypeSpecifier) {
                isDefinition = true;
            }
            if (isDeclaration || isDefinition) {
                IASTNode parentOfDeclaration = declaration.getParent();
                if (parentOfDeclaration instanceof ICPPASTExplicitTemplateInstantiation) {
                    isDeclaration = false;
                } else if (parentOfDeclaration instanceof ICPPASTTemplateSpecialization) {
                    isExplicitSpecialization = true;
                }
            }
        }
        try {
            ICPPASTTemplateDeclaration tdecl;
            IBinding result = null;
            IASTName templateName = id.getTemplateName();
            IBinding template = templateName.resolvePreBinding();
            if (template instanceof ICPPAliasTemplate) {
                ICPPAliasTemplate aliasTemplate = (ICPPAliasTemplate)template;
                ICPPTemplateArgument[] args = CPPTemplates.createTemplateArgumentArray(id);
                args = CPPTemplates.addDefaultArguments(aliasTemplate, args, id);
                ICPPTemplateParameterMap parameterMap = CPPTemplates.createParameterMap(aliasTemplate, args);
                IType aliasedType = aliasTemplate.getType();
                IBinding owner = template.getOwner();
                return CPPTemplates.createAliasTemplaceInstance(aliasTemplate, args, parameterMap, aliasedType, owner, id);
            }
            if (template instanceof ICPPAliasTemplateInstance) {
                ICPPAliasTemplateInstance aliasTemplateInstance = (ICPPAliasTemplateInstance)template;
                ICPPTemplateArgument[] args = CPPTemplates.createTemplateArgumentArray(id);
                ICPPAliasTemplate aliasTemplate = aliasTemplateInstance.getTemplateDefinition();
                args = CPPTemplates.addDefaultArguments(aliasTemplate, args, id);
                ICPPTemplateParameterMap parameterMap = CPPTemplates.createParameterMap(aliasTemplate, args);
                IType aliasedType = aliasTemplateInstance.getType();
                IBinding owner = aliasTemplateInstance.getOwner();
                return CPPTemplates.createAliasTemplaceInstance(aliasTemplate, args, parameterMap, aliasedType, owner, id);
            }
            if (template instanceof ICPPConstructor) {
                template = template.getOwner();
            }
            if (template instanceof ICPPUnknownMemberClass) {
                IType owner = ((ICPPUnknownMemberClass)template).getOwnerType();
                ICPPTemplateArgument[] args = CPPTemplates.createTemplateArgumentArray(id);
                args = SemanticUtil.getSimplifiedArguments(args);
                return new CPPUnknownClassInstance(owner, id.getSimpleID(), args);
            }
            if (!(template instanceof ICPPClassTemplate) || template instanceof ICPPClassTemplatePartialSpecialization) {
                return new ProblemBinding((IASTNode)id, 5, templateName.toCharArray());
            }
            ICPPClassTemplate classTemplate = (ICPPClassTemplate)template;
            ICPPTemplateArgument[] args = CPPTemplates.createTemplateArgumentArray(id);
            if (CPPTemplates.hasDependentArgument(args) && (tdecl = CPPTemplates.getTemplateDeclaration(id)) != null) {
                if (CPPTemplates.argsAreTrivial(classTemplate.getTemplateParameters(), args)) {
                    result = classTemplate;
                } else {
                    if ((args = CPPTemplates.addDefaultArguments(classTemplate, args, id)) == null) {
                        return new ProblemBinding((IASTNode)id, 15, templateName.toCharArray());
                    }
                    ICPPClassTemplatePartialSpecialization partialSpec = CPPTemplates.findPartialSpecialization(classTemplate, args);
                    if ((isDeclaration || isDefinition) && partialSpec == null) {
                        partialSpec = new CPPClassTemplatePartialSpecialization(id, args);
                        if (template instanceof ICPPInternalClassTemplate) {
                            ((ICPPInternalClassTemplate)template).addPartialSpecialization(partialSpec);
                        }
                        return partialSpec;
                    }
                    if (partialSpec == null) {
                        return new ProblemBinding((IASTNode)id, 5, templateName.toCharArray());
                    }
                    result = partialSpec;
                }
            }
            if (result == null && (result = CPPTemplates.instantiate(classTemplate, args, isDefinition, isExplicitSpecialization, id)) instanceof ICPPInternalBinding) {
                if (isDeclaration) {
                    ASTInternal.addDeclaration(result, id);
                } else if (isDefinition) {
                    ASTInternal.addDefinition(result, id);
                }
            }
            return CPPSemantics.postResolution(result, id);
        }
        catch (DOMException e) {
            return e.getProblem();
        }
    }

    private static IBinding createAliasTemplaceInstance(ICPPAliasTemplate aliasTemplate, ICPPTemplateArgument[] args, ICPPTemplateParameterMap parameterMap, IType aliasedType, IBinding owner, ICPPASTTemplateId id) {
        ICPPClassSpecialization within = CPPTemplates.getSpecializationContext(owner);
        IType instantiatedType = CPPTemplates.instantiateType(aliasedType, parameterMap, -1, within, id);
        StringBuilder buf = new StringBuilder();
        buf.append(id.getSimpleID()).append(ASTTypeUtil.getArgumentListString(args, false));
        char[] name = new char[buf.length()];
        buf.getChars(0, buf.length(), name, 0);
        return new CPPAliasTemplateInstance(name, aliasTemplate, instantiatedType);
    }

    static boolean isClassTemplate(ICPPASTTemplateId id) {
        IASTNode parentOfName = id.getParent();
        if (parentOfName instanceof ICPPASTQualifiedName) {
            if (((ICPPASTQualifiedName)parentOfName).getLastName() != id) {
                return true;
            }
            parentOfName = parentOfName.getParent();
        }
        if (parentOfName instanceof ICPPASTElaboratedTypeSpecifier || parentOfName instanceof ICPPASTCompositeTypeSpecifier || parentOfName instanceof ICPPASTNamedTypeSpecifier || parentOfName instanceof ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier) {
            return true;
        }
        if (parentOfName instanceof IASTDeclarator) {
            IASTDeclarator rel = ASTQueries.findTypeRelevantDeclarator((IASTDeclarator)parentOfName);
            return !(rel instanceof IASTFunctionDeclarator);
        }
        return false;
    }

    public static ICPPTemplateInstance createInstance(IBinding owner, ICPPTemplateDefinition template, CPPTemplateParameterMap tpMap, ICPPTemplateArgument[] args, IASTNode point) {
        ICPPTemplateParameterMap map;
        if (owner instanceof ICPPSpecialization && (map = ((ICPPSpecialization)owner).getTemplateParameterMap()) != null) {
            tpMap.putAll(map);
        }
        ICPPTemplateInstance instance = null;
        if (template instanceof ICPPClassType) {
            instance = new CPPClassInstance((ICPPClassType)((Object)template), owner, tpMap, args);
        } else if (template instanceof ICPPFunction) {
            ICPPFunction func = (ICPPFunction)((Object)template);
            ICPPClassSpecialization within = CPPTemplates.getSpecializationContext(owner);
            ICPPFunctionType type = (ICPPFunctionType)CPPTemplates.instantiateType(func.getType(), tpMap, -1, within, point);
            IType[] exceptionSpecs = CPPTemplates.instantiateTypes(func.getExceptionSpecification(), tpMap, -1, within, point);
            CPPFunctionInstance spec = owner instanceof ICPPClassType && template instanceof ICPPMethod ? (template instanceof ICPPConstructor ? new CPPConstructorInstance((ICPPConstructor)((Object)template), (ICPPClassType)owner, tpMap, args, type, exceptionSpecs) : new CPPMethodInstance((ICPPMethod)((Object)template), (ICPPClassType)owner, tpMap, args, type, exceptionSpecs)) : new CPPFunctionInstance((ICPPFunction)((Object)template), owner, tpMap, args, type, exceptionSpecs);
            spec.setParameters(CPPTemplates.specializeParameters(func.getParameters(), spec, tpMap, -1, within, 25, point));
            instance = spec;
        }
        return instance;
    }

    public static ICPPParameter[] specializeParameters(ICPPParameter[] parameters, ICPPFunction functionSpec, ICPPTemplateParameterMap tpMap, int packOffset, ICPPClassSpecialization within, int maxdepth, IASTNode point) {
        if (parameters.length == 0) {
            return parameters;
        }
        IType[] specializedParameterTypes = functionSpec.getType().getParameterTypes();
        int length = specializedParameterTypes.length;
        ICPPParameter par = null;
        ICPPParameter[] result = new ICPPParameter[length];
        int i = 0;
        while (i < length) {
            if (i < parameters.length) {
                par = parameters[i];
            }
            IValue defaultValue = par.getDefaultValue();
            IValue specializedValue = CPPTemplates.instantiateValue(defaultValue, tpMap, packOffset, within, maxdepth, point);
            result[i] = new CPPParameterSpecialization(par, functionSpec, specializedParameterTypes[i], specializedValue, tpMap);
            ++i;
        }
        return result;
    }

    public static IBinding createSpecialization(ICPPClassSpecialization owner, IBinding decl, IASTNode point) {
        IBinding spec;
        block32: {
            spec = null;
            ICPPTemplateParameterMap tpMap = owner.getTemplateParameterMap();
            try {
                if (decl instanceof ICPPClassTemplatePartialSpecialization) {
                    try {
                        ICPPClassSpecialization within = CPPTemplates.getSpecializationContext(owner);
                        ICPPClassTemplatePartialSpecialization pspec = (ICPPClassTemplatePartialSpecialization)decl;
                        ICPPClassTemplate template = pspec.getPrimaryClassTemplate();
                        ICPPTemplateArgument[] args = pspec.getTemplateArguments();
                        template = (ICPPClassTemplate)owner.specializeMember(template, point);
                        args = CPPTemplates.instantiateArguments(args, tpMap, -1, within, point, false);
                        spec = new CPPClassTemplatePartialSpecializationSpecialization(pspec, tpMap, template, args);
                    }
                    catch (DOMException dOMException) {}
                    break block32;
                }
                if (decl instanceof ICPPClassTemplate) {
                    ICPPClassTemplate template = (ICPPClassTemplate)decl;
                    CPPClassTemplateSpecialization classTemplateSpec = new CPPClassTemplateSpecialization(template, owner, tpMap);
                    classTemplateSpec.setTemplateParameters(CPPTemplates.specializeTemplateParameters(classTemplateSpec, (ICPPScope)classTemplateSpec.getScope(), template.getTemplateParameters(), owner, point));
                    spec = classTemplateSpec;
                    break block32;
                }
                if (decl instanceof ICPPClassType) {
                    IBinding oldOwner = decl.getOwner();
                    spec = oldOwner instanceof IType && owner.getSpecializedBinding().isSameType((IType)((Object)oldOwner)) ? new CPPClassSpecialization((ICPPClassType)decl, (IBinding)owner, tpMap) : new CPPClassSpecialization((ICPPClassType)decl, oldOwner, tpMap);
                    break block32;
                }
                if (decl instanceof ICPPField) {
                    ICPPClassSpecialization within = CPPTemplates.getSpecializationContext(owner);
                    ICPPField field = (ICPPField)decl;
                    IType type = CPPTemplates.instantiateType(field.getType(), tpMap, -1, within, point);
                    IValue value = CPPTemplates.instantiateValue(field.getInitialValue(), tpMap, -1, within, 25, point);
                    spec = new CPPFieldSpecialization(decl, owner, tpMap, type, value);
                    break block32;
                }
                if (decl instanceof ICPPFunction) {
                    ICPPFunction func = (ICPPFunction)decl;
                    ICPPClassSpecialization within = CPPTemplates.getSpecializationContext(owner);
                    ICPPFunctionType type = (ICPPFunctionType)CPPTemplates.instantiateType(func.getType(), tpMap, -1, within, point);
                    IType[] exceptionSpecs = CPPTemplates.instantiateTypes(func.getExceptionSpecification(), tpMap, -1, within, point);
                    CPPFunctionSpecialization functionSpec = null;
                    if (decl instanceof ICPPFunctionTemplate) {
                        if (decl instanceof ICPPMethod) {
                            CPPMethodTemplateSpecialization methodSpec = decl instanceof ICPPConstructor ? new CPPConstructorTemplateSpecialization((ICPPConstructor)decl, owner, tpMap, type, exceptionSpecs) : new CPPMethodTemplateSpecialization((ICPPMethod)decl, owner, tpMap, type, exceptionSpecs);
                            methodSpec.setTemplateParameters(CPPTemplates.specializeTemplateParameters(methodSpec, (ICPPScope)methodSpec.getScope(), ((ICPPFunctionTemplate)decl).getTemplateParameters(), owner, point));
                            functionSpec = methodSpec;
                        } else {
                            IBinding oldOwner = decl.getOwner();
                            functionSpec = new CPPFunctionTemplateSpecialization((ICPPFunctionTemplate)decl, oldOwner, tpMap, type, exceptionSpecs);
                        }
                    } else if (decl instanceof ICPPConstructor) {
                        functionSpec = new CPPConstructorSpecialization((ICPPConstructor)decl, (ICPPClassType)owner, tpMap, type, exceptionSpecs);
                    } else if (decl instanceof ICPPMethod) {
                        functionSpec = new CPPMethodSpecialization((ICPPMethod)decl, owner, tpMap, type, exceptionSpecs);
                    } else if (decl instanceof ICPPFunction) {
                        IBinding oldOwner = decl.getOwner();
                        functionSpec = new CPPFunctionSpecialization((ICPPFunction)decl, oldOwner, tpMap, type, exceptionSpecs);
                    }
                    if (functionSpec != null) {
                        functionSpec.setParameters(CPPTemplates.specializeParameters(func.getParameters(), functionSpec, tpMap, -1, within, 25, point));
                    }
                    spec = functionSpec;
                    break block32;
                }
                if (decl instanceof ITypedef) {
                    IType type = CPPTemplates.instantiateType(((ITypedef)decl).getType(), tpMap, -1, CPPTemplates.getSpecializationContext(owner), point);
                    spec = new CPPTypedefSpecialization(decl, owner, tpMap, type);
                    break block32;
                }
                if (decl instanceof ICPPAliasTemplate) {
                    ICPPAliasTemplate aliasTemplate = (ICPPAliasTemplate)decl;
                    IType type = CPPTemplates.instantiateType(aliasTemplate.getType(), tpMap, -1, CPPTemplates.getSpecializationContext(owner), point);
                    spec = new CPPAliasTemplateInstance(decl.getNameCharArray(), aliasTemplate, type);
                    break block32;
                }
                if (decl instanceof ICPPEnumeration) {
                    ICPPClassSpecialization within = CPPTemplates.getSpecializationContext(owner);
                    ICPPEnumeration enumeration = (ICPPEnumeration)decl;
                    IType fixedType = CPPTemplates.instantiateType(enumeration.getFixedType(), tpMap, -1, within, point);
                    CPPEnumerationSpecialization specializedEnumeration = new CPPEnumerationSpecialization(enumeration, owner, tpMap, fixedType);
                    IEnumerator[] enumerators = enumeration.getEnumerators();
                    IEnumerator[] specializedEnumerators = new IEnumerator[enumerators.length];
                    int i = 0;
                    while (i < enumerators.length) {
                        IEnumerator enumerator = enumerators[i];
                        IValue specializedValue = CPPTemplates.instantiateValue(enumerator.getValue(), tpMap, -1, within, 25, point);
                        specializedEnumerators[i] = new CPPEnumeratorSpecialization(enumerator, specializedEnumeration, tpMap, specializedValue);
                        ++i;
                    }
                    specializedEnumeration.setEnumerators(specializedEnumerators);
                    spec = specializedEnumeration;
                    break block32;
                }
                if (decl instanceof IEnumerator) {
                    IEnumerator enumerator = (IEnumerator)decl;
                    ICPPEnumeration enumeration = (ICPPEnumeration)enumerator.getOwner();
                    ICPPEnumerationSpecialization enumSpec = (ICPPEnumerationSpecialization)owner.specializeMember(enumeration, point);
                    spec = enumSpec.specializeEnumerator(enumerator);
                    break block32;
                }
                if (!(decl instanceof ICPPUsingDeclaration)) break block32;
                IBinding[] delegates = ((ICPPUsingDeclaration)decl).getDelegates();
                ArrayList<IBinding> result = new ArrayList<IBinding>();
                ICPPClassSpecialization within = CPPTemplates.getSpecializationContext(owner);
                IBinding[] iBindingArray = delegates;
                int n = delegates.length;
                int n2 = 0;
                while (n2 < n) {
                    IBinding delegate = iBindingArray[n2];
                    try {
                        if (delegate instanceof ICPPUnknownBinding) {
                            delegate = CPPTemplates.resolveUnknown((ICPPUnknownBinding)delegate, tpMap, -1, within, point);
                        }
                        if (delegate instanceof CPPFunctionSet) {
                            ICPPFunction[] iCPPFunctionArray = ((CPPFunctionSet)delegate).getBindings();
                            int n3 = iCPPFunctionArray.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                ICPPFunction b = iCPPFunctionArray[n4];
                                result.add(b);
                                ++n4;
                            }
                        } else if (delegate != null) {
                            result.add(delegate);
                        }
                    }
                    catch (DOMException dOMException) {}
                    ++n2;
                }
                delegates = result.toArray(new IBinding[result.size()]);
                spec = new CPPUsingDeclarationSpecialization((ICPPUsingDeclaration)decl, owner, tpMap, delegates);
            }
            catch (DOMException e) {
                CCorePlugin.log(e);
            }
        }
        return spec;
    }

    private static ICPPClassSpecialization getSpecializationContext(IBinding owner) {
        if (!(owner instanceof ICPPClassSpecialization)) {
            return null;
        }
        ICPPClassSpecialization within = (ICPPClassSpecialization)owner;
        ICPPClassType orig = within.getSpecializedBinding();
        while (true) {
            IBinding o1 = within.getOwner();
            IBinding o2 = orig.getOwner();
            if (!(o1 instanceof ICPPClassSpecialization) || !(o2 instanceof ICPPClassType)) {
                return within;
            }
            orig = (ICPPClassType)o2;
            ICPPClassSpecialization nextWithin = (ICPPClassSpecialization)o1;
            if (orig.isSameType(nextWithin)) {
                return within;
            }
            within = nextWithin;
        }
    }

    public static IValue instantiateValue(IValue value, ICPPTemplateParameterMap tpMap, int packOffset, ICPPClassSpecialization within, int maxdepth, IASTNode point) {
        if (value == null) {
            return null;
        }
        ICPPEvaluation evaluation = value.getEvaluation();
        if (evaluation == null) {
            return value;
        }
        ICPPEvaluation instantiated = evaluation.instantiate(tpMap, packOffset, within, maxdepth, point);
        if (instantiated == evaluation) {
            return value;
        }
        return instantiated.getValue(point);
    }

    public static boolean containsParameterPack(IType type) {
        return CPPTemplates.determinePackSize(type, (ICPPTemplateParameterMap)CPPTemplateParameterMap.EMPTY) == -1;
    }

    static int determinePackSize(IType type, ICPPTemplateParameterMap tpMap) {
        IArrayType at;
        IValue asize;
        if (type instanceof ICPPFunctionType) {
            IType[] ps;
            ICPPFunctionType ft = (ICPPFunctionType)type;
            IType rt = ft.getReturnType();
            int r = CPPTemplates.determinePackSize(rt, tpMap);
            if (r < 0) {
                return r;
            }
            IType[] iTypeArray = ps = ft.getParameterTypes();
            int n = ps.length;
            int n2 = 0;
            while (n2 < n) {
                IType pt = iTypeArray[n2];
                if ((r = CPPTemplates.combinePackSize(r, CPPTemplates.determinePackSize(pt, tpMap))) < 0) {
                    return r;
                }
                ++n2;
            }
            return r;
        }
        if (type instanceof ICPPTemplateParameter) {
            return CPPTemplates.determinePackSize((ICPPTemplateParameter)((Object)type), tpMap);
        }
        if (type instanceof ICPPUnknownBinding) {
            return CPPTemplates.determinePackSize((ICPPUnknownBinding)((Object)type), tpMap);
        }
        if (type instanceof ICPPParameterPackType) {
            return Integer.MAX_VALUE;
        }
        int r = Integer.MAX_VALUE;
        if (type instanceof IArrayType && (r = CPPTemplates.determinePackSize(asize = (at = (IArrayType)type).getSize(), tpMap)) < 0) {
            return r;
        }
        if (type instanceof ITypeContainer) {
            ITypeContainer typeContainer = (ITypeContainer)type;
            r = CPPTemplates.combinePackSize(r, CPPTemplates.determinePackSize(typeContainer.getType(), tpMap));
        }
        return r;
    }

    static int determinePackSize(ICPPTemplateParameter tpar, ICPPTemplateParameterMap tpMap) {
        if (tpar.isParameterPack()) {
            ICPPTemplateArgument[] args = tpMap.getPackExpansion(tpar);
            if (args != null) {
                return args.length;
            }
            return -1;
        }
        return Integer.MAX_VALUE;
    }

    static int determinePackSize(ICPPUnknownBinding binding, ICPPTemplateParameterMap tpMap) {
        IBinding ownerBinding;
        int r = Integer.MAX_VALUE;
        if (binding instanceof ICPPDeferredClassInstance) {
            ICPPTemplateArgument[] args;
            ICPPDeferredClassInstance dcl = (ICPPDeferredClassInstance)binding;
            ICPPTemplateArgument[] iCPPTemplateArgumentArray = args = dcl.getTemplateArguments();
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPTemplateArgument arg = iCPPTemplateArgumentArray[n2];
                if ((r = CPPTemplates.combinePackSize(r, CPPTemplates.determinePackSize(arg, tpMap))) < 0) {
                    return r;
                }
                ++n2;
            }
        }
        if ((ownerBinding = binding.getOwner()) instanceof IType) {
            r = CPPTemplates.combinePackSize(r, CPPTemplates.determinePackSize((IType)((Object)ownerBinding), tpMap));
        }
        return r;
    }

    static int determinePackSize(IValue value, ICPPTemplateParameterMap tpMap) {
        ICPPEvaluation eval = value.getEvaluation();
        if (eval == null) {
            return Integer.MAX_VALUE;
        }
        return ((CPPEvaluation)eval).determinePackSize(tpMap);
    }

    static int determinePackSize(ICPPTemplateArgument arg, ICPPTemplateParameterMap tpMap) {
        if (arg.isTypeValue()) {
            return CPPTemplates.determinePackSize(arg.getTypeValue(), tpMap);
        }
        return CPPTemplates.determinePackSize(arg.getNonTypeValue(), tpMap);
    }

    static int combinePackSize(int ps1, int ps2) {
        if (ps1 < 0 || ps2 == Integer.MAX_VALUE) {
            return ps1;
        }
        if (ps2 < 0 || ps1 == Integer.MAX_VALUE) {
            return ps2;
        }
        if (ps1 != ps2) {
            return -2;
        }
        return ps1;
    }

    public static IType[] instantiateTypes(IType[] types, ICPPTemplateParameterMap tpMap, int packOffset, ICPPClassSpecialization within, IASTNode point) {
        if (types == null) {
            return null;
        }
        IType[] result = types;
        int j = 0;
        int i = 0;
        while (i < types.length) {
            block10: {
                IType newType;
                IType origType;
                block8: {
                    block6: {
                        int packSize;
                        block9: {
                            block7: {
                                origType = types[i];
                                if (!(origType instanceof ICPPParameterPackType)) break block6;
                                packSize = CPPTemplates.determinePackSize(origType = ((ICPPParameterPackType)origType).getType(), tpMap);
                                if (packSize != -2 && packSize != Integer.MAX_VALUE) break block7;
                                newType = new ProblemBinding(point, 5, types[i] instanceof IBinding ? ((IBinding)((Object)types[i])).getNameCharArray() : null);
                                break block8;
                            }
                            if (packSize != -1) break block9;
                            newType = origType;
                            break block8;
                        }
                        IType[] newResult = new IType[result.length + packSize - 1];
                        System.arraycopy(result, 0, newResult, 0, j);
                        result = newResult;
                        int k = 0;
                        while (k < packSize) {
                            result[j++] = CPPTemplates.instantiateType(origType, tpMap, k, within, point);
                            ++k;
                        }
                        break block10;
                    }
                    newType = CPPTemplates.instantiateType(origType, tpMap, packOffset, within, point);
                }
                if (result != types) {
                    result[j++] = newType;
                } else {
                    if (newType != origType) {
                        result = new IType[types.length];
                        System.arraycopy(types, 0, result, 0, i);
                        result[j] = newType;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return result;
    }

    public static ICPPTemplateArgument[] instantiateArguments(ICPPTemplateArgument[] args, ICPPTemplateParameterMap tpMap, int packOffset, ICPPClassSpecialization within, IASTNode point, boolean strict) throws DOMException {
        ICPPTemplateArgument[] result = args;
        int resultShift = 0;
        int i = 0;
        while (i < args.length) {
            block15: {
                ICPPTemplateArgument newArg;
                ICPPTemplateArgument origArg;
                block14: {
                    block12: {
                        int packSize;
                        ICPPTemplateArgument unexpanded;
                        block13: {
                            origArg = args[i];
                            if (!origArg.isPackExpansion()) break block12;
                            unexpanded = origArg;
                            packSize = CPPTemplates.determinePackSize(origArg = origArg.getExpansionPattern(), tpMap);
                            if (packSize == -2 || packSize == Integer.MAX_VALUE) {
                                throw new DOMException(new ProblemBinding(point, 15, null));
                            }
                            if (packSize != -1) break block13;
                            newArg = origArg;
                            break block14;
                        }
                        int shift = packSize - 1;
                        ICPPTemplateArgument[] newResult = new ICPPTemplateArgument[args.length + resultShift + shift];
                        System.arraycopy(result, 0, newResult, 0, i + resultShift);
                        int j = 0;
                        while (j < packSize) {
                            newArg = CPPTemplates.instantiateArgument(origArg, tpMap, j, within, point);
                            if (!CPPTemplates.isValidArgument(newArg)) {
                                if (strict) {
                                    return null;
                                }
                                result[i + resultShift] = unexpanded;
                                newResult = result;
                                shift = 0;
                                break;
                            }
                            newResult[i + resultShift + j] = newArg;
                            ++j;
                        }
                        result = newResult;
                        resultShift += shift;
                        break block15;
                    }
                    newArg = CPPTemplates.instantiateArgument(origArg, tpMap, packOffset, within, point);
                    if (!CPPTemplates.isValidArgument(newArg)) {
                        if (strict) {
                            return null;
                        }
                        newArg = origArg;
                    }
                }
                if (result != args) {
                    result[i + resultShift] = newArg;
                } else if (newArg != origArg) {
                    assert (resultShift == 0);
                    result = new ICPPTemplateArgument[args.length];
                    if (i > 0) {
                        System.arraycopy(args, 0, result, 0, i);
                    }
                    result[i] = newArg;
                }
            }
            ++i;
        }
        return result;
    }

    static ICPPTemplateArgument instantiateArgument(ICPPTemplateArgument arg, ICPPTemplateParameterMap tpMap, int packOffset, ICPPClassSpecialization within, IASTNode point) {
        IType inst;
        if (arg == null) {
            return null;
        }
        if (arg.isNonTypeValue()) {
            ICPPEvaluation newEval;
            ICPPEvaluation eval = arg.getNonTypeEvaluation();
            if (eval == (newEval = eval.instantiate(tpMap, packOffset, within, 25, point))) {
                return arg;
            }
            return new CPPTemplateNonTypeArgument(newEval, point);
        }
        IType orig = arg.getTypeValue();
        if (orig == (inst = CPPTemplates.instantiateType(orig, tpMap, packOffset, within, point))) {
            return arg;
        }
        return new CPPTemplateTypeArgument(inst);
    }

    private static CPPTemplateParameterMap instantiateArgumentMap(ICPPTemplateParameterMap orig, ICPPTemplateParameterMap tpMap, int packOffset, ICPPClassSpecialization within, IASTNode point) {
        Integer[] positions = orig.getAllParameterPositions();
        CPPTemplateParameterMap newMap = new CPPTemplateParameterMap(positions.length);
        Integer[] integerArray = positions;
        int n = positions.length;
        int n2 = 0;
        while (n2 < n) {
            Integer key = integerArray[n2];
            ICPPTemplateArgument arg = orig.getArgument(key);
            if (arg != null) {
                ICPPTemplateArgument newArg = CPPTemplates.instantiateArgument(arg, tpMap, packOffset, within, point);
                if (!CPPTemplates.isValidArgument(newArg)) {
                    newArg = arg;
                }
                newMap.put((int)key, newArg);
            } else {
                ICPPTemplateArgument[] args = orig.getPackExpansion(key);
                if (args != null) {
                    try {
                        newMap.put((int)key, CPPTemplates.instantiateArguments(args, tpMap, packOffset, within, point, false));
                    }
                    catch (DOMException dOMException) {
                        newMap.put((int)key, args);
                    }
                }
            }
            ++n2;
        }
        return newMap;
    }

    public static IType instantiateType(IType type, ICPPTemplateParameterMap tpMap, int packOffset, ICPPClassSpecialization within, IASTNode point) {
        block28: {
            try {
                if (tpMap == null) {
                    return type;
                }
                if (type instanceof ICPPFunctionType) {
                    ICPPFunctionType ft = (ICPPFunctionType)type;
                    IType ret = null;
                    IType[] params = null;
                    IType r = ft.getReturnType();
                    ret = CPPTemplates.instantiateType(r, tpMap, packOffset, within, point);
                    IType[] ps = ft.getParameterTypes();
                    params = CPPTemplates.instantiateTypes(ps, tpMap, packOffset, within, point);
                    if (ret == r && params == ps) {
                        return type;
                    }
                    int i = 0;
                    while (i < params.length) {
                        IType p = params[i];
                        if (!CPPTemplates.isDependentType(p)) {
                            params[i] = CPPVisitor.adjustParameterType(p, true);
                        }
                        ++i;
                    }
                    return new CPPFunctionType(ret, params, ft.isConst(), ft.isVolatile(), ft.takesVarArgs());
                }
                if (type instanceof ICPPTemplateParameter) {
                    return CPPTemplates.resolveTemplateTypeParameter((ICPPTemplateParameter)((Object)type), tpMap, packOffset, point);
                }
                if (type instanceof ICPPUnknownBinding) {
                    if (type instanceof TypeOfDependentExpression) {
                        ICPPEvaluation eval = ((TypeOfDependentExpression)type).getEvaluation();
                        ICPPEvaluation instantiated = eval.instantiate(tpMap, packOffset, within, 25, point);
                        if (instantiated != eval) {
                            return instantiated.getTypeOrFunctionSet(point);
                        }
                    } else {
                        IBinding binding = CPPTemplates.resolveUnknown((ICPPUnknownBinding)((Object)type), tpMap, packOffset, within, point);
                        if (binding instanceof IType) {
                            return (IType)((Object)binding);
                        }
                        return type;
                    }
                }
                if (within != null && type instanceof IBinding) {
                    ICPPTemplateArgument[] args;
                    ICPPTemplateArgument[] newArgs;
                    ICPPTemplateInstance classInstance;
                    IBinding origClass;
                    IType unwound = SemanticUtil.getNestedType(type, 1);
                    if (unwound instanceof ICPPClassType && unwound.isSameType(within.getSpecializedBinding()) && (within instanceof ICPPClassTemplate || !(unwound instanceof ICPPClassTemplate))) {
                        return within;
                    }
                    IBinding typeAsBinding = (IBinding)((Object)type);
                    IBinding owner = typeAsBinding.getOwner();
                    if (owner instanceof IType) {
                        IType ownerAsType = SemanticUtil.getNestedType((IType)((Object)owner), 1);
                        Object newOwner = owner;
                        newOwner = ownerAsType instanceof ICPPClassType && ownerAsType.isSameType(within.getSpecializedBinding()) ? within : CPPTemplates.instantiateType(ownerAsType, tpMap, packOffset, within, point);
                        if (newOwner != owner && newOwner instanceof ICPPClassSpecialization) {
                            return (IType)((Object)((ICPPClassSpecialization)newOwner).specializeMember(typeAsBinding, point));
                        }
                    }
                    if (unwound instanceof ICPPTemplateInstance && !(unwound instanceof ICPPDeferredClassInstance) && (origClass = (classInstance = (ICPPTemplateInstance)((Object)unwound)).getSpecializedBinding()) instanceof ICPPClassType && (newArgs = CPPTemplates.instantiateArguments(args = classInstance.getTemplateArguments(), tpMap, packOffset, within, point, false)) != args) {
                        CPPTemplateParameterMap tparMap = CPPTemplates.instantiateArgumentMap(classInstance.getTemplateParameterMap(), tpMap, packOffset, within, point);
                        return new CPPClassInstance((ICPPClassType)origClass, classInstance.getOwner(), tparMap, args);
                    }
                }
                if (type instanceof ITypeContainer) {
                    IValue newSize;
                    IArrayType at;
                    IValue asize;
                    ITypeContainer typeContainer = (ITypeContainer)type;
                    IType nestedType = typeContainer.getType();
                    IType newNestedType = CPPTemplates.instantiateType(nestedType, tpMap, packOffset, within, point);
                    if (typeContainer instanceof ICPPPointerToMemberType) {
                        ICPPPointerToMemberType ptm = (ICPPPointerToMemberType)((Object)typeContainer);
                        IType memberOfClass = ptm.getMemberOfClass();
                        IType newMemberOfClass = CPPTemplates.instantiateType(memberOfClass, tpMap, packOffset, within, point);
                        IType classType = SemanticUtil.getNestedType(newMemberOfClass, 9);
                        if (!(classType instanceof ICPPClassType || classType instanceof UniqueType || classType instanceof ICPPUnknownBinding)) {
                            return new ProblemType(5);
                        }
                        if (newNestedType != nestedType || newMemberOfClass != memberOfClass) {
                            return new CPPPointerToMemberType(newNestedType, newMemberOfClass, ptm.isConst(), ptm.isVolatile(), ptm.isRestrict());
                        }
                        return typeContainer;
                    }
                    if (typeContainer instanceof IArrayType && (asize = (at = (IArrayType)((Object)typeContainer)).getSize()) != null && (newSize = CPPTemplates.instantiateValue(asize, tpMap, packOffset, within, 25, point)) != asize) {
                        return new CPPArrayType(newNestedType, newSize);
                    }
                    if (newNestedType != nestedType) {
                        return SemanticUtil.replaceNestedType(typeContainer, newNestedType);
                    }
                    return typeContainer;
                }
                if (!(type instanceof ICPPUnaryTypeTransformation)) break block28;
                ICPPUnaryTypeTransformation typeTransformation = (ICPPUnaryTypeTransformation)type;
                IType operand = CPPTemplates.instantiateType(typeTransformation.getOperand(), tpMap, packOffset, within, point);
                switch (typeTransformation.getOperator()) {
                    case underlying_type: {
                        return TypeTraits.underlyingType(operand);
                    }
                }
                return null;
            }
            catch (DOMException e) {
                return e.getProblem();
            }
        }
        return type;
    }

    public static ICPPTemplateParameter specializeTemplateParameter(ICPPSpecialization owner, ICPPScope scope, ICPPTemplateParameter specialized, ICPPClassSpecialization within, IASTNode point) {
        if (specialized == null) {
            return null;
        }
        ICPPTemplateParameterMap tpMap = owner.getTemplateParameterMap();
        ICPPTemplateArgument defaultValue = CPPTemplates.instantiateArgument(specialized.getDefaultValue(), tpMap, 0, within, point);
        if (specialized instanceof ICPPTemplateNonTypeParameter) {
            ICPPTemplateNonTypeParameter spec = (ICPPTemplateNonTypeParameter)specialized;
            IType type = CPPTemplates.instantiateType(spec.getType(), tpMap, 0, within, point);
            return new CPPTemplateNonTypeParameterSpecialization(owner, scope, spec, defaultValue, type);
        }
        if (specialized instanceof ICPPTemplateTypeParameter) {
            return new CPPTemplateTypeParameterSpecialization(owner, scope, (ICPPTemplateTypeParameter)specialized, defaultValue);
        }
        if (specialized instanceof ICPPTemplateTemplateParameter) {
            return new CPPTemplateTemplateParameterSpecialization(owner, scope, (ICPPTemplateTemplateParameter)specialized, defaultValue);
        }
        return null;
    }

    public static ICPPTemplateParameter[] specializeTemplateParameters(ICPPSpecialization owner, ICPPScope scope, ICPPTemplateParameter[] specialized, ICPPClassSpecialization within, IASTNode point) {
        ICPPTemplateParameter[] result = new ICPPTemplateParameter[specialized.length];
        int i = 0;
        while (i < specialized.length) {
            result[i] = CPPTemplates.specializeTemplateParameter(owner, scope, specialized[i], within, point);
            ++i;
        }
        return result;
    }

    public static IBinding instantiateBinding(IBinding binding, ICPPTemplateParameterMap tpMap, int packOffset, ICPPClassSpecialization within, int maxdepth, IASTNode point) throws DOMException {
        ICPPTemplateArgument[] newArgs;
        CPPFunctionInstance origInstance;
        ICPPTemplateArgument[] origArgs;
        if (binding instanceof ICPPClassTemplate) {
            binding = CPPTemplates.createDeferredInstance((ICPPClassTemplate)binding);
        }
        if (binding instanceof ICPPUnknownBinding) {
            return CPPTemplates.resolveUnknown((ICPPUnknownBinding)binding, tpMap, packOffset, within, point);
        }
        if (binding instanceof IEnumerator || binding instanceof ICPPMethod || binding instanceof ICPPField || binding instanceof ICPPEnumeration || binding instanceof ICPPClassType) {
            IBinding owner = binding.getOwner();
            if (!(owner instanceof ICPPSpecialization)) {
                owner = CPPTemplates.instantiateBinding(owner, tpMap, packOffset, within, maxdepth, point);
            }
            if (binding instanceof IEnumerator) {
                if (owner instanceof ICPPEnumerationSpecialization) {
                    return ((ICPPEnumerationSpecialization)owner).specializeEnumerator((IEnumerator)binding);
                }
            } else if (owner instanceof ICPPClassSpecialization) {
                return ((ICPPClassSpecialization)owner).specializeMember(binding, point);
            }
        } else if (binding instanceof CPPFunctionInstance && (origArgs = (origInstance = (CPPFunctionInstance)binding).getTemplateArguments()) != (newArgs = CPPTemplates.instantiateArguments(origArgs, tpMap, packOffset, within, point, false))) {
            CPPTemplateParameterMap newMap = CPPTemplates.instantiateArgumentMap(origInstance.getTemplateParameterMap(), tpMap, packOffset, within, point);
            IType newType = CPPTemplates.instantiateType(origInstance.getType(), tpMap, packOffset, within, point);
            IType[] newExceptionSpecs = CPPTemplates.instantiateTypes(origInstance.getExceptionSpecification(), tpMap, packOffset, within, point);
            CPPFunctionInstance result = new CPPFunctionInstance((ICPPFunction)((Object)origInstance.getTemplateDefinition()), origInstance.getOwner(), newMap, newArgs, (ICPPFunctionType)newType, newExceptionSpecs);
            result.setParameters(CPPTemplates.specializeParameters(origInstance.getParameters(), result, tpMap, packOffset, within, maxdepth, point));
            return result;
        }
        return binding;
    }

    public static IType resolveTemplateTypeParameter(ICPPTemplateParameter tpar, ICPPTemplateParameterMap tpMap, int packOffset, IASTNode point) {
        IType t;
        ICPPTemplateArgument arg = null;
        if (tpar.isParameterPack()) {
            ICPPTemplateArgument[] args;
            if (packOffset >= 0 && (args = tpMap.getPackExpansion(tpar)) != null) {
                if (packOffset >= args.length) {
                    return new ProblemBinding(point, 5, tpar.getNameCharArray());
                }
                arg = args[packOffset];
            }
        } else {
            arg = tpMap.getArgument(tpar);
        }
        if (arg != null && (t = arg.getOriginalTypeValue()) != null) {
            return t;
        }
        return (IType)((Object)tpar);
    }

    public static ICPPASTTemplateDeclaration getTemplateDeclaration(IASTName name) {
        if (name == null) {
            return null;
        }
        ICPPASTInternalTemplateDeclaration tdecl = CPPTemplates.getInnerTemplateDeclaration(name);
        if (tdecl == null) {
            return null;
        }
        IASTNode parent = (name = name.getLastName()).getParent();
        if (!(parent instanceof ICPPASTQualifiedName)) {
            if (parent instanceof ICPPASTTemplateId) {
                return null;
            }
            return tdecl;
        }
        ICPPASTQualifiedName qname = (ICPPASTQualifiedName)parent;
        IASTName lastName = qname.getLastName();
        boolean lastIsTemplate = tdecl.isAssociatedWithLastName();
        if (name == lastName) {
            if (lastIsTemplate) {
                return tdecl;
            }
            return null;
        }
        if (!(name instanceof ICPPASTTemplateId)) {
            return null;
        }
        if (lastIsTemplate) {
            tdecl = CPPTemplates.getDirectlyEnclosingTemplateDeclaration(tdecl);
        }
        ICPPASTNameSpecifier[] qualifier = qname.getQualifier();
        int i = qualifier.length - 1;
        while (tdecl != null && i >= 0) {
            ICPPASTNameSpecifier n = qualifier[i];
            if (n == name) {
                return tdecl;
            }
            if (n instanceof ICPPASTTemplateId) {
                tdecl = CPPTemplates.getDirectlyEnclosingTemplateDeclaration(tdecl);
            }
            --i;
        }
        return null;
    }

    public static void associateTemplateDeclarations(ICPPASTInternalTemplateDeclaration tdecl) {
        int nestingLevel;
        IASTDeclaration decl = tdecl.getDeclaration();
        while (decl instanceof ICPPASTInternalTemplateDeclaration) {
            tdecl = (ICPPASTInternalTemplateDeclaration)decl;
            decl = tdecl.getDeclaration();
        }
        ICPPASTInternalTemplateDeclaration innerMostTDecl = tdecl;
        IASTName declName = CPPTemplates.getNameForDeclarationInTemplateDeclaration(decl);
        int instDeclCount = 0;
        int tdeclCount = 0;
        IASTNode node = tdecl;
        while (node instanceof ICPPASTInternalTemplateDeclaration) {
            tdecl = node;
            node = node.getParent();
            instDeclCount = tdecl.getTemplateParameters().length == 0 ? ++instDeclCount : 0;
            ++tdeclCount;
        }
        ICPPASTInternalTemplateDeclaration outerMostTDecl = tdecl;
        int paramTDeclCount = tdeclCount - instDeclCount;
        boolean lastIsTemplate = true;
        if (declName instanceof ICPPASTQualifiedName) {
            ICPPASTQualifiedName qname = (ICPPASTQualifiedName)declName;
            CharArraySet tparnames = CPPTemplates.collectTemplateParameterNames(outerMostTDecl);
            int depIDCount = 0;
            IBinding owner = null;
            ICPPASTNameSpecifier[] qualifier = qname.getQualifier();
            int i = 0;
            while (i < qualifier.length) {
                ICPPASTNameSpecifier n = qualifier[i];
                if (n instanceof ICPPASTTemplateId && (depIDCount > 0 || CPPTemplates.usesTemplateParameter((ICPPASTTemplateId)n, tparnames))) {
                    ++depIDCount;
                }
                if (depIDCount == 0) {
                    owner = n.resolveBinding();
                }
                ++i;
            }
            if (qname.getLastName() instanceof ICPPASTTemplateId || paramTDeclCount > depIDCount || qualifier.length < 1) {
                lastIsTemplate = true;
                ++depIDCount;
            } else {
                lastIsTemplate = false;
            }
            nestingLevel = 0;
            if (owner != null) {
                IType t;
                int consumesTDecl = 0;
                IBinding b = owner;
                if (b instanceof IType && (t = SemanticUtil.getNestedType((IType)((Object)b), 1)) instanceof IBinding) {
                    b = (IBinding)((Object)t);
                }
                while (b != null) {
                    if (b instanceof ICPPTemplateInstance) {
                        ++nestingLevel;
                        if (!((ICPPTemplateInstance)b).isExplicitSpecialization()) {
                            ++consumesTDecl;
                        }
                    } else if (b instanceof ICPPClassTemplate || b instanceof ICPPClassTemplatePartialSpecialization) {
                        ++nestingLevel;
                        ++consumesTDecl;
                    }
                    b = b.getOwner();
                }
                if (depIDCount > 0) {
                    nestingLevel += depIDCount;
                } else if (consumesTDecl < tdeclCount && !lastIsTemplate) {
                    ++nestingLevel;
                    lastIsTemplate = true;
                }
            } else {
                nestingLevel += depIDCount;
                node = outerMostTDecl.getParent();
                while (node != null) {
                    if (node instanceof ICPPASTInternalTemplateDeclaration) {
                        nestingLevel += ((ICPPASTInternalTemplateDeclaration)node).getNestingLevel() + 1;
                        break;
                    }
                    node = node.getParent();
                }
            }
        } else {
            nestingLevel = 1;
            lastIsTemplate = true;
            if (!CPPTemplates.isFriendFunctionDeclaration(innerMostTDecl.getDeclaration())) {
                node = outerMostTDecl.getParent();
                while (node != null) {
                    if (node instanceof ICPPASTInternalTemplateDeclaration) {
                        nestingLevel += ((ICPPASTInternalTemplateDeclaration)node).getNestingLevel() + 1;
                        break;
                    }
                    node = node.getParent();
                }
            }
        }
        node = innerMostTDecl;
        while (node instanceof ICPPASTInternalTemplateDeclaration) {
            if (--nestingLevel < 0) {
                nestingLevel = 0;
            }
            tdecl = (ICPPASTInternalTemplateDeclaration)node;
            tdecl.setNestingLevel((short)nestingLevel);
            tdecl.setAssociatedWithLastName(false);
            node = tdecl.getParent();
        }
        innerMostTDecl.setAssociatedWithLastName(lastIsTemplate);
    }

    private static boolean isFriendFunctionDeclaration(IASTDeclaration declaration) {
        IASTDeclarator[] dtors;
        IASTSimpleDeclaration sdecl;
        ICPPASTDeclSpecifier declspec;
        while (declaration instanceof ICPPASTTemplateDeclaration) {
            declaration = ((ICPPASTTemplateDeclaration)declaration).getDeclaration();
        }
        return declaration instanceof IASTSimpleDeclaration && (declspec = (ICPPASTDeclSpecifier)(sdecl = (IASTSimpleDeclaration)declaration).getDeclSpecifier()).isFriend() && (dtors = sdecl.getDeclarators()).length == 1 && ASTQueries.findTypeRelevantDeclarator(dtors[0]) instanceof IASTFunctionDeclarator;
    }

    private static CharArraySet collectTemplateParameterNames(ICPPASTTemplateDeclaration tdecl) {
        CharArraySet set = new CharArraySet(4);
        while (true) {
            ICPPASTTemplateParameter[] pars;
            ICPPASTTemplateParameter[] iCPPASTTemplateParameterArray = pars = tdecl.getTemplateParameters();
            int n = pars.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPASTTemplateParameter par = iCPPASTTemplateParameterArray[n2];
                IASTName name = CPPTemplates.getTemplateParameterName(par);
                if (name != null) {
                    set.put(name.getLookupKey());
                }
                ++n2;
            }
            IASTDeclaration next = tdecl.getDeclaration();
            if (!(next instanceof ICPPASTTemplateDeclaration)) break;
            tdecl = (ICPPASTTemplateDeclaration)next;
        }
        return set;
    }

    private static boolean usesTemplateParameter(ICPPASTTemplateId id, final CharArraySet names) {
        final boolean[] result = new boolean[1];
        ASTVisitor v = new ASTVisitor(false){
            {
                super($anonymous0);
                this.shouldVisitNames = true;
                this.shouldVisitAmbiguousNodes = true;
            }

            @Override
            public int visit(IASTName name) {
                if (name instanceof ICPPASTTemplateId) {
                    return 3;
                }
                if (name instanceof ICPPASTQualifiedName) {
                    ICPPASTQualifiedName qname = (ICPPASTQualifiedName)name;
                    if (qname.isFullyQualified()) {
                        return 1;
                    }
                    return 3;
                }
                if (names.containsKey(name.getLookupKey())) {
                    IASTNode parent = name.getParent();
                    if (parent instanceof ICPPASTQualifiedName) {
                        ICPPASTNameSpecifier[] qualifier = ((ICPPASTQualifiedName)parent).getQualifier();
                        if (qualifier.length > 0 && qualifier[0] != name) {
                            return 3;
                        }
                        result[0] = true;
                        return 2;
                    }
                    if (parent instanceof IASTIdExpression || parent instanceof ICPPASTNamedTypeSpecifier) {
                        result[0] = true;
                        return 2;
                    }
                }
                return 3;
            }

            @Override
            public int visit(ASTAmbiguousNode node) {
                IASTNode[] alternatives;
                IASTNode[] iASTNodeArray = alternatives = node.getNodes();
                int n = alternatives.length;
                int n2 = 0;
                while (n2 < n) {
                    IASTNode alt = iASTNodeArray[n2];
                    if (!alt.accept(this)) {
                        return 2;
                    }
                    ++n2;
                }
                return 3;
            }
        };
        id.accept(v);
        return result[0];
    }

    private static IASTName getNameForDeclarationInTemplateDeclaration(IASTDeclaration decl) {
        IASTName name = null;
        if (decl instanceof IASTSimpleDeclaration) {
            IASTSimpleDeclaration sdecl = (IASTSimpleDeclaration)decl;
            IASTDeclarator[] dtors = sdecl.getDeclarators();
            if (dtors != null && dtors.length > 0) {
                name = ASTQueries.findInnermostDeclarator(dtors[0]).getName();
            } else {
                IASTDeclSpecifier declspec = sdecl.getDeclSpecifier();
                if (declspec instanceof IASTCompositeTypeSpecifier) {
                    name = ((IASTCompositeTypeSpecifier)declspec).getName();
                } else if (declspec instanceof IASTElaboratedTypeSpecifier) {
                    name = ((IASTElaboratedTypeSpecifier)declspec).getName();
                }
            }
        } else if (decl instanceof IASTFunctionDefinition) {
            IASTFunctionDefinition fdef = (IASTFunctionDefinition)decl;
            name = ASTQueries.findInnermostDeclarator(fdef.getDeclarator()).getName();
        }
        return name;
    }

    /*
     * Unable to fully structure code
     */
    private static ICPPASTInternalTemplateDeclaration getInnerTemplateDeclaration(IASTName name) {
        block5: {
            parent = name.getParent();
            while (parent instanceof IASTName) {
                parent = parent.getParent();
            }
            if (!(parent instanceof IASTDeclSpecifier)) ** GOTO lbl11
            if (!(parent instanceof IASTCompositeTypeSpecifier) && !(parent instanceof IASTElaboratedTypeSpecifier)) {
                return null;
            }
            parent = parent.getParent();
            break block5;
lbl-1000:
            // 1 sources

            {
                parent = parent.getParent();
lbl11:
                // 2 sources

                ** while (parent instanceof IASTDeclarator)
            }
        }
        if (!(parent instanceof IASTDeclaration)) {
            return null;
        }
        if ((parent = parent.getParent()) instanceof ICPPASTInternalTemplateDeclaration) {
            return (ICPPASTInternalTemplateDeclaration)parent;
        }
        return null;
    }

    private static ICPPASTInternalTemplateDeclaration getDirectlyEnclosingTemplateDeclaration(ICPPASTInternalTemplateDeclaration tdecl) {
        IASTNode parent = tdecl.getParent();
        if (parent instanceof ICPPASTInternalTemplateDeclaration) {
            return (ICPPASTInternalTemplateDeclaration)parent;
        }
        return null;
    }

    public static IASTName getTemplateName(ICPPASTTemplateDeclaration templateDecl) {
        if (templateDecl == null) {
            return null;
        }
        ICPPASTTemplateDeclaration decl = templateDecl;
        while (decl.getParent() instanceof ICPPASTTemplateDeclaration) {
            decl = (ICPPASTTemplateDeclaration)decl.getParent();
        }
        IASTDeclaration nestedDecl = templateDecl.getDeclaration();
        while (nestedDecl instanceof ICPPASTTemplateDeclaration) {
            nestedDecl = ((ICPPASTTemplateDeclaration)nestedDecl).getDeclaration();
        }
        IASTName name = null;
        if (nestedDecl instanceof IASTSimpleDeclaration) {
            IASTSimpleDeclaration simple = (IASTSimpleDeclaration)nestedDecl;
            if (simple.getDeclarators().length == 1) {
                IASTDeclarator dtor = simple.getDeclarators()[0];
                while (dtor.getNestedDeclarator() != null) {
                    dtor = dtor.getNestedDeclarator();
                }
                name = dtor.getName();
            } else if (simple.getDeclarators().length == 0) {
                IASTDeclSpecifier spec = simple.getDeclSpecifier();
                if (spec instanceof ICPPASTCompositeTypeSpecifier) {
                    name = ((ICPPASTCompositeTypeSpecifier)spec).getName();
                } else if (spec instanceof ICPPASTElaboratedTypeSpecifier) {
                    name = ((ICPPASTElaboratedTypeSpecifier)spec).getName();
                }
            }
        } else if (nestedDecl instanceof IASTFunctionDefinition) {
            IASTDeclarator declarator = ((IASTFunctionDefinition)nestedDecl).getDeclarator();
            declarator = ASTQueries.findInnermostDeclarator(declarator);
            name = declarator.getName();
        }
        if (name != null) {
            if (name instanceof ICPPASTQualifiedName) {
                ICPPASTNameSpecifier[] qualifier = ((ICPPASTQualifiedName)name).getQualifier();
                IASTDeclaration currDecl = decl;
                ICPPASTNameSpecifier[] iCPPASTNameSpecifierArray = qualifier;
                int n = qualifier.length;
                int n2 = 0;
                while (n2 < n) {
                    ICPPASTNameSpecifier segment = iCPPASTNameSpecifierArray[n2];
                    if (segment instanceof ICPPASTTemplateId) {
                        if (currDecl == templateDecl) {
                            return (IASTName)((Object)segment);
                        }
                        if (!(currDecl instanceof ICPPASTTemplateDeclaration)) {
                            return null;
                        }
                        currDecl = currDecl.getDeclaration();
                    }
                    ++n2;
                }
                if (currDecl == templateDecl) {
                    return name.getLastName();
                }
            } else {
                return name;
            }
        }
        return null;
    }

    public static boolean areSameArguments(ICPPTemplateArgument[] args, ICPPTemplateArgument[] specArgs) {
        if (args.length != specArgs.length) {
            return false;
        }
        int i = 0;
        while (i < args.length) {
            if (!specArgs[i].isSameValue(args[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static ICPPTemplateArgument[] createTemplateArgumentArray(ICPPASTTemplateId id) throws DOMException {
        ICPPTemplateArgument[] result = ICPPTemplateArgument.EMPTY_ARGUMENTS;
        if (id != null) {
            IASTNode[] args = id.getTemplateArguments();
            result = new ICPPTemplateArgument[args.length];
            int i = 0;
            while (i < args.length) {
                IASTNode arg = args[i];
                if (arg instanceof IASTTypeId) {
                    result[i] = new CPPTemplateTypeArgument(CPPVisitor.createType((IASTTypeId)arg));
                } else if (arg instanceof ICPPASTExpression) {
                    ICPPASTExpression expr = (ICPPASTExpression)arg;
                    result[i] = new CPPTemplateNonTypeArgument(expr.getEvaluation(), expr);
                } else {
                    if (arg instanceof ICPPASTAmbiguousTemplateArgument) {
                        ProblemBinding problem = new ProblemBinding(id, 15);
                        throw new DOMException(problem);
                    }
                    throw new IllegalArgumentException("Unexpected type: " + arg.getClass().getName());
                }
                ++i;
            }
        }
        return result;
    }

    static ICPPFunction[] instantiateForFunctionCall(ICPPFunction[] fns, ICPPTemplateArgument[] tmplArgs, List<IType> fnArgs, List<IASTExpression.ValueCategory> argCats, boolean withImpliedObjectArg, IASTNode point) {
        boolean requireTemplate = tmplArgs != null;
        boolean haveTemplate = false;
        ICPPFunction[] iCPPFunctionArray = fns;
        int n = fns.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPFunction func = iCPPFunctionArray[n2];
            if (func instanceof ICPPConstructor || func instanceof ICPPMethod && ((ICPPMethod)func).isDestructor()) {
                requireTemplate = false;
            }
            if (func instanceof ICPPFunctionTemplate) {
                if (CPPTemplates.containsDependentType(fnArgs)) {
                    return new ICPPFunction[]{CPPDeferredFunction.createForCandidates(fns)};
                }
                if (requireTemplate && CPPTemplates.hasDependentArgument(tmplArgs)) {
                    return new ICPPFunction[]{CPPDeferredFunction.createForCandidates(fns)};
                }
                haveTemplate = true;
                break;
            }
            ++n2;
        }
        if (!haveTemplate && !requireTemplate) {
            return fns;
        }
        ArrayList<ICPPFunction> result = new ArrayList<ICPPFunction>(fns.length);
        ICPPFunction[] iCPPFunctionArray2 = fns;
        int n3 = fns.length;
        n = 0;
        while (n < n3) {
            ICPPFunction fn = iCPPFunctionArray2[n];
            if (fn != null) {
                if (fn instanceof ICPPFunctionTemplate) {
                    ICPPFunctionTemplate fnTmpl = (ICPPFunctionTemplate)fn;
                    ICPPFunction inst = CPPTemplates.instantiateForFunctionCall(fnTmpl, tmplArgs, fnArgs, argCats, withImpliedObjectArg, point);
                    if (inst != null) {
                        result.add(inst);
                    }
                } else if (!requireTemplate || fn instanceof ICPPUnknownBinding) {
                    result.add(fn);
                }
            }
            ++n;
        }
        return result.toArray(new ICPPFunction[result.size()]);
    }

    private static ICPPFunction instantiateForFunctionCall(ICPPFunctionTemplate template, ICPPTemplateArgument[] tmplArgs, List<IType> fnArgs, List<IASTExpression.ValueCategory> argCats, boolean withImpliedObjectArg, IASTNode point) {
        if (withImpliedObjectArg && template instanceof ICPPMethod) {
            fnArgs = fnArgs.subList(1, fnArgs.size());
            argCats = argCats.subList(1, argCats.size());
        }
        CPPTemplateParameterMap map = new CPPTemplateParameterMap(fnArgs.size());
        try {
            ICPPFunction f;
            IBinding instance;
            ICPPTemplateArgument[] args = TemplateArgumentDeduction.deduceForFunctionCall(template, tmplArgs, fnArgs, argCats, map, point);
            if (args != null && (instance = CPPTemplates.instantiateFunctionTemplate(template, args, map, point)) instanceof ICPPFunction && SemanticUtil.isValidType((f = (ICPPFunction)instance).getType())) {
                return f;
            }
        }
        catch (DOMException dOMException) {}
        return null;
    }

    static ICPPFunction[] instantiateConversionTemplates(ICPPFunction[] functions, IType conversionType, IASTNode point) {
        boolean checkedForDependentType = false;
        ICPPFunction[] result = functions;
        int i = 0;
        boolean done = false;
        ICPPFunction[] iCPPFunctionArray = functions;
        int n = functions.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPFunction f;
            ICPPFunction inst = f = iCPPFunctionArray[n2];
            if (f instanceof ICPPFunctionTemplate) {
                ICPPFunctionTemplate template = (ICPPFunctionTemplate)f;
                inst = null;
                if (!checkedForDependentType) {
                    if (CPPTemplates.isDependentType(conversionType)) {
                        inst = CPPDeferredFunction.createForCandidates(functions);
                        done = true;
                    }
                    checkedForDependentType = true;
                }
                CPPTemplateParameterMap map = new CPPTemplateParameterMap(1);
                try {
                    IBinding instance;
                    ICPPTemplateArgument[] args = TemplateArgumentDeduction.deduceForConversion(template, conversionType, map, point);
                    if (args != null && (instance = CPPTemplates.instantiateFunctionTemplate(template, args, map, point)) instanceof ICPPFunction) {
                        inst = (ICPPFunction)instance;
                    }
                }
                catch (DOMException dOMException) {}
            }
            if (result != functions || f != inst) {
                if (result == functions) {
                    result = new ICPPFunction[functions.length];
                    System.arraycopy(functions, 0, result, 0, i);
                }
                result[i++] = inst;
            }
            if (done) break;
            ++n2;
        }
        return result;
    }

    static ICPPFunction instantiateForFunctionDeclaration(ICPPFunctionTemplate template, ICPPTemplateArgument[] args, ICPPFunctionType functionType, IASTNode point) {
        CPPTemplateParameterMap map = new CPPTemplateParameterMap(1);
        try {
            IBinding instance;
            args = TemplateArgumentDeduction.deduceForDeclaration(template, args, functionType, map, point);
            if (args != null && (instance = CPPTemplates.instantiateFunctionTemplate(template, args, map, point)) instanceof ICPPFunction) {
                return (ICPPFunction)instance;
            }
        }
        catch (DOMException dOMException) {}
        return null;
    }

    static ICPPFunction instantiateForAddressOfFunction(ICPPFunctionTemplate template, IFunctionType target, ICPPTemplateArgument[] args, IASTNode point) {
        try {
            IBinding instance;
            CPPTemplateParameterMap map;
            if (target != null && CPPTemplates.isDependentType(target)) {
                return CPPDeferredFunction.createForCandidates(template);
            }
            if (template instanceof ICPPConstructor || args == null) {
                args = ICPPTemplateArgument.EMPTY_ARGUMENTS;
            }
            if ((args = TemplateArgumentDeduction.deduceForAddressOf(template, args, target, map = new CPPTemplateParameterMap(4), point)) != null && (instance = CPPTemplates.instantiateFunctionTemplate(template, args, map, point)) instanceof ICPPFunction) {
                return (ICPPFunction)instance;
            }
        }
        catch (DOMException dOMException) {}
        return null;
    }

    static int orderFunctionTemplates(ICPPFunctionTemplate f1, ICPPFunctionTemplate f2, TypeSelection mode, IASTNode point) throws DOMException {
        int s2;
        if (f1 == f2) {
            return 0;
        }
        if (f1 == null) {
            return -1;
        }
        if (f2 == null) {
            return 1;
        }
        int s1 = CPPTemplates.compareSpecialization(f1, f2, mode, point);
        if (s1 == (s2 = CPPTemplates.compareSpecialization(f2, f1, mode, point))) {
            return 0;
        }
        if (s1 < 0 || s2 > 0) {
            return -1;
        }
        assert (s2 < 0 || s1 > 0);
        return 1;
    }

    private static ICPPFunction transferFunctionTemplate(ICPPFunctionTemplate f, IASTNode point) throws DOMException {
        ICPPTemplateParameter[] tpars = f.getTemplateParameters();
        int argLen = tpars.length;
        ICPPTemplateArgument[] args = new ICPPTemplateArgument[argLen];
        CPPTemplateParameterMap map = new CPPTemplateParameterMap(argLen);
        int i = 0;
        while (i < argLen) {
            ICPPTemplateArgument arg;
            ICPPTemplateParameter tpar = tpars[i];
            args[i] = arg = CPPTemplates.uniqueArg(tpar);
            if (tpar.isParameterPack()) {
                map.put(tpar, new ICPPTemplateArgument[]{arg});
            } else {
                map.put(tpar, arg);
            }
            ++i;
        }
        IBinding result = CPPTemplates.instantiateFunctionTemplate(f, args, map, point);
        if (result instanceof ICPPFunction) {
            return (ICPPFunction)result;
        }
        return null;
    }

    private static ICPPTemplateArgument uniqueArg(ICPPTemplateParameter tpar) throws DOMException {
        ICPPTemplateArgument arg = tpar instanceof ICPPTemplateNonTypeParameter ? new CPPTemplateNonTypeArgument(Value.unique(), ((ICPPTemplateNonTypeParameter)tpar).getType()) : new CPPTemplateTypeArgument(new UniqueType(tpar.isParameterPack()));
        return arg;
    }

    private static ICPPFunctionType getFunctionTypeIgnoringParametersWithDefaults(ICPPFunction function) {
        ICPPParameter[] parameters = function.getParameters();
        IType[] parameterTypes = new IType[parameters.length];
        int i = 0;
        while (i < parameters.length) {
            ICPPParameter parameter = parameters[i];
            if (parameter.hasDefaultValue()) break;
            parameterTypes[i] = parameter.getType();
            ++i;
        }
        ICPPFunctionType originalType = function.getType();
        if (i == parameters.length) {
            return originalType;
        }
        return new CPPFunctionType(originalType.getReturnType(), ArrayUtil.trim(parameterTypes), originalType.isConst(), originalType.isVolatile(), originalType.takesVarArgs());
    }

    private static int compareSpecialization(ICPPFunctionTemplate f1, ICPPFunctionTemplate f2, TypeSelection mode, IASTNode point) throws DOMException {
        IType[] args;
        IType[] pars;
        ICPPFunction transF1 = CPPTemplates.transferFunctionTemplate(f1, point);
        if (transF1 == null) {
            return -1;
        }
        ICPPFunctionType ft2 = f2.getType();
        ICPPFunctionType transFt1 = CPPTemplates.getFunctionTypeIgnoringParametersWithDefaults(transF1);
        switch (mode) {
            case RETURN_TYPE: {
                pars = new IType[]{ft2.getReturnType()};
                args = new IType[]{transFt1.getReturnType()};
                break;
            }
            case PARAMETERS_AND_RETURN_TYPE: {
                pars = CPPTemplates.concat(ft2.getReturnType(), ft2.getParameterTypes());
                args = CPPTemplates.concat(transFt1.getReturnType(), transFt1.getParameterTypes());
                break;
            }
            default: {
                pars = ft2.getParameterTypes();
                args = transFt1.getParameterTypes();
                boolean nonStaticMember1 = CPPTemplates.isNonStaticMember(f1);
                boolean nonStaticMember2 = CPPTemplates.isNonStaticMember(f2);
                if (nonStaticMember1 == nonStaticMember2) break;
                if (nonStaticMember1) {
                    args = CPPTemplates.addImplicitParameterType(args, (ICPPMethod)((Object)f1));
                    break;
                }
                pars = CPPTemplates.addImplicitParameterType(pars, (ICPPMethod)((Object)f2));
            }
        }
        return TemplateArgumentDeduction.deduceForPartialOrdering(f2.getTemplateParameters(), pars, args, point);
    }

    private static boolean isNonStaticMember(ICPPFunctionTemplate f) {
        return f instanceof ICPPMethod && !((ICPPMethod)((Object)f)).isStatic();
    }

    private static IType[] addImplicitParameterType(IType[] types, ICPPMethod m) {
        try {
            IType t = CPPSemantics.getImplicitParameterType(m);
            return CPPTemplates.concat(t, types);
        }
        catch (DOMException dOMException) {
            return types;
        }
    }

    private static IType[] concat(IType t, IType[] types) {
        IType[] result = new IType[types.length + 1];
        result[0] = t;
        System.arraycopy(types, 0, result, 1, types.length);
        return result;
    }

    private static ICPPClassTemplatePartialSpecialization findPartialSpecialization(ICPPClassTemplate ct, ICPPTemplateArgument[] args) throws DOMException {
        ICPPClassTemplatePartialSpecialization[] pspecs = ct.getPartialSpecializations();
        if (pspecs != null && pspecs.length > 0) {
            String argStr = ASTTypeUtil.getArgumentListString(args, true);
            ICPPClassTemplatePartialSpecialization[] iCPPClassTemplatePartialSpecializationArray = pspecs;
            int n = pspecs.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPClassTemplatePartialSpecialization pspec = iCPPClassTemplatePartialSpecializationArray[n2];
                if (argStr.equals(ASTTypeUtil.getArgumentListString(pspec.getTemplateArguments(), true))) {
                    return pspec;
                }
                ++n2;
            }
        }
        return null;
    }

    private static IBinding selectSpecialization(ICPPClassTemplate template, ICPPTemplateArgument[] args, boolean isDef, IASTNode point) throws DOMException {
        if (template == null) {
            return null;
        }
        ICPPClassTemplatePartialSpecialization[] specializations = template.getPartialSpecializations();
        if (specializations == null || specializations.length == 0) {
            return null;
        }
        ICPPClassTemplatePartialSpecialization bestMatch = null;
        CPPTemplateParameterMap bestMap = null;
        boolean bestMatchIsBest = true;
        ICPPClassTemplatePartialSpecialization[] iCPPClassTemplatePartialSpecializationArray = specializations;
        int n = specializations.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPClassTemplatePartialSpecialization specialization = iCPPClassTemplatePartialSpecializationArray[n2];
            CPPTemplateParameterMap map = new CPPTemplateParameterMap(args.length);
            ICPPTemplateArgument[] specializationArguments = specialization.getTemplateArguments();
            if (TemplateArgumentDeduction.fromTemplateArguments(specialization.getTemplateParameters(), specializationArguments, args, map, point) && CPPTemplates.checkInstantiationOfArguments(specializationArguments, map, point)) {
                int compare = CPPTemplates.orderSpecializations(bestMatch, specialization, point);
                if (compare == 0) {
                    bestMatchIsBest = false;
                } else if (compare < 0) {
                    bestMatch = specialization;
                    bestMap = map;
                    bestMatchIsBest = true;
                }
            }
            ++n2;
        }
        if (!bestMatchIsBest) {
            return new CPPTemplateDefinition.CPPTemplateProblem(point, 4, template.getNameCharArray());
        }
        if (bestMatch == null) {
            return null;
        }
        return CPPTemplates.instantiatePartialSpecialization(bestMatch, args, isDef, bestMap, point);
    }

    private static boolean checkInstantiationOfArguments(ICPPTemplateArgument[] args, CPPTemplateParameterMap tpMap, IASTNode point) throws DOMException {
        return CPPTemplates.instantiateArguments(args, tpMap, -1, null, point, true) != null;
    }

    private static int orderSpecializations(ICPPClassTemplatePartialSpecialization spec1, ICPPClassTemplatePartialSpecialization spec2, IASTNode point) throws DOMException {
        boolean f2IsAtLeastAsSpecializedAsF1;
        if (spec1 == null) {
            return -1;
        }
        boolean f1IsAtLeastAsSpecializedAsF2 = CPPTemplates.isAtLeastAsSpecializedAs(spec1, spec2, point);
        if (f1IsAtLeastAsSpecializedAsF2 == (f2IsAtLeastAsSpecializedAsF1 = CPPTemplates.isAtLeastAsSpecializedAs(spec2, spec1, point))) {
            return 0;
        }
        if (f1IsAtLeastAsSpecializedAsF2) {
            return 1;
        }
        return -1;
    }

    private static boolean isAtLeastAsSpecializedAs(ICPPClassTemplatePartialSpecialization f1, ICPPClassTemplatePartialSpecialization f2, IASTNode point) throws DOMException {
        ICPPTemplateParameter[] tpars1 = f1.getTemplateParameters();
        ICPPTemplateParameter[] tpars2 = f2.getTemplateParameters();
        ICPPTemplateArgument[] targs1 = f1.getTemplateArguments();
        ICPPTemplateArgument[] targs2 = f2.getTemplateArguments();
        int tpars1Len = tpars1.length;
        ICPPTemplateArgument[] args = new ICPPTemplateArgument[tpars1Len];
        CPPTemplateParameterMap transferMap = new CPPTemplateParameterMap(tpars1Len);
        int i = 0;
        while (i < tpars1Len) {
            ICPPTemplateArgument arg;
            ICPPTemplateParameter param = tpars1[i];
            args[i] = arg = CPPTemplates.uniqueArg(param);
            if (param.isParameterPack()) {
                transferMap.put(param, new ICPPTemplateArgument[]{arg});
            } else {
                transferMap.put(param, arg);
            }
            ++i;
        }
        ICPPTemplateArgument[] transferredArgs1 = CPPTemplates.instantiateArguments(targs1, transferMap, -1, null, point, false);
        CPPTemplateParameterMap deductionMap = new CPPTemplateParameterMap(2);
        return TemplateArgumentDeduction.fromTemplateArguments(tpars2, targs2, transferredArgs1, deductionMap, point);
    }

    static boolean isValidArgument(ICPPTemplateArgument arg) {
        return arg != null && SemanticUtil.isValidType(arg.isTypeValue() ? arg.getTypeValue() : arg.getTypeOfNonTypeValue());
    }

    static ICPPTemplateArgument matchTemplateParameterAndArgument(ICPPTemplateDefinition template, ICPPTemplateParameter param, ICPPTemplateArgument arg, CPPTemplateParameterMap map, IASTNode point) {
        if (arg == null || !SemanticUtil.isValidType(arg.getTypeValue())) {
            return null;
        }
        if (param instanceof ICPPTemplateTypeParameter) {
            IType t = arg.getTypeValue();
            if (t != null && !(t instanceof ICPPTemplateDefinition)) {
                return arg;
            }
            return null;
        }
        if (param instanceof ICPPTemplateTemplateParameter) {
            IType t = arg.getTypeValue();
            while (!(t instanceof ICPPTemplateDefinition)) {
                if (t instanceof ICPPClassSpecialization) {
                    t = ((ICPPClassSpecialization)t).getSpecializedBinding();
                    continue;
                }
                return null;
            }
            ICPPTemplateParameter[] pParams = null;
            ICPPTemplateParameter[] aParams = null;
            try {
                pParams = ((ICPPTemplateTemplateParameter)param).getTemplateParameters();
                aParams = ((ICPPTemplateDefinition)((Object)t)).getTemplateParameters();
                if (!CPPTemplates.matchTemplateTemplateParameters(pParams, aParams)) {
                    return null;
                }
            }
            catch (DOMException dOMException) {
                return null;
            }
            return arg;
        }
        if (param instanceof ICPPTemplateNonTypeParameter) {
            if (!arg.isNonTypeValue()) {
                return null;
            }
            IType argType = arg.getTypeOfNonTypeValue();
            try {
                IType pType = ((ICPPTemplateNonTypeParameter)param).getType();
                if (pType instanceof ICPPParameterPackType) {
                    pType = ((ICPPParameterPackType)pType).getType();
                }
                if (map != null && pType != null) {
                    pType = CPPTemplates.instantiateType(pType, map, -1, null, point);
                }
                if (argType instanceof ICPPParameterPackType) {
                    argType = ((ICPPParameterPackType)argType).getType();
                }
                if (argType instanceof ICPPUnknownType) {
                    return new CPPTemplateNonTypeArgument(arg.getNonTypeValue(), pType);
                }
                return CPPTemplates.convertNonTypeTemplateArgument(template, pType, arg, point);
            }
            catch (DOMException dOMException) {
                return null;
            }
        }
        assert (false);
        return null;
    }

    private static boolean matchTemplateTemplateParameters(ICPPTemplateParameter[] pParams, ICPPTemplateParameter[] aParams) throws DOMException {
        int pi = 0;
        int ai = 0;
        while (pi < pParams.length && ai < aParams.length) {
            ICPPTemplateParameter pp = pParams[pi];
            ICPPTemplateParameter ap = aParams[ai];
            if (ap.isParameterPack() && !pp.isParameterPack()) {
                return false;
            }
            boolean pb = pp instanceof ICPPTemplateTypeParameter;
            boolean ab = ap instanceof ICPPTemplateTypeParameter;
            if (pb != ab) {
                return false;
            }
            if (!pb) {
                pb = pp instanceof ICPPTemplateNonTypeParameter;
                ab = ap instanceof ICPPTemplateNonTypeParameter;
                if (pb != ab) {
                    return false;
                }
                if (!pb) {
                    if (!(pp instanceof ICPPTemplateTemplateParameter) || !(ap instanceof ICPPTemplateTemplateParameter)) {
                        assert (false);
                        return false;
                    }
                    if (!CPPTemplates.matchTemplateTemplateParameters(((ICPPTemplateTemplateParameter)pp).getTemplateParameters(), ((ICPPTemplateTemplateParameter)ap).getTemplateParameters())) {
                        return false;
                    }
                }
            }
            if (!pp.isParameterPack()) {
                ++pi;
            }
            ++ai;
        }
        if (pi < pParams.length) {
            return pi == pParams.length - 1 && pParams[pi].isParameterPack();
        }
        return ai == aParams.length;
    }

    private static ICPPTemplateArgument convertNonTypeTemplateArgument(ICPPTemplateDefinition template, IType paramType, ICPPTemplateArgument arg, IASTNode point) throws DOMException {
        IType p;
        IType a = arg.getTypeOfNonTypeValue();
        if (paramType instanceof IFunctionType) {
            p = new CPPPointerType(paramType);
        } else if (paramType instanceof IArrayType) {
            p = new CPPPointerType(((IArrayType)paramType).getType());
        } else {
            p = paramType;
            if (p.isSameType(a)) {
                return arg;
            }
        }
        if (a instanceof FunctionSetType) {
            if (p instanceof IPointerType) {
                p = ((IPointerType)p).getType();
            }
            if (p instanceof IFunctionType) {
                CPPFunctionSet functionSet = ((FunctionSetType)a).getFunctionSet();
                ICPPFunction[] iCPPFunctionArray = functionSet.getBindings();
                int n = iCPPFunctionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ICPPFunction f = iCPPFunctionArray[n2];
                    if (p.isSameType(f.getType())) {
                        functionSet.applySelectedFunction(f);
                        return new CPPTemplateNonTypeArgument(new EvalBinding((IBinding)f, null, template), point);
                    }
                    ++n2;
                }
            }
            return null;
        }
        Cost cost = Conversions.checkImplicitConversionSequence(p, a, IASTExpression.ValueCategory.LVALUE, Conversions.UDCMode.FORBIDDEN, Conversions.Context.ORDINARY, point);
        if (cost == null || !cost.converts()) {
            return null;
        }
        return new CPPTemplateNonTypeArgument(arg.getNonTypeValue(), paramType);
    }

    static boolean argsAreTrivial(ICPPTemplateParameter[] pars, ICPPTemplateArgument[] args) {
        if (pars.length != args.length) {
            return false;
        }
        int i = 0;
        while (i < args.length) {
            ICPPTemplateParameter par = pars[i];
            ICPPTemplateArgument arg = args[i];
            if (par instanceof IType) {
                if (arg.isNonTypeValue()) {
                    return false;
                }
                IType argType = arg.getTypeValue();
                if (argType == null) {
                    return false;
                }
                if (par.isParameterPack()) {
                    if (!(argType instanceof ICPPParameterPackType)) {
                        return false;
                    }
                    if ((argType = ((ICPPParameterPackType)argType).getType()) == null) {
                        return false;
                    }
                }
                if (!argType.isSameType((IType)((Object)par))) {
                    return false;
                }
            } else {
                if (arg.isTypeValue()) {
                    return false;
                }
                if (par.isParameterPack() != arg.isPackExpansion()) {
                    return false;
                }
                int parpos = Value.isTemplateParameter(arg.getNonTypeValue());
                if (parpos != par.getParameterID()) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public static boolean hasDependentArgument(ICPPTemplateArgument[] args) {
        ICPPTemplateArgument[] iCPPTemplateArgumentArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPTemplateArgument arg = iCPPTemplateArgumentArray[n2];
            if (CPPTemplates.isDependentArgument(arg)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isDependentArgument(ICPPTemplateArgument arg) {
        if (arg.isTypeValue()) {
            return CPPTemplates.isDependentType(arg.getTypeValue());
        }
        ICPPEvaluation evaluation = arg.getNonTypeEvaluation();
        return evaluation.isTypeDependent() || evaluation.isValueDependent();
    }

    public static boolean containsDependentType(List<IType> ts) {
        for (IType t : ts) {
            if (!CPPTemplates.isDependentType(t)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsDependentType(IType[] ts) {
        IType[] iTypeArray = ts;
        int n = ts.length;
        int n2 = 0;
        while (n2 < n) {
            IType t = iTypeArray[n2];
            if (CPPTemplates.isDependentType(t)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isDependentType(IType t) {
        while (true) {
            IValue asize;
            if (t instanceof ICPPUnknownType) {
                return true;
            }
            if (t instanceof ICPPFunctionType) {
                ICPPFunctionType ft = (ICPPFunctionType)t;
                if (CPPTemplates.containsDependentType(ft.getParameterTypes())) {
                    return true;
                }
                t = ft.getReturnType();
                continue;
            }
            if (t instanceof ICPPPointerToMemberType) {
                ICPPPointerToMemberType ptmt = (ICPPPointerToMemberType)t;
                if (CPPTemplates.isDependentType(ptmt.getMemberOfClass())) {
                    return true;
                }
                t = ptmt.getType();
                continue;
            }
            if (t instanceof ICPPParameterPackType) {
                return true;
            }
            if (!(t instanceof ITypeContainer)) break;
            if (t instanceof IArrayType && (asize = ((IArrayType)t).getSize()) != null && Value.isDependentValue(asize)) {
                return true;
            }
            t = ((ITypeContainer)t).getType();
        }
        if (t instanceof InitializerListType) {
            return ((InitializerListType)t).getEvaluation().isTypeDependent();
        }
        if (t instanceof IBinding) {
            IBinding owner = ((IBinding)((Object)t)).getOwner();
            if (owner instanceof ICPPClassTemplate) {
                return true;
            }
            return owner instanceof IType && owner != t && CPPTemplates.isDependentType((IType)((Object)owner));
        }
        return false;
    }

    public static boolean containsDependentArg(ObjectMap tpMap) {
        Object[] objectArray = tpMap.valueArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object arg = objectArray[n2];
            if (CPPTemplates.isDependentType((IType)arg)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static IBinding resolveUnknown(ICPPUnknownBinding unknown, ICPPTemplateParameterMap tpMap, int packOffset, ICPPClassSpecialization within, IASTNode point) throws DOMException {
        IType type;
        if (unknown instanceof ICPPDeferredClassInstance) {
            return CPPTemplates.resolveDeferredClassInstance((ICPPDeferredClassInstance)unknown, tpMap, packOffset, within, point);
        }
        if (unknown instanceof ICPPUnknownMember) {
            return CPPTemplates.resolveUnknownMember((ICPPUnknownMember)unknown, tpMap, packOffset, within, point);
        }
        if (unknown instanceof ICPPTemplateParameter && unknown instanceof IType && (type = CPPTemplates.resolveTemplateTypeParameter((ICPPTemplateParameter)((Object)unknown), tpMap, packOffset, point)) instanceof IBinding) {
            return (IBinding)((Object)type);
        }
        if (unknown instanceof TypeOfDependentExpression && (type = CPPTemplates.instantiateType((IType)((Object)unknown), tpMap, packOffset, within, point)) instanceof IBinding) {
            return (IBinding)((Object)type);
        }
        return unknown;
    }

    private static IBinding resolveUnknownMember(ICPPUnknownMember unknown, ICPPTemplateParameterMap tpMap, int packOffset, ICPPClassSpecialization within, IASTNode point) throws DOMException {
        IType ot0 = unknown.getOwnerType();
        if (ot0 == null) {
            return unknown;
        }
        IBinding result = unknown;
        IType ot1 = CPPTemplates.instantiateType(ot0, tpMap, packOffset, within, point);
        if (ot1 != null) {
            if ((ot1 = SemanticUtil.getUltimateType(ot1, false)) instanceof ICPPUnknownType) {
                if (unknown instanceof ICPPUnknownMemberClassInstance) {
                    ICPPTemplateArgument[] args1;
                    ICPPUnknownMemberClassInstance ucli = (ICPPUnknownMemberClassInstance)unknown;
                    ICPPTemplateArgument[] args0 = ucli.getArguments();
                    if (args0 != (args1 = CPPTemplates.instantiateArguments(args0, tpMap, packOffset, within, point, false)) || !ot1.isSameType(ot0)) {
                        args1 = SemanticUtil.getSimplifiedArguments(args1);
                        result = new CPPUnknownClassInstance(ot1, ucli.getNameCharArray(), args1);
                    }
                } else if (!ot1.isSameType(ot0)) {
                    result = unknown instanceof ICPPUnknownMemberClass ? new CPPUnknownMemberClass(ot1, unknown.getNameCharArray()) : new CPPUnknownMethod(ot1, unknown.getNameCharArray());
                }
            } else if (ot1 instanceof ICPPClassType) {
                IScope s = ((ICPPClassType)ot1).getCompositeScope();
                if (s != null) {
                    result = CPPSemantics.resolveUnknownName(s, unknown, point);
                    if (unknown instanceof ICPPUnknownMemberClassInstance && result instanceof ICPPTemplateDefinition) {
                        ICPPTemplateArgument[] args1 = CPPTemplates.instantiateArguments(((ICPPUnknownMemberClassInstance)unknown).getArguments(), tpMap, packOffset, within, point, false);
                        if (result instanceof ICPPClassTemplate) {
                            result = CPPTemplates.instantiate((ICPPClassTemplate)result, args1, point);
                        }
                    }
                }
            } else if (ot1 != ot0) {
                return new ProblemBinding((IASTName)new CPPASTName(unknown.getNameCharArray()), point, 10);
            }
        }
        return result;
    }

    private static IBinding resolveDeferredClassInstance(ICPPDeferredClassInstance dci, ICPPTemplateParameterMap tpMap, int packOffset, ICPPClassSpecialization within, IASTNode point) {
        IBinding inst;
        ICPPTemplateArgument[] newArgs;
        ICPPClassTemplate classTemplate = dci.getClassTemplate();
        ICPPTemplateArgument[] arguments = dci.getTemplateArguments();
        try {
            newArgs = CPPTemplates.instantiateArguments(arguments, tpMap, packOffset, within, point, true);
        }
        catch (DOMException e) {
            return e.getProblem();
        }
        if (newArgs == null) {
            return CPPTemplates.createProblem(classTemplate, 15, point);
        }
        boolean changed = arguments != newArgs;
        IType classTemplateSpecialization = CPPTemplates.instantiateType(classTemplate, tpMap, packOffset, within, point);
        if (classTemplateSpecialization != classTemplate && classTemplateSpecialization instanceof ICPPClassTemplate) {
            classTemplate = (ICPPClassTemplate)classTemplateSpecialization;
            changed = true;
        }
        if (changed && (inst = CPPTemplates.instantiate(classTemplate, newArgs, point)) != null) {
            return inst;
        }
        return dci;
    }

    public static boolean haveSameArguments(ICPPTemplateInstance i1, ICPPTemplateInstance i2) {
        ICPPTemplateArgument[] m1 = i1.getTemplateArguments();
        ICPPTemplateArgument[] m2 = i2.getTemplateArguments();
        if (m1 == null || m2 == null || m1.length != m2.length) {
            return false;
        }
        String s1 = ASTTypeUtil.getArgumentListString(m1, true);
        String s2 = ASTTypeUtil.getArgumentListString(m2, true);
        return s1.equals(s2);
    }

    public static ICPPTemplateParameterMap createParameterMap(ICPPTemplateDefinition tdef, ICPPTemplateArgument[] args) {
        ICPPTemplateParameter[] tpars = tdef.getTemplateParameters();
        int len = Math.min(tpars.length, args.length);
        CPPTemplateParameterMap result = new CPPTemplateParameterMap(len);
        int i = 0;
        while (i < len) {
            result.put(tpars[i], args[i]);
            ++i;
        }
        return result;
    }

    @Deprecated
    public static IType[] getArguments(ICPPTemplateArgument[] arguments) {
        IType[] types = new IType[arguments.length];
        int i = 0;
        while (i < types.length) {
            ICPPTemplateArgument arg = arguments[i];
            types[i] = arg == null ? null : (arg.isNonTypeValue() ? arg.getTypeOfNonTypeValue() : arg.getTypeValue());
            ++i;
        }
        return types;
    }

    @Deprecated
    public static ObjectMap getArgumentMap(IBinding b, ICPPTemplateParameterMap tpmap) {
        Integer[] keys = tpmap.getAllParameterPositions();
        if (keys.length == 0) {
            return ObjectMap.EMPTY_MAP;
        }
        ArrayList<ICPPTemplateDefinition> defs = new ArrayList<ICPPTemplateDefinition>();
        IBinding owner = b;
        while (owner != null) {
            if (owner instanceof ICPPTemplateDefinition) {
                defs.add((ICPPTemplateDefinition)owner);
            } else if (owner instanceof ICPPTemplateInstance) {
                defs.add(((ICPPTemplateInstance)owner).getTemplateDefinition());
            }
            owner = owner.getOwner();
        }
        Collections.reverse(defs);
        ObjectMap result = new ObjectMap(keys.length);
        Integer[] integerArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPTemplateArgument arg;
            ICPPTemplateDefinition tdef;
            ICPPTemplateParameter[] tps;
            int key = integerArray[n2];
            int nestingLevel = key >> 16;
            int numParam = key & 0xFFFF;
            if (numParam >= 0 && nestingLevel >= 0 && nestingLevel < defs.size() && numParam < (tps = (tdef = (ICPPTemplateDefinition)defs.get(nestingLevel)).getTemplateParameters()).length && (arg = tpmap.getArgument(key)) != null) {
                IType type = arg.isNonTypeValue() ? arg.getTypeOfNonTypeValue() : arg.getTypeValue();
                result.put(tps[numParam], type);
            }
            ++n2;
        }
        return result;
    }

    public static IBinding findDeclarationForSpecialization(IBinding binding) {
        while (binding instanceof ICPPSpecialization) {
            if (ASTInternal.hasDeclaration(binding)) {
                return binding;
            }
            IBinding original = ((ICPPSpecialization)binding).getSpecializedBinding();
            if (original == null) {
                return binding;
            }
            binding = original;
        }
        return binding;
    }

    static enum TypeSelection {
        PARAMETERS,
        RETURN_TYPE,
        PARAMETERS_AND_RETURN_TYPE;

    }
}

