/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.adapter.api;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;

public class LinkedDataSetUtil {
    private static String GET_LINKED_DATA_MODEL_METHOD = "getLinkedDataModel";

    public static boolean bindToLinkedDataSet(ReportItemHandle reportItemHandle) {
        Method[] methods = reportItemHandle.getClass().getMethods();
        int i = 0;
        while (i < methods.length) {
            String name = methods[i].getName();
            if (name.equals(GET_LINKED_DATA_MODEL_METHOD)) {
                Object result = null;
                try {
                    result = methods[i].invoke((Object)reportItemHandle, new Object[0]);
                }
                catch (Exception exception) {
                    return false;
                }
                if (result != null) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isAggregationBinding(ComputedColumnHandle computed, ReportItemHandle handle) {
        if (computed.getAggregateFunction() != null) {
            return true;
        }
        try {
            Iterator iter = handle.columnBindingsIterator();
            HashSet aggregationBinding = new HashSet();
            LinkedDataSetUtil.populateAggregationBindingNames(aggregationBinding, iter);
            DataSetHandle dataSet = handle.getDataSet();
            if (dataSet != null && (iter = dataSet.computedColumnsIterator()) != null) {
                LinkedDataSetUtil.populateAggregationBindingNames(aggregationBinding, iter);
            }
            ArrayList referedColumn = new ArrayList();
            referedColumn.addAll(ExpressionUtil.extractColumnExpressions((String)computed.getExpression(), (String)"dataSetRow"));
            referedColumn.addAll(ExpressionUtil.extractColumnExpressions((String)computed.getExpression(), (String)"row"));
            int i = 0;
            while (true) {
                if (i >= referedColumn.size()) {
                    return false;
                }
                if (aggregationBinding.contains(referedColumn.get(i))) {
                    return true;
                }
                ++i;
            }
        }
        catch (BirtException birtException) {
            return false;
        }
    }

    private static void populateAggregationBindingNames(Set aggregationBinding, Iterator iter) throws BirtException {
        while (iter.hasNext()) {
            ComputedColumnHandle computedHandle = (ComputedColumnHandle)iter.next();
            if (computedHandle.getAggregateFunction() == null) continue;
            String columnName = null;
            columnName = ExpressionUtil.getColumnName((String)computedHandle.getExpression());
            if (columnName == null) {
                columnName = ExpressionUtil.getColumnBindingName((String)computedHandle.getExpression());
                if (columnName == null) continue;
                aggregationBinding.add(columnName);
                continue;
            }
            aggregationBinding.add(columnName);
        }
    }
}

