/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.actions;

import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.ViperImages;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.analysis.AnalysisScope;
import com.nvidia.viper.analysis.AnalysisStage;
import com.nvidia.viper.model.Analysis;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.model.TimelineIntervalKernel;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class ResetAnalysisAction
extends Action {
    private final Session session;
    private final boolean showAnalysisView;
    private final ResetOption resetOption;

    public ResetAnalysisAction(Session session, boolean showAnalysisView) {
        super(ViperMessages.ResetAnalysis_Label, ViperImages.DESC_RESET_ANALYSIS);
        this.session = session;
        this.showAnalysisView = showAnalysisView;
        this.resetOption = ResetOption.RESET_SESSION;
        this.setToolTipText(ViperMessages.ResetAnalysis_Tooltip);
        this.setId("com.nvidia.viper.resetanalysis");
    }

    public ResetAnalysisAction(Session session, boolean showAnalysisView, ResetOption resetOption) {
        super(ViperMessages.ResetAnalysis_Label, ViperImages.DESC_RESET_ANALYSIS);
        this.session = session;
        this.showAnalysisView = showAnalysisView;
        this.resetOption = resetOption;
        this.setToolTipText(ViperMessages.ResetAnalysis_Tooltip);
        this.setId("com.nvidia.viper.resetanalysis");
    }

    public void run() {
        Analysis analysis = this.session.getAnalysis();
        if (analysis != null) {
            switch (this.resetOption) {
                case RESET_ALL_ANALYSES: {
                    this.session.resetAllAnalyses();
                    analysis.setSelectedStage(AnalysisStage.NONE);
                    analysis.clearVisitedStagesExceptTimeline();
                }
                case RESET_KERNEL_ANALYSES: {
                    this.session.resetKernelAnalyses();
                    analysis.setSelectedStage(AnalysisStage.TIMELINE);
                    TimelineIntervalKernel analysisKernel = AnalysisStage.getAnalysisHostLaunchedKernel(this.session);
                    if (analysisKernel == null) break;
                    analysis.clearVisitedStages(AnalysisScope.KERNEL_INSTANCE.getAnalysisId(analysisKernel));
                    break;
                }
                case RESET_SESSION: {
                    this.session.reset();
                    analysis.setSelectedStage(AnalysisStage.NONE);
                    analysis.clearAllVisitedStages();
                    analysis.setActiveScopeInterval(null);
                }
            }
        }
        if (this.showAnalysisView) {
            try {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("com.nvidia.viper.analysisview");
            }
            catch (PartInitException partInitException) {
                ViperExceptionHandler.logError("unable to show analysis view");
            }
        }
    }

    public static enum ResetOption {
        RESET_SESSION,
        RESET_ALL_ANALYSES,
        RESET_KERNEL_ANALYSES;

    }
}

