/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui.chart;

import com.nvidia.viper.analysis.AnalysisResultKernelUnitBusy;
import com.nvidia.viper.chart.ui.AxesConfiguration;
import com.nvidia.viper.chart.ui.IViperChart;
import com.nvidia.viper.chart.ui.ViperChartSeries;
import java.util.LinkedList;
import java.util.List;

public final class KernelFunctionUnitBusyChart
implements IViperChart {
    private final AnalysisResultKernelUnitBusy result;

    public KernelFunctionUnitBusyChart(AnalysisResultKernelUnitBusy busyResult) {
        this.result = busyResult;
    }

    public ViperChartSeries[] getSeries() {
        List<AnalysisResultKernelUnitBusy.FunctionUnit> units = this.result.getFunctionUnits();
        LinkedList<Double> values = new LinkedList<Double>();
        for (AnalysisResultKernelUnitBusy.FunctionUnit unit : units) {
            values.add((double)this.result.getFunctionUnitBusy(unit).getCode() * 6.9);
        }
        return new ViperChartSeries[]{new ViperChartSeries(values.toArray(new Double[0]), ViperChartSeries.Type.STACKED_BAR, "Utilization")};
    }

    public String getTitle() {
        return null;
    }

    public boolean isHighlighted() {
        return false;
    }

    public boolean showLegend() {
        return false;
    }

    public int getHeight() {
        return 300;
    }

    public int getWidth() {
        return 700;
    }

    public AxesConfiguration getAxesConfiguration() {
        return new AxesConfiguration(null, "Utilization Level", true, Integer.valueOf(69), Integer.valueOf(1), null, Integer.valueOf(23), true, KernelFunctionUnitBusyChart.createLabelsArray(69), false);
    }

    private static String[] createLabelsArray(int arrayLength) {
        int labelStep = (arrayLength - 1) / 3;
        String[] labels = new String[arrayLength];
        String[] captions = new String[]{"Low", "Med", "High"};
        int i = 0;
        while (i < arrayLength) {
            labels[i] = (i + labelStep / 2) % labelStep == 0 ? captions[(i + labelStep / 2) / labelStep - 1] : null;
            ++i;
        }
        return labels;
    }

    public String[] getLabels() {
        List<AnalysisResultKernelUnitBusy.FunctionUnit> units = this.result.getFunctionUnits();
        LinkedList<String> labels = new LinkedList<String>();
        for (AnalysisResultKernelUnitBusy.FunctionUnit unit : units) {
            labels.add(unit.toString());
        }
        return labels.toArray(new String[0]);
    }

    public boolean colorBySeries() {
        return true;
    }
}

