/*###############################################################################
# Linux Management Providers (LMP), CPU provider package
# Copyright (C) 2007 Frederic Desmons, ETRI <desmons@etri.re.kr ,desmons_frederic@yahoo.fr>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Rakhimov Rustam, TUIT <rusyasoft@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#ifndef OPENDRIM_PROCESSORACCESS_H_
#define OPENDRIM_PROCESSORACCESS_H_

#include "CPU_Common.h"
#include <SMBIOS.h>

#include "OpenDRIM_Processor.h"

int CPU_OpenDRIM_Processor_load(const CMPIBroker* broker, string& errorMessage);

int CPU_OpenDRIM_Processor_unload(string& errorMessage);

int CPU_OpenDRIM_Processor_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_Processor>& instances, const char** properties, string& errorMessage, const string& discriminant);

int CPU_OpenDRIM_Processor_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_Processor& instance, const char** properties, string& errorMessage);

int CPU_OpenDRIM_Processor_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_Processor& newInstance, const OpenDRIM_Processor& oldInstance, const char** properties, string& errorMessage);

int CPU_OpenDRIM_Processor_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_Processor& instance, string& errorMessage);

int CPU_OpenDRIM_Processor_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_Processor& instance, string& errorMessage);

int CPU_OpenDRIM_Processor_RequestStateChange(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_Processor& instance, unsigned int& returnValue, const OpenDRIM_Processor_RequestStateChange_In& in, OpenDRIM_Processor_RequestStateChange_Out& out, string& errorMessage);

int CPU_OpenDRIM_Processor_SetPowerState(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_Processor& instance, unsigned int& returnValue, const OpenDRIM_Processor_SetPowerState_In& in, string& errorMessage);

int CPU_OpenDRIM_Processor_Reset(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_Processor& instance, unsigned int& returnValue, string& errorMessage);

int CPU_OpenDRIM_Processor_EnableDevice(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_Processor& instance, unsigned int& returnValue, const OpenDRIM_Processor_EnableDevice_In& in, string& errorMessage);

int CPU_OpenDRIM_Processor_OnlineDevice(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_Processor& instance, unsigned int& returnValue, const OpenDRIM_Processor_OnlineDevice_In& in, string& errorMessage);

int CPU_OpenDRIM_Processor_QuiesceDevice(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_Processor& instance, unsigned int& returnValue, const OpenDRIM_Processor_QuiesceDevice_In& in, string& errorMessage);

int CPU_OpenDRIM_Processor_SaveProperties(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_Processor& instance, unsigned int& returnValue, string& errorMessage);

int CPU_OpenDRIM_Processor_RestoreProperties(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_Processor& instance, unsigned int& returnValue, string& errorMessage);

int CPU_OpenDRIM_Processor_populate(OpenDRIM_Processor& instance, const _processor_topology& cpu_info_processor_information, const _processor_information& SMBIOS_processor_information, bool use_SMBIOS, string& errorMessage);

#endif /*OPENDRIM_PROCESSORACCESS_H_*/
