/*###############################################################################
# Linux Management Providers (LMP), Software Inventory provider package
# Copyright (C) 2009 Nazarov Nodir, TUIT <nazarov.nodir@gmail.com, nodir2000@yahoo.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#ifndef OPENDRIM_SOFTWAREIDENTITY_H_
#define OPENDRIM_SOFTWAREIDENTITY_H_

#include <Instance.h>

const static char* OpenDRIM_SoftwareIdentity_classnames[] = {"OpenDRIM_SoftwareIdentity"};
static string OpenDRIM_SoftwareIdentity_NAMESPACE = _NAMESPACE;

class OpenDRIM_SoftwareIdentity {

public:
	
	string Caption;
	bool Caption_isNULL;
	
	string Description;
	bool Description_isNULL;
	
	string ElementName;
	bool ElementName_isNULL;
	
	string InstallDate;
	bool InstallDate_isNULL;
	
	string Name;
	bool Name_isNULL;
	
	vector<unsigned short> OperationalStatus;
	bool OperationalStatus_isNULL;
	
	vector<string> StatusDescriptions;
	bool StatusDescriptions_isNULL;
	
	string Status;
	bool Status_isNULL;
	
	unsigned short HealthState;
	bool HealthState_isNULL;
	
	unsigned short PrimaryStatus;
	bool PrimaryStatus_isNULL;
	
	unsigned short DetailedStatus;
	bool DetailedStatus_isNULL;
	
	unsigned short OperatingStatus;
	bool OperatingStatus_isNULL;
	
	unsigned short CommunicationStatus;
	bool CommunicationStatus_isNULL;
	
	string InstanceID;
	bool InstanceID_isNULL;
	
	unsigned short MajorVersion;
	bool MajorVersion_isNULL;
	
	unsigned short MinorVersion;
	bool MinorVersion_isNULL;
	
	unsigned short RevisionNumber;
	bool RevisionNumber_isNULL;
	
	unsigned short BuildNumber;
	bool BuildNumber_isNULL;
	
	string VersionString;
	bool VersionString_isNULL;
	
	vector<string> TargetOperatingSystems;
	bool TargetOperatingSystems_isNULL;
	
	string Manufacturer;
	bool Manufacturer_isNULL;
	
	vector<string> Languages;
	bool Languages_isNULL;
	
	vector<unsigned short> Classifications;
	bool Classifications_isNULL;
	
	vector<string> ClassificationDescriptions;
	bool ClassificationDescriptions_isNULL;
	
	string SerialNumber;
	bool SerialNumber_isNULL;
	
	vector<string> TargetTypes;
	bool TargetTypes_isNULL;
	
	vector<string> IdentityInfoValue;
	bool IdentityInfoValue_isNULL;
	
	vector<string> IdentityInfoType;
	bool IdentityInfoType_isNULL;
	
	string ReleaseDate;
	bool ReleaseDate_isNULL;
	
	bool IsEntity;
	bool IsEntity_isNULL;
	
	unsigned short ExtendedResourceType;
	bool ExtendedResourceType_isNULL;
	
	string OtherExtendedResourceTypeDescription;
	bool OtherExtendedResourceTypeDescription_isNULL;
	
	unsigned short MinExtendedResourceTypeMajorVersion;
	bool MinExtendedResourceTypeMajorVersion_isNULL;
	
	unsigned short MinExtendedResourceTypeMinorVersion;
	bool MinExtendedResourceTypeMinorVersion_isNULL;
	
	unsigned short MinExtendedResourceTypeRevisionNumber;
	bool MinExtendedResourceTypeRevisionNumber_isNULL;
	
	unsigned short MinExtendedResourceTypeBuildNumber;
	bool MinExtendedResourceTypeBuildNumber_isNULL;
	
	vector<unsigned short> TargetOSTypes;
	bool TargetOSTypes_isNULL;
	
	OpenDRIM_SoftwareIdentity() {
		Caption_isNULL = true;
		Description_isNULL = true;
		ElementName_isNULL = true;
		InstallDate_isNULL = true;
		Name_isNULL = true;
		OperationalStatus_isNULL = true;
		StatusDescriptions_isNULL = true;
		Status_isNULL = true;
		HealthState_isNULL = true;
		PrimaryStatus_isNULL = true;
		DetailedStatus_isNULL = true;
		OperatingStatus_isNULL = true;
		CommunicationStatus_isNULL = true;
		InstanceID_isNULL = true;
		MajorVersion_isNULL = true;
		MinorVersion_isNULL = true;
		RevisionNumber_isNULL = true;
		BuildNumber_isNULL = true;
		VersionString_isNULL = true;
		TargetOperatingSystems_isNULL = true;
		Manufacturer_isNULL = true;
		Languages_isNULL = true;
		Classifications_isNULL = true;
		ClassificationDescriptions_isNULL = true;
		SerialNumber_isNULL = true;
		TargetTypes_isNULL = true;
		IdentityInfoValue_isNULL = true;
		IdentityInfoType_isNULL = true;
		ReleaseDate_isNULL = true;
		IsEntity_isNULL = true;
		ExtendedResourceType_isNULL = true;
		OtherExtendedResourceTypeDescription_isNULL = true;
		MinExtendedResourceTypeMajorVersion_isNULL = true;
		MinExtendedResourceTypeMinorVersion_isNULL = true;
		MinExtendedResourceTypeRevisionNumber_isNULL = true;
		MinExtendedResourceTypeBuildNumber_isNULL = true;
		TargetOSTypes_isNULL = true;
	}
	
	~OpenDRIM_SoftwareIdentity() {}
	
	string getKeys() const {
		return CF_toLowCase(".InstanceID=\"" + CF_quoteString(InstanceID) + "\"");
	}

	int getCaption(string& value) const {
		if (Caption_isNULL==true)
			return NOT_FOUND;
		value = Caption;
		return OK;
	}
	
	int setCaption(const string& newValue) {
		Caption = newValue;
		Caption_isNULL = false;
		return OK;
	}

	int getDescription(string& value) const {
		if (Description_isNULL==true)
			return NOT_FOUND;
		value = Description;
		return OK;
	}
	
	int setDescription(const string& newValue) {
		Description = newValue;
		Description_isNULL = false;
		return OK;
	}

	int getElementName(string& value) const {
		if (ElementName_isNULL==true)
			return NOT_FOUND;
		value = ElementName;
		return OK;
	}
	
	int setElementName(const string& newValue) {
		ElementName = newValue;
		ElementName_isNULL = false;
		return OK;
	}

	int getInstallDate(string& value) const {
		if (InstallDate_isNULL==true)
			return NOT_FOUND;
		value = InstallDate;
		return OK;
	}
	
	int setInstallDate(const string& newValue) {
		InstallDate = newValue;
		InstallDate_isNULL = false;
		return OK;
	}

	int getName(string& value) const {
		if (Name_isNULL==true)
			return NOT_FOUND;
		value = Name;
		return OK;
	}
	
	int setName(const string& newValue) {
		Name = newValue;
		Name_isNULL = false;
		return OK;
	}

	int getOperationalStatus(vector<unsigned short>& value) const {
		if (OperationalStatus_isNULL==true)
			return NOT_FOUND;
		value = OperationalStatus;
		return OK;
	}
	
	int setOperationalStatus(const vector<unsigned short>& newValue) {
		OperationalStatus = newValue;
		OperationalStatus_isNULL = false;
		return OK;
	}

	int getStatusDescriptions(vector<string>& value) const {
		if (StatusDescriptions_isNULL==true)
			return NOT_FOUND;
		value = StatusDescriptions;
		return OK;
	}
	
	int setStatusDescriptions(const vector<string>& newValue) {
		StatusDescriptions = newValue;
		StatusDescriptions_isNULL = false;
		return OK;
	}

	int getStatus(string& value) const {
		if (Status_isNULL==true)
			return NOT_FOUND;
		value = Status;
		return OK;
	}
	
	int setStatus(const string& newValue) {
		Status = newValue;
		Status_isNULL = false;
		return OK;
	}

	int getHealthState(unsigned short& value) const {
		if (HealthState_isNULL==true)
			return NOT_FOUND;
		value = HealthState;
		return OK;
	}
	
	int setHealthState(const unsigned short& newValue) {
		HealthState = newValue;
		HealthState_isNULL = false;
		return OK;
	}

	int getPrimaryStatus(unsigned short& value) const {
		if (PrimaryStatus_isNULL==true)
			return NOT_FOUND;
		value = PrimaryStatus;
		return OK;
	}
	
	int setPrimaryStatus(const unsigned short& newValue) {
		PrimaryStatus = newValue;
		PrimaryStatus_isNULL = false;
		return OK;
	}

	int getDetailedStatus(unsigned short& value) const {
		if (DetailedStatus_isNULL==true)
			return NOT_FOUND;
		value = DetailedStatus;
		return OK;
	}
	
	int setDetailedStatus(const unsigned short& newValue) {
		DetailedStatus = newValue;
		DetailedStatus_isNULL = false;
		return OK;
	}

	int getOperatingStatus(unsigned short& value) const {
		if (OperatingStatus_isNULL==true)
			return NOT_FOUND;
		value = OperatingStatus;
		return OK;
	}
	
	int setOperatingStatus(const unsigned short& newValue) {
		OperatingStatus = newValue;
		OperatingStatus_isNULL = false;
		return OK;
	}

	int getCommunicationStatus(unsigned short& value) const {
		if (CommunicationStatus_isNULL==true)
			return NOT_FOUND;
		value = CommunicationStatus;
		return OK;
	}
	
	int setCommunicationStatus(const unsigned short& newValue) {
		CommunicationStatus = newValue;
		CommunicationStatus_isNULL = false;
		return OK;
	}

	int getInstanceID(string& value) const {
		if (InstanceID_isNULL==true)
			return NOT_FOUND;
		value = InstanceID;
		return OK;
	}
	
	int setInstanceID(const string& newValue) {
		InstanceID = newValue;
		InstanceID_isNULL = false;
		return OK;
	}

	int getMajorVersion(unsigned short& value) const {
		if (MajorVersion_isNULL==true)
			return NOT_FOUND;
		value = MajorVersion;
		return OK;
	}
	
	int setMajorVersion(const unsigned short& newValue) {
		MajorVersion = newValue;
		MajorVersion_isNULL = false;
		return OK;
	}

	int getMinorVersion(unsigned short& value) const {
		if (MinorVersion_isNULL==true)
			return NOT_FOUND;
		value = MinorVersion;
		return OK;
	}
	
	int setMinorVersion(const unsigned short& newValue) {
		MinorVersion = newValue;
		MinorVersion_isNULL = false;
		return OK;
	}

	int getRevisionNumber(unsigned short& value) const {
		if (RevisionNumber_isNULL==true)
			return NOT_FOUND;
		value = RevisionNumber;
		return OK;
	}
	
	int setRevisionNumber(const unsigned short& newValue) {
		RevisionNumber = newValue;
		RevisionNumber_isNULL = false;
		return OK;
	}

	int getBuildNumber(unsigned short& value) const {
		if (BuildNumber_isNULL==true)
			return NOT_FOUND;
		value = BuildNumber;
		return OK;
	}
	
	int setBuildNumber(const unsigned short& newValue) {
		BuildNumber = newValue;
		BuildNumber_isNULL = false;
		return OK;
	}

	int getVersionString(string& value) const {
		if (VersionString_isNULL==true)
			return NOT_FOUND;
		value = VersionString;
		return OK;
	}
	
	int setVersionString(const string& newValue) {
		VersionString = newValue;
		VersionString_isNULL = false;
		return OK;
	}

	int getTargetOperatingSystems(vector<string>& value) const {
		if (TargetOperatingSystems_isNULL==true)
			return NOT_FOUND;
		value = TargetOperatingSystems;
		return OK;
	}
	
	int setTargetOperatingSystems(const vector<string>& newValue) {
		TargetOperatingSystems = newValue;
		TargetOperatingSystems_isNULL = false;
		return OK;
	}

	int getManufacturer(string& value) const {
		if (Manufacturer_isNULL==true)
			return NOT_FOUND;
		value = Manufacturer;
		return OK;
	}
	
	int setManufacturer(const string& newValue) {
		Manufacturer = newValue;
		Manufacturer_isNULL = false;
		return OK;
	}

	int getLanguages(vector<string>& value) const {
		if (Languages_isNULL==true)
			return NOT_FOUND;
		value = Languages;
		return OK;
	}
	
	int setLanguages(const vector<string>& newValue) {
		Languages = newValue;
		Languages_isNULL = false;
		return OK;
	}

	int getClassifications(vector<unsigned short>& value) const {
		if (Classifications_isNULL==true)
			return NOT_FOUND;
		value = Classifications;
		return OK;
	}
	
	int setClassifications(const vector<unsigned short>& newValue) {
		Classifications = newValue;
		Classifications_isNULL = false;
		return OK;
	}

	int getClassificationDescriptions(vector<string>& value) const {
		if (ClassificationDescriptions_isNULL==true)
			return NOT_FOUND;
		value = ClassificationDescriptions;
		return OK;
	}
	
	int setClassificationDescriptions(const vector<string>& newValue) {
		ClassificationDescriptions = newValue;
		ClassificationDescriptions_isNULL = false;
		return OK;
	}

	int getSerialNumber(string& value) const {
		if (SerialNumber_isNULL==true)
			return NOT_FOUND;
		value = SerialNumber;
		return OK;
	}
	
	int setSerialNumber(const string& newValue) {
		SerialNumber = newValue;
		SerialNumber_isNULL = false;
		return OK;
	}

	int getTargetTypes(vector<string>& value) const {
		if (TargetTypes_isNULL==true)
			return NOT_FOUND;
		value = TargetTypes;
		return OK;
	}
	
	int setTargetTypes(const vector<string>& newValue) {
		TargetTypes = newValue;
		TargetTypes_isNULL = false;
		return OK;
	}

	int getIdentityInfoValue(vector<string>& value) const {
		if (IdentityInfoValue_isNULL==true)
			return NOT_FOUND;
		value = IdentityInfoValue;
		return OK;
	}
	
	int setIdentityInfoValue(const vector<string>& newValue) {
		IdentityInfoValue = newValue;
		IdentityInfoValue_isNULL = false;
		return OK;
	}

	int getIdentityInfoType(vector<string>& value) const {
		if (IdentityInfoType_isNULL==true)
			return NOT_FOUND;
		value = IdentityInfoType;
		return OK;
	}
	
	int setIdentityInfoType(const vector<string>& newValue) {
		IdentityInfoType = newValue;
		IdentityInfoType_isNULL = false;
		return OK;
	}

	int getReleaseDate(string& value) const {
		if (ReleaseDate_isNULL==true)
			return NOT_FOUND;
		value = ReleaseDate;
		return OK;
	}
	
	int setReleaseDate(const string& newValue) {
		ReleaseDate = newValue;
		ReleaseDate_isNULL = false;
		return OK;
	}

	int getIsEntity(bool& value) const {
		if (IsEntity_isNULL==true)
			return NOT_FOUND;
		value = IsEntity;
		return OK;
	}
	
	int setIsEntity(const bool& newValue) {
		IsEntity = newValue;
		IsEntity_isNULL = false;
		return OK;
	}

	int getExtendedResourceType(unsigned short& value) const {
		if (ExtendedResourceType_isNULL==true)
			return NOT_FOUND;
		value = ExtendedResourceType;
		return OK;
	}
	
	int setExtendedResourceType(const unsigned short& newValue) {
		ExtendedResourceType = newValue;
		ExtendedResourceType_isNULL = false;
		return OK;
	}

	int getOtherExtendedResourceTypeDescription(string& value) const {
		if (OtherExtendedResourceTypeDescription_isNULL==true)
			return NOT_FOUND;
		value = OtherExtendedResourceTypeDescription;
		return OK;
	}
	
	int setOtherExtendedResourceTypeDescription(const string& newValue) {
		OtherExtendedResourceTypeDescription = newValue;
		OtherExtendedResourceTypeDescription_isNULL = false;
		return OK;
	}

	int getMinExtendedResourceTypeMajorVersion(unsigned short& value) const {
		if (MinExtendedResourceTypeMajorVersion_isNULL==true)
			return NOT_FOUND;
		value = MinExtendedResourceTypeMajorVersion;
		return OK;
	}
	
	int setMinExtendedResourceTypeMajorVersion(const unsigned short& newValue) {
		MinExtendedResourceTypeMajorVersion = newValue;
		MinExtendedResourceTypeMajorVersion_isNULL = false;
		return OK;
	}

	int getMinExtendedResourceTypeMinorVersion(unsigned short& value) const {
		if (MinExtendedResourceTypeMinorVersion_isNULL==true)
			return NOT_FOUND;
		value = MinExtendedResourceTypeMinorVersion;
		return OK;
	}
	
	int setMinExtendedResourceTypeMinorVersion(const unsigned short& newValue) {
		MinExtendedResourceTypeMinorVersion = newValue;
		MinExtendedResourceTypeMinorVersion_isNULL = false;
		return OK;
	}

	int getMinExtendedResourceTypeRevisionNumber(unsigned short& value) const {
		if (MinExtendedResourceTypeRevisionNumber_isNULL==true)
			return NOT_FOUND;
		value = MinExtendedResourceTypeRevisionNumber;
		return OK;
	}
	
	int setMinExtendedResourceTypeRevisionNumber(const unsigned short& newValue) {
		MinExtendedResourceTypeRevisionNumber = newValue;
		MinExtendedResourceTypeRevisionNumber_isNULL = false;
		return OK;
	}

	int getMinExtendedResourceTypeBuildNumber(unsigned short& value) const {
		if (MinExtendedResourceTypeBuildNumber_isNULL==true)
			return NOT_FOUND;
		value = MinExtendedResourceTypeBuildNumber;
		return OK;
	}
	
	int setMinExtendedResourceTypeBuildNumber(const unsigned short& newValue) {
		MinExtendedResourceTypeBuildNumber = newValue;
		MinExtendedResourceTypeBuildNumber_isNULL = false;
		return OK;
	}

	int getTargetOSTypes(vector<unsigned short>& value) const {
		if (TargetOSTypes_isNULL==true)
			return NOT_FOUND;
		value = TargetOSTypes;
		return OK;
	}
	
	int setTargetOSTypes(const vector<unsigned short>& newValue) {
		TargetOSTypes = newValue;
		TargetOSTypes_isNULL = false;
		return OK;
	}

};

#endif /*OPENDRIM_SOFTWAREIDENTITY_H_*/
