#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2021 Mopi
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Chook & Sosig: Walk the Plank
# send your bug reports to contact@dotslashplay.it
###

script_version=20221206.4

GAME_ID='chook-and-sosig'
GAME_NAME='Chook & Sosig: Walk the Plank'

UNITY3D_NAME='walktheplank'

ARCHIVE_BASE_0='setup_chook__sosig_walk_the_plank_v2.03b_(30724).exe'
ARCHIVE_BASE_0_MD5='e66cdecc51060a98325297d7f9039307'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_SIZE='5200000'
ARCHIVE_BASE_0_VERSION='2.03b-gog30724'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/chook_sosig_walk_the_plank'

CONTENT_PATH_DEFAULT='.'
CONTENT_GAME_BIN_FILES="
mono
unitycrashhandler32.exe
${UNITY3D_NAME}_data/plugins
${UNITY3D_NAME}.exe
*.dll"
CONTENT_GAME_DATA_FILES="
${UNITY3D_NAME}_data"

APP_MAIN_TYPE='wine'
APP_MAIN_EXE="${UNITY3D_NAME}.exe"
APP_MAIN_ICON="${UNITY3D_NAME}.exe"

APP_WINE_LINK_DIRS='
userdata:users/${USER}/AppData/LocalLow/TookiPalooki/WalkthePlank'
USER_PERSISTENT_FILES='
userdata/*.save'

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID"
PKG_BIN_DEPS_ARCH='gst-plugins-base gst-plugins-good gst-libav'
PKG_BIN_DEPS_DEB='gstreamer1.0-plugins-base, gstreamer1.0-plugins-good, gstreamer1.0-libav'
PKG_BIN_DEPS_GENTOO='media-libs/gst-plugins-base media-libs/gst-plugins-good media-plugins/gst-plugins-libav'

# Load common functions

target_version='2.18'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'

# Get icon

PKG='PKG_DATA'
icons_inclusion

# Include game data

content_inclusion_default

# Delete temporary files

rm --recursive "$PLAYIT_WORKDIR/gamedata"

# Write launchers

PKG='PKG_BIN'
launchers_write

# Build package

write_metadata
build_pkg

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
