/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.load;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Locale;
import org.apache.derby.impl.load.ControlInfo;
import org.apache.derby.impl.load.ExportWriteDataAbstract;

final class ExportWriteData
extends ExportWriteDataAbstract
implements PrivilegedExceptionAction {
    private String outputFileName;
    private String lobsFileName;
    private boolean lobsInExtFile = false;
    private long lobFileOffset = 0L;
    private OutputStreamWriter aStream;
    private OutputStreamWriter lobCharStream;
    private BufferedOutputStream lobOutBinaryStream;
    private ByteArrayOutputStream lobByteArrayStream;
    private byte[] byteBuf;
    private char[] charBuf;

    ExportWriteData(String string, ControlInfo controlInfo) throws Exception {
        this.outputFileName = string;
        this.controlFileReader = controlInfo;
        this.init();
    }

    ExportWriteData(String string, String string2, ControlInfo controlInfo) throws Exception {
        this.outputFileName = string;
        this.lobsFileName = string2;
        this.controlFileReader = controlInfo;
        this.lobsInExtFile = true;
        this.byteBuf = new byte[8192];
        this.charBuf = new char[8192];
        this.init();
    }

    private void init() throws Exception {
        this.loadPropertiesInfo();
        try {
            AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw privilegedActionException.getException();
        }
    }

    public final Object run() throws Exception {
        this.openFiles();
        return null;
    }

    private void openFiles() throws Exception {
        Object object;
        try {
            object = new URL(this.outputFileName);
            this.outputFileName = ((URL)object).getFile();
            if (this.lobsInExtFile) {
                object = new URL(this.lobsFileName);
                this.lobsFileName = ((URL)object).getFile();
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        object = null;
        FilterOutputStream filterOutputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            object = new FileOutputStream(this.outputFileName);
            filterOutputStream = new BufferedOutputStream((OutputStream)object);
            OutputStreamWriter outputStreamWriter = this.aStream = this.dataCodeset == null ? new OutputStreamWriter(filterOutputStream) : new OutputStreamWriter((OutputStream)filterOutputStream, this.dataCodeset);
            if (this.lobsInExtFile) {
                File file = new File(this.lobsFileName);
                if (file.getParentFile() == null) {
                    file = new File(new File(this.outputFileName).getParentFile(), this.lobsFileName);
                }
                fileOutputStream = new FileOutputStream(file);
                this.lobOutBinaryStream = new BufferedOutputStream(fileOutputStream);
                this.lobByteArrayStream = new ByteArrayOutputStream();
                this.lobCharStream = this.dataCodeset == null ? new OutputStreamWriter(this.lobByteArrayStream) : new OutputStreamWriter((OutputStream)this.lobByteArrayStream, this.dataCodeset);
            }
        }
        catch (Exception exception) {
            if (this.aStream == null) {
                if (filterOutputStream != null) {
                    filterOutputStream.close();
                } else if (object != null) {
                    ((FileOutputStream)object).close();
                }
            } else {
                this.aStream.close();
                if (this.lobOutBinaryStream != null) {
                    this.lobOutBinaryStream.close();
                } else if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            throw exception;
        }
    }

    void writeColumnDefinitionOptionally(String[] stringArray, String[] stringArray2) throws Exception {
        boolean bl = true;
        if (this.columnDefinition.toUpperCase(Locale.ENGLISH).equals("True".toUpperCase(Locale.ENGLISH))) {
            String string = new String();
            for (int i = 0; i < stringArray.length; ++i) {
                string = i > 0 ? this.fieldSeparator : "";
                string = string + this.fieldStartDelimiter + stringArray[i] + this.fieldStopDelimiter;
                if (!bl) {
                    string = string + this.fieldSeparator + this.fieldStartDelimiter + stringArray2[i] + this.fieldStopDelimiter;
                }
                this.aStream.write(string, 0, string.length());
            }
            this.aStream.write(this.recordSeparator, 0, this.recordSeparator.length());
        }
    }

    private void writeNextColumn(String string, boolean bl) throws Exception {
        if (string != null) {
            if (!bl) {
                this.aStream.write(this.fieldStartDelimiter, 0, this.fieldStartDelimiter.length());
            }
            if (this.doubleDelimiter) {
                string = this.makeDoubleDelimiterString(string, this.fieldStartDelimiter);
            }
            this.aStream.write(string, 0, string.length());
            if (!bl) {
                this.aStream.write(this.fieldStopDelimiter, 0, this.fieldStopDelimiter.length());
            }
        }
    }

    String writeBinaryColumnToExternalFile(InputStream inputStream) throws Exception {
        long l = 0L;
        int n = 0;
        if (inputStream != null) {
            n = inputStream.read(this.byteBuf);
            while (n != -1) {
                this.lobOutBinaryStream.write(this.byteBuf, 0, n);
                l += (long)n;
                n = inputStream.read(this.byteBuf);
            }
            inputStream.close();
            this.lobOutBinaryStream.flush();
        } else {
            l = -1L;
        }
        String string = this.lobsFileName + "." + this.lobFileOffset + "." + l + "/";
        if (l != -1L) {
            this.lobFileOffset += l;
        }
        return string;
    }

    String writeCharColumnToExternalFile(Reader reader) throws Exception {
        long l = 0L;
        int n = 0;
        if (reader != null) {
            n = reader.read(this.charBuf);
            while (n != -1) {
                this.lobByteArrayStream.reset();
                this.lobCharStream.write(this.charBuf, 0, n);
                this.lobCharStream.flush();
                l += (long)this.lobByteArrayStream.size();
                this.lobByteArrayStream.writeTo(this.lobOutBinaryStream);
                n = reader.read(this.charBuf);
            }
            reader.close();
            this.lobOutBinaryStream.flush();
        } else {
            l = -1L;
        }
        String string = this.lobsFileName + "." + this.lobFileOffset + "." + l + "/";
        if (l != -1L) {
            this.lobFileOffset += l;
        }
        return string;
    }

    public void writeData(String[] stringArray, boolean[] blArray) throws Exception {
        if (this.format.equals("ASCII_DELIMITED")) {
            this.writeNextColumn(stringArray[0], blArray[0]);
            for (int i = 1; i < stringArray.length; ++i) {
                this.aStream.write(this.fieldSeparator, 0, this.fieldSeparator.length());
                this.writeNextColumn(stringArray[i], blArray[i]);
            }
            if (this.hasDelimiterAtEnd) {
                this.aStream.write(this.fieldSeparator, 0, this.fieldSeparator.length());
            }
        }
        this.aStream.write(this.recordSeparator, 0, this.recordSeparator.length());
    }

    public void noMoreRows() throws IOException {
        this.aStream.flush();
        this.aStream.close();
        if (this.lobsInExtFile) {
            if (this.lobOutBinaryStream != null) {
                this.lobOutBinaryStream.flush();
                this.lobOutBinaryStream.close();
            }
            if (this.lobCharStream != null) {
                this.lobCharStream.close();
            }
            if (this.lobByteArrayStream != null) {
                this.lobByteArrayStream.close();
            }
        }
    }

    private String makeDoubleDelimiterString(String string, String string2) {
        int n = string.indexOf(string2);
        if (n != -1) {
            StringBuffer stringBuffer = new StringBuffer(string);
            int n2 = string2.length();
            while (n != -1) {
                stringBuffer = stringBuffer.insert(n, string2);
                int n3 = n + n2 + 1;
                n = stringBuffer.toString().indexOf(string2, n3);
            }
            return stringBuffer.toString();
        }
        return string;
    }
}

