!{\src2tex{textfont=tt}}
!!****f* ABINIT/chkneu
!! NAME
!! chkneu
!!
!! FUNCTION
!! Check neutrality of system based on band occupancies and
!! valence charges of pseudo-atoms.
!! Eventually initialize occ if occopt==1 or 3...7
!! Also return nelect, the number of valence electron per unit cell
!!
!! COPYRIGHT
!! Copyright (C) 1998-2007 ABINIT group (DCA, XG, GMR)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  charge=number of electrons missing (+) or added (-) to system (usually 0)
!!  iout=unit number for output file
!!  iscf= if>0, SCF calculation ; if<=0, non SCF calculation (wtk might
!!   not be defined)
!!  mband=maximum number of bands
!!  natom=number of atoms in unit cell
!!  nband(nkpt)=number of bands at each k point
!!  nkpt=number of k points
!!  nspinor=number of spinorial components of the wavefunctions
!!  nsppol=1 for unpolarized, 2 for spin-polarized
!!  ntypat=number of pseudopotentials
!!  occopt=option for occupancies
!!  positron=0 if electron GS calculation
!!          1 if positron GS calculation
!!          2 if electron GS calcultaion in presence of the positron
!!  typat(natom)=atom type (integer) for each atom
!!  wtk(nkpt)=k point weights (defined if iscf>0 or iscf==-3)
!!  ziontypat(ntypat)=ionic charge of each pseudoatom
!!
!! OUTPUT
!!  Writes warning and/or aborts if error condition exists
!!  nelect=number of valence electrons per unit cell
!!   (from counting valence electrons in psps, and taking into
!!    account the input variable "charge")
!!
!! SIDE EFFECTS
!! Input/Output :
!!  occ(maxval(nband(:))*nkpt*nsppol)=occupation numbers for each band and k point
!!    must be input for occopt==0 or 2,
!!    will be an output for occopt==1 or 3 ... 7
!!
!! NOTES
!!
!! PARENTS
!!      invars2
!!
!! CHILDREN
!!      leave_new,wrtout
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine chkneu(charge,iout,iscf,mband,natom,nband,nelect,nkpt,&
& nspinor,nsppol,ntypat,occ,occopt,positron,typat,wtk,ziontypat)

 use defs_basis

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_01manage_mpi
#endif
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: iout,iscf,mband,natom,nkpt,nspinor,nsppol,ntypat,occopt
 integer,intent(in) :: positron
 real(dp),intent(in) :: charge
 real(dp),intent(out) :: nelect
!arrays
 integer,intent(in) :: nband(nkpt*nsppol),typat(natom)
 real(dp),intent(in) :: wtk(nkpt),ziontypat(ntypat)
 real(dp),intent(inout) :: occ(mband*nkpt*nsppol)

!Local variables-------------------------------
!scalars
 integer :: bantot,iatom,iband,ii,ikpt,isppol,nocc
 real(dp) :: maxocc,nelect_occ,occlast,zval
 character(len=500) :: message
!arrays
 real(dp),allocatable :: tmpocc(:)

! *************************************************************************

!(1) count nominal valence electrons according to ziontypat
 zval=0.0_dp
 do iatom=1,natom
  zval=zval+ziontypat(typat(iatom))
 end do
 nelect=zval-charge

 if (positron == 1) nelect=1



!(2) Optionally initialize occ with semiconductor occupancies
!      (even for a metal : at this stage, the eigenenergies are unknown)
 if(occopt==1 .or. (occopt>=3 .and. occopt<=7) )then
! Here, initialize a real(dp) variable giving the
! maximum occupation number per band
  maxocc=2.0_dp/real(nsppol*nspinor,dp)

! Determine the number of bands fully or partially occupied
  nocc=(nelect-1.0d-8)/maxocc + 1
! Occupation number of the highest level
  occlast=nelect-maxocc*(nocc-1)

! The number of allowed bands must be sufficiently large
  if( nocc<=nband(1)*nsppol .or. iscf==-2) then

   if(iscf==-2 .and. nocc>nband(1)*nsppol)nocc=nband(1)*nsppol
!DEBUG
!  write(6,*)' chkneu : nband(1),nsppol,nocc'
!  write(6,*)nband(1),nsppol,nocc
!  stop
!ENDDEBUG

!  Use a temporary array for defining occupation numbers
   allocate(tmpocc(nband(1)*nsppol))
!  First do it for fully occupied bands
   if (1<nocc) tmpocc(1:nocc-1)=maxocc
!  Then, do it for highest occupied band
   if (1<=nocc) tmpocc(nocc)=occlast
!  Finally do it for eventual unoccupied bands
   if ( nocc<nband(1)*nsppol ) tmpocc(nocc+1:nband(1)*nsppol)=0.0_dp

!DEBUG
!  write(6,*)'nocc,occlast,maxocc,nband(1)',nocc,occlast,maxocc,nband(1)
!  write(6,*)'tmpocc=',tmpocc(:)
!ENDDEBUG

!  Now copy the tmpocc array in the occ array, taking into account the spin
   if(nsppol==1)then

    do ikpt=1,nkpt
     occ(1+(ikpt-1)*nband(1):ikpt*nband(1))=tmpocc(:)
    end do
    write(message, '(a,i4,a,a)' ) &
&    ' chkneu : initialized the occupation numbers for occopt= ',occopt,&
&    ch10,'    spin-unpolarized case : '
!   call wrtout(iout,message,'COLL')
    call wrtout(6,message,'COLL')
    do ii=0,(nband(1)-1)/12
     write(message,'(12f6.2)') occ( 1+ii*12 : min(12+ii*12,nband(1)) )
!    call wrtout(iout,message,'COLL')
     call wrtout(6,message,'COLL')
    end do

   else

    do ikpt=1,nkpt
     do iband=1,nband(1)
      do isppol=1,nsppol
       occ(iband+nband(1)*(ikpt-1+nkpt*(isppol-1))) =  &
&           tmpocc(isppol+nsppol*(iband-1))
      end do
     end do
    end do
    write(message, '(a,i4,a,a)' ) &
&    ' chkneu : initialized the occupation numbers for occopt= ',occopt,&
&    ch10,'    spin up   values : '
!   call wrtout(iout,message,'COLL')
    call wrtout(6,message,'COLL')
    do ii=0,(nband(1)-1)/12
     write(message,'(12f6.2)') occ( 1+ii*12 : min(12+ii*12,nband(1)) )
!    call wrtout(iout,message,'COLL')
     call wrtout(6,message,'COLL')
    end do
    write(message, '(a)' ) '    spin down values : '
!   call wrtout(iout,message,'COLL')
    call wrtout(6,message,'COLL')
    do ii=0,(nband(1)-1)/12
     write(message,'(12f6.2)') &
&      occ( 1+ii*12+nkpt*nband(1) : min(12+ii*12,nband(1))+nkpt*nband(1) )
!    call wrtout(iout,message,'COLL')
     call wrtout(6,message,'COLL')
    end do

   end if

   deallocate(tmpocc)

! Here, treat the case when the number of allowed bands is not large enough
  else
   write(message, '(a,a,a,a,i4,a,a,a,a,a,a,a,a)' ) ch10,  &
&   ' chkneu : ERROR -',ch10,&
&   '  Initialization of occ, with occopt=',occopt,ch10,&
&   '  There are not enough bands to get charge balance right',&
&   ch10,' Action : modify input file ... ',ch10,&
&   '  (check the pseudopotential charges, the variable charge,',ch10,&
&   '  and the declared number of bands, nband)'
   call wrtout(06,message,'COLL')
   call leave_new('COLL')
  end if
 end if

!The remaining of the routine is for SCF runs and special options
 if(iscf>0 .or. iscf==-1 .or. iscf==-3)then

! (3) count electrons in bands (note : in case occ has just been
!       initialized, point (3) and (4) is a trivial test
  nelect_occ=0.0_dp
  bantot=0
  do isppol=1,nsppol
  do ikpt=1,nkpt
  do iband=1,nband(ikpt+(isppol-1)*nkpt)
   bantot=bantot+1
   nelect_occ=nelect_occ+wtk(ikpt)*occ(bantot)
  end do
  end do
  end do

! (4) if iscf/=-3, nelect must equal nelect_occ
! if discrepancy exceeds tol11, give warning;  tol8, stop with error

  if (abs(nelect_occ-nelect)>tol11 .and. iscf/=-3) then

!  There is a discrepancy
   write(message, &
&   '(a,a,e16.8,a,e16.8,a,a,a,e22.14,a,a,a,a,a,a,a)' ) ch10,&
&   ' chkneu: nelect_occ=',nelect_occ,', zval=',zval,',',ch10,&
&   '         and input value of charge=',charge,',',ch10,&
&   '   nelec_occ is computed from occ and wtk',ch10,&
&   '   zval is nominal charge of all nuclei, computed from zion (read in psp),',ch10,&
&   '   charge is an input variable (usually 0).'
   call wrtout(06,message,'COLL')

   if (abs(nelect_occ-nelect)>tol8) then
!   The discrepancy is severe
    write(message, '(a,a,e8.2,a,a)' ) ch10,&
&    ' ERROR - These must obey zval-nelect_occ=charge to better than ',tol8,&
&    ch10,' This is not the case. '
   else
!   The discrepancy is not so severe
    write(message, '(a,a,e8.2)' ) ch10,&
&    ' WARNING - These should obey zval-nelect_occ=charge to better than ',tol11
   end if
   call wrtout(06,message,'COLL')

   write(message, '(a,a,a,a,a,a)' ) &
&   '   Action : check input file for occ,wtk, and charge.',ch10,&
&   '   Note that wtk is NOT automatically normalized when occopt=2,',&
&   ch10,'   but IS automatically normalized otherwise.',ch10
   call wrtout(06,message,'COLL')

!  If the discrepancy is severe, stop
   if (abs(nelect_occ-nelect)>tol8)then
    call leave_new('COLL')
   end if

  end if

!End the condition iscf>0 or -1 or -3 .
 end if

end subroutine chkneu
!!***
