# Section A - What is Anarchism?

Modern civilisation faces three potentially catastrophic crises: (1) social
breakdown, a shorthand term for rising rates of poverty, homelessness, crime,
violence, alienation, drug and alcohol abuse, social isolation, political
apathy, dehumanisation, the deterioration of community structures of self-help
and mutual aid, etc.; (2) destruction of the planet's delicate ecosystems on
which all complex forms of life depend; and (3) the proliferation of weapons
of mass destruction, particularly nuclear weapons.

Orthodox opinion, including that of Establishment "experts," mainstream media,
and politicians, generally regards these crises as separable, each having its
own causes and therefore capable of being dealt with on a piecemeal basis, in
isolation from the other two. Obviously, however, this "orthodox" approach
isn't working, since the problems in question are getting worse. Unless some
better approach is taken soon, we are clearly headed for disaster, either from
catastrophic war, ecological Armageddon, or a descent into urban savagery --
or all of the above.

Anarchism offers a unified and coherent way of making sense of these crises,
by tracing them to a common source. This source is the principle of
**hierarchical authority** , which underlies the major institutions of all
"civilised" societies, whether capitalist or "communist." Anarchist analysis
therefore starts from the fact that all of our major institutions are in the
form of hierarchies, i.e. organisations that concentrate power at the top of a
pyramidal structure, such as corporations, government bureaucracies, armies,
political parties, religious organisations, universities, etc. It then goes on
to show how the authoritarian relations inherent in such hierarchies
negatively affect individuals, their society, and culture. In the first part
of this FAQ ( **sections A to E** ) we will present the anarchist analysis of
hierarchical authority and its negative effects in greater detail.

It should not be thought, however, that anarchism is just a critique of modern
civilisation, just "negative" or "destructive." Because it is much more than
that. For one thing, it is also a proposal for a free society. Emma Goldman
expressed what might be called the "anarchist question" as follows: _"The
problem that confronts us today. . . is how to be one's self and yet in
oneness with others, to feel deeply with all human beings and still retain
one's own characteristic qualities."_ [ **Red Emma Speaks** , pp. 158-159] In
other words, how can we create a society in which the potential for each
individual is realised but not at the expense of others? In order to achieve
this, anarchists envision a society in which, instead of being controlled
**_"from the top down"_** through hierarchical structures of centralised
power, the affairs of humanity will, to quote Benjamin Tucker, _"be managed by
individuals or voluntary associations."_ [ **Anarchist Reader** , p. 149]
While later sections of the FAQ ( **sections I and J** ) will describe
anarchism's positive proposals for organising society in this way, "from the
bottom up," some of the constructive core of anarchism will be seen even in
the earlier sections. The positive core of anarchism can even be seen in the
anarchist critique of such flawed solutions to the social question as Marxism
and right-wing "libertarianism" ( **sections F and H** , respectively).

As Clifford Harper elegantly puts it, _"[l]ike all great ideas, anarchism is
pretty simple when you get down to it -- human beings are at their best when
they are living free of authority, deciding things among themselves rather
than being ordered about."_ [ **Anarchy: A Graphic Guide** , p. vii] Due to
their desire to maximise individual and therefore social freedom, anarchists
wish to dismantle all institutions that repress people:

> _"Common to all Anarchists is the desire to free society of all political
> and social coercive institutions which stand in the way of the development
> of a free humanity."_ [Rudolf Rocker, **Anarcho-Syndicalism** , p. 9]

As we'll see, all such institutions are hierarchies, and their repressive
nature stems directly from their hierarchical form.

Anarchism is a socio-economic and political theory, but not an ideology. The
difference is **very** important. Basically, theory means you have ideas; an
ideology means ideas have you. Anarchism is a body of ideas, but they are
flexible, in a constant state of evolution and flux, and open to modification
in light of new data. As society changes and develops, so does anarchism. An
ideology, in contrast, is a set of "fixed" ideas which people believe
dogmatically, usually ignoring reality or "changing" it so as to fit with the
ideology, which is (by definition) correct. All such "fixed" ideas are the
source of tyranny and contradiction, leading to attempts to make everyone fit
onto a Procrustean Bed. This will be true regardless of the ideology in
question -- Leninism, Objectivism, "Libertarianism," or whatever -- all will
all have the same effect: the destruction of real individuals in the name of a
doctrine, a doctrine that usually serves the interest of some ruling elite.
Or, as Michael Bakunin puts it:

> _"Until now all human history has been only a perpetual and bloody
> immolation of millions of poor human beings in honour of some pitiless
> abstraction -- God, country, power of state, national honour, historical
> rights, judicial rights, political liberty, public welfare."_ [ **God and
> the State** , p. 59]

Dogmas are static and deathlike in their rigidity, often the work of some dead
"prophet," religious or secular, whose followers erect his or her ideas into
an idol, immutable as stone. Anarchists want the living to bury the dead so
that the living can get on with their lives. The living should rule the dead,
not vice versa. Ideologies are the nemesis of critical thinking and
consequently of freedom, providing a book of rules and "answers" which relieve
us of the "burden" of thinking for ourselves.

In producing this FAQ on anarchism it is not our intention to give you the
"correct" answers or a new rule book. We will explain a bit about what
anarchism has been in the past, but we will focus more on its modern forms and
why **we** are anarchists today. The FAQ is an attempt to provoke thought and
analysis on your part. If you are looking for a new ideology, then sorry,
anarchism is not for you.

While anarchists try to be realistic and practical, we are not "reasonable"
people. "Reasonable" people uncritically accept what the "experts" and
"authorities" tell them is true, and so they will always remain slaves!
Anarchists know that, as Bakunin wrote:

> _"[a] person is strong only when he stands upon his own truth, when he
> speaks and acts from his deepest convictions. Then, whatever the situation
> he may be in, he always knows what he must say and do. He may fall, but he
> cannot bring shame upon himself or his causes."_ [quoted in Albert Meltzer,
> **I couldn't Paint Golden Angels** , p. 2]

What Bakunin describes is the power of independent thought, which is the power
of freedom. We encourage you not to be "reasonable," not to accept what others
tell you, but to think and act for yourself!

One last point: to state the obvious, this is **not** the final word on
anarchism. Many anarchists will disagree with much that is written here, but
this is to be expected when people think for themselves. All we wish to do is
indicate the **basic** ideas of anarchism and give our analysis of certain
topics based on how we understand and apply these ideas. We are sure, however,
that all anarchists will agree with the core ideas we present, even if they
may disagree with our application of them here and there.

[‹ Section A - What is Anarchism?](secAcon.md "Go to previous page")
[up](secAcon.md "Go to parent page") [A.1 What is anarchism? ›](secA1.md
"Go to next page")

