/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.reporting;

import java.io.File;
import net.sourceforge.cobertura.dsl.Arguments;
import net.sourceforge.cobertura.dsl.ArgumentsBuilder;
import net.sourceforge.cobertura.dsl.Cobertura;
import net.sourceforge.cobertura.dsl.ReportFormat;
import net.sourceforge.cobertura.util.CommandLineBuilder;
import net.sourceforge.cobertura.util.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportMain {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportMain.class);

    private static void parseArgumentsAndReport(String[] args) throws Exception {
        ArgumentsBuilder builder = new ArgumentsBuilder();
        String baseDir = null;
        String format = null;
        boolean sourcesParam = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("--basedir")) {
                baseDir = args[++i];
                builder.setBaseDirectory(baseDir);
                continue;
            }
            if (args[i].equals("--datafile")) {
                String datafile = args[++i];
                ReportMain.validateDataFile(datafile);
                builder.setDataFile(datafile);
                continue;
            }
            if (args[i].equals("--destination")) {
                String destination = args[++i];
                builder.setDestinationDirectory(destination);
                ReportMain.validateAndCreateDestinationDirectory(destination);
                continue;
            }
            if (args[i].equals("--format")) {
                format = args[++i];
                ReportMain.validateFormat(format);
                continue;
            }
            if (args[i].equals("--encoding")) {
                builder.setEncoding(args[++i]);
                continue;
            }
            if (args[i].equals("--calculateMethodComplexity")) {
                builder.calculateMethodComplexity(true);
                continue;
            }
            builder.addSources(args[i], baseDir == null);
        }
        Arguments arguments = builder.build();
        if (arguments.getDestinationDirectory() == null) {
            System.err.println("Error: destination directory must be set");
            System.exit(1);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("format is %s encoding is %s", format, arguments.getEncoding()));
            LOGGER.debug("dataFile is " + arguments.getDataFile().getAbsolutePath());
            LOGGER.debug("destinationDir is " + arguments.getDestinationDirectory().getAbsolutePath());
        }
        new Cobertura(arguments).report().export(ReportFormat.getFromString(format));
    }

    private static void validateFormat(String format) {
        if (!(format.equalsIgnoreCase("html") || format.equalsIgnoreCase("xml") || format.equalsIgnoreCase("summaryXml"))) {
            System.err.println("Error: format \"" + format + "\" is invalid. Must be either html, xml or summaryXml");
            System.exit(1);
        }
    }

    private static void validateDataFile(String value) {
        File dataFile = new File(value);
        if (!dataFile.exists()) {
            System.err.println("Error: data file " + dataFile.getAbsolutePath() + " does not exist");
            System.exit(1);
        }
        if (!dataFile.isFile()) {
            System.err.println("Error: data file " + dataFile.getAbsolutePath() + " must be a regular file");
            System.exit(1);
        }
    }

    private static void validateAndCreateDestinationDirectory(String value) {
        File destinationDir = new File(value);
        if (destinationDir.exists() && !destinationDir.isDirectory()) {
            System.err.println("Error: destination directory " + destinationDir + " already exists but is not a directory");
            System.exit(1);
        }
        destinationDir.mkdirs();
    }

    public static int generateReport(String[] args) throws Exception {
        Header.print(System.out);
        long startTime = System.currentTimeMillis();
        try {
            args = CommandLineBuilder.preprocessCommandLineArguments(args);
        }
        catch (Exception ex) {
            System.err.println("Error: Cannot process arguments: " + ex.getMessage());
            return 1;
        }
        ReportMain.parseArgumentsAndReport(args);
        long stopTime = System.currentTimeMillis();
        System.out.println("Report time: " + (stopTime - startTime) + "ms");
        return 0;
    }

    public static void main(String[] args) throws Exception {
        int returnValue;
        try {
            returnValue = ReportMain.generateReport(args);
        }
        catch (Exception e) {
            returnValue = 1;
        }
        if (returnValue != 0) {
            System.exit(returnValue);
        }
    }
}

