/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 13:44:15 GMT 2018
 */

package uk.ac.sanger.artemis.cramtools.ref;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.reference.ReferenceSequenceFile;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.mock.java.io.MockFile;
import org.evosuite.runtime.testdata.EvoSuiteURL;
import org.evosuite.runtime.testdata.NetworkHandling;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.cramtools.ref.ReferenceSource;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class ReferenceSource_ESTest extends ReferenceSource_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      ReferenceSource referenceSource0 = new ReferenceSource((ReferenceSequenceFile) null);
      referenceSource0.setDownloadTriesBeforeFailing((-2071407238));
      SAMSequenceRecord sAMSequenceRecord0 = new SAMSequenceRecord("", 43);
      sAMSequenceRecord0.setMd5("");
      referenceSource0.getRegion(sAMSequenceRecord0, 1074, 4096);
      assertEquals((-2071407238), referenceSource0.getDownloadTriesBeforeFailing());
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      ReferenceSource referenceSource0 = new ReferenceSource((ReferenceSequenceFile) null);
      referenceSource0.setDownloadTriesBeforeFailing((-2071407238));
      SAMSequenceRecord sAMSequenceRecord0 = new SAMSequenceRecord("", 43);
      sAMSequenceRecord0.setMd5("");
      referenceSource0.getReferenceBases(sAMSequenceRecord0, true);
      assertEquals((-2071407238), referenceSource0.getDownloadTriesBeforeFailing());
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      ReferenceSource referenceSource0 = new ReferenceSource();
      referenceSource0.setDownloadTriesBeforeFailing((-734));
      int int0 = referenceSource0.getDownloadTriesBeforeFailing();
      assertEquals((-734), int0);
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      ReferenceSource referenceSource0 = new ReferenceSource();
      referenceSource0.findBasesByName("", true);
      assertEquals(2, referenceSource0.getDownloadTriesBeforeFailing());
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      ReferenceSource referenceSource0 = new ReferenceSource();
      SAMSequenceRecord sAMSequenceRecord0 = new SAMSequenceRecord("", 0);
      referenceSource0.findBases(sAMSequenceRecord0, false);
      assertEquals(2, referenceSource0.getDownloadTriesBeforeFailing());
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      ReferenceSource referenceSource0 = new ReferenceSource();
      // Undeclared exception!
      try { 
        referenceSource0.getVariants((String) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
      }
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      ReferenceSource referenceSource0 = new ReferenceSource();
      // Undeclared exception!
      try { 
        referenceSource0.getRegion((SAMSequenceRecord) null, (-1553), 679);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.cramtools.ref.ReferenceSource", e);
      }
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      ReferenceSource referenceSource0 = new ReferenceSource();
      // Undeclared exception!
      try { 
        referenceSource0.getReferenceBases((SAMSequenceRecord) null, true);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.cramtools.ref.ReferenceSource", e);
      }
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      ReferenceSource referenceSource0 = new ReferenceSource();
      // Undeclared exception!
      try { 
        referenceSource0.findBasesByMD5((String) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      ReferenceSource referenceSource0 = new ReferenceSource();
      // Undeclared exception!
      try { 
        referenceSource0.findBasesByMD5("VEx_a;$D=ZbhGj $5f");
        fail("Expecting exception: IllegalArgumentException");
      
      } catch(IllegalArgumentException e) {
         //
         // Illegal group reference
         //
         verifyException("java.util.regex.Matcher", e);
      }
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      SAMSequenceRecord sAMSequenceRecord0 = new SAMSequenceRecord("", 43);
      sAMSequenceRecord0.setMd5("");
      ReferenceSource referenceSource0 = new ReferenceSource();
      // Undeclared exception!
      try { 
        referenceSource0.findBases(sAMSequenceRecord0, false);
        fail("Expecting exception: RuntimeException");
      
      } catch(RuntimeException e) {
         //
         // org.evosuite.runtime.mock.java.lang.MockThrowable: Could not find: www.ebi.ac.uk
         //
         verifyException("uk.ac.sanger.artemis.cramtools.ref.ReferenceSource", e);
      }
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      ReferenceSource referenceSource0 = new ReferenceSource();
      // Undeclared exception!
      try { 
        referenceSource0.findBases((SAMSequenceRecord) null, false);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.cramtools.ref.ReferenceSource", e);
      }
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      MockFile mockFile0 = new MockFile("", "");
      ReferenceSource referenceSource0 = null;
      try {
        referenceSource0 = new ReferenceSource(mockFile0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("htsjdk.samtools.reference.ReferenceSequenceFileFactory", e);
      }
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      ReferenceSource referenceSource0 = new ReferenceSource();
      List<String> list0 = referenceSource0.getVariants("chrM");
      assertEquals(2, referenceSource0.getDownloadTriesBeforeFailing());
      assertEquals(2, list0.size());
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      ReferenceSource referenceSource0 = new ReferenceSource((ReferenceSequenceFile) null);
      List<String> list0 = referenceSource0.getVariants("M");
      assertEquals(2, referenceSource0.getDownloadTriesBeforeFailing());
      assertEquals(2, list0.size());
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      EvoSuiteURL evoSuiteURL0 = new EvoSuiteURL("https://www.ebi.ac.uk/ena/cram/md5/d");
      NetworkHandling.createRemoteTextFile(evoSuiteURL0, "Illegal base [");
      ReferenceSource referenceSource0 = new ReferenceSource();
      referenceSource0.findBasesByMD5("d");
      assertEquals(2, referenceSource0.getDownloadTriesBeforeFailing());
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      ReferenceSource referenceSource0 = new ReferenceSource((ReferenceSequenceFile) null);
      SAMSequenceRecord sAMSequenceRecord0 = new SAMSequenceRecord("", 43);
      sAMSequenceRecord0.setMd5("");
      // Undeclared exception!
      try { 
        referenceSource0.getRegion(sAMSequenceRecord0, 1074, 4096);
        fail("Expecting exception: RuntimeException");
      
      } catch(RuntimeException e) {
         //
         // org.evosuite.runtime.mock.java.lang.MockThrowable: Could not find: www.ebi.ac.uk
         //
         verifyException("uk.ac.sanger.artemis.cramtools.ref.ReferenceSource", e);
      }
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      File file0 = MockFile.createTempFile("^JG`;MOf4VH,O*h", "^JG`;MOf4VH,O*h");
      ReferenceSource referenceSource0 = null;
      try {
        referenceSource0 = new ReferenceSource(file0);
        fail("Expecting exception: IllegalArgumentException");
      
      } catch(IllegalArgumentException e) {
         //
         // File is not a supported reference file type: /var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/^JG`;MOf4VH,O*h0^JG`;MOf4VH,O*h
         //
         verifyException("htsjdk.samtools.reference.ReferenceSequenceFileFactory", e);
      }
  }

  @Test(timeout = 4000)
  public void test18()  throws Throwable  {
      ReferenceSource referenceSource0 = new ReferenceSource((File) null);
      List<String> list0 = referenceSource0.getVariants("AS");
      assertEquals(2, referenceSource0.getDownloadTriesBeforeFailing());
      assertEquals(1, list0.size());
  }

  @Test(timeout = 4000)
  public void test19()  throws Throwable  {
      ReferenceSource referenceSource0 = new ReferenceSource();
      int int0 = referenceSource0.getDownloadTriesBeforeFailing();
      assertEquals(2, int0);
  }

  @Test(timeout = 4000)
  public void test20()  throws Throwable  {
      ReferenceSource referenceSource0 = new ReferenceSource();
      assertEquals(2, referenceSource0.getDownloadTriesBeforeFailing());
      
      referenceSource0.setDownloadTriesBeforeFailing(0);
      int int0 = referenceSource0.getDownloadTriesBeforeFailing();
      assertEquals(0, int0);
  }

  @Test(timeout = 4000)
  public void test21()  throws Throwable  {
      ReferenceSource referenceSource0 = new ReferenceSource();
      referenceSource0.clearCache();
      assertEquals(2, referenceSource0.getDownloadTriesBeforeFailing());
  }

  @Test(timeout = 4000)
  public void test22()  throws Throwable  {
      ReferenceSource referenceSource0 = new ReferenceSource((ReferenceSequenceFile) null);
      SAMSequenceRecord sAMSequenceRecord0 = new SAMSequenceRecord("", 43);
      referenceSource0.getRegion(sAMSequenceRecord0, 1074, 4096);
      assertEquals(2, referenceSource0.getDownloadTriesBeforeFailing());
  }

  @Test(timeout = 4000)
  public void test23()  throws Throwable  {
      ReferenceSource referenceSource0 = new ReferenceSource();
      try { 
        referenceSource0.findBasesByMD5("d");
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // Could not find: www.ebi.ac.uk
         //
         verifyException("org.evosuite.runtime.mock.java.net.EvoHttpURLConnection", e);
      }
  }
}
