/*
 * This file was automatically generated by EvoSuite
 * Wed Sep 19 20:36:42 GMT 2018
 */

package uk.ac.sanger.artemis.sequence;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.shaded.org.mockito.Mockito.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.awt.HeadlessException;
import java.awt.List;
import java.awt.TextArea;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.FlavorListener;
import java.io.ByteArrayOutputStream;
import java.io.PipedReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Comparator;
import java.util.Stack;
import javax.swing.JApplet;
import javax.swing.JComboBox;
import javax.swing.JInternalFrame;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.table.JTableHeader;
import javax.swing.tree.TreeNode;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;
import org.biojava.bio.seq.SimpleFeatureRealizer;
import org.biojava.bio.seq.homol.HomologyFeature;
import org.biojava.bio.symbol.SymbolList;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.System;
import org.evosuite.runtime.ViolatedAssumptionAnswer;
import org.evosuite.runtime.mock.java.io.MockFileWriter;
import org.evosuite.runtime.mock.java.io.MockPrintStream;
import org.evosuite.runtime.mock.java.io.MockPrintWriter;
import org.evosuite.runtime.testdata.EvoSuiteFile;
import org.evosuite.runtime.testdata.FileSystemHandling;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.ActionController;
import uk.ac.sanger.artemis.Entry;
import uk.ac.sanger.artemis.EntryGroup;
import uk.ac.sanger.artemis.Feature;
import uk.ac.sanger.artemis.FeatureFromVectorPredicate;
import uk.ac.sanger.artemis.FeatureKeyQualifierPredicate;
import uk.ac.sanger.artemis.FeaturePatternPredicate;
import uk.ac.sanger.artemis.FeaturePredicate;
import uk.ac.sanger.artemis.FeaturePredicateConjunction;
import uk.ac.sanger.artemis.FeaturePredicateVector;
import uk.ac.sanger.artemis.FeatureVector;
import uk.ac.sanger.artemis.FilteredEntryGroup;
import uk.ac.sanger.artemis.GotoEventSource;
import uk.ac.sanger.artemis.Selection;
import uk.ac.sanger.artemis.SimpleEntryGroup;
import uk.ac.sanger.artemis.SimpleGotoEventSource;
import uk.ac.sanger.artemis.components.BasePlotGroup;
import uk.ac.sanger.artemis.components.FeatureDisplay;
import uk.ac.sanger.artemis.components.SelectionViewer;
import uk.ac.sanger.artemis.io.BioJavaSequence;
import uk.ac.sanger.artemis.io.DatabaseDocumentEntry;
import uk.ac.sanger.artemis.io.EmblStreamSequence;
import uk.ac.sanger.artemis.io.FastaStreamSequence;
import uk.ac.sanger.artemis.io.GenbankStreamSequence;
import uk.ac.sanger.artemis.io.Key;
import uk.ac.sanger.artemis.io.LineGroup;
import uk.ac.sanger.artemis.io.Location;
import uk.ac.sanger.artemis.io.PartialSequence;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.io.RawStreamSequence;
import uk.ac.sanger.artemis.io.Sequence;
import uk.ac.sanger.artemis.io.StreamSequence;
import uk.ac.sanger.artemis.plot.AGWindowAlgorithm;
import uk.ac.sanger.artemis.sequence.AminoAcidSequence;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.sequence.Marker;
import uk.ac.sanger.artemis.sequence.MarkerRange;
import uk.ac.sanger.artemis.sequence.SequenceChangeListener;
import uk.ac.sanger.artemis.sequence.Strand;
import uk.ac.sanger.artemis.util.LinePushBackReader;
import uk.ac.sanger.artemis.util.StringVector;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = false, useJEE = true) 
public class Bases_ESTest extends Bases_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test000()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence(";", ";");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Range range0 = new Range((-483), 12);
      FileSystemHandling.shouldThrowIOException((EvoSuiteFile) null);
      Bases bases1 = bases0.truncate(range0);
      bases1.getComplementPosition((-5));
      bases1.getTranslation(range0, 1828, true);
      bases1.getReverseStrand();
      String[] stringArray0 = new String[8];
      stringArray0[0] = ";";
      stringArray0[1] = ";";
      stringArray0[3] = ";";
      stringArray0[4] = ";";
      stringArray0[5] = ";";
      stringArray0[6] = ";";
      stringArray0[0] = ";";
      StringVector stringVector0 = new StringVector();
      bases1.getMatchingCodons(range0, (-1715), stringVector0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases1);
      bases0.getStopCodons(range0, 323);
      Bases.reverseComplement("internal error - unexpected exception: ");
      FeatureVector featureVector0 = new FeatureVector();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector0, ";");
      FeatureFromVectorPredicate featureFromVectorPredicate0 = new FeatureFromVectorPredicate(featureVector0);
      bases1.getStopOrStartCodons(range0, 2139, stringVector0);
      FilteredEntryGroup filteredEntryGroup1 = new FilteredEntryGroup(filteredEntryGroup0, featureFromVectorPredicate0, ";");
      // Undeclared exception!
      try { 
        filteredEntryGroup1.featureAt((-5));
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test001()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("y");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Range range0 = new Range((-483), 12);
      FileSystemHandling.shouldThrowIOException((EvoSuiteFile) null);
      Bases bases1 = bases0.truncate(range0);
      bases1.getComplementPosition((-5));
      bases1.getTranslation(range0, 1828, true);
      bases1.getReverseStrand();
      String[] stringArray0 = new String[8];
      stringArray0[0] = "y";
      stringArray0[1] = "y";
      stringArray0[4] = "y";
      stringArray0[3] = "y";
      range0.copy();
      FileSystemHandling.appendLineToFile((EvoSuiteFile) null, "y");
      stringArray0[4] = "y";
      stringArray0[5] = "y";
      stringArray0[6] = "y";
      stringArray0[0] = "y";
      StringVector stringVector0 = new StringVector(stringArray0);
      // Undeclared exception!
      try { 
        bases1.getMatchingCodons(range0, (-1715), stringVector0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test002()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("OxP;{UEDa");
      StreamSequence streamSequence0 = genbankStreamSequence0.copy();
      Bases bases0 = new Bases(streamSequence0);
      bases0.clearCodonCache();
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      byte[] byteArray0 = new byte[6];
      byteArray0[0] = (byte) (-80);
      byteArray0[1] = (byte) (-112);
      byteArray0[2] = (byte)118;
      byteArray0[3] = (byte)99;
      byteArray0[4] = (byte) (-18);
      byteArray0[5] = (byte)69;
      FileSystemHandling.appendDataToFile((EvoSuiteFile) null, byteArray0);
      ActionController actionController0 = simpleEntryGroup0.getActionController();
      bases0.removeSequenceChangeListener(actionController0);
  }

  @Test(timeout = 4000)
  public void test003()  throws Throwable  {
      String string0 = "";
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("");
      Bases bases0 = new Bases(genbankStreamSequence0);
      String string1 = "xxR)c':nM";
      Bases.reverseComplement("xxR)c':nM");
      Bases.reverseComplement("");
      bases0.getAverageAGPercent();
      Bases.complement(bases0.letter_index);
      FileSystemHandling.appendDataToFile((EvoSuiteFile) null, (byte[]) null);
      int int0 = 86;
      Range range0 = new Range(86);
      bases0.addBases(113, 91, "kn@@g@yxx");
      bases0.getSubSequence(range0, 5);
      try { 
        range0.change(5, 0);
        fail("Expecting exception: Exception");
      
      } catch(Exception e) {
         //
         // start: 5 > end: 0
         //
         verifyException("uk.ac.sanger.artemis.io.Range", e);
      }
  }

  @Test(timeout = 4000)
  public void test004()  throws Throwable  {
      String string0 = "OxP;{UEDa";
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("OxP;{UEDa");
      StreamSequence streamSequence0 = genbankStreamSequence0.copy();
      genbankStreamSequence0.copy();
      Bases bases0 = new Bases(streamSequence0);
      Range range0 = new Range(0);
      // Undeclared exception!
      try { 
        bases0.getStopCodons(range0, (-804));
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // 0
         //
         verifyException("uk.ac.sanger.artemis.io.StreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test005()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Bases.reverseComplement("xxR)c':nM");
      Bases.reverseComplement("");
      bases0.getAverageAGPercent();
      Bases.complement(bases0.letter_index);
      FileSystemHandling.appendDataToFile((EvoSuiteFile) null, (byte[]) null);
      Range range0 = new Range(2);
      bases0.addBases(113, 91, "kn@@g@yxx");
      Bases.complement("kn@@g@yxx");
      range0.change(5, 752);
      bases0.getSubSequenceC(range0, 2);
      bases0.getForwardStrand();
      Bases.reverseComplement("!U~51");
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      FeatureVector featureVector0 = new FeatureVector();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector0, "5iX;=8U &jVO[#{");
      Key key0 = new Key("xxR)c':nM");
      FeatureKeyQualifierPredicate featureKeyQualifierPredicate0 = new FeatureKeyQualifierPredicate(key0, "", "5iX;=8U &jVO[#{", false, false);
      FilteredEntryGroup filteredEntryGroup1 = new FilteredEntryGroup(filteredEntryGroup0, featureKeyQualifierPredicate0, "P");
      Entry entry0 = filteredEntryGroup1.createEntry();
      // Undeclared exception!
      try { 
        entry0.createFeature();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.Entry", e);
      }
  }

  @Test(timeout = 4000)
  public void test006()  throws Throwable  {
      Bases.complement("r@=>y_>:");
      String string0 = "";
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("");
      Bases bases0 = new Bases(rawStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Key key0 = new Key("");
      simpleEntryGroup0.features();
      FeatureKeyQualifierPredicate featureKeyQualifierPredicate0 = new FeatureKeyQualifierPredicate(key0, "y@@@r@@@", "", true, true);
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureKeyQualifierPredicate0, "r@=>y_>:");
      simpleEntryGroup0.getSequenceLength();
      Bases bases1 = filteredEntryGroup0.getBases();
      bases1.getLength();
      System.setCurrentTimeMillis(0);
      Range range0 = new Range(54189869);
      bases0.getStopOrStartCodons(range0, 0, (StringVector) null);
      // Undeclared exception!
      try { 
        bases0.deleteRange(range0);
        fail("Expecting exception: StringIndexOutOfBoundsException");
      
      } catch(StringIndexOutOfBoundsException e) {
      }
  }

  @Test(timeout = 4000)
  public void test007()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("C8Khbv>$yfn,G2Uc&P(");
      StringWriter stringWriter0 = new StringWriter();
      LineGroup.writeEndOfEMBLEntry(stringWriter0);
      Bases bases0 = new Bases(emblStreamSequence0);
      bases0.toString();
      Range range0 = new Range(0);
      // Undeclared exception!
      try { 
        bases0.getSubSequenceC(range0, 5);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // 0
         //
         verifyException("uk.ac.sanger.artemis.io.StreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test008()  throws Throwable  {
      FileSystemHandling fileSystemHandling0 = new FileSystemHandling();
      FileSystemHandling.setPermissions((EvoSuiteFile) null, true, false, false);
      Bases.complement('i');
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("~qN%h6_PO");
      Bases bases0 = new Bases(rawStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      FeatureVector featureVector0 = new FeatureVector();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector0, "~qN%h6_PO");
      Clipboard clipboard0 = new Clipboard("~qN%h6_PO");
      Selection selection0 = new Selection(clipboard0);
      SimpleEntryGroup simpleEntryGroup1 = new SimpleEntryGroup();
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup1);
      List list0 = null;
      try {
        list0 = new List(5);
        fail("Expecting exception: HeadlessException");
      
      } catch(HeadlessException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.awt.GraphicsEnvironment", e);
      }
  }

  @Test(timeout = 4000)
  public void test009()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("Parse error in this location: ");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Range range0 = new Range(1);
      FileSystemHandling.shouldThrowIOException((EvoSuiteFile) null);
      Bases bases1 = bases0.truncate(range0);
      Range range1 = new Range(0, 1);
      Range range2 = range1.change(0, 23);
      bases1.getComplementPosition((-5));
      bases1.getTranslation(range1, 1828, true);
      bases1.getReverseStrand();
      String[] stringArray0 = new String[8];
      stringArray0[0] = "Parse error in this location: ";
      stringArray0[1] = "Parse error in this location: ";
      stringArray0[4] = "Parse error in this location: ";
      stringArray0[0] = "Parse error in this location: ";
      stringArray0[4] = "Parse error in this location: ";
      stringArray0[5] = "Parse error in this location: ";
      stringArray0[6] = "Parse error in this location: ";
      stringArray0[7] = "Parse error in this location: ";
      StringVector stringVector0 = new StringVector(stringArray0);
      bases0.getStopCodons(range2, 2);
      Bases.reverseComplement("internal error - unexpected exception: ");
      FeatureVector featureVector0 = new FeatureVector();
      FeatureFromVectorPredicate featureFromVectorPredicate0 = new FeatureFromVectorPredicate(featureVector0);
      bases1.getStopOrStartCodons(range0, 2139, stringVector0);
      bases1.getSubSequence(range0, (-65));
      bases0.getAverageGCPercent();
  }

  @Test(timeout = 4000)
  public void test010()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence(";");
      Bases bases0 = new Bases(fastaStreamSequence0);
      FileSystemHandling.shouldThrowIOException((EvoSuiteFile) null);
      int[] intArray0 = new int[2];
      intArray0[0] = 12;
      intArray0[1] = 0;
      fastaStreamSequence0.setFastaHeaderPosition(intArray0, intArray0);
      Range range0 = new Range(0, 1);
      String[] stringArray0 = new String[8];
      stringArray0[1] = ";";
      stringArray0[4] = ";";
      stringArray0[3] = ";";
      stringArray0[4] = ";";
      stringArray0[5] = ";";
      stringArray0[6] = ";";
      stringArray0[0] = ";";
      StringVector stringVector0 = new StringVector(stringArray0);
      Bases.reverseComplement("internal error - unexpected exception: ");
      FeatureVector featureVector0 = new FeatureVector();
      FeatureFromVectorPredicate featureFromVectorPredicate0 = new FeatureFromVectorPredicate(featureVector0);
      bases0.getTCount();
      bases0.getAverageGCPercent();
  }

  @Test(timeout = 4000)
  public void test011()  throws Throwable  {
      Bases.complement('T');
  }

  @Test(timeout = 4000)
  public void test012()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence(";");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Range range0 = new Range((-483), 12);
      FileSystemHandling.shouldThrowIOException((EvoSuiteFile) null);
      Bases bases1 = bases0.truncate(range0);
      bases1.getComplementPosition((-5));
      bases1.getStopCodons(range0, 12);
      bases1.getTranslation(range0, 1828, true);
      bases1.getReverseStrand();
      String[] stringArray0 = new String[8];
      stringArray0[0] = ";";
      stringArray0[1] = ";";
      stringArray0[4] = ";";
      stringArray0[3] = ";";
      stringArray0[4] = ";";
      stringArray0[5] = ";";
      FileSystemHandling.appendStringToFile((EvoSuiteFile) null, "eot<wjI;-W,ht7A9");
      stringArray0[6] = ";";
      stringArray0[0] = ";";
      StringVector stringVector0 = new StringVector(stringArray0);
      // Undeclared exception!
      try { 
        bases1.getMatchingCodons(range0, (-1715), stringVector0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test013()  throws Throwable  {
      Bases.getIndexOfBase('6');
      System.setCurrentTimeMillis(403L);
      StringReader stringReader0 = new StringReader("getMethodName");
      LinePushBackReader linePushBackReader0 = new LinePushBackReader(stringReader0);
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("getMethodName", "getMethodName");
      Bases bases0 = new Bases(fastaStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      ActionController actionController0 = simpleEntryGroup0.getActionController();
      bases0.removeSequenceChangeListener(actionController0);
      bases0.getGCount();
  }

  @Test(timeout = 4000)
  public void test014()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      FileSystemHandling.shouldAllThrowIOExceptions();
      SimpleFeatureRealizer simpleFeatureRealizer0 = new SimpleFeatureRealizer();
      SimpleFeatureRealizer simpleFeatureRealizer1 = new SimpleFeatureRealizer(simpleFeatureRealizer0);
      Bases.complement("va-rT~9z_V{");
      HomologyFeature.Template homologyFeature_Template0 = new HomologyFeature.Template();
      Bases.complement('u');
      Bases.isLegalBase('a');
      Bases bases0 = new Bases((Sequence) null);
      Strand strand0 = new Strand(bases0, 1);
      AGWindowAlgorithm aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
      Bases bases1 = aGWindowAlgorithm0.getBases();
      // Undeclared exception!
      try { 
        bases1.getBaseAt(8818);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test015()  throws Throwable  {
      String string0 = "Parse error in this location: ";
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("Parse error in this location: ");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Range range0 = new Range(1);
      FileSystemHandling.shouldThrowIOException((EvoSuiteFile) null);
      Bases bases1 = bases0.truncate(range0);
      Range range1 = new Range(0);
      range1.change(0, 23);
      bases1.getComplementPosition((-5));
      bases1.reverseComplement();
      // Undeclared exception!
      try { 
        bases1.getTranslation(range1, 1828, true);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // 0
         //
         verifyException("uk.ac.sanger.artemis.io.StreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test016()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, (FeaturePredicate) null, "");
      Range range0 = new Range((-5), (-5));
      FeatureVector featureVector0 = simpleEntryGroup0.getFeaturesInRange(range0);
      FilteredEntryGroup filteredEntryGroup1 = new FilteredEntryGroup(filteredEntryGroup0, featureVector0, "");
      Bases bases1 = filteredEntryGroup1.getBases();
      // Undeclared exception!
      try { 
        bases1.getLength();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test017()  throws Throwable  {
      String string0 = "";
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("");
      Bases bases0 = new Bases(genbankStreamSequence0);
      String string1 = "xxR)c':nM";
      Bases.reverseComplement("");
      bases0.getAverageAGPercent();
      char[] charArray0 = AminoAcidSequence.codon_translation_array;
      FileSystemHandling.appendDataToFile((EvoSuiteFile) null, (byte[]) null);
      Range range0 = new Range(1);
      range0.change(5, 752);
      bases0.getLength();
      bases0.getSubSequenceC(range0, 1);
      bases0.getForwardStrand();
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      // Undeclared exception!
      try { 
        simpleEntryGroup0.createFeature();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.SimpleEntryGroup", e);
      }
  }

  @Test(timeout = 4000)
  public void test018()  throws Throwable  {
      int int0 = new Character('E');
      System.setCurrentTimeMillis(418L);
      Bases.complement('E');
      Bases.complement('E');
  }

  @Test(timeout = 4000)
  public void test019()  throws Throwable  {
      Bases.getIndexOfBase('6');
      System.setCurrentTimeMillis(403L);
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("%r}//'k~f&+7y@L,zQp");
      StreamSequence streamSequence0 = genbankStreamSequence0.copy();
      Bases bases0 = new Bases(streamSequence0);
      Strand strand0 = new Strand(bases0, 5);
      Marker marker0 = new Marker(strand0, 1);
      Marker marker1 = Marker.getRawLowest(marker0, marker0);
      MarkerRange markerRange0 = new MarkerRange(marker1);
      Range range0 = markerRange0.getRange();
      Bases bases1 = bases0.truncate(range0);
      bases1.getStopCodons(range0, 2);
      bases1.getGCount();
  }

  @Test(timeout = 4000)
  public void test020()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence(";");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Range range0 = new Range((-483), 12);
      FileSystemHandling.shouldThrowIOException((EvoSuiteFile) null);
      Bases bases1 = bases0.truncate(range0);
      Range range1 = new Range(0, 1);
      bases1.getComplementPosition((-5));
      bases1.addBases(96, 1, "com.ibatis.sqlmap.engine.mapping.sql.dynamic.DynamicSql");
      bases1.getTranslation(range1, 1828, true);
      bases1.getReverseStrand();
      String[] stringArray0 = new String[8];
      stringArray0[0] = ";";
      stringArray0[1] = ";";
      stringArray0[4] = ";";
      stringArray0[3] = ";";
      stringArray0[4] = ";";
      stringArray0[5] = ";";
      stringArray0[6] = ";";
      stringArray0[0] = ";";
      StringVector stringVector0 = new StringVector(stringArray0);
      // Undeclared exception!
      try { 
        bases1.getMatchingCodons(range0, (-1715), stringVector0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test021()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("Parse error in this location: ");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Range range0 = new Range(1);
      FileSystemHandling.shouldThrowIOException((EvoSuiteFile) null);
      Bases bases1 = bases0.truncate(range0);
      Range range1 = new Range(0, 1);
      Range range2 = range1.change(0, 23);
      bases1.getComplementPosition((-5));
      bases1.getTranslation(range1, 1828, true);
      bases1.getReverseStrand();
      String[] stringArray0 = new String[8];
      stringArray0[0] = "Parse error in this location: ";
      stringArray0[1] = "Parse error in this location: ";
      stringArray0[4] = "Parse error in this location: ";
      stringArray0[0] = "Parse error in this location: ";
      stringArray0[4] = "Parse error in this location: ";
      stringArray0[5] = "Parse error in this location: ";
      stringArray0[6] = "Parse error in this location: ";
      stringArray0[7] = "Parse error in this location: ";
      StringVector stringVector0 = new StringVector(stringArray0);
      bases0.getStopCodons(range2, 2);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases1);
      bases1.getSpacedTranslation(range0, 119, true);
      Bases.reverseComplement("internal error - unexpected exception: ");
      // Undeclared exception!
      try { 
        simpleEntryGroup0.getFeaturesInIndexRange(0, 0);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - index out of range: 0
         //
         verifyException("uk.ac.sanger.artemis.SimpleEntryGroup", e);
      }
  }

  @Test(timeout = 4000)
  public void test022()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("Parse error in this location: ");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Range range0 = new Range(1);
      FileSystemHandling.shouldThrowIOException((EvoSuiteFile) null);
      Bases bases1 = bases0.truncate(range0);
      bases1.getBaseAt(1);
      Range range1 = new Range(0, 1);
      Range range2 = range1.change(0, 23);
      bases1.getComplementPosition((-5));
      bases1.getTranslation(range1, 1828, true);
      bases1.getReverseStrand();
      String[] stringArray0 = new String[8];
      stringArray0[0] = "Parse error in this location: ";
      stringArray0[1] = "Parse error in this location: ";
      stringArray0[4] = "Parse error in this location: ";
      stringArray0[0] = "Parse error in this location: ";
      stringArray0[4] = "Parse error in this location: ";
      stringArray0[5] = "Parse error in this location: ";
      stringArray0[6] = "Parse error in this location: ";
      stringArray0[7] = "Parse error in this location: ";
      StringVector stringVector0 = new StringVector(stringArray0);
      bases0.getStopCodons(range2, 2);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases1);
      Bases.reverseComplement("internal error - unexpected exception: ");
      FeatureVector featureVector0 = new FeatureVector();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector0, "Parse error in this location: ");
      FeatureFromVectorPredicate featureFromVectorPredicate0 = new FeatureFromVectorPredicate(featureVector0);
      bases1.getStopOrStartCodons(range0, 2139, stringVector0);
      FilteredEntryGroup filteredEntryGroup1 = new FilteredEntryGroup(filteredEntryGroup0, featureFromVectorPredicate0, "Parse error in this location: ");
      // Undeclared exception!
      try { 
        filteredEntryGroup1.featureAt((-5));
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test023()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("Parse error in this location: ");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Range range0 = new Range(1);
      FileSystemHandling.shouldThrowIOException((EvoSuiteFile) null);
      Bases bases1 = bases0.truncate(range0);
      Range range1 = new Range(0, 1);
      Range range2 = range1.change(0, 33);
      bases1.getComplementPosition((-5));
      bases1.getTranslation(range1, 1828, true);
      bases1.getReverseStrand();
      String[] stringArray0 = new String[8];
      stringArray0[0] = "Parse error in this location: ";
      stringArray0[1] = "Parse error in this location: ";
      stringArray0[4] = "Parse error in this location: ";
      stringArray0[0] = "Parse error in this location: ";
      stringArray0[4] = "Parse error in this location: ";
      stringArray0[5] = "Parse error in this location: ";
      stringArray0[6] = "Parse error in this location: ";
      stringArray0[7] = "Parse error in this location: ";
      StringVector stringVector0 = new StringVector(stringArray0);
      bases0.getStopCodons(range2, 2);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases1);
      Bases.reverseComplement("internal error - unexpected exception: ");
      FeatureVector featureVector0 = new FeatureVector();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector0, "Parse error in this location: ");
      FeatureFromVectorPredicate featureFromVectorPredicate0 = new FeatureFromVectorPredicate(featureVector0);
      bases1.getStopOrStartCodons(range0, 2139, stringVector0);
      FilteredEntryGroup filteredEntryGroup1 = new FilteredEntryGroup(filteredEntryGroup0, featureFromVectorPredicate0, "Parse error in this location: ");
      // Undeclared exception!
      try { 
        filteredEntryGroup1.featureAt((-5));
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test024()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      FileSystemHandling.shouldAllThrowIOExceptions();
      SimpleFeatureRealizer simpleFeatureRealizer0 = new SimpleFeatureRealizer();
      SimpleFeatureRealizer simpleFeatureRealizer1 = new SimpleFeatureRealizer();
      Bases.complement("]mhi3^{OLN(}Y");
      HomologyFeature.Template homologyFeature_Template0 = new HomologyFeature.Template();
      Bases.complement('u');
      Bases.isLegalBase('u');
      Bases bases0 = new Bases((Sequence) null);
      // Undeclared exception!
      try { 
        bases0.getACount();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test025()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("Parse error in this location: ");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Range range0 = new Range((-483), 0);
      FileSystemHandling.shouldThrowIOException((EvoSuiteFile) null);
      Range range1 = new Range((-5), 1);
      bases0.getComplementPosition((-5));
      bases0.getTranslation(range1, 1828, true);
      bases0.getReverseStrand();
      String[] stringArray0 = new String[8];
      stringArray0[0] = "Parse error in this location: ";
      stringArray0[1] = "Parse error in this location: ";
      stringArray0[4] = "Parse error in this location: ";
      stringArray0[3] = "Parse error in this location: ";
      stringArray0[4] = "Parse error in this location: ";
      stringArray0[5] = "Parse error in this location: ";
      stringArray0[6] = "Parse error in this location: ";
      stringArray0[7] = "Parse error in this location: ";
      StringVector stringVector0 = new StringVector(stringArray0);
      bases0.getMatchingCodons(range0, (-1715), stringVector0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Bases.reverseComplement("internal error - unexpected exception: ");
      FeatureVector featureVector0 = new FeatureVector();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector0, "Parse error in this location: ");
      FeatureFromVectorPredicate featureFromVectorPredicate0 = new FeatureFromVectorPredicate(featureVector0);
      bases0.getStopOrStartCodons(range0, 2139, stringVector0);
      FilteredEntryGroup filteredEntryGroup1 = new FilteredEntryGroup(filteredEntryGroup0, featureFromVectorPredicate0, "Parse error in this location: ");
      // Undeclared exception!
      try { 
        filteredEntryGroup1.featureAt((-5));
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test026()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      FileSystemHandling.shouldAllThrowIOExceptions();
      SimpleFeatureRealizer simpleFeatureRealizer0 = new SimpleFeatureRealizer();
      SimpleFeatureRealizer simpleFeatureRealizer1 = new SimpleFeatureRealizer(simpleFeatureRealizer0);
      Bases.complement("va-rT~9z_V{");
      HomologyFeature.Template homologyFeature_Template0 = new HomologyFeature.Template();
      Bases.complement('u');
      Bases.isLegalBase('u');
      Bases bases0 = new Bases((Sequence) null);
      Strand strand0 = new Strand(bases0, 103);
      AGWindowAlgorithm aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
      Bases bases1 = aGWindowAlgorithm0.getBases();
      // Undeclared exception!
      try { 
        bases1.getAverageGCPercent();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test027()  throws Throwable  {
      String string0 = "Pare error in this locatIon: ";
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("Pare error in this locatIon: ");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Range range0 = new Range((-5), 0);
      FileSystemHandling.shouldThrowIOException((EvoSuiteFile) null);
      Bases bases1 = bases0.truncate(range0);
      Range range1 = new Range((-5));
      bases1.getComplementPosition((-5));
      // Undeclared exception!
      try { 
        bases0.getTranslation(range1, 1828, true);
        fail("Expecting exception: NegativeArraySizeException");
      
      } catch(NegativeArraySizeException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.StreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test028()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      Strand strand0 = new Strand(bases0, 2);
      AGWindowAlgorithm aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      simpleEntryGroup0.getSequenceEntry();
      aGWindowAlgorithm0.getDefaultWindowSize();
      SimpleEntryGroup simpleEntryGroup1 = new SimpleEntryGroup();
      Key key0 = Key.CDS;
      FileSystemHandling.shouldAllThrowIOExceptions();
      // Undeclared exception!
      try { 
        bases0.addBases(1, 1, "line has the wrong number of fields:\n");
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test029()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("t\"F[)ExTfnzZN(z");
      Bases bases0 = new Bases(emblStreamSequence0);
      Range range0 = new Range(4);
      Bases bases1 = bases0.truncate(range0);
      bases1.reverseComplement();
  }

  @Test(timeout = 4000)
  public void test030()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      int int0 = (-1849);
      Range range0 = new Range(0, 8848);
      // Undeclared exception!
      try { 
        bases0.deleteRange(range0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test031()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      FileSystemHandling.shouldAllThrowIOExceptions();
      SimpleFeatureRealizer simpleFeatureRealizer0 = new SimpleFeatureRealizer();
      SimpleFeatureRealizer simpleFeatureRealizer1 = new SimpleFeatureRealizer(simpleFeatureRealizer0);
      Bases.reverseComplement("Y.");
      HomologyFeature.Template homologyFeature_Template0 = new HomologyFeature.Template();
      Bases.complement('u');
      Bases.isLegalBase('u');
      Bases.complement('a');
      // Undeclared exception!
      try { 
        AminoAcidSequence.getTranslation((char[]) null, true);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test032()  throws Throwable  {
      FileSystemHandling.shouldAllThrowIOExceptions();
      SimpleFeatureRealizer simpleFeatureRealizer0 = new SimpleFeatureRealizer();
      SimpleFeatureRealizer simpleFeatureRealizer1 = new SimpleFeatureRealizer(simpleFeatureRealizer0);
      Bases.complement("va-rT~l9z_V{");
      HomologyFeature.Template homologyFeature_Template0 = new HomologyFeature.Template();
      Bases.complement('r');
      Bases.isLegalBase('r');
  }

  @Test(timeout = 4000)
  public void test033()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence(" < ");
      Bases bases0 = new Bases(fastaStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      String string0 = null;
      FileSystemHandling.appendStringToFile((EvoSuiteFile) null, (String) null);
      Range range0 = new Range((-5));
      EntryGroup entryGroup0 = simpleEntryGroup0.truncate(range0);
      FeatureKeyQualifierPredicate featureKeyQualifierPredicate0 = new FeatureKeyQualifierPredicate((Key) null, " < ", " < ");
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(entryGroup0, featureKeyQualifierPredicate0, " < ");
      Bases bases1 = filteredEntryGroup0.getBases();
      bases1.getLength();
      bases0.getGCount();
      bases0.getForwardStrand();
      bases0.getGCount();
      range0.change((-5000), 2);
      Range range1 = new Range((-118));
      range1.truncate(range0);
      // Undeclared exception!
      try { 
        bases1.getSubSequenceC(range1, 3);
        fail("Expecting exception: NegativeArraySizeException");
      
      } catch(NegativeArraySizeException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.StreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test034()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("Parse error in this location: ");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Range range0 = new Range((-483), 0);
      FileSystemHandling.shouldThrowIOException((EvoSuiteFile) null);
      Bases bases1 = bases0.truncate(range0);
      Range range1 = new Range(0, 1);
      bases1.getComplementPosition((-5));
      bases1.getTranslation(range1, 1828, true);
      bases1.getReverseStrand();
      String[] stringArray0 = new String[8];
      stringArray0[0] = "Parse error in this location: ";
      stringArray0[1] = "Parse error in this location: ";
      stringArray0[4] = "Parse error in this location: ";
      stringArray0[3] = "Parse error in this location: ";
      stringArray0[4] = "Parse error in this location: ";
      stringArray0[5] = "Parse error in this location: ";
      stringArray0[6] = "Parse error in this location: ";
      stringArray0[7] = "Parse error in this location: ";
      StringVector stringVector0 = new StringVector(stringArray0);
      bases1.getMatchingCodons(range0, (-1715), stringVector0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases1);
      Bases.reverseComplement("internal error - unexpected exception: ");
      FeatureVector featureVector0 = new FeatureVector();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector0, "Parse error in this location: ");
      FeatureFromVectorPredicate featureFromVectorPredicate0 = new FeatureFromVectorPredicate(featureVector0);
      bases1.getStopOrStartCodons(range0, 2139, stringVector0);
      FilteredEntryGroup filteredEntryGroup1 = new FilteredEntryGroup(filteredEntryGroup0, featureFromVectorPredicate0, "Parse error in this location: ");
      bases0.getRawPosition(1934, (-65));
  }

  @Test(timeout = 4000)
  public void test035()  throws Throwable  {
      Bases.complement('l');
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Key key0 = new Key("");
      FeatureKeyQualifierPredicate featureKeyQualifierPredicate0 = new FeatureKeyQualifierPredicate(key0, "");
      int int0 = 200;
      FeaturePredicateConjunction featurePredicateConjunction0 = null;
      try {
        featurePredicateConjunction0 = new FeaturePredicateConjunction(featureKeyQualifierPredicate0, featureKeyQualifierPredicate0, 200);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - illegal type given to FeaturePredicateConjunction constructor
         //
         verifyException("uk.ac.sanger.artemis.FeaturePredicateConjunction", e);
      }
  }

  @Test(timeout = 4000)
  public void test036()  throws Throwable  {
      FileSystemHandling.appendStringToFile((EvoSuiteFile) null, "\n\t");
      Bases.complement('m');
      Bases.complement('m');
      Strand strand0 = new Strand((Bases) null, (-915));
      AGWindowAlgorithm aGWindowAlgorithm0 = null;
      try {
        aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Strand", e);
      }
  }

  @Test(timeout = 4000)
  public void test037()  throws Throwable  {
      String string0 = "";
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("");
      Bases bases0 = new Bases(genbankStreamSequence0);
      String string1 = "xxR)c':nM";
      Bases.reverseComplement("xxR)c':nM");
      Bases.reverseComplement("");
      bases0.getAverageAGPercent();
      Bases.complement(bases0.letter_index);
      FileSystemHandling.appendDataToFile((EvoSuiteFile) null, (byte[]) null);
      int int0 = 86;
      Range range0 = new Range(86);
      range0.toString();
      Bases.complement("kn@@g@yxx");
      range0.change(5, 752);
      // Undeclared exception!
      try { 
        bases0.getSpacedTranslation(range0, 86, false);
        fail("Expecting exception: NegativeArraySizeException");
      
      } catch(NegativeArraySizeException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.StreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test038()  throws Throwable  {
      String string0 = "";
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("");
      Bases bases0 = new Bases(genbankStreamSequence0);
      String string1 = "xxR)c':nM";
      bases0.toString();
      Bases.reverseComplement("");
      bases0.getAverageAGPercent();
      Bases.complement(bases0.letter_index);
      FileSystemHandling.appendDataToFile((EvoSuiteFile) null, (byte[]) null);
      Range range0 = new Range(86);
      Bases.complement("");
      range0.change(5, 752);
      // Undeclared exception!
      try { 
        bases0.getSubSequenceC(range0, 86);
        fail("Expecting exception: NegativeArraySizeException");
      
      } catch(NegativeArraySizeException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.StreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test039()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("}XV8&$K(", (String) null);
      Bases bases0 = new Bases(fastaStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Range range0 = new Range(2);
      EntryGroup entryGroup0 = simpleEntryGroup0.truncate(range0);
      Key key0 = new Key("");
      boolean boolean0 = false;
      FeatureKeyQualifierPredicate featureKeyQualifierPredicate0 = new FeatureKeyQualifierPredicate(key0, "", "", false, false);
      range0.copy();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(entryGroup0, featureKeyQualifierPredicate0, "hrYW[L");
      filteredEntryGroup0.getActiveEntries();
      Bases bases1 = filteredEntryGroup0.getBases();
      bases1.deleteRange(range0);
      // Undeclared exception!
      try { 
        filteredEntryGroup0.featureAt((-5));
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test040()  throws Throwable  {
      String string0 = "OxP;{UEDa";
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("OxP;{UEDa");
      StreamSequence streamSequence0 = genbankStreamSequence0.copy();
      Bases bases0 = new Bases(streamSequence0);
      bases0.clearCodonCache();
      bases0.clearCodonCache();
      Bases.complement("OxP;{UEDa");
      String string1 = null;
      // Undeclared exception!
      try { 
        bases0.reverseComplement((Feature) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test041()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("Parse error in this location: ");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Range range0 = new Range(1);
      FileSystemHandling.shouldThrowIOException((EvoSuiteFile) null);
      Bases bases1 = bases0.truncate(range0);
      Range range1 = new Range(0, 1);
      Range range2 = range1.change(0, 23);
      bases1.getComplementPosition((-5));
      bases1.getTranslation(range1, 1828, true);
      bases1.getReverseStrand();
      String[] stringArray0 = new String[8];
      stringArray0[0] = "Parse error in this location: ";
      stringArray0[1] = "Parse error in this location: ";
      stringArray0[4] = "Parse error in this location: ";
      stringArray0[0] = "Parse error in this location: ";
      stringArray0[4] = "Parse error in this location: ";
      stringArray0[5] = "Parse error in this location: ";
      stringArray0[6] = "Parse error in this location: ";
      stringArray0[7] = "Parse error in this location: ";
      StringVector stringVector0 = new StringVector(stringArray0);
      bases0.getStopCodons(range2, 2);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases1);
      Bases.reverseComplement("internal error - unexpected exception: ");
      FeatureVector featureVector0 = new FeatureVector();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector0, "Parse error in this location: ");
      FeatureFromVectorPredicate featureFromVectorPredicate0 = new FeatureFromVectorPredicate(featureVector0);
      bases1.getStopOrStartCodons(range0, 2139, stringVector0);
      FilteredEntryGroup filteredEntryGroup1 = new FilteredEntryGroup(filteredEntryGroup0, featureFromVectorPredicate0, "Parse error in this location: ");
      // Undeclared exception!
      try { 
        filteredEntryGroup1.featureAt((-5));
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test042()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      FileSystemHandling.shouldAllThrowIOExceptions();
      int int0 = 8818;
      SimpleFeatureRealizer simpleFeatureRealizer0 = new SimpleFeatureRealizer();
      SimpleFeatureRealizer simpleFeatureRealizer1 = new SimpleFeatureRealizer(simpleFeatureRealizer0);
      Bases.reverseComplement("va-rT~9z_V{");
      HomologyFeature.Template homologyFeature_Template0 = new HomologyFeature.Template();
      Bases.complement('s');
      Bases.isLegalBase('s');
      Bases bases0 = new Bases((Sequence) null);
      Range range0 = null;
      StringVector stringVector0 = new StringVector("Use the GFF index file (to increase the performance)\nor concatenate the sequences together?");
      StringVector stringVector1 = new StringVector(stringVector0);
      // Undeclared exception!
      try { 
        bases0.getMatchingCodons((Range) null, 8818, stringVector1);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test043()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("Parse error in this location: ");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Range range0 = new Range((-483), 61);
      FileSystemHandling.shouldThrowIOException((EvoSuiteFile) null);
      Bases bases1 = bases0.truncate(range0);
      Range range1 = new Range(0, 1);
      bases1.getComplementPosition((-5));
      bases1.getTranslation(range1, 1828, true);
      bases1.getReverseStrand();
      String[] stringArray0 = new String[8];
      stringArray0[0] = "Parse error in this location: ";
      stringArray0[1] = "Parse error in this location: ";
      stringArray0[4] = "Parse error in this location: ";
      stringArray0[3] = "Parse error in this location: ";
      stringArray0[4] = "Parse error in this location: ";
      stringArray0[5] = "Parse error in this location: ";
      stringArray0[6] = "Parse error in this location: ";
      stringArray0[7] = "Parse error in this location: ";
      StringVector stringVector0 = new StringVector(stringArray0);
      // Undeclared exception!
      try { 
        bases1.getMatchingCodons(range0, (-1691), stringVector0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test044()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("Parse error in this location: ");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Range range0 = new Range((-483), 0);
      FileSystemHandling.shouldThrowIOException((EvoSuiteFile) null);
      Bases bases1 = bases0.truncate(range0);
      Range range1 = new Range(0, 1);
      bases1.getComplementPosition((-5));
      bases1.getTranslation(range1, 1828, true);
      bases1.getReverseStrand();
      String[] stringArray0 = new String[8];
      stringArray0[0] = "Parse error in this location: ";
      stringArray0[1] = "Parse error in this location: ";
      stringArray0[4] = "Parse error in this location: ";
      stringArray0[3] = "Parse error in this location: ";
      stringArray0[4] = "Parse error in this location: ";
      stringArray0[5] = "Parse error in this location: ";
      stringArray0[6] = "Parse error in this location: ";
      stringArray0[7] = "Parse error in this location: ";
      StringVector stringVector0 = new StringVector(stringArray0);
      // Undeclared exception!
      try { 
        bases1.getStopCodons(range1, 1);
        fail("Expecting exception: NegativeArraySizeException");
      
      } catch(NegativeArraySizeException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.StreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test045()  throws Throwable  {
      Bases.getIndexOfBase('-');
      System.setCurrentTimeMillis(403L);
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("\"kX~t&Xd?/T");
      Bases bases0 = new Bases(emblStreamSequence0);
      bases0.getLength();
  }

  @Test(timeout = 4000)
  public void test046()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("Parse error in this location: ");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Range range0 = new Range(1);
      FileSystemHandling.shouldThrowIOException((EvoSuiteFile) null);
      Bases bases1 = bases0.truncate(range0);
      Range range1 = new Range(0, 1);
      range1.change(0, 0);
      bases1.getComplementPosition((-5));
      bases1.getTranslation(range1, 1828, true);
      bases1.getReverseStrand();
      String[] stringArray0 = new String[8];
      stringArray0[0] = "Parse error in this location: ";
      stringArray0[1] = "Parse error in this location: ";
      stringArray0[4] = "Parse error in this location: ";
      stringArray0[3] = "Parse error in this location: ";
      stringArray0[4] = "Parse error in this location: ";
      stringArray0[5] = "Parse error in this location: ";
      stringArray0[6] = "Parse error in this location: ";
      stringArray0[7] = "Parse error in this location: ";
      StringVector stringVector0 = new StringVector(stringArray0);
      bases1.getMatchingCodons(range0, (-1691), stringVector0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases1);
      Bases.reverseComplement("internal error - unexpected exception: ");
      FeatureVector featureVector0 = new FeatureVector();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector0, "Parse error in this location: ");
      FeatureFromVectorPredicate featureFromVectorPredicate0 = new FeatureFromVectorPredicate(featureVector0);
      bases1.getStopOrStartCodons(range0, 2139, stringVector0);
      FilteredEntryGroup filteredEntryGroup1 = new FilteredEntryGroup(filteredEntryGroup0, featureFromVectorPredicate0, "Parse error in this location: ");
      // Undeclared exception!
      try { 
        filteredEntryGroup1.featureAt((-5));
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test047()  throws Throwable  {
      String string0 = "";
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("");
      Bases bases0 = new Bases(genbankStreamSequence0);
      String string1 = "xxR)c':nM";
      Bases.reverseComplement("xxR)c':nM");
      Bases.reverseComplement("");
      bases0.getAverageAGPercent();
      Bases.complement(bases0.letter_index);
      FileSystemHandling.appendDataToFile((EvoSuiteFile) null, (byte[]) null);
      Range range0 = new Range(86);
      bases0.addBases(113, 91, "kn@@g@yxx");
      Bases.complement("kn@@g@yxx");
      range0.change(5, 752);
      // Undeclared exception!
      try { 
        bases0.getSubSequenceC(range0, 86);
        fail("Expecting exception: NegativeArraySizeException");
      
      } catch(NegativeArraySizeException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.StreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test048()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      Strand strand0 = bases0.getReverseStrand();
      AGWindowAlgorithm aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
      aGWindowAlgorithm0.getDefaultWindowSize();
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      String string0 = "Y.";
      SimpleFeatureRealizer simpleFeatureRealizer0 = new SimpleFeatureRealizer();
      // Undeclared exception!
      try { 
        bases0.getRawPosition(2, 3834);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test049()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("Parse error in this location: ");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Range range0 = new Range((-483), 0);
      FileSystemHandling.shouldThrowIOException((EvoSuiteFile) null);
      Bases bases1 = bases0.truncate(range0);
      Range range1 = new Range(0, 1);
      bases1.getComplementPosition((-5));
      bases1.getTranslation(range1, 1828, true);
      bases1.getReverseStrand();
      String[] stringArray0 = new String[8];
      stringArray0[0] = "Parse error in this location: ";
      stringArray0[1] = "Parse error in this location: ";
      stringArray0[4] = "Parse error in this location: ";
      stringArray0[3] = "Parse error in this location: ";
      stringArray0[4] = "Parse error in this location: ";
      stringArray0[5] = "Parse error in this location: ";
      stringArray0[6] = "Parse error in this location: ";
      stringArray0[7] = "Parse error in this location: ";
      StringVector stringVector0 = new StringVector(stringArray0);
      bases1.getMatchingCodons(range0, (-1691), stringVector0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases1);
      Bases.reverseComplement("internal error - unexpected exception: ");
      FeatureVector featureVector0 = new FeatureVector();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector0, "Parse error in this location: ");
      featureVector0.clone();
      FeatureFromVectorPredicate featureFromVectorPredicate0 = new FeatureFromVectorPredicate(featureVector0);
      bases1.getStopOrStartCodons(range0, 2139, stringVector0);
      simpleEntryGroup0.reverseComplement();
      FilteredEntryGroup filteredEntryGroup1 = new FilteredEntryGroup(filteredEntryGroup0, featureFromVectorPredicate0, "Parse error in this location: ");
      // Undeclared exception!
      try { 
        filteredEntryGroup1.featureAt((-5));
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test050()  throws Throwable  {
      char[] charArray0 = new char[9];
      charArray0[0] = ':';
      charArray0[1] = 'm';
      charArray0[2] = 'q';
      charArray0[3] = 'M';
      charArray0[4] = '%';
      charArray0[5] = 'w';
      charArray0[6] = '$';
      charArray0[7] = 'e';
      charArray0[8] = '?';
      Bases.reverseComplement(charArray0);
  }

  @Test(timeout = 4000)
  public void test051()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      Strand strand0 = bases0.getReverseStrand();
      AGWindowAlgorithm aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      simpleEntryGroup0.getSequenceEntry();
      // Undeclared exception!
      try { 
        bases0.toString();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test052()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      SimpleEntryGroup simpleEntryGroup1 = new SimpleEntryGroup();
      Range range0 = new Range((-2434));
      simpleEntryGroup1.getFeaturesInRange(range0);
      String string0 = "NT 3 [";
      range0.change(0, 1);
      // Undeclared exception!
      try { 
        bases0.getTranslation(range0, 0, false);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test053()  throws Throwable  {
      FileSystemHandling fileSystemHandling0 = new FileSystemHandling();
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      FileSystemHandling.createFolder((EvoSuiteFile) null);
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup0);
      Bases.isLegalBase('c');
      Bases.getIndexOfBase('c');
      byte[] byteArray0 = new byte[2];
      byteArray0[0] = (byte)109;
      byteArray0[1] = (byte)21;
      FileSystemHandling.appendDataToFile((EvoSuiteFile) null, byteArray0);
  }

  @Test(timeout = 4000)
  public void test054()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("Parse error in this location: ");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Range range0 = new Range((-483), 0);
      FileSystemHandling.shouldThrowIOException((EvoSuiteFile) null);
      Bases bases1 = bases0.truncate(range0);
      Range range1 = new Range(0, 1);
      bases1.getComplementPosition((-5));
      bases1.getTranslation(range1, 1828, true);
      bases1.getReverseStrand();
      String[] stringArray0 = new String[8];
      stringArray0[0] = "Parse error in this location: ";
      stringArray0[1] = "Parse error in this location: ";
      stringArray0[4] = "Parse error in this location: ";
      stringArray0[3] = "Parse error in this location: ";
      stringArray0[4] = "Parse error in this location: ";
      stringArray0[5] = "Parse error in this location: ";
      stringArray0[6] = "Parse error in this location: ";
      stringArray0[7] = "Parse error in this location: ";
      StringVector stringVector0 = new StringVector(stringArray0);
      bases1.getMatchingCodons(range0, (-1691), stringVector0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases1);
      bases1.getSubSequence(range0, 7);
      FeatureVector featureVector0 = new FeatureVector();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector0, "Parse error in this location: ");
      FeatureFromVectorPredicate featureFromVectorPredicate0 = new FeatureFromVectorPredicate(featureVector0);
      bases1.getStopOrStartCodons(range0, 2139, stringVector0);
      FilteredEntryGroup filteredEntryGroup1 = new FilteredEntryGroup(filteredEntryGroup0, featureFromVectorPredicate0, "Parse error in this location: ");
      // Undeclared exception!
      try { 
        filteredEntryGroup1.featureAt((-5));
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test055()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("zE`6`Id`e-z");
      Bases bases0 = new Bases(emblStreamSequence0);
      Strand strand0 = new Strand(bases0, (-5));
      strand0.getTCount();
      AGWindowAlgorithm aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
      bases0.getACount();
      Bases bases1 = aGWindowAlgorithm0.getBases();
      bases1.getReverseStrand();
      Clipboard clipboard0 = new Clipboard((String) null);
      FlavorListener flavorListener0 = mock(FlavorListener.class, new ViolatedAssumptionAnswer());
      clipboard0.addFlavorListener(flavorListener0);
      Selection selection0 = new Selection(clipboard0);
      selection0.getSelectionRange();
      // Undeclared exception!
      try { 
        bases0.getStopCodons((Range) null, 4);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test056()  throws Throwable  {
      Bases.complement('?');
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      AGWindowAlgorithm aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
      int int0 = 20;
      // Undeclared exception!
      try { 
        bases0.getSubSequenceC((Range) null, 54);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test057()  throws Throwable  {
      String string0 = "";
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("");
      Bases bases0 = new Bases(genbankStreamSequence0);
      String string1 = "xxR)c':nM";
      Bases.reverseComplement("xxR)c':nM");
      Bases.reverseComplement("");
      bases0.getAverageAGPercent();
      Bases.complement(bases0.letter_index);
      FileSystemHandling.appendDataToFile((EvoSuiteFile) null, (byte[]) null);
      Range range0 = new Range(86);
      Bases.complement("kn@@g@yxx");
      range0.change(5, 752);
      // Undeclared exception!
      try { 
        bases0.getSubSequenceC(range0, 86);
        fail("Expecting exception: NegativeArraySizeException");
      
      } catch(NegativeArraySizeException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.StreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test058()  throws Throwable  {
      char[] charArray0 = new char[0];
      Bases.complement(charArray0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      int int0 = (-688);
      Range range0 = new Range((-688));
      // Undeclared exception!
      try { 
        simpleEntryGroup0.truncate(range0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.SimpleEntryGroup", e);
      }
  }

  @Test(timeout = 4000)
  public void test059()  throws Throwable  {
      System.setCurrentTimeMillis(403L);
      char[] charArray0 = new char[5];
      charArray0[0] = '2';
      charArray0[1] = ']';
      charArray0[2] = '.';
      charArray0[3] = 'R';
      charArray0[4] = 'a';
      Integer integer0 = GVTAttributedCharacterIterator.TextAttribute.ORIENTATION_ANGLE;
      PartialSequence partialSequence0 = new PartialSequence(charArray0, (-1928), (-1928), (Short) null, integer0);
      Bases bases0 = new Bases(partialSequence0);
      Strand strand0 = new Strand(bases0, 2);
      AGWindowAlgorithm aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
      Bases bases1 = aGWindowAlgorithm0.getBases();
      MarkerRange markerRange0 = strand0.makeMarkerRangeFromPositions(1, 0);
      Range range0 = markerRange0.getRawRange();
      // Undeclared exception!
      try { 
        bases1.getSubSequence(range0, 1);
        fail("Expecting exception: NegativeArraySizeException");
      
      } catch(NegativeArraySizeException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.PartialSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test060()  throws Throwable  {
      Bases.reverseComplement("Premature end of stream for GENBANK");
      Bases.complement("Premature end of stream for GENBANK");
  }

  @Test(timeout = 4000)
  public void test061()  throws Throwable  {
      FileSystemHandling.appendStringToFile((EvoSuiteFile) null, "internal error - illegal one letter amino acid code");
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("Parse error in this location: ");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Range range0 = new Range((-483), 0);
      FileSystemHandling.shouldThrowIOException((EvoSuiteFile) null);
      Bases bases1 = bases0.truncate(range0);
      bases1.getComplementPosition((-5));
      bases1.getTranslation(range0, 1828, true);
      bases1.getReverseStrand();
      String[] stringArray0 = new String[8];
      stringArray0[0] = "Parse error in this location: ";
      stringArray0[1] = "Parse error in this location: ";
      stringArray0[2] = "Parse error in this location: ";
      stringArray0[3] = "Parse error in this location: ";
      stringArray0[4] = "Parse error in this location: ";
      stringArray0[5] = "Parse error in this location: ";
      stringArray0[6] = "Parse error in this location: ";
      stringArray0[7] = "Parse error in this location: ";
      StringVector stringVector0 = new StringVector(stringArray0);
      bases1.getMatchingCodons(range0, (-1691), stringVector0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases1);
      FeatureVector featureVector0 = new FeatureVector();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector0, "Parse error in this location: ");
      FeatureFromVectorPredicate featureFromVectorPredicate0 = new FeatureFromVectorPredicate(featureVector0);
      Bases.isLegalBase(']');
      bases1.getBaseAt(4);
      FilteredEntryGroup filteredEntryGroup1 = new FilteredEntryGroup(filteredEntryGroup0, featureFromVectorPredicate0, "Parse error in this location: ");
      // Undeclared exception!
      try { 
        filteredEntryGroup1.featureAt((-5));
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test062()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("internal error - unexpected exception: ");
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence(fastaStreamSequence0);
      StreamSequence streamSequence0 = genbankStreamSequence0.copy();
      Bases bases0 = new Bases(streamSequence0);
      bases0.getAverageGCPercent();
  }

  @Test(timeout = 4000)
  public void test063()  throws Throwable  {
      Key key0 = Key.CDS;
      FeatureKeyQualifierPredicate featureKeyQualifierPredicate0 = new FeatureKeyQualifierPredicate(key0, "]mhi3^{O:N(}Y");
      SimpleFeatureRealizer simpleFeatureRealizer0 = new SimpleFeatureRealizer();
      SimpleFeatureRealizer simpleFeatureRealizer1 = new SimpleFeatureRealizer(simpleFeatureRealizer0);
      HomologyFeature.Template homologyFeature_Template0 = new HomologyFeature.Template();
      char char0 = 'u';
      Bases.complement('u');
      Clipboard clipboard0 = new Clipboard("Y.");
      Selection selection0 = new Selection(clipboard0);
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource((EntryGroup) null);
      FeatureDisplay featureDisplay0 = null;
      try {
        featureDisplay0 = new FeatureDisplay((EntryGroup) null, selection0, simpleGotoEventSource0, (BasePlotGroup) null, 8818);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.FeatureDisplay", e);
      }
  }

  @Test(timeout = 4000)
  public void test064()  throws Throwable  {
      Bases.complement('K');
      FileSystemHandling.appendStringToFile((EvoSuiteFile) null, "ZSh%}&/\"#");
      Bases.getIndexOfBase('y');
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Key key0 = Key.CDS;
      FeatureKeyQualifierPredicate featureKeyQualifierPredicate0 = new FeatureKeyQualifierPredicate(key0, "", true);
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureKeyQualifierPredicate0, (String) null);
      filteredEntryGroup0.createEntry();
      Location location0 = null;
      try {
        location0 = new Location((String) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.LocationLexer$TokenEnumeration", e);
      }
  }

  @Test(timeout = 4000)
  public void test065()  throws Throwable  {
      Bases.complement("|fNvBH^7");
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("|fNvBH^7");
      MockFileWriter mockFileWriter0 = new MockFileWriter("|fNvBH^7", true);
      char[] charArray0 = new char[7];
      charArray0[0] = 'r';
      charArray0[1] = '0';
      charArray0[2] = '&';
      charArray0[3] = 'J';
      charArray0[4] = 'f';
      charArray0[5] = '}';
      charArray0[6] = 'I';
      EvoSuiteFile evoSuiteFile0 = new EvoSuiteFile("/Users/kp11/workspace/applications/Artemis-build-ci/Artemis");
      FileSystemHandling.appendStringToFile(evoSuiteFile0, "|fNvBH^7");
      Bases.reverseComplement("@@nbvd@@");
      Bases.complement(charArray0);
      // Undeclared exception!
      try { 
        mockFileWriter0.write(charArray0, 115, (-4090));
        fail("Expecting exception: IndexOutOfBoundsException");
      
      } catch(IndexOutOfBoundsException e) {
      }
  }

  @Test(timeout = 4000)
  public void test066()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("namespace\t");
      genbankStreamSequence0.setHeader("9P;@Em:");
      Bases bases0 = new Bases(genbankStreamSequence0);
      bases0.toString();
      bases0.getCCount();
      bases0.getForwardStrand();
      bases0.getSequence();
      genbankStreamSequence0.copy();
      bases0.toString();
      Bases.complement(bases0.letter_index);
      bases0.getForwardStrand();
      bases0.getRawPosition(1, 1);
      bases0.toString();
      try { 
        bases0.getBaseAt(362);
        fail("Expecting exception: Exception");
      
      } catch(Exception e) {
         //
         // 362 > 10
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test067()  throws Throwable  {
      FileSystemHandling.shouldAllThrowIOExceptions();
      Bases bases0 = new Bases((Sequence) null);
      int int0 = 100;
      // Undeclared exception!
      try { 
        bases0.getBaseAt(100);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test068()  throws Throwable  {
      String string0 = "g$oc.|fh_<c WF";
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("g$oc.|fh_<c WF");
      Bases bases0 = new Bases(genbankStreamSequence0);
      String string1 = "xxR)c':nM";
      Bases.reverseComplement("xxR)c':nM");
      Bases.reverseComplement("g$oc.|fh_<c WF");
      bases0.getAverageAGPercent();
      // Undeclared exception!
      try { 
        LineGroup.writeStartOfGFFEntry((Writer) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.LineGroup", e);
      }
  }

  @Test(timeout = 4000)
  public void test069()  throws Throwable  {
      Range range0 = new Range(35);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Bases.complement('h');
      Entry entry0 = simpleEntryGroup0.createEntry("OelA,T8z$");
      FeatureVector featureVector0 = entry0.getFeaturesInRange(range0);
      // Undeclared exception!
      try { 
        featureVector0.lastElement();
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test070()  throws Throwable  {
      String string0 = "";
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("");
      Bases bases0 = new Bases(genbankStreamSequence0);
      String string1 = "xxR)c':nM";
      Bases.reverseComplement("xxR)c':nM");
      Bases.reverseComplement("");
      bases0.getAverageAGPercent();
      // Undeclared exception!
      try { 
        LineGroup.writeStartOfGFFEntry((Writer) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.LineGroup", e);
      }
  }

  @Test(timeout = 4000)
  public void test071()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("Parse error in this location: ");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Range range0 = new Range((-483), 0);
      Range range1 = new Range(0, 1);
      bases0.getComplementPosition((-5));
      bases0.getTranslation(range1, 1828, true);
      bases0.getReverseStrand();
      String[] stringArray0 = new String[8];
      stringArray0[1] = "Parse error in this location: ";
      stringArray0[2] = "Parse error in this location: ";
      stringArray0[3] = "Parse error in this location: ";
      stringArray0[4] = "Parse error in this location: ";
      stringArray0[5] = "Parse error in this location: ";
      stringArray0[6] = "Parse error in this location: ";
      stringArray0[7] = "Parse error in this location: ";
      StringVector stringVector0 = new StringVector(stringArray0);
      bases0.getMatchingCodons(range0, (-1691), stringVector0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      simpleEntryGroup0.features();
      FeatureVector featureVector0 = new FeatureVector();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector0, "Parse error in this location: ");
      FeatureFromVectorPredicate featureFromVectorPredicate0 = new FeatureFromVectorPredicate(featureVector0);
      FilteredEntryGroup filteredEntryGroup1 = new FilteredEntryGroup(filteredEntryGroup0, featureFromVectorPredicate0, "Parse error in this location: ");
  }

  @Test(timeout = 4000)
  public void test072()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("Parse error in this location: ");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Range range0 = new Range((-483), 0);
      FileSystemHandling.shouldThrowIOException((EvoSuiteFile) null);
      Bases bases1 = bases0.truncate(range0);
      Range range1 = new Range(0, 1);
      bases1.getComplementPosition((-5));
      bases1.getTranslation(range1, 1828, true);
      bases1.getReverseStrand();
      String[] stringArray0 = new String[8];
      stringArray0[0] = "Parse error in this location: ";
      stringArray0[1] = "Parse error in this location: ";
      stringArray0[4] = "Parse error in this location: ";
      stringArray0[3] = "Parse error in this location: ";
      stringArray0[4] = "Parse error in this location: ";
      stringArray0[5] = "Parse error in this location: ";
      stringArray0[6] = "Parse error in this location: ";
      stringArray0[7] = "Parse error in this location: ";
      StringVector stringVector0 = new StringVector(stringArray0);
      bases1.getMatchingCodons(range0, (-1691), stringVector0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases1);
      Bases.reverseComplement("internal error - unexpected exception: ");
      FeatureVector featureVector0 = new FeatureVector();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector0, "Parse error in this location: ");
      FeatureFromVectorPredicate featureFromVectorPredicate0 = new FeatureFromVectorPredicate(featureVector0);
      bases1.getStopOrStartCodons(range0, 2139, stringVector0);
      FilteredEntryGroup filteredEntryGroup1 = new FilteredEntryGroup(filteredEntryGroup0, featureFromVectorPredicate0, "Parse error in this location: ");
      // Undeclared exception!
      try { 
        filteredEntryGroup1.featureAt((-5));
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test073()  throws Throwable  {
      Bases.complement(']');
      String string0 = "";
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("");
      int int0 = (-2427);
      // Undeclared exception!
      try { 
        genbankStreamSequence0.getSubSequence((-2427), 85);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // -1214
         //
         verifyException("uk.ac.sanger.artemis.io.StreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test074()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, (FeatureVector) null, "- ");
      Key key0 = Key.CDS;
      FeatureKeyQualifierPredicate featureKeyQualifierPredicate0 = new FeatureKeyQualifierPredicate(key0, "%IVFlRR%#;1 1A", false);
      FilteredEntryGroup filteredEntryGroup1 = new FilteredEntryGroup(filteredEntryGroup0, featureKeyQualifierPredicate0, "- ");
      Bases bases1 = filteredEntryGroup1.getBases();
      // Undeclared exception!
      try { 
        bases1.addBases(114, 114, "%IVFlRR%#;1 1A");
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test075()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("Parse error in this location: ");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Range range0 = new Range(5);
      Bases bases1 = bases0.truncate(range0);
      Range range1 = new Range(0, 1);
      bases1.getComplementPosition((-5));
      bases1.getTranslation(range1, 1828, true);
      bases1.getReverseStrand();
      String[] stringArray0 = new String[8];
      stringArray0[0] = "Parse error in this location: ";
      stringArray0[1] = "Parse error in this location: ";
      stringArray0[2] = "Parse error in this location: ";
      stringArray0[3] = "Parse error in this location: ";
      stringArray0[4] = "Parse error in this location: ";
      stringArray0[5] = "Parse error in this location: ";
      stringArray0[6] = "Parse error in this location: ";
      stringArray0[7] = "Parse error in this location: ";
      StringVector stringVector0 = StringVector.getStrings("Parse error in this location: ", "Parse error in this location: ");
      bases1.getMatchingCodons(range0, (-1691), stringVector0);
  }

  @Test(timeout = 4000)
  public void test076()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("Parse error in this location: ");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Range range0 = new Range((-483), 0);
      FileSystemHandling.shouldThrowIOException((EvoSuiteFile) null);
      Bases bases1 = bases0.truncate(range0);
      Range range1 = new Range(0, 1);
      bases1.getComplementPosition((-5));
      bases1.getTranslation(range1, 1828, true);
      bases1.getReverseStrand();
      String[] stringArray0 = new String[8];
      stringArray0[0] = "Parse error in this location: ";
      stringArray0[1] = "Parse error in this location: ";
      stringArray0[2] = "Parse error in this location: ";
      stringArray0[3] = "Parse error in this location: ";
      stringArray0[4] = "Parse error in this location: ";
      stringArray0[5] = "Parse error in this location: ";
      stringArray0[6] = "Parse error in this location: ";
      stringArray0[7] = "Parse error in this location: ";
      StringVector stringVector0 = new StringVector(stringArray0);
      StringVector stringVector1 = new StringVector(stringVector0);
      stringVector0.add(stringVector1);
      bases1.getMatchingCodons(range0, (-1691), stringVector0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases1);
      FeatureVector featureVector0 = new FeatureVector();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector0, "Parse error in this location: ");
      FeatureFromVectorPredicate featureFromVectorPredicate0 = new FeatureFromVectorPredicate(featureVector0);
      // Undeclared exception!
      try { 
        bases1.deleteRange(range0);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // -242
         //
         verifyException("uk.ac.sanger.artemis.io.StreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test077()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("Parse error in this location: ");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Range range0 = new Range((-483), 0);
      Bases bases1 = bases0.truncate(range0);
      Range range1 = new Range(0, 1);
      bases1.getComplementPosition((-5));
      bases1.getTranslation(range1, 1828, true);
      bases1.getReverseStrand();
      String[] stringArray0 = new String[8];
      stringArray0[0] = "Parse error in this location: ";
      stringArray0[1] = "Parse error in this location: ";
      stringArray0[2] = "Parse error in this location: ";
      stringArray0[3] = "Parse error in this location: ";
      stringArray0[4] = "Parse error in this location: ";
      bases1.getTranslation(range1, 619, false);
      stringArray0[5] = "Parse error in this location: ";
      stringArray0[6] = "Parse error in this location: ";
      stringArray0[7] = "Parse error in this location: ";
      StringVector stringVector0 = new StringVector(stringArray0);
      bases1.getMatchingCodons(range0, (-1691), stringVector0);
      bases0.getSpacedTranslation(range1, (-746), false);
  }

  @Test(timeout = 4000)
  public void test078()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("Parse error in this location: ");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Range range0 = new Range((-483), 0);
      FileSystemHandling.shouldThrowIOException((EvoSuiteFile) null);
      Bases bases1 = bases0.truncate(range0);
      Range range1 = new Range(0, 1);
      bases1.getComplementPosition((-5));
      bases1.getTranslation(range1, 1828, true);
      bases1.getTranslation(range1, 1, true);
      bases1.getReverseStrand();
      String[] stringArray0 = new String[8];
      stringArray0[0] = "Parse error in this location: ";
      stringArray0[1] = "Parse error in this location: ";
      stringArray0[2] = "Parse error in this location: ";
      stringArray0[3] = "Parse error in this location: ";
      stringArray0[4] = "Parse error in this location: ";
      stringArray0[5] = "Parse error in this location: ";
      stringArray0[6] = "Parse error in this location: ";
      stringArray0[7] = "Parse error in this location: ";
      StringVector stringVector0 = new StringVector(stringArray0);
      bases1.getMatchingCodons(range0, (-1691), stringVector0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases1);
      FeatureVector featureVector0 = new FeatureVector();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector0, "Parse error in this location: ");
      FeatureFromVectorPredicate featureFromVectorPredicate0 = new FeatureFromVectorPredicate(featureVector0);
      FilteredEntryGroup filteredEntryGroup1 = new FilteredEntryGroup(filteredEntryGroup0, featureFromVectorPredicate0, "Parse error in this location: ");
      // Undeclared exception!
      try { 
        filteredEntryGroup1.featureAt((-5));
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test079()  throws Throwable  {
      int int0 = (-1349);
      Bases.complement("u}'D");
      Bases.complement('_');
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      FeatureVector featureVector0 = new FeatureVector();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector0, "a@@h");
      Clipboard clipboard0 = new Clipboard("uk.ac.sanger.artemis.sequence.Bases");
      Selection selection0 = new Selection(clipboard0);
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup0);
      JApplet jApplet0 = null;
      try {
        jApplet0 = new JApplet();
        fail("Expecting exception: HeadlessException");
      
      } catch(HeadlessException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.applet.Applet", e);
      }
  }

  @Test(timeout = 4000)
  public void test080()  throws Throwable  {
      char[] charArray0 = new char[9];
      charArray0[0] = ' ';
      charArray0[1] = 'W';
      charArray0[2] = '\'';
      charArray0[3] = ':';
      charArray0[4] = ')';
      charArray0[5] = '-';
      charArray0[6] = 'k';
      charArray0[7] = '*';
      charArray0[8] = 'm';
      Short short0 = new Short((short) (-437));
      Integer integer0 = GVTAttributedCharacterIterator.TextAttribute.ORIENTATION_ANGLE;
      PartialSequence partialSequence0 = new PartialSequence(charArray0, 0, 0, short0, integer0);
      Bases bases0 = new Bases(partialSequence0);
      Strand strand0 = new Strand(bases0, 5);
      MarkerRange markerRange0 = strand0.makeMarkerRangeFromRawPositions(116, 0);
      Range range0 = markerRange0.getRawRange();
      bases0.getTranslation(range0, 2, false);
      SelectionViewer.getBaseSummary("");
      // Undeclared exception!
      try { 
        bases0.getMatchingCodons(range0, 8945, (StringVector) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test081()  throws Throwable  {
      Bases.reverseComplement("aC5A:LDl}8 M!<");
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      FeatureVector featureVector0 = new FeatureVector();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector0, "@@@k@@@@h@@t@gt");
      Clipboard clipboard0 = new Clipboard("|");
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(filteredEntryGroup0);
      JTableHeader jTableHeader0 = new JTableHeader();
  }

  @Test(timeout = 4000)
  public void test082()  throws Throwable  {
      EvoSuiteFile evoSuiteFile0 = null;
      String string0 = "JV(2VY?@v+LR3FWR/N";
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("JV(2VY?@v+LR3FWR/N", "JV(2VY?@v+LR3FWR/N");
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence(fastaStreamSequence0);
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      AGWindowAlgorithm aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
      Bases bases1 = aGWindowAlgorithm0.getBases();
      // Undeclared exception!
      bases1.addBases(285212682, 2444, "htsjdk.variant.vcf.VCFContigHeaderLine");
  }

  @Test(timeout = 4000)
  public void test083()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence(" < ");
      Bases bases0 = new Bases(fastaStreamSequence0);
      // Undeclared exception!
      try { 
        bases0.addBases((-3483), (-3483), " < ");
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // -1742
         //
         verifyException("uk.ac.sanger.artemis.io.StreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test084()  throws Throwable  {
      Bases.complement('#');
      Sequence sequence0 = null;
      Bases bases0 = new Bases((Sequence) null);
      // Undeclared exception!
      try { 
        bases0.getTCount();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test085()  throws Throwable  {
      char[] charArray0 = new char[9];
      charArray0[0] = ' ';
      charArray0[1] = 'W';
      charArray0[2] = '\'';
      charArray0[3] = ':';
      charArray0[4] = ')';
      charArray0[5] = '-';
      charArray0[6] = 'k';
      charArray0[7] = '*';
      charArray0[8] = 'm';
      Short short0 = new Short((short) (-437));
      Integer integer0 = GVTAttributedCharacterIterator.TextAttribute.ORIENTATION_ANGLE;
      PartialSequence partialSequence0 = new PartialSequence(charArray0, 0, 0, short0, integer0);
      Bases bases0 = new Bases(partialSequence0);
      Strand strand0 = new Strand(bases0, 5);
      MarkerRange markerRange0 = strand0.makeMarkerRangeFromRawPositions(116, 0);
      Range range0 = markerRange0.getRawRange();
      bases0.getTranslation(range0, 2, false);
      SelectionViewer.getBaseSummary("");
      // Undeclared exception!
      try { 
        bases0.getMatchingCodons(range0, 1, (StringVector) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test086()  throws Throwable  {
      // Undeclared exception!
      try { 
        Bases.complement((String) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test087()  throws Throwable  {
      Bases.complement('O');
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("X,j3raJ)c37/^");
      Bases bases0 = new Bases(rawStreamSequence0);
      Strand strand0 = new Strand(bases0, 0);
      AGWindowAlgorithm aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
      Bases bases1 = aGWindowAlgorithm0.getBases();
      Range range0 = new Range(2, 3009);
      // Undeclared exception!
      bases1.truncate(range0);
  }

  @Test(timeout = 4000)
  public void test088()  throws Throwable  {
      char[] charArray0 = new char[7];
      charArray0[0] = 'Y';
      charArray0[1] = '3';
      charArray0[2] = 'x';
      charArray0[3] = 'e';
      charArray0[4] = ',';
      charArray0[5] = '=';
      charArray0[6] = '!';
      Bases.complement(charArray0);
      Clipboard clipboard0 = new Clipboard(" < ");
      Selection selection0 = new Selection(clipboard0);
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource((EntryGroup) null);
      FeatureDisplay featureDisplay0 = null;
      try {
        featureDisplay0 = new FeatureDisplay((EntryGroup) null, selection0, simpleGotoEventSource0, (BasePlotGroup) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.FeatureDisplay", e);
      }
  }

  @Test(timeout = 4000)
  public void test089()  throws Throwable  {
      String string0 = "";
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("");
      char[] charArray0 = new char[4];
      charArray0[0] = ']';
      emblStreamSequence0.forceReset();
      charArray0[1] = '9';
      charArray0[2] = 'Z';
      charArray0[3] = '*';
      emblStreamSequence0.setFromChar(charArray0);
      Bases bases0 = new Bases(emblStreamSequence0);
      Range range0 = null;
      // Undeclared exception!
      try { 
        bases0.getSpacedTranslation((Range) null, 0, false);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test090()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      bases0.clearCodonCache();
      // Undeclared exception!
      try { 
        bases0.getGCount();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test091()  throws Throwable  {
      BioJavaSequence bioJavaSequence0 = new BioJavaSequence((SymbolList) null);
      Bases bases0 = new Bases(bioJavaSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation("gg7DkY3KrY[{`x,33", true);
      FeaturePatternPredicate featurePatternPredicate0 = new FeaturePatternPredicate(aminoAcidSequence0);
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featurePatternPredicate0, "");
      Entry entry0 = Entry.newEntry(bases0);
      Range range0 = new Range((-5), 1);
      Entry entry1 = entry0.truncate(bases0, range0);
      FeatureVector featureVector0 = entry1.getAllFeatures();
      entry1.removeEntryChangeListener(simpleEntryGroup0);
      FilteredEntryGroup filteredEntryGroup1 = new FilteredEntryGroup(filteredEntryGroup0, featureVector0, (String) null);
      Bases bases1 = filteredEntryGroup1.getBases();
      // Undeclared exception!
      try { 
        bases1.getStopCodons(range0, 0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.BioJavaSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test092()  throws Throwable  {
      Bases.reverseComplement("rKnc");
      Bases.complement("rKnc");
      EntryGroup entryGroup0 = null;
      FeaturePredicateVector featurePredicateVector0 = new FeaturePredicateVector();
      int int0 = 1454;
      FeaturePredicateConjunction featurePredicateConjunction0 = null;
      try {
        featurePredicateConjunction0 = new FeaturePredicateConjunction(featurePredicateVector0, 1454);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - illegal type given to FeaturePredicateConjunction constructor
         //
         verifyException("uk.ac.sanger.artemis.FeaturePredicateConjunction", e);
      }
  }

  @Test(timeout = 4000)
  public void test093()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      Feature feature0 = null;
      // Undeclared exception!
      try { 
        bases0.contigRearrange((Feature) null, (-3535));
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test094()  throws Throwable  {
      Bases.getIndexOfBase('6');
      System.setCurrentTimeMillis(403L);
      Bases.getIndexOfBase('6');
      Bases.reverseComplement("org.biojava.bio.seq.homol.Homology");
  }

  @Test(timeout = 4000)
  public void test095()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Key key0 = Key.CDS;
      Bases bases0 = new Bases((Sequence) null);
      Bases.complement("^lrOo>Cd66");
      // Undeclared exception!
      try { 
        bases0.getGCount();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test096()  throws Throwable  {
      Bases.getIndexOfBase('-');
      String string0 = "a";
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("a", "a");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = new Strand(bases0, 8765);
      AGWindowAlgorithm aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
      Bases bases1 = aGWindowAlgorithm0.getBases();
      Selection selection0 = new Selection((Clipboard) null);
      selection0.getSelectionRange();
      // Undeclared exception!
      try { 
        bases1.truncate((Range) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test097()  throws Throwable  {
      // Undeclared exception!
      try { 
        Bases.complement((char[]) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test098()  throws Throwable  {
      char[] charArray0 = new char[5];
      charArray0[0] = '[';
      charArray0[1] = 'l';
      charArray0[2] = 'F';
      charArray0[3] = '^';
      charArray0[4] = '^';
      Short short0 = new Short((short)0);
      Integer integer0 = GVTAttributedCharacterIterator.TextAttribute.ARABIC_ISOLATED;
      PartialSequence partialSequence0 = new PartialSequence(charArray0, 941, 941, short0, integer0);
      Bases bases0 = new Bases(partialSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Clipboard clipboard0 = new Clipboard("uk.ac.sanger.artemis.sequence.Bases");
      Selection selection0 = new Selection(clipboard0);
      FeatureVector featureVector0 = selection0.getSelectedFeatures();
      bases0.getAverageAGPercent();
      FeatureVector featureVector1 = featureVector0.sort((Comparator) null);
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector1, "uk.ac.sanger.artemis.sequence.Bases");
      featureVector1.sort((Comparator) null);
      Bases bases1 = filteredEntryGroup0.getBases();
      bases1.getGCount();
      filteredEntryGroup0.getDefaultEntry();
      // Undeclared exception!
      try { 
        featureVector0.elementAt((-678));
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test099()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      // Undeclared exception!
      try { 
        bases0.getAverageAGPercent();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test100()  throws Throwable  {
      StringReader stringReader0 = new StringReader("rMf%f;z/i");
      LinePushBackReader linePushBackReader0 = new LinePushBackReader(stringReader0);
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence(linePushBackReader0);
      Bases bases0 = new Bases(rawStreamSequence0);
      bases0.getTCount();
      bases0.getCCount();
      bases0.getComplementPosition(8921);
  }

  @Test(timeout = 4000)
  public void test101()  throws Throwable  {
      char char0 = 'U';
      Bases.isLegalBase('U');
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("");
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence(rawStreamSequence0);
      Bases bases0 = new Bases(genbankStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      String string0 = "2OPhavX8%&0!'}q7+";
      Clipboard clipboard0 = new Clipboard("2OPhavX8%&0!'}q7+");
      Selection selection0 = new Selection(clipboard0);
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup0);
      Stack<GenbankStreamSequence> stack0 = new Stack<GenbankStreamSequence>();
      clipboard0.getFlavorListeners();
      JComboBox<GenbankStreamSequence> jComboBox0 = new JComboBox<GenbankStreamSequence>(stack0);
      BasePlotGroup basePlotGroup0 = null;
      try {
        basePlotGroup0 = new BasePlotGroup(simpleEntryGroup0, jComboBox0, selection0, simpleGotoEventSource0);
      
      } catch(Exception e) {
    	  	fail("caught Exception: " + e.getMessage());
      }
  }

  @Test(timeout = 4000)
  public void test102()  throws Throwable  {
      Bases.reverseComplement("[\"5Kn");
      DatabaseDocumentEntry databaseDocumentEntry0 = new DatabaseDocumentEntry();
  }

  @Test(timeout = 4000)
  public void test103()  throws Throwable  {
      char[] charArray0 = new char[3];
      charArray0[0] = 'o';
      charArray0[1] = 'K';
      charArray0[2] = 'K';
      Bases.complement(charArray0);
  }

  @Test(timeout = 4000)
  public void test104()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("Parse error in this location: ");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Range range0 = new Range((-483), 0);
      Bases bases1 = bases0.truncate(range0);
      Range range1 = new Range(0, 1);
      bases1.getComplementPosition((-5));
      bases1.getTranslation(range1, 1828, true);
      bases1.getReverseStrand();
      String[] stringArray0 = new String[8];
      stringArray0[0] = "Parse error in this location: ";
      stringArray0[1] = "Parse error in this location: ";
      stringArray0[2] = "Parse error in this location: ";
      stringArray0[3] = "Parse error in this location: ";
      stringArray0[4] = "Parse error in this location: ";
      stringArray0[5] = "Parse error in this location: ";
      stringArray0[6] = "Parse error in this location: ";
      stringArray0[7] = "Parse error in this location: ";
      StringVector stringVector0 = new StringVector(stringArray0);
      bases1.getMatchingCodons(range0, (-1691), stringVector0);
  }

  @Test(timeout = 4000)
  public void test105()  throws Throwable  {
      String string0 = "u2 j#:-hBRY)UX%";
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("u2 j#:-hBRY)UX%");
      Bases bases0 = new Bases(fastaStreamSequence0);
      bases0.getRawPosition(0, 0);
      Strand strand0 = new Strand(bases0, 0);
      AGWindowAlgorithm aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
      Selection selection0 = new Selection((Clipboard) null);
      selection0.getSelectionRange();
      // Undeclared exception!
      try { 
        strand0.getTranslation((Range) null, false);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test106()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("LX{");
      StreamSequence streamSequence0 = emblStreamSequence0.copy();
      Bases bases0 = new Bases(streamSequence0);
      try { 
        bases0.getBaseAt((-3992));
        fail("Expecting exception: Exception");
      
      } catch(Exception e) {
         //
         // -3992 < 1
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test107()  throws Throwable  {
      char[] charArray0 = new char[0];
      Bases.reverseComplement(charArray0);
      EntryGroup entryGroup0 = null;
      Clipboard clipboard0 = new Clipboard("g+g@%MLpQ=");
      Selection selection0 = new Selection(clipboard0);
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource((EntryGroup) null);
      JTree jTree0 = new JTree((TreeNode) null);
      BasePlotGroup basePlotGroup0 = null;
      try {
        basePlotGroup0 = new BasePlotGroup((EntryGroup) null, jTree0, selection0, simpleGotoEventSource0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.BasePlotGroup", e);
      }
  }

  @Test(timeout = 4000)
  public void test108()  throws Throwable  {
      Bases.isLegalBase('l');
      char[] charArray0 = new char[5];
      charArray0[0] = 'l';
      charArray0[1] = 'l';
      charArray0[2] = 'l';
      charArray0[3] = 'l';
      charArray0[4] = 'l';
      Bases.reverseComplement(charArray0);
  }

  @Test(timeout = 4000)
  public void test109()  throws Throwable  {
      Bases.complement("W*Z");
      EntryGroup entryGroup0 = null;
      Clipboard clipboard0 = new Clipboard("P<'s+TTjuvq(");
      Selection selection0 = new Selection(clipboard0);
      GotoEventSource gotoEventSource0 = null;
      int int0 = 120;
      TextArea textArea0 = null;
      try {
        textArea0 = new TextArea("W*Z", 0, 120, 2405);
        fail("Expecting exception: HeadlessException");
      
      } catch(HeadlessException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.awt.GraphicsEnvironment", e);
      }
  }

  @Test(timeout = 4000)
  public void test110()  throws Throwable  {
      Bases.complement("~#QO5nNTv(%3;5S]#");
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Selection selection0 = null;
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup0);
      JInternalFrame jInternalFrame0 = new JInternalFrame("~#QO5nNTv(%3;5S]#", true, true, false);
      BasePlotGroup basePlotGroup0 = null;
      try {
        basePlotGroup0 = new BasePlotGroup(simpleEntryGroup0, jInternalFrame0, (Selection) null, simpleGotoEventSource0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.BasePlotGroup", e);
      }
  }

  @Test(timeout = 4000)
  public void test111()  throws Throwable  {
      Bases.complement("");
      char[] charArray0 = new char[1];
      charArray0[0] = 'M';
      Bases.reverseComplement(charArray0);
      BioJavaSequence bioJavaSequence0 = new BioJavaSequence((SymbolList) null);
      Bases bases0 = new Bases(bioJavaSequence0);
      Strand strand0 = new Strand(bases0, 2);
      AGWindowAlgorithm aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
      Bases bases1 = aGWindowAlgorithm0.getBases();
      bases1.getReverseStrand();
  }

  @Test(timeout = 4000)
  public void test112()  throws Throwable  {
      Bases.isLegalBase('r');
      Selection selection0 = new Selection((Clipboard) null);
  }

  @Test(timeout = 4000)
  public void test113()  throws Throwable  {
      Bases.complement('+');
  }

  @Test(timeout = 4000)
  public void test114()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, (FeatureVector) null, "- ");
      Key key0 = Key.CDS;
      FeatureKeyQualifierPredicate featureKeyQualifierPredicate0 = new FeatureKeyQualifierPredicate(key0, "%IVFlRR%#;1 1A", false);
      FilteredEntryGroup filteredEntryGroup1 = new FilteredEntryGroup(filteredEntryGroup0, featureKeyQualifierPredicate0, "- ");
      Bases bases1 = filteredEntryGroup1.getBases();
      // Undeclared exception!
      try { 
        bases1.getCCount();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test115()  throws Throwable  {
      // Undeclared exception!
      try { 
        Bases.reverseComplement((char[]) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test116()  throws Throwable  {
      StringReader stringReader0 = new StringReader("@`");
      LinePushBackReader linePushBackReader0 = new LinePushBackReader(stringReader0);
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence(linePushBackReader0);
      RawStreamSequence rawStreamSequence1 = new RawStreamSequence(rawStreamSequence0);
      Bases bases0 = new Bases(rawStreamSequence1);
      bases0.addSequenceChangeListener((SequenceChangeListener) null, 67);
  }

  @Test(timeout = 4000)
  public void test117()  throws Throwable  {
      Bases.complement('`');
      Bases.complement('@');
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("");
      Bases bases0 = new Bases(emblStreamSequence0);
      Range range0 = new Range(2);
      Bases bases1 = bases0.truncate(range0);
      Strand strand0 = bases1.getReverseStrand();
      AGWindowAlgorithm aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
      Bases bases2 = aGWindowAlgorithm0.getBases();
      bases2.truncate(range0);
  }

  @Test(timeout = 4000)
  public void test118()  throws Throwable  {
      char[] charArray0 = new char[1];
      charArray0[0] = 'M';
      Bases.reverseComplement(charArray0);
      BioJavaSequence bioJavaSequence0 = new BioJavaSequence((SymbolList) null);
      Bases bases0 = new Bases(bioJavaSequence0);
      Strand strand0 = new Strand(bases0, 2);
      AGWindowAlgorithm aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
      Bases bases1 = aGWindowAlgorithm0.getBases();
      bases1.getReverseStrand();
  }

  @Test(timeout = 4000)
  public void test119()  throws Throwable  {
      Bases.complement('d');
      AGWindowAlgorithm aGWindowAlgorithm0 = null;
      try {
        aGWindowAlgorithm0 = new AGWindowAlgorithm((Strand) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.plot.BaseAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test120()  throws Throwable  {
      String string0 = "OxP;{UEDa";
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("OxP;{UEDa");
      StreamSequence streamSequence0 = genbankStreamSequence0.copy();
      Bases bases0 = new Bases(streamSequence0);
      bases0.clearCodonCache();
      char char0 = 'A';
      genbankStreamSequence0.copy();
      Bases.complement("OxP;{UEDa");
      String string1 = null;
      MockPrintStream mockPrintStream0 = null;
      try {
        mockPrintStream0 = new MockPrintStream((String) null, "OxP;{UEDa");
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.io.File", e);
      }
  }

  @Test(timeout = 4000)
  public void test121()  throws Throwable  {
      // Undeclared exception!
      try { 
        Bases.reverseComplement((String) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test122()  throws Throwable  {
      PipedReader pipedReader0 = new PipedReader();
      ByteArrayOutputStream byteArrayOutputStream0 = new ByteArrayOutputStream();
      MockPrintStream mockPrintStream0 = new MockPrintStream(byteArrayOutputStream0, true);
      MockPrintWriter mockPrintWriter0 = new MockPrintWriter(mockPrintStream0);
      MockPrintWriter mockPrintWriter1 = new MockPrintWriter(mockPrintWriter0);
      Bases.reverseComplement("7ob.z<C$|n4O$?");
  }

  @Test(timeout = 4000)
  public void test123()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      SimpleEntryGroup simpleEntryGroup1 = new SimpleEntryGroup();
      Range range0 = new Range((-2428));
      FeatureVector featureVector0 = simpleEntryGroup1.getFeaturesInRange(range0);
      String string0 = "NT 3 [";
      range0.change(0, 1);
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector0, "NT 3 [");
      simpleEntryGroup1.unref();
      Bases bases1 = filteredEntryGroup0.getBases();
      // Undeclared exception!
      try { 
        bases1.getSubSequence(range0, 837);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test124()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("7M`8[Z[");
      Bases bases0 = new Bases(genbankStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      FileSystemHandling.createFolder((EvoSuiteFile) null);
      simpleEntryGroup0.unref();
      // Undeclared exception!
      try { 
        simpleEntryGroup0.truncate((Range) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test125()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("V0 +T$,%_f*x");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Range range0 = new Range(0);
      StringVector stringVector0 = StringVector.getStrings("V0 +T$,%_f*x", "internal error - unexpected exception: ", false);
      bases0.getStopOrStartCodons(range0, (-1976), stringVector0);
  }

  @Test(timeout = 4000)
  public void test126()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("namespace\t");
      genbankStreamSequence0.setHeader("9P;@Em:");
      Bases bases0 = new Bases(genbankStreamSequence0);
      bases0.toString();
      bases0.getCCount();
      bases0.getForwardStrand();
      bases0.getSequence();
      genbankStreamSequence0.copy();
      bases0.toString();
      Bases.complement(bases0.letter_index);
      bases0.getForwardStrand();
      bases0.toString();
      try { 
        bases0.getBaseAt(362);
        fail("Expecting exception: Exception");
      
      } catch(Exception e) {
         //
         // 362 > 10
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test127()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      Strand strand0 = bases0.getForwardStrand();
      AGWindowAlgorithm aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
      aGWindowAlgorithm0.getBases();
      try { 
        strand0.makeMarkerRangeFromPositions(1, 0);
        fail("Expecting exception: Exception");
      
      } catch(Exception e) {
         //
         // position: 0
         //
         verifyException("uk.ac.sanger.artemis.sequence.MarkerInternal", e);
      }
  }

  @Test(timeout = 4000)
  public void test128()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("Q5}");
      Bases bases0 = new Bases(emblStreamSequence0);
      bases0.getComplementPosition(1356);
  }

  @Test(timeout = 4000)
  public void test129()  throws Throwable  {
      Bases.complement("+>y_O:");
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("");
      Bases bases0 = new Bases(rawStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Key key0 = new Key("");
      simpleEntryGroup0.features();
      FeatureKeyQualifierPredicate featureKeyQualifierPredicate0 = new FeatureKeyQualifierPredicate(key0, "@@r@@@", "", true, true);
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureKeyQualifierPredicate0, "+>y_O:");
      simpleEntryGroup0.getSequenceLength();
      Bases bases1 = filteredEntryGroup0.getBases();
      bases1.getLength();
      System.setCurrentTimeMillis(0);
      // Undeclared exception!
      try { 
        bases1.reverseComplement((Feature) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test130()  throws Throwable  {
      Bases.complement("+>y_O:");
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("");
      Bases bases0 = new Bases(rawStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Key key0 = new Key("");
      simpleEntryGroup0.features();
      FeatureKeyQualifierPredicate featureKeyQualifierPredicate0 = new FeatureKeyQualifierPredicate(key0, "@@r@@@", "", true, true);
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureKeyQualifierPredicate0, "+>y_O:");
      simpleEntryGroup0.getSequenceLength();
      Bases bases1 = filteredEntryGroup0.getBases();
      bases1.getLength();
      System.setCurrentTimeMillis(0);
      Range range0 = new Range(2, 54189869);
      bases0.getStopOrStartCodons(range0, 0, (StringVector) null);
      // Undeclared exception!
      try { 
        bases0.deleteRange(range0);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // 0
         //
         verifyException("uk.ac.sanger.artemis.io.StreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test131()  throws Throwable  {
      FileSystemHandling.appendLineToFile((EvoSuiteFile) null, (String) null);
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("WXykj;-R=3RID@C&uo");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Bases.reverseComplement("xxR)c':nM");
      Bases.reverseComplement("WXykj;-R=3RID@C&uo");
      bases0.getAverageAGPercent();
      Bases.complement(bases0.letter_index);
      FileSystemHandling.appendDataToFile((EvoSuiteFile) null, (byte[]) null);
      Range range0 = new Range(5);
      bases0.addBases(113, 91, "kn@@g@yxx");
      Bases.complement("kn@@g@yxx");
      range0.change(5, 752);
      bases0.getSubSequenceC(range0, 2);
      bases0.getForwardStrand();
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      FeatureVector featureVector0 = new FeatureVector();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector0, "5iX;=8U &jVO[#{");
      Key key0 = new Key("xxR)c':nM");
      FeatureKeyQualifierPredicate featureKeyQualifierPredicate0 = new FeatureKeyQualifierPredicate(key0, "WXykj;-R=3RID@C&uo", "5iX;=8U &jVO[#{", false, false);
      FilteredEntryGroup filteredEntryGroup1 = new FilteredEntryGroup(filteredEntryGroup0, featureKeyQualifierPredicate0, "P");
      Entry entry0 = filteredEntryGroup1.createEntry();
      // Undeclared exception!
      try { 
        entry0.createFeature();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.Entry", e);
      }
  }

  @Test(timeout = 4000)
  public void test132()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("Parse error in this location: ");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Range range0 = new Range(1);
      FileSystemHandling.shouldThrowIOException((EvoSuiteFile) null);
      Bases bases1 = bases0.truncate(range0);
      Range range1 = new Range(0, 1);
      Range range2 = range1.change(0, 23);
      bases1.getComplementPosition((-5));
      bases1.reverseComplement();
      bases1.getReverseStrand();
      String[] stringArray0 = new String[8];
      stringArray0[0] = "Parse error in this location: ";
      stringArray0[1] = "Parse error in this location: ";
      stringArray0[4] = "Parse error in this location: ";
      stringArray0[0] = "Parse error in this location: ";
      stringArray0[4] = "Parse error in this location: ";
      stringArray0[5] = "Parse error in this location: ";
      stringArray0[7] = "Parse error in this location: ";
      StringVector stringVector0 = new StringVector(stringArray0);
      bases0.getStopCodons(range2, 2);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases1);
      Bases.reverseComplement("internal error - unexpected exception: ");
      FeatureVector featureVector0 = new FeatureVector();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector0, stringArray0[6]);
      FeatureFromVectorPredicate featureFromVectorPredicate0 = new FeatureFromVectorPredicate(featureVector0);
      bases1.getStopOrStartCodons(range0, 2139, stringVector0);
      FilteredEntryGroup filteredEntryGroup1 = new FilteredEntryGroup(filteredEntryGroup0, featureFromVectorPredicate0, "Parse error in this location: ");
      // Undeclared exception!
      try { 
        filteredEntryGroup1.featureAt((-5));
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test133()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("Parse error in this location: ");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Range range0 = new Range(1);
      FileSystemHandling.shouldThrowIOException((EvoSuiteFile) null);
      Bases bases1 = bases0.truncate(range0);
      Range range1 = new Range(0, 1);
      Range range2 = range1.change(0, 23);
      bases1.getComplementPosition((-5));
      bases1.getTranslation(range1, 1828, true);
      bases1.getReverseStrand();
      range2.truncate(range1);
      String[] stringArray0 = new String[8];
      stringArray0[0] = "Parse error in this location: ";
      stringArray0[1] = "Parse error in this location: ";
      stringArray0[4] = "Parse error in this location: ";
      stringArray0[0] = "Parse error in this location: ";
      stringArray0[4] = "Parse error in this location: ";
      stringArray0[5] = "Parse error in this location: ";
      stringArray0[6] = "Parse error in this location: ";
      stringArray0[7] = "Parse error in this location: ";
      StringVector stringVector0 = new StringVector(stringArray0);
      bases0.getStopCodons(range2, 2);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases1);
      Bases.reverseComplement("internal error - unexpected exception: ");
      FeatureVector featureVector0 = new FeatureVector();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector0, "Parse error in this location: ");
      FeatureFromVectorPredicate featureFromVectorPredicate0 = new FeatureFromVectorPredicate(featureVector0);
      bases1.getStopOrStartCodons(range0, 2139, stringVector0);
      FilteredEntryGroup filteredEntryGroup1 = new FilteredEntryGroup(filteredEntryGroup0, featureFromVectorPredicate0, "Parse error in this location: ");
      // Undeclared exception!
      try { 
        filteredEntryGroup1.featureAt((-5));
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test134()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence(";");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Range range0 = new Range((-483), 12);
      FileSystemHandling.shouldThrowIOException((EvoSuiteFile) null);
      Bases bases1 = bases0.truncate(range0);
      bases1.getComplementPosition((-5));
      bases1.getTranslation(range0, 1828, true);
      bases1.getReverseStrand();
      String[] stringArray0 = new String[8];
      stringArray0[0] = ";";
      stringArray0[1] = ";";
      stringArray0[4] = ";";
      FileSystemHandling.shouldThrowIOException((EvoSuiteFile) null);
      stringArray0[3] = ";";
      stringArray0[4] = ";";
      stringArray0[5] = ";";
      stringArray0[6] = ";";
      stringArray0[0] = ";";
      StringVector stringVector0 = new StringVector(";");
      bases1.getMatchingCodons(range0, (-1715), stringVector0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases1);
      Bases.reverseComplement("internal error - unexpected exception: ");
      FeatureVector featureVector0 = new FeatureVector();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector0, ";");
      FeatureFromVectorPredicate featureFromVectorPredicate0 = new FeatureFromVectorPredicate(featureVector0);
      bases1.getStopOrStartCodons(range0, 2139, stringVector0);
      FilteredEntryGroup filteredEntryGroup1 = new FilteredEntryGroup(filteredEntryGroup0, featureFromVectorPredicate0, ";");
      // Undeclared exception!
      try { 
        filteredEntryGroup1.featureAt((-5));
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test135()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      FileSystemHandling.shouldAllThrowIOExceptions();
      SimpleFeatureRealizer simpleFeatureRealizer0 = new SimpleFeatureRealizer();
      SimpleFeatureRealizer simpleFeatureRealizer1 = new SimpleFeatureRealizer(simpleFeatureRealizer0);
      Bases.complement("va-rT~9z_V{");
      HomologyFeature.Template homologyFeature_Template0 = new HomologyFeature.Template();
      Bases.complement('u');
      Bases.isLegalBase('u');
      Bases bases0 = new Bases((Sequence) null);
      // Undeclared exception!
      try { 
        bases0.getRawPosition(8818, 8818);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test136()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      Strand strand0 = bases0.getReverseStrand();
      AGWindowAlgorithm aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      simpleEntryGroup0.getSequenceEntry();
      aGWindowAlgorithm0.getDefaultWindowSize();
      SimpleEntryGroup simpleEntryGroup1 = new SimpleEntryGroup(bases0);
      Key key0 = Key.CDS;
      FileSystemHandling.shouldAllThrowIOExceptions();
      FeatureKeyQualifierPredicate featureKeyQualifierPredicate0 = new FeatureKeyQualifierPredicate(key0, "]mhi3^{OLN(}Y");
      String string0 = "Y.";
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup1, featureKeyQualifierPredicate0, "Y.");
      // Undeclared exception!
      try { 
        filteredEntryGroup0.featureAt(8818);
        fail("Expecting exception: IndexOutOfBoundsException");
      
      } catch(IndexOutOfBoundsException e) {
         //
         // Index: 8818, Size: 0
         //
         verifyException("java.util.ArrayList", e);
      }
  }

  @Test(timeout = 4000)
  public void test137()  throws Throwable  {
      int int0 = Bases.getIndexOfBase('6');
      assertEquals(4, int0);
      
      System.setCurrentTimeMillis(403L);
      StringReader stringReader0 = new StringReader("getMethodName");
      LinePushBackReader linePushBackReader0 = new LinePushBackReader(stringReader0);
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence(linePushBackReader0);
      Bases bases0 = new Bases(fastaStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      ActionController actionController0 = simpleEntryGroup0.getActionController();
      bases0.removeSequenceChangeListener(actionController0);
      int int1 = bases0.getGCount();
      assertFalse(int1 == int0);
  }

  @Test(timeout = 4000)
  public void test138()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("OxP;{UEDa");
      Bases bases0 = new Bases(genbankStreamSequence0);
      bases0.clearCodonCache();
      Bases.complement("OxP;{UEDa");
      MockPrintStream mockPrintStream0 = null;
      try {
        mockPrintStream0 = new MockPrintStream((String) null, "OxP;{UEDa");
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.io.File", e);
      }
  }
}
