if(CMAKE_BUILD_TYPE STREQUAL "DEBUG")
	if(PERSOSIM)
		if(NOT JAVA_EXECUTABLE)
			find_package(Java COMPONENTS Runtime)
			if(Java_JAVA_EXECUTABLE)
				set(JAVA_EXECUTABLE "${Java_JAVA_EXECUTABLE}")
			endif()
		endif()

		if(JAVA_EXECUTABLE)
			message(STATUS "PersoSim based tests enabled, using PersoSim Jar: ${PERSOSIM}")
			message(STATUS "Java: ${JAVA_EXECUTABLE}")
			add_definitions(-DPERSOSIM_EXECUTABLE=\"\\\"${PERSOSIM}\\\"\" -DJAVA_EXECUTABLE=\"\\\"${JAVA_EXECUTABLE}\\\"\")
			set(CMAKE_AUTOMOC_MOC_OPTIONS ${CMAKE_AUTOMOC_MOC_OPTIONS} -DPERSOSIM_EXECUTABLE=\"\\\"${PERSOSIM}\\\"\" -DJAVA_EXECUTABLE=\"\\\"${JAVA_EXECUTABLE}\\\"\")
		else()
			message(STATUS "Java not found! PersoSim based tests disabled.")
			unset(PERSOSIM)
		endif()
	else()
		message(STATUS "PersoSim based tests disabled")
	endif()
endif()
