#!/bin/sh

set -o errexit 

if [ x$1 = x ] ; then
LG=fr
else
LG=`basename $1 .po`
fi

cd `dirname $0`

echo "generation of gui-$LG.mo from gui-$LG.po... "
xgettext --keyword="_" --keyword="translate" --language=Perl \
	 --from-code=iso-8859-1 ../bins-edit-gui
#xpot --keyword="_" --keyword="translate" ../bins >messages.po 
touch gui-$LG.po
mv gui-$LG.po gui-$LG.po.old
msgmerge gui-$LG.po.old messages.po >gui-$LG.po
msgfmt -o gui-$LG.mo gui-$LG.po
mv messages.po bins-edit-gui.pot

echo "generation of $LG.mo from $LG.po... "
xgettext --keyword="_" --keyword="translate" --language=Perl \
	 --from-code=iso-8859-1 ../bins
#xpot --keyword="_" --keyword="translate" ../bins >messages.po 
touch $LG.po
mv $LG.po $LG.po.old
msgmerge $LG.po.old messages.po >$LG.po
msgfmt -o $LG.mo $LG.po
mv messages.po bins.pot

echo
echo "Now Copy the $LG.mo file to"\
 "/usr/local/share/locale/$LG/LC_MESSAGES/bins.mo"

echo
echo "Now Copy the gui-$LG.mo file to"\
 "/usr/local/share/locale/$LG/LC_MESSAGES/bins-edit-gui.mo"
